/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.beantable.turnout;

import java.awt.Component;
import java.util.HashMap;
import java.util.Objects;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import jmri.InstanceManager;
import jmri.NamedBean;
import jmri.Sensor;
import jmri.SensorManager;
import jmri.Turnout;
import jmri.jmrit.beantable.BeanTableJTable;
import jmri.jmrit.beantable.turnout.TurnoutTableDataModel;
import jmri.swing.NamedBeanComboBox;
import jmri.util.table.JComboBoxEditor;
import jmri.util.table.NamedBeanBoxRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TurnoutTableJTable
extends BeanTableJTable<Turnout> {
    final HashMap<Turnout, TableCellRenderer> rendererMapSensor1 = new HashMap();
    final HashMap<Turnout, TableCellEditor> editorMapSensor1 = new HashMap();
    final HashMap<Turnout, TableCellRenderer> rendererMapSensor2 = new HashMap();
    final HashMap<Turnout, TableCellEditor> editorMapSensor2 = new HashMap();
    private static final Logger log = LoggerFactory.getLogger(TurnoutTableJTable.class);

    public TurnoutTableJTable(TurnoutTableDataModel mdl) {
        super(mdl);
    }

    @Override
    public TableCellRenderer getCellRenderer(int row, int column) {
        int modelColumn = this.convertColumnIndexToModel(column);
        if (modelColumn == 10 || modelColumn == 11) {
            return this.getRenderer(this.convertRowIndexToModel(row), modelColumn);
        }
        return super.getCellRenderer(row, column);
    }

    @Override
    public TableCellEditor getCellEditor(int row, int column) {
        int modelColumn = this.convertColumnIndexToModel(column);
        if (modelColumn == 10 || modelColumn == 11) {
            return this.getEditor(this.convertRowIndexToModel(row), modelColumn);
        }
        return super.getCellEditor(row, column);
    }

    private TableCellRenderer getRenderer(int modelRow, int modelColumn) {
        TableCellRenderer retval;
        Turnout t = (Turnout)this.getModel().getValueAt(modelRow, 0);
        Objects.requireNonNull(t, "SYSNAMECOL column content must be nonnull");
        switch (modelColumn) {
            case 10: {
                retval = this.rendererMapSensor1.get(t);
                break;
            }
            case 11: {
                retval = this.rendererMapSensor2.get(t);
                break;
            }
            default: {
                return null;
            }
        }
        if (retval == null) {
            if (modelColumn == 10) {
                this.loadRenderEditMaps(this.rendererMapSensor1, this.editorMapSensor1, t, t.getFirstSensor());
            } else {
                this.loadRenderEditMaps(this.rendererMapSensor2, this.editorMapSensor2, t, t.getSecondSensor());
            }
            retval = this.rendererMapSensor1.get(t);
        }
        log.debug("fetched for Turnout \"{}\" renderer {}", (Object)t, (Object)retval);
        return retval;
    }

    private TableCellEditor getEditor(int modelRow, int modelColumn) {
        TableCellEditor retval;
        Turnout t = (Turnout)this.getModel().getValueAt(modelRow, 0);
        Objects.requireNonNull(t, "SYSNAMECOL column content must be nonnull");
        switch (modelColumn) {
            case 10: {
                retval = this.editorMapSensor1.get(t);
                break;
            }
            case 11: {
                retval = this.editorMapSensor2.get(t);
                break;
            }
            default: {
                return null;
            }
        }
        if (retval == null) {
            if (modelColumn == 10) {
                this.loadRenderEditMaps(this.rendererMapSensor1, this.editorMapSensor1, t, t.getFirstSensor());
                retval = this.editorMapSensor1.get(t);
            } else {
                this.loadRenderEditMaps(this.rendererMapSensor2, this.editorMapSensor2, t, t.getSecondSensor());
                retval = this.editorMapSensor2.get(t);
            }
        }
        log.debug("fetched for Turnout \"{}\" editor {}", (Object)t, (Object)retval);
        return retval;
    }

    private void loadRenderEditMaps(HashMap<Turnout, TableCellRenderer> r, HashMap<Turnout, TableCellEditor> e, Turnout t, Sensor s) {
        NamedBeanComboBox<Sensor> c = new NamedBeanComboBox<Sensor>(InstanceManager.getDefault(SensorManager.class), s, NamedBean.DisplayOptions.DISPLAYNAME);
        TurnoutTableSensorBoxRenderer renderer = new TurnoutTableSensorBoxRenderer();
        r.put(t, renderer);
        JComboBoxEditor editor = new JComboBoxEditor(c, null);
        e.put(t, editor);
        log.debug("initialize for Turnout \"{}\" Sensor \"{}\"", (Object)t, (Object)s);
    }

    private static class TurnoutTableSensorBoxRenderer
    extends NamedBeanBoxRenderer<Sensor> {
        TurnoutTableSensorBoxRenderer() {
            super(InstanceManager.getDefault(SensorManager.class));
            this.setAllowNull(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            int tableCol = table.convertColumnIndexToModel(column);
            int tableRow = table.convertRowIndexToModel(row);
            Turnout t = (Turnout)table.getModel().getValueAt(tableRow, 0);
            if (t == null) {
                return this;
            }
            if (value instanceof Sensor) {
                if (tableCol == 10 && t.getFeedbackMode() != 16 && t.getFeedbackMode() != 32) {
                    this.setErrorBorder();
                } else if (tableCol == 11 && t.getFeedbackMode() != 32) {
                    this.setErrorBorder();
                } else {
                    this.setNormalBorder();
                }
            } else if (tableCol == 10 && (t.getFeedbackMode() == 16 || t.getFeedbackMode() == 32)) {
                this.setErrorBorder();
            } else if (tableCol == 11 && t.getFeedbackMode() == 32) {
                this.setErrorBorder();
            } else {
                this.setNormalBorder();
            }
            return this;
        }
    }
}

