/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.blockboss;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import jmri.InstanceManager;
import jmri.NamedBean;
import jmri.NamedBeanHandle;
import jmri.NamedBeanHandleManager;
import jmri.NamedBeanUsageReport;
import jmri.Sensor;
import jmri.SignalHead;
import jmri.SignalHeadManager;
import jmri.Turnout;
import jmri.jmrit.automat.Siglet;
import jmri.jmrit.blockboss.BlockBossLogicProvider;
import jmri.jmrit.blockboss.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlockBossLogic
extends Siglet
implements VetoableChangeListener {
    public static final int SINGLEBLOCK = 1;
    public static final int TRAILINGMAIN = 2;
    public static final int TRAILINGDIVERGING = 3;
    public static final int FACING = 4;
    private static final String BEAN_X_NOT_FOUND = "BeanXNotFound";
    private static final String BEAN_NAME_SIGNAL_HEAD = "BeanNameSignalHead";
    private static final String BEAN_NAME_SENSOR = "BeanNameSensor";
    private int mode = 0;
    private final NamedBeanHandleManager nbhm = InstanceManager.getDefault(NamedBeanHandleManager.class);
    private String comment;
    private boolean mHold = false;
    private final String name;
    @Nonnull
    NamedBeanHandle<SignalHead> driveSignal;
    private NamedBeanHandle<Sensor> watchSensor1 = null;
    private NamedBeanHandle<Sensor> watchSensor2 = null;
    private NamedBeanHandle<Sensor> watchSensor3 = null;
    private NamedBeanHandle<Sensor> watchSensor4 = null;
    private NamedBeanHandle<Sensor> watchSensor5 = null;
    private NamedBeanHandle<Turnout> watchTurnout = null;
    private NamedBeanHandle<SignalHead> watchedSignal1 = null;
    private NamedBeanHandle<SignalHead> watchedSignal1Alt = null;
    private NamedBeanHandle<SignalHead> watchedSignal2 = null;
    private NamedBeanHandle<SignalHead> watchedSignal2Alt = null;
    private NamedBeanHandle<Sensor> watchedSensor1 = null;
    private NamedBeanHandle<Sensor> watchedSensor1Alt = null;
    private NamedBeanHandle<Sensor> watchedSensor2 = null;
    private NamedBeanHandle<Sensor> watchedSensor2Alt = null;
    private NamedBeanHandle<Sensor> approachSensor1 = null;
    private boolean limitSpeed1 = false;
    private boolean restrictingSpeed1 = false;
    private boolean limitSpeed2 = false;
    private boolean restrictingSpeed2 = false;
    private boolean protectWithFlashing = false;
    private boolean distantSignal = false;
    private static final Logger log = LoggerFactory.getLogger(BlockBossLogic.class);

    public BlockBossLogic(@Nonnull String name) {
        super(name + Bundle.getMessage("_BlockBossLogic"));
        Objects.requireNonNull(name, "BlockBossLogic name cannot be null");
        this.name = name;
        log.trace("Create BBL {}", (Object)name);
        InstanceManager.getDefault(SignalHeadManager.class).addVetoableChangeListener(this);
        InstanceManager.turnoutManagerInstance().addVetoableChangeListener(this);
        InstanceManager.sensorManagerInstance().addVetoableChangeListener(this);
        SignalHead driveHead = InstanceManager.getDefault(SignalHeadManager.class).getSignalHead(name);
        if (driveHead == null) {
            this.logWarn(Bundle.getMessage(BEAN_X_NOT_FOUND, Bundle.getMessage(BEAN_NAME_SIGNAL_HEAD), name));
            throw new IllegalArgumentException("SignalHead \"" + name + "\" does not exist");
        }
        this.driveSignal = this.nbhm.getNamedBeanHandle(name, driveHead);
        Objects.requireNonNull(this.driveSignal, "driveSignal should not have been null");
    }

    @SuppressFBWarnings(value={"SLF4J_FORMAT_SHOULD_BE_CONST"}, justification="I18N Warning strings.")
    private void logWarn(String stringToLogAsWarning) {
        log.warn(stringToLogAsWarning);
    }

    @Nonnull
    public String getDrivenSignal() {
        Objects.requireNonNull(this.driveSignal, "driveSignal should not have been null");
        String retVal = this.driveSignal.getName();
        Objects.requireNonNull(retVal, "driveSignal system name should not have been null");
        return retVal;
    }

    @Nonnull
    public NamedBeanHandle<SignalHead> getDrivenSignalNamedBean() {
        Objects.requireNonNull(this.driveSignal, "driveSignal should have been null");
        return this.driveSignal;
    }

    public void setSensor1(String name) {
        if (name == null || name.isEmpty()) {
            this.watchSensor1 = null;
            return;
        }
        try {
            this.watchSensor1 = this.nbhm.getNamedBeanHandle(name, InstanceManager.sensorManagerInstance().provideSensor(name));
        }
        catch (IllegalArgumentException ex) {
            this.logWarn(Bundle.getMessage(BEAN_X_NOT_FOUND, Bundle.getMessage(BEAN_NAME_SENSOR) + "1", name));
        }
    }

    public void setSensor2(String name) {
        if (name == null || name.isEmpty()) {
            this.watchSensor2 = null;
            return;
        }
        try {
            this.watchSensor2 = this.nbhm.getNamedBeanHandle(name, InstanceManager.sensorManagerInstance().provideSensor(name));
        }
        catch (IllegalArgumentException ex) {
            this.logWarn(Bundle.getMessage(BEAN_X_NOT_FOUND, Bundle.getMessage(BEAN_NAME_SENSOR) + "2", name));
        }
    }

    public void setSensor3(String name) {
        if (name == null || name.isEmpty()) {
            this.watchSensor3 = null;
            return;
        }
        try {
            this.watchSensor3 = this.nbhm.getNamedBeanHandle(name, InstanceManager.sensorManagerInstance().provideSensor(name));
        }
        catch (IllegalArgumentException ex) {
            this.logWarn(Bundle.getMessage(BEAN_X_NOT_FOUND, Bundle.getMessage(BEAN_NAME_SENSOR) + "3", name));
        }
    }

    public void setSensor4(String name) {
        if (name == null || name.isEmpty()) {
            this.watchSensor4 = null;
            return;
        }
        try {
            this.watchSensor4 = this.nbhm.getNamedBeanHandle(name, InstanceManager.sensorManagerInstance().provideSensor(name));
        }
        catch (IllegalArgumentException ex) {
            this.logWarn(Bundle.getMessage(BEAN_X_NOT_FOUND, Bundle.getMessage(BEAN_NAME_SENSOR) + "4", name));
        }
    }

    public void setSensor5(String name) {
        if (name == null || name.isEmpty()) {
            this.watchSensor5 = null;
            return;
        }
        try {
            this.watchSensor5 = this.nbhm.getNamedBeanHandle(name, InstanceManager.sensorManagerInstance().provideSensor(name));
        }
        catch (IllegalArgumentException ex) {
            this.logWarn(Bundle.getMessage(BEAN_X_NOT_FOUND, Bundle.getMessage(BEAN_NAME_SENSOR) + "5", name));
        }
    }

    public String getSensor1() {
        if (this.watchSensor1 == null) {
            return null;
        }
        return this.watchSensor1.getName();
    }

    public String getSensor2() {
        if (this.watchSensor2 == null) {
            return null;
        }
        return this.watchSensor2.getName();
    }

    public String getSensor3() {
        if (this.watchSensor3 == null) {
            return null;
        }
        return this.watchSensor3.getName();
    }

    public String getSensor4() {
        if (this.watchSensor4 == null) {
            return null;
        }
        return this.watchSensor4.getName();
    }

    public String getSensor5() {
        if (this.watchSensor5 == null) {
            return null;
        }
        return this.watchSensor5.getName();
    }

    public void setTurnout(String name) {
        if (name == null || name.isEmpty()) {
            this.watchTurnout = null;
            return;
        }
        try {
            this.watchTurnout = this.nbhm.getNamedBeanHandle(name, InstanceManager.turnoutManagerInstance().provideTurnout(name));
        }
        catch (IllegalArgumentException ex) {
            this.logWarn(Bundle.getMessage(BEAN_X_NOT_FOUND, Bundle.getMessage("BeanNameTurnout"), name));
        }
    }

    public String getTurnout() {
        if (this.watchTurnout == null) {
            return null;
        }
        return this.watchTurnout.getName();
    }

    public void setMode(int mode) {
        this.mode = mode;
    }

    public int getMode() {
        return this.mode;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String getComment() {
        return this.comment;
    }

    public void setWatchedSignal1(String name, boolean useFlash) {
        if (name == null || name.isEmpty()) {
            this.watchedSignal1 = null;
            return;
        }
        SignalHead head = InstanceManager.getDefault(SignalHeadManager.class).getSignalHead(name);
        if (head != null) {
            this.watchedSignal1 = this.nbhm.getNamedBeanHandle(name, head);
        } else {
            this.logWarn(Bundle.getMessage(BEAN_X_NOT_FOUND, Bundle.getMessage(BEAN_NAME_SIGNAL_HEAD), name));
            this.watchedSignal1 = null;
        }
        this.protectWithFlashing = useFlash;
    }

    public String getWatchedSignal1() {
        if (this.watchedSignal1 == null) {
            return null;
        }
        return this.watchedSignal1.getName();
    }

    public void setWatchedSignal1Alt(String name) {
        if (name == null || name.isEmpty()) {
            this.watchedSignal1Alt = null;
            return;
        }
        SignalHead head = InstanceManager.getDefault(SignalHeadManager.class).getSignalHead(name);
        if (head != null) {
            this.watchedSignal1Alt = this.nbhm.getNamedBeanHandle(name, head);
        } else {
            this.logWarn(Bundle.getMessage(BEAN_X_NOT_FOUND, Bundle.getMessage(BEAN_NAME_SIGNAL_HEAD), name));
            this.watchedSignal1Alt = null;
        }
    }

    public String getWatchedSignal1Alt() {
        if (this.watchedSignal1Alt == null) {
            return null;
        }
        return this.watchedSignal1Alt.getName();
    }

    public void setWatchedSignal2(String name) {
        if (name == null || name.isEmpty()) {
            this.watchedSignal2 = null;
            return;
        }
        SignalHead head = InstanceManager.getDefault(SignalHeadManager.class).getSignalHead(name);
        if (head != null) {
            this.watchedSignal2 = this.nbhm.getNamedBeanHandle(name, head);
        } else {
            this.logWarn(Bundle.getMessage(BEAN_X_NOT_FOUND, Bundle.getMessage(BEAN_NAME_SIGNAL_HEAD), name));
            this.watchedSignal2 = null;
        }
    }

    public String getWatchedSignal2() {
        if (this.watchedSignal2 == null) {
            return null;
        }
        return this.watchedSignal2.getName();
    }

    public void setWatchedSignal2Alt(String name) {
        if (name == null || name.isEmpty()) {
            this.watchedSignal2Alt = null;
            return;
        }
        SignalHead head = InstanceManager.getDefault(SignalHeadManager.class).getSignalHead(name);
        if (head != null) {
            this.watchedSignal2Alt = this.nbhm.getNamedBeanHandle(name, head);
        } else {
            this.logWarn(Bundle.getMessage(BEAN_X_NOT_FOUND, Bundle.getMessage(BEAN_NAME_SIGNAL_HEAD), name));
            this.watchedSignal2Alt = null;
        }
    }

    public String getWatchedSignal2Alt() {
        if (this.watchedSignal2Alt == null) {
            return null;
        }
        return this.watchedSignal2Alt.getName();
    }

    public void setWatchedSensor1(String name) {
        if (name == null || name.isEmpty()) {
            this.watchedSensor1 = null;
            return;
        }
        try {
            this.watchedSensor1 = this.nbhm.getNamedBeanHandle(name, InstanceManager.sensorManagerInstance().provideSensor(name));
        }
        catch (IllegalArgumentException ex) {
            this.logWarn(Bundle.getMessage(BEAN_X_NOT_FOUND, Bundle.getMessage(BEAN_NAME_SENSOR) + "1", name));
            this.watchedSensor1 = null;
        }
    }

    public String getWatchedSensor1() {
        if (this.watchedSensor1 == null) {
            return null;
        }
        return this.watchedSensor1.getName();
    }

    public void setWatchedSensor1Alt(String name) {
        if (name == null || name.isEmpty()) {
            this.watchedSensor1Alt = null;
            return;
        }
        try {
            this.watchedSensor1Alt = this.nbhm.getNamedBeanHandle(name, InstanceManager.sensorManagerInstance().provideSensor(name));
        }
        catch (IllegalArgumentException ex) {
            this.logWarn(Bundle.getMessage(BEAN_X_NOT_FOUND, Bundle.getMessage(BEAN_NAME_SENSOR) + "1Alt", name));
            this.watchedSensor1Alt = null;
        }
    }

    public String getWatchedSensor1Alt() {
        if (this.watchedSensor1Alt == null) {
            return null;
        }
        return this.watchedSensor1Alt.getName();
    }

    public void setWatchedSensor2(String name) {
        if (name == null || name.isEmpty()) {
            this.watchedSensor2 = null;
            return;
        }
        try {
            this.watchedSensor2 = this.nbhm.getNamedBeanHandle(name, InstanceManager.sensorManagerInstance().provideSensor(name));
        }
        catch (IllegalArgumentException ex) {
            this.logWarn(Bundle.getMessage(BEAN_X_NOT_FOUND, Bundle.getMessage(BEAN_NAME_SENSOR) + "2", name));
            this.watchedSensor2 = null;
        }
    }

    public String getWatchedSensor2() {
        if (this.watchedSensor2 == null) {
            return null;
        }
        return this.watchedSensor2.getName();
    }

    public void setWatchedSensor2Alt(String name) {
        if (name == null || name.isEmpty()) {
            this.watchedSensor2Alt = null;
            return;
        }
        try {
            this.watchedSensor2Alt = this.nbhm.getNamedBeanHandle(name, InstanceManager.sensorManagerInstance().provideSensor(name));
        }
        catch (IllegalArgumentException ex) {
            this.logWarn(Bundle.getMessage(BEAN_X_NOT_FOUND, Bundle.getMessage(BEAN_NAME_SENSOR) + "2Alt", name));
            this.watchedSensor2Alt = null;
        }
    }

    public String getWatchedSensor2Alt() {
        if (this.watchedSensor2Alt == null) {
            return null;
        }
        return this.watchedSensor2Alt.getName();
    }

    public void setLimitSpeed1(boolean d) {
        this.limitSpeed1 = d;
    }

    public boolean getLimitSpeed1() {
        return this.limitSpeed1;
    }

    public void setRestrictingSpeed1(boolean d) {
        this.restrictingSpeed1 = d;
    }

    public boolean getRestrictingSpeed1() {
        return this.restrictingSpeed1;
    }

    public void setLimitSpeed2(boolean d) {
        this.limitSpeed2 = d;
    }

    public boolean getLimitSpeed2() {
        return this.limitSpeed2;
    }

    public void setRestrictingSpeed2(boolean d) {
        this.restrictingSpeed2 = d;
    }

    public boolean getRestrictingSpeed2() {
        return this.restrictingSpeed2;
    }

    public boolean getUseFlash() {
        return this.protectWithFlashing;
    }

    public void setDistantSignal(boolean d) {
        this.distantSignal = d;
    }

    public boolean getDistantSignal() {
        return this.distantSignal;
    }

    private boolean getHold() {
        return this.mHold;
    }

    public void setHold(boolean m) {
        this.mHold = m;
        this.setOutput();
    }

    public void setApproachSensor1(String name) {
        if (name == null || name.isEmpty()) {
            this.approachSensor1 = null;
            return;
        }
        this.approachSensor1 = this.nbhm.getNamedBeanHandle(name, InstanceManager.sensorManagerInstance().provideSensor(name));
        if (this.approachSensor1.getBean() == null) {
            this.logWarn(Bundle.getMessage(BEAN_X_NOT_FOUND, Bundle.getMessage("Approach_Sensor1_"), name));
        }
    }

    public String getApproachSensor1() {
        if (this.approachSensor1 == null) {
            return null;
        }
        return this.approachSensor1.getName();
    }

    @Override
    public void defineIO() {
        ArrayList<NamedBean> namedBeanList = new ArrayList<NamedBean>();
        this.addBeanToListIfItExists(namedBeanList, this.watchTurnout);
        this.addBeanToListIfItExists(namedBeanList, this.watchSensor1);
        this.addBeanToListIfItExists(namedBeanList, this.watchSensor2);
        this.addBeanToListIfItExists(namedBeanList, this.watchSensor3);
        this.addBeanToListIfItExists(namedBeanList, this.watchSensor4);
        this.addBeanToListIfItExists(namedBeanList, this.watchSensor5);
        this.addBeanToListIfItExists(namedBeanList, this.watchedSignal1);
        this.addBeanToListIfItExists(namedBeanList, this.watchedSignal1Alt);
        this.addBeanToListIfItExists(namedBeanList, this.watchedSignal2);
        this.addBeanToListIfItExists(namedBeanList, this.watchedSignal2Alt);
        this.addBeanToListIfItExists(namedBeanList, this.watchedSensor1);
        this.addBeanToListIfItExists(namedBeanList, this.watchedSensor1Alt);
        this.addBeanToListIfItExists(namedBeanList, this.watchedSensor2);
        this.addBeanToListIfItExists(namedBeanList, this.watchedSensor2Alt);
        this.addBeanToListIfItExists(namedBeanList, this.approachSensor1);
        this.inputs = namedBeanList.toArray(new NamedBean[1]);
        this.outputs = new NamedBean[]{this.driveSignal.getBean()};
        this.driveSignal.getBean().addPropertyChangeListener(e -> {
            if (e.getPropertyName().equals(Bundle.getMessage("Held"))) {
                this.setOutput();
            }
        }, this.driveSignal.getName(), "BlockBossLogic:" + this.name);
    }

    private void addBeanToListIfItExists(List<NamedBean> namedBeanList, NamedBeanHandle<?> namedBeanHandle) {
        if (namedBeanHandle != null) {
            namedBeanList.add((NamedBean)namedBeanHandle.getBean());
        }
    }

    @Override
    public void setOutput() {
        log.trace("setOutput for {}", (Object)this.name);
        if (this.outputs == null || this.outputs[0] == null) {
            return;
        }
        if (this.getHold()) {
            ((SignalHead)this.outputs[0]).setAppearance(1);
            log.debug("setOutput red due to held for {}", (Object)this.name);
            return;
        }
        switch (this.mode) {
            case 1: {
                this.doSingleBlock();
                break;
            }
            case 2: {
                this.doTrailingMain();
                break;
            }
            case 3: {
                this.doTrailingDiverging();
                break;
            }
            case 4: {
                this.doFacing();
                break;
            }
            default: {
                log.error("{}{}_Signal_{}", new Object[]{Bundle.getMessage("UnexpectedMode"), this.mode, this.getDrivenSignal()});
            }
        }
    }

    private int fastestColor1() {
        int result = 1;
        if (this.watchedSignal1 == null && this.watchedSignal1Alt == null) {
            result = 16;
        }
        int val = result;
        if (this.watchedSignal1 != null) {
            val = this.watchedSignal1.getBean().getAppearance();
        }
        if (this.watchedSignal1 != null && this.watchedSignal1.getBean().getHeld()) {
            val = 1;
        }
        int valAlt = result;
        if (this.watchedSignal1Alt != null) {
            valAlt = this.watchedSignal1Alt.getBean().getAppearance();
        }
        if (this.watchedSignal1Alt != null && this.watchedSignal1Alt.getBean().getHeld()) {
            valAlt = 1;
        }
        return BlockBossLogic.fasterOf(val, valAlt);
    }

    private int fastestColor2() {
        int result = 1;
        if (this.watchedSignal2 == null && this.watchedSignal2Alt == null) {
            result = 16;
        }
        int val = result;
        if (this.watchedSignal2 != null) {
            val = this.watchedSignal2.getBean().getAppearance();
        }
        if (this.watchedSignal2 != null && this.watchedSignal2.getBean().getHeld()) {
            val = 1;
        }
        int valAlt = result;
        if (this.watchedSignal2Alt != null) {
            valAlt = this.watchedSignal2Alt.getBean().getAppearance();
        }
        if (this.watchedSignal2Alt != null && this.watchedSignal2Alt.getBean().getHeld()) {
            valAlt = 1;
        }
        return BlockBossLogic.fasterOf(val, valAlt);
    }

    private static int slowerOf(int a, int b) {
        return Math.min(a, b);
    }

    private static int fasterOf(int a, int b) {
        return Math.max(a, b);
    }

    private void doSingleBlock() {
        int appearance = 16;
        int oldAppearance = ((SignalHead)this.outputs[0]).getAppearance();
        if (this.protectWithFlashing && this.fastestColor1() == 4) {
            appearance = 8;
        }
        if (this.fastestColor1() == 1 || this.fastestColor1() == 2) {
            appearance = 4;
        }
        if (this.distantSignal) {
            appearance = this.fastestColor1();
        }
        if (this.limitSpeed1) {
            appearance = BlockBossLogic.slowerOf(appearance, 4);
        }
        if (this.restrictingSpeed1) {
            appearance = BlockBossLogic.slowerOf(appearance, 2);
        }
        if (this.watchSensor1 != null && this.watchSensor1.getBean().getKnownState() != 4) {
            appearance = 1;
        }
        if (this.watchSensor2 != null && this.watchSensor2.getBean().getKnownState() != 4) {
            appearance = 1;
        }
        if (this.watchSensor3 != null && this.watchSensor3.getBean().getKnownState() != 4) {
            appearance = 1;
        }
        if (this.watchSensor4 != null && this.watchSensor4.getBean().getKnownState() != 4) {
            appearance = 1;
        }
        if (this.watchSensor5 != null && this.watchSensor5.getBean().getKnownState() != 4) {
            appearance = 1;
        }
        if (((SignalHead)this.outputs[0]).getHeld()) {
            appearance = 1;
        }
        this.doApproach();
        if (appearance != oldAppearance) {
            ((SignalHead)this.outputs[0]).setAppearance(appearance);
            log.debug("Change appearance of {} to: {}", (Object)this.name, (Object)appearance);
        }
    }

    private void doTrailingMain() {
        int appearance = 16;
        int oldAppearance = ((SignalHead)this.outputs[0]).getAppearance();
        if (this.protectWithFlashing && this.fastestColor1() == 4) {
            appearance = 8;
        }
        if (this.fastestColor1() == 1 || this.fastestColor1() == 2) {
            appearance = 4;
        }
        if (this.distantSignal) {
            appearance = this.fastestColor1();
        }
        if (this.limitSpeed1) {
            appearance = BlockBossLogic.slowerOf(appearance, 4);
        }
        if (this.restrictingSpeed1) {
            appearance = BlockBossLogic.slowerOf(appearance, 2);
        }
        if (this.watchSensor1 != null && this.watchSensor1.getBean().getKnownState() != 4) {
            appearance = 1;
        }
        if (this.watchSensor2 != null && this.watchSensor2.getBean().getKnownState() != 4) {
            appearance = 1;
        }
        if (this.watchSensor3 != null && this.watchSensor3.getBean().getKnownState() != 4) {
            appearance = 1;
        }
        if (this.watchSensor4 != null && this.watchSensor4.getBean().getKnownState() != 4) {
            appearance = 1;
        }
        if (this.watchSensor5 != null && this.watchSensor5.getBean().getKnownState() != 4) {
            appearance = 1;
        }
        if (this.watchTurnout != null && this.watchTurnout.getBean().getKnownState() != 2) {
            appearance = 1;
        }
        if (this.watchTurnout != null && this.watchTurnout.getBean().getCommandedState() != 2) {
            appearance = 1;
        }
        if (((SignalHead)this.outputs[0]).getHeld()) {
            appearance = 1;
        }
        this.doApproach();
        if (appearance != oldAppearance) {
            ((SignalHead)this.outputs[0]).setAppearance(appearance);
            log.debug("Change appearance of {} to:{}", (Object)this.name, (Object)appearance);
        }
    }

    private void doTrailingDiverging() {
        int appearance = 16;
        int oldAppearance = ((SignalHead)this.outputs[0]).getAppearance();
        if (this.protectWithFlashing && this.fastestColor1() == 4) {
            appearance = 8;
        }
        if (this.fastestColor1() == 1 || this.fastestColor1() == 2) {
            appearance = 4;
        }
        if (this.distantSignal) {
            appearance = this.fastestColor1();
        }
        if (this.limitSpeed2) {
            appearance = BlockBossLogic.slowerOf(appearance, 4);
        }
        if (this.restrictingSpeed2) {
            appearance = BlockBossLogic.slowerOf(appearance, 2);
        }
        if (this.watchSensor1 != null && this.watchSensor1.getBean().getKnownState() != 4) {
            appearance = 1;
        }
        if (this.watchSensor2 != null && this.watchSensor2.getBean().getKnownState() != 4) {
            appearance = 1;
        }
        if (this.watchSensor3 != null && this.watchSensor3.getBean().getKnownState() != 4) {
            appearance = 1;
        }
        if (this.watchSensor4 != null && this.watchSensor4.getBean().getKnownState() != 4) {
            appearance = 1;
        }
        if (this.watchSensor5 != null && this.watchSensor5.getBean().getKnownState() != 4) {
            appearance = 1;
        }
        if (this.watchTurnout != null && this.watchTurnout.getBean().getKnownState() != 4) {
            appearance = 1;
        }
        if (this.watchTurnout != null && this.watchTurnout.getBean().getCommandedState() != 4) {
            appearance = 1;
        }
        if (((SignalHead)this.outputs[0]).getHeld()) {
            appearance = 1;
        }
        this.doApproach();
        if (appearance != oldAppearance) {
            ((SignalHead)this.outputs[0]).setAppearance(appearance);
            if (log.isDebugEnabled()) {
                log.debug("Change appearance of {} to: {}", (Object)this.name, (Object)appearance);
            }
        }
    }

    private void doFacing() {
        int appearance = 16;
        int oldAppearance = ((SignalHead)this.outputs[0]).getAppearance();
        int s = 16;
        if (this.watchTurnout != null && this.watchTurnout.getBean().getKnownState() != 4) {
            s = BlockBossLogic.slowerOf(s, this.fastestColor1());
        }
        if (this.watchTurnout != null && this.watchTurnout.getBean().getKnownState() != 2) {
            s = BlockBossLogic.slowerOf(s, this.fastestColor2());
        }
        if (this.protectWithFlashing && s == 4) {
            appearance = 8;
        }
        if (s == 1 || s == 2) {
            appearance = 4;
        }
        if (this.distantSignal) {
            appearance = s;
        }
        if (this.watchTurnout != null && this.limitSpeed1 && this.watchTurnout.getBean().getKnownState() != 4) {
            appearance = BlockBossLogic.slowerOf(appearance, 4);
        }
        if (this.watchTurnout != null && this.limitSpeed2 && this.watchTurnout.getBean().getKnownState() != 2) {
            appearance = BlockBossLogic.slowerOf(appearance, 4);
        }
        if (this.watchTurnout != null && this.restrictingSpeed1 && this.watchTurnout.getBean().getKnownState() != 4) {
            appearance = BlockBossLogic.slowerOf(appearance, 2);
        }
        if (this.watchTurnout != null && this.restrictingSpeed2 && this.watchTurnout.getBean().getKnownState() != 2) {
            appearance = BlockBossLogic.slowerOf(appearance, 2);
        }
        if (this.watchSensor1 != null && this.watchSensor1.getBean().getKnownState() != 4) {
            appearance = 1;
        }
        if (this.watchSensor2 != null && this.watchSensor2.getBean().getKnownState() != 4) {
            appearance = 1;
        }
        if (this.watchSensor3 != null && this.watchSensor3.getBean().getKnownState() != 4) {
            appearance = 1;
        }
        if (this.watchSensor4 != null && this.watchSensor4.getBean().getKnownState() != 4) {
            appearance = 1;
        }
        if (this.watchSensor5 != null && this.watchSensor5.getBean().getKnownState() != 4) {
            appearance = 1;
        }
        if (this.watchTurnout != null && this.watchTurnout.getBean().getKnownState() == 2 && this.watchedSensor1 != null && this.watchedSensor1.getBean().getKnownState() != 4) {
            appearance = 1;
        }
        if (this.watchTurnout != null && this.watchTurnout.getBean().getKnownState() == 2 && this.watchedSensor1Alt != null && this.watchedSensor1Alt.getBean().getKnownState() != 4) {
            appearance = 1;
        }
        if (this.watchTurnout != null && this.watchTurnout.getBean().getKnownState() == 4 && this.watchedSensor2 != null && this.watchedSensor2.getBean().getKnownState() != 4) {
            appearance = 1;
        }
        if (this.watchTurnout != null && this.watchTurnout.getBean().getKnownState() == 4 && this.watchedSensor2Alt != null && this.watchedSensor2Alt.getBean().getKnownState() != 4) {
            appearance = 1;
        }
        if (this.watchTurnout != null && this.watchTurnout.getBean().getKnownState() != this.watchTurnout.getBean().getCommandedState()) {
            appearance = 1;
        }
        if (this.watchTurnout != null && this.watchTurnout.getBean().getKnownState() != 4 && this.watchTurnout.getBean().getKnownState() != 2) {
            appearance = 1;
        }
        if (((SignalHead)this.outputs[0]).getHeld()) {
            appearance = 1;
        }
        this.doApproach();
        if (appearance != oldAppearance) {
            ((SignalHead)this.outputs[0]).setAppearance(appearance);
        }
    }

    private void doApproach() {
        if (this.approachSensor1 != null && this.approachSensor1.getBean().getKnownState() == 4) {
            if (this.driveSignal.getBean().getLit()) {
                this.driveSignal.getBean().setLit(false);
            }
        } else if (!this.driveSignal.getBean().getLit()) {
            this.driveSignal.getBean().setLit(true);
        }
    }

    @Nonnull
    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"}, justification="enforced dynamically, too hard to prove statically")
    public static BlockBossLogic getStoppedObject(String signal) {
        SignalHead sh = InstanceManager.getDefault(SignalHeadManager.class).getSignalHead(signal);
        Objects.requireNonNull(sh, "signal head must exist");
        return BlockBossLogic.getStoppedObject(sh);
    }

    @Nonnull
    public static BlockBossLogic getStoppedObject(@Nonnull SignalHead sh) {
        BlockBossLogic b = InstanceManager.getDefault(BlockBossLogicProvider.class).provide(sh);
        b.stop();
        return b;
    }

    @Override
    public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
        NamedBean nb = (NamedBean)evt.getOldValue();
        if ("CanDelete".equals(evt.getPropertyName())) {
            this.processCanDelete(evt, nb);
        } else if ("DoDelete".equals(evt.getPropertyName())) {
            this.processDoDelete(nb);
        }
    }

    private void processDoDelete(NamedBean nb) {
        if (nb instanceof SignalHead) {
            this.deleteSignalHead(nb);
        } else if (nb instanceof Turnout) {
            this.deleteTurnout(nb);
        } else if (nb instanceof Sensor) {
            this.deleteSensor(nb);
        }
    }

    private void deleteSensor(NamedBean nb) {
        if (this.watchSensor1 != null && this.watchSensor1.getBean().equals(nb)) {
            this.stop();
            this.setSensor1(null);
            this.start();
        }
        if (this.watchSensor2 != null && this.watchSensor2.getBean().equals(nb)) {
            this.stop();
            this.setSensor2(null);
            this.start();
        }
        if (this.watchSensor3 != null && this.watchSensor3.getBean().equals(nb)) {
            this.stop();
            this.setSensor3(null);
            this.start();
        }
        if (this.watchSensor4 != null && this.watchSensor4.getBean().equals(nb)) {
            this.stop();
            this.setSensor4(null);
            this.start();
        }
        if (this.watchSensor5 != null && this.watchSensor5.getBean().equals(nb)) {
            this.stop();
            this.setSensor5(null);
            this.start();
        }
        if (this.watchedSensor1 != null && this.watchedSensor1.getBean().equals(nb)) {
            this.stop();
            this.setWatchedSensor1(null);
            this.start();
        }
        if (this.watchedSensor2 != null && this.watchedSensor2.getBean().equals(nb)) {
            this.stop();
            this.setWatchedSensor2(null);
            this.start();
        }
        if (this.watchedSensor1Alt != null && this.watchedSensor1Alt.getBean().equals(nb)) {
            this.stop();
            this.setWatchedSensor1Alt(null);
            this.start();
        }
        if (this.watchedSensor2Alt != null && this.watchedSensor2Alt.getBean().equals(nb)) {
            this.stop();
            this.setWatchedSensor2Alt(null);
            this.start();
        }
        if (this.approachSensor1 != null && this.approachSensor1.getBean().equals(nb)) {
            this.stop();
            this.setApproachSensor1(null);
            this.start();
        }
    }

    private void deleteTurnout(NamedBean nb) {
        if (this.watchTurnout != null && this.watchTurnout.getBean().equals(nb)) {
            this.stop();
            this.setTurnout(null);
            this.start();
        }
    }

    private void deleteSignalHead(NamedBean nb) {
        if (nb.equals(this.getDrivenSignalNamedBean().getBean())) {
            this.stop();
            InstanceManager.getDefault(BlockBossLogicProvider.class).remove(this);
        }
        if (this.watchedSignal1 != null && this.watchedSignal1.getBean().equals(nb)) {
            this.stop();
            this.setWatchedSignal1(null, false);
            this.start();
        }
        if (this.watchedSignal1Alt != null && this.watchedSignal1Alt.getBean().equals(nb)) {
            this.stop();
            this.setWatchedSignal1Alt(null);
            this.start();
        }
        if (this.watchedSignal2 != null && this.watchedSignal2.getBean().equals(nb)) {
            this.stop();
            this.setWatchedSignal2(null);
            this.start();
        }
        if (this.watchedSignal2Alt != null && this.watchedSignal2Alt.getBean().equals(nb)) {
            this.stop();
            this.setWatchedSignal2Alt(null);
            this.start();
        }
    }

    private void processCanDelete(PropertyChangeEvent evt, NamedBean nb) throws PropertyVetoException {
        log.debug("name: {} got {} from {}", new Object[]{this.name, evt, evt.getSource()});
        StringBuilder message = new StringBuilder();
        message.append(Bundle.getMessage("InUseBlockBossHeader", this.getDrivenSignal()));
        boolean found = false;
        if (nb instanceof SignalHead) {
            found = this.canDeleteSignalHead(evt, nb, message, found);
        } else if (nb instanceof Turnout) {
            found = this.canDeleteTurnout(nb, message, found);
        } else if (nb instanceof Sensor) {
            found = this.canDeleteSensor(nb, message, found);
        }
        if (found) {
            message.append(Bundle.getMessage("InUseBlockBossFooter"));
            throw new PropertyVetoException(message.toString(), evt);
        }
    }

    private boolean canDeleteSensor(NamedBean nb, StringBuilder message, boolean found) {
        message.append("<ul>");
        if (this.watchSensor1 != null && this.watchSensor1.getBean().equals(nb) || this.watchSensor2 != null && this.watchSensor2.getBean().equals(nb) || this.watchSensor3 != null && this.watchSensor3.getBean().equals(nb) || this.watchSensor4 != null && this.watchSensor4.getBean().equals(nb) || this.watchSensor5 != null && this.watchSensor5.getBean().equals(nb)) {
            this.addMessageToHtmlList(message, "<li>", "InUseWatchedSensor", "</li>");
            found = true;
        }
        if (this.watchedSensor1 != null && this.watchedSensor1.getBean().equals(nb) || this.watchedSensor2 != null && this.watchedSensor2.getBean().equals(nb) || this.watchedSensor1Alt != null && this.watchedSensor1Alt.getBean().equals(nb) || this.watchedSensor2Alt != null && this.watchedSensor2Alt.getBean().equals(nb)) {
            this.addMessageToHtmlList(message, "<li>", "InUseWatchedSensor", "</li>");
            found = true;
        }
        if (this.approachSensor1 != null && this.approachSensor1.getBean().equals(nb)) {
            found = true;
            this.addMessageToHtmlList(message, "<li>", "InUseApproachSensor", "</li>");
        }
        message.append("</ul>");
        return found;
    }

    private boolean canDeleteTurnout(NamedBean nb, StringBuilder message, boolean found) {
        if (this.watchTurnout != null && this.watchTurnout.getBean().equals(nb)) {
            found = true;
            this.addMessageToHtmlList(message, "<ul>", "InUseWatchedTurnout", "</ul>");
        }
        return found;
    }

    private boolean canDeleteSignalHead(PropertyChangeEvent evt, NamedBean nb, StringBuilder message, boolean found) throws PropertyVetoException {
        if (nb.equals(this.getDrivenSignalNamedBean().getBean())) {
            message.append("<br><b>").append(Bundle.getMessage("InUseThisSslWillBeDeleted")).append("</b>");
            throw new PropertyVetoException(message.toString(), evt);
        }
        if (this.watchedSignal1 != null && this.watchedSignal1.getBean().equals(nb) || this.watchedSignal1Alt != null && this.watchedSignal1Alt.getBean().equals(nb) || this.watchedSignal2 != null && this.watchedSignal2.getBean().equals(nb) || this.watchedSignal2Alt != null && this.watchedSignal2Alt.getBean().equals(nb)) {
            this.addMessageToHtmlList(message, "<ul>", "InUseWatchedSignal", "</ul>");
            found = true;
        }
        return found;
    }

    private void addMessageToHtmlList(StringBuilder message, String s, String inUseWatchedSignal, String s2) {
        message.append(s);
        message.append(Bundle.getMessage(inUseWatchedSignal));
        message.append(s2);
    }

    public List<NamedBeanUsageReport> getUsageReport(NamedBean bean) {
        ArrayList<NamedBeanUsageReport> report = new ArrayList<NamedBeanUsageReport>();
        SignalHead head = this.driveSignal.getBean();
        if (bean != null) {
            if (this.watchSensor1 != null && bean.equals(this.getDrivenSignalNamedBean().getBean())) {
                report.add(new NamedBeanUsageReport("SSLSignal", head));
            }
            if (this.watchSensor1 != null && bean.equals(this.watchSensor1.getBean())) {
                report.add(new NamedBeanUsageReport("SSLSensor1", head));
            }
            if (this.watchSensor2 != null && bean.equals(this.watchSensor2.getBean())) {
                report.add(new NamedBeanUsageReport("SSLSensor2", head));
            }
            if (this.watchSensor3 != null && bean.equals(this.watchSensor3.getBean())) {
                report.add(new NamedBeanUsageReport("SSLSensor3", head));
            }
            if (this.watchSensor4 != null && bean.equals(this.watchSensor4.getBean())) {
                report.add(new NamedBeanUsageReport("SSLSensor4", head));
            }
            if (this.watchSensor5 != null && bean.equals(this.watchSensor5.getBean())) {
                report.add(new NamedBeanUsageReport("SSLSensor5", head));
            }
            if (this.watchTurnout != null && bean.equals(this.watchTurnout.getBean())) {
                report.add(new NamedBeanUsageReport("SSLTurnout", head));
            }
            if (this.watchedSignal1 != null && bean.equals(this.watchedSignal1.getBean())) {
                report.add(new NamedBeanUsageReport("SSLSignal1", head));
            }
            if (this.watchedSignal1Alt != null && bean.equals(this.watchedSignal1Alt.getBean())) {
                report.add(new NamedBeanUsageReport("SSLSignal1Alt", head));
            }
            if (this.watchedSignal2 != null && bean.equals(this.watchedSignal2.getBean())) {
                report.add(new NamedBeanUsageReport("SSLSignal2", head));
            }
            if (this.watchedSignal2Alt != null && bean.equals(this.watchedSignal2Alt.getBean())) {
                report.add(new NamedBeanUsageReport("SSLSignal2Alt", head));
            }
            if (this.watchedSensor1 != null && bean.equals(this.watchedSensor1.getBean())) {
                report.add(new NamedBeanUsageReport("SSLSensorWatched1", head));
            }
            if (this.watchedSensor1Alt != null && bean.equals(this.watchedSensor1Alt.getBean())) {
                report.add(new NamedBeanUsageReport("SSLSensorWatched1Alt", head));
            }
            if (this.watchedSensor2 != null && bean.equals(this.watchedSensor2.getBean())) {
                report.add(new NamedBeanUsageReport("SSLSensorWatched2", head));
            }
            if (this.watchedSensor2Alt != null && bean.equals(this.watchedSensor2Alt.getBean())) {
                report.add(new NamedBeanUsageReport("SSLSensorWatched2Alt", head));
            }
            if (this.approachSensor1 != null && bean.equals(this.approachSensor1.getBean())) {
                report.add(new NamedBeanUsageReport("SSLSensorApproach", head));
            }
        }
        return report;
    }
}

