/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.blockboss;

import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import javax.annotation.Nonnull;
import jmri.ConfigureManager;
import jmri.Disposable;
import jmri.InstanceManager;
import jmri.InstanceManagerAutoDefault;
import jmri.SignalHead;
import jmri.SignalHeadManager;
import jmri.jmrit.blockboss.BlockBossLogic;
import jmri.util.NamedBeanComparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlockBossLogicProvider
implements Disposable,
InstanceManagerAutoDefault {
    private final SignalHeadManager signalHeadManager = InstanceManager.getDefault(SignalHeadManager.class);
    private final Map<SignalHead, BlockBossLogic> headToBlockBossLogicMap = new TreeMap(new NamedBeanComparator());
    private static final Logger log = LoggerFactory.getLogger(BlockBossLogicProvider.class);

    public BlockBossLogicProvider() {
        ConfigureManager cm = InstanceManager.getNullableDefault(ConfigureManager.class);
        if (cm != null) {
            cm.registerConfig(this, 150);
        }
    }

    public BlockBossLogic provide(@Nonnull String signalName) {
        SignalHead signalHead = this.signalHeadManager.getSignalHead(signalName);
        if (signalHead == null) {
            log.error("SignalHead {} doesn't exist, BlockBossLogic.getExisting(\"{}\") cannot continue", (Object)signalName, (Object)signalName);
            throw new IllegalArgumentException("Requested signal head doesn't exist");
        }
        return this.provide(signalHead);
    }

    public BlockBossLogic provide(@Nonnull SignalHead signalHead) {
        if (signalHead == null) {
            log.error("BlockBossLogic requested for null signal head.");
            throw new IllegalArgumentException("BlockBossLogic Requested for null signal head.");
        }
        return this.headToBlockBossLogicMap.computeIfAbsent(signalHead, o -> new BlockBossLogic(o.getDisplayName()));
    }

    public void register(BlockBossLogic blockBossLogic) {
        this.headToBlockBossLogicMap.put(blockBossLogic.driveSignal.getBean(), blockBossLogic);
    }

    public void remove(BlockBossLogic blockBossLogic) {
        this.headToBlockBossLogicMap.remove(blockBossLogic.driveSignal.getBean(), blockBossLogic);
    }

    public Collection<BlockBossLogic> provideAll() {
        return this.headToBlockBossLogicMap.values();
    }

    @Override
    public void dispose() {
        for (BlockBossLogic b : this.headToBlockBossLogicMap.values()) {
            b.stop();
        }
        this.headToBlockBossLogicMap.clear();
    }
}

