/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.blockboss.configurexml;

import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import jmri.InstanceManager;
import jmri.SignalHeadManager;
import jmri.configurexml.AbstractXmlAdapter;
import jmri.jmrit.blockboss.BlockBossLogic;
import jmri.jmrit.blockboss.BlockBossLogicProvider;
import org.jdom2.Content;
import org.jdom2.DataConversionException;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlockBossLogicProviderXml
extends AbstractXmlAdapter {
    private static final String SYSTEM_NAME = "systemName";
    private static final String SIGNAL = "signal";
    private static final String APPROACHSENSOR_1 = "approachsensor1";
    private static final String WATCHEDTURNOUT = "watchedturnout";
    private static final String WATCHEDSIGNAL_1 = "watchedsignal1";
    private static final String WATCHEDSIGNAL_1_ALT = "watchedsignal1alt";
    private static final String WATCHEDSIGNAL_2 = "watchedsignal2";
    private static final String WATCHEDSIGNAL_2_ALT = "watchedsignal2alt";
    private static final String WATCHEDSENSOR_1 = "watchedsensor1";
    private static final String WATCHEDSENSOR_1_ALT = "watchedsensor1alt";
    private static final String WATCHEDSENSOR_2 = "watchedsensor2";
    private static final String WATCHEDSENSOR_2_ALT = "watchedsensor2alt";
    private static final String LIMITSPEED_1 = "limitspeed1";
    private static final String LIMITSPEED_2 = "limitspeed2";
    private static final String RESTRICTINGSPEED_1 = "restrictingspeed1";
    private static final String RESTRICTINGSPEED_2 = "restrictingspeed2";
    private static final String USEFLASHYELLOW = "useflashyellow";
    private static final String DISTANTSIGNAL = "distantsignal";
    private final BlockBossLogicProvider blockBossLogicProvider = InstanceManager.getDefault(BlockBossLogicProvider.class);
    private static final Logger log = LoggerFactory.getLogger(BlockBossLogicProviderXml.class);

    @Override
    public Element store(Object o) {
        Enumeration<BlockBossLogic> e = Collections.enumeration(this.blockBossLogicProvider.provideAll());
        if (!e.hasMoreElements()) {
            return null;
        }
        Element blocks = new Element("signalelements");
        blocks.setAttribute("class", this.getClass().getName());
        while (e.hasMoreElements()) {
            BlockBossLogic p = e.nextElement();
            Element block = this.getElementFromBlockBossLogic(p);
            blocks.addContent((Content)block);
        }
        return blocks;
    }

    private Element getElementFromBlockBossLogic(BlockBossLogic p) {
        Element block = new Element("signalelement");
        block.setAttribute(SIGNAL, p.getDrivenSignal());
        block.setAttribute("mode", "" + p.getMode());
        if (p.getApproachSensor1() != null) {
            block.setAttribute(APPROACHSENSOR_1, p.getApproachSensor1());
        }
        if (p.getSensor1() != null) {
            block.addContent((Content)this.storeSensor(p.getSensor1()));
        }
        if (p.getSensor2() != null) {
            block.addContent((Content)this.storeSensor(p.getSensor2()));
        }
        if (p.getSensor3() != null) {
            block.addContent((Content)this.storeSensor(p.getSensor3()));
        }
        if (p.getSensor4() != null) {
            block.addContent((Content)this.storeSensor(p.getSensor4()));
        }
        if (p.getSensor5() != null) {
            block.addContent((Content)this.storeSensor(p.getSensor5()));
        }
        if (p.getTurnout() != null) {
            block.setAttribute(WATCHEDTURNOUT, p.getTurnout());
        }
        if (p.getWatchedSignal1() != null) {
            block.setAttribute(WATCHEDSIGNAL_1, p.getWatchedSignal1());
        }
        if (p.getWatchedSignal1Alt() != null) {
            block.setAttribute(WATCHEDSIGNAL_1_ALT, p.getWatchedSignal1Alt());
        }
        if (p.getWatchedSignal2() != null) {
            block.setAttribute(WATCHEDSIGNAL_2, p.getWatchedSignal2());
        }
        if (p.getWatchedSignal2Alt() != null) {
            block.setAttribute(WATCHEDSIGNAL_2_ALT, p.getWatchedSignal2Alt());
        }
        if (p.getWatchedSensor1() != null) {
            block.setAttribute(WATCHEDSENSOR_1, p.getWatchedSensor1());
        }
        if (p.getWatchedSensor1Alt() != null) {
            block.setAttribute(WATCHEDSENSOR_1_ALT, p.getWatchedSensor1Alt());
        }
        if (p.getWatchedSensor2() != null) {
            block.setAttribute(WATCHEDSENSOR_2, p.getWatchedSensor2());
        }
        if (p.getWatchedSensor2Alt() != null) {
            block.setAttribute(WATCHEDSENSOR_2_ALT, p.getWatchedSensor2Alt());
        }
        block.setAttribute(LIMITSPEED_1, "" + p.getLimitSpeed1());
        block.setAttribute(LIMITSPEED_2, "" + p.getLimitSpeed2());
        if (p.getRestrictingSpeed1()) {
            block.setAttribute(RESTRICTINGSPEED_1, "" + p.getRestrictingSpeed1());
        }
        if (p.getRestrictingSpeed2()) {
            block.setAttribute(RESTRICTINGSPEED_2, "" + p.getRestrictingSpeed2());
        }
        block.setAttribute(USEFLASHYELLOW, "" + p.getUseFlash());
        block.setAttribute(DISTANTSIGNAL, "" + p.getDistantSignal());
        if (p.getComment() != null) {
            Element c = new Element("comment");
            c.addContent(p.getComment());
            block.addContent((Content)c);
        }
        return block;
    }

    private Element storeSensor(String name) {
        Element e = new Element("sensorname");
        e.addContent(name);
        return e;
    }

    @Override
    public boolean load(Element shared, Element perNode) {
        List l = shared.getChildren("signalelement");
        if (l.size() == 0) {
            l = shared.getChildren("block");
        }
        for (Element block : l) {
            BlockBossLogic bb = this.getBlockBossLogicFromElement(block);
            if (bb == null) continue;
            this.loadBlockBossLogicDetailsFromElement(block, bb);
        }
        return true;
    }

    private boolean loadBlockBossLogicDetailsFromElement(Element block, BlockBossLogic bb) {
        boolean result = this.loadOptionalApproachSensor(block, bb);
        result &= this.loadOptionalWatchedSensor(block, bb);
        result &= this.loadOldFormSensorNames(block, bb);
        try {
            bb.setMode(block.getAttribute("mode").getIntValue());
            if (block.getAttribute(DISTANTSIGNAL) != null) {
                bb.setDistantSignal(block.getAttribute(DISTANTSIGNAL).getBooleanValue());
            }
            if (block.getAttribute(LIMITSPEED_1) != null) {
                bb.setLimitSpeed1(block.getAttribute(LIMITSPEED_1).getBooleanValue());
            }
            if (block.getAttribute(RESTRICTINGSPEED_1) != null) {
                bb.setRestrictingSpeed1(block.getAttribute(RESTRICTINGSPEED_1).getBooleanValue());
            }
            if (block.getAttribute(LIMITSPEED_2) != null) {
                bb.setLimitSpeed2(block.getAttribute(LIMITSPEED_2).getBooleanValue());
            }
            if (block.getAttribute(RESTRICTINGSPEED_2) != null) {
                bb.setRestrictingSpeed2(block.getAttribute(RESTRICTINGSPEED_2).getBooleanValue());
            }
            result &= this.loadWatchedTurnout(block, bb);
            result &= this.loadWatchedSignal1(block, bb);
            result &= this.loadWAtchedSignal1Alt(block, bb);
            result &= this.loadWatchedSignal2(block, bb);
            result &= this.loadWatchedSignal2Alt(block, bb);
            result &= this.loadWatchedSensor1(block, bb);
            result &= this.loadWatchedSensor1Alt(block, bb);
            result &= this.loadWatchedSensor2(block, bb);
            result &= this.loadWatchedSensor2Alt(block, bb);
            String c = block.getChildText("comment");
            if (c != null) {
                bb.setComment(c);
            }
        }
        catch (DataConversionException e) {
            log.warn("error reading blocks from file", (Throwable)e);
            result = false;
        }
        catch (IllegalArgumentException e) {
            log.error("An error occurred in the signal element attribute list");
            result = false;
        }
        try {
            this.blockBossLogicProvider.register(bb);
            bb.start();
        }
        catch (IllegalArgumentException e) {
            log.debug("An error occurred trying to start the signal logic {} :: message = {}", (Object)bb.getDrivenSignal(), (Object)e.getMessage());
            result = false;
        }
        return result;
    }

    private boolean loadOldFormSensorNames(Element block, BlockBossLogic bb) {
        boolean result = true;
        List sl = block.getChildren("sensor");
        try {
            this.getSensorAttributesUsingSystemName(bb, sl);
        }
        catch (IllegalArgumentException e) {
            log.error("An error occurred loading the sensors list in the SSL");
            result = false;
        }
        sl = block.getChildren("sensorname");
        try {
            if (sl.size() >= 1 && sl.get(0) != null) {
                bb.setSensor1(((Element)sl.get(0)).getText());
            }
        }
        catch (IllegalArgumentException e) {
            log.error("An error occurred loading the sensor1 list in the SSL for {}", (Object)bb.getDrivenSignal());
            result = false;
        }
        try {
            if (sl.size() >= 2 && sl.get(1) != null) {
                bb.setSensor2(((Element)sl.get(1)).getText());
            }
        }
        catch (IllegalArgumentException e) {
            log.error("An error occurred loading the sensor2 list in the SSL for {}", (Object)bb.getDrivenSignal());
            result = false;
        }
        try {
            if (sl.size() >= 3 && sl.get(2) != null) {
                bb.setSensor3(((Element)sl.get(2)).getText());
            }
        }
        catch (IllegalArgumentException e) {
            log.error("An error occurred loading the sensor3 list in the SSL for {}", (Object)bb.getDrivenSignal());
            result = false;
        }
        try {
            if (sl.size() >= 4 && sl.get(3) != null) {
                bb.setSensor4(((Element)sl.get(3)).getText());
            }
        }
        catch (IllegalArgumentException e) {
            log.error("An error occurred loading the sensor4 list in the SSL for {}", (Object)bb.getDrivenSignal());
            result = false;
        }
        try {
            if (sl.size() >= 5 && sl.get(4) != null) {
                bb.setSensor5(((Element)sl.get(4)).getText());
            }
        }
        catch (IllegalArgumentException e) {
            log.error("An error occurred loading the sensor5 list in the SSL for {}", (Object)bb.getDrivenSignal());
            result = false;
        }
        return result;
    }

    private boolean loadOptionalWatchedSensor(Element block, BlockBossLogic bb) {
        boolean result = true;
        if (block.getAttribute("watchedsensor") != null) {
            try {
                bb.setSensor1(block.getAttributeValue("watchedsensor"));
            }
            catch (IllegalArgumentException e) {
                log.error("An error occurred loading the watched sensor in the SSL for {}", (Object)bb.getDrivenSignal());
                result = false;
            }
        }
        return result;
    }

    private boolean loadOptionalApproachSensor(Element block, BlockBossLogic bb) {
        boolean result = true;
        if (block.getAttribute(APPROACHSENSOR_1) != null) {
            try {
                bb.setApproachSensor1(block.getAttributeValue(APPROACHSENSOR_1));
            }
            catch (IllegalArgumentException e) {
                log.error("An error occurred loading the approach sensor for the signal elements for {}", (Object)bb.getDrivenSignal());
                result = false;
            }
        }
        return result;
    }

    private boolean loadWatchedSensor2Alt(Element block, BlockBossLogic bb) {
        boolean result = true;
        try {
            if (block.getAttribute(WATCHEDSENSOR_2_ALT) != null) {
                bb.setWatchedSensor2Alt(block.getAttributeValue(WATCHEDSENSOR_2_ALT));
            }
        }
        catch (IllegalArgumentException e) {
            log.error("An error occurred in retrieving the watched sensor 2 alt ({})element attribute list for {}", (Object)block.getAttributeValue(WATCHEDSENSOR_2_ALT), (Object)bb.getDrivenSignal());
            result = false;
        }
        return result;
    }

    private boolean loadWatchedSensor2(Element block, BlockBossLogic bb) {
        boolean result = true;
        try {
            if (block.getAttribute(WATCHEDSENSOR_2) != null) {
                bb.setWatchedSensor2(block.getAttributeValue(WATCHEDSENSOR_2));
            }
        }
        catch (IllegalArgumentException e) {
            log.error("An error occurred in retrieving the watched sensor 2 ({}) element attribute list for {}", (Object)block.getAttributeValue(WATCHEDSENSOR_2), (Object)bb.getDrivenSignal());
            result = false;
        }
        return result;
    }

    private boolean loadWatchedSensor1Alt(Element block, BlockBossLogic bb) {
        boolean result = true;
        try {
            if (block.getAttribute(WATCHEDSENSOR_1_ALT) != null) {
                bb.setWatchedSensor1Alt(block.getAttributeValue(WATCHEDSENSOR_1_ALT));
            }
        }
        catch (IllegalArgumentException e) {
            log.error("An error occurred in retrieving the watched sensor 1 alt ({}) element attribute list for {}", (Object)block.getAttributeValue(WATCHEDSENSOR_1_ALT), (Object)bb.getDrivenSignal());
            result = false;
        }
        return result;
    }

    private boolean loadWatchedSensor1(Element block, BlockBossLogic bb) {
        boolean result = true;
        try {
            if (block.getAttribute(WATCHEDSENSOR_1) != null) {
                bb.setWatchedSensor1(block.getAttributeValue(WATCHEDSENSOR_1));
            }
        }
        catch (IllegalArgumentException e) {
            log.error("An error occurred in retrieving the watched sensor 1 ({}) element attribute list for {}", (Object)block.getAttributeValue(WATCHEDSENSOR_1), (Object)bb.getDrivenSignal());
            result = false;
        }
        return result;
    }

    private boolean loadWatchedSignal2Alt(Element block, BlockBossLogic bb) {
        boolean result = true;
        try {
            if (block.getAttribute(WATCHEDSIGNAL_2_ALT) != null) {
                bb.setWatchedSignal2Alt(block.getAttributeValue(WATCHEDSIGNAL_2_ALT));
            }
        }
        catch (IllegalArgumentException e) {
            log.error("An error occurred in retrieving the watched signal 2 alt ({}) element attribute list for {}", (Object)block.getAttributeValue(WATCHEDSIGNAL_2_ALT), (Object)bb.getDrivenSignal());
            result = false;
        }
        return result;
    }

    private boolean loadWatchedSignal2(Element block, BlockBossLogic bb) {
        boolean result = true;
        try {
            if (block.getAttribute(WATCHEDSIGNAL_2) != null) {
                bb.setWatchedSignal2(block.getAttributeValue(WATCHEDSIGNAL_2));
            }
        }
        catch (IllegalArgumentException e) {
            log.error("An error occurred in retrieving the watched signal 2 ({})element attribute list for {}", (Object)block.getAttributeValue(WATCHEDSIGNAL_2), (Object)bb.getDrivenSignal());
            result = false;
        }
        return result;
    }

    private boolean loadWAtchedSignal1Alt(Element block, BlockBossLogic bb) {
        boolean result = true;
        try {
            if (block.getAttribute(WATCHEDSIGNAL_1_ALT) != null) {
                bb.setWatchedSignal1Alt(block.getAttributeValue(WATCHEDSIGNAL_1_ALT));
            }
        }
        catch (IllegalArgumentException e) {
            log.error("An error occurred in retrieving the watched signal 1 alt ({})element attribute list for {}", (Object)block.getAttributeValue(WATCHEDSIGNAL_1_ALT), (Object)bb.getDrivenSignal());
            result = false;
        }
        return result;
    }

    private boolean loadWatchedSignal1(Element block, BlockBossLogic bb) throws DataConversionException {
        boolean result = true;
        try {
            if (block.getAttribute(WATCHEDSIGNAL_1) != null) {
                bb.setWatchedSignal1(block.getAttributeValue(WATCHEDSIGNAL_1), block.getAttribute(USEFLASHYELLOW).getBooleanValue());
            }
        }
        catch (IllegalArgumentException e) {
            log.error("An error occurred in retrieving the watched signal 1 ({})element attribute list for {}", (Object)block.getAttributeValue(WATCHEDSIGNAL_1), (Object)bb.getDrivenSignal());
            result = false;
        }
        return result;
    }

    private boolean loadWatchedTurnout(Element block, BlockBossLogic bb) {
        boolean result = true;
        try {
            if (block.getAttribute(WATCHEDTURNOUT) != null) {
                bb.setTurnout(block.getAttributeValue(WATCHEDTURNOUT));
            }
        }
        catch (IllegalArgumentException e) {
            log.error("An error occurred in retrieving the watched turnout ({})element attribute list for {}", (Object)block.getAttributeValue(WATCHEDTURNOUT), (Object)bb.getDrivenSignal());
            result = false;
        }
        return result;
    }

    private BlockBossLogic getBlockBossLogicFromElement(Element block) {
        BlockBossLogic blockBossLogic;
        String signalName = block.getAttributeValue(SIGNAL);
        if (signalName == null || signalName.isEmpty()) {
            log.error("Ignoring a <signalelement> element with no signal attribute value");
            return null;
        }
        if (InstanceManager.getDefault(SignalHeadManager.class).getSignalHead(signalName) == null) {
            log.error("SignalHead {} not defined, <signalelement> element referring to it is ignored", (Object)signalName);
            return null;
        }
        try {
            blockBossLogic = BlockBossLogic.getStoppedObject(signalName);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        return blockBossLogic;
    }

    private void getSensorAttributesUsingSystemName(BlockBossLogic bb, List<Element> sl) {
        if (sl.size() >= 1 && sl.get(0) != null) {
            bb.setSensor1(sl.get(0).getAttributeValue(SYSTEM_NAME));
        }
        if (sl.size() >= 2 && sl.get(1) != null) {
            bb.setSensor2(sl.get(1).getAttributeValue(SYSTEM_NAME));
        }
        if (sl.size() >= 3 && sl.get(2) != null) {
            bb.setSensor3(sl.get(2).getAttributeValue(SYSTEM_NAME));
        }
        if (sl.size() >= 4 && sl.get(3) != null) {
            bb.setSensor4(sl.get(3).getAttributeValue(SYSTEM_NAME));
        }
        if (sl.size() >= 5 && sl.get(4) != null) {
            bb.setSensor5(sl.get(4).getAttributeValue(SYSTEM_NAME));
        }
    }

    @Override
    public void load(Element element, Object o) {
        log.error("load(Element, Object) called unexpectedly");
    }

    @Override
    public int loadOrder() {
        return 150;
    }
}

