/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.cabsignals;

import javax.swing.JButton;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.AbstractTableModel;
import jmri.Block;
import jmri.BlockManager;
import jmri.CabSignal;
import jmri.CabSignalManager;
import jmri.InstanceManager;
import jmri.LocoAddress;
import jmri.Path;
import jmri.SignalMast;
import jmri.jmrit.cabsignals.Bundle;
import jmri.managers.DefaultCabSignalManager;
import jmri.util.ThreadingUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CabSignalTableModel
extends AbstractTableModel {
    private CabSignalManager cabSignalManager = InstanceManager.getNullableDefault(CabSignalManager.class);
    public static final int LOCO_ID_COLUMN = 0;
    public static final int SEND_CABSIG_COLUMN = 1;
    public static final int CURRENT_BLOCK = 2;
    public static final int BLOCK_DIR = 3;
    public static final int REVERSE_BLOCK_DIR_BUTTON_COLUMN = 4;
    public static final int NEXT_BLOCK = 5;
    public static final int NEXT_SIGNAL = 6;
    public static final int NEXT_ASPECT = 7;
    public static final int NEXT_ASPECT_ICON = 8;
    public static final int MAX_COLUMN = 9;
    static final int[] STARTUPCOLUMNS = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8};
    static final String[] COLUMNTOOLTIPS = new String[]{null, Bundle.getMessage("CabsigCheckboxTip"), Bundle.getMessage("BlockUserName"), Bundle.getMessage("BlockDirectionTip"), null, Bundle.getMessage("NextBlockTip"), Bundle.getMessage("NextSignalTip"), Bundle.getMessage("NextAspectTip"), Bundle.getMessage("NextIconTip")};
    private static final Logger log = LoggerFactory.getLogger(CabSignalTableModel.class);

    CabSignalTableModel(int row, int column) {
        if (this.cabSignalManager == null) {
            log.info("creating new DefaultCabSignalManager");
            InstanceManager.store(new DefaultCabSignalManager(), CabSignalManager.class);
            this.cabSignalManager = InstanceManager.getNullableDefault(CabSignalManager.class);
        }
    }

    @Override
    public int getRowCount() {
        return this.cabSignalManager.getCabSignalList().size();
    }

    @Override
    public int getColumnCount() {
        return 9;
    }

    @Override
    public String getColumnName(int col) {
        switch (col) {
            case 0: {
                return Bundle.getMessage("LocoID");
            }
            case 2: {
                return Bundle.getMessage("Block");
            }
            case 3: {
                return Bundle.getMessage("BlockDirection");
            }
            case 4: {
                return Bundle.getMessage("BlockButton");
            }
            case 5: {
                return Bundle.getMessage("NextBlock");
            }
            case 6: {
                return Bundle.getMessage("NextSignal");
            }
            case 7: {
                return Bundle.getMessage("NextAspect");
            }
            case 1: {
                return Bundle.getMessage("SigDataOn");
            }
            case 8: {
                return Bundle.getMessage("AspectIconMenu");
            }
        }
        return "unknown";
    }

    public static int getPreferredWidth(int col) {
        switch (col) {
            case 1: 
            case 8: {
                return new JTextField((int)3).getPreferredSize().width;
            }
            case 0: {
                return new JTextField((int)4).getPreferredSize().width;
            }
            case 3: 
            case 6: {
                return new JTextField((int)6).getPreferredSize().width;
            }
            case 2: 
            case 5: {
                return new JTextField((int)8).getPreferredSize().width;
            }
            case 4: 
            case 7: {
                return new JTextField((int)10).getPreferredSize().width;
            }
        }
        log.warn("no width found col {}", (Object)col);
        return new JTextField((String)" <unknown> ").getPreferredSize().width;
    }

    @Override
    public Class<?> getColumnClass(int col) {
        switch (col) {
            case 0: {
                return LocoAddress.class;
            }
            case 4: {
                return JButton.class;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                return String.class;
            }
            case 1: {
                return Boolean.class;
            }
        }
        log.error("no column class located");
        return null;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        switch (col) {
            case 1: 
            case 4: {
                return true;
            }
        }
        return false;
    }

    public void configureTable(JTable cmdStatTable) {
        cmdStatTable.getTableHeader().setReorderingAllowed(true);
        cmdStatTable.setAutoResizeMode(0);
        for (int i = 0; i < cmdStatTable.getColumnCount(); ++i) {
            int width = CabSignalTableModel.getPreferredWidth(i);
            cmdStatTable.getColumnModel().getColumn(i).setPreferredWidth(width);
        }
    }

    @Override
    public Object getValueAt(int row, int col) {
        switch (col) {
            case 0: {
                this.cabSignalManager.getCabSignalArray()[row].addPropertyChangeListener(e -> {
                    if (e.getSource() instanceof CabSignal) {
                        this.fireTableDataChanged();
                    }
                });
                return this.cabSignalManager.getCabSignalArray()[row].getCabSignalAddress();
            }
            case 2: {
                Block b = this.cabSignalManager.getCabSignalArray()[row].getBlock();
                if (b != null) {
                    return b.getDisplayName();
                }
                return "";
            }
            case 3: {
                Block b = this.cabSignalManager.getCabSignalArray()[row].getBlock();
                if (b != null) {
                    return Path.decodeDirection(b.getDirection());
                }
                return "";
            }
            case 4: {
                if (this.cabSignalManager.getCabSignalArray()[row].getBlock() == null) {
                    return Bundle.getMessage("BlockLookup");
                }
                return Bundle.getMessage("ChngDirection");
            }
            case 5: {
                Block nextBl = this.cabSignalManager.getCabSignalArray()[row].getNextBlock();
                if (nextBl != null) {
                    return nextBl.getDisplayName();
                }
                return "";
            }
            case 6: {
                SignalMast mast = this.cabSignalManager.getCabSignalArray()[row].getNextMast();
                if (mast != null) {
                    return mast.getDisplayName();
                }
                return "";
            }
            case 7: {
                SignalMast mast = this.cabSignalManager.getCabSignalArray()[row].getNextMast();
                if (mast != null) {
                    return mast.getAspect();
                }
                return "";
            }
            case 8: {
                SignalMast mast = this.cabSignalManager.getCabSignalArray()[row].getNextMast();
                if (mast != null) {
                    String imageLink = mast.getAppearanceMap().getProperty(mast.getAspect(), "imagelink");
                    log.debug("imagelink is {}", (Object)imageLink);
                    if (imageLink != null) {
                        String newlink = imageLink.replace("../", "");
                        return newlink;
                    }
                }
                return "";
            }
            case 1: {
                return this.cabSignalManager.getCabSignalArray()[row].isCabSignalActive();
            }
        }
        log.error("internal state inconsistent with table request for row {} col {}", (Object)row, (Object)col);
        return null;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        switch (col) {
            case 4: {
                this.cabSignalManager.getCabSignalArray()[row].setBlock();
                this.chngblockdir(row);
                break;
            }
            case 5: {
                ThreadingUtil.runOnLayout(() -> {
                    BlockManager bmgr = InstanceManager.getDefault(BlockManager.class);
                    Block b = bmgr.getBlock((String)value);
                    this.cabSignalManager.getCabSignalArray()[row].setBlock(b);
                });
                break;
            }
            case 1: {
                this.cabSignalManager.getCabSignalArray()[row].setCabSignalActive((Boolean)value);
                break;
            }
        }
    }

    private void chngblockdir(int row) {
        int olddirection;
        log.debug("changing block direction for row {}", (Object)row);
        Block b = this.cabSignalManager.getCabSignalArray()[row].getBlock();
        if (b == null) {
            this.cabSignalManager.getCabSignalArray()[row].setBlock();
            b = this.cabSignalManager.getCabSignalArray()[row].getBlock();
            if (b == null) {
                return;
            }
            this.cabSignalManager.getCabSignalArray()[row].setBlock(b);
            olddirection = b.getDirection();
        } else {
            olddirection = b.getDirection();
            log.debug("Block {} set to direction {} ", (Object)b.getUserName(), (Object)String.valueOf(olddirection));
        }
        log.debug(" Direction to reverse :{}", (Object)Path.decodeDirection(olddirection));
        if (olddirection == 0) {
            log.debug("No direction found, setting to North, East");
            b.setDirection(80);
        } else {
            log.debug(" direction found, setting reverse.");
            b.setDirection(Path.reverseDirection(olddirection));
        }
        this.fireTableDataChanged();
        log.debug("block {} now has direction {}", (Object)b.getUserName(), (Object)b.getDirection());
    }

    protected void setPanelPauseButton(boolean isPaused) {
        for (int i = 0; i < this.getRowCount(); ++i) {
            this.cabSignalManager.getCabSignalArray()[i].setMasterCabSigPauseActive(isPaused);
        }
    }

    public void dispose() {
    }
}

