/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.catalog;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.swing.tree.DefaultTreeModel;
import jmri.CatalogTree;
import jmri.CatalogTreeNode;
import jmri.JmriException;
import jmri.NamedBean;
import jmri.jmrit.catalog.Bundle;
import jmri.util.AlphanumComparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCatalogTree
extends DefaultTreeModel
implements CatalogTree {
    private String mUserName;
    protected final String mSystemName;
    private String comment;
    PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    HashMap<PropertyChangeListener, String> register = new HashMap();
    HashMap<PropertyChangeListener, String> listenerRefs = new HashMap();
    private static final Logger log = LoggerFactory.getLogger(AbstractCatalogTree.class);

    public AbstractCatalogTree(String sysname, String username) {
        super(new CatalogTreeNode(username));
        this.mSystemName = sysname;
        this.setUserName(username);
    }

    public AbstractCatalogTree(String sysname) {
        this(sysname, "root");
    }

    @Override
    @CheckReturnValue
    public String getBeanType() {
        return Bundle.getMessage("BeanNameCatalog");
    }

    @Override
    public abstract void insertNodes(String var1, String var2, CatalogTreeNode var3);

    @Override
    public void insertNodes(String pathToRoot) {
        CatalogTreeNode r = this.getRoot();
        log.debug("insertNodes: rootName= {}, pathToRoot= {}", r.getUserObject(), (Object)pathToRoot);
        this.insertNodes((String)r.getUserObject(), pathToRoot, r);
    }

    @Override
    @CheckReturnValue
    public CatalogTreeNode getRoot() {
        return (CatalogTreeNode)super.getRoot();
    }

    @Override
    @CheckReturnValue
    public String getComment() {
        return this.comment;
    }

    @Override
    public void setComment(String comment) {
        String old = this.comment;
        this.comment = comment;
        this.firePropertyChange("Comment", old, comment);
    }

    @Override
    public synchronized void addPropertyChangeListener(PropertyChangeListener l) {
        this.pcs.addPropertyChangeListener(l);
    }

    @Override
    public synchronized void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(propertyName, listener);
    }

    @Override
    public synchronized void removePropertyChangeListener(PropertyChangeListener l) {
        this.pcs.removePropertyChangeListener(l);
    }

    @Override
    public synchronized void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(propertyName, listener);
    }

    @Override
    public synchronized PropertyChangeListener[] getPropertyChangeListeners() {
        return this.pcs.getPropertyChangeListeners();
    }

    @Override
    public synchronized PropertyChangeListener[] getPropertyChangeListeners(String propertyName) {
        return this.pcs.getPropertyChangeListeners(propertyName);
    }

    @Override
    @CheckReturnValue
    public synchronized int getNumPropertyChangeListeners() {
        return this.pcs.getPropertyChangeListeners().length;
    }

    @Override
    public synchronized void addPropertyChangeListener(PropertyChangeListener l, String beanRef, String listenerRef) {
        this.pcs.addPropertyChangeListener(l);
        if (beanRef != null) {
            this.register.put(l, beanRef);
        }
        if (listenerRef != null) {
            this.listenerRefs.put(l, listenerRef);
        }
    }

    @Override
    public synchronized void addPropertyChangeListener(String propertyName, PropertyChangeListener listener, String beanRef, String listenerRef) {
        this.pcs.addPropertyChangeListener(propertyName, listener);
        if (beanRef != null) {
            this.register.put(listener, beanRef);
        }
        if (listenerRef != null) {
            this.listenerRefs.put(listener, listenerRef);
        }
    }

    @Override
    @CheckReturnValue
    public synchronized PropertyChangeListener[] getPropertyChangeListenersByReference(String name) {
        ArrayList list = new ArrayList();
        this.register.keySet().stream().filter(l -> this.register.get(l).equals(name)).forEachOrdered(l -> list.add(l));
        return list.toArray(new PropertyChangeListener[list.size()]);
    }

    @Override
    @CheckReturnValue
    public synchronized ArrayList<String> getListenerRefs() {
        return new ArrayList<String>(this.listenerRefs.values());
    }

    @Override
    public synchronized void updateListenerRef(PropertyChangeListener l, String newName) {
        if (this.listenerRefs.containsKey(l)) {
            this.listenerRefs.put(l, newName);
        }
    }

    @Override
    @CheckReturnValue
    public synchronized String getListenerRef(PropertyChangeListener l) {
        return this.listenerRefs.get(l);
    }

    @Override
    @CheckReturnValue
    public String getSystemName() {
        return this.mSystemName;
    }

    @Override
    @CheckReturnValue
    public String getUserName() {
        return this.mUserName;
    }

    @Override
    public void setUserName(String s) {
        String old = this.mUserName;
        this.mUserName = NamedBean.normalizeUserName(s);
        this.firePropertyChange("UserName", old, this.mUserName);
    }

    protected void firePropertyChange(String p, Object old, Object n) {
        this.pcs.firePropertyChange(p, old, n);
    }

    @Override
    public void dispose() {
        this.pcs = null;
    }

    @Override
    @CheckReturnValue
    public int getState() {
        return 0;
    }

    @Override
    @CheckReturnValue
    public String describeState(int state) {
        switch (state) {
            case 1: {
                return Bundle.getMessage("BeanStateUnknowng");
            }
            case 8: {
                return Bundle.getMessage("BeanStateInconsistent");
            }
        }
        return Bundle.getMessage("BeanStateUnexpected", state);
    }

    @Override
    public void setState(int s) throws JmriException {
    }

    public void addDeleteLock(NamedBean lock) {
    }

    public void removeDeleteLock(NamedBean lock) {
    }

    @CheckReturnValue
    public boolean isDeleteAllowed() {
        return true;
    }

    @Override
    public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
    }

    @Override
    @CheckReturnValue
    public int compareSystemNameSuffix(@Nonnull String suffix1, @Nonnull String suffix2, @Nonnull NamedBean n) {
        AlphanumComparator ac = new AlphanumComparator();
        return ac.compare(suffix1, suffix2);
    }
}

