/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.catalog;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.TransferHandler;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import jmri.CatalogTree;
import jmri.CatalogTreeLeaf;
import jmri.CatalogTreeManager;
import jmri.CatalogTreeNode;
import jmri.InstanceManager;
import jmri.jmrit.catalog.AbstractCatalogTree;
import jmri.jmrit.catalog.Bundle;
import jmri.jmrit.catalog.DragJLabel;
import jmri.jmrit.catalog.NamedIcon;
import jmri.jmrit.display.palette.IconItemPanel;
import jmri.util.FileUtil;
import jmri.util.ThreadingUtil;
import jmri.util.swing.DrawSquares;
import jmri.util.swing.ImagePanel;
import jmri.util.swing.JmriJOptionPane;
import jmri.util.swing.JmriMouseEvent;
import jmri.util.swing.JmriMouseListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CatalogPanel
extends JPanel {
    private static final Object _lock = new Object();
    public static final double ICON_SCALE = 0.02;
    public static final int ICON_WIDTH = 100;
    public static final int ICON_HEIGHT = 100;
    private IconDisplayPanel _selectedImage;
    private IconItemPanel _parent;
    private JSplitPane _splitPane;
    static Color _grayColor = new Color(235, 235, 235);
    static Color _darkGrayColor = new Color(150, 150, 150);
    protected Color[] colorChoice = new Color[]{Color.white, _grayColor, _darkGrayColor};
    protected BufferedImage[] _backgrounds;
    JScrollPane _iconPane;
    JLabel _previewLabel = new JLabel(" ");
    protected ImagePanel _preview;
    private boolean _treeDnd;
    private boolean _dragIcons;
    private JScrollPane _treePane;
    private JTree _dTree;
    private DefaultTreeModel _model;
    private final ArrayList<CatalogTree> _branchModel = new ArrayList();
    private boolean _noMemory = false;
    private static final Logger log = LoggerFactory.getLogger(CatalogPanel.class);

    private CatalogPanel() {
        this._model = new DefaultTreeModel(new CatalogTreeNode("mainRoot"));
    }

    private CatalogPanel(String label1, String label2, boolean addButtonPanel) {
        super(true);
        this.setLayout(new BoxLayout(this, 1));
        this.setLayout(new BorderLayout());
        this.add((Component)new JLabel(Bundle.getMessage(label2)), "North");
        this._splitPane = new JSplitPane(1, this.makeTreePanel(label1), this.makePreviewPanel());
        this._splitPane.setContinuousLayout(true);
        this._splitPane.setOneTouchExpandable(true);
        this.add((Component)this._splitPane, "Center");
        if (addButtonPanel) {
            this.add((Component)this.makeButtonPanel(), "South");
        }
    }

    private CatalogPanel(String label1, String label2) {
        this(label1, label2, true);
    }

    @Override
    public void setToolTipText(String tip) {
        if (this._dTree != null) {
            this._dTree.setToolTipText(tip);
        }
        if (this._treePane != null) {
            this._treePane.setToolTipText(tip);
        }
        super.setToolTipText(tip);
    }

    private void init(boolean treeDnD, boolean dragIcons) {
        this._model = new DefaultTreeModel(new CatalogTreeNode("mainRoot"));
        if (treeDnD) {
            this._dTree = new DropJTree(this._model);
            this.setTransferHandler(new DropOnPanelToNode());
        } else {
            this._dTree = new JTree(this._model);
        }
        this._treeDnd = treeDnD;
        this._dragIcons = dragIcons;
        log.debug("CatalogPanel.init _treeDnd= {}, _dragIcons= {}", (Object)this._treeDnd, (Object)this._dragIcons);
        DefaultTreeCellRenderer renderer = new DefaultTreeCellRenderer();
        renderer.setLeafIcon(renderer.getClosedIcon());
        this._dTree.setCellRenderer(renderer);
        this._dTree.setRootVisible(false);
        this._dTree.setShowsRootHandles(true);
        this._dTree.setScrollsOnExpand(true);
        this._dTree.getSelectionModel().setSelectionMode(1);
        this._dTree.addTreeSelectionListener(e -> this.updatePanel());
        this._dTree.setExpandsSelectedPaths(true);
        this._treePane.setViewportView(this._dTree);
    }

    public void setParent(IconItemPanel p) {
        this._parent = p;
    }

    public void updatePanel() {
        log.debug("updatePanel: _dTree.isSelectionEmpty()= {} _dTree.getSelectionPath() is {}null", (Object)this._dTree.isSelectionEmpty(), (Object)(this._dTree.getSelectionPath() == null ? "" : "not "));
        if (!this._dTree.isSelectionEmpty() && this._dTree.getSelectionPath() != null) {
            try {
                this._previewLabel.setText(this.setIcons());
            }
            catch (OutOfMemoryError oome) {
                this.resetPanel();
                log.debug("setIcons threw OutOfMemoryError", (Throwable)oome);
            }
        } else {
            this._previewLabel.setText(" ");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createNewBranch(String systemName, String userName, String path) {
        Object object = _lock;
        synchronized (object) {
            CatalogTreeManager manager = InstanceManager.getDefault(CatalogTreeManager.class);
            CatalogTree tree = manager.getBySystemName(systemName);
            if (tree != null) {
                ThreadingUtil.runOnGUI(() -> this.addTree(tree));
            } else {
                CatalogTree t = manager.newCatalogTree(systemName, userName);
                t.insertNodes(path);
                ThreadingUtil.runOnGUI(() -> this.addTree(t));
            }
        }
    }

    protected JTree getTree() {
        return this._dTree;
    }

    public void addTree(CatalogTree tree) {
        String name = tree.getSystemName();
        for (CatalogTree t : this._branchModel) {
            if (!name.equals(t.getSystemName())) continue;
            return;
        }
        this.addTreeBranch(tree.getRoot());
        this._branchModel.add(tree);
        this._model.reload();
    }

    private void addTreeBranch(CatalogTreeNode node) {
        if (log.isDebugEnabled()) {
            log.debug("addTreeBranch called for node= {}, has {} children.", (Object)node, (Object)node.getChildCount());
        }
        CatalogTreeNode root = (CatalogTreeNode)this._model.getRoot();
        Enumeration<TreeNode> e = node.children();
        while (e.hasMoreElements()) {
            CatalogTreeNode n = (CatalogTreeNode)e.nextElement();
            this.addNode(root, n);
        }
    }

    private void addNode(CatalogTreeNode parent, CatalogTreeNode n) {
        CatalogTreeNode node = new CatalogTreeNode((String)n.getUserObject());
        node.setLeaves(n.getLeaves());
        parent.add(node);
        Enumeration<TreeNode> e = n.children();
        while (e.hasMoreElements()) {
            CatalogTreeNode nChild = (CatalogTreeNode)e.nextElement();
            this.addNode(node, nChild);
        }
    }

    private CatalogTreeNode getCorrespondingNode(CatalogTreeNode node) {
        CatalogTree t;
        CatalogTreeNode cRoot;
        TreeNode[] nodes = node.getPath();
        CatalogTreeNode cNode = null;
        Iterator<CatalogTree> iterator = this._branchModel.iterator();
        while (iterator.hasNext() && (cNode = this.match(cRoot = (t = iterator.next()).getRoot(), nodes, 1)) == null) {
        }
        return cNode;
    }

    private CatalogTreeNode match(CatalogTreeNode cRoot, TreeNode[] nodes, int idx) {
        if (idx == nodes.length) {
            return cRoot;
        }
        Enumeration<TreeNode> e = cRoot.children();
        CatalogTreeNode result = null;
        while (e.hasMoreElements()) {
            CatalogTreeNode cNode = (CatalogTreeNode)e.nextElement();
            if (!nodes[idx].toString().equals(cNode.toString())) continue;
            result = this.match(cNode, nodes, idx + 1);
            break;
        }
        return result;
    }

    private CatalogTree getCorespondingModel(CatalogTreeNode node) {
        CatalogTree t;
        CatalogTreeNode cRoot;
        TreeNode[] nodes = node.getPath();
        CatalogTree model = null;
        Iterator<CatalogTree> iterator = this._branchModel.iterator();
        while (iterator.hasNext() && this.match(cRoot = (model = (t = iterator.next())).getRoot(), nodes, 1) == null) {
        }
        return model;
    }

    protected boolean insertNodeIntoModel(String name, CatalogTreeNode parent) {
        CatalogTreeNode n;
        if (!this.nameOK(parent, name)) {
            return false;
        }
        int index = 0;
        Enumeration<TreeNode> e = parent.children();
        while (e.hasMoreElements() && name.compareTo((n = (CatalogTreeNode)e.nextElement()).toString()) >= 0) {
            ++index;
        }
        CatalogTreeNode newChild = new CatalogTreeNode(name);
        this._model.insertNodeInto(newChild, parent, index);
        CatalogTreeNode cParent = this.getCorrespondingNode(parent);
        CatalogTreeNode node = new CatalogTreeNode(name);
        AbstractCatalogTree tree = (AbstractCatalogTree)this.getCorespondingModel(parent);
        if (tree != null) {
            tree.insertNodeInto(node, cParent, index);
            InstanceManager.getDefault(CatalogTreeManager.class).indexChanged(true);
        }
        return true;
    }

    protected void removeNodeFromModel(CatalogTreeNode node) {
        AbstractCatalogTree tree = (AbstractCatalogTree)this.getCorespondingModel(node);
        if (tree != null) {
            tree.removeNodeFromParent(this.getCorrespondingNode(node));
            this._model.removeNodeFromParent(node);
            InstanceManager.getDefault(CatalogTreeManager.class).indexChanged(true);
        }
    }

    protected boolean renameNode(CatalogTreeNode node, String name) {
        if (!this.nameOK((CatalogTreeNode)node.getParent(), name)) {
            return false;
        }
        CatalogTreeNode cNode = this.getCorrespondingNode(node);
        AbstractCatalogTree tree = (AbstractCatalogTree)this.getCorespondingModel(node);
        if (cNode != null && tree != null) {
            cNode.setLeaves(node.getLeaves());
            cNode.setUserObject(name);
            tree.nodeChanged(cNode);
            node.setUserObject(name);
            this._model.nodeChanged(node);
            InstanceManager.getDefault(CatalogTreeManager.class).indexChanged(true);
            this.updatePanel();
            return true;
        }
        return false;
    }

    private void addLeaf(CatalogTreeNode node, NamedIcon icon) {
        node.addLeaf(icon.getName(), icon.getURL());
        CatalogTreeNode cNode = this.getCorrespondingNode(node);
        AbstractCatalogTree tree = (AbstractCatalogTree)this.getCorespondingModel(node);
        if (cNode != null && tree != null) {
            cNode.setLeaves(node.getLeaves());
            cNode.setUserObject(node.toString());
            tree.nodeChanged(cNode);
            this._model.nodeChanged(node);
            InstanceManager.getDefault(CatalogTreeManager.class).indexChanged(true);
        }
        if (node.equals(this.getSelectedNode())) {
            this.updatePanel();
        }
    }

    private boolean nameOK(CatalogTreeNode node, String name) {
        TreeNode[] nodes;
        for (TreeNode node1 : nodes = node.getPath()) {
            if (!name.equals(node1.toString())) continue;
            return false;
        }
        return true;
    }

    private JPanel makeTreePanel(String label) {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        this._treePane = new JScrollPane(this._dTree);
        panel.add(new JLabel(Bundle.getMessage(label)));
        this._treePane.setMinimumSize(new Dimension(30, 100));
        panel.add(this._treePane);
        return panel;
    }

    private JPanel makePreviewPanel() {
        JPanel previewPanel = new JPanel();
        previewPanel.setLayout(new BoxLayout(previewPanel, 1));
        previewPanel.add(this._previewLabel);
        this._preview = new ImagePanel();
        this._preview.setOpaque(false);
        this._iconPane = new JScrollPane(this._preview);
        previewPanel.add(this._iconPane);
        this._iconPane.setMinimumSize(new Dimension(30, 100));
        this._iconPane.setPreferredSize(new Dimension(200, 200));
        return previewPanel;
    }

    private JPanel makeButtonPanel() {
        if (this._backgrounds == null) {
            this._backgrounds = new BufferedImage[4];
            for (int i = 0; i <= 2; ++i) {
                this._backgrounds[i] = DrawSquares.getImage(300, 400, 10, this.colorChoice[i], this.colorChoice[i]);
            }
            this._backgrounds[3] = DrawSquares.getImage(300, 400, 10, Color.white, _grayColor);
        }
        JComboBox<String> bgColorBox = new JComboBox<String>();
        bgColorBox.addItem(Bundle.getMessage("White"));
        bgColorBox.addItem(Bundle.getMessage("LightGray"));
        bgColorBox.addItem(Bundle.getMessage("DarkGray"));
        bgColorBox.addItem(Bundle.getMessage("Checkers"));
        bgColorBox.setSelectedIndex(0);
        bgColorBox.addActionListener(e -> {
            this._preview.setImage(this._backgrounds[bgColorBox.getSelectedIndex()]);
            log.debug("Catalog setImage called");
            this._preview.setOpaque(false);
            this._preview.invalidate();
        });
        JPanel backgroundPanel = new JPanel();
        backgroundPanel.setLayout(new BoxLayout(backgroundPanel, 1));
        JPanel pp = new JPanel();
        pp.setLayout(new FlowLayout(1));
        pp.add(new JLabel(Bundle.getMessage("setBackground")));
        pp.add(bgColorBox);
        backgroundPanel.add(pp);
        backgroundPanel.setMaximumSize(backgroundPanel.getPreferredSize());
        return backgroundPanel;
    }

    public ImagePanel getPreviewPanel() {
        return this._preview;
    }

    protected void resetPanel() {
        this._selectedImage = null;
        if (this._preview == null) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("_preview.removeAll done.");
        }
        this._preview.removeAll();
        this._preview.repaint();
    }

    public NamedIcon getIcon() {
        if (this._selectedImage != null) {
            return this._selectedImage.getIcon();
        }
        return null;
    }

    public void deselectIcon() {
        if (this._selectedImage != null) {
            this._selectedImage.setBorder(null);
            this._selectedImage = null;
        }
    }

    protected void setSelection(IconDisplayPanel panel) {
        if (this._parent == null) {
            return;
        }
        if (this._selectedImage != null && !panel.equals(this._selectedImage)) {
            this.deselectIcon();
        }
        if (panel != null) {
            panel.setBorder(BorderFactory.createLineBorder(Color.red, 2));
            this._selectedImage = panel;
        } else {
            this.deselectIcon();
        }
        this._parent.deselectIcon();
    }

    private String setIcons() {
        Thread.UncaughtExceptionHandler exceptionHandler = Thread.getDefaultUncaughtExceptionHandler();
        this.resetPanel();
        CatalogTreeNode node = this.getSelectedNode();
        if (node == null) {
            return null;
        }
        ArrayList<CatalogTreeLeaf> leaves = node.getLeaves();
        if (leaves == null) {
            return null;
        }
        int numCol = 1;
        while (numCol * numCol < leaves.size()) {
            ++numCol;
        }
        if (numCol > 1) {
            --numCol;
        }
        int numRow = leaves.size() / numCol;
        boolean newCol = false;
        this._noMemory = false;
        Thread.setDefaultUncaughtExceptionHandler(new MemoryExceptionHandler());
        GridBagLayout gridbag = new GridBagLayout();
        this._preview.setLayout(gridbag);
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 0;
        c.anchor = 10;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridy = 0;
        c.gridx = -1;
        for (int i = 0; i < leaves.size(); ++i) {
            if (this._noMemory) continue;
            CatalogTreeLeaf leaf = (CatalogTreeLeaf)leaves.get(i);
            NamedIcon icon = new NamedIcon(leaf.getPath(), leaf.getName());
            if (this._noMemory) continue;
            if (c.gridx < numCol) {
                ++c.gridx;
            } else if (c.gridy < numRow) {
                ++c.gridy;
                if (!newCol) {
                    c.gridx = 0;
                }
            } else if (!newCol) {
                ++c.gridx;
                c.gridy = 0;
                newCol = true;
            } else {
                ++c.gridy;
                c.gridx = 0;
                newCol = false;
            }
            c.insets = new Insets(5, 5, 0, 0);
            IconDisplayPanel p = new IconDisplayPanel(leaf.getName(), icon);
            gridbag.setConstraints(p, c);
            this._preview.add(p);
            log.debug("{} inserted at ({}, {})", new Object[]{leaf.getName(), c.gridx, c.gridy});
        }
        this._preview.invalidate();
        Thread.setDefaultUncaughtExceptionHandler(exceptionHandler);
        return Bundle.getMessage("numImagesInNode", node.getUserObject(), leaves.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CatalogPanel makeDefaultCatalog() {
        log.trace("call to makeDefaultCatalog()", (Throwable)new Exception("traceback"));
        log.debug("CatalogPanel catalog requested");
        Object object = _lock;
        synchronized (object) {
            return CatalogPanel.makeDefaultCatalog(true, false, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CatalogPanel makeDefaultCatalog(boolean addButtonPanel, boolean treeDrop, boolean dragIcon) {
        log.trace("call to makeDefaultCatalog({},{},{})", new Object[]{addButtonPanel, treeDrop, dragIcon, new Exception("traceback")});
        Object object = _lock;
        synchronized (object) {
            CatalogPanel catalog = new CatalogPanel("catalogs", "selectNode", addButtonPanel);
            catalog.init(treeDrop, dragIcon);
            CatalogTreeManager manager = InstanceManager.getDefault(CatalogTreeManager.class);
            manager.loadImageIndex();
            for (CatalogTree tree : manager.getNamedBeanSet()) {
                if (tree.getSystemName().charAt(0) != 'I') continue;
                catalog.addTree(tree);
            }
            catalog.createNewBranch("IFJAR", "Program Directory", "resources");
            FileUtil.createDirectory(FileUtil.getUserResourcePath());
            catalog.createNewBranch("IFPREF", "Preferences Directory", FileUtil.getUserResourcePath());
            return catalog;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CatalogPanel makeCatalog(String label1, String label2, boolean addButtonPanel, boolean treeDnD, boolean dragIcons) {
        log.trace("call to makeCatalog", (Throwable)new Exception("traceback"));
        Object object = _lock;
        synchronized (object) {
            CatalogPanel cp = new CatalogPanel(label1, label2, addButtonPanel);
            cp.init(treeDnD, dragIcons);
            return cp;
        }
    }

    public static Frame getParentFrame(Component comp) {
        while (!(comp instanceof Frame)) {
            if (comp == null) {
                return null;
            }
            comp = comp.getParent();
        }
        return (Frame)comp;
    }

    public static void packParentFrame(Component comp) {
        Frame frame = CatalogPanel.getParentFrame(comp);
        if (frame != null) {
            frame.pack();
        }
    }

    public static String printDbl(double z, int decimalPlaces) {
        if (Double.isNaN(z) || decimalPlaces > 8) {
            return Double.toString(z);
        }
        if (decimalPlaces <= 0) {
            return Integer.toString((int)Math.rint(z));
        }
        StringBuilder sb = new StringBuilder();
        if (z < 0.0) {
            sb.append('-');
        }
        z = Math.abs(z);
        int num = 1;
        int d = decimalPlaces;
        while (d-- > 0) {
            num *= 10;
        }
        int x = (int)Math.rint(z * (double)num);
        int ix = x / num;
        int dx = x - ix * num;
        sb.append(ix);
        if (dx == 0) {
            return sb.toString();
        }
        sb.append('.');
        num /= 10;
        while (num > dx) {
            sb.append('0');
            num /= 10;
        }
        sb.append(dx);
        return sb.toString();
    }

    protected void setSelectedNode(CatalogTreeNode node) {
        this._dTree.setExpandsSelectedPaths(true);
        if (log.isDebugEnabled()) {
            log.debug("setSelectedNode node: {}", (Object)node);
        }
        if (node != null) {
            this._dTree.setSelectionPath(new TreePath(node.getPath()));
        } else {
            this._dTree.setSelectionRow(0);
        }
    }

    protected void scrollPathToVisible(String[] names) {
        this._dTree.setExpandsSelectedPaths(true);
        Object[] path = new CatalogTreeNode[names.length];
        for (int i = 0; i < names.length; ++i) {
            path[i] = new CatalogTreeNode(names[i]);
        }
        this._dTree.scrollPathToVisible(new TreePath(path));
    }

    protected CatalogTreeNode getSelectedNode() {
        if (!this._dTree.isSelectionEmpty() && this._dTree.getSelectionPath() != null) {
            TreePath path = this._dTree.getSelectionPath();
            if (log.isDebugEnabled()) {
                log.debug("getSelectedNode TreePath: {}, lastComponent= {}", (Object)path, path.getLastPathComponent());
            }
            return (CatalogTreeNode)path.getLastPathComponent();
        }
        return null;
    }

    private void delete(NamedIcon icon) {
        CatalogTreeNode node = this.getSelectedNode();
        if (node == null) {
            return;
        }
        log.debug("delete icon {} from node {}", (Object)icon.getName(), (Object)node);
        node.deleteLeaf(icon.getName(), icon.getURL());
        this._model.nodeChanged(node);
        this.updatePanel();
        InstanceManager.getDefault(CatalogTreeManager.class).indexChanged(true);
    }

    private void rename(NamedIcon icon) {
        CatalogTreeNode node = this.getSelectedNode();
        if (node == null) {
            return;
        }
        String name = JmriJOptionPane.showInputDialog((Component)CatalogPanel.getParentFrame(this), Bundle.getMessage("newIconName"), icon.getName());
        if (name != null && name.length() > 0) {
            log.debug("rename icon {} to {} from node {}", new Object[]{icon.getName(), name, node});
            CatalogTreeLeaf leaf = node.getLeaf(icon.getName(), icon.getURL());
            if (leaf != null) {
                leaf.setName(name);
            }
            TreePath path = this._dTree.getSelectionPath();
            this._dTree.setSelectionPath(null);
            this._dTree.setSelectionPath(path);
            InstanceManager.getDefault(CatalogTreeManager.class).indexChanged(true);
        }
    }

    private void showPopUp(JmriMouseEvent evt, NamedIcon icon) {
        if (log.isDebugEnabled()) {
            log.debug("showPopUp {}", (Object)icon);
        }
        JPopupMenu popup = new JPopupMenu();
        popup.add(new JMenuItem(icon.getName()));
        popup.add(new JMenuItem(icon.getURL()));
        popup.add(new JPopupMenu.Separator());
        popup.add(new AbstractAction(Bundle.getMessage("RenameIcon")){
            NamedIcon icon;

            @Override
            public void actionPerformed(ActionEvent e) {
                CatalogPanel.this.rename(this.icon);
            }

            AbstractAction init(NamedIcon i) {
                this.icon = i;
                return this;
            }
        }.init(icon));
        popup.add(new JPopupMenu.Separator());
        popup.add(new AbstractAction(Bundle.getMessage("DeleteIcon")){
            NamedIcon icon;

            @Override
            public void actionPerformed(ActionEvent e) {
                CatalogPanel.this.delete(this.icon);
            }

            AbstractAction init(NamedIcon i) {
                this.icon = i;
                return this;
            }
        }.init(icon));
        popup.show(evt.getComponent(), evt.getX(), evt.getY());
    }

    public class IconDisplayPanel
    extends JPanel
    implements JmriMouseListener {
        String _name;
        NamedIcon _icon;

        public IconDisplayPanel(String leafName, NamedIcon icon) {
            this._name = leafName;
            this._icon = icon;
            this.setLayout(new BorderLayout());
            this.setOpaque(false);
            if (this._name != null) {
                this.setBorderAndIcon(icon);
            }
            this.addMouseListener(JmriMouseListener.adapt(new IconListener()));
        }

        NamedIcon getIcon() {
            return this._icon;
        }

        void setBorderAndIcon(NamedIcon icon) {
            if (icon == null) {
                log.error("IconDisplayPanel: No icon for \"{}\"", (Object)this._name);
                return;
            }
            try {
                double scale;
                JLabel image = CatalogPanel.this._dragIcons ? new DragJLabel(new DataFlavor("application/x-java-jvm-local-objectref;class=jmri.jmrit.catalog.NamedIcon")) : new JLabel();
                image.setOpaque(false);
                image.setName(this._name);
                image.setToolTipText(icon.getName());
                if (icon.getIconWidth() < 1 || icon.getIconHeight() < 1) {
                    image.setText(Bundle.getMessage("invisibleIcon"));
                    image.setForeground(Color.lightGray);
                    scale = 0.0;
                } else {
                    scale = icon.reduceTo(100, 100, 0.02);
                }
                image.setIcon(icon);
                image.setHorizontalAlignment(0);
                image.addMouseListener(JmriMouseListener.adapt(new IconListener()));
                this.add((Component)image, "North");
                String scaleMessage = Bundle.getMessage("scale", CatalogPanel.printDbl(scale, 2));
                JLabel label = new JLabel(scaleMessage);
                label.setOpaque(false);
                label.setHorizontalAlignment(0);
                this.add((Component)label, "Center");
                label = new JLabel(this._name);
                label.setOpaque(false);
                label.setHorizontalAlignment(0);
                this.add((Component)label, "South");
                this.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
            }
            catch (ClassNotFoundException cnfe) {
                log.error("Unable to find class supporting {}", (Object)"application/x-java-jvm-local-objectref;class=jmri.jmrit.display.Positionable", (Object)cnfe);
            }
        }

        public String getIconName() {
            return this._name;
        }

        @Override
        public void mouseClicked(JmriMouseEvent event) {
            if (event.getSource() instanceof JLabel) {
                CatalogPanel.this.setSelection(this);
            }
        }

        @Override
        public void mousePressed(JmriMouseEvent event) {
        }

        @Override
        public void mouseReleased(JmriMouseEvent event) {
        }

        @Override
        public void mouseEntered(JmriMouseEvent event) {
        }

        @Override
        public void mouseExited(JmriMouseEvent event) {
        }
    }

    class DropJTree
    extends JTree
    implements DropTargetListener {
        DataFlavor dataFlavor;

        DropJTree(TreeModel model) {
            super(model);
            try {
                this.dataFlavor = new DataFlavor("application/x-java-jvm-local-objectref;class=jmri.jmrit.catalog.NamedIcon");
            }
            catch (ClassNotFoundException cnfe) {
                log.warn("DropJTree Unable to create data flavor", (Throwable)cnfe);
            }
            new DropTarget(this, 3, this);
            log.debug("DropJTree ctor");
        }

        @Override
        public void dragExit(DropTargetEvent dte) {
            log.debug("DropJTree.dragExit");
        }

        @Override
        public void dragEnter(DropTargetDragEvent dtde) {
            log.debug("DropJTree.dragEnter");
        }

        @Override
        public void dragOver(DropTargetDragEvent dtde) {
            log.debug("DropJTree.dragOver");
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent dtde) {
            log.debug("DropJTree.dropActionChanged");
        }

        @Override
        public void drop(DropTargetDropEvent e) {
            try {
                Transferable tr = e.getTransferable();
                if (e.isDataFlavorSupported(this.dataFlavor)) {
                    NamedIcon icon = (NamedIcon)tr.getTransferData(this.dataFlavor);
                    Point pt = e.getLocation();
                    TreePath path = CatalogPanel.this._dTree.getPathForLocation(pt.x, pt.y);
                    if (path != null) {
                        CatalogTreeNode node = (CatalogTreeNode)path.getLastPathComponent();
                        e.acceptDrop(3);
                        CatalogPanel.this.addLeaf(node, icon);
                        e.dropComplete(true);
                        if (log.isDebugEnabled()) {
                            log.debug("DropJTree.drop COMPLETED for {} into {}", (Object)icon.getURL(), (Object)node);
                        }
                        return;
                    }
                }
            }
            catch (UnsupportedFlavorException | IOException ex) {
                log.warn("DropJTree unable to drag and drop", (Throwable)ex);
            }
            log.debug("DropJTree.drop REJECTED!");
            e.rejectDrop();
        }
    }

    class DropOnPanelToNode
    extends TransferHandler {
        DataFlavor dataFlavor;

        DropOnPanelToNode() {
            try {
                this.dataFlavor = new DataFlavor("application/x-java-jvm-local-objectref;class=jmri.jmrit.catalog.NamedIcon");
            }
            catch (ClassNotFoundException cnfe) {
                log.warn("DropOnPanelToNode Unable to create data flavor", (Throwable)cnfe);
            }
        }

        @Override
        public boolean canImport(TransferHandler.TransferSupport support) {
            if (!support.isDataFlavorSupported(this.dataFlavor)) {
                return false;
            }
            support.setDropAction(1);
            return true;
        }

        @Override
        public boolean importData(TransferHandler.TransferSupport support) {
            if (!this.canImport(support)) {
                return false;
            }
            CatalogTreeNode node = CatalogPanel.this.getSelectedNode();
            if (node == null) {
                return false;
            }
            try {
                Transferable t = support.getTransferable();
                NamedIcon icon = (NamedIcon)t.getTransferData(this.dataFlavor);
                CatalogPanel.this.addLeaf(node, icon);
                if (log.isDebugEnabled()) {
                    log.debug("DropOnPanelToNode.drop COMPLETED for {} into {}", (Object)icon.getURL(), (Object)node);
                }
                return true;
            }
            catch (UnsupportedFlavorException | IOException ex) {
                log.warn("DropOnPanelToNode unable to drag and drop", (Throwable)ex);
                return false;
            }
        }
    }

    class IconListener
    implements JmriMouseListener {
        IconListener() {
        }

        @Override
        public void mouseClicked(JmriMouseEvent event) {
            if (event.getSource() instanceof IconDisplayPanel) {
                IconDisplayPanel panel = (IconDisplayPanel)event.getSource();
                CatalogPanel.this.setSelection(panel);
            } else if (event.getSource() instanceof ImagePanel) {
                CatalogPanel.this.deselectIcon();
            }
        }

        @Override
        public void mousePressed(JmriMouseEvent event) {
        }

        @Override
        public void mouseReleased(JmriMouseEvent e) {
            if (log.isDebugEnabled()) {
                log.debug("IconListener mouseReleased, _treeDnd= {}, popup= {}, source= {}", new Object[]{CatalogPanel.this._treeDnd, e.isPopupTrigger(), e.getSource().getClass().getName()});
            }
            if (CatalogPanel.this._treeDnd && e.isPopupTrigger()) {
                JLabel label;
                NamedIcon icon;
                if (e.getSource() instanceof IconDisplayPanel) {
                    IconDisplayPanel panel = (IconDisplayPanel)e.getSource();
                    CatalogPanel.this.setSelection(panel);
                    NamedIcon icon2 = panel.getIcon();
                    CatalogPanel.this.showPopUp(e, icon2);
                } else if (e.getSource() instanceof JLabel && (icon = (NamedIcon)(label = (JLabel)e.getSource()).getIcon()) != null) {
                    CatalogPanel.this.showPopUp(e, icon);
                }
            }
        }

        @Override
        public void mouseEntered(JmriMouseEvent event) {
        }

        @Override
        public void mouseExited(JmriMouseEvent event) {
        }
    }

    public class MemoryExceptionHandler
    implements Thread.UncaughtExceptionHandler {
        @Override
        public void uncaughtException(Thread t, Throwable e) {
            CatalogPanel.this._noMemory = true;
            log.error("MemoryExceptionHandler", e);
        }
    }
}

