/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.catalog;

import java.io.IOException;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jmri.CatalogTree;
import jmri.CatalogTreeManager;
import jmri.CatalogTreeNode;
import jmri.InstanceManager;
import jmri.ShutDownManager;
import jmri.ShutDownTask;
import jmri.implementation.AbstractInstanceInitializer;
import jmri.implementation.swing.SwingShutDownTask;
import jmri.jmrit.catalog.Bundle;
import jmri.jmrit.catalog.CatalogTreeFS;
import jmri.jmrit.catalog.CatalogTreeIndex;
import jmri.jmrit.catalog.configurexml.DefaultCatalogTreeManagerXml;
import jmri.jmrit.display.palette.ItemPalette;
import jmri.jmrix.internal.InternalSystemConnectionMemo;
import jmri.managers.AbstractManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultCatalogTreeManager
extends AbstractManager<CatalogTree>
implements CatalogTreeManager {
    private boolean _indexChanged = false;
    private boolean _indexLoaded = false;
    private ShutDownTask _shutDownTask;
    private static final Logger log = LoggerFactory.getLogger(DefaultCatalogTreeManager.class);

    public DefaultCatalogTreeManager() {
        super(InstanceManager.getDefault(InternalSystemConnectionMemo.class));
    }

    @Override
    protected void registerSelf() {
        log.debug("not registering");
    }

    @Override
    public int getXMLOrder() {
        return 65400;
    }

    @Override
    public char typeLetter() {
        return '0';
    }

    @Override
    @CheckForNull
    public CatalogTree getCatalogTree(@Nonnull String name) {
        CatalogTree t = this.getByUserName(name);
        return t != null ? t : this.getBySystemName(name);
    }

    @Override
    @CheckForNull
    public CatalogTree getBySystemName(@Nonnull String key) {
        if (log.isDebugEnabled()) {
            log.debug("getBySystemName: systemName= {}", (Object)key);
            CatalogTree tree = (CatalogTree)this._tsys.get(key);
            if (tree != null) {
                CatalogTreeNode root = tree.getRoot();
                log.debug("root= {}, has {} children", (Object)root, (Object)root.getChildCount());
            }
        }
        return (CatalogTree)this._tsys.get(key);
    }

    @Override
    @CheckForNull
    public CatalogTree getByUserName(@Nonnull String key) {
        return (CatalogTree)this._tuser.get(key);
    }

    @Override
    @Nonnull
    public CatalogTree newCatalogTree(@Nonnull String systemName, String userName) throws IllegalArgumentException {
        CatalogTree t;
        log.debug("new CatalogTree: systemName= {}, userName= {}", (Object)systemName, (Object)userName);
        if (systemName.isEmpty()) {
            throw new IllegalArgumentException("Empty systemName!");
        }
        if (userName != null && (t = this.getByUserName(userName)) != null) {
            if (this.getBySystemName(systemName) != t) {
                log.error("inconsistent user ({}) and system name ({}) results; userName related to ({})", new Object[]{userName, systemName, t.getSystemName()});
            }
            return t;
        }
        t = this.getBySystemName(systemName);
        if (t != null) {
            if (t.getUserName() == null && userName != null) {
                t.setUserName(userName);
            } else if (userName != null) {
                log.warn("Found memory via system name ({}) with non-null userName ({})", (Object)systemName, (Object)userName);
            }
            return t;
        }
        t = this.createNewCatalogTree(systemName, userName);
        this.register(t);
        return t;
    }

    @Nonnull
    protected CatalogTree createNewCatalogTree(@Nonnull String systemName, String userName) throws IllegalArgumentException {
        if (systemName.isEmpty()) {
            throw new IllegalArgumentException("Empty systemName!");
        }
        if (userName == null || userName.isEmpty()) {
            throw new IllegalArgumentException("Null or empty userName!");
        }
        if (systemName.charAt(1) == 'X') {
            switch (systemName.charAt(0)) {
                case 'I': 
                case 'N': 
                case 'S': 
                case 'T': {
                    return new CatalogTreeIndex(systemName, userName);
                }
            }
            log.error("Bad systemName: {} (userName= {})", (Object)systemName, (Object)userName);
        } else if (systemName.charAt(1) == 'F') {
            switch (systemName.charAt(0)) {
                case 'I': {
                    CatalogTreeFS catTree = new CatalogTreeFS(systemName, userName);
                    catTree.setFilter(IMAGE_FILTER);
                    return catTree;
                }
                case 'S': {
                    CatalogTreeFS catTree = new CatalogTreeFS(systemName, userName);
                    catTree.setFilter(SOUND_FILTER);
                    return catTree;
                }
                case 'T': {
                    CatalogTreeFS catTree = new CatalogTreeFS(systemName, userName);
                    catTree.setFilter(SCRIPT_FILTER);
                    return catTree;
                }
                case 'N': {
                    return new CatalogTreeFS(systemName, userName);
                }
            }
            log.error("Bad systemName: {} (userName= {})", (Object)systemName, (Object)userName);
        }
        throw new IllegalArgumentException("systemName.charAt not XML or FILESYS !");
    }

    @Override
    @Nonnull
    public String getBeanTypeHandled(boolean plural) {
        return Bundle.getMessage(plural ? "BeanNameCatalogs" : "BeanNameCatalog");
    }

    @Override
    public Class<CatalogTree> getNamedBeanClass() {
        return CatalogTree.class;
    }

    @Override
    public void storeImageIndex() {
        ItemPalette.storeIcons();
        log.debug("Start writing CatalogTree info");
        try {
            new DefaultCatalogTreeManagerXml().writeCatalogTrees();
            this.indexChanged(false);
        }
        catch (IOException ioe) {
            log.error("Exception writing CatalogTrees: ", (Throwable)ioe);
        }
    }

    @Override
    public void loadImageIndex() {
        if (!this.isIndexLoaded()) {
            new DefaultCatalogTreeManagerXml().readCatalogTrees();
            this._indexLoaded = true;
            log.debug("loadImageIndex: catalog file loaded");
        }
    }

    @Override
    public boolean isIndexChanged() {
        return this._indexChanged;
    }

    @Override
    public boolean isIndexLoaded() {
        return this._indexLoaded;
    }

    @Override
    public final synchronized void indexChanged(boolean changed) {
        this._indexChanged = changed;
        ShutDownManager sdm = InstanceManager.getDefault(ShutDownManager.class);
        if (changed) {
            if (this._shutDownTask == null) {
                this._shutDownTask = new SwingShutDownTask("PanelPro Save default icon check", Bundle.getMessage("IndexChanged"), Bundle.getMessage("SaveAndQuit"), null){

                    @Override
                    public boolean checkPromptNeeded() {
                        return !DefaultCatalogTreeManager.this._indexChanged;
                    }

                    @Override
                    public void didPrompt() {
                        DefaultCatalogTreeManager.this.storeImageIndex();
                    }
                };
                sdm.register(this._shutDownTask);
            }
        } else if (this._shutDownTask != null) {
            sdm.deregister(this._shutDownTask);
            this._shutDownTask = null;
        }
    }

    public static class Initializer
    extends AbstractInstanceInitializer {
        @Override
        @Nonnull
        public <T> Object getDefault(Class<T> type) {
            if (type.equals(CatalogTreeManager.class)) {
                return new DefaultCatalogTreeManager();
            }
            return super.getDefault(type);
        }

        @Override
        @Nonnull
        public Set<Class<?>> getInitalizes() {
            Set<Class<?>> set = super.getInitalizes();
            set.add(CatalogTreeManager.class);
            return set;
        }
    }
}

