/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.catalog;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.datatransfer.DataFlavor;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import jmri.InstanceManager;
import jmri.jmrit.catalog.Bundle;
import jmri.jmrit.catalog.CatalogPanel;
import jmri.jmrit.catalog.DirectorySearcher;
import jmri.jmrit.catalog.DragJLabel;
import jmri.jmrit.catalog.NamedIcon;
import jmri.util.swing.DrawSquares;
import jmri.util.swing.ImagePanel;
import jmri.util.swing.JmriJOptionPane;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PreviewDialog
extends JDialog {
    JPanel _selectedImage;
    static Color _grayColor = new Color(235, 235, 235);
    static Color _darkGrayColor = new Color(150, 150, 150);
    protected Color[] colorChoice = new Color[]{Color.white, _grayColor, _darkGrayColor};
    protected BufferedImage[] _backgrounds;
    JLabel _previewLabel = new JLabel();
    protected ImagePanel _preview;
    protected JScrollPane js;
    int _cnt;
    int _startNum;
    boolean needsMore = true;
    File _currentDir;
    String[] _filter;
    ActionListener _lookAction;
    boolean _noMemory = false;
    static int CHUNK = 500000;
    private static final Logger log = LoggerFactory.getLogger(PreviewDialog.class);

    protected PreviewDialog(Frame frame, String title, File dir, String[] filter) {
        super(frame, Bundle.getMessage(title), false);
        this._currentDir = dir;
        this._filter = new String[filter.length];
        for (int i = 0; i < filter.length; ++i) {
            this._filter[i] = filter[i];
        }
    }

    protected void init(ActionListener moreAction, ActionListener lookAction, ActionListener cancelAction, int startNum) {
        int choice;
        if (log.isDebugEnabled()) {
            log.debug("Enter _previewDialog.init dir= {}", (Object)this._currentDir.getPath());
        }
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                InstanceManager.getDefault(DirectorySearcher.class).close();
                PreviewDialog.this.dispose();
            }
        });
        JPanel pTop = new JPanel();
        pTop.setLayout(new BoxLayout(pTop, 1));
        pTop.add(new JLabel(this._currentDir.getPath()));
        JTextField msg = new JTextField();
        msg.setFont(new Font("Dialog", 1, 12));
        msg.setEditable(false);
        msg.setBackground(pTop.getBackground());
        pTop.add(msg);
        this.getContentPane().add((Component)pTop, "North");
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        p.add(Box.createHorizontalStrut(5));
        JPanel previewPanel = this.setupPanel();
        this._startNum = startNum;
        this.needsMore = this.setIcons(startNum);
        if (this._noMemory && (choice = JmriJOptionPane.showOptionDialog(this, Bundle.getMessage("OutOfMemory", this._cnt), Bundle.getMessage("ErrorTitle"), -1, 1, null, new String[]{Bundle.getMessage("ButtonStop"), Bundle.getMessage("ShowContents")}, 1)) != 1) {
            return;
        }
        if (this.needsMore) {
            if (moreAction != null) {
                p.add(Box.createHorizontalStrut(5));
                JButton moreButton = new JButton(Bundle.getMessage("ButtonDisplayMore"));
                moreButton.addActionListener(moreAction);
                moreButton.setVisible(this.needsMore);
                p.add(moreButton);
            } else {
                log.error("More ActionListener missing");
            }
            msg.setText(Bundle.getMessage("moreMsg", Bundle.getMessage("ButtonDisplayMore")));
        }
        boolean hasButtons = this.needsMore;
        msg.setText(Bundle.getMessage("dragMsg"));
        this._lookAction = lookAction;
        if (lookAction != null) {
            p.add(Box.createHorizontalStrut(5));
            JButton lookButton = new JButton(Bundle.getMessage("ButtonKeepLooking"));
            lookButton.addActionListener(lookAction);
            p.add(lookButton);
            hasButtons = true;
        }
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        if (hasButtons) {
            p.add(Box.createHorizontalStrut(5));
            JButton cancelButton = new JButton(Bundle.getMessage("ButtonCancel"));
            cancelButton.addActionListener(cancelAction);
            p.add(cancelButton);
            p.add(Box.createHorizontalStrut(5));
            p.setPreferredSize(new Dimension(400, cancelButton.getPreferredSize().height));
            panel.add(p);
            panel.add(new JSeparator());
        }
        panel.add(previewPanel);
        this.getContentPane().add(panel);
        this.setLocationRelativeTo(null);
        this.pack();
        this.setVisible(true);
    }

    ActionListener getLookActionListener() {
        return this._lookAction;
    }

    private JPanel setupPanel() {
        JPanel previewPanel = new JPanel();
        previewPanel.setLayout(new BoxLayout(previewPanel, 1));
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        p.add(this._previewLabel);
        previewPanel.add(p);
        this._preview = new ImagePanel();
        log.debug("Preview ImagePanel created");
        this._preview.setLayout(new BoxLayout(this._preview, 1));
        this._preview.setOpaque(false);
        this.js = new JScrollPane(this._preview);
        previewPanel.add(this.js);
        if (this._backgrounds == null) {
            this._backgrounds = new BufferedImage[4];
            for (int i = 0; i <= 2; ++i) {
                this._backgrounds[i] = DrawSquares.getImage(300, 400, 10, this.colorChoice[i], this.colorChoice[i]);
            }
            this._backgrounds[3] = DrawSquares.getImage(300, 400, 10, Color.white, _grayColor);
        }
        JComboBox<String> bgColorBox = new JComboBox<String>();
        bgColorBox.addItem(Bundle.getMessage("White"));
        bgColorBox.addItem(Bundle.getMessage("LightGray"));
        bgColorBox.addItem(Bundle.getMessage("DarkGray"));
        bgColorBox.addItem(Bundle.getMessage("Checkers"));
        bgColorBox.setSelectedIndex(0);
        bgColorBox.addActionListener(e -> {
            this._preview.setImage(this._backgrounds[bgColorBox.getSelectedIndex()]);
            log.debug("Preview setImage called");
            this._preview.setOpaque(false);
            this._preview.invalidate();
        });
        JPanel pp = new JPanel();
        pp.setLayout(new FlowLayout(1));
        pp.add(new JLabel(Bundle.getMessage("setBackground")));
        pp.add(bgColorBox);
        previewPanel.add(pp);
        return previewPanel;
    }

    void resetPanel() {
        this._selectedImage = null;
        if (this._preview == null) {
            return;
        }
        log.debug("resetPanel");
        this._preview.removeAll();
        this._preview.setImage(this._backgrounds[0]);
        this._preview.invalidate();
        this.pack();
    }

    protected int getNumFilesShown() {
        return this._startNum + this._cnt;
    }

    private boolean setIcons(int startNum) {
        Thread.UncaughtExceptionHandler exceptionHandler = Thread.getDefaultUncaughtExceptionHandler();
        this._noMemory = false;
        Thread.setDefaultUncaughtExceptionHandler(new MemoryExceptionHandler());
        log.debug("setIcons: startNum= {}", (Object)startNum);
        GridBagLayout gridbag = new GridBagLayout();
        this._preview.setLayout(gridbag);
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 0;
        c.anchor = 10;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridy = -1;
        c.gridx = 0;
        this._cnt = 0;
        int cnt = 0;
        File[] files = this._currentDir.listFiles();
        if (files != null) {
            ArrayList<File> aList = new ArrayList<File>(Arrays.asList(files));
            Collections.sort(aList);
            files = aList.toArray(files);
            int nCols = 1;
            int nRows = 1;
            int nAvail = 1;
            long memoryAvailable = this.availableMemory();
            long memoryUsed = 0L;
            block2: for (int i = 0; i < files.length; ++i) {
                String ext = FilenameUtils.getExtension((String)files[i].getName());
                for (int k = 0; k < this._filter.length; ++k) {
                    if (ext != null && ext.equalsIgnoreCase(this._filter[k])) {
                        JLabel image;
                        if (cnt < startNum) {
                            ++cnt;
                            continue;
                        }
                        String name = files[i].getName();
                        int index = name.indexOf(46);
                        if (index > 0) {
                            name = name.substring(0, index);
                        }
                        String path = files[i].getAbsolutePath();
                        NamedIcon icon = new NamedIcon(path, name);
                        long size = icon.getIconWidth() * icon.getIconHeight();
                        log.debug("Memory calculation icon size= {} memoryAvailable= {} memoryUsed= {}", new Object[]{size, memoryAvailable, memoryUsed});
                        if (memoryAvailable < 4L * size) {
                            this._noMemory = true;
                            log.debug("Memory calculation caught icon size= {} testSize= {} memoryAvailable= {}", new Object[]{size, 4L * size, memoryAvailable});
                            continue block2;
                        }
                        double scale = icon.reduceTo(100, 100, 0.02);
                        if (this._noMemory) {
                            log.debug("MemoryExceptionHandler caught icon size={} ", (Object)size);
                            continue block2;
                        }
                        size = scale < 1.0 ? (size *= 4L) : (size += 1000L);
                        memoryUsed += size;
                        memoryAvailable -= size;
                        ++this._cnt;
                        ++cnt;
                        if (this._cnt > nAvail) {
                            nAvail = ++nCols * ++nRows;
                            c.gridx = nCols - 1;
                            c.gridy = 0;
                        } else if (this._cnt > nAvail - nRows) {
                            if (c.gridx < nCols - 1) {
                                ++c.gridx;
                            } else {
                                c.gridx = 0;
                                ++c.gridy;
                            }
                        } else {
                            ++c.gridy;
                        }
                        c.insets = new Insets(5, 5, 0, 0);
                        try {
                            image = new DragJLabel(new DataFlavor("application/x-java-jvm-local-objectref;class=jmri.jmrit.catalog.NamedIcon"));
                        }
                        catch (ClassNotFoundException cnfe) {
                            log.error("Unable to find class supporting {}", (Object)"application/x-java-jvm-local-objectref;class=jmri.jmrit.catalog.NamedIcon", (Object)cnfe);
                            image = new JLabel(cnfe.getMessage());
                        }
                        image.setOpaque(false);
                        image.setName(name);
                        image.setIcon(icon);
                        JPanel p = new JPanel();
                        p.setOpaque(false);
                        p.setLayout(new BoxLayout(p, 1));
                        p.add(image);
                        if (name.length() > 18) {
                            name = name.substring(0, 18);
                        }
                        JLabel nameLabel = new JLabel(name);
                        nameLabel.setOpaque(false);
                        JLabel label = new JLabel(Bundle.getMessage("scale", CatalogPanel.printDbl(scale, 2)));
                        label.setOpaque(false);
                        p.add(label);
                        p.add(nameLabel);
                        gridbag.setConstraints(p, c);
                        log.debug("{} inserted at ({}, {})", new Object[]{name, c.gridx, c.gridy});
                        this._preview.add(p);
                    }
                    if (this._noMemory) continue block2;
                }
            }
            ++c.gridy;
            ++c.gridx;
        }
        JLabel bottom = new JLabel();
        gridbag.setConstraints(bottom, c);
        this._preview.add(bottom);
        String msg = Bundle.getMessage("numImagesInDir", this._currentDir.getName(), DirectorySearcher.numImageFiles(this._currentDir));
        if (startNum > 0) {
            msg = Bundle.getMessage("numImagesShown", msg, this._cnt, startNum);
        }
        this._previewLabel.setText(msg);
        CatalogPanel.packParentFrame(this);
        Thread.setDefaultUncaughtExceptionHandler(exceptionHandler);
        return this._noMemory;
    }

    private long availableMemory() {
        return Runtime.getRuntime().freeMemory() / 2L;
    }

    @Override
    public void dispose() {
        if (this._preview != null) {
            this.resetPanel();
        }
        this.removeAll();
        this._preview = null;
        super.dispose();
        log.debug("PreviewDialog disposed.");
    }

    class MemoryExceptionHandler
    implements Thread.UncaughtExceptionHandler {
        MemoryExceptionHandler() {
        }

        @Override
        public void uncaughtException(Thread t, Throwable e) {
            PreviewDialog.this._noMemory = true;
            log.error("MemoryExceptionHandler: {} {} files read from directory {}", new Object[]{e, PreviewDialog.this._cnt, PreviewDialog.this._currentDir});
            if (log.isDebugEnabled()) {
                log.debug("memoryAvailable = {}", (Object)PreviewDialog.this.availableMemory());
            }
        }
    }
}

