/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.conditional;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import jmri.Conditional;
import jmri.ConditionalAction;
import jmri.ConditionalVariable;
import jmri.InstanceManager;
import jmri.LightManager;
import jmri.LogixManager;
import jmri.MemoryManager;
import jmri.NamedBean;
import jmri.RouteManager;
import jmri.SensorManager;
import jmri.SignalHeadManager;
import jmri.SignalMastManager;
import jmri.TurnoutManager;
import jmri.jmrit.conditional.Bundle;
import jmri.jmrit.conditional.ConditionalEditBase;
import jmri.jmrit.conditional.ConditionalFrame;
import jmri.jmrit.conditional.ConditionalList;
import jmri.jmrit.entryexit.EntryExitPairs;
import jmri.jmrit.logix.OBlockManager;
import jmri.jmrit.logix.WarrantManager;
import jmri.util.swing.JmriJOptionPane;
import jmri.util.table.ButtonEditor;
import jmri.util.table.ButtonRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConditionalCopyFrame
extends ConditionalFrame {
    private Conditional.ItemType _saveType = Conditional.ItemType.NONE;
    private static final Logger log = LoggerFactory.getLogger(ConditionalCopyFrame.class);

    ConditionalCopyFrame(String title, @Nonnull Conditional conditional, ConditionalList parent) {
        super(title, conditional, parent);
        this.makeConditionalFrame(conditional);
    }

    private void makeConditionalFrame(@Nonnull Conditional conditional) {
        this.addHelpMenu("package.jmri.jmrit.conditional.ConditionalCopy", true);
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BoxLayout(contentPane, 1));
        contentPane.add(this.makeTopPanel(conditional));
        JPanel logicPanel = new JPanel();
        logicPanel.setLayout(new BoxLayout(logicPanel, 1));
        JTextField antecedentField = new JTextField(65);
        antecedentField.setText(ConditionalEditBase.translateAntecedent(this._antecedent, false));
        antecedentField.setFont(new Font("SansSerif", 1, 14));
        JPanel antecedentPanel = this.makeEditPanel(antecedentField, "LabelAntecedent", "LabelAntecedentHint");
        antecedentPanel.setVisible(this._logicType == Conditional.AntecedentOperator.MIXED);
        logicPanel.add(antecedentPanel);
        JPanel varTitle = new JPanel();
        varTitle.setLayout(new FlowLayout());
        varTitle.add(new JLabel(Bundle.getMessage("StateVariableTableTitle")));
        logicPanel.add(varTitle);
        VariableCopyTableModel variableTableModel = new VariableCopyTableModel(false, this._parent._selectionMode != ConditionalEditBase.SelectionMode.USESINGLE);
        JTable variableTable = new JTable(variableTableModel);
        variableTable.setRowSelectionAllowed(false);
        int rowHeight = variableTable.getRowHeight();
        TableColumnModel variableColumnModel = variableTable.getColumnModel();
        TableColumn rowColumn = variableColumnModel.getColumn(0);
        rowColumn.setResizable(false);
        rowColumn.setMaxWidth(new JTextField((int)3).getPreferredSize().width);
        TableColumn nameColumn = variableColumnModel.getColumn(1);
        nameColumn.setResizable(false);
        if (this._parent._selectionMode != ConditionalEditBase.SelectionMode.USESINGLE) {
            nameColumn.setCellEditor(new NameCellEditor(new JComboBox<String>()));
        } else {
            nameColumn.setCellEditor(new NameCellEditor(new JTextField()));
        }
        nameColumn.setMinWidth(40);
        nameColumn.setResizable(true);
        TableColumn descColumn = variableColumnModel.getColumn(2);
        descColumn.setMinWidth(300);
        descColumn.setResizable(true);
        JScrollPane variableTableScrollPane = new JScrollPane(variableTable);
        Dimension dim = variableTable.getPreferredSize();
        dim.height = 7 * rowHeight;
        variableTableScrollPane.getViewport().setPreferredSize(dim);
        logicPanel.add(variableTableScrollPane);
        Border logicPanelBorder = BorderFactory.createEtchedBorder();
        TitledBorder logicPanelTitled = BorderFactory.createTitledBorder(logicPanelBorder, Bundle.getMessage("TitleLogicalExpression") + " ");
        logicPanel.setBorder(logicPanelTitled);
        contentPane.add(logicPanel);
        JPanel conseqentPanel = new JPanel();
        conseqentPanel.setLayout(new BoxLayout(conseqentPanel, 1));
        JPanel actTitle = new JPanel();
        actTitle.setLayout(new FlowLayout());
        actTitle.add(new JLabel(Bundle.getMessage("ActionTableTitle")));
        conseqentPanel.add(actTitle);
        ActionCopyTableModel actionTableModel = new ActionCopyTableModel(true, this._parent._selectionMode != ConditionalEditBase.SelectionMode.USESINGLE);
        JTable actionTable = new JTable(actionTableModel);
        actionTable.setRowSelectionAllowed(false);
        ButtonRenderer buttonRenderer = new ButtonRenderer();
        actionTable.setDefaultRenderer(JButton.class, buttonRenderer);
        ButtonEditor buttonEditor = new ButtonEditor(new JButton());
        actionTable.setDefaultEditor(JButton.class, buttonEditor);
        JButton testButton = new JButton("XXXXXX");
        actionTable.setRowHeight(testButton.getPreferredSize().height);
        TableColumnModel actionColumnModel = actionTable.getColumnModel();
        nameColumn = actionColumnModel.getColumn(0);
        nameColumn.setResizable(false);
        if (this._parent._selectionMode != ConditionalEditBase.SelectionMode.USESINGLE) {
            nameColumn.setCellEditor(new NameCellEditor(new JComboBox<String>()));
        } else {
            nameColumn.setCellEditor(new NameCellEditor(new JTextField()));
        }
        nameColumn.setMinWidth(40);
        nameColumn.setResizable(true);
        descColumn = actionColumnModel.getColumn(1);
        descColumn.setMinWidth(300);
        descColumn.setResizable(true);
        TableColumn deleteColumn = actionColumnModel.getColumn(2);
        deleteColumn.setMinWidth(testButton.getPreferredSize().width);
        deleteColumn.setMaxWidth(testButton.getPreferredSize().width);
        deleteColumn.setResizable(false);
        JScrollPane actionTableScrollPane = new JScrollPane(actionTable);
        dim = actionTableScrollPane.getPreferredSize();
        dim.height = 7 * rowHeight;
        actionTableScrollPane.getViewport().setPreferredSize(dim);
        conseqentPanel.add(actionTableScrollPane);
        Border conseqentPanelBorder = BorderFactory.createEtchedBorder();
        TitledBorder conseqentPanelTitled = BorderFactory.createTitledBorder(conseqentPanelBorder, Bundle.getMessage("TitleAction"));
        conseqentPanel.setBorder(conseqentPanelTitled);
        contentPane.add(conseqentPanel);
        contentPane.add(this._parent.makeBottomPanel());
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ConditionalCopyFrame.this.cancelConditionalPressed();
            }
        });
        variableTableModel.fireTableDataChanged();
        actionTableModel.fireTableDataChanged();
    }

    SortedSet<?> getItemNamedBeamns(Conditional.ItemType itemType) {
        switch (itemType) {
            case SENSOR: {
                return InstanceManager.getDefault(SensorManager.class).getNamedBeanSet();
            }
            case TURNOUT: {
                return InstanceManager.getDefault(TurnoutManager.class).getNamedBeanSet();
            }
            case LIGHT: {
                return InstanceManager.getDefault(LightManager.class).getNamedBeanSet();
            }
            case SIGNALHEAD: {
                return InstanceManager.getDefault(SignalHeadManager.class).getNamedBeanSet();
            }
            case SIGNALMAST: {
                return InstanceManager.getDefault(SignalMastManager.class).getNamedBeanSet();
            }
            case MEMORY: {
                return InstanceManager.getDefault(MemoryManager.class).getNamedBeanSet();
            }
            case LOGIX: {
                return InstanceManager.getDefault(LogixManager.class).getNamedBeanSet();
            }
            case WARRANT: {
                return InstanceManager.getDefault(WarrantManager.class).getNamedBeanSet();
            }
            case OBLOCK: {
                return InstanceManager.getDefault(OBlockManager.class).getNamedBeanSet();
            }
            case ENTRYEXIT: {
                return InstanceManager.getDefault(EntryExitPairs.class).getNamedBeanSet();
            }
            case OTHER: {
                return InstanceManager.getDefault(RouteManager.class).getNamedBeanSet();
            }
        }
        return new TreeSet();
    }

    @Override
    void cancelConditionalPressed() {
        super.cancelConditionalPressed();
    }

    boolean validateVariable(String name, @Nonnull ConditionalVariable variable) {
        Conditional.ItemType itemType = variable.getType().getItemType();
        if (!this.checkIsAction(name, itemType)) {
            return false;
        }
        return this.isValidType(itemType, name);
    }

    boolean validateAction(@Nonnull String name, ConditionalAction action) {
        if (!this.checkReferenceByMemory(name)) {
            return false;
        }
        Conditional.ItemType itemType = action.getType().getItemType();
        if (this._referenceByMemory) {
            if (itemType == Conditional.ItemType.MEMORY) {
                JmriJOptionPane.showMessageDialog(this, Bundle.getMessage("Warn6"), Bundle.getMessage("WarningTitle"), 2);
                return false;
            }
        } else {
            if (!this.checkIsVariable(name, itemType)) {
                return false;
            }
            if (!this.isValidType(itemType, name)) {
                return false;
            }
        }
        return true;
    }

    boolean isValidType(@Nonnull Conditional.ItemType itemType, String sname) {
        String name = sname;
        switch (itemType) {
            case SENSOR: {
                name = this._parent.validateSensorReference(name);
                break;
            }
            case TURNOUT: {
                name = this._parent.validateTurnoutReference(name);
                break;
            }
            case CONDITIONAL: {
                name = this._parent.validateConditionalReference(name);
                break;
            }
            case LIGHT: {
                name = this._parent.validateLightReference(name);
                break;
            }
            case SIGNALHEAD: {
                name = this._parent.validateSignalHeadReference(name);
                break;
            }
            case SIGNALMAST: {
                name = this._parent.validateSignalMastReference(name);
                break;
            }
            case MEMORY: {
                name = this._parent.validateMemoryReference(name);
                break;
            }
            case LOGIX: {
                name = this._parent.validateLogixReference(name);
                break;
            }
            case WARRANT: {
                name = this._parent.validateWarrantReference(name);
                break;
            }
            case OBLOCK: {
                name = this._parent.validateOBlockReference(name);
                break;
            }
            case ENTRYEXIT: {
                name = this._parent.validateEntryExitReference(name);
                break;
            }
        }
        return name != null;
    }

    private class ActionCopyTableModel
    extends CopyTableModel {
        static final int NAME_COLUMN = 0;
        static final int DESCRIPTION_COLUMN = 1;
        static final int DELETE_COLUMN = 2;

        ActionCopyTableModel(boolean isAction, boolean isCombo) {
            super(isAction, isCombo);
        }

        @Override
        public Class<?> getColumnClass(int c) {
            switch (c) {
                case 0: {
                    if (this.isComboTable()) {
                        return JComboBox.class;
                    }
                    return JTextField.class;
                }
                case 1: {
                    return String.class;
                }
                case 2: {
                    return JButton.class;
                }
            }
            return String.class;
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public boolean isCellEditable(int r, int col) {
            return col != 1;
        }

        @Override
        public String getColumnName(int col) {
            switch (col) {
                case 0: {
                    return Bundle.getMessage("ColumnLabelName");
                }
                case 1: {
                    return Bundle.getMessage("ColumnLabelDescription");
                }
                case 2: {
                    return "";
                }
            }
            return "";
        }

        @Override
        public int getRowCount() {
            return ConditionalCopyFrame.this._actionList.size();
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (row >= this.getRowCount()) {
                return null;
            }
            ConditionalAction action = (ConditionalAction)ConditionalCopyFrame.this._actionList.get(row);
            switch (col) {
                case 0: {
                    return action.getDeviceName();
                }
                case 1: {
                    return action.description(ConditionalCopyFrame.this._parent._curConditional.getTriggerOnChange());
                }
                case 2: {
                    return Bundle.getMessage("ButtonDelete");
                }
            }
            return null;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            if (row >= this.getRowCount()) {
                return;
            }
            if (col == 0) {
                String name = (String)value;
                ConditionalAction action = (ConditionalAction)ConditionalCopyFrame.this._actionList.get(row);
                if (ConditionalCopyFrame.this.validateAction(name, action)) {
                    action.setDeviceName(name);
                    this.fireTableRowsDeleted(row, row);
                }
            } else if (col == 2) {
                ConditionalCopyFrame.this._actionList.remove(row);
                this.fireTableRowsDeleted(row, row);
            }
        }
    }

    private class VariableCopyTableModel
    extends CopyTableModel {
        static final int ROWNUM_COLUMN = 0;
        static final int NAME_COLUMN = 1;
        static final int DESCRIPTION_COLUMN = 2;

        VariableCopyTableModel(boolean isAction, boolean isCombo) {
            super(isAction, isCombo);
        }

        @Override
        public Class<?> getColumnClass(int c) {
            switch (c) {
                case 1: {
                    if (this.isComboTable()) {
                        return JComboBox.class;
                    }
                    return JTextField.class;
                }
                case 2: {
                    return String.class;
                }
            }
            return String.class;
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public boolean isCellEditable(int r, int col) {
            return col == 1;
        }

        @Override
        public String getColumnName(int col) {
            switch (col) {
                case 0: {
                    return Bundle.getMessage("ColumnLabelRow");
                }
                case 1: {
                    return Bundle.getMessage("ColumnLabelName");
                }
                case 2: {
                    return Bundle.getMessage("ColumnLabelDescription");
                }
            }
            return "";
        }

        @Override
        public int getRowCount() {
            return ConditionalCopyFrame.this._variableList.size();
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (row >= this.getRowCount()) {
                return null;
            }
            switch (col) {
                case 0: {
                    return "R" + (row + 1);
                }
                case 1: {
                    return ((ConditionalVariable)ConditionalCopyFrame.this._variableList.get(row)).getName();
                }
                case 2: {
                    return ((ConditionalVariable)ConditionalCopyFrame.this._variableList.get(row)).toString();
                }
            }
            return null;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            ConditionalVariable variable;
            String name;
            if (row >= this.getRowCount()) {
                return;
            }
            if (col == 1 && ConditionalCopyFrame.this.validateVariable(name = (String)value, variable = (ConditionalVariable)ConditionalCopyFrame.this._variableList.get(row))) {
                variable.setName(name);
                this.fireTableRowsDeleted(row, row);
            }
        }
    }

    private abstract class CopyTableModel
    extends AbstractTableModel {
        boolean _isActionTable;
        private final boolean _isComboTable;

        CopyTableModel(boolean isAction, boolean isCombo) {
            this._isActionTable = isAction;
            this._isComboTable = isCombo;
            log.debug("CopyTableModel: isAction= {}, _isComboTable= {}", (Object)isAction, (Object)this._isComboTable);
        }

        boolean isActionTable() {
            return this._isActionTable;
        }

        boolean isComboTable() {
            return this._isComboTable;
        }
    }

    private class NameCellEditor
    extends DefaultCellEditor {
        NameCellEditor(JComboBox<String> comboBox) {
            super(comboBox);
            log.debug("New JComboBox<String> NameCellEditor");
        }

        NameCellEditor(JTextField textField) {
            super(textField);
            log.debug("New JTextField NameCellEditor");
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            String name;
            Conditional.ItemType itemType;
            CopyTableModel model = (CopyTableModel)table.getModel();
            if (log.isDebugEnabled()) {
                log.debug("getTableCellEditorComponent: row= {}, column= {} selected = {} isComboTable= {}", new Object[]{row, column, isSelected, model.isComboTable()});
            }
            if (model.isActionTable()) {
                ConditionalAction action = (ConditionalAction)ConditionalCopyFrame.this._actionList.get(row);
                itemType = action.getType().getItemType();
                name = action.getDeviceName();
            } else {
                ConditionalVariable variable = (ConditionalVariable)ConditionalCopyFrame.this._variableList.get(row);
                itemType = variable.getType().getItemType();
                name = variable.getName();
            }
            if (model.isComboTable()) {
                SortedSet<?> namedBeans = ConditionalCopyFrame.this.getItemNamedBeamns(itemType);
                JComboBox comboBox = (JComboBox)this.getComponent();
                comboBox.removeAllItems();
                for (NamedBean b : namedBeans) {
                    comboBox.addItem(b.getDisplayName());
                }
            } else {
                if (ConditionalCopyFrame.this._saveType != itemType) {
                    ConditionalCopyFrame.this._parent.closeSinglePanelPickList();
                    ConditionalCopyFrame.this._parent.createSinglePanelPickList(itemType, null, true);
                    ConditionalCopyFrame.this._saveType = itemType;
                }
                JTextField field = (JTextField)this.getComponent();
                field.setText(name);
            }
            return super.getTableCellEditorComponent(table, value, isSelected, row, column);
        }
    }
}

