/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.conditional;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.swing.JFrame;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jmri.Audio;
import jmri.AudioManager;
import jmri.Conditional;
import jmri.ConditionalManager;
import jmri.ConditionalVariable;
import jmri.InstanceManager;
import jmri.Light;
import jmri.LightManager;
import jmri.Logix;
import jmri.LogixManager;
import jmri.Memory;
import jmri.MemoryManager;
import jmri.NamedBean;
import jmri.Route;
import jmri.RouteManager;
import jmri.Sensor;
import jmri.SensorManager;
import jmri.SignalHead;
import jmri.SignalHeadManager;
import jmri.SignalMast;
import jmri.SignalMastManager;
import jmri.Turnout;
import jmri.TurnoutManager;
import jmri.UserPreferencesManager;
import jmri.configurexml.ShutdownPreferences;
import jmri.jmrit.beantable.LRouteTableAction;
import jmri.jmrit.conditional.Bundle;
import jmri.jmrit.entryexit.DestinationPoints;
import jmri.jmrit.entryexit.EntryExitPairs;
import jmri.jmrit.logix.OBlock;
import jmri.jmrit.logix.OBlockManager;
import jmri.jmrit.logix.Warrant;
import jmri.jmrit.logix.WarrantManager;
import jmri.jmrit.picker.PickFrame;
import jmri.jmrit.picker.PickListModel;
import jmri.jmrit.picker.PickSinglePanel;
import jmri.swing.NamedBeanComboBox;
import jmri.util.JmriJFrame;
import jmri.util.swing.JComboBoxUtil;
import jmri.util.swing.JmriJOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConditionalEditBase {
    ConditionalManager _conditionalManager = null;
    LogixManager _logixManager = null;
    Logix _curLogix = null;
    JmriJFrame _editLogixFrame = null;
    boolean _inEditMode = false;
    boolean _showReminder = false;
    boolean _suppressReminder = false;
    boolean _suppressIndirectRef = false;
    private boolean _checkEnabled = InstanceManager.getDefault(ShutdownPreferences.class).isStoreCheckEnabled();
    SelectionMode _selectionMode;
    JTable _pickTable = null;
    JTabbedPane _pickTabPane = null;
    PickFrame _pickTables;
    JFrame _pickSingleFrame = null;
    PickSingleListener _pickListener = null;
    List<LogixEventListener> listenerList = new ArrayList<LogixEventListener>();
    public HashMap<String, String> logixData = new HashMap();
    private static final Logger log = LoggerFactory.getLogger(ConditionalEditBase.class);

    public ConditionalEditBase(String sName) {
        this._logixManager = InstanceManager.getDefault(LogixManager.class);
        this._conditionalManager = InstanceManager.getDefault(ConditionalManager.class);
        this._curLogix = this._logixManager.getBySystemName(sName);
        this.loadSelectionMode();
    }

    public ConditionalEditBase() {
    }

    void loadSelectionMode() {
        Object modeName = InstanceManager.getDefault(UserPreferencesManager.class).getProperty("jmri.jmrit.beantable.LogixTableAction", "Selection Mode");
        if (modeName == null) {
            this._selectionMode = SelectionMode.USEMULTI;
        } else {
            String currentMode;
            switch (currentMode = (String)modeName) {
                case "USEMULTI": {
                    this._selectionMode = SelectionMode.USEMULTI;
                    break;
                }
                case "USESINGLE": {
                    this._selectionMode = SelectionMode.USESINGLE;
                    break;
                }
                case "USECOMBO": {
                    this._selectionMode = SelectionMode.USECOMBO;
                    break;
                }
                default: {
                    log.warn("Invalid Logix conditional selection mode value, '{}', returned", (Object)currentMode);
                    this._selectionMode = SelectionMode.USEMULTI;
                }
            }
        }
    }

    public void addLogixEventListener(LogixEventListener listener) {
        this.listenerList.add(listener);
    }

    public void removeLogixEventListener(LogixEventListener listener) {
        this.listenerList.remove(listener);
    }

    void fireLogixEvent() {
        for (LogixEventListener l : this.listenerList) {
            l.logixEventOccurred();
        }
    }

    String makeAntecedent(List<ConditionalVariable> variableList) {
        StringBuilder antecedent = new StringBuilder(64);
        if (!variableList.isEmpty()) {
            String row = "R";
            if (variableList.get(0).isNegated()) {
                antecedent.append("not ");
            }
            antecedent.append(row + "1");
            for (int i = 1; i < variableList.size(); ++i) {
                ConditionalVariable variable = variableList.get(i);
                switch (variable.getOpern()) {
                    case AND: {
                        antecedent.append(" and ");
                        break;
                    }
                    case OR: {
                        antecedent.append(" or ");
                        break;
                    }
                }
                if (variable.isNegated()) {
                    antecedent = antecedent.append("not ");
                }
                antecedent.append(row);
                antecedent.append(i + 1);
            }
        }
        return antecedent.toString();
    }

    String appendToAntecedent(Conditional.AntecedentOperator logicType, int varListSize, String antecedent) {
        if (varListSize > 1) {
            antecedent = logicType == Conditional.AntecedentOperator.ALL_OR ? (String)antecedent + " or " : (String)antecedent + " and ";
        }
        return (String)antecedent + "R" + varListSize;
    }

    boolean validateAntecedent(Conditional.AntecedentOperator logicType, String antecedentText, List<ConditionalVariable> variableList, Conditional curConditional) {
        String message;
        if (logicType != Conditional.AntecedentOperator.MIXED || LRouteTableAction.getLogixInitializer().equals(this._curLogix.getSystemName()) || antecedentText == null || antecedentText.trim().length() == 0) {
            return true;
        }
        String antecedent = ConditionalEditBase.translateAntecedent(antecedentText, true);
        if (antecedent.length() > 0 && (message = curConditional.validateAntecedent(antecedent, variableList)) != null) {
            JmriJOptionPane.showMessageDialog(this._editLogixFrame, message + Bundle.getMessage("ParseError8"), Bundle.getMessage("ErrorTitle"), 0);
            return false;
        }
        return true;
    }

    public static String translateAntecedent(String antecedent, boolean isLocal) {
        String newNot;
        String newOr;
        String newAnd;
        String oldNot;
        String oldOr;
        String oldAnd;
        if (antecedent == null) {
            return null;
        }
        if (isLocal) {
            oldAnd = Bundle.getMessage("LogicAND").toLowerCase();
            oldOr = Bundle.getMessage("LogicOR").toLowerCase();
            oldNot = Bundle.getMessage("LogicNOT").toLowerCase();
            newAnd = "and";
            newOr = "or";
            newNot = "not";
        } else {
            oldAnd = "and";
            oldOr = "or";
            oldNot = "not";
            newAnd = Bundle.getMessage("LogicAND").toLowerCase();
            newOr = Bundle.getMessage("LogicOR").toLowerCase();
            newNot = Bundle.getMessage("LogicNOT").toLowerCase();
        }
        log.debug("translateAntecedent: before {}", (Object)antecedent);
        antecedent = antecedent.replaceAll(oldAnd, newAnd);
        antecedent = antecedent.replaceAll(oldOr, newOr);
        antecedent = antecedent.replaceAll(oldNot, newNot);
        log.debug("translateAntecedent: after  {}", (Object)antecedent);
        return antecedent;
    }

    boolean checkConditionalUserName(String uName, Logix logix) {
        Conditional p;
        if (uName != null && uName.length() > 0 && (p = this._conditionalManager.getByUserName(logix, uName)) != null) {
            log.error("Failure to update Conditional with Duplicate User Name: {}", (Object)uName);
            JmriJOptionPane.showMessageDialog(this._editLogixFrame, Bundle.getMessage("Error10"), Bundle.getMessage("ErrorTitle"), 0);
            return false;
        }
        return true;
    }

    NamedBeanComboBox<?> createNameBox(@Nonnull Conditional.ItemType itemType) {
        NamedBeanComboBox<Object> nameBox;
        switch (itemType) {
            case SENSOR: {
                nameBox = new NamedBeanComboBox<Object>(InstanceManager.getDefault(SensorManager.class), null, NamedBean.DisplayOptions.DISPLAYNAME);
                break;
            }
            case TURNOUT: {
                nameBox = new NamedBeanComboBox<Object>(InstanceManager.getDefault(TurnoutManager.class), null, NamedBean.DisplayOptions.DISPLAYNAME);
                break;
            }
            case LIGHT: {
                nameBox = new NamedBeanComboBox<Object>(InstanceManager.getDefault(LightManager.class), null, NamedBean.DisplayOptions.DISPLAYNAME);
                break;
            }
            case SIGNALHEAD: {
                nameBox = new NamedBeanComboBox<Object>(InstanceManager.getDefault(SignalHeadManager.class), null, NamedBean.DisplayOptions.DISPLAYNAME);
                break;
            }
            case SIGNALMAST: {
                nameBox = new NamedBeanComboBox<Object>(InstanceManager.getDefault(SignalMastManager.class), null, NamedBean.DisplayOptions.DISPLAYNAME);
                break;
            }
            case MEMORY: {
                nameBox = new NamedBeanComboBox<Object>(InstanceManager.getDefault(MemoryManager.class), null, NamedBean.DisplayOptions.DISPLAYNAME);
                break;
            }
            case LOGIX: {
                nameBox = new NamedBeanComboBox<Object>(InstanceManager.getDefault(LogixManager.class), null, NamedBean.DisplayOptions.DISPLAYNAME);
                break;
            }
            case WARRANT: {
                nameBox = new NamedBeanComboBox<Object>(InstanceManager.getDefault(WarrantManager.class), null, NamedBean.DisplayOptions.DISPLAYNAME);
                break;
            }
            case OBLOCK: {
                nameBox = new NamedBeanComboBox<Object>(InstanceManager.getDefault(OBlockManager.class), null, NamedBean.DisplayOptions.DISPLAYNAME);
                break;
            }
            case ENTRYEXIT: {
                nameBox = new NamedBeanComboBox<Object>(InstanceManager.getDefault(EntryExitPairs.class), null, NamedBean.DisplayOptions.DISPLAYNAME);
                break;
            }
            case OTHER: {
                nameBox = new NamedBeanComboBox<Object>(InstanceManager.getDefault(RouteManager.class), null, NamedBean.DisplayOptions.DISPLAYNAME);
                break;
            }
            default: {
                return null;
            }
        }
        nameBox.setAllowNull(true);
        JComboBoxUtil.setupComboBoxMaxRows(nameBox);
        return nameBox;
    }

    void createSinglePanelPickList(Conditional.ItemType itemType, PickSingleListener listener, boolean actionType) {
        PickSinglePanel<NamedBean> pickSingle;
        if (this._pickListener != null) {
            Conditional.ItemType saveType = this._pickListener.getItemType();
            if (saveType != itemType) {
                this.closeSinglePanelPickList();
            } else {
                return;
            }
        }
        switch (itemType) {
            case SENSOR: {
                pickSingle = new PickSinglePanel<Sensor>(PickListModel.sensorPickModelInstance());
                break;
            }
            case TURNOUT: {
                pickSingle = new PickSinglePanel<Turnout>(PickListModel.turnoutPickModelInstance());
                break;
            }
            case LIGHT: {
                pickSingle = new PickSinglePanel<Light>(PickListModel.lightPickModelInstance());
                break;
            }
            case SIGNALHEAD: {
                pickSingle = new PickSinglePanel<SignalHead>(PickListModel.signalHeadPickModelInstance());
                break;
            }
            case SIGNALMAST: {
                pickSingle = new PickSinglePanel<SignalMast>(PickListModel.signalMastPickModelInstance());
                break;
            }
            case MEMORY: {
                pickSingle = new PickSinglePanel<Memory>(PickListModel.memoryPickModelInstance());
                break;
            }
            case LOGIX: {
                if (!actionType) {
                    return;
                }
                pickSingle = new PickSinglePanel<Logix>(PickListModel.logixPickModelInstance());
                break;
            }
            case WARRANT: {
                pickSingle = new PickSinglePanel<Warrant>(PickListModel.warrantPickModelInstance());
                break;
            }
            case OBLOCK: {
                pickSingle = new PickSinglePanel<OBlock>(PickListModel.oBlockPickModelInstance());
                break;
            }
            case ENTRYEXIT: {
                pickSingle = new PickSinglePanel<DestinationPoints>(PickListModel.entryExitPickModelInstance());
                break;
            }
            default: {
                return;
            }
        }
        this._pickSingleFrame = new JmriJFrame(Bundle.getMessage("SinglePickFrame"));
        this._pickSingleFrame.setContentPane(pickSingle);
        this._pickSingleFrame.pack();
        this._pickSingleFrame.setVisible(true);
        this._pickSingleFrame.toFront();
        this._pickListener = listener;
        this._pickTable = pickSingle.getTable();
        this._pickTable.getSelectionModel().addListSelectionListener(this._pickListener);
    }

    void closeSinglePanelPickList() {
        if (this._pickSingleFrame != null) {
            this._pickSingleFrame.setVisible(false);
            this._pickSingleFrame.dispose();
            this._pickSingleFrame = null;
            this._pickListener = null;
            this._pickTable = null;
        }
    }

    void openPickListTable() {
        if (this._pickTables == null) {
            this._pickTables = new PickFrame(Bundle.getMessage("TitlePickList"));
        } else {
            this._pickTables.setVisible(true);
        }
        this._pickTables.toFront();
    }

    void hidePickListTable() {
        if (this._pickTables != null) {
            this._pickTables.setVisible(false);
        }
    }

    void setPickListTab(Conditional.ItemType curType, boolean actionType) {
        boolean tabSet = true;
        if (this._pickTables == null) {
            return;
        }
        if (this._pickTabPane == null) {
            this.findPickListTabPane(this._pickTables.getComponents(), 1);
        }
        if (this._pickTabPane != null) {
            int tabIndex = 0;
            switch (curType) {
                case SENSOR: {
                    tabIndex = 1;
                    break;
                }
                case TURNOUT: {
                    tabIndex = 0;
                    break;
                }
                case LIGHT: {
                    tabIndex = 6;
                    break;
                }
                case SIGNALHEAD: {
                    tabIndex = 2;
                    break;
                }
                case SIGNALMAST: {
                    tabIndex = 3;
                    break;
                }
                case MEMORY: {
                    tabIndex = 4;
                    break;
                }
                case LOGIX: {
                    if (actionType) {
                        tabIndex = 10;
                        break;
                    }
                    tabSet = false;
                    break;
                }
                case WARRANT: {
                    tabIndex = 7;
                    break;
                }
                case OBLOCK: {
                    tabIndex = 8;
                    break;
                }
                case ENTRYEXIT: {
                    tabIndex = 9;
                    break;
                }
                default: {
                    tabSet = false;
                }
            }
            if (tabSet) {
                this._pickTabPane.setSelectedIndex(tabIndex);
            }
        }
        this._pickTables.setVisible(tabSet);
    }

    void findPickListTabPane(Component[] compList, int level) {
        for (Component compItem : compList) {
            if (level > 10) {
                log.warn("findPickListTabPane: safety breaker reached");
                return;
            }
            if (compItem instanceof JTabbedPane) {
                this._pickTabPane = (JTabbedPane)compItem;
                continue;
            }
            int nextLevel = level + 1;
            if (compItem instanceof Container) {
                Container nextItem = (Container)compItem;
                Component[] nextList = nextItem.getComponents();
                this.findPickListTabPane(nextList, nextLevel);
                continue;
            }
            log.error("compItem {} is not a JTabbedPane, nor Container", (Object)compItem);
        }
    }

    void loadReferenceNames(List<ConditionalVariable> varList, TreeSet<String> treeSet) {
        treeSet.clear();
        for (ConditionalVariable condVar : varList) {
            if (condVar.getType() != Conditional.Type.CONDITIONAL_TRUE && condVar.getType() != Conditional.Type.CONDITIONAL_FALSE) continue;
            treeSet.add(condVar.getName());
        }
    }

    boolean checkConditionalReferences(String logixName) {
        Logix x = this._logixManager.getLogix(logixName);
        int numConditionals = x.getNumConditionals();
        for (int i = 0; i < numConditionals; ++i) {
            String csName = x.getConditionalByNumberOrder(i);
            ArrayList<String> refList = InstanceManager.getDefault(ConditionalManager.class).getWhereUsed(csName);
            if (refList == null) continue;
            for (String refName : refList) {
                Logix xRef = this._conditionalManager.getParentLogix(refName);
                if (xRef == null) {
                    log.error("Could not fetch Logix for ref: {}", (Object)refName);
                    continue;
                }
                String xsName = xRef.getSystemName();
                if (logixName.equals(xsName)) continue;
                Conditional c = x.getConditional(csName);
                Conditional cRef = xRef.getConditional(refName);
                Object[] msgs = new Object[]{c != null ? c.getUserName() : "NULL", csName, cRef != null ? cRef.getUserName() : "NULL", refName, xRef.getUserName(), xRef.getSystemName()};
                JmriJOptionPane.showMessageDialog(this._editLogixFrame, Bundle.getMessage("Error11", msgs), Bundle.getMessage("ErrorTitle"), 0);
                return false;
            }
        }
        return true;
    }

    void updateWhereUsed(TreeSet<String> oldTargetNames, TreeSet<String> newTargetNames, String refName) {
        TreeSet<String> deleteNames = new TreeSet<String>((SortedSet<String>)oldTargetNames);
        deleteNames.removeAll(newTargetNames);
        for (String deleteName : deleteNames) {
            InstanceManager.getDefault(ConditionalManager.class).removeWhereUsed(deleteName, refName);
        }
        TreeSet<String> addNames = new TreeSet<String>((SortedSet<String>)newTargetNames);
        addNames.removeAll(oldTargetNames);
        for (String addName : addNames) {
            InstanceManager.getDefault(ConditionalManager.class).addWhereUsed(addName, refName);
        }
    }

    void showSaveReminder() {
        UserPreferencesManager upm = InstanceManager.getNullableDefault(UserPreferencesManager.class);
        if (this._showReminder && !this._checkEnabled && upm != null) {
            upm.showInfoMessage(Bundle.getMessage("ReminderTitle"), Bundle.getMessage("ReminderSaveString", Bundle.getMessage("MenuItemLogixTable")), "jmri.jmrit.beantable.LogixTableAction", "remindSaveLogix");
        }
    }

    boolean validateIntensityReference(Conditional.Action actionType, @CheckForNull String intReference) {
        if (intReference == null || intReference.trim().length() == 0) {
            this.displayBadNumberReference(actionType);
            return false;
        }
        try {
            return this.validateIntensity(Integer.parseInt(intReference));
        }
        catch (NumberFormatException e) {
            String intRef = intReference;
            if (intReference.length() > 1 && intReference.charAt(0) == '@') {
                intRef = intRef.substring(1);
            }
            if (!this.confirmIndirectMemory(intRef)) {
                return false;
            }
            if ((intRef = this.validateMemoryReference(intRef)) != null) {
                Memory m = InstanceManager.memoryManagerInstance().getByUserName(intRef);
                if (m == null) {
                    m = InstanceManager.memoryManagerInstance().getBySystemName(intRef);
                }
                try {
                    if (m == null || m.getValue() == null) {
                        throw new NumberFormatException();
                    }
                    this.validateIntensity(Integer.parseInt((String)m.getValue()));
                }
                catch (NumberFormatException ex) {
                    JmriJOptionPane.showMessageDialog(this._editLogixFrame, Bundle.getMessage("Error24", intReference), Bundle.getMessage("WarningTitle"), 2);
                }
                return true;
            }
            this.displayBadNumberReference(actionType);
            return false;
        }
    }

    boolean validateIntensity(int time) {
        if (time < 0 || time > 100) {
            JmriJOptionPane.showMessageDialog(this._editLogixFrame, Bundle.getMessage("Error38", time, Bundle.getMessage("Error42")), Bundle.getMessage("ErrorTitle"), 0);
            return false;
        }
        return true;
    }

    boolean validateTimeReference(Conditional.Action actionType, @CheckForNull String ref) {
        if (ref == null || ref.trim().length() == 0) {
            this.displayBadNumberReference(actionType);
            return false;
        }
        try {
            return this.validateTime(actionType, Float.parseFloat(ref));
        }
        catch (NumberFormatException e) {
            String memRef = ref;
            if (ref.length() > 1 && ref.charAt(0) == '@') {
                memRef = ref.substring(1);
            }
            if (!this.confirmIndirectMemory(memRef)) {
                return false;
            }
            if ((memRef = this.validateMemoryReference(memRef)) != null) {
                Memory m = InstanceManager.memoryManagerInstance().getByUserName(memRef);
                if (m == null) {
                    m = InstanceManager.memoryManagerInstance().getBySystemName(memRef);
                }
                try {
                    if (m == null || m.getValue() == null) {
                        throw new NumberFormatException();
                    }
                    this.validateTime(actionType, Float.parseFloat((String)m.getValue()));
                }
                catch (NumberFormatException ex) {
                    JmriJOptionPane.showMessageDialog(this._editLogixFrame, Bundle.getMessage("Error24", memRef), Bundle.getMessage("WarningTitle"), 2);
                }
                return true;
            }
            this.displayBadNumberReference(actionType);
            return false;
        }
    }

    boolean validateTime(Conditional.Action actionType, float time) {
        float maxTime = 3600.0f;
        float minTime = 0.02f;
        if (time < minTime || time > maxTime) {
            String errorNum = " ";
            switch (actionType) {
                case DELAYED_TURNOUT: {
                    errorNum = "Error39";
                    break;
                }
                case RESET_DELAYED_TURNOUT: {
                    errorNum = "Error41";
                    break;
                }
                case DELAYED_SENSOR: {
                    errorNum = "Error23";
                    break;
                }
                case RESET_DELAYED_SENSOR: {
                    errorNum = "Error27";
                    break;
                }
                case SET_LIGHT_TRANSITION_TIME: {
                    errorNum = "Error29";
                    break;
                }
            }
            JmriJOptionPane.showMessageDialog(this._editLogixFrame, Bundle.getMessage("Error38", Float.valueOf(time), Bundle.getMessage(errorNum)), Bundle.getMessage("ErrorTitle"), 0);
            return false;
        }
        return true;
    }

    void displayBadNumberReference(@Nonnull Conditional.Action actionType) {
        String errorNum = " ";
        switch (actionType) {
            case DELAYED_TURNOUT: {
                errorNum = "Error39";
                break;
            }
            case RESET_DELAYED_TURNOUT: {
                errorNum = "Error41";
                break;
            }
            case DELAYED_SENSOR: {
                errorNum = "Error23";
                break;
            }
            case RESET_DELAYED_SENSOR: {
                errorNum = "Error27";
                break;
            }
            case SET_LIGHT_INTENSITY: {
                JmriJOptionPane.showMessageDialog(this._editLogixFrame, Bundle.getMessage("Error43"), Bundle.getMessage("ErrorTitle"), 0);
                return;
            }
            case SET_LIGHT_TRANSITION_TIME: {
                errorNum = "Error29";
                break;
            }
            default: {
                log.warn("Unexpected action type {} in displayBadNumberReference", (Object)actionType);
            }
        }
        JmriJOptionPane.showMessageDialog(this._editLogixFrame, Bundle.getMessage("Error9", Bundle.getMessage(errorNum)), Bundle.getMessage("ErrorTitle"), 0);
    }

    @CheckForNull
    String validateMemoryReference(@CheckForNull String name) {
        Memory m = null;
        if (name != null) {
            if (name.length() > 0 && (m = InstanceManager.memoryManagerInstance().getByUserName(name)) != null) {
                return name;
            }
            m = InstanceManager.memoryManagerInstance().getBySystemName(name);
        }
        if (m == null) {
            this.messageInvalidActionItemName(name, "Memory");
            return null;
        }
        return name;
    }

    boolean confirmIndirectMemory(String memName) {
        if (!this._suppressIndirectRef) {
            int response = JmriJOptionPane.showConfirmDialog(this._editLogixFrame, Bundle.getMessage("ConfirmIndirectReference", memName, Bundle.getMessage("ButtonYes"), Bundle.getMessage("ButtonNo"), Bundle.getMessage("ButtonCancel")), Bundle.getMessage("QuestionTitle"), 1, 3);
            if (response == 1 || response == -1) {
                return false;
            }
            if (response == 2) {
                this._suppressIndirectRef = true;
            }
        }
        return true;
    }

    boolean confirmActionAsVariable(String actionName, String variableName) {
        int response = JmriJOptionPane.showConfirmDialog(this._editLogixFrame, Bundle.getMessage("ConfirmActionAsVariable", actionName, variableName), Bundle.getMessage("QuestionTitle"), 0, 3);
        return response == 0;
    }

    @CheckForNull
    String validateTurnoutReference(@CheckForNull String name) {
        Turnout t = null;
        if (name != null) {
            if (name.length() > 0 && (t = InstanceManager.turnoutManagerInstance().getByUserName(name)) != null) {
                return name;
            }
            t = InstanceManager.turnoutManagerInstance().getBySystemName(name);
        }
        if (t == null) {
            this.messageInvalidActionItemName(name, "Turnout");
            return null;
        }
        return name;
    }

    @CheckForNull
    String validateSignalHeadReference(@CheckForNull String name) {
        SignalHead h = null;
        if (name != null) {
            if (name.length() > 0 && (h = InstanceManager.getDefault(SignalHeadManager.class).getByUserName(name)) != null) {
                return name;
            }
            h = InstanceManager.getDefault(SignalHeadManager.class).getBySystemName(name);
        }
        if (h == null) {
            this.messageInvalidActionItemName(name, "SignalHead");
            return null;
        }
        return name;
    }

    @CheckForNull
    String validateSignalMastReference(@CheckForNull String name) {
        SignalMast h = null;
        if (name != null) {
            if (name.length() > 0 && (h = InstanceManager.getDefault(SignalMastManager.class).getByUserName(name)) != null) {
                return name;
            }
            try {
                h = InstanceManager.getDefault(SignalMastManager.class).provideSignalMast(name);
            }
            catch (IllegalArgumentException ex) {
                h = null;
            }
        }
        if (h == null) {
            this.messageInvalidActionItemName(name, "SignalMast");
            return null;
        }
        return name;
    }

    @CheckForNull
    String validateWarrantReference(@CheckForNull String name) {
        Warrant w = null;
        if (name != null) {
            if (name.length() > 0 && (w = (Warrant)InstanceManager.getDefault(WarrantManager.class).getByUserName(name)) != null) {
                return name;
            }
            w = (Warrant)InstanceManager.getDefault(WarrantManager.class).getBySystemName(name);
        }
        if (w == null) {
            this.messageInvalidActionItemName(name, "Warrant");
            return null;
        }
        return name;
    }

    @CheckForNull
    String validateOBlockReference(@CheckForNull String name) {
        OBlock b = null;
        if (name != null) {
            if (name.length() > 0 && (b = (OBlock)InstanceManager.getDefault(OBlockManager.class).getByUserName(name)) != null) {
                return name;
            }
            b = (OBlock)InstanceManager.getDefault(OBlockManager.class).getBySystemName(name);
        }
        if (b == null) {
            this.messageInvalidActionItemName(name, "OBlock");
            return null;
        }
        return name;
    }

    @CheckForNull
    String validateSensorReference(@CheckForNull String name) {
        Sensor s = null;
        if (name != null) {
            if (name.length() > 0 && (s = InstanceManager.getDefault(SensorManager.class).getByUserName(name)) != null) {
                return name;
            }
            s = InstanceManager.getDefault(SensorManager.class).getBySystemName(name);
        }
        if (s == null) {
            this.messageInvalidActionItemName(name, "Sensor");
            return null;
        }
        return name;
    }

    @CheckForNull
    String validateLightReference(@CheckForNull String name) {
        Light l = null;
        if (name != null) {
            if (name.length() > 0 && (l = InstanceManager.lightManagerInstance().getByUserName(name)) != null) {
                return name;
            }
            l = InstanceManager.lightManagerInstance().getBySystemName(name);
        }
        if (l == null) {
            this.messageInvalidActionItemName(name, "Light");
            return null;
        }
        return name;
    }

    @CheckForNull
    String validateConditionalReference(@CheckForNull String name) {
        Conditional c = null;
        if (name != null) {
            if (name.length() > 0 && (c = this._conditionalManager.getByUserName(name)) != null) {
                return name;
            }
            c = this._conditionalManager.getBySystemName(name);
        }
        if (c == null) {
            this.messageInvalidActionItemName(name, "Conditional");
            return null;
        }
        return name;
    }

    @CheckForNull
    String validateLogixReference(@CheckForNull String name) {
        Logix l = null;
        if (name != null) {
            if (name.length() > 0 && (l = this._logixManager.getByUserName(name)) != null) {
                return name;
            }
            l = this._logixManager.getBySystemName(name);
        }
        if (l == null) {
            this.messageInvalidActionItemName(name, "Logix");
            return null;
        }
        return name;
    }

    @CheckForNull
    String validateRouteReference(@CheckForNull String name) {
        Route r = null;
        if (name != null) {
            if (name.length() > 0 && (r = InstanceManager.getDefault(RouteManager.class).getByUserName(name)) != null) {
                return name;
            }
            r = InstanceManager.getDefault(RouteManager.class).getBySystemName(name);
        }
        if (r == null) {
            this.messageInvalidActionItemName(name, "Route");
            return null;
        }
        return name;
    }

    @CheckForNull
    String validateAudioReference(@CheckForNull String name) {
        Audio a = null;
        if (name != null) {
            if (name.length() > 0 && (a = InstanceManager.getDefault(AudioManager.class).getByUserName(name)) != null) {
                return name;
            }
            a = InstanceManager.getDefault(AudioManager.class).getBySystemName(name);
        }
        if (a == null || a.getSubType() != 'S' && a.getSubType() != 'L') {
            this.messageInvalidActionItemName(name, "Audio");
            return null;
        }
        return name;
    }

    @CheckForNull
    String validateEntryExitReference(@CheckForNull String name) {
        DestinationPoints nb;
        if (name != null && name.length() > 0 && (nb = InstanceManager.getDefault(EntryExitPairs.class).getNamedBean(name)) != null) {
            return nb.getSystemName();
        }
        this.messageInvalidActionItemName(name, "BeanNameEntryExit");
        return null;
    }

    @CheckForNull
    Light getLight(@CheckForNull String name) {
        if (name == null) {
            return null;
        }
        Light l = null;
        if (name.length() > 0) {
            l = InstanceManager.lightManagerInstance().getByUserName(name);
            if (l != null) {
                return l;
            }
            l = InstanceManager.lightManagerInstance().getBySystemName(name);
        }
        if (l == null) {
            this.messageInvalidActionItemName(name, "Light");
        }
        return l;
    }

    int parseTime(@Nonnull String s) {
        int nHour = 0;
        int nMin = 0;
        boolean error = false;
        int index = s.indexOf(58);
        String hour = null;
        String minute = null;
        try {
            if (index > 0) {
                hour = s.substring(0, index);
                minute = index + 1 < s.length() ? s.substring(index + 1) : "0";
            } else if (index == 0) {
                hour = "0";
                minute = s.substring(index + 1);
            } else {
                hour = s;
                minute = "0";
            }
        }
        catch (IndexOutOfBoundsException ioob) {
            error = true;
        }
        if (!error) {
            try {
                nHour = Integer.parseInt(hour);
                if (nHour < 0 || nHour > 24) {
                    error = true;
                }
                if ((nMin = Integer.parseInt(minute)) < 0 || nMin > 59) {
                    error = true;
                }
            }
            catch (NumberFormatException e) {
                error = true;
            }
        }
        if (error) {
            JmriJOptionPane.showMessageDialog(this._editLogixFrame, Bundle.getMessage("Error26", s), Bundle.getMessage("ErrorTitle"), 0);
            return -1;
        }
        return nHour * 60 + nMin;
    }

    public static String formatTime(int hour, int minute) {
        Object s = "";
        String t = Integer.toString(hour);
        if (t.length() == 2) {
            s = t + ":";
        } else if (t.length() == 1) {
            s = "0" + t + ":";
        }
        t = Integer.toString(minute);
        if (t.length() == 2) {
            s = (String)s + t;
        } else if (t.length() == 1) {
            s = (String)s + "0" + t;
        }
        if (((String)s).length() != 5) {
            s = "00:00";
        }
        return s;
    }

    void messageInvalidActionItemName(String name, String itemType) {
        JmriJOptionPane.showMessageDialog(this._editLogixFrame, Bundle.getMessage("Error22", name, Bundle.getMessage("BeanName" + itemType)), Bundle.getMessage("ErrorTitle"), 0);
    }

    void messageDuplicateConditionalUserName(String svName) {
        JmriJOptionPane.showMessageDialog(this._editLogixFrame, Bundle.getMessage("Error30", svName), Bundle.getMessage("ErrorTitle"), 0);
    }

    public void bringToFront() {
        this._editLogixFrame.toFront();
    }

    public void locateAt(Component c) {
        this._editLogixFrame.setLocationRelativeTo(c);
        this._editLogixFrame.toFront();
    }

    protected String getClassName() {
        return ConditionalEditBase.class.getName();
    }

    class PickSingleListener
    implements ListSelectionListener {
        private final JTextField saveTextField;
        private final Conditional.ItemType saveItemType;

        PickSingleListener(JTextField textField, Conditional.ItemType itemType) {
            this.saveItemType = itemType;
            this.saveTextField = textField;
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            int selectedRow = ConditionalEditBase.this._pickTable.getSelectedRow();
            if (selectedRow >= 0) {
                int selectedCol = ConditionalEditBase.this._pickTable.getSelectedColumn();
                String newName = (String)ConditionalEditBase.this._pickTable.getValueAt(selectedRow, selectedCol);
                log.debug("Pick single panel row event: row = '{}', column = '{}', selected name = '{}'", new Object[]{selectedRow, selectedCol, newName});
                this.saveTextField.setText(newName);
            }
        }

        public Conditional.ItemType getItemType() {
            return this.saveItemType;
        }
    }

    static class NameBoxListener
    implements ActionListener {
        private final JTextField saveTextField;

        NameBoxListener(JTextField textField) {
            this.saveTextField = textField;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object src = e.getSource();
            if (!(src instanceof NamedBeanComboBox)) {
                return;
            }
            NamedBeanComboBox srcBox = (NamedBeanComboBox)src;
            String newName = srcBox.getSelectedItemDisplayName();
            log.debug("NameBoxListener: new name = '{}'", (Object)newName);
            this.saveTextField.setText(newName);
        }
    }

    public static interface LogixEventListener
    extends EventListener {
        public void logixEventOccurred();
    }

    public static enum SelectionMode {
        USEMULTI,
        USESINGLE,
        USECOMBO;

    }
}

