/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.conditional;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import jmri.Conditional;
import jmri.InstanceManager;
import jmri.Logix;
import jmri.NamedBean;
import jmri.jmrit.conditional.Bundle;
import jmri.jmrit.conditional.ConditionalCopyFrame;
import jmri.jmrit.conditional.ConditionalEditFrame;
import jmri.jmrit.conditional.ConditionalList;
import jmri.jmrit.conditional.ConditionalListEdit;
import jmri.util.JmriJFrame;
import jmri.util.PlaceWindow;
import jmri.util.swing.JmriJOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConditionalListCopy
extends ConditionalList {
    Logix _targetLogix;
    ConditionalListModel _conditionalListModel;
    JList<Conditional> _conditionalList;
    JRadioButton _fullEditButton;
    private static final Logger log = LoggerFactory.getLogger(ConditionalListCopy.class);

    public ConditionalListCopy(String srcLogixName, Logix targetLogix) {
        super(srcLogixName);
        this._targetLogix = targetLogix;
        this.makeEditLogixWindow();
    }

    public ConditionalListCopy() {
    }

    void makeEditLogixWindow() {
        this._editLogixFrame = new JmriJFrame(Bundle.getMessage("TitleCopyFromLogix", this._curLogix.getDisplayName(NamedBean.DisplayOptions.QUOTED_USERNAME_SYSTEMNAME)));
        this._editLogixFrame.addHelpMenu("package.jmri.jmrit.conditional.ConditionalCopy", true);
        Container contentPane = this._editLogixFrame.getContentPane();
        contentPane.setLayout(new BoxLayout(contentPane, 1));
        contentPane.add(Box.createVerticalStrut(10));
        JPanel topPanel = new JPanel();
        topPanel.add(new JLabel(Bundle.getMessage("SelectCopyConditional", this._targetLogix.getDisplayName())));
        contentPane.add(topPanel);
        contentPane.add(Box.createVerticalStrut(10));
        JPanel listPanel = new JPanel();
        listPanel.setLayout(new BoxLayout(listPanel, 1));
        this._conditionalListModel = new ConditionalListModel(this._curLogix);
        this._conditionalList = new JList<Conditional>(this._conditionalListModel);
        this._conditionalList.setCellRenderer(new ConditionalCellRenderer());
        this._conditionalList.setVisibleRowCount(6);
        this._conditionalList.setSelectionMode(0);
        listPanel.add(new JScrollPane(this._conditionalList));
        Border listPanelBorder = BorderFactory.createEtchedBorder();
        TitledBorder listPanelTitled = BorderFactory.createTitledBorder(listPanelBorder, Bundle.getMessage("TitleConditionalList"));
        listPanel.setBorder(listPanelTitled);
        contentPane.add(listPanel);
        contentPane.add(Box.createVerticalStrut(10));
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        ButtonGroup bGroup = new ButtonGroup();
        this._fullEditButton = new JRadioButton(Bundle.getMessage("fullEditButton"));
        this._fullEditButton.setToolTipText(Bundle.getMessage("HintFullEditButton"));
        bGroup.add(this._fullEditButton);
        panel.add(this._fullEditButton);
        JRadioButton itemsOnlyButton = new JRadioButton(Bundle.getMessage("itemsOnlyButton"));
        itemsOnlyButton.setToolTipText(Bundle.getMessage("HintItemsOnlyButton"));
        bGroup.add(itemsOnlyButton);
        panel.add(itemsOnlyButton);
        itemsOnlyButton.setSelected(true);
        JPanel p = new JPanel();
        p.add(panel);
        p.add(Box.createVerticalStrut(10));
        contentPane.add(p);
        panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        JButton editButton = new JButton(Bundle.getMessage("CopyConditionalButton"));
        editButton.setToolTipText(Bundle.getMessage("HintCopyConditionalButton", this._targetLogix.getDisplayName()));
        panel.add(editButton);
        editButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConditionalListCopy.this.editButtonPressed();
            }
        });
        panel.add(Box.createHorizontalStrut(10));
        JButton exitButton = new JButton(Bundle.getMessage("ButtonDone"));
        exitButton.setToolTipText(Bundle.getMessage("HintExitButton"));
        panel.add(exitButton);
        exitButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConditionalListCopy.this.donePressed(e);
            }
        });
        p = new JPanel();
        p.add(panel);
        p.add(Box.createVerticalStrut(10));
        p.add(panel);
        p.add(Box.createVerticalStrut(10));
        contentPane.add(p);
        this._editLogixFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ConditionalListCopy.this.donePressed(null);
            }
        });
        this._editLogixFrame.pack();
        this._editLogixFrame.setVisible(true);
    }

    void editButtonPressed() {
        Conditional conditional = this._conditionalList.getSelectedValue();
        if (conditional == null) {
            JmriJOptionPane.showMessageDialog(this._editLogixFrame, Bundle.getMessage("SelectCopyConditional"), Bundle.getMessage("ReminderTitle"), 1);
            return;
        }
        this._curConditional = this.makeNewConditional(this._targetLogix);
        this._curConditional.setStateVariables(conditional.getCopyOfStateVariables());
        this._curConditional.setAction(conditional.getCopyOfActions());
        this._curConditional.setLogicType(conditional.getLogicType(), conditional.getAntecedentExpression());
        this._curConditional.setUserName(Bundle.getMessage("CopyOf", conditional.getDisplayName(NamedBean.DisplayOptions.DISPLAYNAME)));
        if (this._fullEditButton.isSelected()) {
            this.makeEditConditionalWindow(conditional);
        } else {
            this.makeChangeItemNameWindow(conditional);
        }
    }

    void makeEditConditionalWindow(Conditional srcCond) {
        log.debug("makeEditConditionalWindow");
        this._curLogix.deActivateLogix();
        this._targetLogix.deActivateLogix();
        this._conditionalFrame = new ConditionalEditFrame(Bundle.getMessage("TitleCopyConditional", srcCond.getDisplayName(NamedBean.DisplayOptions.QUOTED_USERNAME_SYSTEMNAME)), this._curConditional, this);
        this._conditionalFrame.pack();
        this._conditionalFrame.setVisible(true);
        InstanceManager.getDefault(PlaceWindow.class).nextTo(this._editLogixFrame, null, this._conditionalFrame);
    }

    @Override
    JPanel makeBottomPanel() {
        JPanel panel = new JPanel();
        JButton saveButton = new JButton(Bundle.getMessage("ButtonSave"));
        panel.add(saveButton);
        saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConditionalListCopy.this._conditionalFrame.updateConditionalPressed(e);
            }
        });
        saveButton.setToolTipText(Bundle.getMessage("SaveConditionalButtonHint", this._targetLogix.getDisplayName()));
        JButton cancelButton = new JButton(Bundle.getMessage("ButtonCancel"));
        panel.add(cancelButton);
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConditionalListCopy.this._conditionalFrame.cancelConditionalPressed();
            }
        });
        cancelButton.setToolTipText(Bundle.getMessage("CancelSaveButtonHint"));
        return panel;
    }

    @Override
    boolean updateConditional(String uName, Conditional.AntecedentOperator logicType, boolean trigger, String antecedent) {
        return super.updateConditional(uName, this._targetLogix, logicType, trigger, antecedent);
    }

    @Override
    void updateConditionalTableModel() {
        log.debug("updateConditionalTableModel :: not needed for copy process");
    }

    @Override
    void closeConditionalFrame() {
        super.closeConditionalFrame(this._targetLogix);
    }

    void makeChangeItemNameWindow(Conditional srcCond) {
        this._curLogix.deActivateLogix();
        this._targetLogix.deActivateLogix();
        this._conditionalFrame = new ConditionalCopyFrame(Bundle.getMessage("TitleCopyConditional", srcCond.getDisplayName(NamedBean.DisplayOptions.QUOTED_USERNAME_SYSTEMNAME)), this._curConditional, this);
        this._conditionalFrame.pack();
        this._conditionalFrame.setVisible(true);
        InstanceManager.getDefault(PlaceWindow.class).nextTo(this._editLogixFrame, null, this._conditionalFrame);
    }

    void donePressed(ActionEvent e) {
        this.showSaveReminder();
        this._inEditMode = false;
        if (this._targetLogix.getNumConditionals() == 0) {
            this._logixManager.deleteLogix(this._targetLogix);
        }
        this.closeConditionalFrame();
        if (this._editLogixFrame != null) {
            this._editLogixFrame.setVisible(false);
            this._editLogixFrame.dispose();
            this._editLogixFrame = null;
        }
        this.logixData.clear();
        this.logixData.put("Finish", this._curLogix.getSystemName());
        this.fireLogixEvent();
    }

    @Override
    protected String getClassName() {
        return ConditionalListEdit.class.getName();
    }

    static class ConditionalListModel
    extends DefaultListModel<Conditional> {
        Logix _srcLogic;

        ConditionalListModel(Logix srcLogic) {
            this._srcLogic = srcLogic;
            if (srcLogic != null) {
                for (int i = 0; i < srcLogic.getNumConditionals(); ++i) {
                    this.addElement(srcLogic.getConditional(srcLogic.getConditionalByNumberOrder(i)));
                }
            }
        }
    }

    private static class ConditionalCellRenderer
    extends JLabel
    implements ListCellRenderer<Conditional> {
        private ConditionalCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends Conditional> list, Conditional value, int index, boolean isSelected, boolean cellHasFocus) {
            String s = value.getDisplayName(NamedBean.DisplayOptions.USERNAME_SYSTEMNAME);
            this.setText(s);
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.setEnabled(list.isEnabled());
            this.setFont(list.getFont());
            this.setOpaque(true);
            return this;
        }
    }
}

