/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.conditional;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import jmri.Conditional;
import jmri.ConditionalManager;
import jmri.ConditionalVariable;
import jmri.InstanceManager;
import jmri.Logix;
import jmri.jmrit.conditional.Bundle;
import jmri.jmrit.conditional.ConditionalEditFrame;
import jmri.jmrit.conditional.ConditionalList;
import jmri.jmrit.sensorgroup.SensorGroupFrame;
import jmri.util.JmriJFrame;
import jmri.util.PlaceWindow;
import jmri.util.swing.JmriJOptionPane;
import jmri.util.table.ButtonEditor;
import jmri.util.table.ButtonRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConditionalListEdit
extends ConditionalList {
    JTextField _editUserName;
    JLabel _status;
    int _numConditionals = 0;
    ConditionalTableModel conditionalTableModel = null;
    int _conditionalRowNumber = 0;
    boolean _inReorderMode = false;
    int _nextInOrder = 0;
    static final int STRUT = 10;
    private static final Logger log = LoggerFactory.getLogger(ConditionalListEdit.class);

    public ConditionalListEdit(String sName) {
        super(sName);
        this.makeEditLogixWindow();
    }

    public ConditionalListEdit() {
    }

    void makeEditLogixWindow() {
        this._editUserName = new JTextField(20);
        this._editUserName.setText(this._curLogix.getUserName());
        if (this.conditionalTableModel != null) {
            this.conditionalTableModel.fireTableStructureChanged();
        }
        this._inEditMode = true;
        if (this._editLogixFrame == null) {
            this._editLogixFrame = new JmriJFrame(Bundle.getMessage("TitleEditLogix"), false, false);
            this._editLogixFrame.addHelpMenu("package.jmri.jmrit.conditional.ConditionalListEditor", true);
            this._editLogixFrame.setLocation(100, 30);
            Container contentPane = this._editLogixFrame.getContentPane();
            contentPane.setLayout(new BoxLayout(contentPane, 1));
            JPanel panel1 = new JPanel();
            panel1.setLayout(new FlowLayout());
            JLabel systemNameLabel = new JLabel(Bundle.getMessage("ColumnSystemName") + ":");
            panel1.add(systemNameLabel);
            JLabel fixedSystemName = new JLabel(this._curLogix.getSystemName());
            panel1.add(fixedSystemName);
            contentPane.add(panel1);
            JPanel panel2 = new JPanel();
            panel2.setLayout(new FlowLayout());
            JLabel userNameLabel = new JLabel(Bundle.getMessage("ColumnUserName") + ":");
            panel2.add(userNameLabel);
            panel2.add(this._editUserName);
            this._editUserName.setToolTipText(Bundle.getMessage("LogixUserNameHint2"));
            contentPane.add(panel2);
            JPanel pctSpace = new JPanel();
            pctSpace.setLayout(new FlowLayout());
            pctSpace.add(new JLabel("   "));
            contentPane.add(pctSpace);
            JPanel pTitle = new JPanel();
            pTitle.setLayout(new FlowLayout());
            pTitle.add(new JLabel(Bundle.getMessage("ConditionalTableTitle")));
            contentPane.add(pTitle);
            this.conditionalTableModel = new ConditionalTableModel();
            JTable conditionalTable = new JTable(this.conditionalTableModel);
            conditionalTable.setRowSelectionAllowed(false);
            TableColumnModel conditionalColumnModel = conditionalTable.getColumnModel();
            TableColumn sNameColumn = conditionalColumnModel.getColumn(0);
            sNameColumn.setResizable(true);
            sNameColumn.setMinWidth(100);
            sNameColumn.setPreferredWidth(130);
            TableColumn uNameColumn = conditionalColumnModel.getColumn(1);
            uNameColumn.setResizable(true);
            uNameColumn.setMinWidth(210);
            uNameColumn.setPreferredWidth(260);
            TableColumn stateColumn = conditionalColumnModel.getColumn(2);
            stateColumn.setResizable(true);
            stateColumn.setMinWidth(50);
            stateColumn.setMaxWidth(100);
            TableColumn buttonColumn = conditionalColumnModel.getColumn(3);
            ButtonRenderer buttonRenderer = new ButtonRenderer();
            conditionalTable.setDefaultRenderer(JButton.class, buttonRenderer);
            ButtonEditor buttonEditor = new ButtonEditor(new JButton());
            conditionalTable.setDefaultEditor(JButton.class, buttonEditor);
            JButton testButton = new JButton("XXXXXX");
            conditionalTable.setRowHeight(testButton.getPreferredSize().height);
            buttonColumn.setMinWidth(testButton.getPreferredSize().width);
            buttonColumn.setMaxWidth(testButton.getPreferredSize().width);
            buttonColumn.setResizable(false);
            JScrollPane conditionalTableScrollPane = new JScrollPane(conditionalTable);
            Dimension dim = conditionalTable.getPreferredSize();
            dim.height = 450;
            conditionalTableScrollPane.getViewport().setPreferredSize(dim);
            contentPane.add(conditionalTableScrollPane);
            JPanel panel4 = new JPanel();
            panel4.setLayout(new BoxLayout(panel4, 1));
            JPanel panel41 = new JPanel();
            panel41.setLayout(new FlowLayout());
            this._status = new JLabel(" ");
            panel41.add(this._status);
            panel4.add(panel41);
            JPanel panel42 = new JPanel();
            panel42.setLayout(new FlowLayout());
            JButton newConditionalButton = new JButton(Bundle.getMessage("NewConditionalButton"));
            panel42.add(newConditionalButton);
            newConditionalButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ConditionalListEdit.this.newConditionalPressed(e);
                }
            });
            newConditionalButton.setToolTipText(Bundle.getMessage("NewConditionalButtonHint"));
            JButton reorderButton = new JButton(Bundle.getMessage("ReorderButton"));
            panel42.add(reorderButton);
            reorderButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ConditionalListEdit.this.reorderPressed(e);
                }
            });
            reorderButton.setToolTipText(Bundle.getMessage("ReorderButtonHint"));
            JButton calculateButton = new JButton(Bundle.getMessage("CalculateButton"));
            panel42.add(calculateButton);
            calculateButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ConditionalListEdit.this.calculatePressed(e);
                }
            });
            calculateButton.setToolTipText(Bundle.getMessage("CalculateButtonHint"));
            panel4.add(panel42);
            Border panel4Border = BorderFactory.createEtchedBorder();
            panel4.setBorder(panel4Border);
            contentPane.add(panel4);
            JPanel panel5 = new JPanel();
            panel5.setLayout(new FlowLayout());
            JButton done = new JButton(Bundle.getMessage("ButtonDone"));
            panel5.add(done);
            done.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ConditionalListEdit.this.donePressed(e);
                }
            });
            done.setToolTipText(Bundle.getMessage("DoneButtonHint"));
            JButton delete = new JButton(Bundle.getMessage("ButtonDelete"));
            panel5.add(delete);
            delete.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ConditionalListEdit.this.deletePressed(e);
                }
            });
            delete.setToolTipText(Bundle.getMessage("DeleteLogixButtonHint"));
            contentPane.add(panel5);
        }
        this._editLogixFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ConditionalListEdit.this.donePressed(null);
            }
        });
        this._editLogixFrame.pack();
        this._editLogixFrame.setVisible(true);
    }

    void newConditionalPressed(ActionEvent e) {
        if (this.checkEditConditional()) {
            return;
        }
        if (this._curLogix.getSystemName().equals(SensorGroupFrame.logixSysName)) {
            JmriJOptionPane.showMessageDialog(this._editLogixFrame, Bundle.getMessage("Warn8", "System Logix", SensorGroupFrame.logixSysName), Bundle.getMessage("WarningTitle"), 2);
            return;
        }
        this._curConditional = this.makeNewConditional(this._curLogix);
        this.makeEditConditionalWindow();
    }

    @Override
    void updateConditionalTableModel() {
        log.debug("updateConditionalTableModel");
        this._numConditionals = this._curLogix.getNumConditionals();
        this.conditionalTableModel.fireTableRowsInserted(this._numConditionals, this._numConditionals);
    }

    void editConditionalPressed(int rx) {
        if (this.checkEditConditional()) {
            return;
        }
        this._curConditional = this._conditionalManager.getBySystemName(this._curLogix.getConditionalByNumberOrder(rx));
        if (this._curConditional == null) {
            log.error("Attempted edit of non-existant conditional.");
            return;
        }
        this._conditionalRowNumber = rx;
        this.makeEditConditionalWindow();
    }

    void reorderPressed(ActionEvent e) {
        if (this.checkEditConditional()) {
            return;
        }
        this._showReminder = true;
        this._nextInOrder = 0;
        this._inReorderMode = true;
        this._status.setText(Bundle.getMessage("ReorderMessage"));
        this.conditionalTableModel.fireTableDataChanged();
    }

    void calculatePressed(ActionEvent e) {
        if (this.checkEditConditional()) {
            return;
        }
        if (this._numConditionals > 0) {
            String cName = "";
            Conditional c = null;
            for (int i = 0; i < this._numConditionals; ++i) {
                cName = this._curLogix.getConditionalByNumberOrder(i);
                if (cName != null) {
                    c = this._conditionalManager.getBySystemName(cName);
                    if (c == null) {
                        log.error("Invalid conditional system name when calculating - {}", (Object)cName);
                        continue;
                    }
                    c.calculate(false, null);
                    continue;
                }
                log.error("null conditional system name when calculating");
            }
            this.conditionalTableModel.fireTableDataChanged();
        }
    }

    void donePressed(ActionEvent e) {
        if (this.checkEditConditional()) {
            return;
        }
        if (this._curLogix.getSystemName().equals(SensorGroupFrame.logixSysName)) {
            this.finishDone();
            return;
        }
        String uName = this._editUserName.getText().trim();
        if (!uName.equals(this._curLogix.getUserName())) {
            Logix p;
            if (uName.length() > 0 && (p = this._logixManager.getByUserName(uName)) != null) {
                log.error("Failure to update Logix with Duplicate User Name: {}", (Object)uName);
                JmriJOptionPane.showMessageDialog(this._editLogixFrame, Bundle.getMessage("Error6"), Bundle.getMessage("ErrorTitle"), 0);
                return;
            }
            this.logixData.clear();
            this.logixData.put("chgUname", uName);
            this.fireLogixEvent();
        }
        this.finishDone();
    }

    void finishDone() {
        this.showSaveReminder();
        this._inEditMode = false;
        if (this._editLogixFrame != null) {
            this._editLogixFrame.setVisible(false);
            this._editLogixFrame.dispose();
            this._editLogixFrame = null;
        }
        this.logixData.clear();
        this.logixData.put("Finish", this._curLogix.getSystemName());
        this.fireLogixEvent();
    }

    void deletePressed(ActionEvent e) {
        if (this.checkEditConditional()) {
            return;
        }
        if (!this.checkConditionalReferences(this._curLogix.getSystemName())) {
            return;
        }
        this._showReminder = true;
        this.logixData.clear();
        this.logixData.put("Delete", this._curLogix.getSystemName());
        this.fireLogixEvent();
        this.finishDone();
    }

    void deleteConditionalPressed() {
        if (this._curConditional == null) {
            return;
        }
        String sName = this._curConditional.getSystemName();
        if (!this._newConditional) {
            this._showReminder = true;
            this._curConditional = null;
            --this._numConditionals;
            this.loadReferenceNames(this._conditionalFrame._variableList, this._oldTargetNames);
            String[] msgs = this._curLogix.deleteConditional(sName);
            if (msgs != null) {
                JmriJOptionPane.showMessageDialog(this._editLogixFrame, Bundle.getMessage("Error11", msgs), Bundle.getMessage("ErrorTitle"), 0);
            }
            this.conditionalTableModel.fireTableRowsDeleted(this._conditionalRowNumber, this._conditionalRowNumber);
            if (this._numConditionals < 1 && !this._suppressReminder) {
                JmriJOptionPane.showMessageDialog(this._editLogixFrame, Bundle.getMessage("Warn1"), Bundle.getMessage("WarningTitle"), 2);
            }
        }
        this._newConditional = false;
        if (this._pickTables != null) {
            this._pickTables.dispose();
            this._pickTables = null;
        }
        this.closeConditionalFrame();
    }

    boolean checkEditConditional() {
        if (this._conditionalFrame != null) {
            if (this._conditionalFrame._dataChanged) {
                JmriJOptionPane.showMessageDialog(this._conditionalFrame, Bundle.getMessage("Error34", this._curConditional.getSystemName()), Bundle.getMessage("ErrorTitle"), 0);
                return true;
            }
            this._conditionalFrame.cancelConditionalPressed();
        }
        return false;
    }

    void makeEditConditionalWindow() {
        this._curLogix.deActivateLogix();
        this._conditionalFrame = new ConditionalEditFrame(Bundle.getMessage("TitleEditConditional"), this._curConditional, this);
        this._oldTargetNames.clear();
        this.loadReferenceNames(this._conditionalFrame._variableList, this._oldTargetNames);
        this._conditionalFrame.pack();
        this._conditionalFrame.setVisible(true);
        InstanceManager.getDefault(PlaceWindow.class).nextTo(this._editLogixFrame, null, this._conditionalFrame);
    }

    @Override
    JPanel makeBottomPanel() {
        JPanel panel = new JPanel();
        JButton updateButton = new JButton(Bundle.getMessage("ButtonUpdate"));
        panel.add(updateButton);
        updateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConditionalListEdit.this._conditionalFrame.updateConditionalPressed(e);
            }
        });
        updateButton.setToolTipText(Bundle.getMessage("UpdateConditionalButtonHint"));
        JButton cancelButton = new JButton(Bundle.getMessage("ButtonCancel"));
        panel.add(cancelButton);
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConditionalListEdit.this._conditionalFrame.cancelConditionalPressed();
            }
        });
        cancelButton.setToolTipText(Bundle.getMessage("CancelConditionalButtonHint"));
        JButton deleteButton = new JButton(Bundle.getMessage("ButtonDelete"));
        panel.add(deleteButton);
        deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConditionalListEdit.this.deleteConditionalPressed();
            }
        });
        deleteButton.setToolTipText(Bundle.getMessage("DeleteConditionalButtonHint"));
        return panel;
    }

    @Override
    boolean updateConditional(String uName, Conditional.AntecedentOperator logicType, boolean trigger, String antecedent) {
        log.debug("updateConditional");
        return super.updateConditional(uName, this._curLogix, logicType, trigger, antecedent);
    }

    @Override
    void closeConditionalFrame() {
        log.debug("closeConditionalFrame()");
        this.conditionalTableModel.fireTableDataChanged();
        super.closeConditionalFrame(this._curLogix);
    }

    boolean checkConditionalUserName(String uName) {
        Conditional p;
        if (uName != null && !uName.equals("") && (p = this._conditionalManager.getByUserName(this._curLogix, uName)) != null) {
            log.error("Failure to update Conditional with Duplicate User Name: {}", (Object)uName);
            JmriJOptionPane.showMessageDialog(this._conditionalFrame, Bundle.getMessage("Error10"), Bundle.getMessage("ErrorTitle"), 0);
            return false;
        }
        return true;
    }

    void swapConditional(int row) {
        this._curLogix.swapConditional(this._nextInOrder, row);
        ++this._nextInOrder;
        if (this._nextInOrder >= this._numConditionals) {
            this._inReorderMode = false;
        }
        this.conditionalTableModel.fireTableDataChanged();
    }

    @Override
    protected String getClassName() {
        return ConditionalListEdit.class.getName();
    }

    public class ConditionalTableModel
    extends AbstractTableModel
    implements PropertyChangeListener {
        public static final int SNAME_COLUMN = 0;
        public static final int UNAME_COLUMN = 1;
        public static final int STATE_COLUMN = 2;
        public static final int BUTTON_COLUMN = 3;

        public ConditionalTableModel() {
            ConditionalListEdit.this._conditionalManager.addPropertyChangeListener(this);
            this.updateConditionalListeners();
        }

        synchronized void updateConditionalListeners() {
            int i;
            String sNam = "";
            Conditional c = null;
            ConditionalListEdit.this._numConditionals = ConditionalListEdit.this._curLogix.getNumConditionals();
            for (i = 0; i < ConditionalListEdit.this._numConditionals; ++i) {
                sNam = ConditionalListEdit.this._curLogix.getConditionalByNumberOrder(i);
                c = ConditionalListEdit.this._conditionalManager.getBySystemName(sNam);
                if (c == null) continue;
                c.removePropertyChangeListener(this);
            }
            for (i = 0; i < ConditionalListEdit.this._numConditionals; ++i) {
                sNam = ConditionalListEdit.this._curLogix.getConditionalByNumberOrder(i);
                c = ConditionalListEdit.this._conditionalManager.getBySystemName(sNam);
                if (c == null) continue;
                c.addPropertyChangeListener(this);
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            if (e.getPropertyName().equals("length")) {
                this.updateConditionalListeners();
                this.fireTableDataChanged();
            } else if (this.matchPropertyName(e)) {
                this.fireTableDataChanged();
            }
        }

        boolean matchPropertyName(PropertyChangeEvent e) {
            return e.getPropertyName().contains("State") || e.getPropertyName().contains("Appearance");
        }

        @Override
        public Class<?> getColumnClass(int c) {
            if (c == 3) {
                return JButton.class;
            }
            return String.class;
        }

        @Override
        public int getColumnCount() {
            return 4;
        }

        @Override
        public int getRowCount() {
            return ConditionalListEdit.this._numConditionals;
        }

        @Override
        public boolean isCellEditable(int r, int c) {
            if (!ConditionalListEdit.this._inReorderMode) {
                return c == 1 || c == 3;
            }
            if (c == 3) {
                return r >= ConditionalListEdit.this._nextInOrder;
            }
            return false;
        }

        @Override
        public String getColumnName(int col) {
            switch (col) {
                case 0: {
                    return Bundle.getMessage("ColumnSystemName");
                }
                case 1: {
                    return Bundle.getMessage("ColumnUserName");
                }
                case 3: {
                    return "";
                }
                case 2: {
                    return Bundle.getMessage("ColumnState");
                }
            }
            return "";
        }

        @SuppressFBWarnings(value={"DB_DUPLICATE_SWITCH_CLAUSES"}, justification="better to keep cases in column order rather than to combine")
        public int getPreferredWidth(int col) {
            switch (col) {
                case 0: 
                case 3: {
                    return new JTextField((int)6).getPreferredSize().width;
                }
                case 1: {
                    return new JTextField((int)17).getPreferredSize().width;
                }
                case 2: {
                    return new JTextField((int)12).getPreferredSize().width;
                }
            }
            return new JTextField((int)5).getPreferredSize().width;
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (row > ConditionalListEdit.this._numConditionals || ConditionalListEdit.this._curLogix == null) {
                return null;
            }
            switch (col) {
                case 3: {
                    if (!ConditionalListEdit.this._inReorderMode) {
                        return Bundle.getMessage("ButtonEdit");
                    }
                    if (ConditionalListEdit.this._nextInOrder == 0) {
                        return Bundle.getMessage("ButtonFirst");
                    }
                    if (ConditionalListEdit.this._nextInOrder <= row) {
                        return Bundle.getMessage("ButtonNext");
                    }
                    return Integer.toString(row + 1);
                }
                case 0: {
                    return ConditionalListEdit.this._curLogix.getConditionalByNumberOrder(row);
                }
                case 1: {
                    Conditional c = ConditionalListEdit.this._conditionalManager.getBySystemName(ConditionalListEdit.this._curLogix.getConditionalByNumberOrder(row));
                    if (c != null) {
                        return c.getUserName();
                    }
                    return "";
                }
                case 2: {
                    Conditional c = ConditionalListEdit.this._conditionalManager.getBySystemName(ConditionalListEdit.this._curLogix.getConditionalByNumberOrder(row));
                    if (c != null) {
                        int curState = c.getState();
                        if (curState == 4) {
                            return Bundle.getMessage("True");
                        }
                        if (curState == 2) {
                            return Bundle.getMessage("False");
                        }
                    }
                    return Bundle.getMessage("BeanStateUnknown");
                }
            }
            return Bundle.getMessage("BeanStateUnknown");
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            if (row > ConditionalListEdit.this._numConditionals || ConditionalListEdit.this._curLogix == null) {
                return;
            }
            if (col == 3) {
                if (ConditionalListEdit.this._inReorderMode) {
                    ConditionalListEdit.this.swapConditional(row);
                } else if (ConditionalListEdit.this._curLogix.getSystemName().equals(SensorGroupFrame.logixSysName)) {
                    JmriJOptionPane.showMessageDialog(ConditionalListEdit.this._conditionalFrame, Bundle.getMessage("Warn8", "System Logix", SensorGroupFrame.logixSysName), Bundle.getMessage("WarningTitle"), 2);
                } else {
                    class WindowMaker
                    implements Runnable {
                        private int _row;

                        WindowMaker(int r) {
                            this._row = r;
                        }

                        @Override
                        public void run() {
                            ConditionalListEdit.this.editConditionalPressed(this._row);
                        }
                    }
                    WindowMaker t = new WindowMaker(row);
                    SwingUtilities.invokeLater(t);
                }
            } else if (col == 1) {
                String uName = (String)value;
                Conditional cn = ConditionalListEdit.this._conditionalManager.getByUserName(ConditionalListEdit.this._curLogix, uName);
                if (cn == null) {
                    String sName = ConditionalListEdit.this._curLogix.getConditionalByNumberOrder(row);
                    Conditional cdl = ConditionalListEdit.this._conditionalManager.getBySystemName(sName);
                    if (cdl == null) {
                        log.error("No conditional {} while editing user name", (Object)sName);
                        return;
                    }
                    cdl.setUserName(uName);
                    this.fireTableRowsUpdated(row, row);
                    ArrayList<String> refList = InstanceManager.getDefault(ConditionalManager.class).getWhereUsed(sName);
                    if (refList != null) {
                        for (String ref : refList) {
                            Conditional cRef = ConditionalListEdit.this._conditionalManager.getBySystemName(ref);
                            if (cRef == null) continue;
                            List<ConditionalVariable> varList = cRef.getCopyOfStateVariables();
                            for (ConditionalVariable var : varList) {
                                if (!var.getName().equals(sName)) continue;
                                var.setGuiName(uName.length() > 0 ? uName : sName);
                            }
                            cRef.setStateVariables(varList);
                        }
                    }
                } else {
                    String svName = ConditionalListEdit.this._curLogix.getConditionalByNumberOrder(row);
                    if (cn != ConditionalListEdit.this._conditionalManager.getBySystemName(svName)) {
                        ConditionalListEdit.this.messageDuplicateConditionalUserName(cn.getSystemName());
                    }
                }
            }
        }
    }
}

