/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.consisttool;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.JComboBox;
import jmri.ConsistListListener;
import jmri.ConsistManager;
import jmri.InstanceManager;
import jmri.LocoAddress;
import jmri.jmrit.consisttool.Bundle;
import jmri.jmrit.consisttool.ConsistFile;
import jmri.jmrit.consisttool.ConsistListCellRenderer;
import jmri.util.LocoAddressComparator;
import org.jdom2.JDOMException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsistComboBox
extends JComboBox<Object>
implements ConsistListListener {
    ConsistManager consistManager = InstanceManager.getDefault(ConsistManager.class);
    private static boolean consistMgrInitFromXmlFile = false;
    private boolean isUpdatingList = false;
    private static final Logger log = LoggerFactory.getLogger(ConsistComboBox.class);

    public ConsistComboBox() {
        this.init();
    }

    private void init() {
        this.setToolTipText(Bundle.getMessage("ConsistAddressBoxToolTip"));
        this.initConsistList();
        this.setSelectedIndex(0);
        this.setRenderer(new ConsistListCellRenderer());
        this.consistManager.addConsistListListener(this);
        if (!consistMgrInitFromXmlFile) {
            try {
                new ConsistFile().readFile();
                consistMgrInitFromXmlFile = true;
            }
            catch (IOException | JDOMException e) {
                log.warn("error reading consist file: {}", (Object)e.getMessage());
            }
            consistMgrInitFromXmlFile = true;
        }
    }

    public void dispose() {
        this.consistManager.removeConsistListListener(this);
    }

    private void initConsistList() {
        if (this.isUpdatingList) {
            return;
        }
        this.isUpdatingList = true;
        Object selectedItem = this.getSelectedItem();
        int selectedIndex = this.getSelectedIndex();
        ArrayList<LocoAddress> existingConsists = this.consistManager.getConsistList();
        this.removeAllItems();
        if (!existingConsists.isEmpty()) {
            Collections.sort(existingConsists, new LocoAddressComparator());
            existingConsists.forEach(consist -> this.addItem(consist));
            this.setEnabled(true);
        } else {
            this.setEnabled(false);
        }
        this.insertItemAt(Bundle.getMessage("NoConsistSelected"), 0);
        if (selectedIndex > this.getItemCount() || selectedItem != this.getItemAt(selectedIndex)) {
            this.setSelectedIndex(0);
        } else {
            this.setSelectedIndex(selectedIndex);
        }
        this.isUpdatingList = false;
    }

    @Override
    protected void fireActionEvent() {
        if (!this.isUpdatingList) {
            super.fireActionEvent();
        }
    }

    @Override
    public void notifyConsistListChanged() {
        this.initConsistList();
    }
}

