/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.consisttool;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.NoSuchElementException;
import jmri.Consist;
import jmri.ConsistManager;
import jmri.DccLocoAddress;
import jmri.InstanceManager;
import jmri.LocoAddress;
import jmri.jmrit.XmlFile;
import jmri.jmrit.roster.Roster;
import jmri.util.FileUtil;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.ProcessingInstruction;
import org.jdom2.filter.ElementFilter;
import org.jdom2.filter.Filter;
import org.jdom2.util.IteratorIterable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsistFile
extends XmlFile
implements PropertyChangeListener {
    private static final String CONSIST = "consist";
    private static final String CONSISTID = "id";
    private static final String CONSISTNUMBER = "consistNumber";
    private static final String DCCLOCOADDRESS = "dccLocoAddress";
    private static final String LONGADDRESS = "longAddress";
    private static final String LOCODIR = "locoDir";
    private static final String LOCONAME = "locoName";
    private static final String LOCOROSTERID = "locoRosterId";
    private static final String NORMAL = "normal";
    private static final String REVERSE = "reverse";
    protected ConsistManager consistMan = InstanceManager.getDefault(ConsistManager.class);
    private static final Logger log = LoggerFactory.getLogger(ConsistFile.class);

    public ConsistFile() {
        Roster.getDefault().addPropertyChangeListener(this);
    }

    private void consistFromXml(Element consist) {
        DccLocoAddress consistAddress;
        Attribute cnumber = consist.getAttribute(CONSISTNUMBER);
        Attribute isCLong = consist.getAttribute(LONGADDRESS);
        if (isCLong != null) {
            log.debug("adding consist {} with longAddress set to {}.", (Object)cnumber, (Object)isCLong.getValue());
            try {
                int number = Integer.parseInt(cnumber.getValue());
                consistAddress = new DccLocoAddress(number, isCLong.getValue().equals("yes"));
            }
            catch (NumberFormatException e) {
                log.debug("Consist number not an integer");
                return;
            }
        } else {
            log.debug("adding consist {} with default long address setting.", (Object)cnumber);
            consistAddress = new DccLocoAddress(Integer.parseInt(cnumber.getValue()), false);
        }
        Consist newConsist = this.consistMan.getConsist(consistAddress);
        if (!newConsist.getConsistList().isEmpty()) {
            log.debug("Consist {} is not empty.  Using version in memory.", (Object)consistAddress);
            return;
        }
        this.readConsistType(consist, newConsist);
        this.readConsistId(consist, newConsist);
        this.readConsistLocoList(consist, newConsist);
        this.consistMan.notifyConsistListChanged();
    }

    public void readConsistLocoList(Element consist, Consist newConsist) {
        IteratorIterable childIterator = consist.getDescendants((Filter)new ElementFilter("loco"));
        try {
            while (true) {
                Element e = (Element)childIterator.next();
                Attribute number = e.getAttribute(DCCLOCOADDRESS);
                log.debug("adding Loco {}", (Object)number);
                DccLocoAddress address = this.readLocoAddress(e);
                Attribute direction = e.getAttribute(LOCODIR);
                boolean directionNormal = false;
                if (direction != null) {
                    log.debug("using direction from file {}", (Object)direction.getValue());
                    directionNormal = direction.getValue().equals(NORMAL);
                } else {
                    directionNormal = true;
                }
                newConsist.restore(address, directionNormal);
                this.readLocoPosition(e, address, newConsist);
                Attribute rosterId = e.getAttribute(LOCOROSTERID);
                if (rosterId == null) continue;
                newConsist.setRosterId(address, rosterId.getValue());
            }
        }
        catch (NoSuchElementException nse) {
            log.debug("end of loco list");
            return;
        }
    }

    private void readConsistType(Element consist, Consist newConsist) {
        Attribute type = consist.getAttribute("type");
        if (type != null) {
            newConsist.setConsistType(type.getValue().equals("CSAC") ? 1 : 0);
        } else {
            newConsist.setConsistType(0);
        }
    }

    private void readConsistId(Element consist, Consist newConsist) {
        Attribute cID = consist.getAttribute(CONSISTID);
        if (cID != null) {
            newConsist.setConsistID(cID.getValue());
        }
    }

    private void readLocoPosition(Element loco, DccLocoAddress address, Consist newConsist) {
        Attribute position = loco.getAttribute(LOCONAME);
        if (position != null && !position.getValue().equals("mid")) {
            if (position.getValue().equals("lead")) {
                newConsist.setPosition(address, 0);
            } else if (position.getValue().equals("rear")) {
                newConsist.setPosition(address, 255);
            }
        } else {
            Attribute midNumber = loco.getAttribute("locoMidNumber");
            if (midNumber != null) {
                int pos = Integer.parseInt(midNumber.getValue());
                newConsist.setPosition(address, pos);
            }
        }
    }

    private DccLocoAddress readLocoAddress(Element loco) {
        Attribute number = loco.getAttribute(DCCLOCOADDRESS);
        Attribute isLong = loco.getAttribute(LONGADDRESS);
        DccLocoAddress address = isLong != null ? new DccLocoAddress(Integer.parseInt(number.getValue()), isLong.getValue().equals("yes")) : new DccLocoAddress(Integer.parseInt(number.getValue()), true);
        return address;
    }

    private Element consistToXml(Consist consist) {
        Element e = new Element(CONSIST);
        e.setAttribute(CONSISTID, consist.getConsistID());
        e.setAttribute(CONSISTNUMBER, "" + consist.getConsistAddress().getNumber());
        e.setAttribute(LONGADDRESS, consist.getConsistAddress().isLongAddress() ? "yes" : "no");
        e.setAttribute("type", consist.getConsistType() == 0 ? "DAC" : "CSAC");
        ArrayList<DccLocoAddress> addressList = consist.getConsistList();
        for (int i = 0; i < addressList.size(); ++i) {
            DccLocoAddress locoaddress = addressList.get(i);
            Element eng = new Element("loco");
            eng.setAttribute(DCCLOCOADDRESS, "" + locoaddress.getNumber());
            eng.setAttribute(LONGADDRESS, locoaddress.isLongAddress() ? "yes" : "no");
            eng.setAttribute(LOCODIR, consist.getLocoDirection(locoaddress) ? NORMAL : REVERSE);
            int position = consist.getPosition(locoaddress);
            switch (position) {
                case 0: {
                    eng.setAttribute(LOCONAME, "lead");
                    break;
                }
                case 255: {
                    eng.setAttribute(LOCONAME, "rear");
                    break;
                }
                default: {
                    eng.setAttribute(LOCONAME, "mid");
                    eng.setAttribute("locoMidNumber", "" + position);
                }
            }
            String rosterId = consist.getRosterId(locoaddress);
            if (rosterId != null) {
                eng.setAttribute(LOCOROSTERID, rosterId);
            }
            e.addContent((Content)eng);
        }
        return e;
    }

    public void readFile() throws JDOMException, IOException {
        this.readFile(ConsistFile.defaultConsistFilename());
    }

    public void readFile(String fileName) throws JDOMException, IOException {
        if (this.checkFile(fileName)) {
            Element root = this.rootFromName(fileName);
            if (root == null) {
                log.warn("consist file could not be read");
                return;
            }
            Element roster = root.getChild("roster");
            if (roster == null) {
                log.debug("consist file does not contain a roster entry");
                return;
            }
            IteratorIterable consistIterator = root.getDescendants((Filter)new ElementFilter(CONSIST));
            try {
                do {
                    Element consist = (Element)consistIterator.next();
                    this.consistFromXml(consist);
                } while (consistIterator.hasNext());
            }
            catch (NoSuchElementException nde) {
                log.debug("end of consist list");
            }
        } else {
            log.info("Consist file does not exist.  One will be created if necessary.");
        }
    }

    public void writeFile(List<LocoAddress> consistList) throws IOException {
        this.writeFile(consistList, ConsistFile.defaultConsistFilename());
    }

    public void writeFile(List<LocoAddress> consistList, String fileName) throws IOException {
        Element root = new Element("consist-roster-config");
        Document doc = ConsistFile.newDocument(root, this.dtdLocation + "consist-roster-config.dtd");
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("type", "text/xsl");
        m.put("href", "/xml/XSLT/consistRoster.xsl");
        ProcessingInstruction p = new ProcessingInstruction("xml-stylesheet", m);
        doc.addContent(0, (Content)p);
        Element roster = new Element("roster");
        for (int i = 0; i < consistList.size(); ++i) {
            Consist newConsist = this.consistMan.getConsist(consistList.get(i));
            roster.addContent((Content)this.consistToXml(newConsist));
        }
        root.addContent((Content)roster);
        if (!this.checkFile(fileName)) {
            File file = new File(fileName);
            File parentDir = file.getParentFile();
            FileUtil.createDirectory(parentDir);
            if (!file.createNewFile()) {
                throw new IOException();
            }
        }
        this.writeXML(this.findFile(fileName), doc);
    }

    public static String getFileLocation() {
        return Roster.getDefault().getRosterFilesLocation() + CONSIST + File.separator;
    }

    public static String defaultConsistFilename() {
        return ConsistFile.getFileLocation() + "consist.xml";
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource() instanceof Roster && evt.getPropertyName().equals("directory")) {
            try {
                this.writeFile(this.consistMan.getConsistList());
            }
            catch (IOException ioe) {
                log.error("Unable to write consist information to new consist folder");
            }
        }
    }
}

