/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.consisttool;

import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import jmri.Consist;
import jmri.ConsistManager;
import jmri.DccLocoAddress;
import jmri.InstanceManager;
import jmri.LocoAddress;
import jmri.jmrit.roster.RosterIconFactory;
import jmri.util.gui.GuiLafPreferencesManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsistListCellRenderer
extends JLabel
implements ListCellRenderer<Object> {
    private static final int IMAGE_HEIGHT = 19;
    private static final Logger log = LoggerFactory.getLogger(ConsistListCellRenderer.class);

    @Override
    public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            this.setText((String)value);
            this.setIcon(null);
            return this;
        }
        if (value instanceof LocoAddress) {
            LocoAddress consistAddress = (LocoAddress)value;
            this.setText(consistAddress.toString());
            BufferedImage bi = new BufferedImage(1, 19, 2);
            Consist consist = InstanceManager.getDefault(ConsistManager.class).getConsist(consistAddress);
            Font f = new Font("Monospaced", 0, InstanceManager.getDefault(GuiLafPreferencesManager.class).getFontSize());
            for (DccLocoAddress loco : consist.getConsistList()) {
                BufferedImage ti;
                log.debug("Loco : {} - Position : {}", (Object)loco, (Object)consist.getPosition(loco));
                String reName = consist.getRosterId(loco);
                String label = null;
                if (reName != null) {
                    Boolean dir = consist.getLocoDirection(loco);
                    ImageIcon icon = dir != false ? InstanceManager.getDefault(RosterIconFactory.class).getIcon(reName) : InstanceManager.getDefault(RosterIconFactory.class).getReversedIcon(reName);
                    if (icon != null && bi.getWidth() + icon.getIconWidth() > 0) {
                        ti = new BufferedImage(bi.getWidth() + icon.getIconWidth(), 19, 2);
                        Graphics2D g = ti.createGraphics();
                        g.drawImage(icon.getImage(), ti.getHeight() / 2 - icon.getIconHeight() / 2, 0, null);
                        g.drawImage((Image)bi, icon.getIconWidth(), 0, null);
                        g.dispose();
                        bi = ti;
                    } else {
                        label = "[" + reName + "]";
                    }
                } else {
                    label = "[" + loco.toString() + "]";
                }
                if (label == null) continue;
                BufferedImage li = new BufferedImage(label.length() * f.getSize(), 19, 2);
                Graphics2D gli = li.createGraphics();
                gli.setFont(f);
                gli.setColor(this.getForeground());
                ((Graphics)gli).drawString(label, 0, 9 + gli.getFontMetrics().getMaxAscent() / 2);
                ti = new BufferedImage(gli.getFontMetrics().stringWidth(label) + bi.getWidth() + 2, 19, 2);
                Graphics2D gti = ti.createGraphics();
                gti.drawImage((Image)li, 0, 0, null);
                gti.drawImage((Image)bi, gli.getFontMetrics().stringWidth(label) + 2, 0, null);
                bi = ti;
                gli.dispose();
                gti.dispose();
            }
            this.setIcon(new ImageIcon(bi));
        }
        return this;
    }
}

