/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.ctc;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import jmri.InstanceManager;
import jmri.jmrit.ctc.CTCExceptionBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SuppressFBWarnings(value={"SLF4J_FORMAT_SHOULD_BE_CONST"}, justification="Logging Strings provided by calling classes.")
public class CTCException
extends Exception {
    private final String _mModule;
    private final String _mUserIdentifier;
    private final String _mParameter;
    private final String _mReason;
    private static final CTCExceptionBuffer _ctcExceptionBuffer = InstanceManager.getDefault(CTCExceptionBuffer.class);
    private static final Logger log = LoggerFactory.getLogger(CTCException.class);

    public CTCException(String module, String userIdentifier, String parameter, String reason) {
        this._mModule = module;
        this._mUserIdentifier = userIdentifier;
        this._mParameter = parameter;
        this._mReason = reason;
    }

    public String getExceptionString() {
        return this._mModule + ", " + this._mUserIdentifier + this._mParameter + ", " + this._mReason;
    }

    public void logError() {
        CTCException.logError(this.getExceptionString());
    }

    public void logWarning() {
        CTCException.logWarning(this.getExceptionString());
    }

    public static void logError(String string) {
        log.error(string);
        _ctcExceptionBuffer.logString(CTCExceptionBuffer.ExceptionBufferRecordSeverity.ERROR, string);
    }

    public static void logWarning(String string) {
        log.warn(string);
        _ctcExceptionBuffer.logString(CTCExceptionBuffer.ExceptionBufferRecordSeverity.WARN, string);
    }

    public static void logInfo(String string) {
        log.info(string);
        _ctcExceptionBuffer.logString(CTCExceptionBuffer.ExceptionBufferRecordSeverity.INFO, string);
    }
}

