/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.ctc;

import java.util.ArrayList;
import java.util.HashSet;
import jmri.Block;
import jmri.NamedBeanHandle;
import jmri.Sensor;
import jmri.jmrit.ctc.Bundle;
import jmri.jmrit.ctc.CTCException;
import jmri.jmrit.ctc.LockedRoutesManager;
import jmri.jmrit.ctc.NBHSensor;
import jmri.jmrit.ctc.NBHSignal;
import jmri.jmrit.ctc.SignalDirectionIndicatorsInterface;
import jmri.jmrit.ctc.SwitchIndicatorsRoute;
import jmri.jmrit.ctc.TrafficLockingInfo;
import jmri.jmrit.ctc.ctcserialdata.CallOnData;
import jmri.jmrit.ctc.ctcserialdata.OtherData;

public class CallOn {
    private final LockedRoutesManager _mLockedRoutesManager;
    private final boolean _mSignalHeadSelected;
    private final NBHSensor _mCallOnToggleSensor;
    private final ArrayList<GroupingData> _mGroupingDataArrayList = new ArrayList();

    public CallOn(LockedRoutesManager lockedRoutesManager, String userIdentifier, NBHSensor callOnToggleSensor, ArrayList<CallOnData> groupingsList, OtherData.SIGNAL_SYSTEM_TYPE signalSystemType) {
        this._mLockedRoutesManager = lockedRoutesManager;
        this._mSignalHeadSelected = signalSystemType == OtherData.SIGNAL_SYSTEM_TYPE.SIGNALHEAD;
        this._mCallOnToggleSensor = callOnToggleSensor;
        for (CallOnData callOnData : groupingsList) {
            try {
                NBHSignal signal = callOnData._mExternalSignal;
                String trafficDirection = callOnData._mSignalFacingDirection;
                if (!trafficDirection.equals(Bundle.getMessage("InfoDlgCOLeftTraffic")) && !trafficDirection.equals(Bundle.getMessage("InfoDlgCORightTraffic"))) {
                    throw new CTCException("CallOn", userIdentifier, "groupingString", callOnData.toString() + " not " + Bundle.getMessage("InfoDlgCOLeftTraffic") + " or " + Bundle.getMessage("InfoDlgCORightTraffic") + ".");
                }
                SwitchIndicatorsRoute route = new SwitchIndicatorsRoute(callOnData._mSwitchIndicators);
                if (this._mSignalHeadSelected) {
                    String[] validStateNames = signal.getValidStateNames();
                    int validStateNamesIndex = CallOn.arrayFind(validStateNames, this.convertFromForeignLanguageColor(callOnData._mSignalAspectToDisplay));
                    if (validStateNamesIndex == -1) {
                        throw new CTCException("CallOn", userIdentifier, "groupingString", callOnData.toString() + " " + Bundle.getMessage("CallOnNotValidAspect"));
                    }
                    NBHSensor calledOnExternalSensor = callOnData._mCalledOnExternalSensor;
                    int[] correspondingValidStates = signal.getValidStates();
                    this._mGroupingDataArrayList.add(new GroupingData(signal, trafficDirection, correspondingValidStates[validStateNamesIndex], calledOnExternalSensor, null, route));
                    continue;
                }
                NamedBeanHandle<Block> externalBlock = callOnData._mExternalBlock;
                this._mGroupingDataArrayList.add(new GroupingData(signal, trafficDirection, 0, null, externalBlock, route));
            }
            catch (CTCException e) {
                e.logError();
                return;
            }
        }
        this.resetToggle();
    }

    public void removeAllListeners() {
    }

    public void resetToggle() {
        this._mCallOnToggleSensor.setKnownState(4);
    }

    public TrafficLockingInfo codeButtonPressed(HashSet<Sensor> sensors, String userIdentifier, SignalDirectionIndicatorsInterface signalDirectionIndicatorsObject, int signalDirectionLever) {
        if (this._mCallOnToggleSensor.getKnownState() == 4) {
            return new TrafficLockingInfo(false);
        }
        if (signalDirectionLever != 0 && signalDirectionLever != 2) {
            return new TrafficLockingInfo(false);
        }
        GroupingData foundGroupingData = null;
        int ruleNumber = 0;
        for (GroupingData groupingData : this._mGroupingDataArrayList) {
            ++ruleNumber;
            if (groupingData._mSignalHeadFaces != signalDirectionLever || !groupingData._mRoute.isRouteSelected()) continue;
            foundGroupingData = groupingData;
            break;
        }
        TrafficLockingInfo returnValue = new TrafficLockingInfo(true);
        if (foundGroupingData == null) {
            return returnValue;
        }
        if (this._mSignalHeadSelected) {
            if (2 != foundGroupingData._mCalledOnExternalSensor.getKnownState()) {
                return returnValue;
            }
            if (foundGroupingData._mCalledOnExternalSensor.valid()) {
                sensors.add(foundGroupingData._mCalledOnExternalSensor.getBean());
            }
            returnValue._mLockedRoute = this._mLockedRoutesManager.checkRouteAndAllocateIfAvailable(sensors, userIdentifier, "Rule #" + ruleNumber, signalDirectionLever == 2);
            if (returnValue._mLockedRoute == null) {
                return returnValue;
            }
            foundGroupingData._mSignal.setHeld(false);
            foundGroupingData._mSignal.setAppearance(foundGroupingData._mCallOnAspect);
        } else {
            NBHSensor sensor = new NBHSensor(foundGroupingData._mNamedBeanHandleBlock.getBean().getNamedSensor());
            if (2 != sensor.getKnownState()) {
                return returnValue;
            }
            if (sensor.valid()) {
                sensors.add(sensor.getBean());
            }
            returnValue._mLockedRoute = this._mLockedRoutesManager.checkRouteAndAllocateIfAvailable(sensors, userIdentifier, "Rule #" + ruleNumber, signalDirectionLever == 2);
            if (returnValue._mLockedRoute == null) {
                return returnValue;
            }
            foundGroupingData._mSignal.allowPermissiveSML();
            foundGroupingData._mSignal.setHeld(false);
        }
        signalDirectionIndicatorsObject.setRequestedDirection(signalDirectionLever);
        signalDirectionIndicatorsObject.setSignalDirectionIndicatorsToOUTOFCORRESPONDENCE();
        signalDirectionIndicatorsObject.startCodingTime();
        return returnValue;
    }

    private static int arrayFind(String[] array, String aString) {
        for (int index = 0; index < array.length; ++index) {
            if (!aString.equals(array[index])) continue;
            return index;
        }
        return -1;
    }

    private String convertFromForeignLanguageColor(String foreignLanguageColor) {
        String color = "Red";
        if (foreignLanguageColor.equals(Bundle.getMessage("SignalHeadStateDark"))) {
            color = "Dark";
        }
        if (foreignLanguageColor.equals(Bundle.getMessage("SignalHeadStateRed"))) {
            color = "Red";
        }
        if (foreignLanguageColor.equals(Bundle.getMessage("SignalHeadStateYellow"))) {
            color = "Yellow";
        }
        if (foreignLanguageColor.equals(Bundle.getMessage("SignalHeadStateGreen"))) {
            color = "Green";
        }
        if (foreignLanguageColor.equals(Bundle.getMessage("SignalHeadStateFlashingRed"))) {
            color = "Flashing Red";
        }
        if (foreignLanguageColor.equals(Bundle.getMessage("SignalHeadStateFlashingYellow"))) {
            color = "Flashing Yellow";
        }
        if (foreignLanguageColor.equals(Bundle.getMessage("SignalHeadStateFlashingGreen"))) {
            color = "Flashing Green";
        }
        if (foreignLanguageColor.equals(Bundle.getMessage("SignalHeadStateLunar"))) {
            color = "Lunar";
        }
        if (foreignLanguageColor.equals(Bundle.getMessage("SignalHeadStateFlashingLunar"))) {
            color = "Flashing Lunar";
        }
        return color;
    }

    private static class GroupingData {
        public final NBHSignal _mSignal;
        public final int _mSignalHeadFaces;
        public final int _mCallOnAspect;
        public final NBHSensor _mCalledOnExternalSensor;
        public final NamedBeanHandle<Block> _mNamedBeanHandleBlock;
        public final SwitchIndicatorsRoute _mRoute;

        public GroupingData(NBHSignal signal, String signalHeadFaces, int callOnAspect, NBHSensor calledOnExternalSensor, NamedBeanHandle<Block> namedBeanHandleBlock, SwitchIndicatorsRoute route) {
            this._mSignal = signal;
            this._mSignalHeadFaces = signalHeadFaces.equals(Bundle.getMessage("InfoDlgCOLeftTraffic")) ? 0 : 2;
            this._mCallOnAspect = callOnAspect;
            this._mCalledOnExternalSensor = calledOnExternalSensor;
            this._mNamedBeanHandleBlock = namedBeanHandleBlock;
            this._mRoute = route;
        }
    }
}

