/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.ctc;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashSet;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.Sensor;
import jmri.jmrit.ctc.CallOn;
import jmri.jmrit.ctc.CodeButtonSimulator;
import jmri.jmrit.ctc.Fleeting;
import jmri.jmrit.ctc.IndicationLockingSignals;
import jmri.jmrit.ctc.LockedRoute;
import jmri.jmrit.ctc.LockedRoutesManager;
import jmri.jmrit.ctc.NBHSensor;
import jmri.jmrit.ctc.SignalDirectionIndicatorsInterface;
import jmri.jmrit.ctc.SignalDirectionLever;
import jmri.jmrit.ctc.SwitchDirectionIndicators;
import jmri.jmrit.ctc.SwitchDirectionLever;
import jmri.jmrit.ctc.TrafficLocking;
import jmri.jmrit.ctc.TrafficLockingInfo;
import jmri.jmrit.ctc.TurnoutLock;
import org.slf4j.LoggerFactory;

public class CodeButtonHandler {
    private final boolean _mTurnoutLockingOnlyEnabled;
    private final LockedRoutesManager _mLockedRoutesManager;
    private final String _mUserIdentifier;
    private final int _mUniqueID;
    private final NBHSensor _mCodeButtonInternalSensor;
    private final PropertyChangeListener _mCodeButtonInternalSensorPropertyChangeListener;
    private final NBHSensor _mOSSectionOccupiedExternalSensor;
    private final NBHSensor _mOSSectionOccupiedExternalSensor2;
    private final PropertyChangeListener _mOSSectionOccupiedExternalSensorPropertyChangeListener;
    private final SignalDirectionIndicatorsInterface _mSignalDirectionIndicators;
    private final SignalDirectionLever _mSignalDirectionLever;
    private final SwitchDirectionIndicators _mSwitchDirectionIndicators;
    private final SwitchDirectionLever _mSwitchDirectionLever;
    private final Fleeting _mFleeting;
    private final CallOn _mCallOn;
    private final TrafficLocking _mTrafficLocking;
    private final TurnoutLock _mTurnoutLock;
    private final IndicationLockingSignals _mIndicationLockingSignals;
    private final CodeButtonSimulator _mCodeButtonSimulator;
    private LockedRoute _mLockedRoute = null;
    private static final Sensor _mPreconditioningEnabledSensor = CodeButtonHandler.initializePreconditioningEnabledSensor();
    private PreconditioningData _mPreconditioningData = new PreconditioningData();

    private static Sensor initializePreconditioningEnabledSensor() {
        Sensor returnValue = InstanceManager.sensorManagerInstance().newSensor("IS:PRECONDITIONING_ENABLED", null);
        int knownState = returnValue.getKnownState();
        if (2 != knownState && 4 != knownState) {
            try {
                returnValue.setKnownState(4);
            }
            catch (JmriException ex) {
                LoggerFactory.getLogger(CodeButtonHandler.class).debug("Sensor problem, preconditioning won't work.");
            }
        }
        return returnValue;
    }

    public CodeButtonHandler(boolean turnoutLockingOnlyEnabled, LockedRoutesManager lockedRoutesManager, String userIdentifier, int uniqueID, NBHSensor codeButtonInternalSensor, int codeButtonDelayInMilliseconds, NBHSensor osSectionOccupiedExternalSensor, NBHSensor osSectionOccupiedExternalSensor2, SignalDirectionIndicatorsInterface signalDirectionIndicators, SignalDirectionLever signalDirectionLever, SwitchDirectionIndicators switchDirectionIndicators, SwitchDirectionLever switchDirectionLever, Fleeting fleeting, CallOn callOn, TrafficLocking trafficLocking, TurnoutLock turnoutLock, IndicationLockingSignals indicationLockingSignals) {
        signalDirectionIndicators.setCodeButtonHandler(this);
        this._mTurnoutLockingOnlyEnabled = turnoutLockingOnlyEnabled;
        this._mLockedRoutesManager = lockedRoutesManager;
        this._mUserIdentifier = userIdentifier;
        this._mUniqueID = uniqueID;
        this._mSignalDirectionIndicators = signalDirectionIndicators;
        this._mSignalDirectionLever = signalDirectionLever;
        this._mSwitchDirectionIndicators = switchDirectionIndicators;
        this._mSwitchDirectionLever = switchDirectionLever;
        this._mFleeting = fleeting;
        this._mCallOn = callOn;
        this._mTrafficLocking = trafficLocking;
        this._mTurnoutLock = turnoutLock;
        this._mIndicationLockingSignals = indicationLockingSignals;
        this._mCodeButtonInternalSensor = codeButtonInternalSensor;
        this._mCodeButtonInternalSensor.setKnownState(4);
        this._mCodeButtonInternalSensorPropertyChangeListener = e -> this.codeButtonStateChange(e);
        this._mCodeButtonInternalSensor.addPropertyChangeListener(this._mCodeButtonInternalSensorPropertyChangeListener);
        this._mOSSectionOccupiedExternalSensorPropertyChangeListener = e -> this.osSectionPropertyChangeEvent(e);
        this._mOSSectionOccupiedExternalSensor = osSectionOccupiedExternalSensor;
        this._mOSSectionOccupiedExternalSensor.addPropertyChangeListener(this._mOSSectionOccupiedExternalSensorPropertyChangeListener);
        this._mOSSectionOccupiedExternalSensor2 = osSectionOccupiedExternalSensor2;
        this._mCodeButtonSimulator = codeButtonDelayInMilliseconds > 0 ? new CodeButtonSimulator(codeButtonDelayInMilliseconds, this._mCodeButtonInternalSensor, this._mSwitchDirectionLever, this._mSignalDirectionLever, this._mTurnoutLock) : null;
    }

    public void removeAllListeners() {
        this._mCodeButtonInternalSensor.removePropertyChangeListener(this._mCodeButtonInternalSensorPropertyChangeListener);
        this._mOSSectionOccupiedExternalSensor.removePropertyChangeListener(this._mOSSectionOccupiedExternalSensorPropertyChangeListener);
        if (this._mSignalDirectionIndicators != null) {
            this._mSignalDirectionIndicators.removeAllListeners();
        }
        if (this._mSignalDirectionLever != null) {
            this._mSignalDirectionLever.removeAllListeners();
        }
        if (this._mSwitchDirectionIndicators != null) {
            this._mSwitchDirectionIndicators.removeAllListeners();
        }
        if (this._mSwitchDirectionLever != null) {
            this._mSwitchDirectionLever.removeAllListeners();
        }
        if (this._mFleeting != null) {
            this._mFleeting.removeAllListeners();
        }
        if (this._mCallOn != null) {
            this._mCallOn.removeAllListeners();
        }
        if (this._mTrafficLocking != null) {
            this._mTrafficLocking.removeAllListeners();
        }
        if (this._mTurnoutLock != null) {
            this._mTurnoutLock.removeAllListeners();
        }
        if (this._mIndicationLockingSignals != null) {
            this._mIndicationLockingSignals.removeAllListeners();
        }
        if (this._mCodeButtonSimulator != null) {
            this._mCodeButtonSimulator.removeAllListeners();
        }
    }

    public void cancelLockedRoute() {
        this._mLockedRoutesManager.cancelLockedRoute(this._mLockedRoute);
        this._mLockedRoute = null;
    }

    public boolean uniqueIDMatches(int uniqueID) {
        return this._mUniqueID == uniqueID;
    }

    public NBHSensor getOSSectionOccupiedExternalSensor() {
        return this._mOSSectionOccupiedExternalSensor;
    }

    private void osSectionPropertyChangeEvent(PropertyChangeEvent e) {
        if (this.isPrimaryOSSectionOccupied()) {
            if (this._mFleeting != null && !this._mFleeting.isFleetingEnabled()) {
                this._mSignalDirectionIndicators.forceAllSignalsToHeld();
            }
            this._mSignalDirectionIndicators.osSectionBecameOccupied();
        } else if (this._mPreconditioningData._mCodeButtonPressed) {
            this.doCodeButtonPress();
            this._mPreconditioningData._mCodeButtonPressed = false;
        }
    }

    public void externalLockTurnout() {
        if (this._mTurnoutLock != null) {
            this._mTurnoutLock.externalLockTurnout();
        }
    }

    private void codeButtonStateChange(PropertyChangeEvent e) {
        if (e.getPropertyName().equals("KnownState") && (Integer)e.getNewValue() == 2) {
            if (this.isPrimaryOSSectionOccupied() && 2 == _mPreconditioningEnabledSensor.getKnownState()) {
                this._mPreconditioningData._mSignalDirectionLeverWas = this.getCurrentSignalDirectionLever(false);
                this._mPreconditioningData._mSwitchDirectionLeverWas = this.getSwitchDirectionLeverRequestedState(false);
                this._mPreconditioningData._mCodeButtonPressed = true;
            }
            this.doCodeButtonPress();
        }
    }

    private void doCodeButtonPress() {
        if (this._mSignalDirectionIndicators.isRunningTime()) {
            return;
        }
        this.possiblyAllowLockChange();
        this.possiblyAllowTurnoutChange();
        if (!this.possiblyAllowCallOn()) {
            this.possiblyAllowSignalDirectionChange();
        }
    }

    private boolean possiblyAllowCallOn() {
        boolean returnStatus = false;
        if (this.allowCallOnChange()) {
            HashSet<Sensor> sensors = new HashSet<Sensor>();
            sensors.add(this._mOSSectionOccupiedExternalSensor.getBean());
            if (this._mSwitchDirectionIndicators != null && this._mSwitchDirectionIndicators.getLastIndicatorState() == 1 && this._mOSSectionOccupiedExternalSensor2.valid()) {
                sensors.add(this._mOSSectionOccupiedExternalSensor2.getBean());
            }
            TrafficLockingInfo trafficLockingInfo = this._mCallOn.codeButtonPressed(sensors, this._mUserIdentifier, this._mSignalDirectionIndicators, this.getCurrentSignalDirectionLever(false));
            if (trafficLockingInfo._mLockedRoute != null) {
                this._mLockedRoute = trafficLockingInfo._mLockedRoute;
            }
            returnStatus = trafficLockingInfo._mReturnStatus;
        }
        if (this._mCallOn != null) {
            this._mCallOn.resetToggle();
        }
        return returnStatus;
    }

    private boolean allowCallOnChange() {
        if (this._mCallOn == null) {
            return false;
        }
        if (this.isPrimaryOSSectionOccupied()) {
            return false;
        }
        if (this._mSignalDirectionIndicators.isRunningTime()) {
            return false;
        }
        if (this._mSignalDirectionIndicators.getSignalsInTheFieldDirection() != 1) {
            return false;
        }
        return this.areOSSensorsAvailableInRoutes();
    }

    private int getCurrentSignalDirectionLever(boolean allowMergeInPreconditioning) {
        if (this._mSignalDirectionLever == null) {
            return 3;
        }
        if (allowMergeInPreconditioning && this._mPreconditioningData._mCodeButtonPressed && (this._mPreconditioningData._mSignalDirectionLeverWas == 0 || this._mPreconditioningData._mSignalDirectionLeverWas == 2)) {
            return this._mPreconditioningData._mSignalDirectionLeverWas;
        }
        return this._mSignalDirectionLever.getPresentSignalDirectionLeverState();
    }

    private void possiblyAllowTurnoutChange() {
        if (this.allowTurnoutChange()) {
            int requestedState = this.getSwitchDirectionLeverRequestedState(true);
            this.notifyTurnoutLockObjectOfNewAlignment(requestedState);
            if (this._mSwitchDirectionIndicators != null) {
                this._mSwitchDirectionIndicators.codeButtonPressed(requestedState);
            }
        }
    }

    private boolean allowTurnoutChange() {
        if (!this._mSignalDirectionIndicators.signalsNormal()) {
            return false;
        }
        if (this.routeClearedAcross()) {
            return false;
        }
        if (this.isEitherOSSectionOccupied()) {
            return false;
        }
        if (!this.switchDirectionIndicatorsInCorrespondence()) {
            return false;
        }
        if (!this.turnoutPresentlyLocked()) {
            return false;
        }
        return this.areOSSensorsAvailableInRoutes();
    }

    private void notifyTurnoutLockObjectOfNewAlignment(int requestedState) {
        if (this._mTurnoutLock != null) {
            this._mTurnoutLock.dispatcherCommandedState(requestedState);
        }
    }

    private int getSwitchDirectionLeverRequestedState(boolean allowMergeInPreconditioning) {
        if (this._mSwitchDirectionLever == null) {
            return 3;
        }
        if (allowMergeInPreconditioning && this._mPreconditioningData._mCodeButtonPressed && (this._mPreconditioningData._mSwitchDirectionLeverWas == 0 || this._mPreconditioningData._mSwitchDirectionLeverWas == 1)) {
            return this._mPreconditioningData._mSwitchDirectionLeverWas;
        }
        return this._mSwitchDirectionLever.getPresentState();
    }

    private boolean switchDirectionIndicatorsInCorrespondence() {
        if (this._mSwitchDirectionIndicators != null) {
            return this._mSwitchDirectionIndicators.inCorrespondence();
        }
        return true;
    }

    private void possiblyAllowSignalDirectionChange() {
        if (this.allowSignalDirectionChangePart1()) {
            int presentSignalDirectionIndicatorsDirection;
            boolean requestedChangeInSignalDirection;
            int presentSignalDirectionLever = this.getCurrentSignalDirectionLever(true);
            boolean bl = requestedChangeInSignalDirection = presentSignalDirectionLever != (presentSignalDirectionIndicatorsDirection = this._mSignalDirectionIndicators.getPresentDirection());
            if (presentSignalDirectionLever != 1 && !requestedChangeInSignalDirection) {
                return;
            }
            if (presentSignalDirectionLever == 0 && presentSignalDirectionIndicatorsDirection == 2) {
                presentSignalDirectionLever = 1;
            } else if (presentSignalDirectionLever == 2 && presentSignalDirectionIndicatorsDirection == 0) {
                presentSignalDirectionLever = 1;
            }
            if (this.allowSignalDirectionChangePart2(presentSignalDirectionLever)) {
                this._mSignalDirectionIndicators.setPresentSignalDirectionLever(presentSignalDirectionLever);
                this._mSignalDirectionIndicators.codeButtonPressed(presentSignalDirectionLever, requestedChangeInSignalDirection);
            }
        }
    }

    private boolean allowSignalDirectionChangePart1() {
        if (this._mSignalDirectionLever == null) {
            return false;
        }
        if (!this._mSignalDirectionIndicators.inCorrespondence()) {
            return false;
        }
        return this.turnoutPresentlyLocked();
    }

    private boolean allowSignalDirectionChangePart2(int presentSignalDirectionLever) {
        return presentSignalDirectionLever == 1 || this.trafficLockingValid(presentSignalDirectionLever);
    }

    private boolean trafficLockingValid(int presentSignalDirectionLever) {
        if (this._mTrafficLocking != null) {
            TrafficLockingInfo trafficLockingInfo = this._mTrafficLocking.valid(presentSignalDirectionLever, this._mFleeting.isFleetingEnabled());
            this._mLockedRoute = trafficLockingInfo._mLockedRoute;
            return trafficLockingInfo._mReturnStatus;
        }
        return true;
    }

    private void possiblyAllowLockChange() {
        if (this.allowLockChange()) {
            this._mTurnoutLock.codeButtonPressed();
        }
    }

    private boolean allowLockChange() {
        if (this._mTurnoutLock == null) {
            return false;
        }
        if (!this._mTurnoutLockingOnlyEnabled && this.isEitherOSSectionOccupied()) {
            return false;
        }
        if (!this._mTurnoutLock.tryingToChangeLockStatus()) {
            return false;
        }
        if (this.routeClearedAcross()) {
            return false;
        }
        if (!this._mSignalDirectionIndicators.signalsNormal()) {
            return false;
        }
        if (!this.switchDirectionIndicatorsInCorrespondence()) {
            return false;
        }
        return this.areOSSensorsAvailableInRoutes();
    }

    private boolean routeClearedAcross() {
        if (this._mIndicationLockingSignals != null) {
            return this._mIndicationLockingSignals.routeClearedAcross();
        }
        return false;
    }

    private boolean turnoutPresentlyLocked() {
        if (this._mTurnoutLock == null) {
            return true;
        }
        return this._mTurnoutLock.turnoutPresentlyLocked();
    }

    private boolean isEitherOSSectionOccupied() {
        return this._mOSSectionOccupiedExternalSensor.getKnownState() != 4 || this._mOSSectionOccupiedExternalSensor2.getKnownState() != 4;
    }

    private boolean isPrimaryOSSectionOccupied() {
        return this._mOSSectionOccupiedExternalSensor.getKnownState() != 4;
    }

    private boolean areOSSensorsAvailableInRoutes() {
        HashSet<Sensor> sensors = new HashSet<Sensor>();
        sensors.add(this._mOSSectionOccupiedExternalSensor.getBean());
        if (this._mOSSectionOccupiedExternalSensor2.valid()) {
            sensors.add(this._mOSSectionOccupiedExternalSensor2.getBean());
        }
        return this._mLockedRoutesManager.checkRoute(sensors, this._mUserIdentifier, "Turnout Check");
    }

    private static class PreconditioningData {
        public boolean _mCodeButtonPressed = false;
        public int _mSignalDirectionLeverWas = 3;
        public int _mSwitchDirectionLeverWas = 3;

        private PreconditioningData() {
        }
    }
}

