/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.ctc;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collections;
import java.util.HashSet;
import java.util.concurrent.locks.ReentrantLock;
import jmri.Sensor;
import jmri.jmrit.ctc.Bundle;
import jmri.jmrit.ctc.LockedRoutesManager;

public class LockedRoute {
    private final LockedRoutesManager _mLockedRoutesManager;
    private final String _mOSSectionDescription;
    private final String _mRuleDescription;
    private final HashSet<CountedSensor> _mCountedSensors;
    private final boolean _mRightTraffic;
    private final PropertyChangeListener _mSensorPropertyChangeListener = e -> this.occupancyStateChange(e);

    private HashSet<CountedSensor> getCountedSensorHashSet(HashSet<Sensor> sensors) {
        HashSet<CountedSensor> returnValue = new HashSet<CountedSensor>();
        sensors.forEach(sensor -> returnValue.add(new CountedSensor((Sensor)sensor)));
        return returnValue;
    }

    public LockedRoute(LockedRoutesManager lockedRoutesManager, HashSet<Sensor> sensors, String osSectionDescription, String ruleDescription, boolean rightTraffic) {
        this._mLockedRoutesManager = lockedRoutesManager;
        this._mOSSectionDescription = osSectionDescription;
        this._mRuleDescription = ruleDescription;
        this._mCountedSensors = this.getCountedSensorHashSet(sensors);
        this._mRightTraffic = rightTraffic;
    }

    public HashSet<CountedSensor> getCountedSensors() {
        return this._mCountedSensors;
    }

    public HashSet<Sensor> getSensors() {
        HashSet<Sensor> returnValue = new HashSet<Sensor>();
        this._mCountedSensors.forEach(countedSensor -> returnValue.add(countedSensor.getSensor()));
        return returnValue;
    }

    public void allocateRoute() {
        this._mCountedSensors.forEach(countedSensor -> countedSensor.getSensor().addPropertyChangeListener(this._mSensorPropertyChangeListener));
    }

    public void mergeRoutes(LockedRoute newLockedRoute) {
        HashSet<CountedSensor> newCountedSensors = newLockedRoute.getCountedSensors();
        for (CountedSensor newCountedSensor : newCountedSensors) {
            boolean foundMatch = false;
            for (CountedSensor thisCountedSensor : this._mCountedSensors) {
                if (newCountedSensor.getSensor() != thisCountedSensor.getSensor()) continue;
                thisCountedSensor.lockedIncrementCount();
                foundMatch = true;
                break;
            }
            if (foundMatch) continue;
            this._mCountedSensors.add(newCountedSensor);
            newCountedSensor.getSensor().addPropertyChangeListener(this._mSensorPropertyChangeListener);
        }
    }

    public AnyInCommonReturn anyInCommon(LockedRoute lockedRoute, boolean checkDirection, boolean rightTraffic) {
        boolean anyInCommon;
        boolean bl = anyInCommon = !Collections.disjoint(this.getSensors(), lockedRoute.getSensors());
        if (anyInCommon && checkDirection && rightTraffic == lockedRoute._mRightTraffic) {
            return AnyInCommonReturn.FLEETING;
        }
        return anyInCommon ? AnyInCommonReturn.YES : AnyInCommonReturn.NONE;
    }

    public void removeAllListeners() {
        this._mCountedSensors.forEach(countedSensor -> countedSensor.getSensor().removePropertyChangeListener(this._mSensorPropertyChangeListener));
    }

    public String dumpRoute() {
        Object returnString = "";
        for (CountedSensor countedSensor : this._mCountedSensors) {
            if (((String)returnString).isEmpty()) {
                returnString = countedSensor.dumpIt();
                continue;
            }
            returnString = (String)returnString + ", " + countedSensor.dumpIt();
        }
        returnString = (String)returnString + (this._mRightTraffic ? " Dir:R" : " Dir:L");
        return "O.S. " + this._mOSSectionDescription + this._mRuleDescription + " " + Bundle.getMessage("LockedRouteSensorsStillAllocatedList") + " " + (String)returnString;
    }

    private void occupancyStateChange(PropertyChangeEvent e) {
        if (e.getPropertyName().equals("KnownState") && (Integer)e.getNewValue() == 4) {
            Sensor sensor = (Sensor)e.getSource();
            for (CountedSensor countedSensor : this._mCountedSensors) {
                if (countedSensor.getSensor() != sensor) continue;
                if (!countedSensor.lockedDecrementCountAndCheckIfZero()) break;
                sensor.removePropertyChangeListener(this._mSensorPropertyChangeListener);
                this._mCountedSensors.remove(countedSensor);
                break;
            }
            if (this._mCountedSensors.isEmpty()) {
                this._mLockedRoutesManager.cancelLockedRoute(this);
            }
        }
    }

    public static enum AnyInCommonReturn {
        NONE,
        YES,
        FLEETING;

    }

    private static class CountedSensor {
        private final Sensor _mSensor;
        private int _mCount;
        private final ReentrantLock _mLock = new ReentrantLock();

        private CountedSensor(Sensor sensor) {
            this._mSensor = sensor;
            this._mCount = 1;
        }

        private Sensor getSensor() {
            return this._mSensor;
        }

        private void lockedIncrementCount() {
            this._mLock.lock();
            ++this._mCount;
            this._mLock.unlock();
        }

        private boolean lockedDecrementCountAndCheckIfZero() {
            this._mLock.lock();
            --this._mCount;
            boolean returnValue = this._mCount == 0;
            this._mLock.unlock();
            return returnValue;
        }

        private String dumpIt() {
            return this._mSensor.getDisplayName() + "(" + String.valueOf(this._mCount) + ")";
        }
    }
}

