/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.ctc;

import jmri.jmrit.ctc.Bundle;
import jmri.jmrit.ctc.CTCException;
import jmri.jmrit.ctc.NBHSensor;

public class SignalDirectionLever {
    private NBHSensor _mLeftSensor;
    private NBHSensor _mNormalSensor;
    private NBHSensor _mRightSensor;

    public SignalDirectionLever(String userIdentifier, NBHSensor leftSensor, NBHSensor normalSensor, NBHSensor rightSensor) {
        this._mLeftSensor = leftSensor;
        this._mNormalSensor = normalSensor;
        this._mRightSensor = rightSensor;
        if (!this._mLeftSensor.valid() && !this._mRightSensor.valid()) {
            new CTCException("SignalDirectionLever", userIdentifier, Bundle.getMessage("SignalDirectionLeverMustHaveOne"), Bundle.getMessage("SignalDirectionLeverOneOrBoth")).logError();
        }
        this._mLeftSensor.setKnownState(4);
        this._mNormalSensor.setKnownState(2);
        this._mRightSensor.setKnownState(4);
    }

    public void removeAllListeners() {
    }

    public LNR_NBHSensors getLevers() {
        return new LNR_NBHSensors(this._mLeftSensor, this._mNormalSensor, this._mRightSensor);
    }

    public int getPresentSignalDirectionLeverState() {
        if (this._mLeftSensor.getKnownState() == 2) {
            return 0;
        }
        if (this._mNormalSensor.getKnownState() == 2) {
            return 1;
        }
        if (this._mRightSensor.getKnownState() == 2) {
            return 2;
        }
        return 3;
    }

    public static class LNR_NBHSensors {
        public final NBHSensor _mLeftSensor;
        public final NBHSensor _mNormalSensor;
        public final NBHSensor _mRightSensor;

        public LNR_NBHSensors(NBHSensor leftSensor, NBHSensor normalSensor, NBHSensor rightSensor) {
            this._mLeftSensor = leftSensor;
            this._mNormalSensor = normalSensor;
            this._mRightSensor = rightSensor;
        }
    }
}

