/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.ctc;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import jmri.InstanceManager;
import jmri.Sensor;
import jmri.jmrit.ctc.Bundle;
import jmri.jmrit.ctc.CTCMain;
import jmri.jmrit.ctc.CodeButtonHandler;
import jmri.jmrit.ctc.LockedRoutesManager;
import jmri.jmrit.ctc.NBHSensor;
import jmri.jmrit.ctc.SwitchDirectionIndicators;
import jmri.jmrit.ctc.SwitchIndicatorsRoute;
import jmri.jmrit.ctc.TrafficLockingInfo;
import jmri.jmrit.ctc.ctcserialdata.TrafficLockingData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrafficLocking {
    private static final Logger log = LoggerFactory.getLogger(TrafficLocking.class);
    private final ArrayList<TrafficLockingRecord> _mLeftTrafficLockingRulesArrayList = new ArrayList();
    private final ArrayList<TrafficLockingRecord> _mRightTrafficLockingRulesArrayList = new ArrayList();
    private final String _mUserIdentifier;
    private final ArrayList<TrafficLockingData> _mLeftTrafficLockingRulesList;
    private final ArrayList<TrafficLockingData> _mRightTrafficLockingRulesList;
    private final LockedRoutesManager _mLockedRoutesManager;

    public TrafficLocking(String userIdentifier, ArrayList<TrafficLockingData> _mTRL_LeftTrafficLockingRules, ArrayList<TrafficLockingData> _mTRL_RightTrafficLockingRules, LockedRoutesManager lockedRoutesManager) {
        this._mUserIdentifier = userIdentifier;
        this._mLeftTrafficLockingRulesList = _mTRL_LeftTrafficLockingRules;
        this._mRightTrafficLockingRulesList = _mTRL_RightTrafficLockingRules;
        this._mLockedRoutesManager = lockedRoutesManager;
    }

    public void removeAllListeners() {
    }

    public void fileReadComplete(HashMap<Integer, CodeButtonHandler> cbHashMap, HashMap<Integer, SwitchDirectionIndicators> swdiHashMap) {
        this.addAllTrafficLockingEntries(this._mUserIdentifier, this._mLeftTrafficLockingRulesList, "leftTrafficLockingRulesList", cbHashMap, swdiHashMap, this._mLeftTrafficLockingRulesArrayList);
        this.addAllTrafficLockingEntries(this._mUserIdentifier, this._mRightTrafficLockingRulesList, "rightTrafficLockingRulesList", cbHashMap, swdiHashMap, this._mRightTrafficLockingRulesArrayList);
    }

    private void addAllTrafficLockingEntries(String userIdentifier, ArrayList<TrafficLockingData> trafficLockingRulesList, String parameter, HashMap<Integer, CodeButtonHandler> cbHashMap, HashMap<Integer, SwitchDirectionIndicators> swdiHashMap, ArrayList<TrafficLockingRecord> trafficLockingRecordsArrayList) {
        trafficLockingRulesList.forEach(row -> {
            ArrayList<NBHSensor> occupancySensors = row.getOccupancySensors();
            ArrayList<NBHSensor> optionalSensors = row.getOptionalSensors();
            ArrayList<Integer> ids = row.getUniqueIDs();
            ArrayList<String> alignments = row.getAlignments();
            int osSection1UniqueID = ids.get(0);
            int osSection2UniqueID = ids.get(1);
            int osSection3UniqueID = ids.get(2);
            int osSection4UniqueID = ids.get(3);
            int osSection5UniqueID = ids.get(4);
            TrafficLockingRecord trafficLockingRecord = new TrafficLockingRecord(userIdentifier, parameter, this.getSwitchDirectionIndicatorSensor(osSection1UniqueID, alignments.get(0), swdiHashMap), this.getSwitchDirectionIndicatorSensor(osSection2UniqueID, alignments.get(1), swdiHashMap), this.getSwitchDirectionIndicatorSensor(osSection3UniqueID, alignments.get(2), swdiHashMap), this.getSwitchDirectionIndicatorSensor(osSection4UniqueID, alignments.get(3), swdiHashMap), this.getSwitchDirectionIndicatorSensor(osSection5UniqueID, alignments.get(4), swdiHashMap), occupancySensors.get(0), occupancySensors.get(1), occupancySensors.get(2), occupancySensors.get(3), occupancySensors.get(4), occupancySensors.get(5), occupancySensors.get(6), occupancySensors.get(7), occupancySensors.get(8), optionalSensors.get(0), optionalSensors.get(1), row._mRuleEnabled);
            if (!trafficLockingRecord.getOccupancySensors().isEmpty()) {
                trafficLockingRecordsArrayList.add(trafficLockingRecord);
            }
        });
    }

    public TrafficLockingInfo valid(int presentSignalDirectionLever, boolean fleetingEnabled) {
        if (presentSignalDirectionLever == 0) {
            return this.validForTraffic(this._mLeftTrafficLockingRulesArrayList, false, fleetingEnabled);
        }
        return this.validForTraffic(this._mRightTrafficLockingRulesArrayList, true, fleetingEnabled);
    }

    private TrafficLockingInfo validForTraffic(ArrayList<TrafficLockingRecord> trafficLockingRecordArrayList, boolean rightTraffic, boolean fleetingEnabled) {
        int index;
        TrafficLockingInfo returnValue = new TrafficLockingInfo(true);
        if (trafficLockingRecordArrayList.isEmpty()) {
            return returnValue;
        }
        boolean anyEnabled = false;
        for (index = 0; index < trafficLockingRecordArrayList.size(); ++index) {
            if (!trafficLockingRecordArrayList.get(index).isEnabled()) continue;
            anyEnabled = true;
            break;
        }
        if (!anyEnabled) {
            return returnValue;
        }
        for (index = 0; index < trafficLockingRecordArrayList.size(); ++index) {
            TrafficLockingRecord trafficLockingRecord = trafficLockingRecordArrayList.get(index);
            if (!trafficLockingRecord.isValid(fleetingEnabled)) continue;
            String ruleNumber = Integer.toString(index + 1);
            returnValue._mLockedRoute = this._mLockedRoutesManager.checkRouteAndAllocateIfAvailable(trafficLockingRecord.getOccupancySensors(), this._mUserIdentifier, "Rule #" + ruleNumber, rightTraffic);
            if (returnValue._mLockedRoute == null) continue;
            if (InstanceManager.getDefault(CTCMain.class)._mCTCDebug_TrafficLockingRuleTriggeredDisplayLoggingEnabled) {
                log.info("Rule {} valid", (Object)ruleNumber);
            }
            return returnValue;
        }
        returnValue._mReturnStatus = false;
        return returnValue;
    }

    private NBHSensor getSwitchDirectionIndicatorSensor(int uniqueID, String switchAlignment, HashMap<Integer, SwitchDirectionIndicators> swdiHashMap) {
        if (uniqueID < 0) {
            return null;
        }
        boolean isNormalAlignment = !switchAlignment.equals(Bundle.getMessage("TLE_Reverse"));
        SwitchDirectionIndicators switchDirectionIndicators = swdiHashMap.get(uniqueID);
        if (switchDirectionIndicators == null) {
            return null;
        }
        return switchDirectionIndicators.getProperIndicatorSensor(isNormalAlignment);
    }

    private static class TrafficLockingRecord {
        private final SwitchIndicatorsRoute _mSwitchIndicatorsRoute;
        private final NBHSensor _mOccupancyExternalSensor1;
        private final NBHSensor _mOccupancyExternalSensor2;
        private final NBHSensor _mOccupancyExternalSensor3;
        private final NBHSensor _mOccupancyExternalSensor4;
        private final NBHSensor _mOccupancyExternalSensor5;
        private final NBHSensor _mOccupancyExternalSensor6;
        private final NBHSensor _mOccupancyExternalSensor7;
        private final NBHSensor _mOccupancyExternalSensor8;
        private final NBHSensor _mOccupancyExternalSensor9;
        private final NBHSensor _mOptionalSensor1;
        private final NBHSensor _mOptionalSensor2;
        private final boolean _mRuleEnabled;

        public TrafficLockingRecord(String userIdentifier, String parameter, NBHSensor switchIndicator1, NBHSensor switchIndicator2, NBHSensor switchIndicator3, NBHSensor switchIndicator4, NBHSensor switchIndicator5, NBHSensor occupancyExternalSensor1, NBHSensor occupancyExternalSensor2, NBHSensor occupancyExternalSensor3, NBHSensor occupancyExternalSensor4, NBHSensor occupancyExternalSensor5, NBHSensor occupancyExternalSensor6, NBHSensor occupancyExternalSensor7, NBHSensor occupancyExternalSensor8, NBHSensor occupancyExternalSensor9, NBHSensor optionalSensor1, NBHSensor optionalSensor2, String ruleEnabled) {
            this._mSwitchIndicatorsRoute = new SwitchIndicatorsRoute(switchIndicator1, switchIndicator2, switchIndicator3, switchIndicator4, switchIndicator5, null);
            this._mOccupancyExternalSensor1 = occupancyExternalSensor1;
            this._mOccupancyExternalSensor2 = occupancyExternalSensor2;
            this._mOccupancyExternalSensor3 = occupancyExternalSensor3;
            this._mOccupancyExternalSensor4 = occupancyExternalSensor4;
            this._mOccupancyExternalSensor5 = occupancyExternalSensor5;
            this._mOccupancyExternalSensor6 = occupancyExternalSensor6;
            this._mOccupancyExternalSensor7 = occupancyExternalSensor7;
            this._mOccupancyExternalSensor8 = occupancyExternalSensor8;
            this._mOccupancyExternalSensor9 = occupancyExternalSensor9;
            this._mOptionalSensor1 = optionalSensor1;
            this._mOptionalSensor2 = optionalSensor2;
            this._mRuleEnabled = !ruleEnabled.equals(Bundle.getMessage("TLE_RuleDisabled"));
        }

        public boolean isEnabled() {
            return this._mRuleEnabled;
        }

        public boolean isValid(boolean fleetingEnabled) {
            if (!this._mRuleEnabled) {
                return false;
            }
            return this._mSwitchIndicatorsRoute.isRouteSelected() && this.isOptionalSensorActive(this._mOptionalSensor1) && this.isOptionalSensorActive(this._mOptionalSensor2);
        }

        public HashSet<Sensor> getOccupancySensors() {
            HashSet<Sensor> returnValue = new HashSet<Sensor>();
            if (this._mOccupancyExternalSensor1 != null && this._mOccupancyExternalSensor1.valid()) {
                returnValue.add(this._mOccupancyExternalSensor1.getBean());
            }
            if (this._mOccupancyExternalSensor2 != null && this._mOccupancyExternalSensor2.valid()) {
                returnValue.add(this._mOccupancyExternalSensor2.getBean());
            }
            if (this._mOccupancyExternalSensor3 != null && this._mOccupancyExternalSensor3.valid()) {
                returnValue.add(this._mOccupancyExternalSensor3.getBean());
            }
            if (this._mOccupancyExternalSensor4 != null && this._mOccupancyExternalSensor4.valid()) {
                returnValue.add(this._mOccupancyExternalSensor4.getBean());
            }
            if (this._mOccupancyExternalSensor5 != null && this._mOccupancyExternalSensor5.valid()) {
                returnValue.add(this._mOccupancyExternalSensor5.getBean());
            }
            if (this._mOccupancyExternalSensor6 != null && this._mOccupancyExternalSensor6.valid()) {
                returnValue.add(this._mOccupancyExternalSensor6.getBean());
            }
            if (this._mOccupancyExternalSensor7 != null && this._mOccupancyExternalSensor7.valid()) {
                returnValue.add(this._mOccupancyExternalSensor7.getBean());
            }
            if (this._mOccupancyExternalSensor8 != null && this._mOccupancyExternalSensor8.valid()) {
                returnValue.add(this._mOccupancyExternalSensor8.getBean());
            }
            if (this._mOccupancyExternalSensor9 != null && this._mOccupancyExternalSensor9.valid()) {
                returnValue.add(this._mOccupancyExternalSensor9.getBean());
            }
            returnValue.remove(null);
            return returnValue;
        }

        private boolean isOptionalSensorActive(NBHSensor sensor) {
            if (sensor.valid()) {
                return sensor.getKnownState() == 2;
            }
            return true;
        }
    }
}

