/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.ctc.configurexml;

import java.util.ArrayList;
import java.util.List;
import jmri.Block;
import jmri.BlockManager;
import jmri.InstanceManager;
import jmri.NamedBeanHandle;
import jmri.NamedBeanHandleManager;
import jmri.jmrit.ctc.CtcManager;
import jmri.jmrit.ctc.NBHSensor;
import jmri.jmrit.ctc.NBHSignal;
import jmri.jmrit.ctc.NBHTurnout;
import jmri.jmrit.ctc.ctcserialdata.CallOnData;
import jmri.jmrit.ctc.ctcserialdata.CodeButtonHandlerData;
import jmri.jmrit.ctc.ctcserialdata.OtherData;
import jmri.jmrit.ctc.ctcserialdata.TrafficLockingData;
import jmri.jmrit.ctc.editor.code.CodeButtonHandlerDataRoutines;
import jmri.jmrit.ctc.editor.code.ProgramProperties;
import jmri.managers.configurexml.AbstractNamedBeanManagerConfigXML;
import org.jdom2.Content;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CtcManagerXml
extends AbstractNamedBeanManagerConfigXML {
    CtcManager cm = InstanceManager.getDefault(CtcManager.class);
    private static final Logger log = LoggerFactory.getLogger(CtcManagerXml.class);

    @Override
    public Element store(Object o) {
        Element ctcdata = new Element("ctcdata");
        this.setStoreElementClass(ctcdata);
        ctcdata.addContent((Content)this.storeProperties(this.cm));
        ctcdata.addContent((Content)this.storeOtherData(this.cm));
        for (CodeButtonHandlerData cbhd : this.cm.getCTCSerialData().getCodeButtonHandlerDataArrayList()) {
            Element cbhdElement = new Element("ctcCodeButtonData");
            cbhdElement.addContent((Content)this.storeInt("UniqueID", cbhd._mUniqueID));
            cbhdElement.addContent((Content)this.storeInt("SwitchNumber", cbhd._mSwitchNumber));
            cbhdElement.addContent((Content)this.storeInt("SignalEtcNumber", cbhd._mSignalEtcNumber));
            cbhdElement.addContent((Content)this.storeInt("GUIColumnNumber", cbhd._mGUIColumnNumber));
            cbhdElement.addContent((Content)this.storeSensor("CodeButtonInternalSensor", cbhd._mCodeButtonInternalSensor));
            cbhdElement.addContent((Content)this.storeSensor("OSSectionOccupiedExternalSensor", cbhd._mOSSectionOccupiedExternalSensor));
            cbhdElement.addContent((Content)this.storeSensor("OSSectionOccupiedExternalSensor2", cbhd._mOSSectionOccupiedExternalSensor2));
            cbhdElement.addContent((Content)this.storeInt("OSSectionSwitchSlavedToUniqueID", cbhd._mOSSectionSwitchSlavedToUniqueID));
            cbhdElement.addContent((Content)this.storeBoolean("GUIGeneratedAtLeastOnceAlready", cbhd._mGUIGeneratedAtLeastOnceAlready));
            cbhdElement.addContent((Content)this.storeInt("CodeButtonDelayTime", cbhd._mCodeButtonDelayTime));
            cbhdElement.addContent((Content)this.storeBoolean("SIDI_Enabled", cbhd._mSIDI_Enabled));
            cbhdElement.addContent((Content)this.storeSensor("SIDI_LeftInternalSensor", cbhd._mSIDI_LeftInternalSensor));
            cbhdElement.addContent((Content)this.storeSensor("SIDI_NormalInternalSensor", cbhd._mSIDI_NormalInternalSensor));
            cbhdElement.addContent((Content)this.storeSensor("SIDI_RightInternalSensor", cbhd._mSIDI_RightInternalSensor));
            cbhdElement.addContent((Content)this.storeInt("SIDI_CodingTimeInMilliseconds", cbhd._mSIDI_CodingTimeInMilliseconds));
            cbhdElement.addContent((Content)this.storeInt("SIDI_TimeLockingTimeInMilliseconds", cbhd._mSIDI_TimeLockingTimeInMilliseconds));
            cbhdElement.addContent((Content)this.storeString("SIDI_TrafficDirection", cbhd._mSIDI_TrafficDirection.toString()));
            cbhdElement.addContent((Content)this.storeSignalList("SIDI_LeftRightTrafficSignals", cbhd._mSIDI_LeftRightTrafficSignals));
            cbhdElement.addContent((Content)this.storeSignalList("SIDI_RightLeftTrafficSignals", cbhd._mSIDI_RightLeftTrafficSignals));
            cbhdElement.addContent((Content)this.storeBoolean("SIDL_Enabled", cbhd._mSIDL_Enabled));
            cbhdElement.addContent((Content)this.storeSensor("SIDL_LeftInternalSensor", cbhd._mSIDL_LeftInternalSensor));
            cbhdElement.addContent((Content)this.storeSensor("SIDL_NormalInternalSensor", cbhd._mSIDL_NormalInternalSensor));
            cbhdElement.addContent((Content)this.storeSensor("SIDL_RightInternalSensor", cbhd._mSIDL_RightInternalSensor));
            cbhdElement.addContent((Content)this.storeBoolean("SWDI_Enabled", cbhd._mSWDI_Enabled));
            cbhdElement.addContent((Content)this.storeSensor("SWDI_NormalInternalSensor", cbhd._mSWDI_NormalInternalSensor));
            cbhdElement.addContent((Content)this.storeSensor("SWDI_ReversedInternalSensor", cbhd._mSWDI_ReversedInternalSensor));
            cbhdElement.addContent((Content)this.storeTurnout("SWDI_ExternalTurnout", cbhd._mSWDI_ExternalTurnout));
            cbhdElement.addContent((Content)this.storeInt("SWDI_CodingTimeInMilliseconds", cbhd._mSWDI_CodingTimeInMilliseconds));
            cbhdElement.addContent((Content)this.storeBoolean("SWDI_FeedbackDifferent", cbhd._mSWDI_FeedbackDifferent));
            cbhdElement.addContent((Content)this.storeInt("SWDI_GUITurnoutType", cbhd._mSWDI_GUITurnoutType.getInt()));
            cbhdElement.addContent((Content)this.storeBoolean("SWDI_GUITurnoutLeftHand", cbhd._mSWDI_GUITurnoutLeftHand));
            cbhdElement.addContent((Content)this.storeBoolean("SWDI_GUICrossoverLeftHand", cbhd._mSWDI_GUICrossoverLeftHand));
            cbhdElement.addContent((Content)this.storeBoolean("SWDL_Enabled", cbhd._mSWDL_Enabled));
            cbhdElement.addContent((Content)this.storeSensor("SWDL_InternalSensor", cbhd._mSWDL_InternalSensor));
            cbhdElement.addContent((Content)this.storeBoolean("CO_Enabled", cbhd._mCO_Enabled));
            cbhdElement.addContent((Content)this.storeSensor("CO_CallOnToggleInternalSensor", cbhd._mCO_CallOnToggleInternalSensor));
            cbhdElement.addContent((Content)this.storeCallOnList("CO_GroupingsList", cbhd._mCO_GroupingsList));
            cbhdElement.addContent((Content)this.storeBoolean("TRL_Enabled", cbhd._mTRL_Enabled));
            cbhdElement.addContent((Content)this.storeTRLRules("TRL_LeftRules", cbhd._mTRL_LeftTrafficLockingRules));
            cbhdElement.addContent((Content)this.storeTRLRules("TRL_RightRules", cbhd._mTRL_RightTrafficLockingRules));
            cbhdElement.addContent((Content)this.storeBoolean("TUL_Enabled", cbhd._mTUL_Enabled));
            cbhdElement.addContent((Content)this.storeSensor("TUL_DispatcherInternalSensorLockToggle", cbhd._mTUL_DispatcherInternalSensorLockToggle));
            cbhdElement.addContent((Content)this.storeTurnout("TUL_ExternalTurnout", cbhd._mTUL_ExternalTurnout));
            cbhdElement.addContent((Content)this.storeBoolean("TUL_ExternalTurnoutFeedbackDifferent", cbhd._mTUL_ExternalTurnoutFeedbackDifferent));
            cbhdElement.addContent((Content)this.storeSensor("TUL_DispatcherInternalSensorUnlockedIndicator", cbhd._mTUL_DispatcherInternalSensorUnlockedIndicator));
            cbhdElement.addContent((Content)this.storeBoolean("TUL_NoDispatcherControlOfSwitch", cbhd._mTUL_NoDispatcherControlOfSwitch));
            cbhdElement.addContent((Content)this.storeBoolean("TUL_ndcos_WhenLockedSwitchStateIsClosed", cbhd._mTUL_ndcos_WhenLockedSwitchStateIsClosed));
            cbhdElement.addContent((Content)this.storeBoolean("TUL_GUI_IconsEnabled", cbhd._mTUL_GUI_IconsEnabled));
            cbhdElement.addContent((Content)this.storeInt("TUL_LockImplementation", cbhd._mTUL_LockImplementation.getInt()));
            cbhdElement.addContent((Content)this.storeTULAdditionalTurnouts("TUL_AdditionalExternalTurnouts", cbhd));
            cbhdElement.addContent((Content)this.storeBoolean("IL_Enabled", cbhd._mIL_Enabled));
            cbhdElement.addContent((Content)this.storeSignalList("IL_Signals", cbhd._mIL_Signals));
            ctcdata.addContent((Content)cbhdElement);
        }
        return ctcdata;
    }

    public void setStoreElementClass(Element ctcdata) {
        ctcdata.setAttribute("class", "jmri.jmrit.ctc.configurexml.CtcManagerXml");
    }

    Element storeProperties(CtcManager cm) {
        ProgramProperties pp = cm.getProgramProperties();
        Element properties = new Element("ctcProperties");
        properties.addContent((Content)this.storeString("CodeButtonInternalSensorPattern", pp._mCodeButtonInternalSensorPattern));
        properties.addContent((Content)this.storeInt("SIDI_CodingTimeInMilliseconds", pp._mSIDI_CodingTimeInMilliseconds));
        properties.addContent((Content)this.storeString("SIDI_LeftInternalSensorPattern", pp._mSIDI_LeftInternalSensorPattern));
        properties.addContent((Content)this.storeString("SIDI_NormalInternalSensorPattern", pp._mSIDI_NormalInternalSensorPattern));
        properties.addContent((Content)this.storeString("SIDI_RightInternalSensorPattern", pp._mSIDI_RightInternalSensorPattern));
        properties.addContent((Content)this.storeInt("SIDI_TimeLockingTimeInMilliseconds", pp._mSIDI_TimeLockingTimeInMilliseconds));
        properties.addContent((Content)this.storeString("SIDL_LeftInternalSensorPattern", pp._mSIDL_LeftInternalSensorPattern));
        properties.addContent((Content)this.storeString("SIDL_NormalInternalSensorPattern", pp._mSIDL_NormalInternalSensorPattern));
        properties.addContent((Content)this.storeString("SIDL_RightInternalSensorPattern", pp._mSIDL_RightInternalSensorPattern));
        properties.addContent((Content)this.storeInt("SWDI_CodingTimeInMilliseconds", pp._mSWDI_CodingTimeInMilliseconds));
        properties.addContent((Content)this.storeString("SWDI_NormalInternalSensorPattern", pp._mSWDI_NormalInternalSensorPattern));
        properties.addContent((Content)this.storeString("SWDI_ReversedInternalSensorPattern", pp._mSWDI_ReversedInternalSensorPattern));
        properties.addContent((Content)this.storeString("SWDL_InternalSensorPattern", pp._mSWDL_InternalSensorPattern));
        properties.addContent((Content)this.storeString("CO_CallOnToggleInternalSensorPattern", pp._mCO_CallOnToggleInternalSensorPattern));
        properties.addContent((Content)this.storeString("TUL_DispatcherInternalSensorLockTogglePattern", pp._mTUL_DispatcherInternalSensorLockTogglePattern));
        properties.addContent((Content)this.storeString("TUL_DispatcherInternalSensorUnlockedIndicatorPattern", pp._mTUL_DispatcherInternalSensorUnlockedIndicatorPattern));
        properties.addContent((Content)this.storeInt("CodeButtonDelayTime", pp._mCodeButtonDelayTime));
        return properties;
    }

    Element storeOtherData(CtcManager cm) {
        OtherData od = cm.getOtherData();
        Element otherData = new Element("ctcOtherData");
        otherData.addContent((Content)this.storeString("CtcVersion", "v2.0"));
        otherData.addContent((Content)this.storeSensor("FleetingToggleInternalSensor", od._mFleetingToggleInternalSensor));
        otherData.addContent((Content)this.storeBoolean("DefaultFleetingEnabled", od._mDefaultFleetingEnabled));
        otherData.addContent((Content)this.storeBoolean("TUL_EnabledAtStartup", od._mTUL_EnabledAtStartup));
        otherData.addContent((Content)this.storeInt("SignalSystemType", od._mSignalSystemType.getInt()));
        otherData.addContent((Content)this.storeInt("TUL_SecondsToLockTurnouts", od._mTUL_SecondsToLockTurnouts));
        otherData.addContent((Content)this.storeInt("NextUniqueNumber", od._mNextUniqueNumber));
        otherData.addContent((Content)this.storeSensor("CTCDebugSystemReloadInternalSensor", od._mCTCDebugSystemReloadInternalSensor));
        otherData.addContent((Content)this.storeSensor("CTCDebug_TrafficLockingRuleTriggeredDisplayInternalSensor", od._mCTCDebug_TrafficLockingRuleTriggeredDisplayInternalSensor));
        otherData.addContent((Content)this.storeInt("GUIDesign_NumberOfEmptyColumnsAtEnd", od._mGUIDesign_NumberOfEmptyColumnsAtEnd));
        otherData.addContent((Content)this.storeInt("GUIDesign_CTCPanelType", od._mGUIDesign_CTCPanelType.getRadioGroupValue()));
        otherData.addContent((Content)this.storeBoolean("GUIDesign_BuilderPlate", od._mGUIDesign_BuilderPlate));
        otherData.addContent((Content)this.storeInt("GUIDesign_SignalsOnPanel", od._mGUIDesign_SignalsOnPanel.getRadioGroupValue()));
        otherData.addContent((Content)this.storeBoolean("GUIDesign_FleetingToggleSwitch", od._mGUIDesign_FleetingToggleSwitch));
        otherData.addContent((Content)this.storeBoolean("GUIDesign_AnalogClockEtc", od._mGUIDesign_AnalogClockEtc));
        otherData.addContent((Content)this.storeBoolean("GUIDesign_ReloadCTCSystemButton", od._mGUIDesign_ReloadCTCSystemButton));
        otherData.addContent((Content)this.storeBoolean("GUIDesign_CTCDebugOnToggle", od._mGUIDesign_CTCDebugOnToggle));
        otherData.addContent((Content)this.storeBoolean("GUIDesign_CreateTrackPieces", od._mGUIDesign_CreateTrackPieces));
        otherData.addContent((Content)this.storeInt("GUIDesign_VerticalSize", od._mGUIDesign_VerticalSize.getRadioGroupValue()));
        otherData.addContent((Content)this.storeBoolean("GUIDesign_OSSectionUnknownInconsistentRedBlink", od._mGUIDesign_OSSectionUnknownInconsistentRedBlink));
        otherData.addContent((Content)this.storeBoolean("GUIDesign_TurnoutsOnPanel", od._mGUIDesign_TurnoutsOnPanel));
        return otherData;
    }

    Element storeString(String elementName, String elementValue) {
        Element element = new Element(elementName);
        element.setText(elementValue);
        return element;
    }

    Element storeInt(String elementName, int elementValue) {
        Element element = new Element(elementName);
        element.setText(String.valueOf(elementValue));
        return element;
    }

    Element storeBoolean(String elementName, boolean elementValue) {
        Element element = new Element(elementName);
        element.setText(elementValue ? "true" : "false");
        return element;
    }

    Element storeSensor(String elementName, NBHSensor sensor) {
        Element element = new Element(elementName);
        if (sensor != null) {
            element.setText(sensor.getHandleName());
        }
        return element;
    }

    Element storeSignal(String elementName, NBHSignal signal) {
        Element element = new Element(elementName);
        if (signal != null) {
            element.setText(signal.getHandleName());
        }
        return element;
    }

    Element storeTurnout(String elementName, NBHTurnout turnout) {
        Element element = new Element(elementName);
        if (turnout != null) {
            element.setText(turnout.getHandleName());
        }
        return element;
    }

    Element storeBlock(String elementName, NamedBeanHandle<Block> block) {
        Element element = new Element(elementName);
        if (block != null) {
            element.setText(block.getName());
        }
        return element;
    }

    Element storeSensorList(String elementName, List<NBHSensor> sensors) {
        Element element = new Element(elementName);
        sensors.forEach(sensor -> element.addContent((Content)this.storeSensor("sensor", (NBHSensor)sensor)));
        return element;
    }

    Element storeSignalList(String elementName, List<NBHSignal> signals) {
        Element element = new Element(elementName);
        signals.forEach(signal -> element.addContent((Content)this.storeSignal("signal", (NBHSignal)signal)));
        return element;
    }

    Element storeCallOnList(String elementName, List<CallOnData> callOnList) {
        Element element = new Element(elementName);
        callOnList.forEach(row -> {
            Element groupEntry = new Element("CO_GroupEntry");
            groupEntry.addContent((Content)this.storeSignal("ExternalSignal", row._mExternalSignal));
            groupEntry.addContent((Content)this.storeString("SignalFacingDirection", row._mSignalFacingDirection));
            groupEntry.addContent((Content)this.storeString("SignalAspectToDisplay", row._mSignalAspectToDisplay));
            groupEntry.addContent((Content)this.storeSensor("CalledOnExternalSensor", row._mCalledOnExternalSensor));
            groupEntry.addContent((Content)this.storeBlock("ExternalBlock", row._mExternalBlock));
            groupEntry.addContent((Content)this.storeSensorList("SwitchIndicators", row._mSwitchIndicators));
            element.addContent((Content)groupEntry);
        });
        return element;
    }

    Element storeTRLRules(String elementName, List<TrafficLockingData> trlList) {
        Element element = new Element(elementName);
        trlList.forEach(row -> {
            Element ruleEntry = new Element("TRL_TrafficLockingRule");
            ruleEntry.addContent((Content)this.storeString("UserRuleNumber", row._mUserRuleNumber));
            ruleEntry.addContent((Content)this.storeString("RuleEnabled", row._mRuleEnabled));
            ruleEntry.addContent((Content)this.storeString("DestinationSignalOrComment", row._mDestinationSignalOrComment));
            ruleEntry.addContent((Content)this.storeTRLSwitches("switches", row._mSwitchAlignments));
            ruleEntry.addContent((Content)this.storeSensorList("OccupancyExternalSensors", row._mOccupancyExternalSensors));
            ruleEntry.addContent((Content)this.storeSensorList("OptionalExternalSensors", row._mOptionalExternalSensors));
            element.addContent((Content)ruleEntry);
        });
        return element;
    }

    Element storeTRLSwitches(String elementName, List<TrafficLockingData.TRLSwitch> trlSwitches) {
        Element element = new Element(elementName);
        trlSwitches.forEach(trlSwitch -> {
            Element elSwitch = new Element("switch");
            elSwitch.addContent((Content)this.storeString("UserText", trlSwitch._mUserText));
            elSwitch.addContent((Content)this.storeString("SwitchAlignment", trlSwitch._mSwitchAlignment));
            elSwitch.addContent((Content)this.storeInt("UniqueID", trlSwitch._mUniqueID));
            element.addContent((Content)elSwitch);
        });
        return element;
    }

    Element storeTULAdditionalTurnouts(String elementName, CodeButtonHandlerData cbhd) {
        Element element = new Element(elementName);
        Element elementRow = this.createAdditionalTurnoutEntry(cbhd._mTUL_AdditionalExternalTurnout1, cbhd._mTUL_AdditionalExternalTurnout1FeedbackDifferent);
        if (elementRow != null) {
            element.addContent((Content)elementRow);
        }
        if ((elementRow = this.createAdditionalTurnoutEntry(cbhd._mTUL_AdditionalExternalTurnout2, cbhd._mTUL_AdditionalExternalTurnout2FeedbackDifferent)) != null) {
            element.addContent((Content)elementRow);
        }
        if ((elementRow = this.createAdditionalTurnoutEntry(cbhd._mTUL_AdditionalExternalTurnout3, cbhd._mTUL_AdditionalExternalTurnout3FeedbackDifferent)) != null) {
            element.addContent((Content)elementRow);
        }
        return element;
    }

    Element createAdditionalTurnoutEntry(NBHTurnout turnout, boolean turnoutFeedback) {
        Element element = null;
        if (turnout.valid()) {
            element = new Element("TUL_AdditionalExternalTurnoutEntry");
            element.addContent((Content)this.storeTurnout("TUL_AdditionalExternalTurnout", turnout));
            element.addContent((Content)this.storeBoolean("TUL_AdditionalExternalTurnoutFeedbackDifferent", turnoutFeedback));
        }
        return element;
    }

    @Override
    public void load(Element element, Object o) {
        log.error("Invalid method called");
    }

    @Override
    public boolean load(Element sharedCtcData, Element perNodeCtcData) {
        List ctcList = sharedCtcData.getChildren();
        for (Element lvl1 : ctcList) {
            if (lvl1.getName().equals("ctcProperties")) {
                this.loadProperties(this.cm, lvl1);
                continue;
            }
            if (lvl1.getName().equals("ctcOtherData")) {
                this.loadOtherData(this.cm, lvl1);
                continue;
            }
            if (!lvl1.getName().equals("ctcCodeButtonData")) continue;
            log.debug("------------- CBHD ------------");
            int _mUniqueID = this.loadInt(lvl1.getChild("UniqueID"));
            int _mSwitchNumber = this.loadInt(lvl1.getChild("SwitchNumber"));
            int _mSignalEtcNumber = this.loadInt(lvl1.getChild("SignalEtcNumber"));
            int _mGUIColumnNumber = this.loadInt(lvl1.getChild("GUIColumnNumber"));
            CodeButtonHandlerData cbhd = CodeButtonHandlerDataRoutines.createNewCodeButtonHandlerData(_mUniqueID, _mSwitchNumber, _mSignalEtcNumber, _mGUIColumnNumber, this.cm.getProgramProperties());
            this.cm.getCTCSerialData().addCodeButtonHandlerData(cbhd);
            log.debug("------------- Code ------------");
            cbhd._mCodeButtonInternalSensor = this.loadSensor(lvl1.getChild("CodeButtonInternalSensor"), true);
            cbhd._mOSSectionOccupiedExternalSensor = this.loadSensor(lvl1.getChild("OSSectionOccupiedExternalSensor"), false);
            cbhd._mOSSectionOccupiedExternalSensor2 = this.loadSensor(lvl1.getChild("OSSectionOccupiedExternalSensor2"), false);
            cbhd._mOSSectionSwitchSlavedToUniqueID = this.loadInt(lvl1.getChild("OSSectionSwitchSlavedToUniqueID"));
            cbhd._mGUIGeneratedAtLeastOnceAlready = this.loadBoolean(lvl1.getChild("GUIGeneratedAtLeastOnceAlready"));
            cbhd._mCodeButtonDelayTime = this.loadInt(lvl1.getChild("CodeButtonDelayTime"));
            log.debug("------------- SIDI ------------");
            cbhd._mSIDI_Enabled = this.loadBoolean(lvl1.getChild("SIDI_Enabled"));
            cbhd._mSIDI_LeftInternalSensor = this.loadSensor(lvl1.getChild("SIDI_LeftInternalSensor"), true);
            cbhd._mSIDI_NormalInternalSensor = this.loadSensor(lvl1.getChild("SIDI_NormalInternalSensor"), true);
            cbhd._mSIDI_RightInternalSensor = this.loadSensor(lvl1.getChild("SIDI_RightInternalSensor"), true);
            cbhd._mSIDI_CodingTimeInMilliseconds = this.loadInt(lvl1.getChild("SIDI_CodingTimeInMilliseconds"));
            cbhd._mSIDI_TimeLockingTimeInMilliseconds = this.loadInt(lvl1.getChild("SIDI_TimeLockingTimeInMilliseconds"));
            cbhd._mSIDI_TrafficDirection = CodeButtonHandlerData.TRAFFIC_DIRECTION.valueOf(this.loadString(lvl1.getChild("SIDI_TrafficDirection")));
            cbhd._mSIDI_LeftRightTrafficSignals = this.getSignalList(lvl1.getChild("SIDI_LeftRightTrafficSignals"));
            cbhd._mSIDI_RightLeftTrafficSignals = this.getSignalList(lvl1.getChild("SIDI_RightLeftTrafficSignals"));
            log.debug("------------- SIDL ------------");
            cbhd._mSIDL_Enabled = this.loadBoolean(lvl1.getChild("SIDL_Enabled"));
            cbhd._mSIDL_LeftInternalSensor = this.loadSensor(lvl1.getChild("SIDL_LeftInternalSensor"), true);
            cbhd._mSIDL_NormalInternalSensor = this.loadSensor(lvl1.getChild("SIDL_NormalInternalSensor"), true);
            cbhd._mSIDL_RightInternalSensor = this.loadSensor(lvl1.getChild("SIDL_RightInternalSensor"), true);
            log.debug("------------- SWDI ------------");
            cbhd._mSWDI_Enabled = this.loadBoolean(lvl1.getChild("SWDI_Enabled"));
            cbhd._mSWDI_NormalInternalSensor = this.loadSensor(lvl1.getChild("SWDI_NormalInternalSensor"), true);
            cbhd._mSWDI_ReversedInternalSensor = this.loadSensor(lvl1.getChild("SWDI_ReversedInternalSensor"), true);
            cbhd._mSWDI_ExternalTurnout = this.loadTurnout(lvl1.getChild("SWDI_ExternalTurnout"), lvl1.getChild("SWDI_FeedbackDifferent"));
            cbhd._mSWDI_CodingTimeInMilliseconds = this.loadInt(lvl1.getChild("SWDI_CodingTimeInMilliseconds"));
            cbhd._mSWDI_FeedbackDifferent = this.loadBoolean(lvl1.getChild("SWDI_FeedbackDifferent"));
            cbhd._mSWDI_GUITurnoutType = CodeButtonHandlerData.TURNOUT_TYPE.getTurnoutType(this.loadInt(lvl1.getChild("SWDI_GUITurnoutType")));
            cbhd._mSWDI_GUITurnoutLeftHand = this.loadBoolean(lvl1.getChild("SWDI_GUITurnoutLeftHand"));
            cbhd._mSWDI_GUICrossoverLeftHand = this.loadBoolean(lvl1.getChild("SWDI_GUICrossoverLeftHand"));
            log.debug("------------- SWDL ------------");
            cbhd._mSWDL_Enabled = this.loadBoolean(lvl1.getChild("SWDL_Enabled"));
            cbhd._mSWDL_InternalSensor = this.loadSensor(lvl1.getChild("SWDL_InternalSensor"), true);
            log.debug("-------------  CO  ------------");
            cbhd._mCO_Enabled = this.loadBoolean(lvl1.getChild("CO_Enabled"));
            cbhd._mCO_CallOnToggleInternalSensor = this.loadSensor(lvl1.getChild("CO_CallOnToggleInternalSensor"), true);
            cbhd._mCO_GroupingsList = this.getCallOnList(lvl1.getChild("CO_GroupingsList"));
            log.debug("------------- TRL  ------------");
            cbhd._mTRL_Enabled = this.loadBoolean(lvl1.getChild("TRL_Enabled"));
            cbhd._mTRL_LeftTrafficLockingRules = this.getTrafficLocking(lvl1.getChild("TRL_LeftRules"));
            cbhd._mTRL_RightTrafficLockingRules = this.getTrafficLocking(lvl1.getChild("TRL_RightRules"));
            log.debug("------------- TUL  ------------");
            cbhd._mTUL_Enabled = this.loadBoolean(lvl1.getChild("TUL_Enabled"));
            cbhd._mTUL_DispatcherInternalSensorLockToggle = this.loadSensor(lvl1.getChild("TUL_DispatcherInternalSensorLockToggle"), true);
            cbhd._mTUL_ExternalTurnout = this.loadTurnout(lvl1.getChild("TUL_ExternalTurnout"), lvl1.getChild("TUL_ExternalTurnoutFeedbackDifferent"));
            cbhd._mTUL_ExternalTurnoutFeedbackDifferent = this.loadBoolean(lvl1.getChild("TUL_ExternalTurnoutFeedbackDifferent"));
            cbhd._mTUL_DispatcherInternalSensorUnlockedIndicator = this.loadSensor(lvl1.getChild("TUL_DispatcherInternalSensorUnlockedIndicator"), true);
            cbhd._mTUL_NoDispatcherControlOfSwitch = this.loadBoolean(lvl1.getChild("TUL_NoDispatcherControlOfSwitch"));
            cbhd._mTUL_ndcos_WhenLockedSwitchStateIsClosed = this.loadBoolean(lvl1.getChild("TUL_ndcos_WhenLockedSwitchStateIsClosed"));
            cbhd._mTUL_GUI_IconsEnabled = this.loadBoolean(lvl1.getChild("TUL_GUI_IconsEnabled"));
            cbhd._mTUL_LockImplementation = CodeButtonHandlerData.LOCK_IMPLEMENTATION.getLockImplementation(this.loadInt(lvl1.getChild("TUL_LockImplementation")));
            this.loadAdditionalTurnouts(lvl1.getChild("TUL_AdditionalExternalTurnouts"), cbhd);
            log.debug("-------------  IL  ------------");
            cbhd._mIL_Enabled = this.loadBoolean(lvl1.getChild("IL_Enabled"));
            cbhd._mIL_Signals = this.getSignalList(lvl1.getChild("IL_Signals"));
        }
        this.convertCallOnSensorNamesToNBHSensors(this.cm);
        return true;
    }

    void loadProperties(CtcManager cm, Element el) {
        ProgramProperties pp = cm.getProgramProperties();
        pp._mCodeButtonInternalSensorPattern = this.loadString(el.getChild("CodeButtonInternalSensorPattern"));
        pp._mSIDI_CodingTimeInMilliseconds = this.loadInt(el.getChild("SIDI_CodingTimeInMilliseconds"));
        pp._mSIDI_LeftInternalSensorPattern = this.loadString(el.getChild("SIDI_LeftInternalSensorPattern"));
        pp._mSIDI_NormalInternalSensorPattern = this.loadString(el.getChild("SIDI_NormalInternalSensorPattern"));
        pp._mSIDI_RightInternalSensorPattern = this.loadString(el.getChild("SIDI_RightInternalSensorPattern"));
        pp._mSIDI_TimeLockingTimeInMilliseconds = this.loadInt(el.getChild("SIDI_TimeLockingTimeInMilliseconds"));
        pp._mSIDL_LeftInternalSensorPattern = this.loadString(el.getChild("SIDL_LeftInternalSensorPattern"));
        pp._mSIDL_NormalInternalSensorPattern = this.loadString(el.getChild("SIDL_NormalInternalSensorPattern"));
        pp._mSIDL_RightInternalSensorPattern = this.loadString(el.getChild("SIDL_RightInternalSensorPattern"));
        pp._mSWDI_CodingTimeInMilliseconds = this.loadInt(el.getChild("SWDI_CodingTimeInMilliseconds"));
        pp._mSWDI_NormalInternalSensorPattern = this.loadString(el.getChild("SWDI_NormalInternalSensorPattern"));
        pp._mSWDI_ReversedInternalSensorPattern = this.loadString(el.getChild("SWDI_ReversedInternalSensorPattern"));
        pp._mSWDL_InternalSensorPattern = this.loadString(el.getChild("SWDL_InternalSensorPattern"));
        pp._mCO_CallOnToggleInternalSensorPattern = this.loadString(el.getChild("CO_CallOnToggleInternalSensorPattern"));
        pp._mTUL_DispatcherInternalSensorLockTogglePattern = this.loadString(el.getChild("TUL_DispatcherInternalSensorLockTogglePattern"));
        pp._mTUL_DispatcherInternalSensorUnlockedIndicatorPattern = this.loadString(el.getChild("TUL_DispatcherInternalSensorUnlockedIndicatorPattern"));
        pp._mCodeButtonDelayTime = this.loadInt(el.getChild("CodeButtonDelayTime"));
    }

    void loadOtherData(CtcManager cm, Element el) {
        OtherData od = cm.getOtherData();
        String xmlVersion = this.loadString(el.getChild("CtcVersion"));
        String string = xmlVersion = xmlVersion == null ? "v2.0" : xmlVersion;
        if (!xmlVersion.equals("v2.0")) {
            log.warn("Update from version {} to version {} required", (Object)xmlVersion, (Object)"v2.0");
        }
        od._mFleetingToggleInternalSensor = this.loadSensor(el.getChild("FleetingToggleInternalSensor"), true);
        od._mDefaultFleetingEnabled = this.loadBoolean(el.getChild("DefaultFleetingEnabled"));
        od._mTUL_EnabledAtStartup = this.loadBoolean(el.getChild("TUL_EnabledAtStartup"));
        od._mSignalSystemType = OtherData.SIGNAL_SYSTEM_TYPE.getSignalSystemType(this.loadInt(el.getChild("SignalSystemType")));
        od._mTUL_SecondsToLockTurnouts = this.loadInt(el.getChild("TUL_SecondsToLockTurnouts"));
        od._mNextUniqueNumber = this.loadInt(el.getChild("NextUniqueNumber"));
        od._mCTCDebugSystemReloadInternalSensor = this.loadSensor(el.getChild("CTCDebugSystemReloadInternalSensor"), true);
        od._mCTCDebug_TrafficLockingRuleTriggeredDisplayInternalSensor = this.loadSensor(el.getChild("CTCDebug_TrafficLockingRuleTriggeredDisplayInternalSensor"), true);
        od._mGUIDesign_NumberOfEmptyColumnsAtEnd = this.loadInt(el.getChild("GUIDesign_NumberOfEmptyColumnsAtEnd"));
        od._mGUIDesign_CTCPanelType = OtherData.CTC_PANEL_TYPE.getRadioGroupValue(this.loadInt(el.getChild("GUIDesign_CTCPanelType")));
        od._mGUIDesign_BuilderPlate = this.loadBoolean(el.getChild("GUIDesign_BuilderPlate"));
        od._mGUIDesign_SignalsOnPanel = OtherData.SIGNALS_ON_PANEL.getRadioGroupValue(this.loadInt(el.getChild("GUIDesign_SignalsOnPanel")));
        od._mGUIDesign_FleetingToggleSwitch = this.loadBoolean(el.getChild("GUIDesign_FleetingToggleSwitch"));
        od._mGUIDesign_AnalogClockEtc = this.loadBoolean(el.getChild("GUIDesign_AnalogClockEtc"));
        od._mGUIDesign_ReloadCTCSystemButton = this.loadBoolean(el.getChild("GUIDesign_ReloadCTCSystemButton"));
        od._mGUIDesign_CTCDebugOnToggle = this.loadBoolean(el.getChild("GUIDesign_CTCDebugOnToggle"));
        od._mGUIDesign_CreateTrackPieces = this.loadBoolean(el.getChild("GUIDesign_CreateTrackPieces"));
        od._mGUIDesign_VerticalSize = OtherData.VERTICAL_SIZE.getRadioGroupValue(this.loadInt(el.getChild("GUIDesign_VerticalSize")));
        od._mGUIDesign_OSSectionUnknownInconsistentRedBlink = this.loadBoolean(el.getChild("GUIDesign_OSSectionUnknownInconsistentRedBlink"));
        od._mGUIDesign_TurnoutsOnPanel = this.loadBoolean(el.getChild("GUIDesign_TurnoutsOnPanel"));
    }

    String loadString(Element element) {
        String newString = null;
        if (element != null) {
            newString = element.getValue();
        }
        return newString;
    }

    int loadInt(Element element) {
        int newInt = 0;
        if (element != null) {
            try {
                newInt = Integer.parseInt(element.getValue());
            }
            catch (NumberFormatException ex) {
                log.warn("loadInt format exception: element = {}, value = {}", (Object)element.getName(), (Object)element.getValue());
            }
        }
        return newInt;
    }

    boolean loadBoolean(Element element) {
        boolean newBoolean = false;
        if (element != null) {
            newBoolean = element.getValue().equals("true");
        }
        return newBoolean;
    }

    NBHSensor loadSensor(Element element, boolean isInternal) {
        NBHSensor sensor = null;
        if (element != null && element.getValue() != null && !element.getValue().isEmpty()) {
            String sensorName = element.getValue();
            sensor = this.cm.getNBHSensor(sensorName);
            if (sensor == null) {
                sensor = isInternal ? new NBHSensor("CtcManagerXml", "create internal = ", sensorName, sensorName) : new NBHSensor("CtcManagerXml", "create standard = ", sensorName, sensorName, false);
            }
        } else {
            sensor = new NBHSensor("CtcManagerXml", "", "Empty NBHSensor", "", true);
        }
        return sensor;
    }

    NBHSignal loadSignal(Element element) {
        NBHSignal signal = null;
        if (element != null && element.getValue() != null && !element.getValue().isEmpty()) {
            String signalName = element.getValue();
            signal = this.cm.getNBHSignal(signalName);
            if (signal == null) {
                signal = new NBHSignal(element.getValue());
            }
        } else {
            signal = new NBHSignal("");
        }
        return signal;
    }

    NBHTurnout loadTurnout(Element element, Element feedback) {
        NBHTurnout turnout = null;
        boolean feedBack = this.loadBoolean(feedback);
        if (element != null && element.getValue() != null && !element.getValue().isEmpty()) {
            String turnoutName = element.getValue();
            turnout = this.cm.getNBHTurnout(turnoutName);
            if (turnout == null) {
                turnout = new NBHTurnout("CtcManagerXml", "", element.getValue(), element.getValue(), feedBack);
            }
        } else {
            turnout = new NBHTurnout("CtcManagerXml", "Empty NBHTurnout", "");
        }
        return turnout;
    }

    NamedBeanHandle<Block> loadBlock(Element element) {
        Block block;
        NamedBeanHandle<Block> blockHandle = null;
        if (element != null && element.getValue() != null && !element.getValue().isEmpty() && (blockHandle = this.cm.getBlock(element.getValue())) == null && (block = InstanceManager.getDefault(BlockManager.class).getBlock(element.getValue())) != null) {
            blockHandle = InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(element.getValue(), block);
            this.cm.putBlock(element.getValue(), blockHandle);
        }
        return blockHandle;
    }

    ArrayList<NBHSensor> getSensorList(Element element) {
        ArrayList<NBHSensor> sensorList = new ArrayList<NBHSensor>();
        if (element != null) {
            for (Element el : element.getChildren()) {
                NBHSensor sensor = this.loadSensor(el, false);
                sensorList.add(sensor);
            }
        }
        return sensorList;
    }

    ArrayList<NBHSignal> getSignalList(Element element) {
        ArrayList<NBHSignal> signalList = new ArrayList<NBHSignal>();
        if (element != null) {
            for (Element el : element.getChildren()) {
                NBHSignal signal = this.loadSignal(el);
                signalList.add(signal);
            }
        }
        return signalList;
    }

    ArrayList<CallOnData> getCallOnList(Element element) {
        ArrayList<CallOnData> callOnList = new ArrayList<CallOnData>();
        if (element != null) {
            for (Element elCallOn : element.getChildren()) {
                CallOnData cod = new CallOnData();
                cod._mExternalSignal = this.loadSignal(elCallOn.getChild("ExternalSignal"));
                cod._mSignalFacingDirection = this.loadString(elCallOn.getChild("SignalFacingDirection"));
                cod._mSignalAspectToDisplay = this.loadString(elCallOn.getChild("SignalAspectToDisplay"));
                cod._mCalledOnExternalSensor = this.loadSensor(elCallOn.getChild("CalledOnExternalSensor"), false);
                cod._mExternalBlock = this.loadBlock(elCallOn.getChild("ExternalBlock"));
                cod._mSwitchIndicators = new ArrayList();
                cod._mSwitchIndicatorNames = this.getCallOnSensorNames(elCallOn.getChild("SwitchIndicators"));
                callOnList.add(cod);
            }
        }
        return callOnList;
    }

    ArrayList<String> getCallOnSensorNames(Element element) {
        ArrayList<String> sensorList = new ArrayList<String>();
        if (element != null) {
            for (Element el : element.getChildren()) {
                sensorList.add(el.getValue());
            }
        }
        return sensorList;
    }

    void convertCallOnSensorNamesToNBHSensors(CtcManager cm) {
        for (CodeButtonHandlerData cbhd : cm.getCTCSerialData().getCodeButtonHandlerDataArrayList()) {
            for (CallOnData cod : cbhd._mCO_GroupingsList) {
                for (String sensorName : cod._mSwitchIndicatorNames) {
                    NBHSensor sensor = cm.getNBHSensor(sensorName);
                    if (sensor == null) continue;
                    cod._mSwitchIndicators.add(sensor);
                }
            }
        }
    }

    ArrayList<TrafficLockingData> getTrafficLocking(Element element) {
        ArrayList<TrafficLockingData> trlData = new ArrayList<TrafficLockingData>();
        if (element != null) {
            for (Element elRule : element.getChildren()) {
                TrafficLockingData trl = new TrafficLockingData();
                trl._mUserRuleNumber = this.loadString(elRule.getChild("UserRuleNumber"));
                trl._mRuleEnabled = this.loadString(elRule.getChild("RuleEnabled"));
                trl._mDestinationSignalOrComment = this.loadString(elRule.getChild("DestinationSignalOrComment"));
                trl._mSwitchAlignments = this.getTRLSwitchList(elRule.getChild("switches"));
                trl._mOccupancyExternalSensors = this.getSensorList(elRule.getChild("OccupancyExternalSensors"));
                trl._mOptionalExternalSensors = this.getSensorList(elRule.getChild("OptionalExternalSensors"));
                trlData.add(trl);
            }
        }
        return trlData;
    }

    ArrayList<TrafficLockingData.TRLSwitch> getTRLSwitchList(Element element) {
        ArrayList<TrafficLockingData.TRLSwitch> trlSwitches = new ArrayList<TrafficLockingData.TRLSwitch>();
        if (element != null) {
            for (Element elSwitch : element.getChildren()) {
                String userText = this.loadString(elSwitch.getChild("UserText"));
                if (userText == null || userText.isEmpty()) continue;
                TrafficLockingData.TRLSwitch newSwitch = new TrafficLockingData.TRLSwitch(userText, this.loadString(elSwitch.getChild("SwitchAlignment")), this.loadInt(elSwitch.getChild("UniqueID")));
                trlSwitches.add(newSwitch);
            }
        }
        return trlSwitches;
    }

    void loadAdditionalTurnouts(Element element, CodeButtonHandlerData cbhd) {
        if (element != null) {
            int rowNumber = 0;
            for (Element elTurnout : element.getChildren()) {
                NBHTurnout turnout = this.loadTurnout(elTurnout.getChild("TUL_AdditionalExternalTurnout"), elTurnout.getChild("TUL_AdditionalExternalTurnoutFeedbackDifferent"));
                boolean feedback = this.loadBoolean(elTurnout.getChild("TUL_AdditionalExternalTurnoutFeedbackDifferent"));
                if (++rowNumber == 1) {
                    cbhd._mTUL_AdditionalExternalTurnout1 = turnout;
                    cbhd._mTUL_AdditionalExternalTurnout1FeedbackDifferent = feedback;
                }
                if (rowNumber == 2) {
                    cbhd._mTUL_AdditionalExternalTurnout2 = turnout;
                    cbhd._mTUL_AdditionalExternalTurnout2FeedbackDifferent = feedback;
                }
                if (rowNumber != 3) continue;
                cbhd._mTUL_AdditionalExternalTurnout3 = turnout;
                cbhd._mTUL_AdditionalExternalTurnout3FeedbackDifferent = feedback;
            }
        }
    }

    @Override
    public int loadOrder() {
        return InstanceManager.getDefault(CtcManager.class).getXMLOrder();
    }
}

