/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.ctc.configurexml;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import jmri.jmrit.ctc.CTCFiles;

public class ImportCodeButtonHandlerData
implements Serializable {
    private static final int FILE_VERSION = 6;
    public static final int SWITCH_NOT_SLAVED = -1;
    private static final long serialVersionUID = 1L;
    public int _mUniqueID = -1;
    public int _mSwitchNumber;
    public int _mSignalEtcNumber;
    public int _mFileVersion;
    public String _mCodeButtonInternalSensor;
    public String _mOSSectionOccupiedExternalSensor;
    public String _mOSSectionOccupiedExternalSensor2;
    public int _mOSSectionSwitchSlavedToUniqueID = -1;
    public int _mGUIColumnNumber;
    public boolean _mGUIGeneratedAtLeastOnceAlready;
    public int _mCodeButtonDelayTime;
    public boolean _mSIDI_Enabled;
    public String _mSIDI_LeftInternalSensor;
    public String _mSIDI_NormalInternalSensor;
    public String _mSIDI_RightInternalSensor;
    public int _mSIDI_CodingTimeInMilliseconds;
    public int _mSIDI_TimeLockingTimeInMilliseconds;
    public String _mSIDI_LeftRightTrafficSignalsCSVList;
    public String _mSIDI_RightLeftTrafficSignalsCSVList;
    public boolean _mSIDL_Enabled;
    public String _mSIDL_LeftInternalSensor;
    public String _mSIDL_NormalInternalSensor;
    public String _mSIDL_RightInternalSensor;
    public boolean _mSWDI_Enabled;
    public String _mSWDI_NormalInternalSensor;
    public String _mSWDI_ReversedInternalSensor;
    public String _mSWDI_ExternalTurnout;
    public int _mSWDI_CodingTimeInMilliseconds;
    public boolean _mSWDI_FeedbackDifferent;
    public TURNOUT_TYPE _mSWDI_GUITurnoutType = TURNOUT_TYPE.TURNOUT;
    public boolean _mSWDI_GUITurnoutLeftHand;
    public boolean _mSWDI_GUICrossoverLeftHand;
    public boolean _mSWDL_Enabled;
    public String _mSWDL_InternalSensor;
    public boolean _mCO_Enabled;
    public String _mCO_CallOnToggleInternalSensor;
    public String _mCO_GroupingsListString;
    public boolean _mTRL_Enabled;
    public String _mTRL_LeftTrafficLockingRulesSSVList;
    public String _mTRL_RightTrafficLockingRulesSSVList;
    public boolean _mTUL_Enabled;
    public String _mTUL_DispatcherInternalSensorLockToggle;
    public String _mTUL_ExternalTurnout;
    public boolean _mTUL_ExternalTurnoutFeedbackDifferent;
    public String _mTUL_DispatcherInternalSensorUnlockedIndicator;
    public boolean _mTUL_NoDispatcherControlOfSwitch;
    public boolean _mTUL_ndcos_WhenLockedSwitchStateIsClosed;
    public LOCK_IMPLEMENTATION _mTUL_LockImplementation = LOCK_IMPLEMENTATION.GREGS;
    public String _mTUL_AdditionalExternalTurnout1;
    public boolean _mTUL_AdditionalExternalTurnout1FeedbackDifferent;
    public String _mTUL_AdditionalExternalTurnout2;
    public boolean _mTUL_AdditionalExternalTurnout2FeedbackDifferent;
    public String _mTUL_AdditionalExternalTurnout3;
    public boolean _mTUL_AdditionalExternalTurnout3FeedbackDifferent;
    public boolean _mIL_Enabled;
    public String _mIL_ListOfCSVSignalNames;
    private static final String FILE_VERSION_STRING = "<string>_mFileVersion</string>";
    private static final String LESS_THAN_SIGN = "<";
    private static final String TEMPORARY_EXTENSION = ".xmlTMP";
    private static final String INT_START_STRING = "<int>";
    private static final String INT_END_STRING = "</int>";
    private static final String STRING_START_STRING = "<string>";
    private static final String STRING_END_STRING = "</string>";

    public void upgradeSelf() {
        block3: for (int oldVersion = this._mFileVersion; oldVersion < 6; ++oldVersion) {
            switch (oldVersion) {
                case 0: 
                case 1: 
                case 2: 
                case 3: {
                    this._mTRL_Enabled = false;
                    this._mTRL_LeftTrafficLockingRulesSSVList = "";
                    this._mTRL_RightTrafficLockingRulesSSVList = "";
                    continue block3;
                }
            }
        }
        this._mFileVersion = 6;
    }

    @SuppressFBWarnings(value={"NP_IMMEDIATE_DEREFERENCE_OF_READLINE"}, justification="I'm already catching 'NullPointerException', it's ok!")
    public static void preprocessingUpgradeSelf(String filename) {
        int fileVersion = -1;
        try (BufferedReader bufferedReader = new BufferedReader(new FileReader(filename));){
            String aLine;
            while (!(aLine = bufferedReader.readLine()).contains(FILE_VERSION_STRING)) {
            }
            bufferedReader.readLine();
            bufferedReader.readLine();
            aLine = bufferedReader.readLine().trim();
            if (aLine.startsWith(INT_START_STRING)) {
                aLine = aLine.substring(5);
                fileVersion = Integer.parseInt(aLine.substring(0, aLine.indexOf(LESS_THAN_SIGN)));
            }
        }
        catch (IOException | NullPointerException | NumberFormatException exception) {
            // empty catch block
        }
        if (fileVersion < 0) {
            return;
        }
        switch (fileVersion) {
            case 4: {
                ImportCodeButtonHandlerData.upgradeVersion4FileTo5(filename);
                break;
            }
            case 5: {
                ImportCodeButtonHandlerData.upgradeVersion5FileTo6(filename);
                break;
            }
        }
    }

    @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED_BAD_PRACTICE"}, justification="Any problems, I don't care, it's too late by this point")
    private static void upgradeVersion4FileTo5(String filename) {
        String temporaryFilename = CTCFiles.changeExtensionTo(filename, TEMPORARY_EXTENSION);
        new File(temporaryFilename).delete();
        boolean hadAChange = false;
        try (BufferedReader bufferedReader = new BufferedReader(new FileReader(filename));
             BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(temporaryFilename));){
            String aLine = null;
            while ((aLine = bufferedReader.readLine()) != null) {
                if ((aLine = ImportCodeButtonHandlerData.checkFileVersion(bufferedReader, bufferedWriter, aLine, "4", "5")) == null) {
                    hadAChange = true;
                    continue;
                }
                if ((aLine = ImportCodeButtonHandlerData.checkForRefactor(bufferedWriter, aLine, "_mSWDI_ActualTurnout", "_mSWDI_ExternalTurnout")) == null) {
                    hadAChange = true;
                    continue;
                }
                if ((aLine = ImportCodeButtonHandlerData.checkForRefactor(bufferedWriter, aLine, "_mTUL_ActualTurnout", "_mTUL_ExternalTurnout")) == null) {
                    hadAChange = true;
                    continue;
                }
                if ((aLine = ImportCodeButtonHandlerData.checkForRefactor(bufferedWriter, aLine, "_mTUL_ActualTurnoutFeedbackDifferent", "_mTUL_ExternalTurnoutFeedbackDifferent")) == null) {
                    hadAChange = true;
                    continue;
                }
                if ((aLine = ImportCodeButtonHandlerData.checkForRefactor(bufferedWriter, aLine, "_mTUL_AdditionalTurnout1", "_mTUL_AdditionalExternalTurnout1")) == null) {
                    hadAChange = true;
                    continue;
                }
                if ((aLine = ImportCodeButtonHandlerData.checkForRefactor(bufferedWriter, aLine, "_mTUL_AdditionalTurnout1FeedbackDifferent", "_mTUL_AdditionalExternalTurnout1FeedbackDifferent")) == null) {
                    hadAChange = true;
                    continue;
                }
                if ((aLine = ImportCodeButtonHandlerData.checkForRefactor(bufferedWriter, aLine, "_mTUL_AdditionalTurnout2", "_mTUL_AdditionalExternalTurnout2")) == null) {
                    hadAChange = true;
                    continue;
                }
                if ((aLine = ImportCodeButtonHandlerData.checkForRefactor(bufferedWriter, aLine, "_mTUL_AdditionalTurnout2FeedbackDifferent", "_mTUL_AdditionalExternalTurnout2FeedbackDifferent")) == null) {
                    hadAChange = true;
                    continue;
                }
                if ((aLine = ImportCodeButtonHandlerData.checkForRefactor(bufferedWriter, aLine, "_mTUL_AdditionalTurnout3", "_mTUL_AdditionalExternalTurnout3")) == null) {
                    hadAChange = true;
                    continue;
                }
                if ((aLine = ImportCodeButtonHandlerData.checkForRefactor(bufferedWriter, aLine, "_mTUL_AdditionalTurnout3FeedbackDifferent", "_mTUL_AdditionalExternalTurnout3FeedbackDifferent")) == null) {
                    hadAChange = true;
                    continue;
                }
                ImportCodeButtonHandlerData.writeLine(bufferedWriter, aLine);
            }
            if (hadAChange) {
                bufferedReader.close();
                bufferedWriter.close();
                File oldFile = new File(filename);
                oldFile.delete();
                new File(temporaryFilename).renameTo(oldFile);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        new File(temporaryFilename).delete();
    }

    @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED_BAD_PRACTICE"}, justification="Any problems, I don't care, it's too late by this point")
    private static void upgradeVersion5FileTo6(String filename) {
        String temporaryFilename = CTCFiles.changeExtensionTo(filename, TEMPORARY_EXTENSION);
        new File(temporaryFilename).delete();
        boolean hadAChange = false;
        try (BufferedReader bufferedReader = new BufferedReader(new FileReader(filename));
             BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(temporaryFilename));){
            String aLine = null;
            while ((aLine = bufferedReader.readLine()) != null) {
                if ((aLine = ImportCodeButtonHandlerData.checkFileVersion(bufferedReader, bufferedWriter, aLine, "5", "6")) == null) {
                    hadAChange = true;
                    continue;
                }
                if ((aLine = ImportCodeButtonHandlerData.checkForMultipleSemiColons(bufferedWriter, aLine)) == null) {
                    hadAChange = true;
                    continue;
                }
                ImportCodeButtonHandlerData.writeLine(bufferedWriter, aLine);
            }
            if (hadAChange) {
                bufferedReader.close();
                bufferedWriter.close();
                File oldFile = new File(filename);
                oldFile.delete();
                new File(temporaryFilename).renameTo(oldFile);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        new File(temporaryFilename).delete();
    }

    private static String checkFileVersion(BufferedReader bufferedReader, BufferedWriter bufferedWriter, String aLine, String oldVersion, String newVersion) throws IOException {
        if (aLine.contains(FILE_VERSION_STRING)) {
            ImportCodeButtonHandlerData.writeLine(bufferedWriter, aLine);
            ImportCodeButtonHandlerData.writeLine(bufferedWriter, bufferedReader.readLine());
            ImportCodeButtonHandlerData.writeLine(bufferedWriter, bufferedReader.readLine());
            aLine = bufferedReader.readLine();
            if (aLine != null) {
                int intStart = aLine.indexOf(INT_START_STRING + oldVersion + INT_END_STRING);
                if (intStart >= 0) {
                    ImportCodeButtonHandlerData.writeLine(bufferedWriter, aLine.substring(0, intStart) + INT_START_STRING + newVersion + INT_END_STRING);
                } else {
                    ImportCodeButtonHandlerData.writeLine(bufferedWriter, aLine);
                }
            }
            return null;
        }
        return aLine;
    }

    private static String checkForRefactor(BufferedWriter bufferedWriter, String aLine, String oldName, String newName) throws IOException {
        int intStart = aLine.indexOf(STRING_START_STRING + oldName + STRING_END_STRING);
        if (intStart >= 0) {
            ImportCodeButtonHandlerData.writeLine(bufferedWriter, aLine.substring(0, intStart) + STRING_START_STRING + newName + STRING_END_STRING);
            return null;
        }
        return aLine;
    }

    private static String checkForMultipleSemiColons(BufferedWriter bufferedWriter, String aLine) throws IOException {
        int intStart = aLine.indexOf(STRING_START_STRING);
        int intEnd = aLine.indexOf(STRING_END_STRING);
        if (intStart >= 0 && intEnd >= 0 && intStart < intEnd) {
            while (aLine.contains(";;")) {
                aLine = aLine.replace(";;", ";");
            }
        }
        if (intStart >= 0) {
            ImportCodeButtonHandlerData.writeLine(bufferedWriter, aLine);
            return null;
        }
        return aLine;
    }

    private static void writeLine(BufferedWriter bufferedWriter, String aLine) throws IOException {
        bufferedWriter.write(aLine);
        bufferedWriter.newLine();
    }

    public static enum TURNOUT_TYPE {
        TURNOUT(0),
        CROSSOVER(1),
        DOUBLE_CROSSOVER(2);

        private final int _mRadioGroupValue;
        private static final HashMap<Integer, TURNOUT_TYPE> map;

        private TURNOUT_TYPE(int radioGroupValue) {
            this._mRadioGroupValue = radioGroupValue;
        }

        static {
            map = new HashMap();
            for (TURNOUT_TYPE value : TURNOUT_TYPE.values()) {
                map.put(value._mRadioGroupValue, value);
            }
        }
    }

    public static enum LOCK_IMPLEMENTATION {
        GREGS(0),
        OTHER(1);

        private final int _mRadioGroupValue;
        private static final HashMap<Integer, LOCK_IMPLEMENTATION> map;

        private LOCK_IMPLEMENTATION(int radioGroupValue) {
            this._mRadioGroupValue = radioGroupValue;
        }

        static {
            map = new HashMap();
            for (LOCK_IMPLEMENTATION value : LOCK_IMPLEMENTATION.values()) {
                map.put(value._mRadioGroupValue, value);
            }
        }
    }
}

