/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.ctc.ctcserialdata;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import jmri.Turnout;
import jmri.jmrit.ctc.ctcserialdata.CodeButtonHandlerData;
import jmri.jmrit.ctc.ctcserialdata.OtherData;
import jmri.jmrit.ctc.ctcserialdata.TrafficLockingData;

public class CTCSerialData {
    private OtherData _mOtherData = new OtherData();
    private ArrayList<CodeButtonHandlerData> _mCodeButtonHandlerDataArrayList = new ArrayList();

    public OtherData getOtherData() {
        return this._mOtherData;
    }

    public int getUniqueNumber() {
        return this._mOtherData.getNextUniqueNumber();
    }

    public CodeButtonHandlerData getCodeButtonHandlerDataViaUniqueID(int uniqueID) {
        for (CodeButtonHandlerData codeButtonHandlerData : this._mCodeButtonHandlerDataArrayList) {
            if (codeButtonHandlerData._mUniqueID != uniqueID) continue;
            return codeButtonHandlerData;
        }
        return null;
    }

    public String getMyShortStringNoCommaViaUniqueID(int uniqueID) {
        for (CodeButtonHandlerData codeButtonHandlerData : this._mCodeButtonHandlerDataArrayList) {
            if (codeButtonHandlerData._mUniqueID != uniqueID) continue;
            return codeButtonHandlerData.myShortStringNoComma();
        }
        return "UNKNOWN";
    }

    public int getIndexOfUniqueID(int uniqueID) {
        for (int index = 0; index < this._mCodeButtonHandlerDataArrayList.size(); ++index) {
            if (this._mCodeButtonHandlerDataArrayList.get((int)index)._mUniqueID != uniqueID) continue;
            return index;
        }
        return -1;
    }

    public void setOtherData(OtherData otherData) {
        this._mOtherData = otherData;
    }

    public ArrayList<CodeButtonHandlerData> getCodeButtonHandlerDataArrayList() {
        return this._mCodeButtonHandlerDataArrayList;
    }

    public void addCodeButtonHandlerData(CodeButtonHandlerData codeButtonHandlerData) {
        this._mCodeButtonHandlerDataArrayList.add(codeButtonHandlerData);
    }

    public void removeCodeButtonHandlerData(int index) {
        this._mCodeButtonHandlerDataArrayList.remove(index);
    }

    public CodeButtonHandlerData getCodeButtonHandlerData(int index) {
        return this._mCodeButtonHandlerDataArrayList.get(index);
    }

    public int getCodeButtonHandlerDataSize() {
        return this._mCodeButtonHandlerDataArrayList.size();
    }

    public void moveUp(int index) {
        try {
            Collections.swap(this._mCodeButtonHandlerDataArrayList, index, index - 1);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    public void moveDown(int index) {
        try {
            Collections.swap(this._mCodeButtonHandlerDataArrayList, index, index + 1);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    public void updateSwitchAndSignalEtcNumbersEverywhere(int index, int newSwitchNumber, int newSignalEtcNumber, int newGUIColumnNumber, boolean newGUIGeneratedAtLeastOnceAlready) {
        CodeButtonHandlerData codeButtonHandlerData = this._mCodeButtonHandlerDataArrayList.get(index);
        codeButtonHandlerData._mSwitchNumber = newSwitchNumber;
        codeButtonHandlerData._mSignalEtcNumber = newSignalEtcNumber;
        codeButtonHandlerData._mGUIColumnNumber = newGUIColumnNumber;
        codeButtonHandlerData._mGUIGeneratedAtLeastOnceAlready = newGUIGeneratedAtLeastOnceAlready;
        int UniqueIDBeingModified = codeButtonHandlerData._mUniqueID;
        String replacementString = codeButtonHandlerData.myShortStringNoComma();
        for (CodeButtonHandlerData temp : this._mCodeButtonHandlerDataArrayList) {
            this.updateTrlUserText(temp._mTRL_LeftTrafficLockingRules, UniqueIDBeingModified, replacementString);
            this.updateTrlUserText(temp._mTRL_RightTrafficLockingRules, UniqueIDBeingModified, replacementString);
        }
    }

    private void updateTrlUserText(ArrayList<TrafficLockingData> rulesToFix, int uniqueIDBeingModified, String replacementString) {
        rulesToFix.forEach(rule -> rule._mSwitchAlignments.forEach(alignment -> {
            if (uniqueIDBeingModified == alignment._mUniqueID) {
                alignment._mUserText = replacementString;
            }
        }));
    }

    public void setCodeButtonHandlerData(int index, CodeButtonHandlerData codeButtonHandlerData) {
        this._mCodeButtonHandlerDataArrayList.set(index, codeButtonHandlerData);
    }

    public int findHighestSwitchNumberUsedSoFar() {
        int highestSwitchNumber = -1;
        for (CodeButtonHandlerData codeButtonHandlerData : this._mCodeButtonHandlerDataArrayList) {
            if (codeButtonHandlerData._mSwitchNumber <= highestSwitchNumber) continue;
            highestSwitchNumber = codeButtonHandlerData._mSwitchNumber;
        }
        return highestSwitchNumber;
    }

    public int findHighestColumnNumberUsedSoFar() {
        int highestColumnNumber = 0;
        for (CodeButtonHandlerData codeButtonHandlerData : this._mCodeButtonHandlerDataArrayList) {
            if (codeButtonHandlerData._mGUIColumnNumber <= highestColumnNumber) continue;
            highestColumnNumber = codeButtonHandlerData._mGUIColumnNumber;
        }
        return highestColumnNumber;
    }

    public CTCTurnoutData getCTCTurnoutData(Turnout turnout) {
        for (CodeButtonHandlerData codeButtonHandlerData : this._mCodeButtonHandlerDataArrayList) {
            if (!codeButtonHandlerData._mSWDI_Enabled || !codeButtonHandlerData._mSWDI_ExternalTurnout.getBean().equals(turnout)) continue;
            return new CTCTurnoutData(codeButtonHandlerData.myShortStringNoComma(), codeButtonHandlerData._mUniqueID);
        }
        return null;
    }

    public HashSet<String> getHashSetOfAllLockedTurnoutsExcludingPassedOne(CodeButtonHandlerData excludedOne) {
        HashSet<String> lockedTurnouts = new HashSet<String>();
        for (CodeButtonHandlerData codeButtonHandlerData : this._mCodeButtonHandlerDataArrayList) {
            if (codeButtonHandlerData == excludedOne) continue;
            if (codeButtonHandlerData._mTUL_ExternalTurnout.valid()) {
                lockedTurnouts.add(codeButtonHandlerData._mTUL_ExternalTurnout.getHandleName());
            }
            if (codeButtonHandlerData._mTUL_AdditionalExternalTurnout1.valid()) {
                lockedTurnouts.add(codeButtonHandlerData._mTUL_AdditionalExternalTurnout1.getHandleName());
            }
            if (codeButtonHandlerData._mTUL_AdditionalExternalTurnout2.valid()) {
                lockedTurnouts.add(codeButtonHandlerData._mTUL_AdditionalExternalTurnout2.getHandleName());
            }
            if (!codeButtonHandlerData._mTUL_AdditionalExternalTurnout3.valid()) continue;
            lockedTurnouts.add(codeButtonHandlerData._mTUL_AdditionalExternalTurnout3.getHandleName());
        }
        return lockedTurnouts;
    }

    public static class CTCTurnoutData {
        public final String _mOSSectionText;
        public final int _mUniqueID;

        public CTCTurnoutData(String OSSectionText, int uniqueID) {
            this._mOSSectionText = OSSectionText;
            this._mUniqueID = uniqueID;
        }
    }
}

