/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.ctc.ctcserialdata;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import jmri.jmrit.ctc.NBHSensor;
import jmri.jmrit.ctc.ctcserialdata.Bundle;
import jmri.jmrit.ctc.editor.code.CommonSubs;
import jmri.jmrit.ctc.editor.gui.FrmTRL_Rules;
import jmri.jmrit.ctc.topology.TopologyInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrafficLockingData {
    public String _mUserRuleNumber;
    public String _mRuleEnabled;
    public String _mDestinationSignalOrComment;
    public List<TRLSwitch> _mSwitchAlignments;
    public List<NBHSensor> _mOccupancyExternalSensors;
    public List<NBHSensor> _mOptionalExternalSensors;
    private static final Logger log = LoggerFactory.getLogger(TrafficLockingData.class);

    public TrafficLockingData() {
    }

    public TrafficLockingData(int ruleNumber, String destinationSignalMast, TopologyInfo topologyInfo) {
        int i;
        this._mUserRuleNumber = FrmTRL_Rules.getRuleNumberString(ruleNumber);
        this._mRuleEnabled = FrmTRL_Rules.getRuleEnabledString();
        this._mDestinationSignalOrComment = topologyInfo.getDestinationSignalMast();
        this._mSwitchAlignments = new ArrayList<TRLSwitch>();
        for (i = 0; i < 5; ++i) {
            int intID;
            if (topologyInfo.getOSSectionText(i) == null) continue;
            try {
                intID = Integer.parseInt(topologyInfo.getUniqueID(i));
            }
            catch (NumberFormatException ex) {
                log.warn("TrafficLockingData format exception: id = {}", (Object)topologyInfo.getUniqueID(i));
                intID = 0;
            }
            this._mSwitchAlignments.add(new TRLSwitch(topologyInfo.getOSSectionText(i), topologyInfo.getNormalReversed(i), intID));
        }
        this._mOccupancyExternalSensors = new ArrayList<NBHSensor>();
        for (i = 0; i < 9; ++i) {
            String sensorName = topologyInfo.getSensorDisplayName(i);
            NBHSensor sensor = CommonSubs.getNBHSensor(sensorName, false);
            if (sensor == null || !sensor.valid()) continue;
            this._mOccupancyExternalSensors.add(sensor);
        }
        this._mOptionalExternalSensors = new ArrayList<NBHSensor>();
    }

    public ArrayList<NBHSensor> getOccupancySensors() {
        NBHSensor dummy = new NBHSensor("TrafficLockingData", "", "", "", true);
        Object[] occupancyArray = new NBHSensor[9];
        Arrays.fill(occupancyArray, dummy);
        ArrayList<Object> occupancyList = new ArrayList<Object>(Arrays.asList(occupancyArray));
        for (int index = 0; index < this._mOccupancyExternalSensors.size(); ++index) {
            occupancyList.set(index, this._mOccupancyExternalSensors.get(index));
        }
        return occupancyList;
    }

    public ArrayList<NBHSensor> getOptionalSensors() {
        NBHSensor dummy = new NBHSensor("TrafficLockingData", "", "", "", true);
        Object[] optionalArray = new NBHSensor[2];
        Arrays.fill(optionalArray, dummy);
        ArrayList<Object> optionalList = new ArrayList<Object>(Arrays.asList(optionalArray));
        for (int index = 0; index < this._mOptionalExternalSensors.size(); ++index) {
            optionalList.set(index, this._mOptionalExternalSensors.get(index));
        }
        return optionalList;
    }

    public ArrayList<Integer> getUniqueIDs() {
        Object[] ids = new Integer[5];
        Arrays.fill(ids, (Object)-1);
        ArrayList<Object> idList = new ArrayList<Object>(Arrays.asList(ids));
        for (int index = 0; index < this._mSwitchAlignments.size(); ++index) {
            idList.set(index, this._mSwitchAlignments.get((int)index)._mUniqueID);
        }
        return idList;
    }

    public ArrayList<String> getAlignments() {
        Object[] alignment = new String[5];
        Arrays.fill(alignment, Bundle.getMessage("TLE_Normal"));
        ArrayList<Object> alignmentList = new ArrayList<Object>(Arrays.asList(alignment));
        for (int index = 0; index < this._mSwitchAlignments.size(); ++index) {
            alignmentList.set(index, this._mSwitchAlignments.get((int)index)._mSwitchAlignment);
        }
        return alignmentList;
    }

    public String toString() {
        String formattedString = String.format("%s,%s,%s", this._mUserRuleNumber != null ? this._mUserRuleNumber : "", this._mRuleEnabled != null ? this._mRuleEnabled : "", this._mDestinationSignalOrComment != null ? this._mDestinationSignalOrComment : "");
        StringBuilder buildString = new StringBuilder(formattedString);
        this._mSwitchAlignments.forEach(tlrSw -> {
            buildString.append(",");
            buildString.append(tlrSw._mUserText);
            buildString.append(",");
            buildString.append(tlrSw._mSwitchAlignment);
            buildString.append(",");
            buildString.append(tlrSw._mUniqueID);
        });
        this._mOccupancyExternalSensors.forEach(sw -> {
            buildString.append(",");
            buildString.append(sw.getHandleName());
        });
        this._mOptionalExternalSensors.forEach(sw -> {
            buildString.append(",");
            buildString.append(sw.getHandleName());
        });
        return buildString.toString();
    }

    public static class TRLSwitch {
        public String _mUserText;
        public String _mSwitchAlignment;
        public int _mUniqueID;

        public TRLSwitch(String text, String alignment, int uniqueID) {
            this._mUserText = text;
            this._mSwitchAlignment = alignment;
            this._mUniqueID = uniqueID;
        }
    }
}

