/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.ctc.editor.code;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.reflect.Field;
import java.util.ArrayList;
import javax.swing.JFrame;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableModel;
import jmri.BlockManager;
import jmri.InstanceManager;
import jmri.SignalHeadManager;
import jmri.SignalMastManager;
import jmri.jmrit.ctc.ctcserialdata.ProjectsCommonSubs;
import jmri.jmrit.ctc.editor.code.Bundle;

public class CheckJMRIObject {
    public static final String EXTERNAL_TURNOUT = "ExternalTurnout";
    public static final String EXTERNAL_SENSOR = "ExternalSensor";
    public static final String EXTERNAL_BLOCK = "ExternalBlock";
    public static final String EXTERNAL_SIGNAL = "ExternalSignal";

    public boolean checkSignal(String signalName) {
        return this.lowLevelCheck(OBJECT_TYPE.SIGNAL, signalName);
    }

    public boolean validClass(Object object) {
        return this.verifyClassCommon("", object) == null;
    }

    public boolean validClassWithPrefix(String prefix, Object object) {
        return this.verifyClassCommon(prefix, object) == null;
    }

    public VerifyClassReturnValue verifyClass(Object object) {
        return this.verifyClassCommon("", object);
    }

    private VerifyClassReturnValue verifyClassCommon(String prefix, Object object) {
        Field[] objFields;
        for (Field field : objFields = object.getClass().getDeclaredFields()) {
            String fieldContent;
            String fieldName;
            if (field.getType() != String.class || !(fieldName = field.getName()).startsWith(prefix)) continue;
            try {
                fieldContent = (String)field.get(object);
                if (ProjectsCommonSubs.isNullOrEmptyString(fieldContent)) {
                }
            }
            catch (IllegalAccessException e) {}
            continue;
            VerifyClassReturnValue verifyClassReturnValue = this.processField(fieldName, fieldContent);
            if (verifyClassReturnValue == null) continue;
            return verifyClassReturnValue;
        }
        return null;
    }

    @SuppressFBWarnings(value={"DP_DO_INSIDE_DO_PRIVILEGED"})
    public void analyzeForm(String prefix, JFrame dialog, ArrayList<String> errors) {
        Field[] objFields;
        for (Field field : objFields = dialog.getClass().getDeclaredFields()) {
            DefaultTableModel defaultTableModel;
            OBJECT_TYPE objectType;
            String fieldName;
            Class<?> fieldType = field.getType();
            if (fieldType == JTextField.class) {
                String fieldContent;
                fieldName = field.getName();
                if (!fieldName.startsWith(prefix)) continue;
                try {
                    field.setAccessible(true);
                    fieldContent = ((JTextField)field.get(dialog)).getText();
                    if (ProjectsCommonSubs.isNullOrEmptyString(fieldContent)) {
                    }
                }
                catch (IllegalAccessException e) {}
                continue;
                VerifyClassReturnValue verifyClassReturnValue = this.processField(fieldName, fieldContent);
                if (verifyClassReturnValue == null) continue;
                errors.add(verifyClassReturnValue.toString());
                continue;
            }
            if (fieldType != JTable.class || !(fieldName = field.getName()).startsWith(prefix)) continue;
            if (fieldName.contains(EXTERNAL_TURNOUT)) {
                objectType = OBJECT_TYPE.TURNOUT;
            } else if (fieldName.contains(EXTERNAL_SENSOR)) {
                objectType = OBJECT_TYPE.SENSOR;
            } else if (fieldName.contains(EXTERNAL_BLOCK)) {
                objectType = OBJECT_TYPE.BLOCK;
            } else {
                if (!fieldName.contains(EXTERNAL_SIGNAL)) continue;
                objectType = OBJECT_TYPE.SIGNAL;
            }
            try {
                field.setAccessible(true);
                defaultTableModel = (DefaultTableModel)((JTable)field.get(dialog)).getModel();
            }
            catch (IllegalAccessException e) {
                continue;
            }
            for (int sourceIndex = 0; sourceIndex < defaultTableModel.getRowCount(); ++sourceIndex) {
                String jmriObjectName;
                Object object = defaultTableModel.getValueAt(sourceIndex, 0);
                if (object == null || ProjectsCommonSubs.isNullOrEmptyString(object.toString()) || this.lowLevelCheck(objectType, jmriObjectName = object.toString().trim())) continue;
                errors.add(new VerifyClassReturnValue(jmriObjectName, objectType).toString());
            }
        }
    }

    private VerifyClassReturnValue processField(String fieldName, String fieldContent) {
        OBJECT_TYPE objectType;
        if (fieldName.contains(EXTERNAL_TURNOUT)) {
            objectType = OBJECT_TYPE.TURNOUT;
        } else if (fieldName.contains(EXTERNAL_SENSOR)) {
            objectType = OBJECT_TYPE.SENSOR;
        } else if (fieldName.contains(EXTERNAL_BLOCK)) {
            objectType = OBJECT_TYPE.BLOCK;
        } else if (fieldName.contains(EXTERNAL_SIGNAL)) {
            objectType = OBJECT_TYPE.SIGNAL;
        } else {
            return null;
        }
        if (this.lowLevelCheck(objectType, fieldContent)) {
            return null;
        }
        return new VerifyClassReturnValue(fieldContent, objectType);
    }

    private boolean lowLevelCheck(OBJECT_TYPE objectType, String JMRIObjectName) {
        switch (objectType) {
            case SENSOR: {
                if (InstanceManager.sensorManagerInstance().getSensor(JMRIObjectName) == null) break;
                return true;
            }
            case TURNOUT: {
                if (InstanceManager.turnoutManagerInstance().getTurnout(JMRIObjectName) == null) break;
                return true;
            }
            case SIGNAL: {
                if (InstanceManager.getDefault(SignalHeadManager.class).getSignalHead(JMRIObjectName) != null) {
                    return true;
                }
                if (InstanceManager.getDefault(SignalMastManager.class).getSignalMast(JMRIObjectName) == null) break;
                return true;
            }
            case BLOCK: {
                if (InstanceManager.getDefault(BlockManager.class).getBlock(JMRIObjectName) == null) break;
                return true;
            }
        }
        return false;
    }

    public static class VerifyClassReturnValue {
        public final String _mFieldContents;
        public final OBJECT_TYPE _mObjectType;

        public VerifyClassReturnValue(String fieldContents, OBJECT_TYPE objectType) {
            this._mFieldContents = fieldContents;
            this._mObjectType = objectType;
        }

        public String toString() {
            switch (this._mObjectType) {
                case SENSOR: {
                    return Bundle.getMessage("CJMRIO_Sensor") + " " + this._mFieldContents + " " + Bundle.getMessage("CJMRIO_DoesntExist");
                }
                case TURNOUT: {
                    return Bundle.getMessage("CJMRIO_Turnout") + " " + this._mFieldContents + " " + Bundle.getMessage("CJMRIO_DoesntExist");
                }
                case SIGNAL: {
                    return Bundle.getMessage("CJMRIO_Signal") + " " + this._mFieldContents + " " + Bundle.getMessage("CJMRIO_DoesntExist");
                }
                case BLOCK: {
                    return Bundle.getMessage("CJMRIO_Block") + " " + this._mFieldContents + " " + Bundle.getMessage("CJMRIO_DoesntExist");
                }
            }
            return "";
        }
    }

    public static enum OBJECT_TYPE {
        SENSOR,
        TURNOUT,
        SIGNAL,
        BLOCK;

    }
}

