/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.ctc.editor.code;

import java.awt.Color;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.TreeSet;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import jmri.jmrit.ctc.ctcserialdata.CTCSerialData;
import jmri.jmrit.ctc.ctcserialdata.CodeButtonHandlerData;
import jmri.jmrit.ctc.ctcserialdata.TrafficLockingData;
import jmri.jmrit.ctc.editor.code.CheckJMRIObject;
import jmri.jmrit.ctc.editor.gui.FrmCB;
import jmri.jmrit.ctc.editor.gui.FrmCO;
import jmri.jmrit.ctc.editor.gui.FrmIL;
import jmri.jmrit.ctc.editor.gui.FrmSIDI;
import jmri.jmrit.ctc.editor.gui.FrmSWDI;
import jmri.jmrit.ctc.editor.gui.FrmTRL;
import jmri.jmrit.ctc.editor.gui.FrmTUL;

public class Columns {
    public static final String REFERENCES_PRESENT_INDICATOR = " (";
    private static final String ERROR_STRING = " ***ERROR***";
    private final CTCSerialData _mCTCSerialData;
    private final CheckJMRIObject _mCheckJMRIObject;
    private final DefaultListModel<String> _mDefaultListModel;
    private final JButton _mDeleteButton;
    private final JButton _mChangeNumbersButton;
    private final JButton _mMoveUpButton;
    private final JButton _mMoveDownButton;
    private final JLabel _mEdit_CB_Prompt;
    private final JLabel _mCB_EditAlwaysEnabled;
    private final JButton _mEdit_CB;
    private final JLabel _mEdit_SIDI_Prompt;
    private final JCheckBox _mSIDI_Enabled;
    private final JButton _mEdit_SIDI;
    private final JLabel _mEdit_SIDL_Prompt;
    private final JCheckBox _mSIDL_Enabled;
    private final JButton _mEdit_SIDL;
    private final JLabel _mEdit_SWDI_Prompt;
    private final JCheckBox _mSWDI_Enabled;
    private final JButton _mEdit_SWDI;
    private final JLabel _mEdit_SWDL_Prompt;
    private final JCheckBox _mSWDL_Enabled;
    private final JButton _mEdit_SWDL;
    private final JLabel _mEdit_CO_Prompt;
    private final JCheckBox _mCO_Enabled;
    private final JButton _mEdit_CO;
    private final JLabel _mEdit_TRL_Prompt;
    private final JCheckBox _mTRL_Enabled;
    private final JButton _mEdit_TRL;
    private final JLabel _mEdit_TUL_Prompt;
    private final JCheckBox _mTUL_Enabled;
    private final JButton _mEdit_TUL;
    private final JLabel _mEdit_IL_Prompt;
    private final JCheckBox _mIL_Enabled;
    private final JButton _mEdit_IL;
    private int _mSelectedCodeButtonHandlerDataIndex;
    private CodeButtonHandlerData _mSelectedCodeButtonHandlerData;

    public Columns(CTCSerialData ctcSerialData, CheckJMRIObject checkJMRIObject, DefaultListModel<String> defaultListModel, JButton deleteButton, JButton changeNumbersButton, JButton moveUpButton, JButton moveDownButton, JLabel edit_CB_Prompt, JLabel cb_EditAlwaysEnabled, JButton edit_CB, JLabel edit_SIDI_Prompt, JCheckBox sidi_Enabled, JButton edit_SIDI, JLabel edit_SIDL_Prompt, JCheckBox sidl_Enabled, JButton edit_SIDL, JLabel edit_SWDI_Prompt, JCheckBox swdi_Enabled, JButton edit_SWDI, JLabel edit_SWDL_Prompt, JCheckBox swdl_Enabled, JButton edit_SWDL, JLabel edit_CO_Prompt, JCheckBox co_Enabled, JButton edit_CO, JLabel edit_TRL_Prompt, JCheckBox trl_Enabled, JButton edit_TRL, JLabel edit_TUL_Prompt, JCheckBox tul_Enabled, JButton edit_TUL, JLabel edit_IL_Prompt, JCheckBox il_Enabled, JButton edit_IL) {
        this._mCTCSerialData = ctcSerialData;
        this._mCheckJMRIObject = checkJMRIObject;
        this._mDefaultListModel = defaultListModel;
        this._mDeleteButton = deleteButton;
        this._mChangeNumbersButton = changeNumbersButton;
        this._mMoveUpButton = moveUpButton;
        this._mMoveDownButton = moveDownButton;
        this._mEdit_CB_Prompt = edit_CB_Prompt;
        this._mCB_EditAlwaysEnabled = cb_EditAlwaysEnabled;
        this._mEdit_CB = edit_CB;
        this._mEdit_SIDI_Prompt = edit_SIDI_Prompt;
        this._mSIDI_Enabled = sidi_Enabled;
        this._mEdit_SIDI = edit_SIDI;
        this._mEdit_SIDL_Prompt = edit_SIDL_Prompt;
        this._mSIDL_Enabled = sidl_Enabled;
        this._mEdit_SIDL = edit_SIDL;
        this._mEdit_SWDI_Prompt = edit_SWDI_Prompt;
        this._mSWDI_Enabled = swdi_Enabled;
        this._mEdit_SWDI = edit_SWDI;
        this._mEdit_SWDL_Prompt = edit_SWDL_Prompt;
        this._mSWDL_Enabled = swdl_Enabled;
        this._mEdit_SWDL = edit_SWDL;
        this._mEdit_CO_Prompt = edit_CO_Prompt;
        this._mCO_Enabled = co_Enabled;
        this._mEdit_CO = edit_CO;
        this._mEdit_TRL_Prompt = edit_TRL_Prompt;
        this._mTRL_Enabled = trl_Enabled;
        this._mEdit_TRL = edit_TRL;
        this._mTUL_Enabled = tul_Enabled;
        this._mEdit_TUL_Prompt = edit_TUL_Prompt;
        this._mEdit_TUL = edit_TUL;
        this._mEdit_IL_Prompt = edit_IL_Prompt;
        this._mIL_Enabled = il_Enabled;
        this._mEdit_IL = edit_IL;
        this.updateFrame();
    }

    public CodeButtonHandlerData getSelectedCodeButtonHandlerData() {
        return this._mSelectedCodeButtonHandlerData;
    }

    public final void updateFrame() {
        this._mDefaultListModel.clear();
        this._mCTCSerialData.getCodeButtonHandlerDataArrayList().forEach(codeButtonHandlerData -> this._mDefaultListModel.addElement(this.constructSingleColumnDisplayLine((CodeButtonHandlerData)codeButtonHandlerData)));
        this._mDeleteButton.setEnabled(false);
        this._mChangeNumbersButton.setEnabled(false);
        this._mMoveUpButton.setEnabled(false);
        this._mMoveDownButton.setEnabled(false);
        this._mSIDI_Enabled.setEnabled(false);
        this._mCB_EditAlwaysEnabled.setEnabled(false);
        this._mEdit_CB.setEnabled(false);
        this._mEdit_SIDI.setEnabled(false);
        this._mSIDL_Enabled.setEnabled(false);
        this._mEdit_SIDL.setEnabled(false);
        this._mSWDI_Enabled.setEnabled(false);
        this._mEdit_SWDI.setEnabled(false);
        this._mSWDL_Enabled.setEnabled(false);
        this._mEdit_SWDL.setEnabled(false);
        this._mCO_Enabled.setEnabled(false);
        this._mEdit_CO.setEnabled(false);
        this._mTRL_Enabled.setEnabled(false);
        this._mEdit_TRL.setEnabled(false);
        this._mTUL_Enabled.setEnabled(false);
        this._mEdit_TUL.setEnabled(false);
        this._mIL_Enabled.setEnabled(false);
        this._mEdit_IL.setEnabled(false);
    }

    public int getEntrySelectedIndex() {
        return this._mSelectedCodeButtonHandlerDataIndex;
    }

    public void fixAllErrors() {
        for (CodeButtonHandlerData codeButtonHandlerData : this._mCTCSerialData.getCodeButtonHandlerDataArrayList()) {
            if (!FrmSIDI.dialogCodeButtonHandlerDataValid(this._mCheckJMRIObject, codeButtonHandlerData)) {
                codeButtonHandlerData._mSIDI_Enabled = false;
            }
            if (!FrmSWDI.dialogCodeButtonHandlerDataValid(this._mCheckJMRIObject, codeButtonHandlerData)) {
                codeButtonHandlerData._mSWDI_Enabled = false;
            }
            if (!FrmCO.dialogCodeButtonHandlerDataValid(this._mCheckJMRIObject, codeButtonHandlerData)) {
                codeButtonHandlerData._mCO_Enabled = false;
            }
            if (!FrmTRL.dialogCodeButtonHandlerDataValid(this._mCheckJMRIObject, codeButtonHandlerData)) {
                codeButtonHandlerData._mTRL_Enabled = false;
            }
            if (!FrmTUL.dialogCodeButtonHandlerDataValid(this._mCheckJMRIObject, codeButtonHandlerData)) {
                codeButtonHandlerData._mTUL_Enabled = false;
            }
            if (FrmIL.dialogCodeButtonHandlerDataValid(this._mCheckJMRIObject, codeButtonHandlerData)) continue;
            codeButtonHandlerData._mIL_Enabled = false;
        }
        this.updateFrame();
    }

    public boolean anyErrorsPresent() {
        Enumeration<String> enumerationOfStrings = this._mDefaultListModel.elements();
        while (enumerationOfStrings.hasMoreElements()) {
            if (!enumerationOfStrings.nextElement().contains(ERROR_STRING)) continue;
            return true;
        }
        return false;
    }

    public void updateCurrentlySelectedColumnErrorStatus() {
        Columns.lazy1(this._mEdit_CB_Prompt, FrmCB.dialogCodeButtonHandlerDataValid(this._mCheckJMRIObject, this._mSelectedCodeButtonHandlerData) ? Color.black : Color.red);
        Columns.lazy1(this._mEdit_SIDI_Prompt, FrmSIDI.dialogCodeButtonHandlerDataValid(this._mCheckJMRIObject, this._mSelectedCodeButtonHandlerData) ? Color.black : Color.red);
        Columns.lazy1(this._mEdit_SWDI_Prompt, FrmSWDI.dialogCodeButtonHandlerDataValid(this._mCheckJMRIObject, this._mSelectedCodeButtonHandlerData) ? Color.black : Color.red);
        Columns.lazy1(this._mEdit_CO_Prompt, FrmCO.dialogCodeButtonHandlerDataValid(this._mCheckJMRIObject, this._mSelectedCodeButtonHandlerData) ? Color.black : Color.red);
        Columns.lazy1(this._mEdit_TRL_Prompt, FrmTRL.dialogCodeButtonHandlerDataValid(this._mCheckJMRIObject, this._mSelectedCodeButtonHandlerData) ? Color.black : Color.red);
        Columns.lazy1(this._mEdit_TUL_Prompt, FrmTUL.dialogCodeButtonHandlerDataValid(this._mCheckJMRIObject, this._mSelectedCodeButtonHandlerData) ? Color.black : Color.red);
        Columns.lazy1(this._mEdit_IL_Prompt, FrmIL.dialogCodeButtonHandlerDataValid(this._mCheckJMRIObject, this._mSelectedCodeButtonHandlerData) ? Color.black : Color.red);
        this._mDefaultListModel.set(this._mSelectedCodeButtonHandlerDataIndex, this.constructSingleColumnDisplayLine(this._mSelectedCodeButtonHandlerData));
    }

    public void clearCurrentlySelectedColumnErrorStatus() {
        Columns.lazy1(this._mEdit_CB_Prompt, Color.black);
        Columns.lazy1(this._mEdit_SIDI_Prompt, Color.black);
        Columns.lazy1(this._mEdit_SIDL_Prompt, Color.black);
        Columns.lazy1(this._mEdit_SWDI_Prompt, Color.black);
        Columns.lazy1(this._mEdit_SWDL_Prompt, Color.black);
        Columns.lazy1(this._mEdit_CO_Prompt, Color.black);
        Columns.lazy1(this._mEdit_TRL_Prompt, Color.black);
        Columns.lazy1(this._mEdit_TUL_Prompt, Color.black);
        Columns.lazy1(this._mEdit_IL_Prompt, Color.black);
    }

    private static void lazy1(JLabel label, Color foreground) {
        label.setForeground(foreground);
    }

    public void setEntrySelected(int selectedIndex) {
        if (selectedIndex >= 0) {
            this._mDeleteButton.setEnabled(true);
            this._mChangeNumbersButton.setEnabled(true);
            this._mMoveUpButton.setEnabled(selectedIndex > 0);
            this._mMoveDownButton.setEnabled(selectedIndex < this._mCTCSerialData.getCodeButtonHandlerDataSize() - 1);
            this._mSelectedCodeButtonHandlerDataIndex = selectedIndex;
            this._mSelectedCodeButtonHandlerData = this._mCTCSerialData.getCodeButtonHandlerData(selectedIndex);
            this._mCB_EditAlwaysEnabled.setEnabled(true);
            this.updateCurrentlySelectedColumnErrorStatus();
            this._mEdit_CB.setEnabled(true);
            Columns.lazy1(this._mSIDI_Enabled, this._mEdit_SIDI, true, this._mSelectedCodeButtonHandlerData._mSIDI_Enabled);
            Columns.lazy1(this._mSIDL_Enabled, this._mEdit_SIDL, true, this._mSelectedCodeButtonHandlerData._mSIDL_Enabled);
            Columns.lazy1(this._mSWDI_Enabled, this._mEdit_SWDI, true, this._mSelectedCodeButtonHandlerData._mSWDI_Enabled);
            Columns.lazy1(this._mSWDL_Enabled, this._mEdit_SWDL, true, this._mSelectedCodeButtonHandlerData._mSWDL_Enabled);
            this.specialUpdateEnableCO_and_TRL();
            Columns.lazy1(this._mTUL_Enabled, this._mEdit_TUL, true, this._mSelectedCodeButtonHandlerData._mTUL_Enabled);
            Columns.lazy1(this._mIL_Enabled, this._mEdit_IL, true, this._mSelectedCodeButtonHandlerData._mIL_Enabled);
        } else {
            this.clearCurrentlySelectedColumnErrorStatus();
        }
    }

    private void specialUpdateEnableCO_and_TRL() {
        boolean signalDirectionLeverEnabled = this.signalDirectionLeverEnabled();
        if (!this.signalDirectionLeverEnabled()) {
            this._mSelectedCodeButtonHandlerData._mCO_Enabled = false;
            this._mSelectedCodeButtonHandlerData._mTRL_Enabled = false;
        }
        Columns.lazy1(this._mCO_Enabled, this._mEdit_CO, signalDirectionLeverEnabled, this._mSelectedCodeButtonHandlerData._mCO_Enabled);
        Columns.lazy1(this._mTRL_Enabled, this._mEdit_TRL, signalDirectionLeverEnabled, this._mSelectedCodeButtonHandlerData._mTRL_Enabled);
    }

    private static void lazy1(JCheckBox jCheckBox, JButton jButton, boolean enabled, boolean value) {
        jCheckBox.setEnabled(enabled);
        jCheckBox.setSelected(value);
        jButton.setEnabled(value);
    }

    public void sidi_EnabledClicked(boolean newState) {
        this._mSelectedCodeButtonHandlerData._mSIDI_Enabled = newState;
        this.lazy2(this._mEdit_SIDI, newState);
    }

    public void sidl_EnabledClicked(boolean newState) {
        this._mSelectedCodeButtonHandlerData._mSIDL_Enabled = newState;
        this.lazy2(this._mEdit_SIDL, newState);
        this.specialUpdateEnableCO_and_TRL();
    }

    public void swdi_EnabledClicked(boolean newState) {
        this._mSelectedCodeButtonHandlerData._mSWDI_Enabled = newState;
        this.lazy2(this._mEdit_SWDI, newState);
    }

    public void swdl_EnabledClicked(boolean newState) {
        this._mSelectedCodeButtonHandlerData._mSWDL_Enabled = newState;
        this.lazy2(this._mEdit_SWDL, newState);
    }

    public void co_EnabledClicked(boolean newState) {
        this._mSelectedCodeButtonHandlerData._mCO_Enabled = newState;
        this.lazy2(this._mEdit_CO, newState);
    }

    public void trl_EnabledClicked(boolean newState) {
        this._mSelectedCodeButtonHandlerData._mTRL_Enabled = newState;
        this.lazy2(this._mEdit_TRL, newState);
    }

    public void tul_EnabledClicked(boolean newState) {
        this._mSelectedCodeButtonHandlerData._mTUL_Enabled = newState;
        this.lazy2(this._mEdit_TUL, newState);
    }

    public void il_EnabledClicked(boolean newState) {
        this._mSelectedCodeButtonHandlerData._mIL_Enabled = newState;
        this.lazy2(this._mEdit_IL, newState);
    }

    private void lazy2(JButton jButton, boolean value) {
        jButton.setEnabled(value);
        this._mCTCSerialData.setCodeButtonHandlerData(this._mSelectedCodeButtonHandlerDataIndex, this._mSelectedCodeButtonHandlerData);
        this.updateCurrentlySelectedColumnErrorStatus();
    }

    public String checkForDups(int newSwitchNumber, int newGUIColumnNumber, boolean isModify, int indexModifying) {
        ArrayList<CodeButtonHandlerData> codeButtonHandlerDataList = this._mCTCSerialData.getCodeButtonHandlerDataArrayList();
        int codeButtonHandlerDataListSize = codeButtonHandlerDataList.size();
        for (int index = 0; index < codeButtonHandlerDataListSize; ++index) {
            if (isModify && index == indexModifying) continue;
            CodeButtonHandlerData codeButtonHandlerData = codeButtonHandlerDataList.get(index);
            if (codeButtonHandlerData._mSwitchNumber == newSwitchNumber) {
                return "Switch #" + newSwitchNumber + " already used";
            }
            if (newGUIColumnNumber <= 0 || codeButtonHandlerData._mGUIColumnNumber != newGUIColumnNumber) continue;
            return "GUI Column #" + newGUIColumnNumber + " already used";
        }
        return null;
    }

    private String getListOfTrafficLockingRulesOSSectionsReferenced(CodeButtonHandlerData currentCodeButtonHandlerData, ArrayList<CodeButtonHandlerData> codeButtonHandlerDataArrayList) {
        StringBuffer returnStringBuffer = new StringBuffer("");
        TreeSet<String> temp = new TreeSet<String>();
        int currentUniqueID = currentCodeButtonHandlerData._mUniqueID;
        for (CodeButtonHandlerData codeButtonHandlerData : codeButtonHandlerDataArrayList) {
            if (currentCodeButtonHandlerData == codeButtonHandlerData) continue;
            int otherUniqueID = codeButtonHandlerData._mUniqueID;
            this.checkThisList(currentUniqueID, otherUniqueID, "L", codeButtonHandlerData._mTRL_LeftTrafficLockingRules, temp);
            this.checkThisList(currentUniqueID, otherUniqueID, "R", codeButtonHandlerData._mTRL_RightTrafficLockingRules, temp);
        }
        for (String result : temp) {
            returnStringBuffer.append(result);
        }
        if (returnStringBuffer.length() > 0) {
            return "TrL: " + returnStringBuffer.substring(0, returnStringBuffer.length() - 2);
        }
        return "";
    }

    private void checkThisList(int ourUniqueID, int otherUniqueID, String lr, ArrayList<TrafficLockingData> trafficLockingRules, TreeSet<String> setOfUniqueIDs) {
        trafficLockingRules.forEach(rule -> {
            ArrayList<Integer> idList = rule.getUniqueIDs();
            this.lazy3(ourUniqueID, otherUniqueID, lr, idList.get(0), setOfUniqueIDs);
            this.lazy3(ourUniqueID, otherUniqueID, lr, idList.get(1), setOfUniqueIDs);
            this.lazy3(ourUniqueID, otherUniqueID, lr, idList.get(2), setOfUniqueIDs);
            this.lazy3(ourUniqueID, otherUniqueID, lr, idList.get(3), setOfUniqueIDs);
            this.lazy3(ourUniqueID, otherUniqueID, lr, idList.get(4), setOfUniqueIDs);
        });
    }

    private void lazy3(int ourUniqueID, int otherUniqueID, String lr, int uniqueID, TreeSet<String> setOfUniqueIDs) {
        if (ourUniqueID == uniqueID) {
            setOfUniqueIDs.add(this._mCTCSerialData.getMyShortStringNoCommaViaUniqueID(otherUniqueID) + lr + ", ");
        }
    }

    private String getListOfSwitchSlavedToOSSectionsReferenced(CodeButtonHandlerData currentCodeButtonHandlerData, ArrayList<CodeButtonHandlerData> codeButtonHandlerDataArrayList) {
        StringBuffer returnStringBuffer = new StringBuffer("");
        TreeSet<CallSite> temp = new TreeSet<CallSite>();
        int currentUniqueID = currentCodeButtonHandlerData._mUniqueID;
        for (CodeButtonHandlerData codeButtonHandlerData : codeButtonHandlerDataArrayList) {
            if (currentCodeButtonHandlerData == codeButtonHandlerData || codeButtonHandlerData._mOSSectionSwitchSlavedToUniqueID == -1 || currentUniqueID != codeButtonHandlerData._mOSSectionSwitchSlavedToUniqueID) continue;
            temp.add((CallSite)((Object)(this._mCTCSerialData.getMyShortStringNoCommaViaUniqueID(codeButtonHandlerData._mUniqueID) + ", ")));
        }
        for (String string : temp) {
            returnStringBuffer.append(string);
        }
        if (returnStringBuffer.length() > 0) {
            return "Sw: " + returnStringBuffer.substring(0, returnStringBuffer.length() - 2);
        }
        return "";
    }

    private static String generatePossibleErrorString(CheckJMRIObject checkJMRIObject, CodeButtonHandlerData currentCodeButtonHandlerData) {
        if (!FrmCB.dialogCodeButtonHandlerDataValid(checkJMRIObject, currentCodeButtonHandlerData)) {
            return ERROR_STRING;
        }
        if (!FrmSIDI.dialogCodeButtonHandlerDataValid(checkJMRIObject, currentCodeButtonHandlerData)) {
            return ERROR_STRING;
        }
        if (!FrmSWDI.dialogCodeButtonHandlerDataValid(checkJMRIObject, currentCodeButtonHandlerData)) {
            return ERROR_STRING;
        }
        if (!FrmCO.dialogCodeButtonHandlerDataValid(checkJMRIObject, currentCodeButtonHandlerData)) {
            return ERROR_STRING;
        }
        if (!FrmTRL.dialogCodeButtonHandlerDataValid(checkJMRIObject, currentCodeButtonHandlerData)) {
            return ERROR_STRING;
        }
        if (!FrmTUL.dialogCodeButtonHandlerDataValid(checkJMRIObject, currentCodeButtonHandlerData)) {
            return ERROR_STRING;
        }
        if (!FrmIL.dialogCodeButtonHandlerDataValid(checkJMRIObject, currentCodeButtonHandlerData)) {
            return ERROR_STRING;
        }
        return "";
    }

    private String constructSingleColumnDisplayLine(CodeButtonHandlerData codeButtonHandlerData) {
        String referencesString1 = this.getListOfTrafficLockingRulesOSSectionsReferenced(codeButtonHandlerData, this._mCTCSerialData.getCodeButtonHandlerDataArrayList());
        String referencesString2 = this.getListOfSwitchSlavedToOSSectionsReferenced(codeButtonHandlerData, this._mCTCSerialData.getCodeButtonHandlerDataArrayList());
        Object displayString = codeButtonHandlerData.myString();
        if (!referencesString1.isEmpty() || !referencesString2.isEmpty()) {
            displayString = (String)displayString + REFERENCES_PRESENT_INDICATOR + referencesString1 + " " + referencesString2 + ")";
        }
        displayString = (String)displayString + Columns.generatePossibleErrorString(this._mCheckJMRIObject, codeButtonHandlerData);
        return displayString;
    }

    private boolean signalDirectionLeverEnabled() {
        return this._mSelectedCodeButtonHandlerData._mSIDL_Enabled;
    }
}

