/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.ctc.editor.code;

import java.awt.Font;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.TreeMap;
import jmri.InstanceManager;
import jmri.jmrit.ctc.CtcManager;
import jmri.jmrit.ctc.ctcserialdata.CTCSerialData;
import jmri.jmrit.ctc.ctcserialdata.CodeButtonHandlerData;
import jmri.jmrit.ctc.ctcserialdata.OtherData;
import jmri.jmrit.ctc.ctcserialdata.ProjectsCommonSubs;
import jmri.jmrit.ctc.editor.code.Bundle;
import jmri.jmrit.ctc.editor.code.CreateXMLFiles;
import jmri.util.FileUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateGUIObjectsXMLFile {
    private static final int START_OFFSET = 12;
    private static final int GIF_HORIZONTAL_SIZE = 65;
    private static final String DIALOG_USED = "Dialog.plain";
    private static final Logger log = LoggerFactory.getLogger(CreateGUIObjectsXMLFile.class);

    public static void writeGUIObjects() {
        int oneOfItemsBottomEdge;
        PrintWriter printWriter;
        CTCSerialData ctcSerialData = InstanceManager.getDefault(CtcManager.class).getCTCSerialData();
        TreeMap cbhdMap = new TreeMap();
        ctcSerialData.getCodeButtonHandlerDataArrayList().forEach(cbhd -> {
            if (cbhd._mGUIColumnNumber > 0 && !cbhd._mGUIGeneratedAtLeastOnceAlready) {
                cbhdMap.put(cbhd._mGUIColumnNumber, cbhd._mUniqueID);
            }
        });
        try {
            printWriter = new PrintWriter(new FileWriter(FileUtil.getUserFilesPath() + "ctc/GUIObjects.xml"));
        }
        catch (IOException e) {
            log.debug("PrintWriter exception: {}", (Object)e.getMessage());
            return;
        }
        CreateXMLFiles.generateProlog(printWriter);
        printWriter.println("  <paneleditor class=\"jmri.jmrit.display.panelEditor.configurexml.PanelEditorXml\" name=\"Panel \" x=\"857\" y=\"437\" height=\"437\" width=\"527\" editable=\"yes\" positionable=\"no\" showtooltips=\"yes\" controlling=\"yes\" hide=\"yes\" panelmenu=\"yes\" scrollable=\"both\" redBackground=\"255\" greenBackground=\"255\" blueBackground=\"255\">");
        OtherData otherData = ctcSerialData.getOtherData();
        if (otherData._mGUIDesign_BuilderPlate) {
            CreateGUIObjectsXMLFile.generateBuilderPlate(printWriter);
        }
        switch (otherData._mGUIDesign_VerticalSize) {
            default: {
                oneOfItemsBottomEdge = 718;
                break;
            }
            case MEDIUM: {
                oneOfItemsBottomEdge = 850;
                break;
            }
            case LARGE: {
                oneOfItemsBottomEdge = 900;
            }
        }
        if (otherData._mGUIDesign_AnalogClockEtc) {
            printWriter.println("    <fastclock x=\"26\" y=\"" + (oneOfItemsBottomEdge - 186) + "\" scale=\"1.0\" color=\"black\" class=\"jmri.jmrit.display.configurexml.AnalogClock2DisplayXml\" />");
            CreateGUIObjectsXMLFile.generateToggle(96, oneOfItemsBottomEdge - 223, "ISCLOCKRUNNING", printWriter);
            CreateGUIObjectsXMLFile.generateTextPositionableLabel(87, oneOfItemsBottomEdge - 244, Bundle.getMessage("CreateGUIObjectsXMLFileClockOn"), printWriter);
        }
        if (otherData._mGUIDesign_FleetingToggleSwitch && !ProjectsCommonSubs.isNullOrEmptyString(otherData._mFleetingToggleInternalSensor.getHandleName())) {
            CreateGUIObjectsXMLFile.generateToggle(226, oneOfItemsBottomEdge - 36, otherData._mFleetingToggleInternalSensor.getHandleName(), printWriter);
            CreateGUIObjectsXMLFile.generateTextPositionableLabel(215, oneOfItemsBottomEdge - 54, Bundle.getMessage("CreateGUIObjectsXMLFileFleetingOn"), printWriter);
        }
        if (otherData._mGUIDesign_ReloadCTCSystemButton && !ProjectsCommonSubs.isNullOrEmptyString(otherData._mCTCDebugSystemReloadInternalSensor.getHandleName())) {
            CreateGUIObjectsXMLFile.generatePushButton(291, oneOfItemsBottomEdge - 36, otherData._mCTCDebugSystemReloadInternalSensor.getHandleName(), printWriter);
            CreateGUIObjectsXMLFile.generateTextPositionableLabel(277, oneOfItemsBottomEdge - 54, Bundle.getMessage("CreateGUIObjectsXMLFileReloadCTC"), printWriter);
        }
        if (otherData._mGUIDesign_CTCDebugOnToggle && !ProjectsCommonSubs.isNullOrEmptyString(otherData._mCTCDebug_TrafficLockingRuleTriggeredDisplayInternalSensor.getHandleName())) {
            CreateGUIObjectsXMLFile.generateToggle(358, oneOfItemsBottomEdge - 36, otherData._mCTCDebug_TrafficLockingRuleTriggeredDisplayInternalSensor.getHandleName(), printWriter);
            CreateGUIObjectsXMLFile.generateTextPositionableLabel(339, oneOfItemsBottomEdge - 54, Bundle.getMessage("CreateGUIObjectsXMLFileCTCDebugOn"), printWriter);
        }
        if (!cbhdMap.isEmpty()) {
            CreateGUIObjectsXMLFile.generatePanel(0, 0, otherData._mGUIDesign_VerticalSize, "Panel-left", printWriter);
            int lastHorizontalPosition = 12;
            int thisObjectHorizontalPosition = 12;
            Iterator iterator = cbhdMap.values().iterator();
            while (iterator.hasNext()) {
                int y;
                int cbhdID = (Integer)iterator.next();
                CodeButtonHandlerData codeButtonHandlerData = ctcSerialData.getCodeButtonHandlerDataViaUniqueID(cbhdID);
                boolean directionLeft = true;
                boolean directionRight = true;
                if (codeButtonHandlerData._mSIDI_TrafficDirection == CodeButtonHandlerData.TRAFFIC_DIRECTION.LEFT) {
                    directionRight = false;
                }
                if (codeButtonHandlerData._mSIDI_TrafficDirection == CodeButtonHandlerData.TRAFFIC_DIRECTION.RIGHT) {
                    directionLeft = false;
                }
                thisObjectHorizontalPosition = (codeButtonHandlerData._mGUIColumnNumber - 1) * 65 + 12;
                while (lastHorizontalPosition < thisObjectHorizontalPosition) {
                    CreateGUIObjectsXMLFile.generatePanel(lastHorizontalPosition, 0, otherData._mGUIDesign_VerticalSize, "Panel-blank", printWriter);
                    lastHorizontalPosition += 65;
                }
                lastHorizontalPosition = thisObjectHorizontalPosition + 65;
                boolean generateSwitch = codeButtonHandlerData._mSWDI_Enabled || codeButtonHandlerData._mSWDL_Enabled;
                boolean generateSignal = codeButtonHandlerData._mSIDI_Enabled || codeButtonHandlerData._mSIDL_Enabled;
                String filename = "Panel-blank";
                if (generateSwitch && generateSignal) {
                    filename = "Panel-sw-sig";
                } else if (!generateSwitch && generateSignal) {
                    filename = "Panel-signal";
                } else if (generateSwitch && !generateSignal) {
                    filename = "Panel-switch";
                }
                CreateGUIObjectsXMLFile.generatePanel(thisObjectHorizontalPosition, 0, otherData._mGUIDesign_VerticalSize, filename, printWriter);
                if (!ProjectsCommonSubs.isNullOrEmptyString(codeButtonHandlerData._mCodeButtonInternalSensor.getHandleName()) && codeButtonHandlerData._mCodeButtonDelayTime == 0) {
                    CreateGUIObjectsXMLFile.generatePushButton(thisObjectHorizontalPosition + 21, CreateGUIObjectsXMLFile.adjustCodeButtonYBySize(632, otherData._mGUIDesign_VerticalSize), codeButtonHandlerData._mCodeButtonInternalSensor.getHandleName(), printWriter);
                }
                if (!ProjectsCommonSubs.isNullOrEmptyString(codeButtonHandlerData._mOSSectionOccupiedExternalSensor.getHandleName())) {
                    CreateGUIObjectsXMLFile.generateSensorIndicator(thisObjectHorizontalPosition + 21, 78, codeButtonHandlerData._mOSSectionOccupiedExternalSensor.getHandleName(), "Red", otherData._mGUIDesign_OSSectionUnknownInconsistentRedBlink, printWriter);
                }
                if (!ProjectsCommonSubs.isNullOrEmptyString(codeButtonHandlerData._mOSSectionOccupiedExternalSensor2.getHandleName())) {
                    CreateGUIObjectsXMLFile.generateSensorIndicator(thisObjectHorizontalPosition + 21, 108, codeButtonHandlerData._mOSSectionOccupiedExternalSensor2.getHandleName(), "Red", otherData._mGUIDesign_OSSectionUnknownInconsistentRedBlink, printWriter);
                }
                if (codeButtonHandlerData._mSWDI_Enabled) {
                    y = CreateGUIObjectsXMLFile.adjustSwitchItemsYBySize(340, otherData._mGUIDesign_VerticalSize);
                    if (!ProjectsCommonSubs.isNullOrEmptyString(codeButtonHandlerData._mSWDI_NormalInternalSensor.getHandleName())) {
                        CreateGUIObjectsXMLFile.generateSensorIndicator(thisObjectHorizontalPosition + 4, y, codeButtonHandlerData._mSWDI_NormalInternalSensor.getHandleName(), "green", false, printWriter);
                    }
                    if (!ProjectsCommonSubs.isNullOrEmptyString(codeButtonHandlerData._mSWDI_ReversedInternalSensor.getHandleName())) {
                        CreateGUIObjectsXMLFile.generateSensorIndicator(thisObjectHorizontalPosition + 38, y, codeButtonHandlerData._mSWDI_ReversedInternalSensor.getHandleName(), "amber", false, printWriter);
                    }
                    if (otherData._mGUIDesign_TurnoutsOnPanel && !ProjectsCommonSubs.isNullOrEmptyString(codeButtonHandlerData._mSWDI_ExternalTurnout.getHandleName())) {
                        switch (codeButtonHandlerData._mSWDI_GUITurnoutType) {
                            case TURNOUT: {
                                CreateGUIObjectsXMLFile.generateTurnoutIcon(thisObjectHorizontalPosition + 9, 80, codeButtonHandlerData._mSWDI_ExternalTurnout.getHandleName(), codeButtonHandlerData._mSWDI_GUITurnoutLeftHand, printWriter);
                                break;
                            }
                            case CROSSOVER: {
                                if (codeButtonHandlerData._mSWDI_GUITurnoutLeftHand == codeButtonHandlerData._mSWDI_GUICrossoverLeftHand) {
                                    CreateGUIObjectsXMLFile.generateTurnoutCrossoverIcon(thisObjectHorizontalPosition + 20, 40, codeButtonHandlerData._mSWDI_ExternalTurnout.getHandleName(), false, codeButtonHandlerData._mSWDI_GUICrossoverLeftHand, printWriter);
                                    break;
                                }
                                CreateGUIObjectsXMLFile.generateTurnoutIcon(thisObjectHorizontalPosition + 9, 80, codeButtonHandlerData._mSWDI_ExternalTurnout.getHandleName(), codeButtonHandlerData._mSWDI_GUITurnoutLeftHand, printWriter);
                                CreateGUIObjectsXMLFile.generateTurnoutIcon(thisObjectHorizontalPosition + 9, 135, codeButtonHandlerData._mSWDI_ExternalTurnout.getHandleName(), codeButtonHandlerData._mSWDI_GUICrossoverLeftHand, printWriter);
                                break;
                            }
                            case DOUBLE_CROSSOVER: {
                                CreateGUIObjectsXMLFile.generateTurnoutCrossoverIcon(thisObjectHorizontalPosition + 20, 80, codeButtonHandlerData._mSWDI_ExternalTurnout.getHandleName(), true, codeButtonHandlerData._mSWDI_GUICrossoverLeftHand, printWriter);
                                break;
                            }
                        }
                    }
                }
                if (codeButtonHandlerData._mSWDL_Enabled && !ProjectsCommonSubs.isNullOrEmptyString(codeButtonHandlerData._mSWDL_InternalSensor.getHandleName())) {
                    CreateGUIObjectsXMLFile.generateTurnoutLever(thisObjectHorizontalPosition + 8, CreateGUIObjectsXMLFile.adjustSwitchItemsYBySize(379, otherData._mGUIDesign_VerticalSize), codeButtonHandlerData._mSWDL_InternalSensor.getHandleName(), printWriter);
                    CreateGUIObjectsXMLFile.generateTextPositionableLabelCentered(thisObjectHorizontalPosition + 32, CreateGUIObjectsXMLFile.adjustSwitchItemsYBySize(356, otherData._mGUIDesign_VerticalSize), Integer.toString(codeButtonHandlerData._mSwitchNumber), printWriter);
                }
                if (codeButtonHandlerData._mSIDI_Enabled) {
                    y = CreateGUIObjectsXMLFile.adjustSignalItemsYBySize(454, otherData._mGUIDesign_VerticalSize);
                    if (!ProjectsCommonSubs.isNullOrEmptyString(codeButtonHandlerData._mSIDI_LeftInternalSensor.getHandleName())) {
                        if (directionLeft) {
                            CreateGUIObjectsXMLFile.generateSensorIndicator(thisObjectHorizontalPosition + 4, y, codeButtonHandlerData._mSIDI_LeftInternalSensor.getHandleName(), "green", false, printWriter);
                        } else {
                            CreateGUIObjectsXMLFile.generateKnockout(thisObjectHorizontalPosition + 4, y, printWriter);
                        }
                    }
                    if (!ProjectsCommonSubs.isNullOrEmptyString(codeButtonHandlerData._mSIDI_NormalInternalSensor.getHandleName())) {
                        CreateGUIObjectsXMLFile.generateSensorIndicator(thisObjectHorizontalPosition + 22, CreateGUIObjectsXMLFile.adjustSignalItemsYBySize(440, otherData._mGUIDesign_VerticalSize), codeButtonHandlerData._mSIDI_NormalInternalSensor.getHandleName(), "red", false, printWriter);
                    }
                    if (!ProjectsCommonSubs.isNullOrEmptyString(codeButtonHandlerData._mSIDI_RightInternalSensor.getHandleName())) {
                        if (directionRight) {
                            CreateGUIObjectsXMLFile.generateSensorIndicator(thisObjectHorizontalPosition + 38, y, codeButtonHandlerData._mSIDI_RightInternalSensor.getHandleName(), "green", false, printWriter);
                        } else {
                            CreateGUIObjectsXMLFile.generateKnockout(thisObjectHorizontalPosition + 38, y, printWriter);
                        }
                    }
                    if (otherData._mGUIDesign_SignalsOnPanel == OtherData.SIGNALS_ON_PANEL.ALL) {
                        ArrayList<String> signalsArrayListLR = ProjectsCommonSubs.getArrayListOfSignalNames(codeButtonHandlerData._mSIDI_LeftRightTrafficSignals);
                        int x = thisObjectHorizontalPosition + 10;
                        for (String signal : signalsArrayListLR) {
                            switch (otherData._mSignalSystemType) {
                                case SIGNALHEAD: {
                                    CreateGUIObjectsXMLFile.generateSignalHead(x, 120, signal, false, printWriter);
                                    break;
                                }
                                case SIGNALMAST: {
                                    CreateGUIObjectsXMLFile.generateSignalMast(x, 120, signal, false, printWriter);
                                    break;
                                }
                            }
                            x -= 11;
                        }
                        ArrayList<String> signalsArrayListRL = ProjectsCommonSubs.getArrayListOfSignalNames(codeButtonHandlerData._mSIDI_RightLeftTrafficSignals);
                        x = thisObjectHorizontalPosition + 20;
                        for (String signal : signalsArrayListRL) {
                            switch (otherData._mSignalSystemType) {
                                case SIGNALHEAD: {
                                    CreateGUIObjectsXMLFile.generateSignalHead(x, 70, signal, true, printWriter);
                                    break;
                                }
                                case SIGNALMAST: {
                                    CreateGUIObjectsXMLFile.generateSignalMast(x, 70, signal, true, printWriter);
                                    break;
                                }
                            }
                            x += 11;
                        }
                    }
                }
                if (codeButtonHandlerData._mSIDL_Enabled && !ProjectsCommonSubs.isNullOrEmptyString(codeButtonHandlerData._mSIDL_NormalInternalSensor.getHandleName())) {
                    CreateGUIObjectsXMLFile.generateSignalLever(thisObjectHorizontalPosition + 8, CreateGUIObjectsXMLFile.adjustSignalItemsYBySize(492, otherData._mGUIDesign_VerticalSize), directionLeft ? codeButtonHandlerData._mSIDL_LeftInternalSensor.getHandleName() : "", codeButtonHandlerData._mSIDL_NormalInternalSensor.getHandleName(), directionRight ? codeButtonHandlerData._mSIDL_RightInternalSensor.getHandleName() : "", printWriter);
                    CreateGUIObjectsXMLFile.generateTextPositionableLabelCentered(thisObjectHorizontalPosition + 32, CreateGUIObjectsXMLFile.adjustSignalItemsYBySize(470, otherData._mGUIDesign_VerticalSize), Integer.toString(codeButtonHandlerData._mSignalEtcNumber), printWriter);
                }
                if (codeButtonHandlerData._mCO_Enabled && !ProjectsCommonSubs.isNullOrEmptyString(codeButtonHandlerData._mCO_CallOnToggleInternalSensor.getHandleName())) {
                    CreateGUIObjectsXMLFile.generateToggle(thisObjectHorizontalPosition + 21, CreateGUIObjectsXMLFile.adjustCallOnItemsYBySize(582, otherData._mGUIDesign_VerticalSize), codeButtonHandlerData._mCO_CallOnToggleInternalSensor.getHandleName(), printWriter);
                    CreateGUIObjectsXMLFile.generateTextPositionableLabel(thisObjectHorizontalPosition + 48, CreateGUIObjectsXMLFile.adjustCallOnItemsYBySize(590, otherData._mGUIDesign_VerticalSize), Bundle.getMessage("CreateGUIObjectsXMLFileCallOn"), printWriter);
                }
                if (codeButtonHandlerData._mTUL_Enabled && codeButtonHandlerData._mTUL_GUI_IconsEnabled) {
                    if (!ProjectsCommonSubs.isNullOrEmptyString(codeButtonHandlerData._mTUL_DispatcherInternalSensorLockToggle.getHandleName())) {
                        CreateGUIObjectsXMLFile.generateToggle(thisObjectHorizontalPosition + 21, CreateGUIObjectsXMLFile.adjustLockedItemsYBySize(541, otherData._mGUIDesign_VerticalSize), codeButtonHandlerData._mTUL_DispatcherInternalSensorLockToggle.getHandleName(), printWriter);
                        CreateGUIObjectsXMLFile.generateTextPositionableLabel(thisObjectHorizontalPosition + 48, CreateGUIObjectsXMLFile.adjustLockedItemsYBySize(536, otherData._mGUIDesign_VerticalSize), Bundle.getMessage("CreateGUIObjectsXMLFileLocal"), printWriter);
                        CreateGUIObjectsXMLFile.generateTextPositionableLabel(thisObjectHorizontalPosition + 48, CreateGUIObjectsXMLFile.adjustLockedItemsYBySize(560, otherData._mGUIDesign_VerticalSize), Bundle.getMessage("CreateGUIObjectsXMLFileLocked"), printWriter);
                    }
                    if (!ProjectsCommonSubs.isNullOrEmptyString(codeButtonHandlerData._mTUL_DispatcherInternalSensorUnlockedIndicator.getHandleName())) {
                        CreateGUIObjectsXMLFile.generateSensorIndicator(thisObjectHorizontalPosition + 22, 200, codeButtonHandlerData._mTUL_DispatcherInternalSensorUnlockedIndicator.getHandleName(), "red", false, printWriter);
                        CreateGUIObjectsXMLFile.generateTextPositionableLabel(thisObjectHorizontalPosition + 9, 230, Bundle.getMessage("CreateGUIObjectsXMLFileUnlocked"), printWriter);
                    }
                }
                thisObjectHorizontalPosition += 65;
            }
            for (int i = 0; i < otherData._mGUIDesign_NumberOfEmptyColumnsAtEnd; ++i) {
                CreateGUIObjectsXMLFile.generatePanel(thisObjectHorizontalPosition, 0, otherData._mGUIDesign_VerticalSize, "Panel-blank", printWriter);
                thisObjectHorizontalPosition += 65;
            }
            CreateGUIObjectsXMLFile.generatePanel(thisObjectHorizontalPosition, 0, otherData._mGUIDesign_VerticalSize, "Panel-right", printWriter);
        }
        printWriter.println("  </paneleditor>");
        CreateXMLFiles.generateEpilogue(printWriter);
        printWriter.close();
    }

    private static void generateBuilderPlate(PrintWriter printWriter) {
        printWriter.println("    <positionablelabel x=\"55\" y=\"323\" level=\"3\" forcecontroloff=\"false\" hidden=\"no\" positionable=\"true\" showtooltip=\"true\" editable=\"true\" icon=\"yes\" class=\"jmri.jmrit.display.configurexml.PositionableLabelXml\">");
        printWriter.println("      <tooltip>Icon</tooltip>");
        printWriter.println("      <icon url=\"program:resources/icons/USS/plate/base-plates/misc/USS-plate.gif\" scale=\"1.0\">");
        printWriter.println("        <rotation>0</rotation>");
        printWriter.println("      </icon>");
        printWriter.println("    </positionablelabel>");
    }

    private static void generateTextPositionableLabel(int x, int y, String text, PrintWriter printWriter) {
        printWriter.println("    <positionablelabel x=\"" + x + "\" y=\"" + y + "\" level=\"4\" forcecontroloff=\"false\" hidden=\"no\" positionable=\"true\" showtooltip=\"true\" editable=\"true\" text=\"" + text + "\" fontname=\"Dialog.plain\" size=\"11\" style=\"0\" red=\"255\" green=\"255\" blue=\"255\" hasBackground=\"no\" justification=\"centre\" class=\"jmri.jmrit.display.configurexml.PositionableLabelXml\">");
        printWriter.println("      <tooltip>Text Label</tooltip>");
        printWriter.println("    </positionablelabel>");
    }

    private static void generateTextPositionableLabelCentered(int x, int y, String text, PrintWriter printWriter) {
        CreateGUIObjectsXMLFile.generateTextPositionableLabel(CreateGUIObjectsXMLFile.centerText(x, text), y, text, printWriter);
    }

    private static int centerText(int originalValue, String text) {
        AffineTransform affinetransform = new AffineTransform();
        FontRenderContext frc = new FontRenderContext(affinetransform, true, true);
        Font font = new Font(DIALOG_USED, 0, 11);
        int textwidth = (int)font.getStringBounds(text, frc).getWidth();
        return originalValue - textwidth / 2;
    }

    private static void generatePanel(int x, int y, OtherData.VERTICAL_SIZE verticalSize, String resourceFilename, PrintWriter printWriter) {
        switch (verticalSize) {
            default: {
                resourceFilename = (String)resourceFilename + "-7.gif";
                break;
            }
            case MEDIUM: {
                resourceFilename = (String)resourceFilename + "-8.gif";
                break;
            }
            case LARGE: {
                resourceFilename = (String)resourceFilename + "-9.gif";
            }
        }
        printWriter.println("    <positionablelabel x=\"" + x + "\" y=\"" + y + "\" level=\"1\" forcecontroloff=\"false\" hidden=\"no\" positionable=\"false\" showtooltip=\"false\" editable=\"true\" icon=\"yes\" class=\"jmri.jmrit.display.configurexml.PositionableLabelXml\">");
        printWriter.println("      <icon url=\"program:resources/icons/USS/background/" + (String)resourceFilename + "\" scale=\"1.0\">");
        printWriter.println("        <rotation>0</rotation>");
        printWriter.println("      </icon>");
        printWriter.println("    </positionablelabel>");
    }

    private static void generateSensorIndicator(int x, int y, String sensor, String color, boolean unknownInconsistentRedBlink, PrintWriter printWriter) {
        String unknown = unknownInconsistentRedBlink ? "blink/red-b" : "s-unknown";
        String inconsistent = unknownInconsistentRedBlink ? "blink/red-b" : "s-inconsistent";
        printWriter.println("    <sensoricon sensor=\"" + sensor + "\" x=\"" + x + "\" y=\"" + y + "\" level=\"10\" forcecontroloff=\"false\" hidden=\"no\" positionable=\"true\" showtooltip=\"true\" editable=\"true\" momentary=\"false\" icon=\"yes\" class=\"jmri.jmrit.display.configurexml.SensorIconXml\">");
        printWriter.println("      <tooltip>" + sensor + "</tooltip>");
        printWriter.println("      <active url=\"program:resources/icons/USS/sensor/" + color + "-on.gif\" scale=\"1.0\">");
        printWriter.println("        <rotation>0</rotation>");
        printWriter.println("      </active>");
        printWriter.println("      <inactive url=\"program:resources/icons/USS/sensor/" + color + "-off.gif\" scale=\"1.0\">");
        printWriter.println("        <rotation>0</rotation>");
        printWriter.println("      </inactive>");
        printWriter.println("      <unknown url=\"program:resources/icons/USS/sensor/" + unknown + ".gif\" scale=\"1.0\">");
        printWriter.println("        <rotation>0</rotation>");
        printWriter.println("      </unknown>");
        printWriter.println("      <inconsistent url=\"program:resources/icons/USS/sensor/" + inconsistent + ".gif\" scale=\"1.0\">");
        printWriter.println("        <rotation>0</rotation>");
        printWriter.println("      </inconsistent>");
        printWriter.println("      <iconmaps />");
        printWriter.println("    </sensoricon>");
    }

    private static void generateKnockout(int x, int y, PrintWriter printWriter) {
        printWriter.println("    <positionablelabel x=\"" + x + "\" y=\"" + y + "\" level=\"3\" forcecontroloff=\"false\" hidden=\"no\" positionable=\"true\" showtooltip=\"true\" editable=\"true\" icon=\"yes\" class=\"jmri.jmrit.display.configurexml.PositionableLabelXml\">");
        printWriter.println("      <icon url=\"program:resources/icons/USSpanels/Panels/knockout.gif\" degrees=\"0\" scale=\"1.0\">");
        printWriter.println("        <rotation>0</rotation>");
        printWriter.println("      </icon>");
        printWriter.println("    </positionablelabel>");
    }

    private static void generateTurnoutIcon(int x, int y, String turnout, boolean isTurnoutLeftHanded, PrintWriter printWriter) {
        String partialFilename = isTurnoutLeftHanded ? "left/west/os-l-w" : "right/east/os-r-e";
        printWriter.println("    <turnouticon turnout=\"" + turnout + "\" x=\"" + x + "\" y=\"" + y + "\" level=\"7\" forcecontroloff=\"true\" hidden=\"no\" positionable=\"true\" showtooltip=\"false\" editable=\"true\" tristate=\"false\" momentary=\"false\" directControl=\"false\" class=\"jmri.jmrit.display.configurexml.TurnoutIconXml\">");
        printWriter.println("      <icons>");
        printWriter.println("        <closed url=\"program:resources/icons/USS/track/turnout/" + partialFilename + "-closed.gif\" scale=\"1.0\">");
        printWriter.println("          <rotation>0</rotation>");
        printWriter.println("        </closed>");
        printWriter.println("        <thrown url=\"program:resources/icons/USS/track/turnout/" + partialFilename + "-thrown.gif\" scale=\"1.0\">");
        printWriter.println("          <rotation>0</rotation>");
        printWriter.println("        </thrown>");
        printWriter.println("        <unknown url=\"program:resources/icons/USS/track/turnout/" + partialFilename + "-unknown.gif\" scale=\"1.0\">");
        printWriter.println("          <rotation>0</rotation>");
        printWriter.println("        </unknown>");
        printWriter.println("        <inconsistent url=\"program:resources/icons/USS/track/turnout/" + partialFilename + "-inconsistent.gif\" scale=\"1.0\">");
        printWriter.println("          <rotation>0</rotation>");
        printWriter.println("        </inconsistent>");
        printWriter.println("      </icons>");
        printWriter.println("      <iconmaps />");
        printWriter.println("    </turnouticon>");
    }

    private static void generateTurnoutCrossoverIcon(int x, int y, String turnout, boolean isDoubleCrossover, boolean isTurnoutLeftHanded, PrintWriter printWriter) {
        String partialFilename = isDoubleCrossover ? "double/os-dc" : (isTurnoutLeftHanded ? "left/os-l-sc" : "right/os-r-sc");
        printWriter.println("    <turnouticon turnout=\"" + turnout + "\" x=\"" + x + "\" y=\"" + y + "\" level=\"7\" forcecontroloff=\"true\" hidden=\"no\" positionable=\"true\" showtooltip=\"false\" editable=\"true\" tristate=\"false\" momentary=\"false\" directControl=\"false\" class=\"jmri.jmrit.display.configurexml.TurnoutIconXml\">");
        printWriter.println("      <icons>");
        printWriter.println("        <closed url=\"program:resources/icons/USS/track/crossover/" + partialFilename + "-closed.gif\" scale=\"1.0\">");
        printWriter.println("          <rotation>0</rotation>");
        printWriter.println("        </closed>");
        printWriter.println("        <thrown url=\"program:resources/icons/USS/track/crossover/" + partialFilename + "-thrown.gif\" scale=\"1.0\">");
        printWriter.println("          <rotation>0</rotation>");
        printWriter.println("        </thrown>");
        printWriter.println("        <unknown url=\"program:resources/icons/USS/track/crossover/" + partialFilename + "-unknown.gif\" scale=\"1.0\">");
        printWriter.println("          <rotation>0</rotation>");
        printWriter.println("        </unknown>");
        printWriter.println("        <inconsistent url=\"program:resources/icons/USS/track/crossover/" + partialFilename + "-inconsistent.gif\" scale=\"1.0\">");
        printWriter.println("          <rotation>0</rotation>");
        printWriter.println("        </inconsistent>");
        printWriter.println("      </icons>");
        printWriter.println("      <iconmaps />");
        printWriter.println("    </turnouticon>");
    }

    private static void generateSignalHead(int x, int y, String signalHead, boolean isRightToLeft, PrintWriter printWriter) {
        String direction = isRightToLeft ? "left" : "right";
        printWriter.println("    <signalheadicon signalhead=\"" + signalHead + "\" x=\"" + x + "\" y=\"" + y + "\" level=\"9\" forcecontroloff=\"false\" hidden=\"no\" positionable=\"true\" showtooltip=\"true\" editable=\"true\" clickmode=\"3\" litmode=\"false\" class=\"jmri.jmrit.display.configurexml.SignalHeadIconXml\">");
        printWriter.println("      <tooltip>" + signalHead + "</tooltip>");
        printWriter.println("      <icons>");
        CreateGUIObjectsXMLFile.generateSignalBlock(direction, "held", printWriter);
        CreateGUIObjectsXMLFile.generateSignalBlock(direction, "dark", printWriter);
        CreateGUIObjectsXMLFile.generateSignalBlock(direction, "red", printWriter);
        CreateGUIObjectsXMLFile.generateSignalBlock(direction, "yellow", printWriter);
        CreateGUIObjectsXMLFile.generateSignalBlock(direction, "green", printWriter);
        CreateGUIObjectsXMLFile.generateSignalBlock(direction, "flashred", printWriter);
        CreateGUIObjectsXMLFile.generateSignalBlock(direction, "flashyellow", printWriter);
        CreateGUIObjectsXMLFile.generateSignalBlock(direction, "flashgreen", printWriter);
        printWriter.println("      </icons>");
        printWriter.println("      <iconmaps />");
        printWriter.println("    </signalheadicon>");
    }

    private static void generateSignalBlock(String direction, String color, PrintWriter printWriter) {
        printWriter.println(CreateGUIObjectsXMLFile.generateSignalLineStart(direction, color));
        printWriter.println("          <rotation>0</rotation>");
        printWriter.println(CreateGUIObjectsXMLFile.generateSignalLineEnd(color));
    }

    private static String generateSignalLineStart(String direction, String color) {
        return "        <" + color + " url=\"program:resources/icons/smallschematics/searchlights/" + direction + "-" + color + "-short.gif\" scale=\"1.0\">";
    }

    private static String generateSignalLineEnd(String color) {
        return "        </" + color + ">";
    }

    private static void generateSignalMast(int x, int y, String signalMast, boolean isRightToLeft, PrintWriter printWriter) {
        String degrees = isRightToLeft ? "180" : "0";
        printWriter.println("    <signalmasticon signalmast=\"" + signalMast + "\" x=\"" + x + "\" y=\"" + y + "\" level=\"9\" forcecontroloff=\"false\" hidden=\"no\" positionable=\"true\" showtooltip=\"true\" editable=\"true\" clickmode=\"0\" litmode=\"false\" degrees=\"" + degrees + "\" scale=\"1.0\" imageset=\"default\" class=\"jmri.jmrit.display.configurexml.SignalMastIconXml\">");
        printWriter.println("      <tooltip>" + signalMast + "</tooltip>");
        printWriter.println("    </signalmasticon>");
    }

    public static void generateTurnoutLever(int x, int y, String lever, PrintWriter printWriter) {
        printWriter.println("    <sensoricon sensor=\"" + lever + "\" x=\"" + x + "\" y=\"" + y + "\" level=\"10\" forcecontroloff=\"false\" hidden=\"no\" positionable=\"true\" showtooltip=\"true\" editable=\"true\" momentary=\"false\" icon=\"yes\" class=\"jmri.jmrit.display.configurexml.SensorIconXml\">");
        printWriter.println("      <tooltip>" + lever + "</tooltip>");
        printWriter.println("      <active url=\"program:resources/icons/USS/plate/levers/lever-left-wide.gif\" scale=\"1.0\">");
        printWriter.println("        <rotation>0</rotation>");
        printWriter.println("      </active>");
        printWriter.println("      <inactive url=\"program:resources/icons/USS/plate/levers/lever-right-wide.gif\" scale=\"1.0\">");
        printWriter.println("        <rotation>0</rotation>");
        printWriter.println("      </inactive>");
        printWriter.println("      <unknown url=\"program:resources/icons/USS/plate/levers/lever-unknown-wide.gif\" scale=\"1.0\">");
        printWriter.println("        <rotation>0</rotation>");
        printWriter.println("      </unknown>");
        printWriter.println("      <inconsistent url=\"program:resources/icons/USS/plate/levers/lever-inconsistent-wide.gif\" scale=\"1.0\">");
        printWriter.println("        <rotation>0</rotation>");
        printWriter.println("      </inconsistent>");
        printWriter.println("      <iconmaps />");
        printWriter.println("    </sensoricon>");
    }

    public static void generateSignalLever(int x, int y, String left, String vertical, String right, PrintWriter printWriter) {
        printWriter.println("    <multisensoricon x=\"" + x + "\" y=\"" + y + "\" level=\"10\" forcecontroloff=\"false\" hidden=\"no\" positionable=\"true\" showtooltip=\"true\" editable=\"true\" updown=\"false\" class=\"jmri.jmrit.display.configurexml.MultiSensorIconXml\">");
        printWriter.println("      <tooltip>" + left + "," + vertical + "," + right + "</tooltip>");
        if (!left.trim().isEmpty()) {
            printWriter.println("      <active url=\"program:resources/icons/USS/plate/levers/lever-left-wide.gif\" scale=\"1.0\" sensor=\"" + left + "\">");
            printWriter.println("        <rotation>0</rotation>");
            printWriter.println("      </active>");
        }
        printWriter.println("      <active url=\"program:resources/icons/USS/plate/levers/lever-vertical-wide.gif\" scale=\"1.0\" sensor=\"" + vertical + "\">");
        printWriter.println("        <rotation>0</rotation>");
        printWriter.println("      </active>");
        if (!right.trim().isEmpty()) {
            printWriter.println("      <active url=\"program:resources/icons/USS/plate/levers/lever-right-wide.gif\" scale=\"1.0\" sensor=\"" + right + "\">");
            printWriter.println("        <rotation>0</rotation>");
            printWriter.println("      </active>");
        }
        printWriter.println("      <inactive url=\"program:resources/icons/USS/plate/levers/lever-inactive-wide.gif\" scale=\"1.0\">");
        printWriter.println("        <rotation>0</rotation>");
        printWriter.println("      </inactive>");
        printWriter.println("      <unknown url=\"program:resources/icons/USS/plate/levers/lever-unknown-wide.gif\" scale=\"1.0\">");
        printWriter.println("        <rotation>0</rotation>");
        printWriter.println("      </unknown>");
        printWriter.println("      <inconsistent url=\"program:resources/icons/USS/plate/levers/lever-inconsistent-wide.gif\" scale=\"1.0\">");
        printWriter.println("        <rotation>0</rotation>");
        printWriter.println("      </inconsistent>");
        printWriter.println("    </multisensoricon>");
    }

    public static void generateToggle(int x, int y, String sensor, PrintWriter printWriter) {
        printWriter.println("    <sensoricon sensor=\"" + sensor + "\" x=\"" + x + "\" y=\"" + y + "\" level=\"10\" forcecontroloff=\"false\" hidden=\"no\" positionable=\"true\" showtooltip=\"true\" editable=\"true\" momentary=\"false\" icon=\"yes\" class=\"jmri.jmrit.display.configurexml.SensorIconXml\">");
        printWriter.println("      <tooltip>" + sensor + "</tooltip>");
        printWriter.println("      <active url=\"program:resources/icons/USS/plate/levers/switch-on.gif\" scale=\"1.0\">");
        printWriter.println("        <rotation>0</rotation>");
        printWriter.println("      </active>");
        printWriter.println("      <inactive url=\"program:resources/icons/USS/plate/levers/switch-off.gif\" scale=\"1.0\">");
        printWriter.println("        <rotation>0</rotation>");
        printWriter.println("      </inactive>");
        printWriter.println("      <unknown url=\"program:resources/icons/USS/plate/levers/switch-unknown.gif\" scale=\"1.0\">");
        printWriter.println("        <rotation>0</rotation>");
        printWriter.println("      </unknown>");
        printWriter.println("      <inconsistent url=\"program:resources/icons/USS/plate/levers/switch-inconsistent.gif\" scale=\"1.0\">");
        printWriter.println("        <rotation>0</rotation>");
        printWriter.println("      </inconsistent>");
        printWriter.println("      <iconmaps />");
        printWriter.println("    </sensoricon>");
    }

    public static void generatePushButton(int x, int y, String sensor, PrintWriter printWriter) {
        printWriter.println("    <sensoricon sensor=\"" + sensor + "\" x=\"" + x + "\" y=\"" + y + "\" level=\"10\" forcecontroloff=\"false\" hidden=\"no\" positionable=\"true\" showtooltip=\"true\" editable=\"true\" momentary=\"true\" icon=\"yes\" class=\"jmri.jmrit.display.configurexml.SensorIconXml\">");
        printWriter.println("      <tooltip>" + sensor + "</tooltip>");
        printWriter.println("      <active url=\"program:resources/icons/USS/plate/levers/code-press.gif\" scale=\"1.0\">");
        printWriter.println("        <rotation>0</rotation>");
        printWriter.println("      </active>");
        printWriter.println("      <inactive url=\"program:resources/icons/USS/plate/levers/code.gif\" scale=\"1.0\">");
        printWriter.println("        <rotation>0</rotation>");
        printWriter.println("      </inactive>");
        printWriter.println("      <unknown url=\"program:resources/icons/USS/plate/levers/code-unknown.gif\" scale=\"1.0\">");
        printWriter.println("        <rotation>0</rotation>");
        printWriter.println("      </unknown>");
        printWriter.println("      <inconsistent url=\"program:resources/icons/USS/plate/levers/code-inconsistent.gif\" scale=\"1.0\">");
        printWriter.println("        <rotation>0</rotation>");
        printWriter.println("      </inconsistent>");
        printWriter.println("      <iconmaps />");
        printWriter.println("    </sensoricon>");
    }

    private static int adjustSwitchItemsYBySize(int y, OtherData.VERTICAL_SIZE verticalSize) {
        switch (verticalSize) {
            default: {
                return y;
            }
            case MEDIUM: {
                return y + 6;
            }
            case LARGE: 
        }
        return y + 18;
    }

    private static int adjustSignalItemsYBySize(int y, OtherData.VERTICAL_SIZE verticalSize) {
        switch (verticalSize) {
            default: {
                return y;
            }
            case MEDIUM: {
                return y + 12;
            }
            case LARGE: 
        }
        return y + 33;
    }

    private static int adjustLockedItemsYBySize(int y, OtherData.VERTICAL_SIZE verticalSize) {
        switch (verticalSize) {
            default: {
                return y;
            }
            case MEDIUM: {
                return y + 38;
            }
            case LARGE: 
        }
        return y + 82;
    }

    private static int adjustCallOnItemsYBySize(int y, OtherData.VERTICAL_SIZE verticalSize) {
        switch (verticalSize) {
            default: {
                return y;
            }
            case MEDIUM: {
                return y + 85;
            }
            case LARGE: 
        }
        return y + 134;
    }

    private static int adjustCodeButtonYBySize(int y, OtherData.VERTICAL_SIZE verticalSize) {
        switch (verticalSize) {
            default: {
                return y;
            }
            case MEDIUM: {
                return y + 120;
            }
            case LARGE: 
        }
        return y + 180;
    }
}

