/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.ctc.editor.gui;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.LayoutStyle;
import jmri.InstanceManager;
import jmri.jmrit.ctc.ctcserialdata.CTCSerialData;
import jmri.jmrit.ctc.ctcserialdata.CodeButtonHandlerData;
import jmri.jmrit.ctc.ctcserialdata.OtherData;
import jmri.jmrit.ctc.ctcserialdata.TrafficLockingData;
import jmri.jmrit.ctc.editor.code.AwtWindowProperties;
import jmri.jmrit.ctc.editor.code.CheckJMRIObject;
import jmri.jmrit.ctc.editor.code.CommonSubs;
import jmri.jmrit.ctc.editor.gui.Bundle;
import jmri.jmrit.ctc.editor.gui.FrmMainForm;
import jmri.jmrit.ctc.editor.gui.FrmTRL_Rules;
import jmri.jmrit.ctc.topology.Topology;
import jmri.jmrit.ctc.topology.TopologyInfo;

public class FrmTRL
extends JFrame {
    private static final String FORM_PROPERTIES = "DlgTRL";
    private final AwtWindowProperties _mAwtWindowProperties;
    private boolean _mClosedNormally = false;
    private final CodeButtonHandlerData _mCodeButtonHandlerData;
    private final CTCSerialData _mCTCSerialData;
    private final CheckJMRIObject _mCheckJMRIObject;
    private final FrmMainForm _mMainForm;
    private Topology _mTopology;
    private JButton _mAutoGenerate;
    private JLabel _mAutoGenerateWarning;
    private JButton _mEditLeftTrafficLockingRules;
    private JButton _mEditRightTrafficLockingRules;
    private JLabel _mLeftNumberOfRules;
    private JLabel _mLeftNumberOfRulesPrompt;
    private JButton _mOK;
    private JButton _mReverseLeftRight;
    private JLabel _mRightNumberOfRules;
    private JLabel _mRightNumberOfRulesPrompt;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel4;

    public boolean closedNormally() {
        return this._mClosedNormally;
    }

    private void initOrig() {
    }

    private boolean dataChanged() {
        return false;
    }

    public FrmTRL(AwtWindowProperties awtWindowProperties, CodeButtonHandlerData codeButtonHandlerData, CTCSerialData ctcSerialData, CheckJMRIObject checkJMRIObject) {
        this.initComponents();
        CommonSubs.addHelpMenu(this, "package.jmri.jmrit.ctc.CTC_frmTRL", true);
        this._mMainForm = InstanceManager.getDefault(FrmMainForm.class);
        this._mAwtWindowProperties = awtWindowProperties;
        this._mCodeButtonHandlerData = codeButtonHandlerData;
        this._mCTCSerialData = ctcSerialData;
        this._mCheckJMRIObject = checkJMRIObject;
        this.initOrig();
        this._mAwtWindowProperties.setWindowState(this, FORM_PROPERTIES);
        this.getRootPane().setDefaultButton(this._mOK);
        this.updateRuleCounts();
        this.setTitle(Bundle.getMessage("TitleDlgTRL") + " " + codeButtonHandlerData.myShortStringNoComma());
        ArrayList<String> listOfOSSectionOccupiedExternalSensors = this.getListOfExternalSensorsSlaved(codeButtonHandlerData, this._mCTCSerialData.getCodeButtonHandlerDataArrayList());
        this._mTopology = new Topology(this._mCTCSerialData, listOfOSSectionOccupiedExternalSensors, Bundle.getMessage("TLE_Normal"), Bundle.getMessage("TLE_Reverse"));
        boolean isMastSignalType = this._mCTCSerialData.getOtherData()._mSignalSystemType == OtherData.SIGNAL_SYSTEM_TYPE.SIGNALMAST;
        boolean topologyAvailable = this._mTopology.isTopologyAvailable() && isMastSignalType;
        this._mAutoGenerate.setVisible(topologyAvailable);
        this._mReverseLeftRight.setVisible(topologyAvailable);
        this._mAutoGenerateWarning.setVisible(topologyAvailable);
    }

    private ArrayList<String> getListOfExternalSensorsSlaved(CodeButtonHandlerData currentCodeButtonHandlerData, ArrayList<CodeButtonHandlerData> codeButtonHandlerDataArrayList) {
        ArrayList<String> returnValue = new ArrayList<String>();
        returnValue.add(currentCodeButtonHandlerData._mOSSectionOccupiedExternalSensor.getHandleName());
        int currentUniqueID = currentCodeButtonHandlerData._mUniqueID;
        for (CodeButtonHandlerData codeButtonHandlerData : codeButtonHandlerDataArrayList) {
            if (currentCodeButtonHandlerData == codeButtonHandlerData || codeButtonHandlerData._mOSSectionSwitchSlavedToUniqueID == -1 || currentUniqueID != codeButtonHandlerData._mOSSectionSwitchSlavedToUniqueID) continue;
            returnValue.add(codeButtonHandlerData._mOSSectionOccupiedExternalSensor.getHandleName());
        }
        return returnValue;
    }

    public static boolean dialogCodeButtonHandlerDataValid(CheckJMRIObject checkJMRIObject, CodeButtonHandlerData codeButtonHandlerData) {
        if (!FrmTRL.valid(checkJMRIObject, codeButtonHandlerData._mTRL_LeftTrafficLockingRules)) {
            return false;
        }
        return FrmTRL.valid(checkJMRIObject, codeButtonHandlerData._mTRL_RightTrafficLockingRules);
    }

    private void updateRuleCounts() {
        this._mLeftNumberOfRules.setText(Bundle.getMessage("InfoDlgTRLRules") + " " + Integer.toString(this._mCodeButtonHandlerData._mTRL_LeftTrafficLockingRules.size()));
        this._mRightNumberOfRules.setText(Bundle.getMessage("InfoDlgTRLRules") + " " + Integer.toString(this._mCodeButtonHandlerData._mTRL_RightTrafficLockingRules.size()));
        this._mLeftNumberOfRulesPrompt.setForeground(FrmTRL.valid(this._mCheckJMRIObject, this._mCodeButtonHandlerData._mTRL_LeftTrafficLockingRules) ? Color.black : Color.red);
        this._mRightNumberOfRulesPrompt.setForeground(FrmTRL.valid(this._mCheckJMRIObject, this._mCodeButtonHandlerData._mTRL_RightTrafficLockingRules) ? Color.black : Color.red);
    }

    private static boolean valid(CheckJMRIObject checkJMRIObject, ArrayList<TrafficLockingData> trafficLockingRules) {
        for (TrafficLockingData trafficLockingRule : trafficLockingRules) {
            if (checkJMRIObject.validClass(trafficLockingRule)) continue;
            return false;
        }
        return true;
    }

    private void initComponents() {
        this._mEditLeftTrafficLockingRules = new JButton();
        this._mEditRightTrafficLockingRules = new JButton();
        this._mLeftNumberOfRulesPrompt = new JLabel();
        this._mRightNumberOfRulesPrompt = new JLabel();
        this._mOK = new JButton();
        this._mLeftNumberOfRules = new JLabel();
        this._mRightNumberOfRules = new JLabel();
        this.jLabel10 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jLabel11 = new JLabel();
        this._mAutoGenerate = new JButton();
        this._mReverseLeftRight = new JButton();
        this._mAutoGenerateWarning = new JLabel();
        this.setDefaultCloseOperation(2);
        this.setTitle(Bundle.getMessage("TitleDlgTRL"));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                FrmTRL.this.formWindowClosing(evt);
            }
        });
        this._mEditLeftTrafficLockingRules.setText(Bundle.getMessage("LabelDlgTRLEdit"));
        this._mEditLeftTrafficLockingRules.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmTRL.this._mEditLeftTrafficLockingRulesActionPerformed(evt);
            }
        });
        this._mEditRightTrafficLockingRules.setText(Bundle.getMessage("LabelDlgTRLEdit"));
        this._mEditRightTrafficLockingRules.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmTRL.this._mEditRightTrafficLockingRulesActionPerformed(evt);
            }
        });
        this._mLeftNumberOfRulesPrompt.setText(Bundle.getMessage("LabelDlgTRLLeft"));
        this._mRightNumberOfRulesPrompt.setText(Bundle.getMessage("LabelDlgTRLRight"));
        this._mOK.setText(Bundle.getMessage("ButtonOK"));
        this._mOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmTRL.this._mOKActionPerformed(evt);
            }
        });
        this._mLeftNumberOfRules.setText(Bundle.getMessage("InfoDlgTRLRulesQuestion"));
        this._mRightNumberOfRules.setText(Bundle.getMessage("InfoDlgTRLRulesQuestion"));
        this.jLabel10.setText(Bundle.getMessage("InfoDlgTRLNote2"));
        this.jLabel4.setText(Bundle.getMessage("InfoDlgTRLNote1"));
        this.jLabel11.setText(Bundle.getMessage("InfoDlgTRLNote3"));
        this._mAutoGenerate.setText(Bundle.getMessage("LabelDlgTRLAutoGenerate"));
        this._mAutoGenerate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmTRL.this._mAutoGenerateActionPerformed(evt);
            }
        });
        this._mReverseLeftRight.setText(Bundle.getMessage("LabelDlgTRLReverseLeftRight"));
        this._mReverseLeftRight.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmTRL.this._mReverseLeftRightActionPerformed(evt);
            }
        });
        this._mAutoGenerateWarning.setText(Bundle.getMessage("LabelDlgTRLAutoGenerateWarning"));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(49, 49, 49).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this._mLeftNumberOfRulesPrompt).addComponent(this._mRightNumberOfRulesPrompt)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this._mEditRightTrafficLockingRules).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this._mRightNumberOfRules, -2, 62, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this._mReverseLeftRight)).addGroup(layout.createSequentialGroup().addComponent(this._mEditLeftTrafficLockingRules).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this._mLeftNumberOfRules, -2, 62, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this._mAutoGenerateWarning).addComponent(this._mAutoGenerate, -2, 117, -2))))).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel4)).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel10)).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel11)).addGroup(layout.createSequentialGroup().addGap(164, 164, 164).addComponent(this._mOK))).addContainerGap(-1, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this._mAutoGenerateWarning).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this._mLeftNumberOfRulesPrompt).addComponent(this._mEditLeftTrafficLockingRules).addComponent(this._mLeftNumberOfRules).addComponent(this._mAutoGenerate)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this._mEditRightTrafficLockingRules).addComponent(this._mRightNumberOfRulesPrompt).addComponent(this._mRightNumberOfRules).addComponent(this._mReverseLeftRight)).addGap(13, 13, 13).addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel10).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel11).addGap(18, 18, 18).addComponent(this._mOK).addContainerGap(31, Short.MAX_VALUE)));
        this.pack();
    }

    private void formWindowClosing(WindowEvent evt) {
        this._mAwtWindowProperties.saveWindowState(this, FORM_PROPERTIES);
        if (CommonSubs.allowClose(this, this.dataChanged())) {
            this.dispose();
        }
    }

    private void _mEditLeftTrafficLockingRulesActionPerformed(ActionEvent evt) {
        if (this._mMainForm._mTRL_RulesFormOpen) {
            return;
        }
        this._mMainForm._mTRL_RulesFormOpen = true;
        final FrmTRL_Rules dialog = new FrmTRL_Rules(this._mAwtWindowProperties, this._mCodeButtonHandlerData, true, this._mCTCSerialData, this._mCheckJMRIObject);
        dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                if (dialog.closedNormally()) {
                    FrmTRL.this._mClosedNormally = true;
                    FrmTRL.this.updateRuleCounts();
                }
                FrmTRL.this._mMainForm._mTRL_RulesFormOpen = false;
            }
        });
        dialog.setVisible(true);
    }

    private void _mEditRightTrafficLockingRulesActionPerformed(ActionEvent evt) {
        if (this._mMainForm._mTRL_RulesFormOpen) {
            return;
        }
        this._mMainForm._mTRL_RulesFormOpen = true;
        final FrmTRL_Rules dialog = new FrmTRL_Rules(this._mAwtWindowProperties, this._mCodeButtonHandlerData, false, this._mCTCSerialData, this._mCheckJMRIObject);
        dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                if (dialog.closedNormally()) {
                    FrmTRL.this._mClosedNormally = true;
                    FrmTRL.this.updateRuleCounts();
                }
                FrmTRL.this._mMainForm._mTRL_RulesFormOpen = false;
            }
        });
        dialog.setVisible(true);
    }

    private void _mOKActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void _mReverseLeftRightActionPerformed(ActionEvent evt) {
        ArrayList<TrafficLockingData> blah = this._mCodeButtonHandlerData._mTRL_LeftTrafficLockingRules;
        this._mCodeButtonHandlerData._mTRL_LeftTrafficLockingRules = this._mCodeButtonHandlerData._mTRL_RightTrafficLockingRules;
        this._mCodeButtonHandlerData._mTRL_RightTrafficLockingRules = blah;
        this.updateRuleCounts();
    }

    private void _mAutoGenerateActionPerformed(ActionEvent evt) {
        TrafficLockingData trafficLockingData;
        TopologyInfo topologyInfo;
        int index;
        ArrayList<TopologyInfo> topologyInfosArrayList = this._mTopology.getTrafficLockingRules(true);
        this._mCodeButtonHandlerData._mTRL_LeftTrafficLockingRules.clear();
        for (index = 0; index < topologyInfosArrayList.size(); ++index) {
            topologyInfo = topologyInfosArrayList.get(index);
            trafficLockingData = new TrafficLockingData(index + 1, topologyInfo.getDestinationSignalMast(), topologyInfo);
            this._mCodeButtonHandlerData._mTRL_LeftTrafficLockingRules.add(trafficLockingData);
        }
        topologyInfosArrayList = this._mTopology.getTrafficLockingRules(false);
        this._mCodeButtonHandlerData._mTRL_RightTrafficLockingRules.clear();
        for (index = 0; index < topologyInfosArrayList.size(); ++index) {
            topologyInfo = topologyInfosArrayList.get(index);
            trafficLockingData = new TrafficLockingData(index + 1, topologyInfo.getDestinationSignalMast(), topologyInfo);
            this._mCodeButtonHandlerData._mTRL_RightTrafficLockingRules.add(trafficLockingData);
        }
        this.updateRuleCounts();
    }
}

