/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.ctc.topology;

import java.util.ArrayList;
import java.util.List;
import jmri.Block;
import jmri.Sensor;
import jmri.SignalMast;
import jmri.SignalMastLogic;
import jmri.Turnout;
import jmri.jmrit.ctc.ctcserialdata.CTCSerialData;

public class TopologyInfo {
    private final CTCSerialData _mCTCSerialData;
    private final String _mDestinationSignalMast;
    private final String _mNormal;
    private final String _mReverse;
    private final ArrayList<Sensor> _mSensors = new ArrayList();
    private final ArrayList<TurnoutInfo> _mTurnoutInfos = new ArrayList();
    private final ArrayList<Turnout> _mTurnouts = new ArrayList();

    public TopologyInfo() {
        this._mCTCSerialData = null;
        this._mDestinationSignalMast = null;
        this._mNormal = null;
        this._mReverse = null;
    }

    public TopologyInfo(CTCSerialData CTCSerialData2, String destinationSignalMast, String normal, String reverse) {
        this._mCTCSerialData = CTCSerialData2;
        this._mDestinationSignalMast = destinationSignalMast;
        this._mNormal = normal;
        this._mReverse = reverse;
    }

    public String getDestinationSignalMast() {
        return this._mDestinationSignalMast;
    }

    public boolean nonEmpty() {
        return !this._mSensors.isEmpty() || !this._mTurnoutInfos.isEmpty();
    }

    public String getOSSectionText(int index) {
        if (index < this._mTurnoutInfos.size()) {
            return this._mTurnoutInfos.get((int)index)._mOSSectionText;
        }
        return null;
    }

    public String getNormalReversed(int index) {
        if (index < this._mTurnoutInfos.size()) {
            return this._mTurnoutInfos.get((int)index)._mNormalReversed;
        }
        return "Normal";
    }

    public String getSensorDisplayName(int index) {
        if (index < this._mSensors.size()) {
            return this._mSensors.get(index).getDisplayName();
        }
        return "";
    }

    public String getUniqueID(int index) {
        if (index < this._mTurnoutInfos.size()) {
            return Integer.toString(this._mTurnoutInfos.get((int)index)._mUniqueID);
        }
        return null;
    }

    public void addBlocks(List<Block> blocks) {
        for (Block block : blocks) {
            Sensor sensor = block.getSensor();
            if (null == sensor || this._mSensors.contains(sensor)) continue;
            this._mSensors.add(sensor);
        }
    }

    public void addTurnouts(SignalMastLogic signalMastLogic, SignalMast signalMast) {
        boolean isNormal;
        CTCSerialData.CTCTurnoutData turnoutData;
        for (Turnout turnout : signalMastLogic.getTurnouts(signalMast)) {
            if (this._mTurnouts.contains(turnout)) continue;
            this._mTurnouts.add(turnout);
            turnoutData = this._mCTCSerialData.getCTCTurnoutData(turnout);
            if (null == turnoutData) continue;
            isNormal = signalMastLogic.getTurnoutState(turnout, signalMast) == 2;
            this._mTurnoutInfos.add(new TurnoutInfo(turnoutData._mOSSectionText, isNormal ? this._mNormal : this._mReverse, turnoutData._mUniqueID));
        }
        for (Turnout turnout : signalMastLogic.getAutoTurnouts(signalMast)) {
            if (this._mTurnouts.contains(turnout)) continue;
            this._mTurnouts.add(turnout);
            turnoutData = this._mCTCSerialData.getCTCTurnoutData(turnout);
            if (null == turnoutData) continue;
            isNormal = signalMastLogic.getAutoTurnoutState(turnout, signalMast) == 2;
            this._mTurnoutInfos.add(new TurnoutInfo(turnoutData._mOSSectionText, isNormal ? this._mNormal : this._mReverse, turnoutData._mUniqueID));
        }
    }

    private static class TurnoutInfo {
        public final String _mOSSectionText;
        public final String _mNormalReversed;
        public final int _mUniqueID;

        public TurnoutInfo(String OSSectionText, String normalReversed, int uniqueID) {
            this._mOSSectionText = OSSectionText;
            this._mNormalReversed = normalReversed;
            this._mUniqueID = uniqueID;
        }
    }
}

