/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.decoderdefn;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.swing.JLabel;
import jmri.LocoAddress;
import jmri.Programmer;
import jmri.jmrit.XmlFile;
import jmri.jmrit.symbolicprog.ExtraMenuTableModel;
import jmri.jmrit.symbolicprog.ResetTableModel;
import jmri.jmrit.symbolicprog.VariableTableModel;
import org.jdom2.DataConversionException;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DecoderFile
extends XmlFile {
    boolean[] versions = new boolean[256];
    String _mfg = null;
    String _mfgID = null;
    String _model = null;
    String _family = null;
    String _filename = null;
    String _productID = null;
    String _replacementModel = null;
    String _replacementFamily = null;
    String _developerID = null;
    String _manufacturerID = null;
    String _programmingModes = null;
    int _numFns = -1;
    int _numOuts = -1;
    Element _element = null;
    ArrayList<LocoAddress.Protocol> protocols = null;
    int nextCvStoreIndex = 0;
    @SuppressFBWarnings(value={"MS_SHOULD_BE_FINAL"})
    public static String fileLocation = "decoders" + File.separator;
    private static final Logger log = LoggerFactory.getLogger(DecoderFile.class);

    public DecoderFile() {
    }

    public DecoderFile(String mfg, String mfgID, String model, String lowVersionID, String highVersionID, String family, String filename, int numFns, int numOuts, Element decoder) {
        this._mfg = mfg;
        this._mfgID = mfgID;
        this._model = model;
        this._family = family;
        this._filename = filename;
        this._numFns = numFns;
        this._numOuts = numOuts;
        this._element = decoder;
        log.trace("Create DecoderFile with Family \"{}\" Model \"{}\"", (Object)family, (Object)model);
        this.setVersionRange(lowVersionID, highVersionID);
    }

    public DecoderFile(String mfg, String mfgID, String model, String lowVersionID, String highVersionID, String family, String filename, int numFns, int numOuts, Element decoder, String replacementModel, String replacementFamily) {
        this(mfg, mfgID, model, lowVersionID, highVersionID, family, filename, numFns, numOuts, decoder);
        this._replacementModel = replacementModel;
        this._replacementFamily = replacementFamily;
        this._developerID = "-1";
        this._manufacturerID = mfgID.compareTo("") != 0 ? mfgID : "-1";
        this._productID = "-1";
    }

    public DecoderFile(String mfg, String mfgID, String model, String lowVersionID, String highVersionID, String family, String filename, String developerID, String manufacturerID, String productID, int numFns, int numOuts, Element decoder, String replacementModel, String replacementFamily) {
        this(mfg, mfgID, model, lowVersionID, highVersionID, family, filename, numFns, numOuts, decoder);
        this._replacementModel = replacementModel;
        this._replacementFamily = replacementFamily;
        this._developerID = developerID;
        if (mfgID == null) {
            log.error("mfgID missing for decoder file {}", (Object)filename);
        }
        this._manufacturerID = !manufacturerID.isEmpty() && manufacturerID.compareTo("-1") != 0 ? manufacturerID : (mfgID != null && mfgID.compareTo("") != 0 ? mfgID : "-1");
        this._productID = productID;
    }

    public DecoderFile(String mfg, String mfgID, String model, String lowVersionID, String highVersionID, String family, String filename, String developerID, String manufacturerID, String productID, int numFns, int numOuts, Element decoder, String replacementModel, String replacementFamily, String programmingModes) {
        this(mfg, mfgID, model, lowVersionID, highVersionID, family, filename, developerID, manufacturerID, productID, numFns, numOuts, decoder, replacementModel, replacementFamily);
        log.debug("DecoderFile {} created with ProgModes: {}", (Object)model, (Object)programmingModes);
        this._programmingModes = Objects.requireNonNullElse(programmingModes, "");
    }

    public void setOneVersion(int i) {
        this.versions[i] = true;
    }

    public void setVersionRange(int low, int high) {
        for (int i = low; i <= high; ++i) {
            this.versions[i] = true;
        }
    }

    public void setVersionRange(String lowVersionID, String highVersionID) {
        if (lowVersionID != null) {
            if (highVersionID != null) {
                this.setVersionRange(Integer.parseInt(lowVersionID), Integer.parseInt(highVersionID));
            } else {
                this.setOneVersion(Integer.parseInt(lowVersionID));
            }
        } else if (highVersionID != null) {
            this.setOneVersion(Integer.parseInt(highVersionID));
        }
    }

    public boolean isVersion(int i) {
        return this.versions[i];
    }

    public boolean[] getVersions() {
        return Arrays.copyOf(this.versions, this.versions.length);
    }

    @Nonnull
    public String getVersionsAsString() {
        String part;
        Object ret = "";
        int partStart = -1;
        for (int i = 0; i < 256; ++i) {
            if (partStart >= 0) {
                if (this.versions[i]) continue;
                part = i - partStart > 1 ? partStart + "-" + (i - 1) : "" + (i - 1);
                ret = ((String)ret).isEmpty() ? part : "," + (String)part;
                partStart = -1;
                continue;
            }
            if (!this.versions[i]) continue;
            partStart = i;
        }
        if (partStart >= 0) {
            part = partStart != 255 ? partStart + "-255" : "" + partStart;
            ret = ((String)ret).isEmpty() ? (String)ret + "," + part : part;
        }
        return ret;
    }

    public String getMfg() {
        return this._mfg;
    }

    public String getMfgID() {
        return this._mfgID;
    }

    public String getDeveloperID() {
        return this._developerID;
    }

    public String getManufacturerID() {
        return this._manufacturerID;
    }

    public String getModel() {
        return this._model;
    }

    public String getFamily() {
        return this._family;
    }

    public String getReplacementModel() {
        return this._replacementModel;
    }

    public String getReplacementFamily() {
        return this._replacementFamily;
    }

    public String getFileName() {
        return this._filename;
    }

    public int getNumFunctions() {
        return this._numFns;
    }

    public int getNumOutputs() {
        return this._numOuts;
    }

    public Showable getShowable() {
        if (this._element.getAttribute("show") == null) {
            return Showable.YES;
        }
        if (this._element.getAttributeValue("show").equals("no")) {
            return Showable.NO;
        }
        if (this._element.getAttributeValue("show").equals("maybe")) {
            return Showable.MAYBE;
        }
        log.error("unexpected value for show attribute: {}", (Object)this._element.getAttributeValue("show"));
        return Showable.YES;
    }

    public String getModelComment() {
        return this._element.getAttributeValue("comment");
    }

    public String getFamilyComment() {
        return ((Element)this._element.getParent()).getAttributeValue("comment");
    }

    public String getProductID() {
        this._productID = this._element.getAttributeValue("productID");
        return this._productID;
    }

    public Element getModelElement() {
        return this._element;
    }

    public LocoAddress.Protocol[] getSupportedProtocols() {
        if (this.protocols == null) {
            this.setSupportedProtocols();
        }
        return this.protocols.toArray(new LocoAddress.Protocol[0]);
    }

    private void setSupportedProtocols() {
        this.protocols = new ArrayList();
        if (this._element.getChild("protocols") != null) {
            List protocolList = this._element.getChild("protocols").getChildren("protocol");
            protocolList.forEach(e -> this.protocols.add(LocoAddress.Protocol.getByShortName(e.getText())));
        }
    }

    @Nonnull
    public String getProgrammingModes() {
        if (this._programmingModes == null) {
            this._programmingModes = "";
        }
        return this._programmingModes;
    }

    public boolean isProgrammingMode(String mode) {
        return this.getProgrammingModes().contains(mode);
    }

    public static String getMfgName(Element decoderElement) {
        return decoderElement.getChild("family").getAttribute("mfg").getValue();
    }

    public static String getProgrammingModes(Element decoderElement) {
        return decoderElement.getChild("programming").getChild("mode").getText();
    }

    boolean isProductIDok(Element e, String extraInclude, String extraExclude) {
        return DecoderFile.isIncluded(e, this._productID, this._model, this._family, extraInclude, extraExclude);
    }

    public static boolean isIncluded(Element e, String productID, String modelID, String familyID, String extraInclude, String extraExclude) {
        Object include = e.getAttributeValue("include");
        include = include != null ? (String)include + "," + extraInclude : extraInclude;
        if (!(((String)include).isEmpty() || DecoderFile.isInList(productID, (String)include) || DecoderFile.isInList(modelID, (String)include) || DecoderFile.isInList(familyID, (String)include))) {
            if (log.isTraceEnabled()) {
                log.trace("include not in list of OK values: /{}/ /{}/ /{}/", new Object[]{include, productID, modelID});
            }
            return false;
        }
        Object exclude = e.getAttributeValue("exclude");
        exclude = exclude != null ? (String)exclude + "," + extraExclude : extraExclude;
        if (!((String)exclude).isEmpty() && (DecoderFile.isInList(productID, (String)exclude) || DecoderFile.isInList(modelID, (String)exclude) || DecoderFile.isInList(familyID, (String)exclude))) {
            if (log.isTraceEnabled()) {
                log.trace("exclude match: /{}/ /{}/ /{}/", new Object[]{exclude, productID, modelID});
            }
            return false;
        }
        return true;
    }

    private static boolean isInList(String checkFor, String okList) {
        String[] testList;
        String test = "," + okList + ",";
        if (test.contains("," + checkFor + ",")) {
            return true;
        }
        if (checkFor != null && (testList = checkFor.split(",")).length > 1) {
            for (String item : testList) {
                if (!test.contains("," + item + ",")) continue;
                return true;
            }
        }
        return false;
    }

    public void loadVariableModel(Element decoderElement, VariableTableModel variableModel) {
        this.nextCvStoreIndex = 0;
        this.processVariablesElement(decoderElement.getChild("variables"), variableModel, "", "");
        variableModel.configDone();
    }

    public void processVariablesElement(Element variablesElement, VariableTableModel variableModel, String extraInclude, String extraExclude) {
        extraInclude = (String)extraInclude + (String)(variablesElement.getAttributeValue("include") != null ? "," + variablesElement.getAttributeValue("include") : "");
        extraExclude = (String)extraExclude + (String)(variablesElement.getAttributeValue("exclude") != null ? "," + variablesElement.getAttributeValue("exclude") : "");
        log.debug("extraInclude /{}/, extraExclude /{}/", extraInclude, extraExclude);
        for (Element e : variablesElement.getChildren("variable")) {
            try {
                if (this.getNumFunctions() >= 0 && e.getAttribute("minFn") != null && this.getNumFunctions() < e.getAttribute("minFn").getIntValue() || this.getNumOutputs() >= 0 && e.getAttribute("minOut") != null && this.getNumOutputs() < Integer.parseInt(e.getAttribute("minOut").getValue()) || !this.isProductIDok(e, (String)extraInclude, (String)extraExclude)) {
                    continue;
                }
            }
            catch (NumberFormatException | DataConversionException ex) {
                log.warn("Problem parsing minFn or minOut in decoder file, variable {} exception", (Object)e.getAttribute("item"), (Object)ex);
            }
            variableModel.setRow(this.nextCvStoreIndex++, e, this._element == null ? null : this);
        }
        for (Element e : variablesElement.getChildren("constant")) {
            try {
                if (this.getNumFunctions() >= 0 && e.getAttribute("minFn") != null && this.getNumFunctions() < e.getAttribute("minFn").getIntValue() || this.getNumOutputs() >= 0 && e.getAttribute("minOut") != null && this.getNumOutputs() < e.getAttribute("minOut").getIntValue() || !this.isProductIDok(e, (String)extraInclude, (String)extraExclude)) {
                    continue;
                }
            }
            catch (DataConversionException ex) {
                log.warn("Problem parsing minFn or minOut in decoder file, variable {} exception", (Object)e.getAttribute("item"), (Object)ex);
            }
            variableModel.setConstant(e);
        }
        for (Element e : variablesElement.getChildren("variables")) {
            this.processVariablesElement(e, variableModel, (String)extraInclude, (String)extraExclude);
        }
    }

    public void loadResetModel(Element decoderElement, ResetTableModel resetModel) {
        if (decoderElement.getChild("resets") != null) {
            List resetList = decoderElement.getChild("resets").getChildren("factReset");
            for (int i = 0; i < resetList.size(); ++i) {
                Element e = (Element)resetList.get(i);
                resetModel.setRow(i, e, decoderElement.getChild("resets"), this._model);
            }
        }
    }

    public void loadExtraMenuModel(Element decoderElement, ArrayList<ExtraMenuTableModel> extraMenuModelList, JLabel progStatus, Programmer mProgrammer) {
        List menus = decoderElement.getChildren("extraMenu");
        log.trace("loadExtraMenuModel {} {}", (Object)menus.size(), extraMenuModelList);
        int i = 0;
        for (Element menuElement : menus) {
            if (i >= extraMenuModelList.size() || extraMenuModelList.get(i) == null) {
                log.trace("Add element {} in array of size {}", (Object)i, (Object)extraMenuModelList.size());
                ExtraMenuTableModel model = new ExtraMenuTableModel(progStatus, mProgrammer);
                model.setName(menuElement.getAttributeValue("name", "Extra"));
                extraMenuModelList.add(i, model);
            }
            List itemList = menuElement.getChildren("extraMenuItem");
            ExtraMenuTableModel extraMenuModel = extraMenuModelList.get(i);
            for (int j = 0; j < itemList.size(); ++j) {
                Element e = (Element)itemList.get(j);
                extraMenuModel.setRow(j, e, menuElement, this._model);
            }
            ++i;
        }
    }

    public String titleString() {
        return DecoderFile.titleString(this.getModel(), this.getFamily());
    }

    public static String titleString(String model, String family) {
        return model + " (" + family + ")";
    }

    public static enum Showable {
        YES,
        NO,
        MAYBE;

    }
}

