/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.decoderdefn;

import java.awt.Component;
import java.awt.GraphicsEnvironment;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import jmri.InstanceManager;
import jmri.implementation.AbstractInstanceInitializer;
import jmri.jmrit.XmlFile;
import jmri.jmrit.decoderdefn.Bundle;
import jmri.jmrit.decoderdefn.DecoderFile;
import jmri.util.FileUtil;
import jmri.util.ThreadingUtil;
import org.jdom2.Attribute;
import org.jdom2.Comment;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.Namespace;
import org.jdom2.ProcessingInstruction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DecoderIndexFile
extends XmlFile {
    public static final String MANUFACTURER = "manufacturer";
    public static final String MFG_ID = "mfgID";
    public static final String DECODER_INDEX = "decoderIndex";
    public static final String VERSION = "version";
    public static final String LOW_VERSION_ID = "lowVersionID";
    public static final String HIGH_VERSION_ID = "highVersionID";
    protected List<DecoderFile> decoderList = new ArrayList<DecoderFile>();
    int fileVersion = -1;
    protected HashMap<String, String> _mfgIdFromNameHash = new HashMap();
    protected HashMap<String, String> _mfgNameFromIdHash = new HashMap();
    protected ArrayList<String> mMfgNameList = new ArrayList();
    String nmraListDate = null;
    String updated = null;
    String lastAdd = null;
    protected static final String DECODER_INDEX_FILE_NAME = "decoderIndex.xml";
    private static final Logger log = LoggerFactory.getLogger(DecoderIndexFile.class);

    public int numDecoders() {
        return this.decoderList.size();
    }

    public List<String> getMfgNameList() {
        return this.mMfgNameList;
    }

    public String mfgIdFromName(String name) {
        return this._mfgIdFromNameHash.get(name);
    }

    public String mfgNameFromID(String idNum) {
        return this._mfgNameFromIdHash.get(idNum);
    }

    @Nonnull
    public List<DecoderFile> matchingDecoderList(String progMode) {
        return this.matchingDecoderList(null, null, null, null, null, null, null, null, null, progMode);
    }

    @Nonnull
    public List<DecoderFile> matchingDecoderList(String mfg, String family, String decoderMfgID, String decoderVersionID, String decoderProductID, String model) {
        return this.matchingDecoderList(mfg, family, decoderMfgID, decoderVersionID, decoderProductID, model, null, null, null, null);
    }

    @Nonnull
    public List<DecoderFile> matchingDecoderList(String mfg, String family, String decoderMfgID, String decoderVersionID, String decoderProductID, String model, String developerID, String manufacturerID, String productID) {
        return this.matchingDecoderList(mfg, family, decoderMfgID, decoderVersionID, decoderProductID, model, null, null, null, null);
    }

    @Nonnull
    public List<DecoderFile> matchingDecoderList(String mfg, String family, String decoderMfgID, String decoderVersionID, String decoderProductID, String model, String developerID, String manufacturerID, String productID, String progMode) {
        ArrayList<DecoderFile> l = new ArrayList<DecoderFile>();
        for (int i = 0; i < this.numDecoders(); ++i) {
            if (!this.checkEntry(i, mfg, family, decoderMfgID, decoderVersionID, decoderProductID, model, developerID, manufacturerID, productID, progMode)) continue;
            l.add(this.decoderList.get(i));
        }
        return l;
    }

    public JComboBox<String> matchingComboBox(String mfg, String family, String decoderMfgID, String decoderVersionID, String decoderProductID, String model) {
        List<DecoderFile> l = this.matchingDecoderList(mfg, family, decoderMfgID, decoderVersionID, decoderProductID, model);
        return DecoderIndexFile.jComboBoxFromList(l);
    }

    public static JComboBox<String> jComboBoxFromList(List<DecoderFile> l) {
        return new JComboBox<String>(DecoderIndexFile.jComboBoxModelFromList(l));
    }

    public static ComboBoxModel<String> jComboBoxModelFromList(List<DecoderFile> l) {
        DefaultComboBoxModel<String> b = new DefaultComboBoxModel<String>();
        for (DecoderFile r : l) {
            b.addElement(r.titleString());
        }
        return b;
    }

    public DecoderFile fileFromTitle(String title) {
        for (int i = this.numDecoders() - 1; i >= 0; --i) {
            DecoderFile r = this.decoderList.get(i);
            if (!r.titleString().equals(title)) continue;
            return r;
        }
        return null;
    }

    public boolean checkEntry(int i, String mfgName, String family, String mfgID, String decoderVersionID, String decoderProductID, String model, String developerID, String manufacturerID, String productID, String progMode) {
        int versionID;
        DecoderFile r = this.decoderList.get(i);
        if (mfgName != null && !mfgName.equals(r.getMfg())) {
            return false;
        }
        if (family != null && !family.equals(r.getFamily())) {
            return false;
        }
        if (mfgID != null && !mfgID.equals(r.getMfgID())) {
            return false;
        }
        if (model != null && !model.equals(r.getModel())) {
            return false;
        }
        if (decoderVersionID != null && !r.isVersion(versionID = Integer.parseInt(decoderVersionID))) {
            return false;
        }
        if (decoderProductID != null && !this.checkInCommaDelimString(decoderProductID, r.getProductID())) {
            return false;
        }
        if (developerID != null) {
            if (!developerID.equals(r.getDeveloperID())) {
                if (r.getModelElement().getAttribute("developerID") == null) {
                    return false;
                }
                if (!("," + r.getModelElement().getAttribute("developerID").getValue() + ",").contains("," + developerID + ",")) {
                    return false;
                }
            }
            log.debug("developerID match");
        }
        if (manufacturerID != null) {
            Attribute a;
            log.debug("checking manufactureriD {}, mfgID {}, modelElement[manufacturerID] {}", new Object[]{manufacturerID, r._mfgID, r.getModelElement().getAttribute("manufacturerID")});
            if (!(r._mfgID != null && manufacturerID.compareTo(r._mfgID) == 0 || manufacturerID.equals(r.getManufacturerID()) || (a = r.getModelElement().getAttribute("manufacturerID")) != null && a.getValue() != null && manufacturerID.compareTo(a.getValue()) == 0)) {
                return false;
            }
            log.debug("manufacturerID match");
        }
        if (productID != null) {
            if (!productID.equals(r.getProductID())) {
                if (r.getModelElement().getAttribute("productID") == null) {
                    return false;
                }
                if (!("," + r.getModelElement().getAttribute("productID").getValue() + ",").contains("," + productID + ",")) {
                    return false;
                }
            }
            log.debug("productID match");
        }
        if (progMode != null) {
            return r.isProgrammingMode(progMode);
        }
        return true;
    }

    public static synchronized void resetInstance() {
        InstanceManager.getDefault().clear(DecoderIndexFile.class);
    }

    public static boolean updateIndexIfNeeded() throws JDOMException, IOException {
        switch (FileUtil.findFiles(DecoderIndexFile.defaultDecoderIndexFilename(), ".").size()) {
            case 0: {
                log.debug("creating decoder index");
                DecoderIndexFile.forceCreationOfNewIndex();
                return true;
            }
            case 1: {
                return false;
            }
        }
        String masterVersion = null;
        DecoderIndexFile masterXmlFile = new DecoderIndexFile();
        URL masterFile = FileUtil.findURL("xml/" + DecoderIndexFile.defaultDecoderIndexFilename(), FileUtil.Location.INSTALLED);
        if (masterFile == null) {
            return false;
        }
        log.debug("checking for master file at {}", (Object)masterFile);
        Element masterRoot = masterXmlFile.rootFromURL(masterFile);
        if (masterRoot.getChild(DECODER_INDEX) != null) {
            if (masterRoot.getChild(DECODER_INDEX).getAttribute(VERSION) != null) {
                masterVersion = masterRoot.getChild(DECODER_INDEX).getAttribute(VERSION).getValue();
            }
        } else {
            return false;
        }
        log.debug("master version found, is {}", masterVersion);
        String userVersion = null;
        DecoderIndexFile userXmlFile = new DecoderIndexFile();
        log.debug("checking for user file at {}", (Object)DecoderIndexFile.defaultDecoderIndexFilename());
        Element userRoot = userXmlFile.rootFromName(DecoderIndexFile.defaultDecoderIndexFilename());
        if (userRoot.getChild(DECODER_INDEX) != null) {
            if (userRoot.getChild(DECODER_INDEX).getAttribute(VERSION) != null) {
                userVersion = userRoot.getChild(DECODER_INDEX).getAttribute(VERSION).getValue();
            }
            log.debug("user version found, is {}", userVersion);
        }
        if (masterVersion != null && masterVersion.equals(userVersion)) {
            return false;
        }
        log.debug("forcing update of decoder index due to {} and {}", (Object)masterVersion, userVersion);
        DecoderIndexFile.forceCreationOfNewIndex();
        return true;
    }

    public static void forceCreationOfNewIndex() {
        DecoderIndexFile.forceCreationOfNewIndex(false);
    }

    public static void forceCreationOfNewIndex(boolean increment) {
        log.info("update decoder index");
        File oldfile = new File(FileUtil.getUserFilesPath() + DECODER_INDEX_FILE_NAME);
        if (oldfile.exists()) {
            log.debug("remove existing user decoderIndex.xml file");
            if (!oldfile.delete()) {
                log.error("Failed to delete old index file");
            }
            DecoderIndexFile.resetInstance();
        }
        ArrayList<String> al = new ArrayList<String>();
        FileUtil.createDirectory(FileUtil.getUserFilesPath() + DecoderFile.fileLocation);
        File fp = new File(FileUtil.getUserFilesPath() + DecoderFile.fileLocation);
        if (fp.exists()) {
            String[] list = fp.list();
            if (list != null) {
                for (String sp : list) {
                    if (!sp.endsWith(".xml") && !sp.endsWith(".XML")) continue;
                    al.add(sp);
                }
            }
        } else {
            log.debug("{}decoders was missing, though tried to create it", (Object)FileUtil.getUserFilesPath());
        }
        String[] fileList = new File(XmlFile.xmlDir() + DecoderFile.fileLocation).list();
        if (fileList != null) {
            for (String sx : fileList) {
                if (!sx.endsWith(".xml") && !sx.endsWith(".XML") || al.contains(sx)) continue;
                al.add(sx);
            }
        } else {
            log.error("Could not access decoder definition directory {}{}", (Object)XmlFile.xmlDir(), (Object)DecoderFile.fileLocation);
        }
        Object[] sbox = al.toArray(new String[0]);
        Arrays.sort(sbox);
        DecoderIndexFile index = new DecoderIndexFile();
        index.fileVersion = increment ? InstanceManager.getDefault(DecoderIndexFile.class).fileVersion + 2 : InstanceManager.getDefault(DecoderIndexFile.class).fileVersion;
        if (sbox.length < 30 || GraphicsEnvironment.isHeadless() || !ThreadingUtil.isGUIThread()) {
            try {
                index.writeFile(DECODER_INDEX_FILE_NAME, InstanceManager.getDefault(DecoderIndexFile.class), (String[])sbox, null, null);
            }
            catch (IOException ex) {
                log.error("Error writing new decoder index file: {}", (Object)ex.getMessage());
            }
            return;
        }
        String message = Bundle.getMessage("DecoderProgressMessage", "...");
        String title = Bundle.getMessage("DecoderProgressMessage", "");
        String cancel = Bundle.getMessage("ButtonCancel");
        JOptionPane pane = new JOptionPane(message + "                            \t", -1, 2, null, new String[]{cancel});
        JProgressBar pb = new JProgressBar(0, sbox.length);
        pb.setValue(0);
        pane.add((Component)pb, 1);
        JDialog dialog = pane.createDialog(null, title);
        ThreadingUtil.newThread(() -> DecoderIndexFile.lambda$forceCreationOfNewIndex$0(index, (String[])sbox, pane, pb, dialog), "decoderIndexer").start();
        dialog.setAlwaysOnTop(true);
        dialog.toFront();
        dialog.setVisible(true);
    }

    void readFile(String name) throws JDOMException, IOException {
        log.debug("readFile {}", (Object)name);
        Element root = this.rootFromName(name);
        if (root.getChild(DECODER_INDEX) != null) {
            if (root.getChild(DECODER_INDEX).getAttribute(VERSION) != null) {
                this.fileVersion = Integer.parseInt(root.getChild(DECODER_INDEX).getAttribute(VERSION).getValue());
            }
            log.debug("found fileVersion of {}", (Object)this.fileVersion);
            this.readMfgSection();
            this.readFamilySection(root.getChild(DECODER_INDEX));
        } else {
            log.error("Unrecognized decoderIndex file contents in file: {}", (Object)name);
        }
    }

    void readMfgSection() throws JDOMException, IOException {
        Element mfgList = this.rootFromName("nmra_mfg_list.xml");
        if (mfgList != null) {
            Attribute a = mfgList.getAttribute("nmraListDate");
            if (a != null) {
                this.nmraListDate = a.getValue();
            }
            if ((a = mfgList.getAttribute("updated")) != null) {
                this.updated = a.getValue();
            }
            if ((a = mfgList.getAttribute("lastadd")) != null) {
                this.lastAdd = a.getValue();
            }
            List l = mfgList.getChildren(MANUFACTURER);
            log.debug("readMfgSection sees {} children", (Object)l.size());
            for (Element el : l) {
                String mfg = el.getAttribute("mfg").getValue();
                this.mMfgNameList.add(mfg);
                Attribute attr = el.getAttribute(MFG_ID);
                if (attr == null) continue;
                this._mfgIdFromNameHash.put(mfg, attr.getValue());
                this._mfgNameFromIdHash.put(attr.getValue(), mfg);
            }
        } else {
            log.debug("no mfgList found");
        }
    }

    void readFamilySection(Element decoderIndex) {
        Element familyList = decoderIndex.getChild("familyList");
        if (familyList != null) {
            List l = familyList.getChildren("family");
            log.trace("readFamilySection sees {} children", (Object)l.size());
            for (Element el : l) {
                this.readFamily(el);
            }
        } else {
            log.debug("no familyList found in decoderIndexFile");
        }
    }

    void readFamily(Element family) {
        Element modelElement;
        String filename = family.getAttribute("file").getValue();
        Attribute attr = family.getAttribute(LOW_VERSION_ID);
        String parentLowVersID = attr != null ? attr.getValue() : null;
        attr = family.getAttribute(HIGH_VERSION_ID);
        String parentHighVersID = attr != null ? attr.getValue() : null;
        attr = family.getAttribute("replacementFamily");
        String ParentReplacementFamilyName = attr != null ? attr.getValue() : null;
        attr = family.getAttribute("name");
        String familyName = attr != null ? attr.getValue() : null;
        attr = family.getAttribute("mfg");
        String mfg = attr != null ? attr.getValue() : null;
        attr = family.getAttribute("developerID");
        String developerID = attr != null ? attr.getValue() : null;
        attr = family.getAttribute("manufacturerID");
        String manufacturerID = attr != null ? attr.getValue() : null;
        attr = family.getAttribute("productID");
        String productID = attr != null ? attr.getValue() : null;
        String mfgID = null;
        if (mfg != null) {
            mfgID = this.mfgIdFromName(mfg);
        } else {
            log.error("Did not find required mfg attribute, may not find proper manufacturer");
        }
        attr = family.getAttribute("modes");
        String modes = attr != null ? attr.getValue() : null;
        List l = family.getChildren("model");
        log.trace("readFamily sees {} children", (Object)l.size());
        if (l.isEmpty()) {
            log.error("Did not find at least one model in the {} family", (Object)familyName);
            modelElement = null;
        } else {
            modelElement = (Element)l.get(0);
        }
        DecoderFile vFamilyDecoderFile = new DecoderFile(mfg, mfgID, familyName, parentLowVersID, parentHighVersID, familyName, filename, developerID != null ? developerID : "-1", manufacturerID != null ? manufacturerID : "-1", productID != null ? productID : "-1", -1, -1, modelElement, ParentReplacementFamilyName, ParentReplacementFamilyName, modes);
        this.decoderList.add(vFamilyDecoderFile);
        for (Element decoder : l) {
            attr = decoder.getAttribute(LOW_VERSION_ID);
            String loVersID = attr != null ? attr.getValue() : parentLowVersID;
            attr = decoder.getAttribute(HIGH_VERSION_ID);
            String hiVersID = attr != null ? attr.getValue() : parentHighVersID;
            attr = decoder.getAttribute("replacementModel");
            String replacementModelName = attr != null ? attr.getValue() : null;
            attr = decoder.getAttribute("replacementFamily");
            String replacementFamilyName = attr != null ? attr.getValue() : ParentReplacementFamilyName;
            attr = decoder.getAttribute("numFns");
            int numFns = attr != null ? Integer.parseInt(attr.getValue()) : -1;
            attr = decoder.getAttribute("numOuts");
            int numOuts = attr != null ? Integer.parseInt(attr.getValue()) : -1;
            attr = decoder.getAttribute("developerID");
            String devId = attr != null ? attr.getValue() : "-1";
            attr = decoder.getAttribute("manufacturerID");
            String manufId = attr != null ? attr.getValue() : "-1";
            attr = decoder.getAttribute("productID");
            String prodId = attr != null ? attr.getValue() : "-1";
            attr = decoder.getAttribute("model");
            DecoderFile df = new DecoderFile(mfg, mfgID, attr != null ? attr.getValue() : null, loVersID, hiVersID, familyName, filename, devId, manufId, prodId, numFns, numOuts, decoder, replacementModelName, replacementFamilyName, modes);
            this.decoderList.add(df);
            List vcodes = decoder.getChildren("versionCV");
            for (Element vcv : vcodes) {
                attr = vcv.getAttribute(LOW_VERSION_ID);
                String vLoVersID = attr != null ? attr.getValue() : loVersID;
                attr = vcv.getAttribute(HIGH_VERSION_ID);
                String vHiVersID = attr != null ? attr.getValue() : hiVersID;
                df.setVersionRange(vLoVersID, vHiVersID);
            }
        }
    }

    public boolean checkInCommaDelimString(String findString, String inString) {
        String bracketedFindString = "," + findString + ",";
        String bracketedInString = "," + inString + ",";
        return bracketedInString.contains(bracketedFindString);
    }

    /*
     * WARNING - void declaration
     */
    public void writeFile(String name, DecoderIndexFile oldIndex, String[] files, JOptionPane pane, JProgressBar pb) throws IOException {
        log.debug("writeFile {}", (Object)name);
        File file = new File(FileUtil.getUserFilesPath() + name);
        Element root = new Element("decoderIndex-config");
        root.setAttribute("noNamespaceSchemaLocation", "http://jmri.org/xml/schema/decoder-4-15-2.xsd", Namespace.getNamespace((String)"xsi", (String)"http://www.w3.org/2001/XMLSchema-instance"));
        Document doc = DecoderIndexFile.newDocument(root);
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("type", "text/xsl");
        m.put("href", "/xml/XSLT/DecoderID.xsl");
        ProcessingInstruction p = new ProcessingInstruction("xml-stylesheet", m);
        doc.addContent(0, (Content)p);
        Element index = new Element(DECODER_INDEX);
        root.addContent((Content)index);
        index.setAttribute(VERSION, Integer.toString(this.fileVersion));
        log.debug("version written to file as {}", (Object)this.fileVersion);
        Element mfgList = new Element("mfgList");
        if (oldIndex.nmraListDate != null) {
            mfgList.setAttribute("nmraListDate", oldIndex.nmraListDate);
        }
        if (oldIndex.updated != null) {
            mfgList.setAttribute("updated", oldIndex.updated);
        }
        if (oldIndex.lastAdd != null) {
            mfgList.setAttribute("lastadd", oldIndex.lastAdd);
        }
        Element mfg = new Element(MANUFACTURER);
        mfg.setAttribute("mfg", "NMRA");
        mfg.setAttribute(MFG_ID, "999");
        mfgList.addContent((Content)mfg);
        ArrayList<String> keys = new ArrayList<String>(oldIndex._mfgIdFromNameHash.keySet());
        Collections.sort(keys);
        for (Object e : keys) {
            String[] mfgName = (String[])e;
            if (mfgName.equals("NMRA")) continue;
            mfg = new Element(MANUFACTURER);
            mfg.setAttribute("mfg", (String)mfgName);
            mfg.setAttribute(MFG_ID, oldIndex._mfgIdFromNameHash.get(mfgName));
            mfgList.addContent((Content)mfg);
        }
        Element familyList = new Element("familyList");
        boolean bl = false;
        for (String fileName : files) {
            if (pb != null) {
                void var16_18;
                pb.setValue((int)(++var16_18));
            }
            if (pane != null && pane.getValue() != JOptionPane.UNINITIALIZED_VALUE) {
                log.info("Decoder index recreation cancelled");
                return;
            }
            DecoderFile d = new DecoderFile();
            try {
                List modes;
                Element droot = d.rootFromName(DecoderFile.fileLocation + fileName);
                Element family = droot.getChild("decoder").getChild("family").clone();
                Element prog = droot.getChild("decoder").getChild("programming");
                if (prog != null && (modes = prog.getChildren("mode")) != null) {
                    StringBuilder supportedModes = new StringBuilder();
                    for (Element md : modes) {
                        String modeName = md.getText();
                        if (supportedModes.length() > 0) {
                            supportedModes.append(",");
                        }
                        supportedModes.append(modeName);
                    }
                    if (supportedModes.length() > 0) {
                        family.setAttribute("modes", supportedModes.toString());
                    }
                }
                family.setAttribute("file", fileName);
                for (Element element : family.getChildren()) {
                    element.removeAttribute("maxInputVolts");
                    element.removeAttribute("maxMotorCurrent");
                    element.removeAttribute("maxTotalCurrent");
                    element.removeAttribute("formFactor");
                    element.removeAttribute("connector");
                    element.removeAttribute("nmraWarrant");
                    element.removeAttribute("nmraWarrantStart");
                    element.removeChildren("size");
                    for (Element output : element.getChildren()) {
                        output.removeAttribute("connection");
                        output.removeAttribute("maxcurrent");
                        output.removeChildren("label");
                    }
                }
                familyList.addContent((Content)family);
            }
            catch (JDOMException exj) {
                log.error("could not parse {}: {}", (Object)fileName, (Object)exj.getMessage());
            }
            catch (FileNotFoundException exj) {
                log.error("could not read {}: {}", (Object)fileName, (Object)exj.getMessage());
            }
            catch (IOException exj) {
                log.error("other exception while dealing with {}: {}", (Object)fileName, (Object)exj.getMessage());
            }
        }
        index.addContent((Content)new Comment("The manufacturer list is from the nmra_mfg_list.xml file"));
        index.addContent((Content)mfgList);
        index.addContent((Content)familyList);
        log.debug("Writing decoderIndex");
        try {
            this.writeXML(file, doc);
        }
        catch (Exception e) {
            log.error("Error writing file: {}", (Object)file, (Object)e);
        }
        DecoderIndexFile.resetInstance();
    }

    protected static String defaultDecoderIndexFilename() {
        return DECODER_INDEX_FILE_NAME;
    }

    private static /* synthetic */ void lambda$forceCreationOfNewIndex$0(DecoderIndexFile index, String[] sbox, JOptionPane pane, JProgressBar pb, JDialog dialog) {
        try {
            index.writeFile(DECODER_INDEX_FILE_NAME, InstanceManager.getDefault(DecoderIndexFile.class), sbox, pane, pb);
        }
        catch (IOException e) {
            log.error("Error writing new decoder index file: {}", (Object)e.getMessage());
        }
        dialog.setVisible(false);
        dialog.dispose();
    }

    public static class Initializer
    extends AbstractInstanceInitializer {
        @Override
        @Nonnull
        public <T> Object getDefault(Class<T> type) {
            if (type.equals(DecoderIndexFile.class)) {
                DecoderIndexFile instance = new DecoderIndexFile();
                log.debug("DecoderIndexFile creating instance");
                try {
                    instance.readFile(DecoderIndexFile.defaultDecoderIndexFilename());
                }
                catch (IOException | JDOMException e) {
                    log.error("Exception during decoder index reading: ", e);
                }
                try {
                    if (DecoderIndexFile.updateIndexIfNeeded()) {
                        try {
                            instance = new DecoderIndexFile();
                            instance.readFile(DecoderIndexFile.defaultDecoderIndexFilename());
                        }
                        catch (IOException | JDOMException e) {
                            log.error("Exception during decoder index reload: ", e);
                        }
                    }
                }
                catch (IOException | JDOMException e) {
                    log.error("Exception during decoder index update: ", e);
                }
                log.debug("DecoderIndexFile returns instance {}", (Object)instance);
                return instance;
            }
            return super.getDefault(type);
        }

        @Override
        @Nonnull
        public Set<Class<?>> getInitalizes() {
            Set<Class<?>> set = super.getInitalizes();
            set.add(DecoderIndexFile.class);
            return set;
        }
    }
}

