/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.decoderdefn;

import jmri.Programmer;
import jmri.jmrit.AbstractIdentify;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class IdentifyDecoder
extends AbstractIdentify {
    Manufacturer mfgID = null;
    int intMfg = -1;
    int modelID = -1;
    int productIDhigh = -1;
    int productIDlow = -1;
    int productIDhighest = -1;
    int productIDlowest = -1;
    int productID = -1;
    private static final Logger log = LoggerFactory.getLogger(IdentifyDecoder.class);

    public IdentifyDecoder(Programmer programmer) {
        super(programmer);
    }

    @Override
    public boolean test1() {
        this.statusUpdate("Read MFG ID - CV 8");
        this.readCV("8");
        return false;
    }

    @Override
    public boolean test2(int value) {
        this.mfgID = Manufacturer.forValue(value);
        this.intMfg = value;
        this.statusUpdate("Read MFG version - CV 7");
        this.readCV("7");
        return false;
    }

    @Override
    public boolean test3(int value) {
        this.modelID = value;
        if (this.mfgID == null) {
            return true;
        }
        switch (this.mfgID) {
            case QSI: {
                this.statusUpdate("Set PI for Read Product ID High Byte");
                this.writeCV("49", 254);
                return false;
            }
            case TCS: {
                this.statusUpdate("Read decoder ID CV 249");
                this.readCV("249");
                return false;
            }
            case HORNBY: {
                if (this.modelID == 254) {
                    this.statusUpdate("Read Product ID High Byte CV 200");
                    this.readCV("200");
                    return false;
                }
                this.statusUpdate("Read optional decoder ID CV 159");
                this.setOptionalCv(true);
                this.readCV("159");
                return false;
            }
            case ZIMO: {
                this.statusUpdate("Read decoder ID CV 250");
                this.readCV("250");
                return false;
            }
            case SOUNDTRAXX: {
                if (this.modelID >= 70 && this.modelID <= 72) {
                    this.statusUpdate("Read productID high CV253");
                    this.readCV("253");
                    return false;
                }
                return true;
            }
            case HARMAN: {
                this.statusUpdate("Read decoder ID high CV 112");
                this.readCV("112");
                return false;
            }
            case ESU: {
                if (this.modelID == 255) {
                    this.statusUpdate("Set PI for Read productID");
                    this.writeCV("31", 0);
                    return false;
                }
                return true;
            }
            case DIY: {
                this.statusUpdate("Read decoder product ID #1 CV 47");
                this.readCV("47");
                return false;
            }
            case DOEHLER: {
                this.statusUpdate("Read optional decoder ID CV 261");
                this.setOptionalCv(true);
                this.readCV("261");
                return false;
            }
            case TRAINOMATIC: {
                this.statusUpdate("Read productID #1 CV 510");
                this.readCV("510");
                return false;
            }
            case DIETZ: {
                this.statusUpdate("Read productID CV 128");
                this.readCV("128");
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean test4(int value) {
        switch (this.mfgID) {
            case QSI: {
                this.statusUpdate("Set SI for Read Product ID High Byte");
                this.writeCV("50", 4);
                return false;
            }
            case TCS: {
                if (value < 129) {
                    this.productID = value;
                    return true;
                }
                this.productIDlowest = value;
                this.statusUpdate("Read decoder sound version number");
                this.readCV("248");
                return false;
            }
            case HORNBY: {
                if (this.modelID == 254) {
                    this.productIDhigh = value;
                    this.statusUpdate("ProductID High - " + this.productIDhigh + " - reading CV201");
                    this.readCV("201");
                    return false;
                }
                if (this.isOptionalCv()) {
                    return true;
                }
                if (value == 143) {
                    this.productIDlow = value;
                    this.statusUpdate("Read Product ID High Byte");
                    this.readCV("158");
                    return false;
                }
                this.productID = value;
                return true;
            }
            case ZIMO: {
                this.productID = value;
                return true;
            }
            case SOUNDTRAXX: {
                if (this.modelID >= 70 && this.modelID <= 72) {
                    this.productIDhighest = value;
                    this.statusUpdate("Read decoder productID low CV256");
                    this.readCV("256");
                    return false;
                }
                return true;
            }
            case HARMAN: {
                this.productIDhigh = value;
                this.statusUpdate("Read decoder ID low CV 113");
                this.readCV("113");
                return false;
            }
            case ESU: {
                this.statusUpdate("Set SI for Read productID");
                this.writeCV("32", 255);
                return false;
            }
            case DIY: {
                this.productIDhighest = value;
                this.statusUpdate("Read decoder product ID #2 CV 48");
                this.readCV("48");
                return false;
            }
            case DOEHLER: {
                if (this.isOptionalCv()) {
                    return true;
                }
                this.productID = value;
                return true;
            }
            case TRAINOMATIC: {
                this.productIDhigh = value;
                this.statusUpdate("Read productID #2 CV 509");
                this.readCV("509");
                return false;
            }
            case DIETZ: {
                this.productID = value;
                return true;
            }
        }
        log.error("unexpected step 4 reached with value: {}", (Object)value);
        return true;
    }

    @Override
    public boolean test5(int value) {
        switch (this.mfgID) {
            case QSI: {
                this.statusUpdate("Read Product ID High Byte");
                this.readCV("56");
                return false;
            }
            case HORNBY: {
                if (this.modelID == 254) {
                    this.productIDlow = value;
                    this.productID = this.productIDlow + this.productIDhigh * 256;
                    this.statusUpdate("ProductID is " + this.productID);
                    return true;
                }
                this.productIDhigh = value;
                this.productID = this.productIDhigh << 8 | this.productIDlow;
                return true;
            }
            case SOUNDTRAXX: {
                if (this.modelID >= 70 && this.modelID <= 72) {
                    this.productIDlow = value;
                    this.readCV("255");
                    return false;
                }
                return true;
            }
            case HARMAN: {
                this.productIDlow = value;
                this.productID = this.productIDhigh << 8 | this.productIDlow;
                return true;
            }
            case ESU: {
                this.statusUpdate("Read productID Byte 1");
                this.readCV("261");
                return false;
            }
            case DIY: {
                this.productIDhigh = value;
                this.statusUpdate("Read decoder product ID #3 CV 49");
                this.readCV("49");
                return false;
            }
            case TCS: {
                this.productIDlow = value;
                this.statusUpdate("Read decoder extended Version ID Low Byte");
                this.readCV("111");
                return false;
            }
            case TRAINOMATIC: {
                this.productIDlow = value;
                this.statusUpdate("Read productID #3 CV 508");
                this.readCV("508");
                return false;
            }
        }
        log.error("unexpected step 5 reached with value: {}", (Object)value);
        return true;
    }

    @Override
    public boolean test6(int value) {
        switch (this.mfgID) {
            case QSI: {
                this.productIDhigh = value;
                this.statusUpdate("Set SI for Read Product ID Low Byte");
                this.writeCV("50", 5);
                return false;
            }
            case HORNBY: {
                this.productID = value + this.productIDhigh * 256 + this.productIDhighest * 256 * 256;
                return true;
            }
            case ESU: {
                this.productID = value;
                this.statusUpdate("Read productID Byte 2");
                this.readCV("262");
                return false;
            }
            case DIY: {
                this.productIDlow = value;
                this.statusUpdate("Read decoder product ID #4 CV 50");
                this.readCV("50");
                return false;
            }
            case SOUNDTRAXX: {
                if (this.modelID >= 70 && this.modelID <= 72) {
                    this.productIDhigh = value;
                    this.productID = this.productIDlow | (this.productIDhigh & 7) << 8 | this.productIDhighest << 11;
                    return true;
                }
                return true;
            }
            case TCS: {
                this.productIDhigh = value;
                this.statusUpdate("Read decoder extended Version ID High Byte");
                this.readCV("110");
                return false;
            }
            case TRAINOMATIC: {
                this.productID = value + this.productIDlow * 256 + this.productIDhigh * 256 * 256;
                return true;
            }
        }
        log.error("unexpected step 6 reached with value: {}", (Object)value);
        return true;
    }

    @Override
    public boolean test7(int value) {
        switch (this.mfgID) {
            case QSI: {
                this.statusUpdate("Read Product ID Low Byte");
                this.readCV("56");
                return false;
            }
            case ESU: {
                this.productID += value * 256;
                this.statusUpdate("Read productID Byte 3");
                this.readCV("263");
                return false;
            }
            case DIY: {
                this.productIDlowest = value;
                this.productID = ((this.productIDhighest << 8 | this.productIDhigh) << 8 | this.productIDlow) << 8 | this.productIDlowest;
                return true;
            }
            case TCS: {
                this.productIDhighest = value;
                this.productID = this.productIDlowest >= 129 && this.productIDlowest <= 135 && this.productIDlow == 5 || this.modelID >= 5 ? (this.productIDlowest == 180 && this.modelID == 5 ? this.productIDlowest + this.productIDlow * 256 : this.productIDlowest + this.productIDlow * 256 + this.productIDhigh * 256 * 256 + this.productIDhighest * 256 * 256 * 256) : ((this.productIDlowest >= 129 && this.productIDlowest <= 135 || this.productIDlowest >= 170 && this.productIDlowest <= 172 || this.productIDlowest == 180) && this.modelID == 4 ? this.productIDlowest + this.productIDlow * 256 : this.productIDlowest);
                return true;
            }
        }
        log.error("unexpected step 7 reached with value: {}", (Object)value);
        return true;
    }

    @Override
    public boolean test8(int value) {
        switch (this.mfgID) {
            case QSI: {
                this.productIDlow = value;
                this.productID = this.productIDhigh * 256 + this.productIDlow;
                return true;
            }
            case ESU: {
                this.productID += value * 256 * 256;
                this.statusUpdate("Read productID Byte 4");
                this.readCV("264");
                return false;
            }
        }
        log.error("unexpected step 8 reached with value: {}", (Object)value);
        return true;
    }

    @Override
    public boolean test9(int value) {
        if (this.mfgID == Manufacturer.ESU) {
            this.productID += value * 256 * 256 * 256;
            return true;
        }
        log.error("unexpected step 9 reached with value: {}", (Object)value);
        return true;
    }

    @Override
    protected void statusUpdate(String s) {
        this.message(s);
        if (s.equals("Done")) {
            this.done(this.intMfg, this.modelID, this.productID);
            log.info("Decoder returns mfgID:{};modelID:{};productID:{}", new Object[]{this.intMfg, this.modelID, this.productID});
        } else if (log.isDebugEnabled()) {
            log.debug("received status: {}", (Object)s);
        }
    }

    protected abstract void done(int var1, int var2, int var3);

    protected abstract void message(String var1);

    static enum Manufacturer {
        DIETZ(115),
        DIY(13),
        DOEHLER(97),
        ESU(151),
        HARMAN(98),
        HORNBY(48),
        QSI(113),
        SOUNDTRAXX(141),
        TCS(153),
        TRAINOMATIC(78),
        ZIMO(145);

        public int value;

        private Manufacturer(int value) {
            this.value = value;
        }

        public static Manufacturer forValue(int value) {
            for (Manufacturer e : Manufacturer.values()) {
                if (e.value != value) continue;
                return e;
            }
            return null;
        }
    }
}

