/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.decoderdefn;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import javax.swing.Icon;
import javax.swing.JPanel;
import jmri.jmrit.XmlFile;
import jmri.jmrit.decoderdefn.Bundle;
import jmri.jmrit.decoderdefn.DecoderIndexFile;
import jmri.util.FileUtil;
import jmri.util.swing.JmriAbstractAction;
import jmri.util.swing.JmriJOptionPane;
import jmri.util.swing.JmriPanel;
import jmri.util.swing.WindowInterface;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstallDecoderURLAction
extends JmriAbstractAction {
    JPanel _who;
    private static final Logger log = LoggerFactory.getLogger(InstallDecoderURLAction.class);

    public InstallDecoderURLAction(String s, WindowInterface wi) {
        super(s, wi);
    }

    public InstallDecoderURLAction(String s, Icon i, WindowInterface wi) {
        super(s, i, wi);
    }

    public InstallDecoderURLAction(String s) {
        super(s);
    }

    public InstallDecoderURLAction(String s, JPanel who) {
        super(s);
    }

    URL pickURL(JPanel who) {
        String urlname = JmriJOptionPane.showInputDialog((Component)who, Bundle.getMessage("InputURL"), "");
        if (urlname == null || urlname.isBlank()) {
            JmriJOptionPane.showMessageDialog(who, Bundle.getMessage("NoURL"));
            return null;
        }
        try {
            return new URI(urlname).toURL();
        }
        catch (MalformedURLException | URISyntaxException e) {
            JmriJOptionPane.showMessageDialog(who, Bundle.getMessage("MalformedURL"));
            return null;
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        URL url = this.pickURL(this._who);
        if (url == null) {
            return;
        }
        if (this.checkFile(url, this._who)) {
            this.copyAndInstall(url, this._who);
        }
    }

    @SuppressFBWarnings(value={"SLF4J_SIGN_ONLY_FORMAT"}, justification="Specific log message format")
    void copyAndInstall(URL from, JPanel who) {
        log.debug("[{}]", (Object)from.getFile());
        File temp = new File(from.getFile());
        log.debug("File [{}]", (Object)temp.toString());
        FileUtil.createDirectory(FileUtil.getUserFilesPath() + "decoders");
        File toFile = new File(FileUtil.getUserFilesPath() + "decoders" + File.separator + temp.getName());
        log.debug("file [{}]", (Object)toFile.toString());
        if (!temp.toString().equals(toFile.toString())) {
            if (!this.copyfile(from, toFile, this._who)) {
                return;
            }
        } else {
            log.info("Source and destination files identical - file not copied");
            log.info("  source file: {}", (Object)temp.toString());
            log.info("  destination: {}", (Object)toFile.toString());
        }
        DecoderIndexFile.forceCreationOfNewIndex();
        JmriJOptionPane.showMessageDialog(who, Bundle.getMessage("CompleteOK"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"OBL_UNSATISFIED_OBLIGATION"}, justification="Looks like false positive")
    boolean copyfile(URL from, File toFile, JPanel who) {
        InputStream in = null;
        FileOutputStream out = null;
        try {
            int len;
            in = from.openConnection().getInputStream();
            out = new FileOutputStream(toFile);
            byte[] buf = new byte[1024];
            while ((len = in.read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
        }
        catch (FileNotFoundException ex) {
            log.debug("unexpected", (Throwable)ex);
            JmriJOptionPane.showMessageDialog(who, Bundle.getMessage("CopyError1"));
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            log.debug("IO Exception ", (Throwable)e);
            JmriJOptionPane.showMessageDialog(who, Bundle.getMessage("CopyError2"));
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e1) {
                log.error("exception closing in stream", (Throwable)e1);
            }
            try {
                if (out != null) {
                    ((OutputStream)out).close();
                }
            }
            catch (IOException e2) {
                log.error("exception closing out stream", (Throwable)e2);
            }
        }
        return true;
    }

    boolean checkFile(URL url, JPanel who) {
        try {
            Element root = this.readFile(url);
            if (log.isDebugEnabled()) {
                log.debug("parsing complete");
            }
            if (root.getChild("decoder") == null) {
                JmriJOptionPane.showMessageDialog(who, Bundle.getMessage("WrongContent"));
                return false;
            }
            return true;
        }
        catch (IOException | JDOMException ex) {
            log.debug("Exception checking file", ex);
            JmriJOptionPane.showMessageDialog(who, Bundle.getMessage("ParseError"));
            return false;
        }
    }

    Element readFile(URL url) throws JDOMException, IOException {
        XmlFile xf = new XmlFile(){};
        return xf.rootFromURL(url);
    }

    @Override
    public JmriPanel makePanel() {
        throw new IllegalArgumentException("Should not be invoked");
    }
}

