/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.decoderdefn;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import jmri.InstanceManager;
import jmri.Version;
import jmri.jmrit.decoderdefn.DecoderFile;
import jmri.jmrit.decoderdefn.DecoderIndexFile;
import jmri.util.FileUtil;
import jmri.util.davidflanagan.HardcopyWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrintDecoderListAction
extends AbstractAction {
    Frame mFrame;
    boolean isPreview;
    private static final Logger log = LoggerFactory.getLogger(PrintDecoderListAction.class);

    public PrintDecoderListAction(String actionName, Frame frame, boolean preview) {
        super(actionName);
        this.mFrame = frame;
        this.isPreview = preview;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        HardcopyWriter writer = null;
        try {
            writer = new HardcopyWriter(this.mFrame, "DecoderPro V" + Version.name() + " Decoder Definitions", 10, 0.5, 0.5, 0.5, 0.5, this.isPreview);
        }
        catch (HardcopyWriter.PrintCanceledException ex) {
            log.debug("Print cancelled");
            return;
        }
        ImageIcon icon = new ImageIcon(FileUtil.findURL("resources/decoderpro.gif", FileUtil.Location.INSTALLED));
        writer.write(icon.getImage(), new JLabel(icon));
        String lastMfg = "";
        String lastFamily = "";
        DecoderIndexFile f = InstanceManager.getDefault(DecoderIndexFile.class);
        List<DecoderFile> l = f.matchingDecoderList(null, null, null, null, null, null);
        int i = -1;
        log.debug("Roster list size: {}", (Object)l.size());
        for (i = 0; i < l.size(); ++i) {
            DecoderFile d = l.get(i);
            if (!d.getMfg().equals(lastMfg)) {
                this.printMfg(d, writer);
                lastMfg = d.getMfg();
                lastFamily = "";
            }
            if (!d.getFamily().equals(lastFamily)) {
                this.printFamily(d, writer);
                lastFamily = d.getFamily();
            }
            if (d.getFamily().equals(d.getModel())) continue;
            this.printEntry(d, writer);
        }
        writer.close();
    }

    void printEntry(DecoderFile d, HardcopyWriter w) {
        try {
            String s = "\n                       " + d.getModel();
            w.write(s, 0, s.length());
        }
        catch (IOException e) {
            log.error("Error printing", (Throwable)e);
        }
    }

    void printMfg(DecoderFile d, HardcopyWriter w) {
        try {
            String s = "\n\n" + d.getMfg();
            w.write(s, 0, s.length());
        }
        catch (IOException e) {
            log.error("Error printing", (Throwable)e);
        }
    }

    void printFamily(DecoderFile d, HardcopyWriter w) {
        try {
            String s = "\n           " + d.getFamily();
            w.write(s, 0, s.length());
        }
        catch (IOException e) {
            log.error("Error printing", (Throwable)e);
        }
    }
}

