/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.dispatcher;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import jmri.Block;
import jmri.InstanceManager;
import jmri.NamedBean;
import jmri.Sensor;
import jmri.Transit;
import jmri.TransitManager;
import jmri.jmrit.dispatcher.ActiveTrain;
import jmri.jmrit.dispatcher.Bundle;
import jmri.jmrit.dispatcher.DispatcherFrame;
import jmri.jmrit.dispatcher.TrainInfo;
import jmri.jmrit.dispatcher.TrainInfoFile;
import jmri.jmrit.dispatcher.TrainInfoFileSummary;
import jmri.jmrit.display.layoutEditor.LayoutBlock;
import jmri.jmrit.display.layoutEditor.LayoutBlockManager;
import jmri.jmrit.operations.trains.Train;
import jmri.jmrit.operations.trains.TrainManager;
import jmri.jmrit.roster.RosterEntry;
import jmri.jmrit.roster.swing.RosterEntryComboBox;
import jmri.swing.NamedBeanComboBox;
import jmri.util.JmriJFrame;
import jmri.util.MathUtil;
import jmri.util.StringUtil;
import jmri.util.swing.JComboBoxUtil;
import jmri.util.swing.JmriJOptionPane;
import org.jdom2.JDOMException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActivateTrainFrame
extends JmriJFrame {
    private DispatcherFrame _dispatcher = null;
    private TrainInfoFile _tiFile = null;
    private final TransitManager _TransitManager = InstanceManager.getDefault(TransitManager.class);
    private String _trainInfoName = "";
    private Transit selectedTransit = null;
    private JmriJFrame initiateFrame = null;
    private Container initiatePane = null;
    private final NamedBeanComboBox<Transit> transitSelectBox = new NamedBeanComboBox<Transit>(this._TransitManager);
    private final JComboBox<Object> trainSelectBox = new JComboBox();
    private RosterEntryComboBox rosterComboBox = null;
    private final JLabel trainFieldLabel = new JLabel(Bundle.getMessage("TrainBoxLabel") + ":");
    private final JTextField trainNameField = new JTextField(10);
    private final JLabel dccAddressFieldLabel = new JLabel("     " + Bundle.getMessage("DccAddressFieldLabel") + ":");
    private final JSpinner dccAddressSpinner = new JSpinner(new SpinnerNumberModel(3, 1, 9999, 1));
    private final JCheckBox inTransitBox = new JCheckBox(Bundle.getMessage("TrainInTransit"));
    private final JComboBox<String> startingBlockBox = new JComboBox();
    private final JComboBox<String> viaBlockBox = new JComboBox();
    private final JLabel viaBlockBoxLabel = new JLabel(Bundle.getMessage("ViaBlockBoxLabel"));
    private List<Block> startingBlockBoxList = new ArrayList<Block>();
    private final List<Block> viaBlockBoxList = new ArrayList<Block>();
    private List<Integer> startingBlockSeqList = new ArrayList<Integer>();
    private final JComboBox<String> destinationBlockBox = new JComboBox();
    private List<Block> destinationBlockBoxList = new ArrayList<Block>();
    private List<Integer> destinationBlockSeqList = new ArrayList<Integer>();
    private JButton addNewTrainButton = null;
    private JButton loadButton = null;
    private JButton saveButton = null;
    private JButton saveAsTemplateButton = null;
    private JButton deleteButton = null;
    private final JCheckBox autoRunBox = new JCheckBox(Bundle.getMessage("AutoRun"));
    private final JCheckBox loadAtStartupBox = new JCheckBox(Bundle.getMessage("LoadAtStartup"));
    private final JRadioButton radioTrainsFromRoster = new JRadioButton(Bundle.getMessage("TrainsFromRoster"));
    private final JRadioButton radioTrainsFromOps = new JRadioButton(Bundle.getMessage("TrainsFromTrains"));
    private final JRadioButton radioTrainsFromUser = new JRadioButton(Bundle.getMessage("TrainsFromUser"));
    private final JRadioButton radioTrainsFromSetLater = new JRadioButton(Bundle.getMessage("TrainsFromSetLater"));
    private final ButtonGroup trainsFromButtonGroup = new ButtonGroup();
    private final JRadioButton radioTransitsPredefined = new JRadioButton(Bundle.getMessage("TransitsPredefined"));
    private final JRadioButton radioTransitsAdHoc = new JRadioButton(Bundle.getMessage("TransitsAdHoc"));
    private final ButtonGroup transitsFromButtonGroup = new ButtonGroup();
    private final JRadioButton allocateBySafeRadioButton = new JRadioButton(Bundle.getMessage("ToSafeSections"));
    private final JRadioButton allocateAllTheWayRadioButton = new JRadioButton(Bundle.getMessage("AsFarAsPos"));
    private final JRadioButton allocateNumberOfBlocks = new JRadioButton(Bundle.getMessage("NumberOfBlocks") + ":");
    private final ButtonGroup allocateMethodButtonGroup = new ButtonGroup();
    private final JSpinner allocateCustomSpinner = new JSpinner(new SpinnerNumberModel(3, 1, 100, 1));
    private final JCheckBox terminateWhenDoneBox = new JCheckBox(Bundle.getMessage("TerminateWhenDone"));
    private final JPanel terminateWhenDoneDetails = new JPanel();
    private final JComboBox<String> nextTrain = new JComboBox();
    private final JLabel nextTrainLabel = new JLabel(Bundle.getMessage("TerminateWhenDoneNextTrain"));
    private final JSpinner prioritySpinner = new JSpinner(new SpinnerNumberModel(5, 0, 100, 1));
    private final JCheckBox resetWhenDoneBox = new JCheckBox(Bundle.getMessage("ResetWhenDone"));
    private final JCheckBox reverseAtEndBox = new JCheckBox(Bundle.getMessage("ReverseAtEnd"));
    int[] delayedStartInt = new int[]{0, 1, 2};
    String[] delayedStartString = new String[]{Bundle.getMessage("DelayedStartNone"), Bundle.getMessage("DelayedStartTimed"), Bundle.getMessage("DelayedStartSensor")};
    private final JComboBox<String> reverseDelayedRestartType = new JComboBox<String>(this.delayedStartString);
    private final JLabel delayReverseReStartLabel = new JLabel(Bundle.getMessage("DelayRestart"));
    private final JLabel delayReverseReStartSensorLabel = new JLabel(Bundle.getMessage("RestartSensor"));
    private final JCheckBox delayReverseResetSensorBox = new JCheckBox(Bundle.getMessage("ResetRestartSensor"));
    private final NamedBeanComboBox<Sensor> delayReverseReStartSensor = new NamedBeanComboBox<Sensor>(InstanceManager.sensorManagerInstance());
    private final JSpinner delayReverseMinSpinner = new JSpinner(new SpinnerNumberModel(0, 0, 1000, 1));
    private final JLabel delayReverseMinLabel = new JLabel(Bundle.getMessage("RestartTimed"));
    private final JCheckBox resetStartSensorBox = new JCheckBox(Bundle.getMessage("ResetStartSensor"));
    private final JComboBox<String> delayedStartBox = new JComboBox<String>(this.delayedStartString);
    private final JLabel delayedReStartLabel = new JLabel(Bundle.getMessage("DelayRestart"));
    private final JLabel delayReStartSensorLabel = new JLabel(Bundle.getMessage("RestartSensor"));
    private final JCheckBox resetRestartSensorBox = new JCheckBox(Bundle.getMessage("ResetRestartSensor"));
    private final JComboBox<String> delayedReStartBox = new JComboBox<String>(this.delayedStartString);
    private final NamedBeanComboBox<Sensor> delaySensor = new NamedBeanComboBox<Sensor>(InstanceManager.sensorManagerInstance());
    private final NamedBeanComboBox<Sensor> delayReStartSensor = new NamedBeanComboBox<Sensor>(InstanceManager.sensorManagerInstance());
    private final JSpinner departureHrSpinner = new JSpinner(new SpinnerNumberModel(8, 0, 23, 1));
    private final JSpinner departureMinSpinner = new JSpinner(new SpinnerNumberModel(0, 0, 59, 1));
    private final JLabel departureTimeLabel = new JLabel(Bundle.getMessage("DepartureTime"));
    private final JLabel departureSepLabel = new JLabel(":");
    private final JSpinner delayMinSpinner = new JSpinner(new SpinnerNumberModel(0, 0, 1000, 1));
    private final JLabel delayMinLabel = new JLabel(Bundle.getMessage("RestartTimed"));
    private final JComboBox<String> trainTypeBox = new JComboBox();
    boolean transitsFromSpecificBlock = false;
    private TrainInfo trainInfo;
    private final String nameOfTemplateFile = "TrainInfoDefaultTemplate.xml";
    private final ActionListener viaBlockBoxListener = e -> this.handleViaBlockSelectionChanged();
    private final JPanel pa1 = new JPanel();
    private final JLabel speedFactorLabel = new JLabel(Bundle.getMessage("SpeedFactorLabel"));
    private final JSpinner speedFactorSpinner = new JSpinner();
    private final JLabel minReliableOperatingSpeedLabel = new JLabel(Bundle.getMessage("MinReliableOperatingSpeedLabel"));
    private final JSpinner minReliableOperatingSpeedSpinner = new JSpinner();
    private final JLabel maxSpeedLabel = new JLabel(Bundle.getMessage("MaxSpeedLabel"));
    private final JSpinner maxSpeedSpinner = new JSpinner();
    private final JPanel pa2 = new JPanel();
    private final JLabel rampRateLabel = new JLabel(Bundle.getMessage("RampRateBoxLabel"));
    private final JComboBox<String> rampRateBox = new JComboBox();
    private final JPanel pa2a = new JPanel();
    private final JLabel useSpeedProfileLabel = new JLabel(Bundle.getMessage("UseSpeedProfileLabel"));
    private final JCheckBox useSpeedProfileCheckBox = new JCheckBox();
    private final JLabel stopBySpeedProfileLabel = new JLabel(Bundle.getMessage("StopBySpeedProfileLabel"));
    private final JCheckBox stopBySpeedProfileCheckBox = new JCheckBox();
    private final JLabel stopBySpeedProfileAdjustLabel = new JLabel(Bundle.getMessage("StopBySpeedProfileAdjustLabel"));
    private final JSpinner stopBySpeedProfileAdjustSpinner = new JSpinner();
    private final JPanel pa3 = new JPanel();
    private final JCheckBox soundDecoderBox = new JCheckBox(Bundle.getMessage("SoundDecoder"));
    private final JCheckBox runInReverseBox = new JCheckBox(Bundle.getMessage("RunInReverse"));
    private final JPanel pa4 = new JPanel();
    private final JLabel trainDetectionLabel = new JLabel(Bundle.getMessage("TrainDetection"));
    public final TrainDetectionJCombo trainDetectionComboBox = new TrainDetectionJCombo();
    public final TrainLengthUnitsJCombo trainLengthUnitsComboBox = new TrainLengthUnitsJCombo();
    private final JLabel trainLengthLabel = new JLabel(Bundle.getMessage("MaxTrainLengthLabel"));
    private JLabel trainLengthAltLengthLabel;
    private final JSpinner maxTrainLengthSpinner = new JSpinner();
    private static final Logger log = LoggerFactory.getLogger(ActivateTrainFrame.class);

    public ActivateTrainFrame(DispatcherFrame d) {
        super(true, true);
        this._dispatcher = d;
        this._tiFile = new TrainInfoFile();
    }

    public void initiateTrain(ActionEvent e, RosterEntry re, Block b) {
        this.initiateTrain(e);
        if (this.trainInfo.getTrainsFrom() == DispatcherFrame.TrainsFrom.TRAINSFROMROSTER && re != null) {
            this.setRosterComboBox(this.rosterComboBox, re.getId());
        }
        if (b != null && this.selectedTransit != null) {
            ArrayList<Transit> transitList = this._TransitManager.getListUsingBlock(b);
            ArrayList<Transit> transitEntryList = this._TransitManager.getListEntryBlock(b);
            for (Transit t : transitEntryList) {
                if (transitList.contains(t)) continue;
                transitList.add(t);
            }
            this.transitsFromSpecificBlock = true;
            this.initializeFreeTransitsCombo(transitList);
            ArrayList<Object> tmpBlkList = new ArrayList();
            if (this.selectedTransit.getEntryBlocksList().contains(b)) {
                tmpBlkList = this.selectedTransit.getEntryBlocksList();
                this.inTransitBox.setSelected(false);
            } else if (this.selectedTransit.containsBlock(b)) {
                tmpBlkList = this.selectedTransit.getInternalBlocksList();
                this.inTransitBox.setSelected(true);
            }
            ArrayList<Integer> tmpSeqList = this.selectedTransit.getBlockSeqList();
            for (int i = 0; i < tmpBlkList.size(); ++i) {
                if (tmpBlkList.get(i) != b) continue;
                this.setComboBox(this.startingBlockBox, this.getBlockName(b) + "-" + tmpSeqList.get(i));
                break;
            }
        }
    }

    protected void initiateTrain(ActionEvent e) {
        try {
            this.trainInfo = this._tiFile.readTrainInfo("TrainInfoDefaultTemplate.xml");
            if (this.trainInfo == null) {
                this.trainInfo = new TrainInfo();
            }
        }
        catch (IOException ioe) {
            log.error("IO Exception when reading train info file", (Throwable)ioe);
            return;
        }
        catch (JDOMException jde) {
            log.error("JDOM Exception when reading train info file", (Throwable)jde);
            return;
        }
        if (this.initiateFrame == null) {
            this.initiateFrame = this;
            this.initiateFrame.setTitle(Bundle.getMessage("AddTrainTitle"));
            this.initiateFrame.addHelpMenu("package.jmri.jmrit.dispatcher.NewTrain", true);
            this.initiatePane = this.initiateFrame.getContentPane();
            this.initiatePane.setLayout(new BoxLayout(this.initiatePane, 1));
            JPanel hdr = new JPanel();
            this.loadButton = new JButton(Bundle.getMessage("LoadButton"));
            hdr.add(this.loadButton);
            this.loadButton.addActionListener(this::loadTrainInfo);
            this.loadButton.setToolTipText(Bundle.getMessage("LoadButtonHint"));
            this.saveButton = new JButton(Bundle.getMessage("SaveButton"));
            hdr.add(this.saveButton);
            this.saveButton.addActionListener(ev -> this.saveTrainInfo());
            this.saveButton.setToolTipText(Bundle.getMessage("SaveButtonHint"));
            this.saveAsTemplateButton = new JButton(Bundle.getMessage("SaveAsTemplateButton"));
            hdr.add(this.saveAsTemplateButton);
            this.saveAsTemplateButton.addActionListener(ev -> this.saveTrainInfoAsTemplate());
            this.saveAsTemplateButton.setToolTipText(Bundle.getMessage("SaveAsTemplateButtonHint"));
            this.deleteButton = new JButton(Bundle.getMessage("DeleteButton"));
            hdr.add(this.deleteButton);
            this.deleteButton.addActionListener(ev -> this.deleteTrainInfo());
            this.deleteButton.setToolTipText(Bundle.getMessage("DeleteButtonHint"));
            JPanel p1 = new JPanel();
            p1.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("TrainsFrom")));
            this.radioTrainsFromRoster.setActionCommand("TRAINSFROMROSTER");
            this.trainsFromButtonGroup.add(this.radioTrainsFromRoster);
            this.radioTrainsFromOps.setActionCommand("TRAINSFROMOPS");
            this.trainsFromButtonGroup.add(this.radioTrainsFromOps);
            this.radioTrainsFromUser.setActionCommand("TRAINSFROMUSER");
            this.trainsFromButtonGroup.add(this.radioTrainsFromUser);
            this.radioTrainsFromSetLater.setActionCommand("TRAINSFROMSETLATER");
            this.trainsFromButtonGroup.add(this.radioTrainsFromSetLater);
            p1.add(this.radioTrainsFromRoster);
            this.radioTrainsFromRoster.setToolTipText(Bundle.getMessage("TrainsFromRosterHint"));
            p1.add(this.radioTrainsFromOps);
            this.radioTrainsFromOps.setToolTipText(Bundle.getMessage("TrainsFromTrainsHint"));
            p1.add(this.radioTrainsFromUser);
            this.radioTrainsFromUser.setToolTipText(Bundle.getMessage("TrainsFromUserHint"));
            p1.add(this.radioTrainsFromSetLater);
            this.radioTrainsFromSetLater.setToolTipText(Bundle.getMessage("TrainsFromSetLaterHint"));
            this.radioTrainsFromOps.addItemListener(e1 -> {
                if (e1.getStateChange() == 1) {
                    this.setTrainsFromOptions(DispatcherFrame.TrainsFrom.TRAINSFROMOPS);
                }
            });
            this.radioTrainsFromRoster.addItemListener(e1 -> {
                if (e1.getStateChange() == 1) {
                    this.setTrainsFromOptions(DispatcherFrame.TrainsFrom.TRAINSFROMROSTER);
                }
            });
            this.radioTrainsFromUser.addItemListener(e1 -> {
                if (e1.getStateChange() == 1) {
                    this.setTrainsFromOptions(DispatcherFrame.TrainsFrom.TRAINSFROMUSER);
                }
            });
            this.radioTrainsFromSetLater.addItemListener(e1 -> {
                if (e1.getStateChange() == 1) {
                    this.setTrainsFromOptions(DispatcherFrame.TrainsFrom.TRAINSFROMSETLATER);
                }
            });
            this.initiatePane.add(p1);
            JPanel p2 = new JPanel();
            p2.add(this.trainFieldLabel);
            p2.add(this.trainNameField);
            this.trainNameField.setToolTipText(Bundle.getMessage("TrainFieldHint"));
            this.rosterComboBox = new RosterEntryComboBox();
            this.initializeFreeRosterEntriesCombo();
            this.rosterComboBox.addActionListener(this::handleRosterSelectionChanged);
            p2.add(this.rosterComboBox);
            p2.add(this.trainSelectBox);
            this.trainSelectBox.addActionListener(e1 -> this.handleTrainSelectionChanged());
            this.trainSelectBox.setToolTipText(Bundle.getMessage("TrainBoxHint"));
            p2.add(this.dccAddressFieldLabel);
            p2.add(this.dccAddressSpinner);
            this.dccAddressSpinner.setToolTipText(Bundle.getMessage("DccAddressFieldHint"));
            this.initiatePane.add(p2);
            JPanel p3 = new JPanel();
            p3.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("TransitsFrom")));
            this.radioTransitsPredefined.setActionCommand("USETRANSITS");
            this.transitsFromButtonGroup.add(this.radioTransitsPredefined);
            this.radioTransitsAdHoc.setActionCommand("USEADHOC");
            this.transitsFromButtonGroup.add(this.radioTransitsAdHoc);
            p3.add(this.radioTransitsPredefined);
            this.radioTransitsPredefined.setToolTipText(Bundle.getMessage("TransitsPredefinedHint"));
            p3.add(this.radioTransitsAdHoc);
            this.radioTransitsAdHoc.setToolTipText(Bundle.getMessage("TransitsAdHocHint"));
            this.radioTransitsPredefined.addItemListener(e1 -> {
                if (e1.getStateChange() == 1) {
                    this.transitSelectBox.setEnabled(true);
                    this.inTransitBox.setEnabled(true);
                    this.handleInTransitClick();
                    this.viaBlockBox.setVisible(false);
                    this.viaBlockBoxLabel.setVisible(false);
                }
            });
            this.radioTransitsAdHoc.addItemListener(e1 -> {
                if (e1.getStateChange() == 1) {
                    this.checkAdvancedRouting();
                    this.transitSelectBox.setEnabled(false);
                    this.inTransitBox.setEnabled(false);
                    this.inTransitBox.setSelected(true);
                    this.initializeStartingBlockComboDynamic();
                    this.viaBlockBox.setVisible(true);
                    this.viaBlockBoxLabel.setVisible(true);
                }
            });
            p3.add(new JLabel(Bundle.getMessage("TransitBoxLabel") + " :"));
            p3.add(this.transitSelectBox);
            this.transitSelectBox.addActionListener(this::handleTransitSelectionChanged);
            this.transitSelectBox.setToolTipText(Bundle.getMessage("TransitBoxHint"));
            this.initiatePane.add(p3);
            JPanel p4 = new JPanel();
            p4.add(this.inTransitBox);
            this.inTransitBox.addActionListener(ev -> this.handleInTransitClick());
            this.inTransitBox.setToolTipText(Bundle.getMessage("InTransitBoxHint"));
            this.initiatePane.add(p4);
            JPanel p5 = new JPanel();
            p5.add(new JLabel(Bundle.getMessage("StartingBlockBoxLabel") + " :"));
            p5.add(this.startingBlockBox);
            this.startingBlockBox.setToolTipText(Bundle.getMessage("StartingBlockBoxHint"));
            this.startingBlockBox.addActionListener(ev -> this.handleStartingBlockSelectionChanged());
            p5.add(this.viaBlockBoxLabel);
            p5.add(this.viaBlockBox);
            this.viaBlockBox.setToolTipText(Bundle.getMessage("ViaBlockBoxHint"));
            this.viaBlockBox.addActionListener(this.viaBlockBoxListener);
            this.initiatePane.add(p5);
            JPanel p6 = new JPanel();
            p6.add(new JLabel(Bundle.getMessage("DestinationBlockBoxLabel") + ":"));
            p6.add(this.destinationBlockBox);
            this.destinationBlockBox.setToolTipText(Bundle.getMessage("DestinationBlockBoxHint"));
            this.initiatePane.add(p6);
            JPanel p7 = new JPanel();
            p7.add(this.trainDetectionLabel);
            this.initializeTrainDetectionBox();
            p7.add(this.trainDetectionComboBox);
            this.trainDetectionComboBox.setToolTipText(Bundle.getMessage("TrainDetectionBoxHint"));
            this.initiatePane.add(p7);
            JPanel p8 = new JPanel();
            p8.setBorder(BorderFactory.createTitledBorder(Bundle.getMessage("AllocateMethodLabel")));
            this.allocateMethodButtonGroup.add(this.allocateAllTheWayRadioButton);
            this.allocateMethodButtonGroup.add(this.allocateBySafeRadioButton);
            this.allocateMethodButtonGroup.add(this.allocateNumberOfBlocks);
            p8.add(this.allocateAllTheWayRadioButton);
            this.allocateAllTheWayRadioButton.setToolTipText(Bundle.getMessage("AllocateAllTheWayHint"));
            p8.add(this.allocateBySafeRadioButton);
            this.allocateBySafeRadioButton.setToolTipText(Bundle.getMessage("AllocateSafeHint"));
            p8.add(this.allocateNumberOfBlocks);
            this.allocateNumberOfBlocks.setToolTipText(Bundle.getMessage("AllocateMethodHint"));
            this.allocateAllTheWayRadioButton.addActionListener(ev -> this.handleAllocateAllTheWayButtonChanged());
            this.allocateBySafeRadioButton.addActionListener(ev -> this.handleAllocateBySafeButtonChanged());
            this.allocateNumberOfBlocks.addActionListener(ev -> this.handleAllocateNumberOfBlocksButtonChanged());
            p8.add(this.allocateCustomSpinner);
            this.allocateCustomSpinner.setToolTipText(Bundle.getMessage("AllocateMethodHint"));
            this.initiatePane.add(p8);
            JPanel p9 = new JPanel();
            p9.add(this.resetWhenDoneBox);
            this.resetWhenDoneBox.addActionListener(ev -> this.handleResetWhenDoneClick());
            this.resetWhenDoneBox.setToolTipText(Bundle.getMessage("ResetWhenDoneBoxHint"));
            this.initiatePane.add(p9);
            JPanel p9a = new JPanel();
            ((FlowLayout)p9a.getLayout()).setVgap(1);
            p9a.add(this.delayedReStartLabel);
            p9a.add(this.delayedReStartBox);
            p9a.add(this.resetRestartSensorBox);
            this.resetRestartSensorBox.setToolTipText(Bundle.getMessage("ResetRestartSensorHint"));
            this.resetRestartSensorBox.setSelected(true);
            this.delayedReStartBox.addActionListener(ev -> this.handleResetWhenDoneClick());
            this.delayedReStartBox.setToolTipText(Bundle.getMessage("DelayedReStartHint"));
            this.initiatePane.add(p9a);
            JPanel p9b = new JPanel();
            ((FlowLayout)p9b.getLayout()).setVgap(1);
            p9b.add(this.delayMinLabel);
            p9b.add(this.delayMinSpinner);
            this.delayMinSpinner.setToolTipText(Bundle.getMessage("RestartTimedHint"));
            p9b.add(this.delayReStartSensorLabel);
            p9b.add(this.delayReStartSensor);
            this.delayReStartSensor.setAllowNull(true);
            this.handleResetWhenDoneClick();
            this.initiatePane.add(p9b);
            this.initiatePane.add(new JSeparator());
            JPanel p10 = new JPanel();
            p10.add(this.reverseAtEndBox);
            this.reverseAtEndBox.setToolTipText(Bundle.getMessage("ReverseAtEndBoxHint"));
            this.initiatePane.add(p10);
            this.reverseAtEndBox.addActionListener(ev -> this.handleReverseAtEndBoxClick());
            JPanel pDelayReverseRestartDetails = new JPanel();
            ((FlowLayout)pDelayReverseRestartDetails.getLayout()).setVgap(1);
            pDelayReverseRestartDetails.add(this.delayReverseReStartLabel);
            pDelayReverseRestartDetails.add(this.reverseDelayedRestartType);
            pDelayReverseRestartDetails.add(this.delayReverseResetSensorBox);
            this.delayReverseResetSensorBox.setToolTipText(Bundle.getMessage("ReverseResetRestartSensorHint"));
            this.delayReverseResetSensorBox.setSelected(true);
            this.reverseDelayedRestartType.addActionListener(ev -> this.handleReverseAtEndBoxClick());
            this.reverseDelayedRestartType.setToolTipText(Bundle.getMessage("ReverseDelayedReStartHint"));
            this.initiatePane.add(pDelayReverseRestartDetails);
            JPanel pDelayReverseRestartDetails2 = new JPanel();
            ((FlowLayout)pDelayReverseRestartDetails2.getLayout()).setVgap(1);
            pDelayReverseRestartDetails2.add(this.delayReverseMinLabel);
            pDelayReverseRestartDetails2.add(this.delayReverseMinSpinner);
            this.delayReverseMinSpinner.setToolTipText(Bundle.getMessage("ReverseRestartTimedHint"));
            pDelayReverseRestartDetails2.add(this.delayReverseReStartSensorLabel);
            pDelayReverseRestartDetails2.add(this.delayReverseReStartSensor);
            this.delayReverseReStartSensor.setAllowNull(true);
            this.handleReverseAtEndBoxClick();
            this.initiatePane.add(pDelayReverseRestartDetails2);
            this.initiatePane.add(new JSeparator());
            JPanel p11 = new JPanel();
            p11.setLayout(new FlowLayout());
            p11.add(this.terminateWhenDoneBox);
            this.terminateWhenDoneBox.addActionListener(ev -> this.handleTerminateWhenDoneBoxClick());
            this.initiatePane.add(p11);
            this.terminateWhenDoneDetails.setLayout(new FlowLayout());
            this.terminateWhenDoneDetails.add(this.nextTrainLabel);
            this.terminateWhenDoneDetails.add(this.nextTrain);
            this.nextTrain.setToolTipText(Bundle.getMessage("TerminateWhenDoneNextTrainHint"));
            this.initiatePane.add(this.terminateWhenDoneDetails);
            this.handleTerminateWhenDoneBoxClick();
            this.initiatePane.add(new JSeparator());
            JPanel p12 = new JPanel();
            p12.setLayout(new FlowLayout());
            p12.add(new JLabel(Bundle.getMessage("PriorityLabel") + ":"));
            p12.add(this.prioritySpinner);
            this.prioritySpinner.setToolTipText(Bundle.getMessage("PriorityHint"));
            p12.add(new JLabel("     "));
            p12.add(new JLabel(Bundle.getMessage("TrainTypeBoxLabel")));
            this.initializeTrainTypeBox();
            p12.add(this.trainTypeBox);
            this.trainTypeBox.setSelectedIndex(1);
            this.trainTypeBox.setToolTipText(Bundle.getMessage("TrainTypeBoxHint"));
            this.initiatePane.add(p12);
            JPanel p13 = new JPanel();
            p13.add(new JLabel(Bundle.getMessage("DelayedStart")));
            p13.add(this.delayedStartBox);
            this.delayedStartBox.setToolTipText(Bundle.getMessage("DelayedStartHint"));
            this.delayedStartBox.addActionListener(this::handleDelayStartClick);
            p13.add(this.departureTimeLabel);
            this.departureHrSpinner.setEditor(new JSpinner.NumberEditor(this.departureHrSpinner, "00"));
            p13.add(this.departureHrSpinner);
            this.departureHrSpinner.setValue(8);
            this.departureHrSpinner.setToolTipText(Bundle.getMessage("DepartureTimeHrHint"));
            p13.add(this.departureSepLabel);
            this.departureMinSpinner.setEditor(new JSpinner.NumberEditor(this.departureMinSpinner, "00"));
            p13.add(this.departureMinSpinner);
            this.departureMinSpinner.setValue(0);
            this.departureMinSpinner.setToolTipText(Bundle.getMessage("DepartureTimeMinHint"));
            p13.add(this.delaySensor);
            this.delaySensor.setAllowNull(true);
            p13.add(this.resetStartSensorBox);
            this.resetStartSensorBox.setToolTipText(Bundle.getMessage("ResetStartSensorHint"));
            this.resetStartSensorBox.setSelected(true);
            this.handleDelayStartClick(null);
            this.initiatePane.add(p13);
            JPanel p14 = new JPanel();
            p14.setLayout(new FlowLayout());
            p14.add(this.loadAtStartupBox);
            this.loadAtStartupBox.setToolTipText(Bundle.getMessage("LoadAtStartupBoxHint"));
            this.loadAtStartupBox.setSelected(false);
            this.initiatePane.add(p14);
            this.initiatePane.add(new JSeparator());
            JPanel p15 = new JPanel();
            p15.add(this.autoRunBox);
            this.autoRunBox.addActionListener(ev -> this.handleAutoRunClick());
            this.autoRunBox.setToolTipText(Bundle.getMessage("AutoRunBoxHint"));
            this.autoRunBox.setSelected(false);
            this.initiatePane.add(p15);
            this.initializeAutoRunItems();
            JPanel ftr = new JPanel();
            JButton cancelButton = new JButton(Bundle.getMessage("ButtonCancel"));
            ftr.add(cancelButton);
            cancelButton.addActionListener(ev -> this.cancelInitiateTrain());
            cancelButton.setToolTipText(Bundle.getMessage("CancelButtonHint"));
            this.addNewTrainButton = new JButton(Bundle.getMessage("ButtonCreate"));
            ftr.add(this.addNewTrainButton);
            this.addNewTrainButton.addActionListener(e1 -> this.addNewTrain());
            this.addNewTrainButton.setToolTipText(Bundle.getMessage("AddNewTrainButtonHint"));
            JPanel mainPane = new JPanel(new BorderLayout());
            JScrollPane scrPane = new JScrollPane(this.initiatePane);
            mainPane.add((Component)hdr, "North");
            mainPane.add((Component)scrPane, "Center");
            mainPane.add((Component)ftr, "South");
            this.initiateFrame.setContentPane(mainPane);
            switch (this.trainInfo.getTrainsFrom()) {
                case TRAINSFROMROSTER: {
                    this.radioTrainsFromRoster.setSelected(true);
                    break;
                }
                case TRAINSFROMOPS: {
                    this.radioTrainsFromOps.setSelected(true);
                    break;
                }
                case TRAINSFROMUSER: {
                    this.radioTrainsFromUser.setSelected(true);
                    break;
                }
                default: {
                    this.radioTrainsFromSetLater.setSelected(true);
                }
            }
        }
        this.autoRunBox.setSelected(false);
        this.loadAtStartupBox.setSelected(false);
        this.initializeFreeTransitsCombo(new ArrayList<Transit>());
        this.refreshNextTrainCombo();
        this.setTrainsFromOptions(this.trainInfo.getTrainsFrom());
        this.initiateFrame.pack();
        this.initiateFrame.setVisible(true);
        this.trainInfoToDialog(this.trainInfo);
    }

    private void refreshNextTrainCombo() {
        Object saveEntry = null;
        if (this.nextTrain.getSelectedIndex() > 0) {
            saveEntry = this.nextTrain.getSelectedItem();
        }
        this.nextTrain.removeAllItems();
        this.nextTrain.addItem(" ");
        for (String file : this._tiFile.getTrainInfoFileNames()) {
            this.nextTrain.addItem(file);
        }
        if (saveEntry != null) {
            this.nextTrain.setSelectedItem(saveEntry);
        }
    }

    private void setTrainsFromOptions(DispatcherFrame.TrainsFrom transFrom) {
        switch (transFrom) {
            case TRAINSFROMROSTER: {
                this.initializeFreeRosterEntriesCombo();
                this.rosterComboBox.setVisible(true);
                this.trainSelectBox.setVisible(false);
                this.trainFieldLabel.setVisible(true);
                this.trainNameField.setVisible(true);
                this.dccAddressFieldLabel.setVisible(false);
                this.dccAddressSpinner.setVisible(false);
                break;
            }
            case TRAINSFROMOPS: {
                this.initializeFreeTrainsCombo();
                this.trainSelectBox.setVisible(true);
                this.rosterComboBox.setVisible(false);
                this.trainFieldLabel.setVisible(true);
                this.trainNameField.setVisible(true);
                this.dccAddressFieldLabel.setVisible(true);
                this.dccAddressSpinner.setVisible(true);
                this.setSpeedProfileOptions(this.trainInfo, false);
                break;
            }
            case TRAINSFROMUSER: {
                this.trainNameField.setText("");
                this.trainSelectBox.setVisible(false);
                this.rosterComboBox.setVisible(false);
                this.trainFieldLabel.setVisible(true);
                this.trainNameField.setVisible(true);
                this.dccAddressFieldLabel.setVisible(true);
                this.dccAddressSpinner.setVisible(true);
                this.dccAddressSpinner.setEnabled(true);
                this.setSpeedProfileOptions(this.trainInfo, false);
                break;
            }
            default: {
                this.rosterComboBox.setVisible(false);
                this.trainSelectBox.setVisible(false);
                this.trainFieldLabel.setVisible(true);
                this.trainNameField.setVisible(true);
                this.dccAddressFieldLabel.setVisible(false);
                this.dccAddressSpinner.setVisible(false);
            }
        }
    }

    private void initializeTrainTypeBox() {
        this.trainTypeBox.removeAllItems();
        this.trainTypeBox.addItem("<" + Bundle.getMessage("None").toLowerCase() + ">");
        this.trainTypeBox.addItem(Bundle.getMessage("LOCAL_PASSENGER"));
        this.trainTypeBox.addItem(Bundle.getMessage("LOCAL_FREIGHT"));
        this.trainTypeBox.addItem(Bundle.getMessage("THROUGH_PASSENGER"));
        this.trainTypeBox.addItem(Bundle.getMessage("THROUGH_FREIGHT"));
        this.trainTypeBox.addItem(Bundle.getMessage("EXPRESS_PASSENGER"));
        this.trainTypeBox.addItem(Bundle.getMessage("EXPRESS_FREIGHT"));
        this.trainTypeBox.addItem(Bundle.getMessage("MOW"));
    }

    private void initializeTrainDetectionBox() {
        this.trainDetectionComboBox.addItem(new TrainDetectionItem(Bundle.getMessage("TrainDetectionWholeTrain"), ActiveTrain.TrainDetection.TRAINDETECTION_WHOLETRAIN));
        this.trainDetectionComboBox.addItem(new TrainDetectionItem(Bundle.getMessage("TrainDetectionHeadAndTail"), ActiveTrain.TrainDetection.TRAINDETECTION_HEADANDTAIL));
        this.trainDetectionComboBox.addItem(new TrainDetectionItem(Bundle.getMessage("TrainDetectionHeadOnly"), ActiveTrain.TrainDetection.TRAINDETECTION_HEADONLY));
    }

    private void initializeScaleLengthBox() {
        this.trainLengthUnitsComboBox.addItem(new TrainLengthUnitsItem(Bundle.getMessage("TrainLengthInScaleFeet"), ActiveTrain.TrainLengthUnits.TRAINLENGTH_SCALEFEET));
        this.trainLengthUnitsComboBox.addItem(new TrainLengthUnitsItem(Bundle.getMessage("TrainLengthInScaleMeters"), ActiveTrain.TrainLengthUnits.TRAINLENGTH_SCALEMETERS));
        this.trainLengthUnitsComboBox.addItem(new TrainLengthUnitsItem(Bundle.getMessage("TrainLengthInActualInchs"), ActiveTrain.TrainLengthUnits.TRAINLENGTH_ACTUALINCHS));
        this.trainLengthUnitsComboBox.addItem(new TrainLengthUnitsItem(Bundle.getMessage("TrainLengthInActualcm"), ActiveTrain.TrainLengthUnits.TRAINLENGTH_ACTUALCM));
    }

    private void handleTransitSelectionChanged(ActionEvent e) {
        int index = this.transitSelectBox.getSelectedIndex();
        if (index < 0) {
            return;
        }
        Transit t = (Transit)this.transitSelectBox.getSelectedItem();
        if (t != null && t != this.selectedTransit) {
            this.selectedTransit = t;
            this.initializeStartingBlockCombo();
            this.initializeDestinationBlockCombo();
            this.initiateFrame.pack();
        }
    }

    private void handleInTransitClick() {
        if (!this.inTransitBox.isSelected() && this.selectedTransit.getEntryBlocksList().isEmpty()) {
            JmriJOptionPane.showMessageDialog(this.initiateFrame, Bundle.getMessage("NoEntryBlocks"), Bundle.getMessage("MessageTitle"), 1);
            this.inTransitBox.setSelected(true);
        }
        this.initializeStartingBlockCombo();
        this.initializeDestinationBlockCombo();
        this.initiateFrame.pack();
    }

    private void handleTrainSelectionChanged() {
        int dccAddress;
        if (!this.trainsFromButtonGroup.getSelection().getActionCommand().equals("TRAINSFROMOPS")) {
            return;
        }
        int ix = this.trainSelectBox.getSelectedIndex();
        if (ix < 1) {
            this.dccAddressSpinner.setEnabled(false);
            return;
        }
        this.dccAddressSpinner.setEnabled(true);
        try {
            dccAddress = Integer.parseInt(((Train)this.trainSelectBox.getSelectedItem()).getLeadEngineDccAddress());
        }
        catch (NumberFormatException ex) {
            JmriJOptionPane.showMessageDialog(this.initiateFrame, Bundle.getMessage("Error43"), Bundle.getMessage("ErrorTitle"), 0);
            return;
        }
        this.dccAddressSpinner.setValue(dccAddress);
        this.trainNameField.setText(((Train)this.trainSelectBox.getSelectedItem()).getName());
    }

    private void handleRosterSelectionChanged(ActionEvent e) {
        if (!this.trainsFromButtonGroup.getSelection().getActionCommand().equals("TRAINSFROMROSTER")) {
            return;
        }
        int ix = this.rosterComboBox.getSelectedIndex();
        if (ix > 0) {
            RosterEntry r = (RosterEntry)this.rosterComboBox.getItemAt(ix);
            if (r.getSpeedProfile() == null || r.getSpeedProfile().getProfileSize() < 1) {
                this.setSpeedProfileOptions(this.trainInfo, false);
            } else {
                this.setSpeedProfileOptions(this.trainInfo, true);
            }
            this.maxSpeedSpinner.setValue(Float.valueOf((float)r.getMaxSpeedPCT() / 100.0f));
            this.trainNameField.setText(r.titleString());
            if (r.getAttribute("DispatcherTrainType") != null && !r.getAttribute("DispatcherTrainType").equals("")) {
                this.trainTypeBox.setSelectedItem(r.getAttribute("DispatcherTrainType"));
            }
        } else {
            this.setSpeedProfileOptions(this.trainInfo, false);
        }
    }

    private void handleDelayStartClick(ActionEvent e) {
        this.departureHrSpinner.setVisible(false);
        this.departureMinSpinner.setVisible(false);
        this.departureTimeLabel.setVisible(false);
        this.departureSepLabel.setVisible(false);
        this.delaySensor.setVisible(false);
        this.resetStartSensorBox.setVisible(false);
        if (this.delayedStartBox.getSelectedItem().equals(Bundle.getMessage("DelayedStartTimed"))) {
            this.departureHrSpinner.setVisible(true);
            this.departureMinSpinner.setVisible(true);
            this.departureTimeLabel.setVisible(true);
            this.departureSepLabel.setVisible(true);
        } else if (this.delayedStartBox.getSelectedItem().equals(Bundle.getMessage("DelayedStartSensor"))) {
            this.delaySensor.setVisible(true);
            this.resetStartSensorBox.setVisible(true);
        }
        this.initiateFrame.pack();
    }

    private void handleResetWhenDoneClick() {
        this.delayMinSpinner.setVisible(false);
        this.delayMinLabel.setVisible(false);
        this.delayedReStartLabel.setVisible(false);
        this.delayedReStartBox.setVisible(false);
        this.delayReStartSensorLabel.setVisible(false);
        this.delayReStartSensor.setVisible(false);
        this.resetRestartSensorBox.setVisible(false);
        if (this.resetWhenDoneBox.isSelected()) {
            this.delayedReStartLabel.setVisible(true);
            this.delayedReStartBox.setVisible(true);
            this.terminateWhenDoneBox.setSelected(false);
            if (this.delayedReStartBox.getSelectedItem().equals(Bundle.getMessage("DelayedStartTimed"))) {
                this.delayMinSpinner.setVisible(true);
                this.delayMinLabel.setVisible(true);
            } else if (this.delayedReStartBox.getSelectedItem().equals(Bundle.getMessage("DelayedStartSensor"))) {
                this.delayReStartSensor.setVisible(true);
                this.delayReStartSensorLabel.setVisible(true);
                this.resetRestartSensorBox.setVisible(true);
            }
        } else {
            this.terminateWhenDoneBox.setEnabled(true);
        }
        this.initiateFrame.pack();
    }

    private void handleTerminateWhenDoneBoxClick() {
        if (this.terminateWhenDoneBox.isSelected()) {
            this.refreshNextTrainCombo();
            this.resetWhenDoneBox.setSelected(false);
            this.terminateWhenDoneDetails.setVisible(true);
        } else {
            this.terminateWhenDoneDetails.setVisible(false);
        }
    }

    private void handleReverseAtEndBoxClick() {
        this.delayReverseMinSpinner.setVisible(false);
        this.delayReverseMinLabel.setVisible(false);
        this.delayReverseReStartLabel.setVisible(false);
        this.reverseDelayedRestartType.setVisible(false);
        this.delayReverseReStartSensorLabel.setVisible(false);
        this.delayReverseReStartSensor.setVisible(false);
        this.delayReverseResetSensorBox.setVisible(false);
        if (this.reverseAtEndBox.isSelected()) {
            this.delayReverseReStartLabel.setVisible(true);
            this.reverseDelayedRestartType.setVisible(true);
            if (this.reverseDelayedRestartType.getSelectedItem().equals(Bundle.getMessage("DelayedStartTimed"))) {
                this.delayReverseMinSpinner.setVisible(true);
                this.delayReverseMinLabel.setVisible(true);
            } else if (this.reverseDelayedRestartType.getSelectedItem().equals(Bundle.getMessage("DelayedStartSensor"))) {
                this.delayReverseReStartSensor.setVisible(true);
                this.delayReStartSensorLabel.setVisible(true);
                this.delayReverseResetSensorBox.setVisible(true);
            }
        }
        this.initiateFrame.pack();
        if (this.resetWhenDoneBox.isSelected()) {
            this.terminateWhenDoneBox.setSelected(false);
            this.terminateWhenDoneBox.setEnabled(false);
        } else {
            this.terminateWhenDoneBox.setEnabled(true);
        }
    }

    private void handleAutoRunClick() {
        if (this.autoRunBox.isSelected()) {
            this.showAutoRunItems();
        } else {
            this.hideAutoRunItems();
        }
        this.initiateFrame.pack();
    }

    private void handleStartingBlockSelectionChanged() {
        if (this.radioTransitsAdHoc.isSelected()) {
            this.initializeViaBlockDynamicCombo();
            this.initializeDestinationBlockDynamicCombo();
        } else {
            this.initializeDestinationBlockCombo();
        }
        this.initiateFrame.pack();
    }

    private void handleViaBlockSelectionChanged() {
        if (this.radioTransitsAdHoc.isSelected()) {
            this.initializeDestinationBlockDynamicCombo();
        } else {
            this.initializeDestinationBlockCombo();
        }
        this.initiateFrame.pack();
    }

    private void handleAllocateAllTheWayButtonChanged() {
        this.allocateCustomSpinner.setVisible(false);
    }

    private void handleAllocateBySafeButtonChanged() {
        this.allocateCustomSpinner.setVisible(false);
    }

    private void handleAllocateNumberOfBlocksButtonChanged() {
        this.allocateCustomSpinner.setVisible(true);
    }

    private void cancelInitiateTrain() {
        this._dispatcher.newTrainDone(null);
    }

    private void addNewTrain() {
        try {
            this.validateDialog();
            this.trainInfo = new TrainInfo();
            this.dialogToTrainInfo(this.trainInfo);
            if (this.radioTransitsAdHoc.isSelected()) {
                int ixStart = this.startingBlockBox.getSelectedIndex();
                int ixEnd = this.destinationBlockBox.getSelectedIndex();
                int ixVia = this.viaBlockBox.getSelectedIndex();
                NamedBean tmpTransit = null;
                int routeCount = 9999;
                int startBlockSeq = 0;
                int endBlockSeq = 0;
                log.debug("Start[{}]Via[{}]Dest[{}}]", new Object[]{this.startingBlockBoxList.get(ixStart).getDisplayName(), this.viaBlockBoxList.get(ixVia).getDisplayName(), this.destinationBlockBoxList.get(ixEnd).getDisplayName()});
                for (Transit tr : InstanceManager.getDefault(TransitManager.class).getListUsingBlock(this.startingBlockBoxList.get(ixStart))) {
                    if (tr.getState() != 2 || !tr.containsBlock(this.startingBlockBoxList.get(ixStart)) || !tr.containsBlock(this.viaBlockBoxList.get(ixVia)) || !tr.containsBlock(this.destinationBlockBoxList.get(ixEnd))) continue;
                    log.debug("[{}]  contains all blocks", (Object)tr.getDisplayName());
                    int ixCountStart = -1;
                    int ixCountVia = -1;
                    int ixCountDest = -1;
                    int ixCount = 0;
                    ArrayList<Block> transitBlocks = tr.getInternalBlocksList();
                    ArrayList<Integer> transitBlockSeq = tr.getBlockSeqList();
                    for (Block blk : transitBlocks) {
                        log.debug("Checking Block[{}] t[{}] BlockSequ[{}]", new Object[]{blk.getDisplayName(), ixCount, transitBlockSeq.get(ixCount)});
                        if (ixCountStart == -1 && blk == this.startingBlockBoxList.get(ixStart)) {
                            log.trace("ixOne[{}]block[{}]", (Object)ixCount, (Object)blk.getDisplayName());
                            ixCountStart = ixCount;
                        } else if (ixCountStart != -1 && ixCountVia == -1 && blk == this.viaBlockBoxList.get(ixVia)) {
                            log.trace("ixTwo[{}]block[{}]", (Object)ixCount, (Object)blk.getDisplayName());
                            if (ixCount != ixCountStart + 1) {
                                log.debug("AdHoc {}:via and start not ajacent", (Object)tr.getDisplayName());
                                break;
                            }
                            ixCountVia = ixCount;
                        } else if (ixCountStart != -1 && ixCountVia != -1 && ixCountDest == -1 && blk == this.destinationBlockBoxList.get(ixEnd)) {
                            ixCountDest = ixCount;
                            log.trace("ixThree[{}]block[{}]", (Object)ixCountDest, (Object)blk.getDisplayName());
                            break;
                        }
                        ++ixCount;
                    }
                    if (ixCountVia != ixCountStart + 1 || ixCountDest <= ixCountStart) continue;
                    log.debug("Canuse [{}", (Object)tr.getDisplayName());
                    Integer routeBlockLength = (Integer)transitBlockSeq.get(ixCountDest) - (Integer)transitBlockSeq.get(ixCountStart);
                    if (routeBlockLength >= routeCount) continue;
                    routeCount = ixCountDest - ixCountStart;
                    tmpTransit = tr;
                    startBlockSeq = (Integer)transitBlockSeq.get(ixCountStart);
                    endBlockSeq = (Integer)transitBlockSeq.get(ixCountDest);
                }
                if (tmpTransit != null && JmriJOptionPane.showConfirmDialog(this, Bundle.getMessage("Question6", tmpTransit.getDisplayName()), "Question", 0, 3) == 0) {
                    this.trainInfo.setDynamicTransit(false);
                    this.trainInfo.setTransitName(tmpTransit.getDisplayName());
                    this.trainInfo.setTransitId(tmpTransit.getDisplayName());
                    this.trainInfo.setStartBlockSeq(startBlockSeq);
                    this.trainInfo.setStartBlockName(this.getBlockName(this.startingBlockBoxList.get(ixStart)) + "-" + startBlockSeq);
                    this.trainInfo.setDestinationBlockSeq(endBlockSeq);
                    this.trainInfo.setDestinationBlockName(this.getBlockName(this.destinationBlockBoxList.get(ixEnd)) + "-" + endBlockSeq);
                    this.trainInfoToDialog(this.trainInfo);
                } else {
                    List<LayoutBlock> blockList = this._dispatcher.getAdHocRoute(this.startingBlockBoxList.get(ixStart), this.destinationBlockBoxList.get(ixEnd), this.viaBlockBoxList.get(ixVia));
                    if (blockList == null) {
                        JmriJOptionPane.showMessageDialog(this.initiateFrame, Bundle.getMessage("Error51"), Bundle.getMessage("ErrorTitle"), 0);
                        return;
                    }
                }
            }
            this._dispatcher.loadTrainFromTrainInfoThrowsException(this.trainInfo, "NONE", "");
        }
        catch (IllegalArgumentException ex) {
            JmriJOptionPane.showMessageDialog(this.initiateFrame, ex.getMessage(), Bundle.getMessage("ErrorTitle"), 0);
        }
    }

    private void initializeFreeTransitsCombo(List<Transit> transitList) {
        HashSet<Transit> excludeTransits = new HashSet<Transit>();
        for (Transit t : this._TransitManager.getNamedBeanSet()) {
            if (t.getState() == 2) continue;
            excludeTransits.add(t);
        }
        this.transitSelectBox.setExcludedItems(excludeTransits);
        JComboBoxUtil.setupComboBoxMaxRows(this.transitSelectBox);
        if (this.transitSelectBox.getItemCount() > 0) {
            this.transitSelectBox.setSelectedIndex(0);
            this.selectedTransit = (Transit)this.transitSelectBox.getItemAt(0);
        } else {
            this.selectedTransit = null;
        }
    }

    private void initializeFreeRosterEntriesCombo() {
        this.rosterComboBox.update();
        for (int ix = this.rosterComboBox.getItemCount() - 1; ix > 1; --ix) {
            if (this._dispatcher.isAddressFree(((RosterEntry)this.rosterComboBox.getItemAt(ix)).getDccLocoAddress().getNumber())) continue;
            this.rosterComboBox.removeItemAt(ix);
        }
    }

    private void initializeFreeTrainsCombo() {
        ActionListener[] als;
        Train prevValue = null;
        if (this.trainSelectBox.getSelectedIndex() > 0) {
            prevValue = (Train)this.trainSelectBox.getSelectedItem();
        }
        for (ActionListener al : als = this.trainSelectBox.getActionListeners()) {
            this.trainSelectBox.removeActionListener(al);
        }
        this.trainSelectBox.removeAllItems();
        this.trainSelectBox.addItem("Select Train");
        List<Train> trains = InstanceManager.getDefault(TrainManager.class).getTrainsByNameList();
        if (trains.size() > 0) {
            for (int i = 0; i < trains.size(); ++i) {
                String tName;
                Train t = trains.get(i);
                if (t == null || !this._dispatcher.isTrainFree(tName = t.getName())) continue;
                this.trainSelectBox.addItem(t);
            }
        }
        if (prevValue != null) {
            this.trainSelectBox.setSelectedItem(prevValue);
        }
        for (ActionListener al : als) {
            this.trainSelectBox.addActionListener(al);
        }
    }

    private void setSpeedProfileOptions(TrainInfo info, boolean b) {
        this.useSpeedProfileLabel.setEnabled(b);
        this.useSpeedProfileCheckBox.setEnabled(b);
        this.stopBySpeedProfileLabel.setEnabled(b);
        this.stopBySpeedProfileCheckBox.setEnabled(b);
        this.stopBySpeedProfileAdjustLabel.setEnabled(b);
        this.stopBySpeedProfileAdjustSpinner.setEnabled(b);
        if (!b) {
            this.useSpeedProfileCheckBox.setSelected(false);
            this.stopBySpeedProfileCheckBox.setSelected(false);
        }
    }

    private void initializeStartingBlockCombo() {
        String prevValue = (String)this.startingBlockBox.getSelectedItem();
        this.startingBlockBox.removeAllItems();
        this.startingBlockBoxList.clear();
        if (!this.inTransitBox.isSelected() && this.selectedTransit.getEntryBlocksList().isEmpty()) {
            this.inTransitBox.setSelected(true);
        }
        this.startingBlockBoxList = this.inTransitBox.isSelected() ? this.selectedTransit.getInternalBlocksList() : this.selectedTransit.getEntryBlocksList();
        this.startingBlockSeqList = this.selectedTransit.getBlockSeqList();
        boolean found = false;
        for (int i = 0; i < this.startingBlockBoxList.size(); ++i) {
            Block b = this.startingBlockBoxList.get(i);
            int seq = this.startingBlockSeqList.get(i);
            this.startingBlockBox.addItem(this.getBlockName(b) + "-" + seq);
            if (found || b.getState() != 2) continue;
            this.startingBlockBox.setSelectedItem(this.getBlockName(b) + "-" + seq);
            found = true;
        }
        if (prevValue != null) {
            this.startingBlockBox.setSelectedItem(prevValue);
        }
        JComboBoxUtil.setupComboBoxMaxRows(this.startingBlockBox);
    }

    private void initializeDestinationBlockCombo() {
        String prevValue = (String)this.destinationBlockBox.getSelectedItem();
        this.destinationBlockBox.removeAllItems();
        this.destinationBlockBoxList.clear();
        int index = this.startingBlockBox.getSelectedIndex();
        if (index < 0) {
            return;
        }
        Block startBlock = this.startingBlockBoxList.get(index);
        this.destinationBlockBoxList = this.selectedTransit.getDestinationBlocksList(startBlock, this.inTransitBox.isSelected());
        this.destinationBlockSeqList = this.selectedTransit.getDestBlocksSeqList();
        for (int i = 0; i < this.destinationBlockBoxList.size(); ++i) {
            Block b = this.destinationBlockBoxList.get(i);
            Object bName = this.getBlockName(b);
            if (this.selectedTransit.getBlockCount(b) > 1) {
                int seq = this.destinationBlockSeqList.get(i);
                bName = (String)bName + "-" + seq;
            }
            this.destinationBlockBox.addItem((String)bName);
        }
        if (prevValue != null) {
            this.destinationBlockBox.setSelectedItem(prevValue);
        }
        JComboBoxUtil.setupComboBoxMaxRows(this.destinationBlockBox);
    }

    private String getBlockName(Block b) {
        if (b != null) {
            return b.getDisplayName();
        }
        return " ";
    }

    protected void showActivateFrame() {
        if (this.initiateFrame != null) {
            this.initializeFreeTransitsCombo(new ArrayList<Transit>());
            this.initiateFrame.setVisible(true);
        } else {
            this._dispatcher.newTrainDone(null);
        }
    }

    public void showActivateFrame(RosterEntry re) {
        this.showActivateFrame();
    }

    protected void loadTrainInfo(ActionEvent e) {
        List<TrainInfoFileSummary> names = this._tiFile.getTrainInfoFileSummaries();
        if (!names.isEmpty()) {
            JTable table = new JTable(){

                @Override
                public Dimension getPreferredScrollableViewportSize() {
                    return new Dimension(super.getPreferredSize().width, super.getPreferredScrollableViewportSize().height);
                }
            };
            DefaultTableModel tm = new DefaultTableModel(new Object[]{Bundle.getMessage("FileNameColumnTitle"), Bundle.getMessage("TrainColumnTitle"), Bundle.getMessage("TransitColumnTitle"), Bundle.getMessage("StartBlockColumnTitle"), Bundle.getMessage("EndBlockColumnTitle"), Bundle.getMessage("DccColumnTitleColumnTitle")}, 0){

                @Override
                public boolean isCellEditable(int row, int column) {
                    return false;
                }
            };
            table.setModel(tm);
            for (TrainInfoFileSummary fs : names) {
                tm.addRow(new Object[]{fs.getFileName(), fs.getTrainName(), fs.getTransitName(), fs.getStartBlockName(), fs.getEndBlockName(), fs.getDccAddress()});
            }
            JPanel jp = new JPanel(new BorderLayout());
            TableColumnModel columnModel = table.getColumnModel();
            table.setAutoResizeMode(0);
            for (int column = 0; column < table.getColumnCount(); ++column) {
                int width = 30;
                for (int row = 0; row < table.getRowCount(); ++row) {
                    TableCellRenderer renderer = table.getCellRenderer(row, column);
                    Component comp = table.prepareRenderer(renderer, row, column);
                    width = Math.max(comp.getPreferredSize().width + 1, width);
                }
                if (width > 300) {
                    width = 300;
                }
                columnModel.getColumn(column).setPreferredWidth(width);
            }
            jp.add(table);
            JScrollPane sp = new JScrollPane(table, 20, 30);
            int optionSelected = JmriJOptionPane.showOptionDialog(this.initiateFrame, sp, Bundle.getMessage("LoadTrainTitle"), 2, -1, null, null, null);
            if (optionSelected != 0) {
                return;
            }
            if (table.getSelectedRow() < 0) {
                return;
            }
            String selName = (String)table.getModel().getValueAt(table.getSelectedRow(), 0);
            if (selName == null || selName.isEmpty()) {
                return;
            }
            this._trainInfoName = selName;
            try {
                this.trainInfo = this._tiFile.readTrainInfo(selName);
                if (this.trainInfo != null) {
                    this.trainInfoToDialog(this.trainInfo);
                }
            }
            catch (IOException ioe) {
                log.error("IO Exception when reading train info file", (Throwable)ioe);
            }
            catch (JDOMException jde) {
                log.error("JDOM Exception when reading train info file", (Throwable)jde);
            }
            this.handleDelayStartClick(null);
            this.handleReverseAtEndBoxClick();
        }
    }

    private void saveTrainInfo() {
        this.saveTrainInfo(false);
        this.refreshNextTrainCombo();
    }

    private void saveTrainInfoAsTemplate() {
        this.saveTrainInfo(true);
    }

    private void saveTrainInfo(boolean asTemplate) {
        String fileName;
        try {
            this.dialogToTrainInfo(this.trainInfo);
        }
        catch (IllegalArgumentException ide) {
            JmriJOptionPane.showMessageDialog(this.initiateFrame, ide.getMessage(), Bundle.getMessage("ErrorTitle"), 0);
            return;
        }
        if (asTemplate) {
            fileName = this.normalizeXmlFileName("TrainInfoDefaultTemplate.xml");
        } else {
            String eName = JmriJOptionPane.showInputDialog((Component)this.initiateFrame, Bundle.getMessage("EnterFileName") + " :", this._trainInfoName);
            if (eName == null) {
                return;
            }
            if (eName.length() < 1) {
                JmriJOptionPane.showMessageDialog(this.initiateFrame, Bundle.getMessage("Error25"), Bundle.getMessage("ErrorTitle"), 0);
                return;
            }
            this._trainInfoName = fileName = this.normalizeXmlFileName(eName);
        }
        String[] names = this._tiFile.getTrainInfoFileNames();
        if (names.length > 0) {
            int selectedValue;
            boolean found = false;
            for (int i = 0; i < names.length; ++i) {
                if (!fileName.equals(names[i])) continue;
                found = true;
            }
            if (found && (selectedValue = JmriJOptionPane.showOptionDialog(this.initiateFrame, Bundle.getMessage("Question3", fileName), Bundle.getMessage("WarningTitle"), -1, 3, null, new Object[]{Bundle.getMessage("ButtonReplace"), Bundle.getMessage("ButtonNo")}, Bundle.getMessage("ButtonNo"))) != 0) {
                return;
            }
        }
        try {
            this._tiFile.writeTrainInfo(this.trainInfo, fileName);
        }
        catch (IOException ioe) {
            log.error("IO exception writing Train Info", (Throwable)ioe);
        }
    }

    private void deleteTrainInfo() {
        Object[] names = this._tiFile.getTrainInfoFileNames();
        if (names.length > 0) {
            Object selName = JmriJOptionPane.showInputDialog(this.initiateFrame, Bundle.getMessage("DeleteTrainChoice"), Bundle.getMessage("DeleteTrainTitle"), 3, null, names, names[0]);
            if (selName == null || ((String)selName).isEmpty()) {
                return;
            }
            this._tiFile.deleteTrainInfoFile((String)selName);
        }
    }

    private void trainInfoToDialog(TrainInfo info) {
        if (!info.getDynamicTransit()) {
            this.radioTransitsPredefined.setSelected(true);
            if (!info.getTransitName().isEmpty()) {
                try {
                    this.transitSelectBox.setSelectedItemByName(info.getTransitName());
                }
                catch (Exception ex) {
                    log.warn("Transit {} from file not in Transit menu", (Object)info.getTransitName());
                    JmriJOptionPane.showMessageDialog(this.initiateFrame, Bundle.getMessage("TransitWarn", info.getTransitName()), null, 2);
                }
            }
        } else {
            this.radioTransitsAdHoc.setSelected(true);
        }
        switch (info.getTrainsFrom()) {
            case TRAINSFROMROSTER: {
                this.radioTrainsFromRoster.setSelected(true);
                if (info.getRosterId().isEmpty() || this.setRosterComboBox(this.rosterComboBox, info.getRosterId())) break;
                log.warn("Roster {} from file not in Roster Combo", (Object)info.getRosterId());
                JmriJOptionPane.showMessageDialog(this.initiateFrame, Bundle.getMessage("TrainWarn", info.getRosterId()), null, 2);
                break;
            }
            case TRAINSFROMOPS: {
                this.radioTrainsFromOps.setSelected(true);
                if (info.getTrainName().isEmpty() || this.setTrainComboBox(this.trainSelectBox, info.getTrainName())) break;
                log.warn("Train {} from file not in Train Combo", (Object)info.getTrainName());
                JmriJOptionPane.showMessageDialog(this.initiateFrame, Bundle.getMessage("TrainWarn", info.getTrainName()), null, 2);
                break;
            }
            case TRAINSFROMUSER: {
                this.radioTrainsFromUser.setSelected(true);
                this.dccAddressSpinner.setValue(Integer.valueOf(info.getDccAddress()));
                break;
            }
            default: {
                this.radioTrainsFromSetLater.setSelected(true);
            }
        }
        this.trainNameField.setText(info.getTrainUserName());
        this.trainDetectionComboBox.setSelectedItemByValue(info.getTrainDetection());
        this.inTransitBox.setSelected(info.getTrainInTransit());
        if (this.radioTransitsAdHoc.isSelected()) {
            this.initializeStartingBlockComboDynamic();
        } else {
            this.initializeStartingBlockCombo();
        }
        this.setComboBox(this.startingBlockBox, info.getStartBlockName());
        if (this.radioTransitsAdHoc.isSelected()) {
            this.initializeViaBlockDynamicCombo();
            this.setComboBox(this.viaBlockBox, info.getViaBlockName());
        }
        if (this.radioTransitsAdHoc.isSelected()) {
            this.initializeDestinationBlockDynamicCombo();
        } else {
            this.initializeDestinationBlockCombo();
        }
        this.setComboBox(this.destinationBlockBox, info.getDestinationBlockName());
        this.setAllocateMethodButtons(info.getAllocationMethod());
        this.prioritySpinner.setValue(info.getPriority());
        this.resetWhenDoneBox.setSelected(info.getResetWhenDone());
        this.reverseAtEndBox.setSelected(info.getReverseAtEnd());
        this.setDelayModeBox(info.getDelayedStart(), this.delayedStartBox);
        this.departureHrSpinner.setValue(info.getDepartureTimeHr());
        this.departureMinSpinner.setValue(info.getDepartureTimeMin());
        this.delaySensor.setSelectedItem(info.getDelaySensor());
        this.resetStartSensorBox.setSelected(info.getResetStartSensor());
        this.setDelayModeBox(info.getDelayedRestart(), this.delayedReStartBox);
        this.delayMinSpinner.setValue(info.getRestartDelayMin());
        this.delayReStartSensor.setSelectedItem(info.getRestartSensor());
        this.resetRestartSensorBox.setSelected(info.getResetRestartSensor());
        this.resetStartSensorBox.setSelected(info.getResetStartSensor());
        this.setDelayModeBox(info.getReverseDelayedRestart(), this.reverseDelayedRestartType);
        this.delayReverseMinSpinner.setValue(info.getReverseRestartDelayMin());
        this.delayReverseReStartSensor.setSelectedItem(info.getReverseRestartSensor());
        this.delayReverseResetSensorBox.setSelected(info.getReverseResetRestartSensor());
        this.terminateWhenDoneBox.setSelected(info.getTerminateWhenDone());
        this.nextTrain.setSelectedIndex(-1);
        try {
            this.nextTrain.setSelectedItem(info.getNextTrain());
        }
        catch (Exception ex) {
            this.nextTrain.setSelectedIndex(-1);
        }
        this.handleTerminateWhenDoneBoxClick();
        this.setComboBox(this.trainTypeBox, info.getTrainType());
        this.autoRunBox.setSelected(info.getAutoRun());
        this.loadAtStartupBox.setSelected(info.getLoadAtStartup());
        this.setAllocateMethodButtons(info.getAllocationMethod());
        this.autoTrainInfoToDialog(info);
    }

    private boolean validateDialog() throws IllegalArgumentException {
        int min;
        int index = this.transitSelectBox.getSelectedIndex();
        if (index < 0) {
            throw new IllegalArgumentException(Bundle.getMessage("Error44"));
        }
        switch (this.trainsFromButtonGroup.getSelection().getActionCommand()) {
            case "TRAINSFROMROSTER": {
                if (this.rosterComboBox.getSelectedIndex() >= 1) break;
                throw new IllegalArgumentException(Bundle.getMessage("Error41"));
            }
            case "TRAINSFROMOPS": {
                if (this.trainSelectBox.getSelectedIndex() >= 1) break;
                throw new IllegalArgumentException(Bundle.getMessage("Error42"));
            }
            case "TRAINSFROMUSER": {
                if (!this.trainNameField.getText().isEmpty()) break;
                throw new IllegalArgumentException(Bundle.getMessage("Error22"));
            }
        }
        index = this.startingBlockBox.getSelectedIndex();
        if (index < 0) {
            throw new IllegalArgumentException(Bundle.getMessage("Error13"));
        }
        index = this.destinationBlockBox.getSelectedIndex();
        if (index < 0) {
            throw new IllegalArgumentException(Bundle.getMessage("Error8"));
        }
        if (this.radioTransitsAdHoc.isSelected() && (index = this.viaBlockBox.getSelectedIndex()) < 0) {
            throw new IllegalArgumentException(Bundle.getMessage("Error8"));
        }
        if (!this.reverseAtEndBox.isSelected() && this.resetWhenDoneBox.isSelected() && !this.selectedTransit.canBeResetWhenDone()) {
            this.resetWhenDoneBox.setSelected(false);
            throw new IllegalArgumentException(Bundle.getMessage("NoResetMessage"));
        }
        int max = Math.round(((Float)this.maxSpeedSpinner.getValue()).floatValue() * 100.0f);
        if (max - (min = Math.round(((Float)this.minReliableOperatingSpeedSpinner.getValue()).floatValue() * 100.0f)) < 10) {
            throw new IllegalArgumentException(Bundle.getMessage("Error49", this.maxSpeedSpinner.getValue(), this.minReliableOperatingSpeedSpinner.getValue()));
        }
        return true;
    }

    private boolean dialogToTrainInfo(TrainInfo info) {
        int index = this.transitSelectBox.getSelectedIndex();
        info.setDynamicTransit(this.radioTransitsAdHoc.isSelected());
        if (!info.getDynamicTransit() && index >= 0) {
            info.setTransitName(((Transit)this.transitSelectBox.getSelectedItem()).getDisplayName());
            info.setTransitId(((Transit)this.transitSelectBox.getSelectedItem()).getDisplayName());
        }
        switch (this.trainsFromButtonGroup.getSelection().getActionCommand()) {
            case "TRAINSFROMROSTER": {
                info.setRosterId(((RosterEntry)this.rosterComboBox.getSelectedItem()).getId());
                info.setDccAddress(((RosterEntry)this.rosterComboBox.getSelectedItem()).getDccAddress());
                this.trainInfo.setTrainsFrom(DispatcherFrame.TrainsFrom.TRAINSFROMROSTER);
                this.setTrainsFromOptions(this.trainInfo.getTrainsFrom());
                break;
            }
            case "TRAINSFROMOPS": {
                info.setTrainName(((Train)this.trainSelectBox.getSelectedItem()).toString());
                info.setDccAddress(String.valueOf(this.dccAddressSpinner.getValue()));
                this.trainInfo.setTrainsFrom(DispatcherFrame.TrainsFrom.TRAINSFROMOPS);
                this.setTrainsFromOptions(this.trainInfo.getTrainsFrom());
                break;
            }
            case "TRAINSFROMUSER": {
                this.trainInfo.setTrainsFrom(DispatcherFrame.TrainsFrom.TRAINSFROMUSER);
                info.setDccAddress(String.valueOf(this.dccAddressSpinner.getValue()));
                break;
            }
            default: {
                this.trainInfo.setTrainsFrom(DispatcherFrame.TrainsFrom.TRAINSFROMSETLATER);
                info.setTrainName("");
                info.setDccAddress("");
            }
        }
        info.setTrainUserName(this.trainNameField.getText());
        info.setTrainInTransit(this.inTransitBox.isSelected());
        info.setStartBlockName((String)this.startingBlockBox.getSelectedItem());
        index = this.startingBlockBox.getSelectedIndex();
        info.setStartBlockId(this.startingBlockBoxList.get(index).getDisplayName());
        if (info.getDynamicTransit()) {
            info.setStartBlockSeq(1);
        } else {
            info.setStartBlockSeq(this.startingBlockSeqList.get(index));
        }
        index = this.destinationBlockBox.getSelectedIndex();
        info.setDestinationBlockId(this.destinationBlockBoxList.get(index).getDisplayName());
        info.setDestinationBlockName(this.destinationBlockBoxList.get(index).getDisplayName());
        if (info.getDynamicTransit()) {
            info.setViaBlockName(this.viaBlockBoxList.get(this.viaBlockBox.getSelectedIndex()).getDisplayName());
        } else {
            info.setDestinationBlockSeq(this.destinationBlockSeqList.get(index));
        }
        info.setPriority((Integer)this.prioritySpinner.getValue());
        info.setTrainDetection(((TrainDetectionItem)this.trainDetectionComboBox.getSelectedItem()).value);
        info.setResetWhenDone(this.resetWhenDoneBox.isSelected());
        info.setReverseAtEnd(this.reverseAtEndBox.isSelected());
        info.setDelayedStart(this.delayModeFromBox(this.delayedStartBox));
        info.setDelaySensorName(this.delaySensor.getSelectedItemDisplayName());
        info.setResetStartSensor(this.resetStartSensorBox.isSelected());
        info.setDepartureTimeHr((Integer)this.departureHrSpinner.getValue());
        info.setDepartureTimeMin((Integer)this.departureMinSpinner.getValue());
        info.setTrainType((String)this.trainTypeBox.getSelectedItem());
        info.setAutoRun(this.autoRunBox.isSelected());
        info.setLoadAtStartup(this.loadAtStartupBox.isSelected());
        info.setAllocateAllTheWay(false);
        if (this.allocateAllTheWayRadioButton.isSelected()) {
            info.setAllocationMethod(-1);
        } else if (this.allocateBySafeRadioButton.isSelected()) {
            info.setAllocationMethod(0);
        } else {
            info.setAllocationMethod((Integer)this.allocateCustomSpinner.getValue());
        }
        info.setDelayedRestart(this.delayModeFromBox(this.delayedReStartBox));
        info.setRestartSensorName(this.delayReStartSensor.getSelectedItemDisplayName());
        info.setResetRestartSensor(this.resetRestartSensorBox.isSelected());
        info.setRestartDelayMin((Integer)this.delayMinSpinner.getValue());
        info.setReverseDelayedRestart(this.delayModeFromBox(this.reverseDelayedRestartType));
        info.setReverseRestartSensorName(this.delayReverseReStartSensor.getSelectedItemDisplayName());
        info.setReverseResetRestartSensor(this.delayReverseResetSensorBox.isSelected());
        info.setReverseRestartDelayMin((Integer)this.delayReverseMinSpinner.getValue());
        info.setTerminateWhenDone(this.terminateWhenDoneBox.isSelected());
        if (this.nextTrain.getSelectedIndex() > 0) {
            info.setNextTrain((String)this.nextTrain.getSelectedItem());
        } else {
            info.setNextTrain("None");
        }
        this.autoRunItemsToTrainInfo(info);
        return true;
    }

    private boolean setRosterComboBox(RosterEntryComboBox box, String txt) {
        boolean found = false;
        for (int i = 1; i < box.getItemCount(); ++i) {
            if (!txt.equals(((RosterEntry)box.getItemAt(i)).getId())) continue;
            box.setSelectedIndex(i);
            found = true;
            break;
        }
        if (!found && box.getItemCount() > 0) {
            box.setSelectedIndex(0);
        }
        return found;
    }

    private String normalizeXmlFileName(String name) {
        if (name.length() < 1) {
            return "";
        }
        String newName = name;
        if ((name.endsWith(".xml") || name.endsWith(".XML")) && (newName = name.substring(0, name.length() - 4)).length() < 1) {
            return "";
        }
        newName = newName.replaceAll("[\\W]", "_");
        return newName + ".xml";
    }

    private boolean setTrainComboBox(JComboBox<Object> box, String txt) {
        boolean found = false;
        for (int i = 1; i < box.getItemCount(); ++i) {
            if (!txt.equals(box.getItemAt(i).toString())) continue;
            box.setSelectedIndex(i);
            found = true;
            break;
        }
        if (!found && box.getItemCount() > 0) {
            box.setSelectedIndex(0);
        }
        return found;
    }

    private boolean setComboBox(JComboBox<String> box, String txt) {
        boolean found = false;
        for (int i = 0; i < box.getItemCount(); ++i) {
            if (!txt.equals(box.getItemAt(i))) continue;
            box.setSelectedIndex(i);
            found = true;
            break;
        }
        if (!found && box.getItemCount() > 0) {
            box.setSelectedIndex(0);
        }
        return found;
    }

    int delayModeFromBox(JComboBox<String> box) {
        String mode = (String)box.getSelectedItem();
        int result = StringUtil.getStateFromName(mode, this.delayedStartInt, this.delayedStartString);
        if (result < 0) {
            log.warn("unexpected mode string in turnoutMode: {}", (Object)mode);
            throw new IllegalArgumentException();
        }
        return result;
    }

    void setDelayModeBox(int mode, JComboBox<String> box) {
        String result = StringUtil.getNameFromState(mode, this.delayedStartInt, this.delayedStartString);
        box.setSelectedItem(result);
    }

    private void initializeAutoRunItems() {
        this.initializeRampCombo();
        this.initializeScaleLengthBox();
        this.pa1.setLayout(new FlowLayout());
        this.pa1.add(this.speedFactorLabel);
        this.speedFactorSpinner.setModel(new SpinnerNumberModel(Float.valueOf(1.0f), Float.valueOf(0.1f), Float.valueOf(2.0f), Float.valueOf(0.01f)));
        this.speedFactorSpinner.setEditor(new JSpinner.NumberEditor(this.speedFactorSpinner, "# %"));
        this.pa1.add(this.speedFactorSpinner);
        this.speedFactorSpinner.setToolTipText(Bundle.getMessage("SpeedFactorHint"));
        this.pa1.add(new JLabel("   "));
        this.pa1.add(this.maxSpeedLabel);
        this.maxSpeedSpinner.setModel(new SpinnerNumberModel(Float.valueOf(1.0f), Float.valueOf(0.1f), Float.valueOf(1.0f), Float.valueOf(0.01f)));
        this.maxSpeedSpinner.setEditor(new JSpinner.NumberEditor(this.maxSpeedSpinner, "# %"));
        this.pa1.add(this.maxSpeedSpinner);
        this.maxSpeedSpinner.setToolTipText(Bundle.getMessage("MaxSpeedHint"));
        this.pa1.add(this.minReliableOperatingSpeedLabel);
        this.minReliableOperatingSpeedSpinner.setModel(new SpinnerNumberModel(Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(1.0f), Float.valueOf(0.01f)));
        this.minReliableOperatingSpeedSpinner.setEditor(new JSpinner.NumberEditor(this.minReliableOperatingSpeedSpinner, "# %"));
        this.pa1.add(this.minReliableOperatingSpeedSpinner);
        this.minReliableOperatingSpeedSpinner.setToolTipText(Bundle.getMessage("MinReliableOperatingSpeedHint"));
        this.initiatePane.add(this.pa1);
        this.pa2.setLayout(new FlowLayout());
        this.pa2.add(this.rampRateLabel);
        this.pa2.add(this.rampRateBox);
        this.rampRateBox.setToolTipText(Bundle.getMessage("RampRateBoxHint"));
        this.pa2.add(this.useSpeedProfileLabel);
        this.pa2.add(this.useSpeedProfileCheckBox);
        this.useSpeedProfileCheckBox.setToolTipText(Bundle.getMessage("UseSpeedProfileHint"));
        this.initiatePane.add(this.pa2);
        this.pa2a.setLayout(new FlowLayout());
        this.pa2a.add(this.stopBySpeedProfileLabel);
        this.pa2a.add(this.stopBySpeedProfileCheckBox);
        this.stopBySpeedProfileCheckBox.setToolTipText(Bundle.getMessage("UseSpeedProfileHint"));
        this.pa2a.add(this.stopBySpeedProfileAdjustLabel);
        this.stopBySpeedProfileAdjustSpinner.setModel(new SpinnerNumberModel(Float.valueOf(1.0f), Float.valueOf(0.1f), Float.valueOf(5.0f), Float.valueOf(0.01f)));
        this.stopBySpeedProfileAdjustSpinner.setEditor(new JSpinner.NumberEditor(this.stopBySpeedProfileAdjustSpinner, "# %"));
        this.pa2a.add(this.stopBySpeedProfileAdjustSpinner);
        this.stopBySpeedProfileAdjustSpinner.setToolTipText(Bundle.getMessage("StopBySpeedProfileAdjustHint"));
        this.initiatePane.add(this.pa2a);
        this.pa3.setLayout(new FlowLayout());
        this.pa3.add(this.soundDecoderBox);
        this.soundDecoderBox.setToolTipText(Bundle.getMessage("SoundDecoderBoxHint"));
        this.pa3.add(new JLabel("   "));
        this.pa3.add(this.runInReverseBox);
        this.runInReverseBox.setToolTipText(Bundle.getMessage("RunInReverseBoxHint"));
        this.initiatePane.add(this.pa3);
        this.maxTrainLengthSpinner.setModel(new SpinnerNumberModel(Float.valueOf(18.0f), Float.valueOf(0.0f), Float.valueOf(10000.0f), Float.valueOf(0.5f)));
        this.maxTrainLengthSpinner.setEditor(new JSpinner.NumberEditor(this.maxTrainLengthSpinner, "###0.0"));
        this.maxTrainLengthSpinner.setToolTipText(Bundle.getMessage("MaxTrainLengthHint"));
        this.maxTrainLengthSpinner.addChangeListener(e -> this.handlemaxTrainLengthChangeUnitsLength());
        this.trainLengthUnitsComboBox.addActionListener(e -> this.handlemaxTrainLengthChangeUnitsLength());
        this.trainLengthAltLengthLabel = new JLabel();
        this.pa4.setLayout(new FlowLayout());
        this.pa4.add(this.trainLengthLabel);
        this.pa4.add(this.maxTrainLengthSpinner);
        this.pa4.add(this.trainLengthUnitsComboBox);
        this.pa4.add(this.trainLengthAltLengthLabel);
        this.initiatePane.add(this.pa4);
        this.hideAutoRunItems();
    }

    private void handlemaxTrainLengthChangeUnitsLength() {
        this.trainLengthAltLengthLabel.setText(this.maxTrainLengthCalculateAltFormatted(((TrainLengthUnitsItem)this.trainLengthUnitsComboBox.getSelectedItem()).getValue(), ((Float)this.maxTrainLengthSpinner.getValue()).floatValue()));
    }

    private String maxTrainLengthCalculateAltFormatted(ActiveTrain.TrainLengthUnits fromUnits, float fromValue) {
        float value = this.maxTrainLengthCalculateAlt(fromUnits, fromValue);
        switch (fromUnits) {
            case TRAINLENGTH_ACTUALINCHS: {
                return String.format(Locale.getDefault(), "%.2f %s", Float.valueOf(value), Bundle.getMessage("TrainLengthInScaleFeet"));
            }
            case TRAINLENGTH_ACTUALCM: {
                return String.format(Locale.getDefault(), "%.1f %s", Float.valueOf(value), Bundle.getMessage("TrainLengthInScaleMeters"));
            }
            case TRAINLENGTH_SCALEFEET: {
                return String.format(Locale.getDefault(), "%.1f %s", Float.valueOf(value), Bundle.getMessage("TrainLengthInActualInchs"));
            }
            case TRAINLENGTH_SCALEMETERS: {
                return String.format(Locale.getDefault(), "%.0f %s", Float.valueOf(value), Bundle.getMessage("TrainLengthInActualcm"));
            }
        }
        log.error("Invalid TrainLengthUnits must have been updated, fix maxTrainLengthCalculateAltFormatted");
        return "";
    }

    private float maxTrainLengthToScaleMeters(ActiveTrain.TrainLengthUnits fromUnits, float fromValue) {
        float value;
        switch (fromUnits) {
            case TRAINLENGTH_ACTUALINCHS: {
                value = fromValue / 12.0f * (float)this._dispatcher.getScale().getScaleRatio();
                value /= 3.28084f;
                break;
            }
            case TRAINLENGTH_ACTUALCM: {
                value = fromValue / 100.0f * (float)this._dispatcher.getScale().getScaleRatio();
                break;
            }
            case TRAINLENGTH_SCALEFEET: {
                value = fromValue / 3.28084f;
                break;
            }
            case TRAINLENGTH_SCALEMETERS: {
                value = fromValue;
                break;
            }
            default: {
                value = 0.0f;
                log.error("Invalid TrainLengthUnits has been updated, fix me");
            }
        }
        return value;
    }

    private float maxTrainLengthCalculateAlt(ActiveTrain.TrainLengthUnits fromUnits, float fromValue) {
        switch (fromUnits) {
            case TRAINLENGTH_ACTUALINCHS: {
                return (float)MathUtil.granulize(fromValue / 12.0f * (float)this._dispatcher.getScale().getScaleRatio(), (double)0.1f);
            }
            case TRAINLENGTH_ACTUALCM: {
                return fromValue / 100.0f * (float)this._dispatcher.getScale().getScaleRatio();
            }
            case TRAINLENGTH_SCALEFEET: {
                return fromValue * 12.0f * (float)this._dispatcher.getScale().getScaleFactor();
            }
            case TRAINLENGTH_SCALEMETERS: {
                return fromValue * 100.0f * (float)this._dispatcher.getScale().getScaleFactor();
            }
        }
        log.error("Invalid TrainLengthUnits has been updated, fix me");
        return 0.0f;
    }

    private void hideAutoRunItems() {
        this.pa1.setVisible(false);
        this.pa2.setVisible(false);
        this.pa2a.setVisible(false);
        this.pa3.setVisible(false);
        this.pa4.setVisible(false);
    }

    private void showAutoRunItems() {
        this.pa1.setVisible(true);
        this.pa2.setVisible(true);
        this.pa2a.setVisible(true);
        this.pa3.setVisible(true);
        this.pa4.setVisible(true);
    }

    private void autoTrainInfoToDialog(TrainInfo info) {
        this.speedFactorSpinner.setValue(info.getSpeedFactor());
        this.maxSpeedSpinner.setValue(info.getMaxSpeed());
        this.minReliableOperatingSpeedSpinner.setValue(Float.valueOf(info.getMinReliableOperatingSpeed()));
        this.setComboBox(this.rampRateBox, info.getRampRate());
        this.trainDetectionComboBox.setSelectedItemByValue(info.getTrainDetection());
        this.runInReverseBox.setSelected(info.getRunInReverse());
        this.soundDecoderBox.setSelected(info.getSoundDecoder());
        this.trainLengthUnitsComboBox.setSelectedItemByValue(info.getTrainLengthUnits());
        switch (info.getTrainLengthUnits()) {
            case TRAINLENGTH_SCALEFEET: {
                this.maxTrainLengthSpinner.setValue(Float.valueOf(info.getMaxTrainLengthScaleFeet()));
                break;
            }
            case TRAINLENGTH_SCALEMETERS: {
                this.maxTrainLengthSpinner.setValue(Float.valueOf(info.getMaxTrainLengthScaleMeters()));
                break;
            }
            case TRAINLENGTH_ACTUALINCHS: {
                this.maxTrainLengthSpinner.setValue(Float.valueOf(info.getMaxTrainLengthScaleFeet() * 12.0f * (float)this._dispatcher.getScale().getScaleFactor()));
                break;
            }
            case TRAINLENGTH_ACTUALCM: {
                this.maxTrainLengthSpinner.setValue(Float.valueOf(info.getMaxTrainLengthScaleMeters() * 100.0f * (float)this._dispatcher.getScale().getScaleFactor()));
                break;
            }
            default: {
                this.maxTrainLengthSpinner.setValue(Float.valueOf(0.0f));
            }
        }
        this.useSpeedProfileCheckBox.setSelected(info.getUseSpeedProfile());
        this.stopBySpeedProfileCheckBox.setSelected(info.getStopBySpeedProfile());
        this.stopBySpeedProfileAdjustSpinner.setValue(Float.valueOf(info.getStopBySpeedProfileAdjust()));
        if (this.autoRunBox.isSelected()) {
            this.showAutoRunItems();
        } else {
            this.hideAutoRunItems();
        }
        this.initiateFrame.pack();
    }

    private void autoRunItemsToTrainInfo(TrainInfo info) {
        info.setSpeedFactor(((Float)this.speedFactorSpinner.getValue()).floatValue());
        info.setMaxSpeed(((Float)this.maxSpeedSpinner.getValue()).floatValue());
        info.setMinReliableOperatingSpeed(((Float)this.minReliableOperatingSpeedSpinner.getValue()).floatValue());
        info.setRampRate((String)this.rampRateBox.getSelectedItem());
        info.setRunInReverse(this.runInReverseBox.isSelected());
        info.setSoundDecoder(this.soundDecoderBox.isSelected());
        info.setTrainLengthUnits(((TrainLengthUnitsItem)this.trainLengthUnitsComboBox.getSelectedItem()).getValue());
        info.setMaxTrainLengthScaleMeters(this.maxTrainLengthToScaleMeters(info.getTrainLengthUnits(), ((Float)this.maxTrainLengthSpinner.getValue()).floatValue()));
        if (this.useSpeedProfileCheckBox.isEnabled()) {
            info.setUseSpeedProfile(this.useSpeedProfileCheckBox.isSelected());
            info.setStopBySpeedProfile(this.stopBySpeedProfileCheckBox.isSelected());
            info.setStopBySpeedProfileAdjust(((Float)this.stopBySpeedProfileAdjustSpinner.getValue()).floatValue());
        } else {
            info.setUseSpeedProfile(false);
            info.setStopBySpeedProfile(false);
            info.setStopBySpeedProfileAdjust(1.0f);
        }
    }

    private void initializeRampCombo() {
        this.rampRateBox.removeAllItems();
        this.rampRateBox.addItem(Bundle.getMessage("RAMP_NONE"));
        this.rampRateBox.addItem(Bundle.getMessage("RAMP_FAST"));
        this.rampRateBox.addItem(Bundle.getMessage("RAMP_MEDIUM"));
        this.rampRateBox.addItem(Bundle.getMessage("RAMP_MED_SLOW"));
        this.rampRateBox.addItem(Bundle.getMessage("RAMP_SLOW"));
        this.rampRateBox.addItem(Bundle.getMessage("RAMP_SPEEDPROFILE"));
    }

    private void setAllocateMethodButtons(int value) {
        switch (value) {
            case 0: {
                this.allocateBySafeRadioButton.setSelected(true);
                this.allocateCustomSpinner.setVisible(false);
                break;
            }
            case -1: {
                this.allocateAllTheWayRadioButton.setSelected(true);
                this.allocateCustomSpinner.setVisible(false);
                break;
            }
            default: {
                this.allocateNumberOfBlocks.setSelected(true);
                this.allocateCustomSpinner.setVisible(true);
                this.allocateCustomSpinner.setValue(value);
            }
        }
    }

    private ArrayList<LayoutBlock> getOccupiedBlockList() {
        LayoutBlockManager lBM = InstanceManager.getDefault(LayoutBlockManager.class);
        ArrayList<LayoutBlock> lBlocks = new ArrayList<LayoutBlock>();
        for (LayoutBlock lB : lBM.getNamedBeanSet()) {
            if (lB.getBlock().getState() != 2) continue;
            lBlocks.add(lB);
        }
        return lBlocks;
    }

    private void initializeStartingBlockComboDynamic() {
        this.startingBlockBox.removeAllItems();
        this.startingBlockBoxList.clear();
        for (LayoutBlock lB : this.getOccupiedBlockList()) {
            if (this.startingBlockBoxList.contains(lB.getBlock())) continue;
            this.startingBlockBoxList.add(lB.getBlock());
            this.startingBlockBox.addItem(this.getBlockName(lB.getBlock()));
        }
        JComboBoxUtil.setupComboBoxMaxRows(this.startingBlockBox);
    }

    private void initializeViaBlockDynamicCombo() {
        LayoutBlock lBSrc;
        String prevValue = (String)this.viaBlockBox.getSelectedItem();
        this.viaBlockBox.removeActionListener(this.viaBlockBoxListener);
        this.viaBlockBox.removeAllItems();
        this.viaBlockBoxList.clear();
        LayoutBlockManager lBM = InstanceManager.getDefault(LayoutBlockManager.class);
        if (this.startingBlockBox.getSelectedItem() != null && this.startingBlockBox.getSelectedIndex() >= 0 && (lBSrc = (LayoutBlock)lBM.getByUserName((String)this.startingBlockBox.getSelectedItem())) != null) {
            for (int rX = lBSrc.getNumberOfNeighbours() - 1; rX > -1; --rX) {
                this.viaBlockBox.addItem(lBSrc.getNeighbourAtIndex(rX).getDisplayName());
                this.viaBlockBoxList.add(lBSrc.getNeighbourAtIndex(rX));
            }
        }
        if (prevValue != null) {
            this.viaBlockBox.setSelectedItem(prevValue);
        }
        this.viaBlockBox.addActionListener(this.viaBlockBoxListener);
    }

    private void initializeDestinationBlockDynamicCombo() {
        this.destinationBlockBox.removeAllItems();
        this.destinationBlockBoxList.clear();
        LayoutBlockManager lBM = InstanceManager.getDefault(LayoutBlockManager.class);
        if (this.startingBlockBox.getSelectedItem() != null && this.startingBlockBox.getSelectedIndex() >= 0 && this.viaBlockBox.getSelectedIndex() >= 0) {
            LayoutBlock lBSrc = (LayoutBlock)lBM.getByUserName((String)this.startingBlockBox.getSelectedItem());
            Block b = this.viaBlockBoxList.get(this.viaBlockBox.getSelectedIndex());
            if (lBSrc != null) {
                for (int rX = lBSrc.getNumberOfRoutes() - 1; rX > -1; --rX) {
                    if (lBSrc.getRouteNextBlockAtIndex(rX) != b) continue;
                    this.destinationBlockBox.addItem(lBSrc.getRouteDestBlockAtIndex(rX).getDisplayName());
                    this.destinationBlockBoxList.add(lBSrc.getRouteDestBlockAtIndex(rX));
                }
            }
        }
    }

    private boolean checkAdvancedRouting() {
        if (!InstanceManager.getDefault(LayoutBlockManager.class).isAdvancedRoutingEnabled()) {
            int response = JmriJOptionPane.showConfirmDialog(this, Bundle.getMessage("AdHocNeedsEnableBlockRouting"), Bundle.getMessage("AdHocNeedsBlockRouting"), 0);
            if (response == 0) {
                InstanceManager.getDefault(LayoutBlockManager.class).enableAdvancedRouting(true);
                JmriJOptionPane.showMessageDialog(this, Bundle.getMessage("AdhocNeedsBlockRoutingEnabled"));
            } else {
                return false;
            }
        }
        return true;
    }

    protected static class TrainLengthUnitsItem {
        private final String key;
        private ActiveTrain.TrainLengthUnits value;

        public TrainLengthUnitsItem(String text, ActiveTrain.TrainLengthUnits trainLength) {
            this.key = text;
            this.value = trainLength;
        }

        public String toString() {
            return this.key;
        }

        public String getKey() {
            return this.key;
        }

        public ActiveTrain.TrainLengthUnits getValue() {
            return this.value;
        }
    }

    protected static class TrainDetectionItem {
        private final String key;
        private ActiveTrain.TrainDetection value;

        public TrainDetectionItem(String text, ActiveTrain.TrainDetection trainDetection) {
            this.key = text;
            this.value = trainDetection;
        }

        public String toString() {
            return this.key;
        }

        public String getKey() {
            return this.key;
        }

        public ActiveTrain.TrainDetection getValue() {
            return this.value;
        }
    }

    protected static class TrainLengthUnitsJCombo
    extends JComboBox<TrainLengthUnitsItem> {
        protected TrainLengthUnitsJCombo() {
        }

        public void setSelectedItemByValue(ActiveTrain.TrainLengthUnits var) {
            for (int ix = 0; ix < this.getItemCount(); ++ix) {
                if (((TrainLengthUnitsItem)this.getItemAt((int)ix)).value != var) continue;
                this.setSelectedIndex(ix);
                break;
            }
        }
    }

    protected static class TrainDetectionJCombo
    extends JComboBox<TrainDetectionItem> {
        protected TrainDetectionJCombo() {
        }

        public void setSelectedItemByValue(ActiveTrain.TrainDetection trainDetVar) {
            for (int ix = 0; ix < this.getItemCount(); ++ix) {
                if (((TrainDetectionItem)this.getItemAt((int)ix)).value != trainDetVar) continue;
                this.setSelectedIndex(ix);
                break;
            }
        }
    }
}

