/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.dispatcher;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import jmri.Block;
import jmri.EntryPoint;
import jmri.InstanceManager;
import jmri.Section;
import jmri.Sensor;
import jmri.TransitSection;
import jmri.jmrit.dispatcher.ActiveTrain;
import jmri.jmrit.dispatcher.DispatcherFrame;
import jmri.jmrit.display.layoutEditor.LayoutTrackExpectedState;
import jmri.jmrit.display.layoutEditor.LayoutTurnout;
import jmri.util.ThreadingUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AllocatedSection {
    private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private Section mSection = null;
    private ActiveTrain mActiveTrain = null;
    private int mSequence = 0;
    private Section mNextSection = null;
    private int mNextSectionSequence = 0;
    private PropertyChangeListener mSectionListener = null;
    private boolean mEntered = false;
    private boolean mExited = false;
    private int mAllocationNumber = 0;
    private Sensor mForwardStoppingSensor = null;
    private Sensor mReverseStoppingSensor = null;
    private List<LayoutTrackExpectedState<LayoutTurnout>> autoTurnoutsResponse = null;
    private int mIndex = 0;
    private PropertyChangeListener mExitSignalListener = null;
    private final List<PropertyChangeListener> mBlockListeners = new ArrayList<PropertyChangeListener>();
    private List<Block> mBlockList = null;
    private final List<Block> mActiveBlockList = new ArrayList<Block>();
    private static final Logger log = LoggerFactory.getLogger(AllocatedSection.class);

    public AllocatedSection(@Nonnull Section s, ActiveTrain at, int seq, Section next, int nextSeqNo) {
        this.mSection = s;
        this.mActiveTrain = at;
        this.mSequence = seq;
        this.mNextSection = next;
        this.mNextSectionSequence = nextSeqNo;
        if (this.mSection.getOccupancy() == 2) {
            this.mEntered = true;
        }
        this.mSectionListener = e -> this.handleSectionChange(e);
        this.mSection.addPropertyChangeListener(this.mSectionListener);
        this.setStoppingSensors();
        if (this.mActiveTrain.getAutoActiveTrain() == null && !InstanceManager.getDefault(DispatcherFrame.class).getSupportVSDecoder()) {
            if (this.mActiveTrain.getReverseAtEnd() && (this.mSequence == this.mActiveTrain.getEndBlockSectionSequenceNumber() || this.mActiveTrain.getResetWhenDone() && this.mSequence == this.mActiveTrain.getStartBlockSectionSequenceNumber())) {
                this.initializeMonitorBlockOccupancy();
            } else if (this.mSequence == this.mActiveTrain.getEndBlockSectionSequenceNumber()) {
                this.initializeMonitorBlockOccupancy();
            }
        } else {
            this.initializeMonitorBlockOccupancy();
        }
    }

    public void setAutoTurnoutsResponse(List<LayoutTrackExpectedState<LayoutTurnout>> atr) {
        this.autoTurnoutsResponse = atr;
    }

    public float getLengthRemaining(Block block) {
        float length = 0.0f;
        if (this.mSection == null) {
            return length;
        }
        if (this.mSection.getState() == 4) {
            for (int ix = 0; ix < this.mSection.getNumBlocks(); ++ix) {
                Block b = this.mSection.getBlockBySequenceNumber(ix);
                if (b == null || !(length > 0.0f) && b != block) continue;
                length += b.getLengthMm();
            }
        } else if (this.mSection.getState() == 8) {
            for (int ix = this.mSection.getNumBlocks() - 1; ix > -1; --ix) {
                Block b = this.mSection.getBlockBySequenceNumber(ix);
                if (b == null || !(length > 0.0f) && b != block) continue;
                length += b.getLengthMm();
            }
        }
        log.debug("Remaining length in section[{}] is [{}]", (Object)this.mSection.getDisplayName(), (Object)Float.valueOf(length));
        return length;
    }

    public List<LayoutTrackExpectedState<LayoutTurnout>> getAutoTurnoutsResponse() {
        return this.autoTurnoutsResponse;
    }

    public Section getSection() {
        return this.mSection;
    }

    public String getSectionName() {
        String s = this.mSection.getDisplayName();
        return s;
    }

    public ActiveTrain getActiveTrain() {
        return this.mActiveTrain;
    }

    public String getActiveTrainName() {
        return this.mActiveTrain.getTrainName() + "/" + this.mActiveTrain.getTransitName();
    }

    public int getSequence() {
        return this.mSequence;
    }

    public Section getNextSection() {
        return this.mNextSection;
    }

    public int getNextSectionSequence() {
        return this.mNextSectionSequence;
    }

    protected boolean setNextSection(Section sec, int i) {
        if (sec == null) {
            this.mNextSection = null;
            this.mNextSectionSequence = i;
            return true;
        }
        if (this.mNextSection != null) {
            log.error("Next section is already set");
            return false;
        }
        this.mNextSection = sec;
        return true;
    }

    public void setNextSectionSequence(int i) {
        this.mNextSectionSequence = i;
    }

    public boolean getEntered() {
        return this.mEntered;
    }

    public boolean getExited() {
        return this.mExited;
    }

    public int getAllocationNumber() {
        return this.mAllocationNumber;
    }

    public void setAllocationNumber(int n) {
        this.mAllocationNumber = n;
    }

    public Sensor getForwardStoppingSensor() {
        return this.mForwardStoppingSensor;
    }

    public Sensor getReverseStoppingSensor() {
        return this.mReverseStoppingSensor;
    }

    public void setIndex(int i) {
        this.mIndex = i;
    }

    public int getIndex() {
        return this.mIndex;
    }

    public void setExitSignalListener(PropertyChangeListener xSigListener) {
        this.mExitSignalListener = xSigListener;
    }

    public PropertyChangeListener getExitSignalListener() {
        return this.mExitSignalListener;
    }

    protected final void setStoppingSensors() {
        if (this.mSection.getState() == 4) {
            this.mForwardStoppingSensor = this.mSection.getForwardStoppingSensor();
            this.mReverseStoppingSensor = this.mSection.getReverseStoppingSensor();
        } else {
            this.mForwardStoppingSensor = this.mSection.getReverseStoppingSensor();
            this.mReverseStoppingSensor = this.mSection.getForwardStoppingSensor();
        }
    }

    protected TransitSection getTransitSection() {
        return this.mActiveTrain.getTransit().getTransitSectionFromSectionAndSeq(this.mSection, this.mSequence);
    }

    public int getDirection() {
        return this.mSection.getState();
    }

    public int getActualLength() {
        return this.mSection.getActualLength();
    }

    public void reset() {
        this.mExited = false;
        this.mEntered = false;
        if (this.mSection.getOccupancy() == 2) {
            this.mEntered = true;
        }
    }

    private synchronized void handleSectionChange(PropertyChangeEvent e) {
        if (this.mSection.getOccupancy() == 2) {
            this.mEntered = true;
        } else if (this.mSection.getOccupancy() == 4 && this.mEntered) {
            this.mExited = true;
            if (InstanceManager.getDefault(DispatcherFrame.class).getExtraColorForAllocated()) {
                this.mSection.setAlternateColorFromActiveBlock(true);
            }
        }
        if (this.mActiveTrain.getAutoActiveTrain() != null) {
            if (e.getPropertyName().equals("state")) {
                this.mActiveTrain.getAutoActiveTrain().handleSectionStateChange(this);
            } else if (e.getPropertyName().equals("occupancy")) {
                this.mActiveTrain.getAutoActiveTrain().handleSectionOccupancyChange(this);
            }
        }
        InstanceManager.getDefault(DispatcherFrame.class).sectionOccupancyChanged();
    }

    public final synchronized void initializeMonitorBlockOccupancy() {
        if (this.mBlockList != null) {
            return;
        }
        this.mBlockList = this.mSection.getBlockList();
        for (int i = 0; i < this.mBlockList.size(); ++i) {
            Block b = this.mBlockList.get(i);
            if (b == null) continue;
            int index = i;
            PropertyChangeListener listener = e -> this.handleBlockChange(index, e);
            b.addPropertyChangeListener(listener);
            this.mBlockListeners.add(listener);
        }
    }

    private synchronized void handleBlockChange(int index, PropertyChangeEvent e) {
        if (e.getPropertyName().equals("state")) {
            Block b;
            if (this.mBlockList == null) {
                this.mBlockList = this.mSection.getBlockList();
            }
            if (!this.isInActiveBlockList(b = this.mBlockList.get(index))) {
                int occ = b.getState();
                RespondToBlockStateChange handleBlockChange = new RespondToBlockStateChange(b, occ, this);
                Thread tBlockChange = ThreadingUtil.newThread(handleBlockChange, "Allocated Section Block Change on " + b.getDisplayName());
                tBlockChange.start();
                this.addToActiveBlockList(b);
                if (InstanceManager.getDefault(DispatcherFrame.class).getSupportVSDecoder()) {
                    this.firePropertyChangeEvent("BlockStateChange", null, b.getSystemName());
                }
            }
        }
    }

    protected Block getExitBlock() {
        if (this.mNextSection == null) {
            return null;
        }
        EntryPoint ep = this.mSection.getExitPointToSection(this.mNextSection, this.mSection.getState());
        if (ep != null) {
            return ep.getBlock();
        }
        return null;
    }

    protected Block getEnterBlock(AllocatedSection previousAllocatedSection) {
        if (previousAllocatedSection == null) {
            return null;
        }
        Section sPrev = previousAllocatedSection.getSection();
        EntryPoint ep = this.mSection.getEntryPointFromSection(sPrev, this.mSection.getState());
        if (ep != null) {
            return ep.getBlock();
        }
        return null;
    }

    protected synchronized void addToActiveBlockList(Block b) {
        if (b != null) {
            this.mActiveBlockList.add(b);
        }
    }

    protected synchronized void removeFromActiveBlockList(Block b) {
        if (b != null) {
            for (int i = 0; i < this.mActiveBlockList.size(); ++i) {
                if (b != this.mActiveBlockList.get(i)) continue;
                this.mActiveBlockList.remove(i);
                return;
            }
        }
    }

    protected synchronized boolean isInActiveBlockList(Block b) {
        if (b != null) {
            for (int i = 0; i < this.mActiveBlockList.size(); ++i) {
                if (b != this.mActiveBlockList.get(i)) continue;
                return true;
            }
        }
        return false;
    }

    public synchronized void dispose() {
        if (this.mSectionListener != null && this.mSection != null) {
            this.mSection.removePropertyChangeListener(this.mSectionListener);
        }
        this.mSectionListener = null;
        for (int i = this.mBlockListeners.size(); i > 0; --i) {
            Block b = this.mBlockList.get(i - 1);
            b.removePropertyChangeListener(this.mBlockListeners.get(i - 1));
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    protected void firePropertyChangeEvent(PropertyChangeEvent evt) {
        this.pcs.firePropertyChange(evt);
    }

    protected void firePropertyChangeEvent(String name, Object oldVal, Object newVal) {
        this.pcs.firePropertyChange(name, oldVal, newVal);
    }

    class RespondToBlockStateChange
    implements Runnable {
        private Block _block = null;
        private int _occ = 0;
        private AllocatedSection _aSection = null;

        public RespondToBlockStateChange(Block b, int occ, AllocatedSection as) {
            this._block = b;
            this._aSection = as;
            this._occ = occ;
        }

        @Override
        public void run() {
            if (AllocatedSection.this.mActiveTrain.getAutoActiveTrain() != null) {
                AllocatedSection.this.mActiveTrain.getAutoActiveTrain().handleBlockStateChange(this._aSection, this._block);
            } else if (this._occ == 2 && !AllocatedSection.this.mActiveTrain.getAutoRun()) {
                if (this._block == AllocatedSection.this.mActiveTrain.getEndBlock() && AllocatedSection.this.mActiveTrain.getReverseAtEnd()) {
                    AllocatedSection.this.mActiveTrain.reverseAllAllocatedSections();
                    AllocatedSection.this.mActiveTrain.setRestart(AllocatedSection.this.mActiveTrain.getDelayReverseRestart(), AllocatedSection.this.mActiveTrain.getReverseRestartDelay(), AllocatedSection.this.mActiveTrain.getReverseRestartSensor(), AllocatedSection.this.mActiveTrain.getResetReverseRestartSensor());
                } else if (this._block == AllocatedSection.this.mActiveTrain.getStartBlock() && AllocatedSection.this.mActiveTrain.getResetWhenDone()) {
                    AllocatedSection.this.mActiveTrain.resetAllAllocatedSections();
                    AllocatedSection.this.mActiveTrain.setRestart(AllocatedSection.this.mActiveTrain.getDelayedRestart(), AllocatedSection.this.mActiveTrain.getRestartDelay(), AllocatedSection.this.mActiveTrain.getRestartSensor(), AllocatedSection.this.mActiveTrain.getResetRestartSensor());
                } else if (this._block == AllocatedSection.this.mActiveTrain.getEndBlock() || this._block == AllocatedSection.this.mActiveTrain.getStartBlock()) {
                    AllocatedSection.this.mActiveTrain.setStatus(64);
                }
            }
            AllocatedSection.this.removeFromActiveBlockList(this._block);
        }
    }
}

