/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.dispatcher;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.LinkedList;
import javax.annotation.CheckForNull;
import javax.swing.Timer;
import jmri.Block;
import jmri.BlockManager;
import jmri.DccLocoAddress;
import jmri.DccThrottle;
import jmri.EntryPoint;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.LocoAddress;
import jmri.NamedBean;
import jmri.Section;
import jmri.Sensor;
import jmri.SignalHead;
import jmri.SignalMast;
import jmri.SignalMastLogic;
import jmri.SignalMastLogicManager;
import jmri.ThrottleListener;
import jmri.Timebase;
import jmri.TransitSection;
import jmri.Turnout;
import jmri.implementation.SignalSpeedMap;
import jmri.jmrit.dispatcher.ActiveTrain;
import jmri.jmrit.dispatcher.AllocatedSection;
import jmri.jmrit.dispatcher.AutoTrainAction;
import jmri.jmrit.dispatcher.Bundle;
import jmri.jmrit.dispatcher.DispatcherFrame;
import jmri.jmrit.display.layoutEditor.LayoutBlockManager;
import jmri.jmrit.roster.RosterEntry;
import jmri.util.ThreadingUtil;
import jmri.util.swing.JmriJOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoActiveTrain
implements ThrottleListener {
    public static final int STOP_SPEED = 1;
    public static final int RESTRICTED_SPEED = 2;
    public static final int SLOW_SPEED = 3;
    public static final int MEDIUM_SPEED = 4;
    public static final int LIMITED_SPEED = 5;
    public static final int NORMAL_SPEED = 6;
    public static final int MAXIMUM_SPEED = 7;
    private final Float[] _speedRatio = new Float[]{Float.valueOf(-1.0f), Float.valueOf(0.0f), Float.valueOf(0.25f), Float.valueOf(0.35f), Float.valueOf(0.5f), Float.valueOf(0.65f), Float.valueOf(0.8f), Float.valueOf(1.15f)};
    public static final int RAMP_NONE = 0;
    public static final int RAMP_FAST = 1;
    public static final int RAMP_MEDIUM = 2;
    public static final int RAMP_MED_SLOW = 3;
    public static final int RAMP_SLOW = 4;
    public static final int RAMP_SPEEDPROFILE = 5;
    public static final int NO_TASK = 0;
    public static final int END_REVERSAL = 1;
    public static final int BEGINNING_RESET = 2;
    public static final int END_TRAIN = 4;
    private static final NamedBean.DisplayOptions USERSYS = NamedBean.DisplayOptions.USERNAME_SYSTEMNAME;
    private ActiveTrain _activeTrain = null;
    private AutoTrainAction _autoTrainAction = null;
    private DccThrottle _throttle = null;
    private AutoEngineer _autoEngineer = null;
    private int _address = -1;
    private int _savedStatus = 1;
    private int _currentRampRate = 0;
    private boolean _pausingActive = false;
    private DispatcherFrame _dispatcher;
    private int _rampRate = 0;
    private float _speedFactor = 1.0f;
    private float _maxSpeed = 1.0f;
    private float _minReliableOperatingSpeed = 0.0f;
    private boolean _runInReverse = false;
    private boolean _soundDecoder = false;
    private long _MaxTrainLength = 600L;
    private float _stopBySpeedProfileAdjust = 1.0f;
    private boolean _stopBySpeedProfile = false;
    private boolean _useSpeedProfileRequested = true;
    private RosterEntry re = null;
    boolean useSpeedProfile = false;
    private LayoutBlockManager _lbManager = null;
    private AllocatedSection _lastAllocatedSection = null;
    private boolean _initialized = false;
    private Section _nextSection = null;
    private volatile AllocatedSection _currentAllocatedSection = null;
    private volatile AllocatedSection _previousAllocatedSection = null;
    private SignalHead _controllingSignal = null;
    private SignalMast _controllingSignalMast = null;
    private SignalHead _controllingSignalPrev = null;
    private SignalMast _controllingSignalMastPrev = null;
    private PropertyChangeListener _conSignalListener = null;
    private PropertyChangeListener _conSignalMastListener = null;
    private Block _conSignalProtectedBlock = null;
    private volatile Block _currentBlock = null;
    private Block _nextBlock = null;
    private volatile Block _previousBlock = null;
    private boolean _stoppingBySensor = false;
    private Sensor _stopSensor = null;
    private PropertyChangeListener _stopSensorListener = null;
    private PropertyChangeListener _turnoutStateListener = null;
    private boolean _stoppingByBlockOccupancy = false;
    private boolean _stoppingUsingSpeedProfile = false;
    private volatile Block _stoppingBlock = null;
    private boolean _resumingAutomatic = false;
    private boolean _needSetSpeed = false;
    private boolean waitingOnAllocation = false;
    private float _savedSpeed = 0.0f;
    private boolean _savedForward = true;
    private boolean _useStopSensor = true;
    private int _activeHornThreads = 0;
    float prevSpeed = -1.0f;
    private static final Logger log = LoggerFactory.getLogger(AutoActiveTrain.class);

    public AutoActiveTrain(ActiveTrain at) {
        this._activeTrain = at;
        at.setAutoActiveTrain(this);
        this._autoTrainAction = new AutoTrainAction(this);
        this._lbManager = InstanceManager.getDefault(LayoutBlockManager.class);
        at.addPropertyChangeListener("sectionallocated", this::handleAnotherSectionAllocatedChange);
    }

    public ActiveTrain getActiveTrain() {
        return this._activeTrain;
    }

    public AutoEngineer getAutoEngineer() {
        return this._autoEngineer;
    }

    public AutoTrainAction getAutoTrainAction() {
        return this._autoTrainAction;
    }

    public RosterEntry getRosterEntry() {
        return this.re;
    }

    public boolean getForward() {
        return this._autoEngineer.getIsForward();
    }

    public void setForward(boolean set) {
        this._autoEngineer.setIsForward(set);
    }

    public synchronized float getTargetSpeed() {
        return this._autoEngineer.getTargetSpeed();
    }

    public synchronized void setTargetSpeedByPass(float speed) {
        this._autoEngineer.setTargetSpeed(speed);
    }

    public synchronized void setTargetSpeed(float speed) {
        if (this._autoEngineer.isStopped() && this.getTargetSpeed() == 0.0f && speed > 0.0f && this._autoTrainAction.isDelayedStart(speed)) {
            return;
        }
        this._autoEngineer.setTargetSpeed(speed);
    }

    public int getSavedStatus() {
        return this._savedStatus;
    }

    public void setSavedStatus(int status) {
        this._savedStatus = status;
    }

    public synchronized void setCurrentRampRate(int rate) {
        this._currentRampRate = rate;
    }

    public int getRampRate() {
        return this._rampRate;
    }

    public void setRampRate(int rate) {
        this._rampRate = rate;
        this._currentRampRate = rate;
    }

    public float getSpeedFactor() {
        return this._speedFactor;
    }

    public void setSpeedFactor(float factor) {
        this._speedFactor = factor;
    }

    public float getMaxSpeed() {
        return this._maxSpeed;
    }

    public void setMaxSpeed(float speed) {
        this._maxSpeed = speed;
    }

    public float getMinReliableOperatingSpeed() {
        return this._minReliableOperatingSpeed;
    }

    public void setMinReliableOperatingSpeed(float speed) {
        this._minReliableOperatingSpeed = speed;
    }

    @Deprecated(since="5.7.6", forRemoval=true)
    public void setResistanceWheels(boolean set) {
        if (set) {
            this._activeTrain.setTrainDetection(ActiveTrain.TrainDetection.TRAINDETECTION_WHOLETRAIN);
        } else {
            this._activeTrain.setTrainDetection(ActiveTrain.TrainDetection.TRAINDETECTION_HEADONLY);
        }
    }

    public boolean getRunInReverse() {
        return this._runInReverse;
    }

    public void setRunInReverse(boolean set) {
        this._runInReverse = set;
    }

    public boolean getSoundDecoder() {
        return this._soundDecoder;
    }

    public void setSoundDecoder(boolean set) {
        this._soundDecoder = set;
    }

    public long getMaxTrainLengthMM() {
        return this._MaxTrainLength;
    }

    public void setMaxTrainLength(double length, double scaleFactor) {
        this._MaxTrainLength = (long)(length * 1000.0 * scaleFactor);
        log.trace("setMaxTrainLength[{}]", (Object)this._MaxTrainLength);
    }

    public void setUseSpeedProfile(boolean tf) {
        this._useSpeedProfileRequested = tf;
    }

    public boolean getUseSpeedProfile() {
        return this._useSpeedProfileRequested;
    }

    public void setStopBySpeedProfile(boolean tf) {
        this._stopBySpeedProfile = tf;
    }

    public void setStopBySpeedProfileAdjust(float adjust) {
        this._stopBySpeedProfileAdjust = adjust;
    }

    public boolean getStopBySpeedProfile() {
        return this._stopBySpeedProfile;
    }

    public float getStopBySpeedProfileAdjust() {
        return this._stopBySpeedProfileAdjust;
    }

    public String getCurrentSignal() {
        if (this._activeTrain.getSignalType() == 0) {
            return this._controllingSignal == null ? "" : this._controllingSignal.getDisplayName();
        }
        return this._controllingSignalMast == null ? "" : this._controllingSignalMast.getDisplayName();
    }

    public String getCurrentSignalUserName() {
        if (this._activeTrain.getSignalType() == 0) {
            return this._controllingSignal == null || this._controllingSignal.getUserName() == null ? "" : this._controllingSignal.getUserName();
        }
        return this._controllingSignalMast == null || this._controllingSignalMast.getUserName() == null ? "" : this._controllingSignalMast.getUserName();
    }

    public boolean initialize() {
        boolean ok;
        this._pausingActive = false;
        this._stoppingBySensor = false;
        this._stoppingByBlockOccupancy = false;
        this._stoppingUsingSpeedProfile = false;
        this._dispatcher = InstanceManager.getDefault(DispatcherFrame.class);
        try {
            this._address = Integer.parseInt(this._activeTrain.getDccAddress());
        }
        catch (NumberFormatException ex) {
            log.warn("invalid dcc address '{}' for {}", (Object)this._activeTrain.getDccAddress(), (Object)this._activeTrain.getTrainName());
            return false;
        }
        if (this._address < 1 || this._address > 9999) {
            log.warn("invalid dcc address '{}' for {}", (Object)this._activeTrain.getDccAddress(), (Object)this._activeTrain.getTrainName());
            return false;
        }
        this.useSpeedProfile = false;
        DccLocoAddress addressForRequest = new DccLocoAddress(this._address, !InstanceManager.throttleManagerInstance().canBeShortAddress(this._address));
        if (this._activeTrain.getTrainSource() == 1) {
            if (this._activeTrain.getRosterEntry() != null) {
                this.re = this._activeTrain.getRosterEntry();
                ok = InstanceManager.throttleManagerInstance().requestThrottle(this.re, (ThrottleListener)this, false);
                if (this._useSpeedProfileRequested && this.re.getSpeedProfile() != null && this.re.getSpeedProfile().getProfileSize() > 0) {
                    this.useSpeedProfile = true;
                }
                log.debug("{}: requested roster entry '{}', address={}, use speed profile requested={} usespeedprofile set={}", new Object[]{this._activeTrain.getTrainName(), this.re.getId(), this._address, this._useSpeedProfileRequested, this.useSpeedProfile});
            } else {
                ok = InstanceManager.throttleManagerInstance().requestThrottle(addressForRequest, (ThrottleListener)this, false);
                log.debug("{}: requested throttle address={}, roster entry not found", (Object)this._activeTrain.getTrainName(), (Object)this._address);
            }
        } else {
            ok = InstanceManager.throttleManagerInstance().requestThrottle(addressForRequest, (ThrottleListener)this, false);
            log.debug("{}: requested throttle address={}", (Object)this._activeTrain.getTrainName(), (Object)this._address);
        }
        if (!ok) {
            log.warn("Throttle for locomotive address {} could not be setup.", (Object)this._address);
            this._activeTrain.setMode(8);
            return false;
        }
        return true;
    }

    @Override
    public void notifyThrottleFound(DccThrottle t) {
        this._throttle = t;
        if (this._throttle == null) {
            JmriJOptionPane.showMessageDialog(null, MessageFormat.format(Bundle.getMessage("Error28"), this._activeTrain.getTrainName()), Bundle.getMessage("MessageTitle"), 1);
            log.warn("null throttle returned for train '{}' during automatic initialization.", (Object)this._activeTrain.getTrainName());
            this._activeTrain.setMode(8);
            return;
        }
        log.debug("{}: New AutoEngineer, address={}, length (mm)={}, factor={}, useSpeedProfile={}", new Object[]{this._activeTrain.getTrainName(), this._throttle.getLocoAddress(), this.getMaxTrainLengthMM(), Float.valueOf(this._speedFactor), this.useSpeedProfile});
        ThreadingUtil.runOnLayoutDelayed(() -> {
            if (this._autoEngineer != null) {
                log.error("Second Trottle for same loco[{}] - ignoring", (Object)this._address);
                this.setEngineDirection();
            } else {
                this._autoEngineer = new AutoEngineer(t, this.re);
                this._activeTrain.setMode(2);
                this.setEngineDirection();
                this._autoEngineer.setRamping(this._currentRampRate, this._dispatcher.getFullRampTime(), this._dispatcher.getMinThrottleInterval(), this._currentRampRate);
                this._autoEngineer.setSpeedLimits(this._minReliableOperatingSpeed, this._maxSpeed, this._speedFactor);
            }
            if (this._resumingAutomatic) {
                this._resumingAutomatic = false;
                this._activeTrain.setStatus(1);
                this.setupNewCurrentSignal(null, true);
                if (!this.isCurrentSignal()) {
                    this.restoreSavedSpeedAndDirection();
                } else {
                    this.setSpeedBySignal();
                }
            } else if (this._dispatcher.getAutoAllocate() && this._currentAllocatedSection != null) {
                this.setSpeedBySignal();
            }
        }, 500);
    }

    protected DccThrottle getThrottle() {
        return this._throttle;
    }

    @Override
    public void notifyFailedThrottleRequest(LocoAddress address, String reason) {
        log.error("Throttle request failed for {} because {}", (Object)address, (Object)reason);
    }

    @Override
    public void notifyDecisionRequired(LocoAddress address, ThrottleListener.DecisionType question) {
    }

    protected Section getLastAllocatedSection() {
        Section as = this._activeTrain.getLastAllocatedSection();
        return as;
    }

    public void set_useStopSensor(boolean _useStopSensor) {
        this._useStopSensor = _useStopSensor;
    }

    protected void saveSpeedAndDirection() {
        this._savedSpeed = this._autoEngineer.getTargetSpeed();
        this._savedForward = this._autoEngineer.getIsForward();
    }

    protected void restoreSavedSpeedAndDirection() {
        this._autoEngineer.setTargetSpeed(this._savedSpeed);
        this._autoEngineer.setIsForward(this._savedForward);
    }

    protected void decrementHornExecution() {
        --this._activeHornThreads;
    }

    protected void incrementHornExecution() {
        ++this._activeHornThreads;
    }

    protected void handleSectionStateChange(AllocatedSection as) {
        if (!this._activeTrain.isInAllocatedList(as)) {
            this.addAllocatedSection(as);
        }
    }

    private void handleAnotherSectionAllocatedChange(PropertyChangeEvent evt) {
        if (this.waitingOnAllocation || this._activeTrain.getSignalType() == 2) {
            this.waitingOnAllocation = false;
            this.setSpeedBySignal();
        }
    }

    protected void handleSectionOccupancyChange(AllocatedSection as) {
        TransitSection ts;
        if (!this._activeTrain.isInAllocatedList(as)) {
            log.debug("Unexpected occupancy change notification - Section {}", (Object)as.getSection().getDisplayName(USERSYS));
            return;
        }
        if (as.getSection().getOccupancy() == 2) {
            if (as.getSection() == this._nextSection) {
                this.setNewCurrentSection(as);
            }
        } else if (as.getSection().getOccupancy() == 4 && (ts = as.getTransitSection()) != null) {
            this._autoTrainAction.removeTransitSection(ts);
        }
    }

    @SuppressFBWarnings(value={"IS2_INCONSISTENT_SYNC"}, justification="OK to not sync here, no conflict expected")
    protected void handleBlockStateChange(AllocatedSection as, Block b) {
        if (b.getState() == 2) {
            log.debug("{}: handleBlockStateChange to OCCUPIED section {}, block {}, length {}", new Object[]{this._activeTrain.getTrainName(), as.getSection().getDisplayName(USERSYS), b.getDisplayName(USERSYS), this.getBlockLength(b)});
            if (b == this._nextBlock || this._nextBlock == null) {
                this._currentBlock = b;
                if (!this._activeTrain.isTransitReversed() && as.getSequence() == this._activeTrain.getEndBlockSectionSequenceNumber()) {
                    if (this._activeTrain.getReverseAtEnd()) {
                        this.removeCurrentSignal();
                        this.stopInCurrentSection(1);
                    } else if (this._activeTrain.getResetWhenDone() && this._activeTrain.getDelayedRestart() == 0) {
                        this._activeTrain.setRestart(this._activeTrain.getDelayedRestart(), this._activeTrain.getRestartDelay(), this._activeTrain.getRestartSensor(), this._activeTrain.getResetRestartSensor());
                        this._activeTrain.setTransitReversed(false);
                        this._activeTrain.resetAllAllocatedSections();
                        this._previousBlock = null;
                        this._nextBlock = this.getNextBlock(this._currentBlock, this._currentAllocatedSection);
                        this.setEngineDirection();
                        if (this._nextSection != null && !this._activeTrain.isInAllocatedList(this._nextSection)) {
                            this._dispatcher.queueScanOfAllocationRequests();
                        }
                        this.setupNewCurrentSignal(null, true);
                        this.setSpeedBySignal();
                    } else if (this._activeTrain.getResetWhenDone()) {
                        this.removeCurrentSignal();
                        this.stopInCurrentSection(2);
                    } else {
                        log.debug("{}: Trip end, stop in Current Section, Block= {}", (Object)this._activeTrain.getTrainName(), (Object)b.getDisplayName(USERSYS));
                        this.removeCurrentSignal();
                        this.stopInCurrentSection(4);
                    }
                } else if (this._activeTrain.isTransitReversed() && as.getSequence() == this._activeTrain.getStartBlockSectionSequenceNumber()) {
                    if (this._activeTrain.getResetWhenDone() && this._activeTrain.isTransitReversed()) {
                        this.removeCurrentSignal();
                        this.stopInCurrentSection(2);
                    } else {
                        log.debug("{}: Trip end, stop in Current Section, Block= {}", (Object)this._activeTrain.getTrainName(), (Object)b.getDisplayName(USERSYS));
                        this.removeCurrentSignal();
                        this.stopInCurrentSection(4);
                    }
                } else {
                    this._nextBlock = this.getNextBlock(b, as);
                    if (this._nextBlock != null) {
                        this._previousBlock = this._currentBlock;
                        this._nextBlock = this.getNextBlock(b, as);
                        this.setupNewCurrentSignal(as, false);
                    } else {
                        log.warn("{}: No next Block from Block= {} Section= {}", new Object[]{this._activeTrain.getTrainName(), b.getDisplayName(USERSYS), as.getSection().getDisplayName(USERSYS)});
                        this.removeCurrentSignal();
                        this.stopInCurrentSection(0);
                    }
                }
            } else if (b != this._currentBlock) {
                log.trace("{}: block going occupied {} is not _nextBlock or _currentBlock - ignored.", (Object)this._activeTrain.getTrainName(), (Object)b.getDisplayName(USERSYS));
                return;
            }
        } else if (b.getState() == 4) {
            log.debug("{}: handleBlockStateChange to UNOCCUPIED - Section {}, Block {}, speed {}", new Object[]{this._activeTrain.getTrainName(), as.getSection().getDisplayName(USERSYS), b.getDisplayName(USERSYS), this._autoEngineer == null ? "" : Float.valueOf(this.getTargetSpeed())});
            if (this._stoppingByBlockOccupancy && b == this._stoppingBlock) {
                log.trace("{}: setStopNow by block occupancy from Block unoccupied, Block= {}", (Object)this._activeTrain.getTrainName(), (Object)b.getDisplayName(USERSYS));
                this._stoppingByBlockOccupancy = false;
                this._stoppingBlock = null;
                if (this._needSetSpeed) {
                    this._needSetSpeed = false;
                    this.setSpeedBySignal();
                } else {
                    this.setStopNow();
                }
            }
        }
        this._autoTrainAction.handleBlockStateChange(as, b);
    }

    protected void setEngineDirection() {
        boolean oldFwd = this.getForward();
        if (this._runInReverse) {
            this.setForward(this._activeTrain.isTransitReversed());
        } else {
            this.setForward(!this._activeTrain.isTransitReversed());
        }
        log.debug("[{}]flipping direction was [{}] now [{}]", new Object[]{this._activeTrain.getActiveTrainName(), oldFwd, this.getForward()});
    }

    protected AllocatedSection getCurrentAllocatedSection() {
        return this._currentAllocatedSection;
    }

    protected AllocatedSection getAllocatedSectionForSection(Section s) {
        for (AllocatedSection allocatedSection : this._activeTrain.getAllocatedSectionList()) {
            if (allocatedSection.getSection() != s) continue;
            return allocatedSection;
        }
        return null;
    }

    protected void allocateAFresh() {
        this._initialized = false;
        this._currentAllocatedSection = null;
        this._currentBlock = null;
        this.setForward(!this.getRunInReverse());
    }

    private void addAllocatedSection(AllocatedSection as) {
        if (!this._initialized) {
            this._initialized = true;
            this._nextSection = as.getSection();
            this._currentBlock = this._activeTrain.getStartBlock();
            if (as.getSection().containsBlock(this._currentBlock)) {
                this.setNewCurrentSection(as);
                this._nextBlock = this.getNextBlock(this._currentBlock, as);
            } else if (as.getSection().connectsToBlock(this._currentBlock)) {
                EntryPoint ep = as.getSection().getEntryPointFromBlock(this._currentBlock, as.getDirection());
                if (ep != null) {
                    this._nextBlock = ep.getBlock();
                } else {
                    log.error("failure to get entry point to Transit from Block {}", (Object)this._currentBlock.getDisplayName(USERSYS));
                }
            }
            if (this._nextBlock != null) {
                this.setupNewCurrentSignal(as, true);
            }
        }
        if (!this._pausingActive && this._lastAllocatedSection == this._currentAllocatedSection && this.isStopping() && this._activeTrain.getStatus() == 1) {
            this._needSetSpeed = true;
        }
        if (!(this._dispatcher.getAutoAllocate() || this._lastAllocatedSection != null && this._lastAllocatedSection.getNextSection() != as.getSection())) {
            this._lastAllocatedSection = as;
            if (as.getNextSection() != null) {
                Section nSection = as.getNextSection();
                int nextSeq = as.getNextSectionSequence();
                int nextDir = this._activeTrain.getAllocationDirectionFromSectionAndSeq(nSection, nextSeq);
                this._dispatcher.requestAllocation(this._activeTrain, nSection, nextDir, nextSeq, true, null);
            }
        }
    }

    private boolean isStopping() {
        return this._stoppingBySensor || this._stoppingByBlockOccupancy || this._stoppingUsingSpeedProfile;
    }

    private void removeCurrentSignal() {
        if (this._conSignalListener != null) {
            this._controllingSignal.removePropertyChangeListener(this._conSignalListener);
            this._conSignalListener = null;
        }
        this._controllingSignalPrev = this._controllingSignal;
        this._controllingSignal = null;
        if (this._conSignalMastListener != null) {
            this._controllingSignalMast.removePropertyChangeListener(this._conSignalMastListener);
            this._conSignalMastListener = null;
        }
        this._controllingSignalMastPrev = this._controllingSignalMast;
        this._controllingSignalMast = null;
        this._needSetSpeed = false;
    }

    protected boolean isCurrentSignal() {
        if (this._activeTrain.getSignalType() == 0) {
            return this._controllingSignal != null;
        }
        return this._controllingSignalMast != null;
    }

    protected synchronized void setupNewCurrentSignal(AllocatedSection as, boolean forceSpeedChange) {
        log.trace("setupNewCurrentSignal Called Section[{}] forceSpeedChange[{}]", (Object)(as != null ? as.getSectionName() : "null"), (Object)forceSpeedChange);
        this.removeCurrentSignal();
        if (this._activeTrain.getSignalType() == 0) {
            SignalHead sh = this._lbManager.getFacingSignalHead(this._currentBlock, this._nextBlock);
            if (sh != null) {
                this._controllingSignal = sh;
                this._conSignalProtectedBlock = this._nextBlock;
                this._conSignalListener = e -> {
                    if (e.getPropertyName().equals("Appearance")) {
                        this.setSpeedBySignal();
                    }
                };
                sh.addPropertyChangeListener(this._conSignalListener);
                this._activeTrain.setControlingSignal(this._controllingSignal, this._controllingSignalPrev);
                log.debug("new current signal = {}", (Object)sh.getDisplayName(USERSYS));
            } else {
                log.warn("new current signal is null - sometimes OK");
            }
            this.setSpeedBySignal();
        } else if (this._activeTrain.getSignalType() == 1) {
            SignalMast sm = null;
            Block cB = this._currentBlock;
            Block nB = this._nextBlock;
            if (as == null) {
                as = this._currentAllocatedSection;
            }
            boolean weAreAtSpeedChangingMast = forceSpeedChange;
            if (!forceSpeedChange && nB != null && (sm = this._lbManager.getFacingSignalMast(cB, nB)) != null) {
                weAreAtSpeedChangingMast = true;
            }
            while (sm == null && nB != null) {
                sm = this._lbManager.getFacingSignalMast(cB, nB);
                if (sm != null) continue;
                cB = nB;
                nB = this.getNextBlock(nB, as);
            }
            if (sm != null) {
                this._controllingSignalMast = sm;
                this._conSignalProtectedBlock = nB;
                this._conSignalMastListener = e -> {
                    if (e.getPropertyName().equals("Aspect") || e.getPropertyName().equals("Held")) {
                        this.setSpeedBySignal();
                    }
                };
                sm.addPropertyChangeListener(this._conSignalMastListener);
                this._activeTrain.setControlingSignal(this._controllingSignalMast, this._controllingSignalMastPrev);
                log.debug("{}: new current signalmast {}({}) for section {}", new Object[]{this._activeTrain.getTrainName(), sm.getDisplayName(USERSYS), sm.getAspect(), as.getSection().getDisplayName(USERSYS)});
                if (weAreAtSpeedChangingMast) {
                    this.setSpeedBySignal();
                } else {
                    this.checkForGhost();
                }
            } else {
                log.debug("{}: new current signalmast is null for section {} - sometimes OK", (Object)this._activeTrain.getTrainName(), (Object)(as == null ? "Null" : as.getSection().getDisplayName(USERSYS)));
                if (this._nextBlock == null || !this._activeTrain.getBlockList().contains(this._nextBlock) || this._autoEngineer.isStopped()) {
                    log.warn("{}: new current signalmast is null for section {} and next block is not this trains. Temporarily continuing by allocations", (Object)this._activeTrain.getTrainName(), (Object)(as == null ? "Null" : as.getSection().getDisplayName(USERSYS)));
                    this.setSpeedBySectionsAllocated();
                }
                this.checkForGhost();
            }
        } else {
            this.setSpeedBySignal();
        }
    }

    @CheckForNull
    private Block getNextBlock(Block b, AllocatedSection as) {
        EntryPoint ep;
        if (this._currentBlock == this._activeTrain.getStartBlock() && this._activeTrain.getResetWhenDone() && this._activeTrain.isTransitReversed() && as.getSequence() == this._activeTrain.getStartBlockSectionSequenceNumber()) {
            return this._previousBlock;
        }
        if (as.getNextSection() != null && (ep = as.getSection().getExitPointToSection(this._nextSection, as.getDirection())) != null && ep.getBlock() == b) {
            return ep.getFromBlock();
        }
        Block blk = as.getSection().getEntryBlock();
        while (blk != null) {
            if (b == blk) {
                return as.getSection().getNextBlock();
            }
            blk = as.getSection().getNextBlock();
        }
        return null;
    }

    private void setNewCurrentSection(AllocatedSection as) {
        if (as.getSection() == this._nextSection) {
            this._previousAllocatedSection = this._currentAllocatedSection;
            this._currentAllocatedSection = as;
            this._nextSection = as.getNextSection();
            TransitSection ts = as.getTransitSection();
            if (ts != null) {
                this._autoTrainAction.addTransitSection(ts);
            }
            boolean nextSectionExpected = true;
            if (ts != null && ts.isSafe() && this._activeTrain.getAllocateMethod() == 0) {
                nextSectionExpected = false;
            } else if (!this._activeTrain.isAllocationReversed() && this._activeTrain.getEndBlockSection() == this._currentAllocatedSection.getSection()) {
                nextSectionExpected = false;
            } else if (this._activeTrain.isAllocationReversed() && this._activeTrain.getStartBlockSectionSequenceNumber() == this._currentAllocatedSection.getSequence()) {
                nextSectionExpected = false;
            }
            log.debug("{}:Next Section Expected[{}]", (Object)this._activeTrain.getActiveTrainName(), (Object)nextSectionExpected);
            if (ts != null && ts.isSafe() && this._activeTrain.getAllocateMethod() == 0) {
                this._dispatcher.queueScanOfAllocationRequests();
            }
        }
    }

    protected synchronized void setSpeedBySignal() {
        log.trace("Set Speed by Signal");
        if (this._pausingActive || this._activeTrain.getStatus() != 1 && this._activeTrain.getStatus() != 4 && !this._activeTrain.getStarted() || this._activeTrain.getMode() != 2) {
            log.trace("Skip Set Speed By Signal");
            return;
        }
        if (this.checkAllocationsAhead() && this.checkTurn(this.getAllocatedSectionForSection(this._nextSection))) {
            if (this._activeTrain.getSignalType() == 0 && this._controllingSignal != null) {
                this.setSpeedBySignalHead();
            } else if (this._activeTrain.getSignalType() == 1 && this._controllingSignalMast != null) {
                this.setSpeedBySignalMast();
            } else {
                log.trace("{}:Set Speed by BlocksAllocated", (Object)this._activeTrain.getActiveTrainName());
                this.setSpeedBySectionsAllocated();
            }
            this.checkForGhost();
        } else if (this._currentAllocatedSection != null && this._currentAllocatedSection.getNextSection() == null) {
            this.stopInCurrentSection(4);
        } else {
            this.stopInCurrentSection(0);
            log.debug("{}:Set Stop", (Object)this._activeTrain.getActiveTrainName());
            this.waitingOnAllocation = true;
        }
    }

    private void checkForGhost() {
        if (this.getTargetSpeed() != 0.0f && !this.isStopping() && this._nextBlock != null && this._currentBlock != null && this._nextBlock.getSensor() != null && this._nextBlock.getIsGhost()) {
            if (this._currentBlock.getIsGhost()) {
                log.error("Stopping due to two consecutive no sensor blocks [{}], [{}]", (Object)this._currentBlock.getDisplayName(), (Object)this._nextBlock.getDisplayName());
            } else {
                try {
                    this._currentBlock.addPropertyChangeListener(new DarkTerritoryListener(this._nextBlock.getSensor()));
                    this._nextBlock.getSensor().setKnownState(2);
                }
                catch (JmriException ex) {
                    log.error("Error entering darkterratory");
                }
            }
        }
    }

    private boolean checkAllocationsAhead() {
        if (this._nextSection != null) {
            for (AllocatedSection allocatedSection : this._activeTrain.getAllocatedSectionList()) {
                if (allocatedSection.getSection() != this._nextSection) continue;
                return true;
            }
        }
        return false;
    }

    private void setSpeedBySectionsAllocated() {
        float f;
        if (this._stoppingByBlockOccupancy && this._stoppingBlock != null && this._stoppingBlock.getState() == 4) {
            return;
        }
        int sectionsAhead = 0;
        for (AllocatedSection allocatedSection : this._activeTrain.getAllocatedSectionList()) {
            if (allocatedSection.getEntered()) continue;
            ++sectionsAhead;
        }
        float newSpeed = 0.0f;
        log.debug("[{}:SectionsAhead[{}]", (Object)this._activeTrain.getActiveTrainName(), (Object)sectionsAhead);
        switch (sectionsAhead) {
            case 0: {
                newSpeed = 0.0f;
                break;
            }
            case 1: {
                newSpeed = InstanceManager.getDefault(SignalSpeedMap.class).getSpeed("Medium");
                this._activeTrain.setStatus(1);
                break;
            }
            default: {
                newSpeed = InstanceManager.getDefault(SignalSpeedMap.class).getSpeed("Normal");
                this._activeTrain.setStatus(1);
            }
        }
        for (AllocatedSection asE : this._activeTrain.getAllocatedSectionList()) {
            if (!asE.getEntered()) continue;
            for (Block b : asE.getSection().getBlockList()) {
                if (!(this.getSpeedFromBlock(b) < newSpeed)) continue;
                newSpeed = this.getSpeedFromBlock(b);
            }
        }
        if (newSpeed > 0.0f && this._nextBlock != null && (f = this.getSpeedFromBlock(this._nextBlock)) < newSpeed) {
            newSpeed = f;
        }
        if (newSpeed > 0.0f) {
            log.trace("setSpeedBySectionsAllocated isStopping[{}]", (Object)this.isStopping());
            this.cancelStopInCurrentSection();
            this.setTargetSpeed(this.getThrottleSettingFromSpeed(newSpeed));
        } else {
            this.waitingOnAllocation = true;
            this.stopInCurrentSection(0);
        }
    }

    private boolean checkTurn(AllocatedSection as) {
        Turnout to;
        if (as != null && as.getAutoTurnoutsResponse() != null && (to = this._dispatcher.getAutoTurnoutsHelper().checkStateAgainstList(as.getAutoTurnoutsResponse())) != null) {
            this._turnoutStateListener = e -> {
                if (e.getPropertyName().equals("KnownState")) {
                    ((Turnout)e.getSource()).removePropertyChangeListener(this._turnoutStateListener);
                    this.setSpeedBySignal();
                }
            };
            to.addPropertyChangeListener(this._turnoutStateListener);
            return false;
        }
        return true;
    }

    private void setSpeedBySignalMast() {
        if (this._controllingSignalMast == null) {
            this.setSpeedBySectionsAllocated();
            return;
        }
        String displayedAspect = this._controllingSignalMast.getAspect();
        if (log.isTraceEnabled()) {
            log.trace("{}: Controlling mast {} ({})", new Object[]{this._activeTrain.getTrainName(), this._controllingSignalMast.getDisplayName(USERSYS), displayedAspect});
            if (this._conSignalProtectedBlock == null) {
                log.trace("{}: Protected block is null", (Object)this._activeTrain.getTrainName());
            } else {
                log.trace("{}: Protected block: {} state: {} speed: {}", new Object[]{this._activeTrain.getTrainName(), this._conSignalProtectedBlock.getSensor().getDisplayName(USERSYS), this._conSignalProtectedBlock.getSensor().getState() == 2 ? "OCCUPIED" : "NOT OCCUPIED", this._conSignalProtectedBlock.getBlockSpeed()});
            }
        }
        if (this._controllingSignalMast.getAppearanceMap().getSpecificAppearance(2).equals(displayedAspect) || !this._controllingSignalMast.getLit() || this._controllingSignalMast.getHeld()) {
            this.checkForSignalPassedOrStop(this._controllingSignalMast.getDisplayName(USERSYS));
        } else if (this._controllingSignalMast.getAppearanceMap().getSpecificAppearance(1) != null && this._controllingSignalMast.getAppearanceMap().getSpecificAppearance(1).equals(displayedAspect)) {
            this.setTargetSpeedState(2);
            this._activeTrain.setStatus(1);
        } else {
            SignalMast smDestination;
            String aspectSpeedStr = (String)this._controllingSignalMast.getSignalSystem().getProperty(displayedAspect, "speed");
            log.trace("{}: Signal {} speed {} for aspect {}", new Object[]{this._activeTrain.getTrainName(), this._controllingSignalMast.getDisplayName(USERSYS), aspectSpeedStr, displayedAspect});
            float speed = -1.0f;
            if (aspectSpeedStr != null) {
                try {
                    speed = Float.parseFloat(aspectSpeedStr);
                }
                catch (NumberFormatException nx) {
                    try {
                        speed = InstanceManager.getDefault(SignalSpeedMap.class).getSpeed(aspectSpeedStr);
                        log.trace("{}: Signal {} speed from map for {} is {}", new Object[]{this._activeTrain.getTrainName(), this._controllingSignalMast.getDisplayName(USERSYS), aspectSpeedStr, Float.valueOf(speed)});
                    }
                    catch (IllegalArgumentException ex) {
                        log.trace("{}: Speed not found {}", (Object)this._activeTrain.getTrainName(), (Object)aspectSpeedStr);
                    }
                }
            }
            int aspectSpeed = (int)speed;
            float smLogicSpeed = -1.0f;
            String smDestinationName = "unknown";
            SignalMastLogic smLogic = InstanceManager.getDefault(SignalMastLogicManager.class).getSignalMastLogic(this._controllingSignalMast);
            if (smLogic != null && (smDestination = smLogic.getActiveDestination()) != null) {
                smDestinationName = smDestination.getDisplayName(USERSYS);
                smLogicSpeed = (int)smLogic.getMaximumSpeed(smDestination);
            }
            if (smLogicSpeed > -1.0f && smLogicSpeed < speed) {
                speed = smLogicSpeed;
            }
            log.debug("{}: {}({}) {}({}), Dest: {}, path max: {}", new Object[]{this._activeTrain.getTrainName(), this._controllingSignalMast.getDisplayName(USERSYS), displayedAspect, aspectSpeedStr, aspectSpeed, smDestinationName, (int)smLogicSpeed});
            if (speed > -1.0f) {
                if (this.prevSpeed == -1.0f || speed < this.prevSpeed) {
                    log.debug("{}: Signal {} setting speed to {} for next", new Object[]{this._activeTrain.getTrainName(), this._controllingSignalMast.getDisplayName(USERSYS), Float.valueOf(speed)});
                    this.setTargetSpeedValue(speed);
                } else {
                    log.debug("{}: Signal {} setting speed to {} for previous", new Object[]{this._activeTrain.getTrainName(), this._controllingSignalMast.getDisplayName(USERSYS), Float.valueOf(speed)});
                    this.setTargetSpeedValue(this.prevSpeed);
                }
                this.prevSpeed = speed;
                this._activeTrain.setStatus(1);
            } else {
                log.warn("{}: No specific speeds found so will use the default", (Object)this._activeTrain.getTrainName());
                this.setTargetSpeedState(6);
                this._activeTrain.setStatus(1);
            }
        }
    }

    private void setSpeedBySignalHead() {
        if (this._controllingSignal != null && this._controllingSignal.getAppearance() == 256) {
            this.stopInCurrentSection(0);
            return;
        }
        if (this.useSpeedProfile) {
            float signalSpeed;
            float blockSpeed = this.getSpeedFromBlock(this._conSignalProtectedBlock);
            String displayedAspect = this._controllingSignal.getAppearanceName();
            try {
                String signalSpeedName = InstanceManager.getDefault(SignalSpeedMap.class).getAppearanceSpeed(displayedAspect);
                signalSpeed = InstanceManager.getDefault(SignalSpeedMap.class).getSpeed(signalSpeedName);
            }
            catch (Throwable ex) {
                signalSpeed = -1.0f;
                log.warn("{}: Block {} AppearanceSpeed {} not found in SignalSpeedMap", new Object[]{this._activeTrain.getTrainName(), this._conSignalProtectedBlock.getDisplayName(USERSYS), displayedAspect});
            }
            float useSpeed = blockSpeed < signalSpeed ? blockSpeed : signalSpeed;
            log.trace("BlockSpeed[{}] SignalSpeed[{}]", (Object)Float.valueOf(blockSpeed), (Object)Float.valueOf(signalSpeed));
            if (useSpeed < 0.01f) {
                this.checkForSignalPassedOrStop(this._controllingSignal.getDisplayName(USERSYS));
            } else {
                this.setTargetSpeedByProfile(useSpeed, this._stopBySpeedProfileAdjust, true);
            }
        } else {
            switch (this._controllingSignal.getAppearance()) {
                case 0: 
                case 1: 
                case 2: {
                    this.checkForSignalPassedOrStop(this._controllingSignal.getDisplayName(USERSYS));
                    break;
                }
                case 4: 
                case 8: {
                    this.setTargetSpeedState(3);
                    this._activeTrain.setStatus(1);
                    break;
                }
                case 16: 
                case 32: {
                    this.setTargetSpeedState(6);
                    this._activeTrain.setStatus(1);
                    break;
                }
                case 64: 
                case 128: {
                    this.setTargetSpeedState(2);
                    this._activeTrain.setStatus(1);
                    break;
                }
                default: {
                    log.warn("Signal Head[{}] has invalid Appearence - using stop", (Object)this._controllingSignal.getAppearance());
                    this.stopInCurrentSection(0);
                }
            }
        }
    }

    private void checkForSignalPassedOrStop(String displayName) {
        if (this._currentAllocatedSection != null) {
            if ((this._currentAllocatedSection.isInActiveBlockList(this._conSignalProtectedBlock) || this._nextSection != null && this._activeTrain.isInAllocatedList(this._nextSection) && this._nextSection.containsBlock(this._conSignalProtectedBlock)) && this._conSignalProtectedBlock.getSensor().getState() == 2) {
                log.debug("{}: _conSignalProtectedBlock [{}] for signal [{}] is the block just past so ignore.", new Object[]{this._activeTrain.getTrainName(), this._conSignalProtectedBlock.getDisplayName(USERSYS), displayName});
            } else {
                log.debug("{}: stopping for signal [{}] ", (Object)this._activeTrain.getTrainName(), (Object)displayName);
                this.stopInCurrentSection(0);
            }
        }
    }

    protected float getSpeedFromBlock(Block block) {
        String blockSpeedName = block.getBlockSpeed();
        if (blockSpeedName.contains("Global")) {
            blockSpeedName = InstanceManager.getDefault(BlockManager.class).getDefaultSpeed();
        }
        float blockSpeed = -1.0f;
        if (!blockSpeedName.isEmpty()) {
            try {
                blockSpeed = Float.parseFloat(blockSpeedName);
            }
            catch (NumberFormatException nx) {
                try {
                    blockSpeed = InstanceManager.getDefault(SignalSpeedMap.class).getSpeed(blockSpeedName);
                    log.debug("{} {}: block speed from map for {} is {}", new Object[]{this._activeTrain.getTrainName(), block.getDisplayName(USERSYS), blockSpeedName, Float.valueOf(blockSpeed)});
                }
                catch (Throwable ex) {
                    log.warn("{}: Block {} Speed {} not found in SignalSpeedMap", new Object[]{this._activeTrain.getTrainName(), block.getDisplayName(USERSYS), Float.valueOf(blockSpeed)});
                }
            }
        }
        return blockSpeed;
    }

    private synchronized void cancelStopInCurrentSection() {
        log.trace("[{}]:Cancel Stopping", (Object)this._activeTrain.getTrainName());
        this.cancelStoppingBySensor();
        this._stoppingByBlockOccupancy = false;
        this._stoppingBlock = null;
        this._stoppingUsingSpeedProfile = false;
        this._stoppingBlock = null;
        this._autoEngineer.slowToStop(false);
    }

    private synchronized void stopInCurrentSection(int task) {
        if (this._currentAllocatedSection == null) {
            log.error("{}: Current allocated section null on entry to stopInCurrentSection", (Object)this._activeTrain.getTrainName());
            this.setStopNow();
            return;
        }
        log.debug("{}: StopInCurrentSection called for {} task[{}] targetspeed[{}]", new Object[]{this._activeTrain.getTrainName(), this._currentAllocatedSection.getSection().getDisplayName(USERSYS), task, Float.valueOf(this.getTargetSpeed())});
        if (this.getTargetSpeed() == 0.0f || this.isStopping()) {
            log.debug("{}: train is already stopped or stopping.", (Object)this._activeTrain.getTrainName());
            return;
        }
        this._stopSensor = this._currentAllocatedSection.getSection().getState() == 4 ? this._currentAllocatedSection.getSection().getForwardStoppingSensor() : this._currentAllocatedSection.getSection().getReverseStoppingSensor();
        if (this._stopSensor != null && this._useStopSensor) {
            if (this._stopSensor.getKnownState() == 2) {
                this.setStopNow();
            } else {
                this.setDecreasedSpeedBeforeStop();
                this._stopSensorListener = e -> this.handleStopSensorChange(e);
                this._stopSensor.addPropertyChangeListener(this._stopSensorListener);
                this._stoppingBySensor = true;
            }
        } else if (this.useSpeedProfile && this._stopBySpeedProfile) {
            log.debug("{}: Section [{}] Section Length[{}] Max Train Length [{}] StopBySpeedProfile [{}]. setStopNow", new Object[]{this._activeTrain.getTrainName(), this._currentAllocatedSection.getSection().getDisplayName(USERSYS), this._currentAllocatedSection.getActualLength(), this.getMaxTrainLengthMM(), this._stopBySpeedProfile});
            this.setTargetSpeedState(1, this.useSpeedProfile);
        } else if ((long)this._currentAllocatedSection.getActualLength() < this.getMaxTrainLengthMM()) {
            log.debug("{}: Section [{}] Section Length[{}] Max Train Length [{}]. setStopNow({})", new Object[]{this._activeTrain.getTrainName(), this._currentAllocatedSection.getSection().getDisplayName(USERSYS), this._currentAllocatedSection.getActualLength(), this.getMaxTrainLengthMM(), this._stopBySpeedProfile});
            this.setStopNow();
        } else if (this._activeTrain.getTrainDetection() == ActiveTrain.TrainDetection.TRAINDETECTION_WHOLETRAIN) {
            log.debug("{}: train will fit in [{}] ({}>={}), stop when prev block clears.", new Object[]{this._activeTrain.getTrainName(), this._currentAllocatedSection.getSection().getDisplayName(USERSYS), this._currentAllocatedSection.getActualLength(), this.getMaxTrainLengthMM()});
            if (this._currentAllocatedSection.getSection().getNumBlocks() == 1) {
                if (this._previousAllocatedSection != null) {
                    Block tBlock = this._previousAllocatedSection.getSection().getNumBlocks() == 1 ? this._previousAllocatedSection.getSection().getLastBlock() : this._previousAllocatedSection.getSection().getExitBlock();
                    if (tBlock != null && tBlock.getState() == 2) {
                        this._stoppingBlock = tBlock;
                        this.setStopByBlockOccupancy(false);
                    } else {
                        this.setStopNow();
                    }
                } else {
                    this.setStopNow();
                }
            } else {
                Block exitBlock = this._currentAllocatedSection.getExitBlock();
                Block enterBlock = this._currentAllocatedSection.getEnterBlock(this._previousAllocatedSection);
                if (enterBlock == null) {
                    this.setStopNow();
                } else if (exitBlock == enterBlock) {
                    if (this._previousBlock != null && this._previousBlock.getState() == 2 && (long)this.getBlockLength(exitBlock) > this.getMaxTrainLengthMM()) {
                        this._stoppingBlock = this._previousBlock;
                        this.setStopByBlockOccupancy(false);
                    } else {
                        this.setStopNow();
                    }
                } else {
                    Block tstBlock = exitBlock;
                    if (tstBlock == null) {
                        tstBlock = this._currentAllocatedSection.getDirection() == 8 ? this._currentAllocatedSection.getSection().getBlockBySequenceNumber(0) : this._currentAllocatedSection.getSection().getBlockBySequenceNumber(this._currentAllocatedSection.getSection().getNumBlocks() - 1);
                    }
                    int tstLength = this.getBlockLength(tstBlock);
                    int tstBlockSeq = this._currentAllocatedSection.getSection().getBlockSequenceNumber(tstBlock);
                    while ((long)tstLength < this.getMaxTrainLengthMM() && tstBlock != enterBlock) {
                        int newSeqNumber = this._currentAllocatedSection.getDirection() == 8 ? tstBlockSeq + 1 : tstBlockSeq - 1;
                        tstBlock = this._currentAllocatedSection.getSection().getBlockBySequenceNumber(newSeqNumber);
                        tstBlockSeq = newSeqNumber;
                        tstLength += this.getBlockLength(tstBlock);
                    }
                    if (this.getMaxTrainLengthMM() > (long)tstLength) {
                        this.setStopNow();
                    } else if (tstBlock == enterBlock) {
                        Block previousSectionExitBlock = this._previousAllocatedSection.getExitBlock();
                        if (previousSectionExitBlock != null && previousSectionExitBlock.getState() == 2) {
                            this._stoppingBlock = previousSectionExitBlock;
                            this.setStopByBlockOccupancy(true);
                        } else {
                            this.setStopNow();
                        }
                    } else {
                        int xSeqNumber = tstBlockSeq + 1;
                        if (this._currentAllocatedSection.getDirection() == 4) {
                            xSeqNumber = tstBlockSeq - 1;
                        }
                        this._stoppingBlock = this._currentAllocatedSection.getSection().getBlockBySequenceNumber(xSeqNumber);
                        this.setStopByBlockOccupancy(true);
                    }
                }
            }
        } else {
            this.setStopNow();
        }
        WaitForTrainToStop waitForStop = new WaitForTrainToStop(task);
        Thread tWait = ThreadingUtil.newThread(waitForStop, "Wait for stop " + this.getActiveTrain().getActiveTrainName());
        tWait.start();
    }

    protected synchronized void executeStopTasks(int task) {
        this.cancelStopInCurrentSection();
        this._dispatcher.queueReleaseOfCompletedAllocations();
        log.trace("exec[{}]", (Object)task);
        switch (task) {
            case 4: {
                this._activeTrain.setStatus(64);
                break;
            }
            case 0: {
                break;
            }
            case 1: {
                this._activeTrain.setRestart(this._activeTrain.getDelayReverseRestart(), this._activeTrain.getReverseRestartDelay(), this._activeTrain.getReverseRestartSensor(), this._activeTrain.getResetReverseRestartSensor());
                this._activeTrain.setTransitReversed(true);
                this._activeTrain.reverseAllAllocatedSections();
                this.setEngineDirection();
                this._previousBlock = null;
                this._nextBlock = this.getNextBlock(this._currentBlock, this._currentAllocatedSection);
                if (this._activeTrain.getDelayReverseRestart() != 0) break;
                this._activeTrain.holdAllocation(false);
                this.setupNewCurrentSignal(this._currentAllocatedSection, true);
                this.setSpeedBySignal();
                if (this._nextSection == null || this._activeTrain.isInAllocatedList(this._nextSection)) break;
                this._dispatcher.queueScanOfAllocationRequests();
                break;
            }
            case 2: {
                this._activeTrain.setRestart(this._activeTrain.getDelayedRestart(), this._activeTrain.getRestartDelay(), this._activeTrain.getRestartSensor(), this._activeTrain.getResetRestartSensor());
                if (this._activeTrain.getResetWhenDone()) {
                    if (this._activeTrain.getDelayedRestart() == 0 && !this._activeTrain.getReverseAtEnd()) {
                        log.error("[{}]: train is continueing without pause, should have been handled in handleBlockStateChange.", (Object)this._activeTrain.getTrainName());
                        break;
                    }
                    this._activeTrain.setTransitReversed(false);
                    this._activeTrain.resetAllAllocatedSections();
                    this._previousBlock = null;
                    this._nextBlock = this.getNextBlock(this._currentBlock, this._currentAllocatedSection);
                    this.setEngineDirection();
                    this._activeTrain.setRestart(this._activeTrain.getDelayedRestart(), this._activeTrain.getRestartDelay(), this._activeTrain.getRestartSensor(), this._activeTrain.getResetRestartSensor());
                    if (this._nextSection != null && !this._activeTrain.isInAllocatedList(this._nextSection)) {
                        this._dispatcher.queueScanOfAllocationRequests();
                    }
                    this.setupNewCurrentSignal(null, true);
                    this.setSpeedBySignal();
                    break;
                }
                log.warn("[{}]resetWhenDone flag reset, likely user cancelling while processing stop", (Object)this._activeTrain.getActiveTrainName());
                break;
            }
            default: {
                log.debug("[{}]Invalid action [{}] in executeStopTasksRequest to execute BEGINNING_RESET cancelled", (Object)this._activeTrain.getActiveTrainName(), (Object)task);
            }
        }
    }

    private void cancelStoppingBySensor() {
        if (this._stopSensor != null) {
            this._stopSensor.removePropertyChangeListener(this._stopSensorListener);
            this._stoppingBySensor = false;
            this._stopSensorListener = null;
            this._stopSensor = null;
        }
    }

    private synchronized void handleStopSensorChange(PropertyChangeEvent e) {
        if (e.getPropertyName().equals("KnownState") && (Integer)e.getNewValue() == 2) {
            this._stopSensor.removePropertyChangeListener(this._stopSensorListener);
            this._stoppingBySensor = false;
            this._stopSensorListener = null;
            this._stopSensor = null;
            if (this._needSetSpeed) {
                this._needSetSpeed = false;
                this.setSpeedBySignal();
            } else {
                this.setStopNow();
            }
        }
    }

    private synchronized void setStopNow() {
        this.setStopNow(false);
    }

    private synchronized void setStopNow(boolean useSpeedProfile) {
        this.setTargetSpeedState(1, useSpeedProfile);
        if (this._currentAllocatedSection == null) {
            this._activeTrain.setStatus(4);
        } else if (this._currentAllocatedSection.getNextSection() == null) {
            this.waitUntilStopped();
            this._activeTrain.setStatus(64);
        } else {
            this._activeTrain.setStatus(4);
        }
    }

    private void setStopByBlockOccupancy(boolean ignoreNotOccupied) {
        if (this._stoppingBlock.getState() == 2 || ignoreNotOccupied) {
            this.setDecreasedSpeedBeforeStop();
            this._stoppingByBlockOccupancy = true;
        } else {
            this.setStopNow();
        }
    }

    private void setDecreasedSpeedBeforeStop() {
        float signalSpeed = 25.0f;
        try {
            signalSpeed = InstanceManager.getDefault(SignalSpeedMap.class).getSpeed(this._dispatcher.getStoppingSpeedName());
        }
        catch (IllegalArgumentException ex) {
            log.error("Missing [{}] from Speed table - defaulting to 25", (Object)this._dispatcher.getStoppingSpeedName());
        }
        if (this.getThrottleSettingFromSpeed(signalSpeed) < this.getTargetSpeed()) {
            if (this.useSpeedProfile) {
                this.setTargetSpeedByProfile(signalSpeed, this._stopBySpeedProfileAdjust * 0.75f, false);
            } else {
                this.setTargetSpeed(signalSpeed / 100.0f);
            }
        }
    }

    private synchronized float getThrottleSettingFromSpeed(float speed) {
        if (this.useSpeedProfile) {
            float throttleSetting = this._activeTrain.getRosterEntry().getSpeedProfile().getThrottleSettingFromSignalMapSpeed(speed, this.getForward());
            return throttleSetting;
        }
        if (this._activeTrain.getSignalType() == 1) {
            float mls = this._controllingSignalMast != null ? this._controllingSignalMast.getSignalSystem().getMaximumLineSpeed() : this._dispatcher.getMaximumLineSpeed();
            float throttleSetting = speed / mls;
            return throttleSetting;
        }
        return speed / 100.0f;
    }

    private synchronized void setTargetSpeedState(int speedState) {
        this.setTargetSpeedState(speedState, false);
    }

    private synchronized void setTargetSpeedState(int speedState, boolean stopBySpeedProfile) {
        log.trace("{}: setTargetSpeedState:({})", (Object)this._activeTrain.getTrainName(), (Object)speedState);
        this._autoEngineer.slowToStop(false);
        if (speedState > 1) {
            this.cancelStopInCurrentSection();
            if (this._currentRampRate == 5 && this.useSpeedProfile) {
                this._autoEngineer.setTargetSpeed(this._currentAllocatedSection.getLengthRemaining(this._currentBlock) * this._stopBySpeedProfileAdjust, speedState);
            } else {
                this.setTargetSpeed(this._speedRatio[speedState].floatValue());
            }
        } else if (stopBySpeedProfile) {
            this._stoppingUsingSpeedProfile = true;
            this._autoEngineer.setTargetSpeed(this._currentAllocatedSection.getLengthRemaining(this._currentBlock) * this._stopBySpeedProfileAdjust, 0.0f);
        } else {
            this._autoEngineer.setHalt(true);
            this.setTargetSpeed(0.0f);
        }
    }

    private synchronized void setTargetSpeedByProfile(float speedState, float stopBySpeedProfileAdjust, boolean cancelStopping) {
        try {
            float throttleSetting = this._activeTrain.getRosterEntry().getSpeedProfile().getThrottleSettingFromSignalMapSpeed(speedState, this.getForward());
            log.debug("{}: setTargetSpeedByProfile: {} SpeedState[{}]", new Object[]{this._activeTrain.getTrainName(), Float.valueOf(throttleSetting), Float.valueOf(speedState)});
            if ((double)throttleSetting > 0.009 && this._currentRampRate != 5 && this.useSpeedProfile) {
                if (cancelStopping) {
                    this.cancelStopInCurrentSection();
                }
                this.setTargetSpeed(throttleSetting);
            } else if ((double)throttleSetting > 0.009) {
                if (cancelStopping) {
                    this.cancelStopInCurrentSection();
                }
                this._autoEngineer.setTargetSpeed(this._currentAllocatedSection.getLengthRemaining(this._currentBlock) * stopBySpeedProfileAdjust, throttleSetting);
            } else if (this.useSpeedProfile && this._stopBySpeedProfile) {
                this.setTargetSpeed(0.0f);
                this._stoppingUsingSpeedProfile = true;
                this._autoEngineer.setTargetSpeed(this._currentAllocatedSection.getLengthRemaining(this._currentBlock) * stopBySpeedProfileAdjust, 0.0f);
            } else {
                this._autoEngineer.slowToStop(false);
                this.setTargetSpeed(0.0f);
                this._autoEngineer.setHalt(true);
            }
        }
        catch (Exception ex) {
            log.error("setTargetSpeedByProfile crashed - Emergency Stop: ", (Throwable)ex);
            this._autoEngineer.slowToStop(false);
            this.setTargetSpeed(-1.0f);
            this._autoEngineer.setHalt(true);
        }
    }

    private synchronized void setTargetSpeedValue(float speed) {
        log.debug("{}: setTargetSpeedValue: Speed[{}]", (Object)this._activeTrain.getTrainName(), (Object)Float.valueOf(speed));
        if (this.useSpeedProfile) {
            this.setTargetSpeedByProfile(speed, this._stopBySpeedProfileAdjust, true);
            return;
        }
        this._autoEngineer.slowToStop(false);
        float mls = this._controllingSignalMast != null ? this._controllingSignalMast.getSignalSystem().getMaximumLineSpeed() : this._dispatcher.getMaximumLineSpeed();
        float decSpeed = speed / mls;
        if (decSpeed > 0.0f) {
            this.cancelStopInCurrentSection();
            this.setTargetSpeed(decSpeed);
        } else {
            this.setTargetSpeed(0.0f);
            this._autoEngineer.setHalt(true);
        }
    }

    private int getBlockLength(Block b) {
        if (b == null) {
            return 0;
        }
        return (int)b.getLengthMm();
    }

    protected void initiateWorking() {
        if (this._activeTrain.getStatus() != 8) {
            this._activeTrain.setMode(8);
            this._activeTrain.setStatus(8);
            this.saveSpeedAndDirection();
            if (this._autoEngineer != null) {
                this._autoEngineer.setHalt(true);
                this.waitUntilStopped();
                this._autoEngineer.abort();
                InstanceManager.throttleManagerInstance().releaseThrottle(this._throttle, this);
                this._autoEngineer = null;
                this._throttle = null;
            }
        }
    }

    protected void waitUntilStopped() {
        boolean doneWaiting = false;
        while (!doneWaiting) {
            doneWaiting = this._autoEngineer != null ? this._autoEngineer.isStopped() : true;
            if (doneWaiting) continue;
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    protected void resumeAutomaticRunning() {
        if (this._activeTrain.getStatus() == 8 || this._activeTrain.getStatus() == 16) {
            this._autoTrainAction.cancelDoneSensor();
            if (this.initialize()) {
                this._resumingAutomatic = true;
            } else {
                log.error("Failed to initialize throttle when resuming automatic mode.");
            }
        }
    }

    public Thread pauseTrain(int fastMinutes) {
        if (this._pausingActive) {
            return null;
        }
        PauseTrain pauseTrain = new PauseTrain(fastMinutes);
        Thread tPause = ThreadingUtil.newThread(pauseTrain, "pause train " + this._activeTrain.getTrainName());
        tPause.start();
        return tPause;
    }

    public void terminate() {
        while (this._activeHornThreads > 0) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this._autoTrainAction.clearRemainingActions();
        if (this._autoEngineer != null) {
            this._autoEngineer.setHalt(true);
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.waitUntilStopped();
            this._autoEngineer.abort();
            InstanceManager.throttleManagerInstance().releaseThrottle(this._throttle, this);
        }
    }

    public void dispose() {
        if (this._controllingSignalMast != null && this._conSignalMastListener != null) {
            this._controllingSignalMast.removePropertyChangeListener(this._conSignalMastListener);
        }
        this._controllingSignalMast = null;
        this._conSignalMastListener = null;
    }

    public static int getRampRateFromName(String rampRate) {
        if (rampRate.equals(Bundle.getMessage("RAMP_FAST"))) {
            return 1;
        }
        if (rampRate.equals(Bundle.getMessage("RAMP_MEDIUM"))) {
            return 2;
        }
        if (rampRate.equals(Bundle.getMessage("RAMP_MED_SLOW"))) {
            return 3;
        }
        if (rampRate.equals(Bundle.getMessage("RAMP_SLOW"))) {
            return 4;
        }
        if (rampRate.equals(Bundle.getMessage("RAMP_SPEEDPROFILE"))) {
            return 5;
        }
        return 0;
    }

    static class DarkTerritoryListener
    implements PropertyChangeListener {
        private Sensor sensor;

        public DarkTerritoryListener(Sensor sensor) {
            this.sensor = sensor;
            log.trace("Sensor[{}]", (Object)sensor.getDisplayName());
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            if (e.getPropertyName().equals("state")) {
                ((Block)e.getSource()).removePropertyChangeListener(this);
                if (e.getNewValue().equals(4)) {
                    try {
                        log.trace("Sensor INACTIVE[{}]", (Object)this.sensor.getDisplayName());
                        this.sensor.setKnownState(4);
                    }
                    catch (JmriException ex) {
                        log.error("Error leaving darkterratory");
                    }
                }
            }
        }
    }

    class AutoEngineer {
        private DccThrottle throttle;
        private int ramping;
        private boolean speedProfileStoppingIsRunning = false;
        private float speedIncrement = 0.0f;
        private float targetSpeed;
        private RosterEntry rosterEntry;
        private int throttleInterval;
        private float minReliableOperatingSpeed;
        private float maxSpeed;
        private float speedFactor;
        LinkedList<SpeedSetting> stepQueue;
        private Timer rampingTimer;

        AutoEngineer(DccThrottle throttle, RosterEntry rosterEntry) {
            this.throttle = throttle;
            this.rosterEntry = rosterEntry;
        }

        public void setRamping(int ramping, int fullRampTime, int minThrottleInterval, int rampRate) {
            this.ramping = ramping;
            this.throttleInterval = minThrottleInterval;
            this.speedIncrement = 100.0f / ((float)fullRampTime / (float)minThrottleInterval) / (float)rampRate / 100.0f;
            log.debug("{}: _speedIncrement={}", (Object)this.throttle.getLocoAddress(), (Object)Float.valueOf(this.speedIncrement));
        }

        public void setIsForward(boolean isForward) {
            this.throttle.setIsForward(isForward);
        }

        public boolean getIsForward() {
            return this.throttle.getIsForward();
        }

        public void setTargetSpeed(float speed) {
            this.stopAllTimers();
            this.targetSpeed = this.applyMaxThrottleAndFactor(speed);
            log.debug("setTargetSpeed: Set Speed[{}] adjusted to TargetSpeed[{}] ", (Object)Float.valueOf(speed), (Object)Float.valueOf(this.targetSpeed));
            if (this.ramping == 0 || this.ramping == 5) {
                this.throttle.setSpeedSetting(this.targetSpeed);
            } else {
                this.rampToTarget();
            }
        }

        public float getTargetSpeed() {
            return this.targetSpeed;
        }

        private float applyMaxThrottleAndFactor(float throttleSetting) {
            if (throttleSetting > 0.0f) {
                if (throttleSetting * this.speedFactor > this.maxSpeed) {
                    return this.maxSpeed;
                }
                if (throttleSetting * this.speedFactor < this.minReliableOperatingSpeed) {
                    return this.minReliableOperatingSpeed;
                }
                return throttleSetting * this.speedFactor;
            }
            return throttleSetting;
        }

        public void setHalt(boolean halt) {
            if (halt) {
                this.setSpeedImmediate(0.0f);
            }
        }

        public void setSpeedLimits(float minReliableOperatingSpeed, float maxSpeed, float speedFactor) {
            this.minReliableOperatingSpeed = minReliableOperatingSpeed;
            this.maxSpeed = maxSpeed;
            this.speedFactor = speedFactor;
        }

        public void setTargetSpeed(float distance, float speed) {
            log.debug("Set Target Speed[{}] with distance{{}] from speed[{}]", new Object[]{Float.valueOf(speed), Float.valueOf(distance), Float.valueOf(this.throttle.getSpeedSetting())});
            this.stopAllTimers();
            if (this.rosterEntry != null) {
                this.rosterEntry.getSpeedProfile().setExtraInitialDelay(1500.0f);
                this.rosterEntry.getSpeedProfile().setMinMaxLimits(this.minReliableOperatingSpeed, this.maxSpeed);
                this.rosterEntry.getSpeedProfile().changeLocoSpeed(AutoActiveTrain.this._throttle, distance, speed);
                this.speedProfileStoppingIsRunning = true;
                this.targetSpeed = speed;
            } else {
                this.setTargetSpeed(0.0f);
            }
        }

        public void slowToStop(boolean on) {
            this.stopAllTimers();
            if (on) {
                log.debug("SlowToStopOn");
                this.setTargetSpeed(0.0f);
            }
        }

        public void stopAllTimers() {
            if (this.speedProfileStoppingIsRunning) {
                AutoActiveTrain.this.re.getSpeedProfile().cancelSpeedChange();
                this.speedProfileStoppingIsRunning = false;
            }
            if (this.rampingTimer != null) {
                this.rampingTimer.stop();
                this.rampingTimer = null;
            }
        }

        private void rampToTarget() {
            log.debug("RampToTarget[{}]current[{}]", (Object)Float.valueOf(this.getTargetSpeed()), (Object)Float.valueOf(this.throttle.getSpeedSetting()));
            this.stepQueue = new LinkedList();
            if (this.throttle.getSpeedSetting() == this.getTargetSpeed()) {
                return;
            }
            if (this.throttle.getSpeedSetting() < this.getTargetSpeed()) {
                float newSpeed = this.throttle.getSpeedSetting();
                if (newSpeed < this.minReliableOperatingSpeed) {
                    this.stepQueue.add(new SpeedSetting(this.minReliableOperatingSpeed, this.throttleInterval));
                    newSpeed = this.minReliableOperatingSpeed;
                }
                while (newSpeed < this.getTargetSpeed()) {
                    if ((newSpeed += this.speedIncrement) > this.getTargetSpeed()) {
                        newSpeed = this.getTargetSpeed();
                    }
                    log.trace("NewSpeedUp[{}]", (Object)Float.valueOf(newSpeed));
                    this.stepQueue.add(new SpeedSetting(newSpeed, this.throttleInterval));
                }
            } else {
                boolean andStop = false;
                if (this.getTargetSpeed() <= 0.0f) {
                    andStop = true;
                }
                float newSpeed = this.throttle.getSpeedSetting();
                while (newSpeed > this.getTargetSpeed()) {
                    if ((newSpeed -= this.speedIncrement) < this.getTargetSpeed()) {
                        newSpeed = this.getTargetSpeed();
                    }
                    log.trace("NewSpeedDown[{}]", (Object)Float.valueOf(newSpeed));
                    this.stepQueue.add(new SpeedSetting(newSpeed, this.throttleInterval));
                }
                if (andStop) {
                    this.stepQueue.add(new SpeedSetting(0.0f, this.throttleInterval));
                }
            }
            if (this.rampingTimer == null) {
                this.setNextStep();
            }
        }

        private void finishChange() {
            if (this.rampingTimer != null) {
                this.rampingTimer.stop();
            }
            this.rampingTimer = null;
            this.stepQueue.clear();
            this.stepQueue = null;
        }

        synchronized void setNextStep() {
            if (this.stepQueue.isEmpty()) {
                log.trace("Empty");
                this.finishChange();
                return;
            }
            SpeedSetting ss = this.stepQueue.getFirst();
            if (ss.getDuration() == 0) {
                log.trace("Duratiom Zero");
                this.finishChange();
                return;
            }
            this.stepQueue.removeFirst();
            log.trace("Set New Speed[{}]", (Object)Float.valueOf(ss.getSpeedStep()));
            this.throttle.setSpeedSetting(ss.getSpeedStep());
            this.rampingTimer = new Timer(ss.getDuration(), e -> this.setNextStep());
            this.rampingTimer.setRepeats(false);
            this.rampingTimer.start();
        }

        public synchronized void setSpeedImmediate(float speed) {
            log.trace("{}: setting speed directly to {}%", (Object)AutoActiveTrain.this._activeTrain.getTrainName(), (Object)((int)(speed * 100.0f)));
            this.stopAllTimers();
            this.targetSpeed = this.applyMaxThrottleAndFactor(speed);
            this.throttle.setSpeedSetting(this.targetSpeed);
        }

        public synchronized boolean isStopped() {
            return this.throttle.getSpeedSetting() <= 4.0E-4f;
        }

        public synchronized boolean isAtSpeed() {
            return (double)Math.abs(this.throttle.getSpeedSetting() - this.targetSpeed) <= 0.01;
        }

        public void abort() {
            this.stopAllTimers();
        }

        protected void setFunction(int cmdNum, boolean isSet) {
            this.throttle.setFunction(cmdNum, isSet);
        }

        private class SpeedSetting {
            float step = 0.0f;
            int duration = 0;

            SpeedSetting(float step, int duration) {
                this.step = step;
                this.duration = duration;
            }

            float getSpeedStep() {
                return this.step;
            }

            int getDuration() {
                return this.duration;
            }
        }
    }

    class PauseTrain
    implements Runnable {
        private int _fastMinutes = 0;
        private float _savedTargetSpeed = 0.0f;
        private int _savedRampRate = 0;

        public PauseTrain(int fastMinutes) {
            this._fastMinutes = fastMinutes;
        }

        @Override
        public void run() {
            AutoActiveTrain.this._pausingActive = true;
            this._savedTargetSpeed = AutoActiveTrain.this.getTargetSpeed();
            this._savedRampRate = AutoActiveTrain.this.getRampRate();
            AutoActiveTrain.this.setCurrentRampRate(1);
            AutoActiveTrain.this.stopInCurrentSection(0);
            boolean waitNow = true;
            boolean keepGoing = true;
            while (waitNow) {
                try {
                    Thread.sleep(101L);
                    if (AutoActiveTrain.this._autoEngineer != null) {
                        if (!AutoActiveTrain.this._autoEngineer.isStopped()) continue;
                        waitNow = false;
                        continue;
                    }
                    waitNow = false;
                }
                catch (InterruptedException e2) {
                    log.trace("InterruptedException while waiting to stop for pause-indicates action cancelled.", (Throwable)e2);
                    waitNow = false;
                    keepGoing = false;
                }
            }
            AutoActiveTrain.this._activeTrain.setStatus(2);
            if (keepGoing) {
                Timebase _clock = InstanceManager.getDefault(Timebase.class);
                PropertyChangeListener _clockListener = e -> --this._fastMinutes;
                _clock.addMinuteChangeListener(_clockListener);
                waitNow = true;
                while (waitNow) {
                    try {
                        Thread.sleep(501L);
                        if (this._fastMinutes > 0) continue;
                        waitNow = false;
                    }
                    catch (InterruptedException e3) {
                        log.trace("InterruptedException indicates action cancelled.", (Throwable)e3);
                        keepGoing = false;
                    }
                }
                _clock.removeMinuteChangeListener(_clockListener);
            }
            AutoActiveTrain.this._pausingActive = false;
            if (keepGoing) {
                AutoActiveTrain.this.setCurrentRampRate(this._savedRampRate);
                AutoActiveTrain.this.setTargetSpeed(this._savedTargetSpeed);
                AutoActiveTrain.this._activeTrain.setStatus(1);
                AutoActiveTrain.this.setSpeedBySignal();
            }
        }
    }

    class WaitForTrainToStop
    implements Runnable {
        private final int _delay = 91;
        private int _task = 0;

        public WaitForTrainToStop(int task) {
            this._task = task;
        }

        @Override
        public void run() {
            boolean waitingOnTrain = true;
            try {
                while (waitingOnTrain) {
                    if (AutoActiveTrain.this.getAutoEngineer() != null && AutoActiveTrain.this.getAutoEngineer().isStopped()) {
                        waitingOnTrain = false;
                        continue;
                    }
                    Thread.sleep(91L);
                }
                log.trace("executing task[{}]", (Object)this._task);
                AutoActiveTrain.this.executeStopTasks(this._task);
            }
            catch (InterruptedException e) {
                log.warn("Waiting for train to stop interrupted - stop tasks not executing");
            }
            catch (Exception e) {
                log.error("Waiting for train to stop crashed - stop tasks not executing.", (Throwable)e);
            }
        }
    }
}

