/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.dispatcher;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import jmri.Block;
import jmri.EntryPoint;
import jmri.InstanceManager;
import jmri.NamedBean;
import jmri.NamedBeanHandleManager;
import jmri.Section;
import jmri.SectionManager;
import jmri.Sensor;
import jmri.SignalMast;
import jmri.Transit;
import jmri.TransitSection;
import jmri.jmrit.dispatcher.ActiveTrain;
import jmri.jmrit.dispatcher.AllocatedSection;
import jmri.jmrit.dispatcher.AllocationPlan;
import jmri.jmrit.dispatcher.AllocationRequest;
import jmri.jmrit.dispatcher.DispatcherFrame;
import jmri.jmrit.dispatcher.TaskAllocateRelease;
import jmri.jmrit.display.layoutEditor.LayoutBlockManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoAllocate
implements Runnable {
    LinkedBlockingQueue<TaskAllocateRelease> taskList;
    private static final NamedBean.DisplayOptions USERSYS = NamedBean.DisplayOptions.USERNAME_SYSTEMNAME;
    private DispatcherFrame _dispatcher = null;
    private final List<AllocationPlan> _planList = new ArrayList<AllocationPlan>();
    private int nextPlanNum = 1;
    private final List<AllocationRequest> orderedRequests = new ArrayList<AllocationRequest>();
    private List<AllocationRequest> allocationRequests = null;
    private final Map<String, String> reservedSections = new HashMap<String, String>();
    private boolean abort = false;
    private final AllocationRequest savedAR = null;
    private final Section savedSection = null;
    Section curSection = null;
    private static final Logger log = LoggerFactory.getLogger(AutoAllocate.class);

    public AutoAllocate(DispatcherFrame d, List<AllocationRequest> inAllocationRequests) {
        this._dispatcher = d;
        this.allocationRequests = inAllocationRequests;
        if (this._dispatcher == null) {
            log.error("null DispatcherFrame when constructing AutoAllocate");
            return;
        }
        this.taskList = new LinkedBlockingQueue();
    }

    protected void setAbort() {
        this.abort = true;
        this.scanAllocationRequests(new TaskAllocateRelease(TaskAllocateRelease.TaskAction.ABORT));
    }

    protected boolean allRequestsDone() {
        return this.taskList.isEmpty();
    }

    protected void scanAllocationRequests(TaskAllocateRelease task) {
        log.trace("Add request from [{}] for [{}][{}]", new Object[]{task.getTrainName(), task.getAction().name(), task.getAllocationRequest() == null ? "None" : task.getAllocationRequest().getSectionName()});
        this.taskList.add(task);
    }

    @Override
    public void run() {
        while (!this.abort) {
            try {
                TaskAllocateRelease task = this.taskList.take();
                try {
                    switch (task.getAction()) {
                        case AUTO_RELEASE: {
                            this._dispatcher.checkAutoRelease();
                            break;
                        }
                        case RELEASE_ONE: {
                            this._dispatcher.doReleaseAllocatedSection(task.getAllocatedSection(), task.getTerminatingTrain());
                            break;
                        }
                        case RELEASE_RESERVED: {
                            this.removeAllReservesForTrain(task.getTrainName());
                            break;
                        }
                        case SCAN_REQUESTS: {
                            this.scanAllocationRequestList(this.allocationRequests);
                            break;
                        }
                        case ALLOCATE_IMMEDIATE: {
                            this._dispatcher.allocateSection(task.getAllocationRequest(), null);
                            break;
                        }
                        case ABORT: {
                            this.abort = true;
                            break;
                        }
                        default: {
                            log.error("Unknown action in TaskAllocateRelease - ignoring");
                            break;
                        }
                    }
                }
                catch (Exception ex) {
                    log.error("Unexpected Exeption, likely bad task request.", (Throwable)ex);
                }
            }
            catch (InterruptedException ex) {
                log.error("Blocklist killed, taking this as terminate", (Throwable)ex);
                this.abort = true;
            }
        }
    }

    private synchronized void scanAllocationRequestList(List<AllocationRequest> list) {
        boolean okToAllocate = false;
        if (list.size() <= 0) {
            return;
        }
        this.copyAndSortARs(list);
        this.removeCompletePlans();
        for (int i = 0; i < this.orderedRequests.size(); ++i) {
            try {
                okToAllocate = false;
                AllocationRequest ar = this.orderedRequests.get(i);
                if (ar == null) {
                    log.error("error in allocation request list - AllocationRequest is null");
                    continue;
                }
                ActiveTrain activeTrain = ar.getActiveTrain();
                String trainName = activeTrain.getTrainName();
                log.trace("{}: try to allocate [{}]", (Object)trainName, (Object)ar.getSection().getDisplayName(USERSYS));
                if (activeTrain.getLastAllocatedSection() != null) {
                    Transit arTransit = activeTrain.getTransit();
                    TransitSection arCurrentTransitSection = arTransit.getTransitSectionFromSectionAndSeq(activeTrain.getLastAllocatedSection(), activeTrain.getLastAllocatedSectionSeqNumber());
                    if (this.stopAllocateSensorSet(activeTrain, arCurrentTransitSection)) {
                        log.debug("[{}]:StopAllocateSensor active", (Object)trainName);
                        continue;
                    }
                    if (activeTrain.holdAllocation() || !activeTrain.getStarted() && activeTrain.getDelayedStart() != 0) {
                        log.debug("[{}]:Allocation is Holding or Delayed hold[{}] started[{}], delayedstart[{}]", new Object[]{trainName, activeTrain.holdAllocation(), activeTrain.getStarted(), activeTrain.getDelayedStart() != 0});
                        continue;
                    }
                    if (activeTrain.getSignalType() == 1 && this.isSignalHeldAtStartOfSection(ar)) continue;
                    String reservedTrainName = this.reservedSections.get(ar.getSection().getSystemName());
                    if (reservedTrainName != null && reservedTrainName.equals(trainName)) {
                        String sectionName = ar.getSection().getSystemName();
                        if (!this.allocateMore(ar)) continue;
                        this.reservedSections.remove(sectionName);
                        continue;
                    }
                    if (activeTrain.getAllocateMethod() == 0) {
                        String sectionSystemName;
                        log.trace("{}: Allocating [{}] using Safe Sections", (Object)trainName, (Object)ar.getSection().getDisplayName());
                        if ((activeTrain.getLastAllocOverrideSafe() == null || activeTrain.getLastAllocOverrideSafe() != arCurrentTransitSection.getSection()) && arCurrentTransitSection.isSafe() && activeTrain.getLastAllocatedSection().getOccupancy() != 2) {
                            log.debug("Allocating Train [{}] has not arrived at Passing Point", (Object)trainName);
                            continue;
                        }
                        int itSequ = ar.getSectionSeqNumber();
                        int iIncrement = 0;
                        int iLimit = 0;
                        int ix = 0;
                        boolean skip = false;
                        int iStart = 0;
                        if (activeTrain.isTransitReversed()) {
                            iIncrement = -1;
                            iLimit = 0;
                            iStart = itSequ;
                        } else {
                            if (activeTrain.getStartBlockSectionSequenceNumber() == ar.getSectionSeqNumber()) {
                                skip = true;
                            }
                            iIncrement = 1;
                            iLimit = arTransit.getMaxSequence() + 1;
                            iStart = itSequ;
                        }
                        if (!skip) {
                            boolean areForwardsFree = false;
                            log.trace("index [{}] Limit [{}] transitsize [{}]", new Object[]{ix, iLimit, arTransit.getTransitSectionList().size()});
                            for (ix = iStart; ix != iLimit; ix += iIncrement) {
                                log.trace("index [{}] Limit [{}] transitsize [{}]", new Object[]{ix, iLimit, arTransit.getTransitSectionList().size()});
                                ArrayList<TransitSection> sectionsInSeq = arTransit.getTransitSectionListBySeq(ix);
                                areForwardsFree = false;
                                log.trace("Search ALternates Size[{}]", (Object)sectionsInSeq.size());
                                int seqNumberfound = 0;
                                for (int iSectionsInSeq = 0; iSectionsInSeq < sectionsInSeq.size() && !areForwardsFree; ++iSectionsInSeq) {
                                    log.trace("iSectionInSeq[{}]", (Object)iSectionsInSeq);
                                    Section sS = sectionsInSeq.get(iSectionsInSeq).getSection();
                                    seqNumberfound = iSectionsInSeq;
                                    log.trace("SectionName[{}] getState[{}] occupancy[{}] ", new Object[]{sS.getDisplayName(USERSYS), sS.getState(), sS.getOccupancy()});
                                    if (!this.checkUnallocatedCleanly(activeTrain, sS)) {
                                        areForwardsFree = false;
                                        continue;
                                    }
                                    if (sS.getState() != 2) {
                                        log.debug("{}: Forward section [{}] unavailable", (Object)trainName, (Object)sS.getDisplayName(USERSYS));
                                        areForwardsFree = false;
                                        continue;
                                    }
                                    if (sS.getOccupancy() != 4) {
                                        log.debug("{}: Forward section [{}] is not unoccupied", (Object)trainName, (Object)sS.getDisplayName(USERSYS));
                                        areForwardsFree = false;
                                        continue;
                                    }
                                    if (this._dispatcher.checkBlocksNotInAllocatedSection(sS, ar) != null) {
                                        log.debug("{}: Forward section [{}] is in conflict with [{}]", new Object[]{trainName, sS.getUserName(), this._dispatcher.checkBlocksNotInAllocatedSection(sS, ar)});
                                        areForwardsFree = false;
                                        continue;
                                    }
                                    if (this.checkBlocksNotInReservedSection(activeTrain, sS) != null) {
                                        log.debug("{}: Forward section [{}] is in conflict with [{}]", new Object[]{trainName, sS.getDisplayName(), this.checkBlocksNotInReservedSection(activeTrain, sS).getDisplayName()});
                                        areForwardsFree = false;
                                        continue;
                                    }
                                    if (this.reservedSections.get(sS.getSystemName()) != null && !this.reservedSections.get(sS.getSystemName()).equals(trainName)) {
                                        log.debug("{}: Forward section [{}] is reserved for [{}]", new Object[]{trainName, sS.getDisplayName(USERSYS), this.reservedSections.get(sS.getSystemName())});
                                        areForwardsFree = false;
                                        continue;
                                    }
                                    log.debug("Adding [{}],[{}]", (Object)sS.getDisplayName(USERSYS), (Object)trainName);
                                    this.reservedSections.put(sS.getSystemName(), trainName);
                                    areForwardsFree = true;
                                }
                                if (!areForwardsFree) {
                                    this.removeAllReservesForTrain(trainName);
                                    break;
                                }
                                if (!sectionsInSeq.get(seqNumberfound).isSafe()) continue;
                                log.trace("Safe Section Found");
                                break;
                            }
                            log.trace("ForwardsFree[{}]", (Object)areForwardsFree);
                            if (!areForwardsFree) {
                                this.removeAllReservesForTrain(trainName);
                                continue;
                            }
                        }
                        try {
                            sectionSystemName = ar.getSection().getSystemName();
                        }
                        catch (Exception ex) {
                            log.error("Error", (Throwable)ex);
                            sectionSystemName = "Unknown";
                        }
                        if (!this.allocateMore(ar)) continue;
                        if (!sectionSystemName.equals("Unknown")) {
                            log.debug("removing : [{}]", (Object)sectionSystemName);
                            this.reservedSections.remove(sectionSystemName);
                            continue;
                        }
                        log.error("{};Cannot allocate allocatable section[{}]", (Object)trainName, (Object)sectionSystemName);
                        continue;
                    }
                }
                log.trace("Using Regular");
                if (!this.checkUnallocatedCleanly(activeTrain, ar.getSection())) {
                    okToAllocate = false;
                    continue;
                }
                if (this.getPlanThisTrain(activeTrain) != null) {
                    if (!this.willAllocatingFollowPlan(ar, this.getPlanThisTrain(activeTrain)) || !this.allocateMore(ar)) continue;
                    continue;
                }
                if (this.waitingForStartTime(ar) || ar.getSection().getState() != 2 || ar.getSection().getOccupancy() == 2 || ar.getActiveTrain().getSignalType() != 0 && ar.getActiveTrain().getSignalType() != 2 && (ar.getActiveTrain().getSignalType() != 1 || this._dispatcher.checkBlocksNotInAllocatedSection(ar.getSection(), ar) != null)) continue;
                List<ActiveTrain> activeTrainsList = this._dispatcher.getActiveTrainsList();
                if (activeTrainsList.size() == 1) {
                    if (!this.allocateMore(ar)) continue;
                    continue;
                }
                okToAllocate = true;
                ArrayList<ActiveTrain> neededByTrainList = new ArrayList<ActiveTrain>();
                for (int j = 0; j < activeTrainsList.size(); ++j) {
                    ActiveTrain at = activeTrainsList.get(j);
                    if (at == activeTrain || !this.sectionNeeded(ar, at)) continue;
                    neededByTrainList.add(at);
                }
                for (int k = 0; k < neededByTrainList.size(); ++k) {
                    ActiveTrain nt = (ActiveTrain)neededByTrainList.get(k);
                    if (this.sameDirection(ar, nt)) {
                        if (!this.firstTrainLeadsSecond(activeTrain, nt) || nt.getPriority() <= activeTrain.getPriority() || !this.checkForPassingPlan(ar, nt, neededByTrainList) || this.willAllocatingFollowPlan(ar, this.getPlanThisTrain(activeTrain))) continue;
                        okToAllocate = false;
                        continue;
                    }
                    if (!this.willTrainsCross(activeTrain, nt) || !this.checkForXingPlan(ar, nt, neededByTrainList) || this.willAllocatingFollowPlan(ar, this.getPlanThisTrain(activeTrain))) continue;
                    okToAllocate = false;
                }
                if (okToAllocate && !this.allocateMore(ar)) continue;
            }
            catch (RuntimeException e) {
                log.warn("scanAllocationRequestList - maybe the allocationrequest was removed due to a terminating train??", (Throwable)e);
            }
        }
    }

    protected void removeAllReservesForTrain(String trainName) {
        Iterator<Map.Entry<String, String>> iterRS = this.reservedSections.entrySet().iterator();
        while (iterRS.hasNext()) {
            Map.Entry<String, String> pair = iterRS.next();
            if (!pair.getValue().equals(trainName)) continue;
            iterRS.remove();
        }
    }

    protected void releaseReservation(String trainName, String sectionSystemName) {
        String reservedTrainName = this.reservedSections.get(sectionSystemName);
        if (reservedTrainName.equals(trainName)) {
            this.reservedSections.remove(sectionSystemName);
        }
    }

    protected Section checkBlocksNotInReservedSection(ActiveTrain at, Section sectionToCheck) {
        String trainName = at.getTrainName();
        List<Block> lb = sectionToCheck.getBlockList();
        for (Map.Entry<String, String> pair : this.reservedSections.entrySet()) {
            if (pair.getValue().equals(trainName)) continue;
            Section s = InstanceManager.getDefault(SectionManager.class).getSection(pair.getKey());
            for (Block rb : s.getBlockList()) {
                if (!lb.contains(rb)) continue;
                return s;
            }
        }
        return null;
    }

    private boolean checkUnallocatedCleanly(ActiveTrain at, Section section) {
        for (ActiveTrain atx : InstanceManager.getDefault(DispatcherFrame.class).getActiveTrainsList()) {
            for (AllocatedSection asx : atx.getAllocatedSectionList()) {
                if (asx.getSection() != section) continue;
                return false;
            }
        }
        return true;
    }

    protected Section autoNextSectionChoice(List<Section> sList, AllocationRequest ar, int sectionSeqNo) {
        int i;
        if (this.savedAR != null && this.savedAR == ar) {
            for (int j = 0; j < sList.size(); ++j) {
                if (this.savedSection != sList.get(j)) continue;
                return this.savedSection;
            }
            log.warn("Failure of prepared choice of next Section in AutoAllocate");
        }
        ActiveTrain at = ar.getActiveTrain();
        for (Section sectionOption : sList) {
            String reservedTrainName = this.reservedSections.get(sectionOption.getSystemName());
            if (reservedTrainName == null || !reservedTrainName.equals(at.getTrainName())) continue;
            return sectionOption;
        }
        at = ar.getActiveTrain();
        AllocationPlan ap = this.getPlanThisTrain(at);
        Section as = null;
        if (ap != null) {
            if (ap.getActiveTrain(1) == at) {
                as = ap.getTargetSection(1);
            } else if (ap.getActiveTrain(2) == at) {
                as = ap.getTargetSection(2);
            } else {
                return null;
            }
            for (int i2 = 0; i2 < sList.size(); ++i2) {
                if (as == null || as != sList.get(i2)) continue;
                return as;
            }
        }
        for (i = 0; i < sList.size(); ++i) {
            if (at.getEndBlockSectionSequenceNumber() != sectionSeqNo || !at.getEndBlockSection().getSystemName().equals(sList.get(i).getSystemName())) continue;
            return sList.get(i);
        }
        for (i = 0; i < sList.size(); ++i) {
            if (sList.get(i).getOccupancy() != 4 || sList.get(i).getState() != 2 || ar.getActiveTrain().getSignalType() != 0 && ar.getActiveTrain().getSignalType() != 2 && (ar.getActiveTrain().getSignalType() != 1 || this._dispatcher.checkBlocksNotInAllocatedSection(sList.get(i), ar) != null)) continue;
            return sList.get(i);
        }
        int dir = ar.getSectionDirection();
        List<AllocatedSection> allocatedSections = this._dispatcher.getAllocatedSectionsList();
        for (int m = 0; m < sList.size(); ++m) {
            boolean notFound = true;
            for (int k = 0; k < allocatedSections.size() && notFound; ++k) {
                if (sList.get(m) != allocatedSections.get(k).getSection()) continue;
                notFound = false;
                if (allocatedSections.get(k).getSection().getState() != dir) continue;
                return sList.get(m);
            }
        }
        return null;
    }

    private void copyAndSortARs(List<AllocationRequest> list) {
        this.orderedRequests.clear();
        for (int i = 0; i < list.size(); ++i) {
            this.orderedRequests.add(list.get(i));
        }
        this.orderedRequests.sort((e1, e2) -> {
            if (e1.getActiveTrain().getPriority() < e2.getActiveTrain().getPriority()) {
                return 1;
            }
            if (e1.getActiveTrain().getPriority() > e2.getActiveTrain().getPriority()) {
                return -1;
            }
            return e1.getActiveTrain().getTrainName().compareTo(e2.getActiveTrain().getTrainName());
        });
    }

    private boolean stopAllocateSensorSet(ActiveTrain at, TransitSection lastAllocatedTransitSection) {
        if (lastAllocatedTransitSection.getStopAllocatingSensor() != null && !lastAllocatedTransitSection.getStopAllocatingSensor().equals("")) {
            String sensorName = lastAllocatedTransitSection.getStopAllocatingSensor();
            try {
                Sensor sensor = InstanceManager.sensorManagerInstance().provideSensor(sensorName);
                if (sensor.getKnownState() == 2) {
                    log.trace("Sensor[{}] InActive", (Object)sensor.getDisplayName(USERSYS));
                    at.initializeRestartAllocationSensor(InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(sensorName, sensor));
                    return true;
                }
            }
            catch (NumberFormatException ex) {
                log.error("Error with pause/stop allocation sensor[{}]", (Object)sensorName, (Object)ex);
                return false;
            }
        }
        return false;
    }

    private AllocationPlan getPlanThisTrain(ActiveTrain at) {
        for (int i = 0; i < this._planList.size(); ++i) {
            AllocationPlan ap = this._planList.get(i);
            for (int j = 1; j < 3; ++j) {
                if (ap.getActiveTrain(j) != at) continue;
                return ap;
            }
        }
        return null;
    }

    private boolean willAllocatingFollowPlan(AllocationRequest ar, AllocationPlan ap) {
        ActiveTrain at = ar.getActiveTrain();
        int cTrainNum = 0;
        if (ap.getActiveTrain(1) == at) {
            cTrainNum = 1;
        } else if (ap.getActiveTrain(2) == at) {
            cTrainNum = 2;
        } else {
            log.error("Requesting train not in Allocation Plan");
            return false;
        }
        return !at.isAllocationReversed() ? ap.getTargetSectionSequenceNum(cTrainNum) >= ar.getSectionSeqNumber() && ar.getSection().getState() == 2 && ar.getSection().getOccupancy() != 2 : ap.getTargetSectionSequenceNum(cTrainNum) <= ar.getSectionSeqNumber() && ar.getSection().getState() == 2 && ar.getSection().getOccupancy() != 2;
    }

    private void removeCompletePlans() {
        boolean foundCompletePlan = true;
        while (foundCompletePlan) {
            foundCompletePlan = false;
            for (int i = 0; !foundCompletePlan && i < this._planList.size(); ++i) {
                foundCompletePlan = this._planList.get(i).isComplete();
                if (!foundCompletePlan) continue;
                this._planList.get(i).dispose();
                this._planList.remove(i);
            }
        }
    }

    protected void clearAllocationPlans() {
        for (int i = this._planList.size() - 1; i >= 0; --i) {
            AllocationPlan ap = this._planList.get(i);
            this._planList.remove(i);
            ap.dispose();
        }
    }

    private boolean allocateMore(AllocationRequest ar) {
        log.trace("in allocateMore, ar.Section={}", (Object)ar.getSection().getDisplayName(USERSYS));
        int allocateSectionsAhead = ar.getActiveTrain().getAllocateMethod();
        if (allocateSectionsAhead == -1) {
            return this._dispatcher.allocateSection(ar, null) != null;
        }
        List<AllocatedSection> aSectionList = ar.getActiveTrain().getAllocatedSectionList();
        boolean allocateBySafeSections = false;
        if (allocateSectionsAhead == 0) {
            allocateBySafeSections = true;
        }
        if (allocateBySafeSections && aSectionList.size() >= 1 || !allocateBySafeSections && aSectionList.size() >= allocateSectionsAhead + 1) {
            int curSeq = ar.getSectionSeqNumber() - 1;
            if (ar.getActiveTrain().isAllocationReversed()) {
                curSeq = ar.getSectionSeqNumber() + 1;
            }
            if (curSeq == 1 && ar.getActiveTrain().getResetWhenDone()) {
                curSeq = ar.getActiveTrain().getTransit().getMaxSequence();
            }
            AllocatedSection curAS = null;
            for (int i = aSectionList.size() - 1; i >= 0; --i) {
                AllocatedSection as = aSectionList.get(i);
                if (as == null || as.getSequence() != curSeq) continue;
                curAS = as;
            }
            if (allocateBySafeSections && curAS != null && curAS.getSection().getOccupancy() != 2 && (ar.getActiveTrain().getLastAllocOverrideSafe() == null || ar.getActiveTrain().getLastAllocOverrideSafe() != curAS.getSection()) && ar.getActiveTrain().getTransit().getTransitSectionFromSectionAndSeq(curAS.getSection(), curSeq).isSafe()) {
                log.trace("{}: not at end of safe allocations, [{}] not allocated", (Object)ar.getActiveTrain().getTrainName(), (Object)ar.getSection().getDisplayName(USERSYS));
                return false;
            }
            if (allocateBySafeSections) {
                log.trace("auto allocating Section keep going");
                return this._dispatcher.allocateSection(ar, null) != null;
            }
            log.trace("Auto allocating by count");
            int numberAllocatedButUnoccupied = 0;
            for (int i = aSectionList.size() - 1; i >= 0; --i) {
                AllocatedSection as = aSectionList.get(i);
                if (as == null || as.getSection().getOccupancy() == 2 || as.getExited()) continue;
                ++numberAllocatedButUnoccupied;
            }
            log.trace("FinalCounter[{}]", (Object)numberAllocatedButUnoccupied);
            if (numberAllocatedButUnoccupied < allocateSectionsAhead) {
                return this._dispatcher.allocateSection(ar, null) != null;
            }
            return false;
        }
        log.debug("{}: auto allocating Section {}", (Object)ar.getActiveTrain().getTrainName(), (Object)ar.getSection().getDisplayName(USERSYS));
        return this._dispatcher.allocateSection(ar, null) != null;
    }

    private boolean checkForXingPlan(AllocationRequest ar, ActiveTrain nt, List<ActiveTrain> neededByTrainList) {
        ActiveTrain at;
        int aSecSeq;
        int nSecSeq;
        Section aSec;
        Section nSec;
        block13: {
            block15: {
                block14: {
                    block12: {
                        nSec = null;
                        aSec = null;
                        nSecSeq = 0;
                        aSecSeq = 0;
                        at = ar.getActiveTrain();
                        AllocationPlan apx = this.getPlanThisTrain(nt);
                        if (apx == null) break block12;
                        if (apx.getPlanType() != 1) {
                            return false;
                        }
                        if (apx.getActiveTrain(1) == nt) {
                            nSecSeq = apx.getTargetSectionSequenceNum(1);
                            nSec = apx.getTargetSection(1);
                        } else {
                            nSecSeq = apx.getTargetSectionSequenceNum(2);
                            nSec = apx.getTargetSection(2);
                        }
                        ArrayList<Section> nSections = nt.getTransit().getSectionListBySeq(nSecSeq);
                        if (nSections.size() <= 1) {
                            return false;
                        }
                        aSec = this.getBestOtherSection(nSections, nSec);
                        if (aSec == null) {
                            return false;
                        }
                        aSecSeq = this.willTraverse(aSec, at, this.getCurrentSequenceNumber(at));
                        if (aSecSeq == 0) {
                            return false;
                        }
                        break block13;
                    }
                    int aSeq = ar.getSectionSeqNumber();
                    aSecSeq = this.findPassingSection(at, aSeq);
                    if (aSecSeq != 0) break block14;
                    int nCurrentSeq = this.getCurrentSequenceNumber(nt);
                    nSecSeq = this.findPassingSection(nt, nCurrentSeq);
                    if (nSecSeq <= 0) break block15;
                    ArrayList<Section> nSections = nt.getTransit().getSectionListBySeq(nSecSeq);
                    for (int i = 0; i < nSections.size() && aSec == null; ++i) {
                        aSecSeq = this.willTraverse((Section)nSections.get(i), at, aSeq);
                        if (aSecSeq <= 0) continue;
                        aSec = at.getTransit().getSectionListBySeq(aSecSeq).get(0);
                    }
                    if (aSec == null) break block15;
                    nSec = this.getBestOtherSection(nSections, aSec);
                    break block15;
                }
                ArrayList<Section> aSections = at.getTransit().getSectionListBySeq(aSecSeq);
                int nCurrentSeq = this.getCurrentSequenceNumber(nt);
                for (int i = 0; i < aSections.size() && aSec == null; ++i) {
                    nSecSeq = this.willTraverse((Section)aSections.get(i), nt, nCurrentSeq);
                    if (nSecSeq <= 0) continue;
                    nSec = (Section)aSections.get(i);
                    aSec = this.getBestOtherSection(aSections, nSec);
                }
            }
            if (aSec == null || nSec == null) {
                return false;
            }
        }
        if (neededByTrainList.size() > 2) {
            if (!this.areTrainsAdjacent(at, nt)) {
                return false;
            }
            if (this.isThereConflictingPlan(at, aSec, aSecSeq, nt, nSec, nSecSeq, 1)) {
                return false;
            }
        }
        AllocationPlan ap = new AllocationPlan(this, this.nextPlanNum);
        ++this.nextPlanNum;
        ap.setPlanType(1);
        ap.setActiveTrain(at, 1);
        ap.setTargetSection(aSec, aSecSeq, 1);
        ap.setActiveTrain(nt, 2);
        ap.setTargetSection(nSec, nSecSeq, 2);
        this._planList.add(ap);
        return true;
    }

    private boolean checkForPassingPlan(AllocationRequest ar, ActiveTrain nt, List<ActiveTrain> neededByTrainList) {
        ActiveTrain at;
        int aSecSeq;
        int nSecSeq;
        Section aSec;
        Section nSec;
        block20: {
            block22: {
                block21: {
                    block19: {
                        int i;
                        nSec = null;
                        aSec = null;
                        nSecSeq = 0;
                        aSecSeq = 0;
                        at = ar.getActiveTrain();
                        AllocationPlan apx = this.getPlanThisTrain(nt);
                        if (apx == null) break block19;
                        if (apx.getPlanType() != 2) {
                            return false;
                        }
                        Section oSection = null;
                        if (apx.getActiveTrain(1) == nt) {
                            nSecSeq = apx.getTargetSectionSequenceNum(1);
                            nSec = apx.getTargetSection(1);
                            oSection = apx.getTargetSection(2);
                        } else {
                            nSecSeq = apx.getTargetSectionSequenceNum(2);
                            nSec = apx.getTargetSection(2);
                            oSection = apx.getTargetSection(1);
                        }
                        int aCurrentSeq = this.getCurrentSequenceNumber(at);
                        aSecSeq = this.willTraverse(nSec, at, aCurrentSeq);
                        if (aSecSeq == 0) {
                            return false;
                        }
                        ArrayList<Section> nSections = nt.getTransit().getSectionListBySeq(nSecSeq);
                        if (nSections.size() <= 1) {
                            return false;
                        }
                        for (i = 0; i < nSections.size() && aSec == null; ++i) {
                            if (nSections.get(i) != oSection || (aSecSeq = this.willTraverse((Section)nSections.get(i), at, aCurrentSeq)) <= 0) continue;
                            aSec = (Section)nSections.get(i);
                        }
                        if (aSec == null) {
                            for (i = 0; i < nSections.size() && aSec == null; ++i) {
                                if (nSections.get(i) == nSec || (aSecSeq = this.willTraverse((Section)nSections.get(i), at, aCurrentSeq)) <= 0) continue;
                                aSec = (Section)nSections.get(i);
                            }
                        }
                        if (aSec == null) {
                            return false;
                        }
                        break block20;
                    }
                    int aSeq = ar.getSectionSeqNumber();
                    aSecSeq = this.findPassingSection(at, aSeq);
                    if (aSecSeq != 0) break block21;
                    int nCurrentSeq = this.getCurrentSequenceNumber(nt);
                    nSecSeq = this.findPassingSection(nt, nCurrentSeq);
                    if (nSecSeq <= 0) break block22;
                    ArrayList<Section> nSections = nt.getTransit().getSectionListBySeq(nSecSeq);
                    for (int i = 0; i < nSections.size() && aSec == null; ++i) {
                        aSecSeq = this.willTraverse((Section)nSections.get(i), at, aSeq);
                        if (aSecSeq <= 0) continue;
                        aSec = at.getTransit().getSectionListBySeq(aSecSeq).get(0);
                    }
                    if (aSec == null) break block22;
                    nSec = this.getBestOtherSection(nSections, aSec);
                    break block22;
                }
                ArrayList<Section> aSections = at.getTransit().getSectionListBySeq(aSecSeq);
                int nCurrentSeq = this.getCurrentSequenceNumber(nt);
                for (int i = 0; i < aSections.size() && aSec == null; ++i) {
                    nSecSeq = this.willTraverse((Section)aSections.get(i), nt, nCurrentSeq);
                    if (nSecSeq <= 0) continue;
                    nSec = (Section)aSections.get(i);
                    aSec = this.getBestOtherSection(aSections, nSec);
                }
            }
            if (aSec == null || nSec == null) {
                return false;
            }
            if (!nt.isAllocationReversed()) {
                if (nSecSeq < nt.getTransit().getMaxSequence()) {
                    nSec = nt.getTransit().getSectionListBySeq(++nSecSeq).get(0);
                }
            } else if (nSecSeq > 1) {
                nSec = nt.getTransit().getSectionListBySeq(--nSecSeq).get(0);
            }
        }
        if (neededByTrainList.size() > 2) {
            if (!this.areTrainsAdjacent(at, nt)) {
                return false;
            }
            if (this.isThereConflictingPlan(at, aSec, aSecSeq, nt, nSec, nSecSeq, 2)) {
                return false;
            }
        }
        AllocationPlan ap = new AllocationPlan(this, this.nextPlanNum);
        ++this.nextPlanNum;
        ap.setPlanType(2);
        ap.setActiveTrain(at, 1);
        ap.setTargetSection(aSec, aSecSeq, 1);
        ap.setActiveTrain(nt, 2);
        ap.setTargetSection(nSec, nSecSeq, 2);
        this._planList.add(ap);
        return true;
    }

    private boolean isThereConflictingPlan(ActiveTrain at, Section aSec, int aSecSeq, ActiveTrain nt, Section nSec, int nSecSeq, int type) {
        if (this._planList.size() == 0) {
            return false;
        }
        for (int i = 0; i < this._planList.size(); ++i) {
            AllocationPlan ap = this._planList.get(i);
            int trainNum = 0;
            if (ap.getActiveTrain(1) == nt) {
                trainNum = 1;
            } else if (ap.getActiveTrain(2) == nt) {
                trainNum = 2;
            }
            if (trainNum > 0) {
                if (ap.getPlanType() == type && ap.getTargetSection(trainNum) == nSec && ap.getTargetSectionSequenceNum(trainNum) == nSecSeq) continue;
                return true;
            }
            ArrayList<Section> aSections = at.getTransit().getSectionListBySeq(aSecSeq);
            for (int j = 0; j < aSections.size(); ++j) {
                if (aSections.get(j) != ap.getTargetSection(1) && aSections.get(j) != ap.getTargetSection(2)) continue;
                return true;
            }
        }
        return false;
    }

    private Section getBestOtherSection(List<Section> sList, Section aSec) {
        int i;
        for (i = 0; i < sList.size(); ++i) {
            if (sList.get(i) == aSec || sList.get(i).getState() != 2 || sList.get(i).getOccupancy() == 2) continue;
            return sList.get(i);
        }
        for (i = 0; i < sList.size(); ++i) {
            if (sList.get(i) == aSec || sList.get(i).getOccupancy() == 2) continue;
            return sList.get(i);
        }
        for (i = 0; i < sList.size(); ++i) {
            if (sList.get(i) == aSec) continue;
            return sList.get(i);
        }
        return null;
    }

    private int findPassingSection(ActiveTrain at, int aSeq) {
        Transit t = at.getTransit();
        if (!at.isTransitReversed()) {
            for (int i = aSeq; i <= t.getMaxSequence(); ++i) {
                if (t.getSectionListBySeq(i).size() <= 1) continue;
                return i;
            }
        } else {
            for (int i = aSeq; i >= 0; --i) {
                if (t.getSectionListBySeq(i).size() <= 1) continue;
                return i;
            }
        }
        return 0;
    }

    private int willTraverse(Section s, ActiveTrain at, int seq) {
        Transit t = at.getTransit();
        if (!at.isTransitReversed()) {
            for (int i = seq; i <= t.getMaxSequence(); ++i) {
                for (int j = 0; j < t.getSectionListBySeq(i).size(); ++j) {
                    if (t.getSectionListBySeq(i).get(j) != s) continue;
                    return i;
                }
            }
        } else {
            for (int i = seq; i >= 0; --i) {
                for (int j = 0; j < t.getSectionListBySeq(i).size(); ++j) {
                    if (t.getSectionListBySeq(i).get(j) != s) continue;
                    return i;
                }
            }
        }
        return 0;
    }

    private boolean sectionNeeded(AllocationRequest ar, ActiveTrain at) {
        block16: {
            int j;
            int i;
            if (ar == null || at == null) {
                log.error("null argument on entry to 'sectionNeeded'");
                return false;
            }
            ArrayList<Section> aSectionList = ar.getActiveTrain().getTransit().getSectionListBySeq(ar.getSectionSeqNumber());
            boolean found = false;
            for (int i2 = 0; i2 < aSectionList.size(); ++i2) {
                if (at.getTransit().containsSection((Section)aSectionList.get(i2))) continue;
                found = true;
            }
            if (!found) {
                return false;
            }
            if (at.getResetWhenDone() || at.getReverseAtEnd() && !at.isAllocationReversed()) {
                return true;
            }
            ArrayList<TransitSection> tsList = at.getTransit().getTransitSectionList();
            int curSeq = this.getCurrentSequenceNumber(at);
            if (!at.isAllocationReversed()) {
                for (i = 0; i < tsList.size(); ++i) {
                    if (((TransitSection)tsList.get(i)).getSequenceNumber() <= curSeq) continue;
                    for (j = 0; j < aSectionList.size(); ++j) {
                        if (((TransitSection)tsList.get(i)).getSection() != aSectionList.get(j)) continue;
                        return true;
                    }
                }
            } else {
                for (i = tsList.size() - 1; i >= 0; --i) {
                    if (((TransitSection)tsList.get(i)).getSequenceNumber() >= curSeq) continue;
                    for (j = 0; j < aSectionList.size(); ++j) {
                        if (((TransitSection)tsList.get(i)).getSection() != aSectionList.get(j)) continue;
                        return true;
                    }
                }
            }
            if (ar.getActiveTrain().getSignalType() != 1) break block16;
            if (!at.isAllocationReversed()) {
                for (i = 0; i < tsList.size(); ++i) {
                    if (((TransitSection)tsList.get(i)).getSequenceNumber() <= curSeq) continue;
                    for (j = 0; j < aSectionList.size(); ++j) {
                        if (((TransitSection)tsList.get(i)).getSection() != aSectionList.get(j)) continue;
                        return true;
                    }
                }
            } else {
                for (i = tsList.size() - 1; i >= 0; --i) {
                    if (((TransitSection)tsList.get(i)).getSequenceNumber() >= curSeq) continue;
                    for (j = 0; j < aSectionList.size(); ++j) {
                        if (((TransitSection)tsList.get(i)).getSection() != aSectionList.get(j)) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private boolean sameDirection(AllocationRequest ar, ActiveTrain at) {
        if (ar == null || at == null) {
            log.error("null argument on entry to 'sameDirection'");
            return false;
        }
        ArrayList<TransitSection> tsList = at.getTransit().getTransitSectionList();
        ArrayList<TransitSection> rtsList = ar.getActiveTrain().getTransit().getTransitSectionListBySeq(ar.getSectionSeqNumber());
        int curSeq = this.getCurrentSequenceNumber(at);
        if (!at.isAllocationReversed()) {
            for (int i = 0; i < tsList.size(); ++i) {
                if (((TransitSection)tsList.get(i)).getSequenceNumber() <= curSeq) continue;
                for (int k = 0; k < rtsList.size(); ++k) {
                    if (((TransitSection)tsList.get(i)).getSection() != ((TransitSection)rtsList.get(k)).getSection() || ((TransitSection)tsList.get(i)).getDirection() != ((TransitSection)rtsList.get(k)).getDirection()) continue;
                    return true;
                }
            }
        } else {
            for (int i = tsList.size() - 1; i >= 0; --i) {
                if (((TransitSection)tsList.get(i)).getSequenceNumber() >= curSeq) continue;
                for (int k = 0; k < rtsList.size(); ++k) {
                    if (((TransitSection)tsList.get(i)).getSection() != ((TransitSection)rtsList.get(k)).getSection() || ((TransitSection)tsList.get(i)).getDirection() != ((TransitSection)rtsList.get(k)).getDirection()) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean firstTrainLeadsSecond(ActiveTrain at, ActiveTrain nt) {
        int i;
        int aSeq = this.getCurrentSequenceNumber(at);
        Section aSec = this.getCurSection();
        int nSeq = this.getCurrentSequenceNumber(nt);
        Section nSec = this.getCurSection();
        ArrayList<TransitSection> atsList = at.getTransit().getTransitSectionList();
        if (!at.isTransitReversed()) {
            for (i = 0; i < atsList.size(); ++i) {
                if (((TransitSection)atsList.get(i)).getSequenceNumber() <= aSeq || ((TransitSection)atsList.get(i)).getSection() != nSec) continue;
                return false;
            }
        } else {
            for (i = atsList.size() - 1; i <= 0; --i) {
                if (((TransitSection)atsList.get(i)).getSequenceNumber() >= aSeq || ((TransitSection)atsList.get(i)).getSection() != nSec) continue;
                return false;
            }
        }
        ArrayList<TransitSection> ntsList = nt.getTransit().getTransitSectionList();
        if (!nt.isTransitReversed()) {
            for (int i2 = 0; i2 < ntsList.size(); ++i2) {
                if (((TransitSection)ntsList.get(i2)).getSequenceNumber() <= nSeq || ((TransitSection)ntsList.get(i2)).getSection() != aSec) continue;
                return true;
            }
        } else {
            for (int i3 = ntsList.size() - 1; i3 <= 0; --i3) {
                if (((TransitSection)ntsList.get(i3)).getSequenceNumber() >= nSeq || ((TransitSection)ntsList.get(i3)).getSection() != aSec) continue;
                return true;
            }
        }
        return false;
    }

    private boolean willTrainsCross(ActiveTrain at, ActiveTrain nt) {
        int i;
        int aSeq = this.getCurrentSequenceNumber(at);
        Section aSec = this.getCurSection();
        int nSeq = this.getCurrentSequenceNumber(nt);
        Section nSec = this.getCurSection();
        ArrayList<TransitSection> atsList = at.getTransit().getTransitSectionList();
        boolean found = false;
        if (!at.isTransitReversed()) {
            for (i = 0; i < atsList.size() && !found; ++i) {
                if (((TransitSection)atsList.get(i)).getSequenceNumber() <= aSeq || ((TransitSection)atsList.get(i)).getSection() != nSec) continue;
                found = true;
            }
        } else {
            for (i = atsList.size() - 1; i <= 0 && !found; --i) {
                if (((TransitSection)atsList.get(i)).getSequenceNumber() >= aSeq || ((TransitSection)atsList.get(i)).getSection() != nSec) continue;
                found = true;
            }
        }
        if (!found) {
            return false;
        }
        ArrayList<TransitSection> ntsList = nt.getTransit().getTransitSectionList();
        if (!nt.isTransitReversed()) {
            for (int i2 = 0; i2 < ntsList.size(); ++i2) {
                if (((TransitSection)ntsList.get(i2)).getSequenceNumber() <= nSeq || ((TransitSection)ntsList.get(i2)).getSection() != aSec) continue;
                return true;
            }
        } else {
            for (int i3 = ntsList.size() - 1; i3 <= 0; --i3) {
                if (((TransitSection)ntsList.get(i3)).getSequenceNumber() >= nSeq || ((TransitSection)ntsList.get(i3)).getSection() != aSec) continue;
                return true;
            }
        }
        return false;
    }

    private boolean areTrainsAdjacent(ActiveTrain at, ActiveTrain nt) {
        List<AllocatedSection> allocatedSections = this._dispatcher.getAllocatedSectionsList();
        ArrayList<TransitSection> atsList = at.getTransit().getTransitSectionList();
        int aSeq = this.getCurrentSequenceNumber(at);
        Section nSec = this.getCurSection();
        if (this.willTraverse(nSec, at, aSeq) != 0) {
            if (!at.isTransitReversed()) {
                for (int i = 0; i < atsList.size(); ++i) {
                    if (((TransitSection)atsList.get(i)).getSequenceNumber() <= aSeq) continue;
                    Section tSec = ((TransitSection)atsList.get(i)).getSection();
                    if (tSec == nSec) {
                        return true;
                    }
                    for (int j = 0; j < allocatedSections.size(); ++j) {
                        if (allocatedSections.get(j).getSection() != tSec || allocatedSections.get(j).getActiveTrain() == at || allocatedSections.get(j).getActiveTrain() == nt) continue;
                        return false;
                    }
                }
            } else {
                for (int i = atsList.size() - 1; i <= 0; --i) {
                    if (((TransitSection)atsList.get(i)).getSequenceNumber() >= aSeq) continue;
                    Section tSec = ((TransitSection)atsList.get(i)).getSection();
                    if (tSec == nSec) {
                        return true;
                    }
                    for (int j = 0; j < allocatedSections.size(); ++j) {
                        if (allocatedSections.get(j).getSection() != tSec || allocatedSections.get(j).getActiveTrain() == at || allocatedSections.get(j).getActiveTrain() == nt) continue;
                        return false;
                    }
                }
            }
        } else if (at.isTransitReversed()) {
            for (int i = 0; i < atsList.size(); ++i) {
                if (((TransitSection)atsList.get(i)).getSequenceNumber() <= aSeq) continue;
                Section tSec = ((TransitSection)atsList.get(i)).getSection();
                if (tSec == nSec) {
                    return true;
                }
                for (int j = 0; j < allocatedSections.size(); ++j) {
                    if (allocatedSections.get(j).getSection() != tSec || allocatedSections.get(j).getActiveTrain() == at || allocatedSections.get(j).getActiveTrain() == nt) continue;
                    return false;
                }
            }
        } else {
            for (int i = atsList.size() - 1; i <= 0; --i) {
                if (((TransitSection)atsList.get(i)).getSequenceNumber() >= aSeq) continue;
                Section tSec = ((TransitSection)atsList.get(i)).getSection();
                if (tSec == nSec) {
                    return true;
                }
                for (int j = 0; j < allocatedSections.size(); ++j) {
                    if (allocatedSections.get(j).getSection() != tSec || allocatedSections.get(j).getActiveTrain() == at || allocatedSections.get(j).getActiveTrain() == nt) continue;
                    return false;
                }
            }
        }
        return false;
    }

    private int getCurrentSequenceNumber(ActiveTrain at) {
        int seq = 0;
        this.curSection = null;
        if (at == null) {
            log.error("null argument on entry to 'getCurrentSeqNumber'");
            return seq;
        }
        Section temSection = null;
        ArrayList<TransitSection> tsList = at.getTransit().getTransitSectionList();
        if (!at.isTransitReversed()) {
            for (int i = 0; i < tsList.size(); ++i) {
                if (((TransitSection)tsList.get(i)).getSection().getOccupancy() != 2 || !this.isSectionAllocatedToTrain(((TransitSection)tsList.get(i)).getSection(), ((TransitSection)tsList.get(i)).getSequenceNumber(), at)) continue;
                seq = ((TransitSection)tsList.get(i)).getSequenceNumber();
                temSection = ((TransitSection)tsList.get(i)).getSection();
            }
            if (seq == at.getTransit().getMaxSequence() && at.getResetWhenDone()) {
                boolean further = true;
                for (int j = 0; j < tsList.size() && further; ++j) {
                    if (((TransitSection)tsList.get(j)).getSection().getOccupancy() == 2 && this.isSectionAllocatedToTrain(((TransitSection)tsList.get(j)).getSection(), ((TransitSection)tsList.get(j)).getSequenceNumber(), at)) {
                        seq = ((TransitSection)tsList.get(j)).getSequenceNumber();
                        temSection = ((TransitSection)tsList.get(j)).getSection();
                        continue;
                    }
                    further = false;
                }
            }
        } else {
            for (int i = tsList.size() - 1; i >= 0; --i) {
                if (((TransitSection)tsList.get(i)).getSection().getOccupancy() != 2 || !this.isSectionAllocatedToTrain(((TransitSection)tsList.get(i)).getSection(), ((TransitSection)tsList.get(i)).getSequenceNumber(), at)) continue;
                seq = ((TransitSection)tsList.get(i)).getSequenceNumber();
                temSection = ((TransitSection)tsList.get(i)).getSection();
            }
        }
        if (seq == 0) {
            if (at.getMode() != 4) {
                log.error("{}: ActiveTrain has no occupied Section. Halting immediately to avoid runaway.", (Object)at.getTrainName());
                at.getAutoActiveTrain().getAutoEngineer().setHalt(true);
            } else {
                log.debug("{}: ActiveTrain has no occupied Section, running in Manual mode.", (Object)at.getTrainName());
            }
        } else {
            this.curSection = temSection;
        }
        return seq;
    }

    private Section getCurSection() {
        return this.curSection;
    }

    private boolean isSectionAllocatedToTrain(Section s, int seq, ActiveTrain at) {
        if (s == null || at == null) {
            log.error("null argument to isSectionAllocatedToTrain");
            return false;
        }
        List<AllocatedSection> asList = at.getAllocatedSectionList();
        for (int i = 0; i < asList.size(); ++i) {
            if (asList.get(i).getSection() != s || asList.get(i).getSequence() != seq) continue;
            return true;
        }
        return false;
    }

    private boolean waitingForStartTime(AllocationRequest ar) {
        if (ar != null) {
            ActiveTrain at = ar.getActiveTrain();
            if (at == null) {
                return false;
            }
            if (!at.getStarted() && at.getDelayedStart() != 0 || at.reachedRestartPoint()) {
                return true;
            }
        }
        return false;
    }

    private boolean isSignalHeldAtStartOfSection(AllocationRequest ar) {
        if (ar == null) {
            return false;
        }
        Section sec = ar.getSection();
        ActiveTrain mActiveTrain = ar.getActiveTrain();
        if (sec == null || mActiveTrain == null) {
            return false;
        }
        Section lastSec = mActiveTrain.getLastAllocatedSection();
        if (lastSec == null) {
            return false;
        }
        if (!sec.equals(mActiveTrain.getNextSectionToAllocate())) {
            log.error("[{}]Allocation request section does not match active train next section to allocate", (Object)mActiveTrain.getActiveTrainName());
            log.error("[{}]Section requested {}", (Object)mActiveTrain.getActiveTrainName(), (Object)sec.getDisplayName(USERSYS));
            if (mActiveTrain.getNextSectionToAllocate() != null) {
                log.error("[{}]Section expected {}", (Object)mActiveTrain.getActiveTrainName(), (Object)mActiveTrain.getNextSectionToAllocate().getDisplayName(USERSYS));
            }
            if (mActiveTrain.getLastAllocatedSection() != null) {
                log.error("[{}]Last Section Allocated {}", (Object)mActiveTrain.getActiveTrainName(), (Object)mActiveTrain.getLastAllocatedSection().getDisplayName(USERSYS));
            }
            return false;
        }
        EntryPoint protectingEP = sec.getEntryPointFromSection(lastSec, ar.getSectionDirection());
        EntryPoint facingEP = lastSec.getExitPointToSection(sec, lastSec.getState());
        if (protectingEP == null || facingEP == null) {
            return false;
        }
        Block protectingBlock = protectingEP.getBlock();
        Block facingBlock = facingEP.getBlock();
        if (protectingBlock == null || facingBlock == null) {
            return false;
        }
        SignalMast sm = InstanceManager.getDefault(LayoutBlockManager.class).getFacingSignalMast(facingBlock, protectingBlock);
        if (sm != null && sm.getHeld() && !this._dispatcher.isMastHeldByDispatcher(sm, mActiveTrain)) {
            ar.setWaitingForSignalMast(sm);
            return true;
        }
        return false;
    }
}

