/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.dispatcher;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Iterator;
import jmri.Block;
import jmri.BlockManager;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.Sensor;
import jmri.SignalHead;
import jmri.SignalHeadManager;
import jmri.SignalMast;
import jmri.SignalMastManager;
import jmri.TransitSection;
import jmri.TransitSectionAction;
import jmri.jmrit.dispatcher.ActiveTrain;
import jmri.jmrit.dispatcher.AllocatedSection;
import jmri.jmrit.dispatcher.AutoActiveTrain;
import jmri.jmrit.dispatcher.DispatcherFrame;
import jmri.util.ThreadingUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoTrainAction {
    private AutoActiveTrain _autoActiveTrain = null;
    private ActiveTrain _activeTrain = null;
    private ArrayList<TransitSection> _activeTransitSectionList = new ArrayList();
    private ArrayList<TransitSectionAction> _activeActionList = new ArrayList();
    private Sensor _doneSensor = null;
    private PropertyChangeListener _doneSensorListener = null;
    private static final Logger log = LoggerFactory.getLogger(AutoTrainAction.class);

    public AutoTrainAction(AutoActiveTrain aat) {
        this._autoActiveTrain = aat;
        this._activeTrain = aat.getActiveTrain();
    }

    protected synchronized boolean isDelayedStart(float speed) {
        for (TransitSectionAction t : this._activeActionList) {
            if (t.getWhenCode() != 9 || t.getTargetTransitSection().getSection() != this._autoActiveTrain.getCurrentAllocatedSection().getSection()) continue;
            log.debug("Start Internal resume task delay[{}] resume target speed[{}] Existing Thread[{}], Section:[{}]", new Object[]{t.getDataWhen(), Float.valueOf(speed), t.getWaitingThread(), t.getTargetTransitSection().getSectionName()});
            if (t.getWaitingThread() == null) {
                log.trace("Adding actions");
                t.setDataWhat1Float(speed);
                this.checkDelay(t);
                for (TransitSectionAction tA : this._activeActionList) {
                    if (tA.getWhenCode() != 10) continue;
                    this.checkDelay(tA);
                }
            } else {
                log.debug("Ignored, Prestart Process already running.");
            }
            return true;
        }
        return false;
    }

    protected synchronized void addTransitSection(TransitSection ts) {
        this._activeTransitSectionList.add(ts);
        log.debug("Adding TransitSection[{}]", (Object)ts.getSectionName());
        ArrayList<TransitSectionAction> tsaList = ts.getTransitSectionActionList();
        if (tsaList.size() > 0) {
            block8: for (int i = 0; i < tsaList.size(); ++i) {
                TransitSectionAction tsa = tsaList.get(i);
                boolean found = false;
                for (int j = 0; j < this._activeActionList.size(); ++j) {
                    if (this._activeActionList.get(j) != tsa) continue;
                    found = true;
                }
                if (!found) {
                    this._activeActionList.add(tsa);
                    tsa.initialize();
                }
                tsa.setTargetTransitSection(ts);
                switch (tsa.getWhenCode()) {
                    case 9: 
                    case 10: {
                        continue block8;
                    }
                    case 1: {
                        this.checkDelay(tsa);
                        continue block8;
                    }
                    case 2: {
                        tsa.setWaitingForSectionExit(true);
                        continue block8;
                    }
                    case 3: 
                    case 4: {
                        tsa.setWaitingForBlock(true);
                        continue block8;
                    }
                    case 5: 
                    case 6: {
                        MonitorTrain monTrain = new MonitorTrain(tsa);
                        Thread tMonTrain = ThreadingUtil.newThread(monTrain, "Monitor Train Transit Action " + this._activeTrain.getDccAddress());
                        tsa.setWaitingThread(tMonTrain);
                        tMonTrain.start();
                        continue block8;
                    }
                    case 7: 
                    case 8: {
                        if (!this.waitOnSensor(tsa)) {
                            this.checkDelay(tsa);
                            continue block8;
                        }
                        tsa.setWaitingForSensor(true);
                        continue block8;
                    }
                }
            }
        }
    }

    private boolean waitOnSensor(TransitSectionAction tsa) {
        if (tsa.getWaitingForSensor()) {
            return true;
        }
        Sensor s = InstanceManager.sensorManagerInstance().getSensor(tsa.getStringWhen());
        if (s == null) {
            log.error("Sensor with name - {} - was not found.", (Object)tsa.getStringWhen());
            return false;
        }
        int now = s.getKnownState();
        if (now == 2 && tsa.getWhenCode() == 7 || now == 4 && tsa.getWhenCode() == 8) {
            return false;
        }
        tsa.setTriggerSensor(s);
        tsa.setWaitingForSensor(true);
        final String sensorName = tsa.getStringWhen();
        PropertyChangeListener sensorListener = null;
        sensorListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                if (e.getPropertyName().equals("KnownState")) {
                    AutoTrainAction.this.handleSensorChange(sensorName);
                }
            }
        };
        s.addPropertyChangeListener(sensorListener);
        tsa.setSensorListener(sensorListener);
        return true;
    }

    public void handleSensorChange(String sName) {
        for (int i = 0; i < this._activeActionList.size(); ++i) {
            TransitSectionAction tsa;
            if (!this._activeActionList.get(i).getWaitingForSensor() || !(tsa = this._activeActionList.get(i)).getStringWhen().equals(sName)) continue;
            tsa.setWaitingForSensor(false);
            if (tsa.getSensorListener() != null) {
                tsa.getTriggerSensor().removePropertyChangeListener(tsa.getSensorListener());
                tsa.setSensorListener(null);
            }
            this.checkDelay(tsa);
            return;
        }
    }

    protected synchronized void handleBlockStateChange(AllocatedSection as, Block b) {
        for (int i = 0; i < this._activeActionList.size(); ++i) {
            if (!this._activeActionList.get(i).getWaitingForBlock()) continue;
            TransitSectionAction tsa = this._activeActionList.get(i);
            Block target = InstanceManager.getDefault(BlockManager.class).getBlock(tsa.getStringWhen());
            if (b != target || (b.getState() != 2 || tsa.getWhenCode() != 3) && (b.getState() != 4 || tsa.getWhenCode() != 4)) continue;
            this.checkDelay(tsa);
        }
    }

    protected synchronized void removeTransitSection(TransitSection ts) {
        int i;
        log.debug("Remove TransitSection[{}]", (Object)ts.getSectionName());
        for (i = this._activeTransitSectionList.size() - 1; i >= 0; --i) {
            if (this._activeTransitSectionList.get(i) != ts) continue;
            this._activeTransitSectionList.remove(i);
        }
        for (i = 0; i < this._activeActionList.size(); ++i) {
            if (!this._activeActionList.get(i).getWaitingForSectionExit() || this._activeActionList.get(i).getTargetTransitSection() != ts) continue;
            this.executeAction(this._activeActionList.get(i));
        }
        for (int ix = this._activeActionList.size() - 1; ix > -1; --ix) {
            TransitSectionAction t = this._activeActionList.get(ix);
            if (t.getTargetTransitSection() != ts) continue;
            if (t.getWaitingThread() != null) {
                t.getWaitingThread().interrupt();
            }
            this._activeActionList.remove(ix);
            Object var3_3 = null;
        }
    }

    private synchronized void completedAction(TransitSectionAction tsa) {
        if (tsa.getWaitingForSensor()) {
            tsa.disposeSensorListener();
        }
        Iterator<TransitSectionAction> itr = this._activeActionList.iterator();
        while (itr.hasNext()) {
            TransitSectionAction t = itr.next();
            if (t != tsa) continue;
            itr.remove();
            return;
        }
    }

    protected synchronized void clearRemainingActions() {
        for (int i = this._activeActionList.size() - 1; i >= 0; --i) {
            TransitSectionAction tsa = this._activeActionList.get(i);
            Thread t = tsa.getWaitingThread();
            if (t != null) {
                log.trace("Interrupting [{}] Code[{}] Section[{}]", new Object[]{t.getName(), tsa.getWhatCode(), tsa.getTargetTransitSection().getSection().getDisplayName()});
                t.interrupt();
            }
            if (tsa.getWaitingForSensor()) {
                tsa.disposeSensorListener();
            }
            tsa.initialize();
            this._activeActionList.remove(i);
        }
    }

    private synchronized void checkDelay(TransitSectionAction tsa) {
        int delay = tsa.getDataWhen();
        if (delay <= 0) {
            this.executeAction(tsa);
        } else {
            TSActionDelay r = new TSActionDelay(tsa, delay);
            Thread t = ThreadingUtil.newThread(r, "Check Delay on Action");
            tsa.setWaitingThread(t);
            t.start();
        }
    }

    private synchronized void listenToDoneSensor(TransitSectionAction tsa) {
        Sensor s = InstanceManager.sensorManagerInstance().getSensor(tsa.getStringWhat());
        if (s == null) {
            log.error("Done Sensor with name - {} - was not found.", (Object)tsa.getStringWhat());
            return;
        }
        this._doneSensor = s;
        this._doneSensorListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                int state;
                if (e.getPropertyName().equals("KnownState") && (state = AutoTrainAction.this._doneSensor.getKnownState()) == 2 && AutoTrainAction.this._activeTrain.getStatus() == 8) {
                    AutoTrainAction.this._activeTrain.getAutoActiveTrain().resumeAutomaticRunning();
                }
            }
        };
        s.addPropertyChangeListener(this._doneSensorListener);
    }

    protected synchronized void cancelDoneSensor() {
        if (this._doneSensor != null) {
            if (this._doneSensorListener != null) {
                this._doneSensor.removePropertyChangeListener(this._doneSensorListener);
            }
            this._doneSensorListener = null;
            this._doneSensor = null;
        }
    }

    @SuppressFBWarnings(value={"SWL_SLEEP_WITH_LOCK_HELD"}, justification="used only by thread that can be stopped, no conflict with other threads expected")
    public synchronized void executeAction(TransitSectionAction tsa) {
        if (tsa == null) {
            log.error("executeAction called with null TransitSectionAction");
            return;
        }
        Sensor s = null;
        float temp = 0.0f;
        block4 : switch (tsa.getWhatCode()) {
            case 18: {
                log.trace("Terminate Train Section [[{}]", (Object)tsa.getTargetTransitSection().getSectionName());
                InstanceManager.getDefault(DispatcherFrame.class).terminateActiveTrain(this._activeTrain, true, false);
                break;
            }
            case 20: {
                log.trace("Force pass next safe Section [[{}]", (Object)tsa.getTargetTransitSection().getSectionName());
                this._activeTrain.forcePassNextSafeSection();
                break;
            }
            case 19: {
                log.info("Section[[{}] LoadTrain [{}]", (Object)tsa.getTargetTransitSection().getSectionName(), (Object)tsa.getStringWhat());
                switch (tsa.getDataWhat2()) {
                    case 1: {
                        log.debug("Spinning off load of {}, using Roster entry {}", (Object)tsa.getStringWhat(), (Object)tsa.getStringWhat2());
                        ThreadingUtil.runOnLayoutDelayed(() -> InstanceManager.getDefault(DispatcherFrame.class).loadTrainFromTrainInfo(tsa.getStringWhat(), "ROSTER", tsa.getStringWhat2()), 2000);
                        break block4;
                    }
                    case 2: {
                        log.debug("Spinning off load of {}, using USER entered address {}", (Object)tsa.getStringWhat(), (Object)tsa.getStringWhat2());
                        ThreadingUtil.runOnLayoutDelayed(() -> InstanceManager.getDefault(DispatcherFrame.class).loadTrainFromTrainInfo(tsa.getStringWhat(), "USER", tsa.getStringWhat2()), 2000);
                        break block4;
                    }
                    case 3: {
                        if (this._activeTrain.getTrainSource() == 1) {
                            log.debug("Spinning off load of {}, using current Roster {}", (Object)tsa.getStringWhat(), (Object)this._activeTrain.getRosterEntry().getId());
                            ThreadingUtil.runOnLayoutDelayed(() -> InstanceManager.getDefault(DispatcherFrame.class).loadTrainFromTrainInfo(tsa.getStringWhat(), "ROSTER", this._activeTrain.getRosterEntry().getId()), 2000);
                            break block4;
                        }
                        log.debug("Spinning off load of {}, using current address {}", (Object)tsa.getStringWhat(), (Object)this._activeTrain.getDccAddress());
                        ThreadingUtil.runOnLayoutDelayed(() -> InstanceManager.getDefault(DispatcherFrame.class).loadTrainFromTrainInfo(tsa.getStringWhat(), "USER", this._activeTrain.getDccAddress()), 2000);
                        break block4;
                    }
                }
                log.debug("Spinning off load of {}, using defaults", (Object)tsa.getStringWhat());
                ThreadingUtil.runOnLayoutDelayed(() -> InstanceManager.getDefault(DispatcherFrame.class).loadTrainFromTrainInfo(tsa.getStringWhat(), "NONE", null), 2000);
                break;
            }
            case 1: {
                log.trace("Pause Started Section:[{}]", (Object)tsa.getTargetTransitSection().getSectionName());
                if (this._autoActiveTrain.getCurrentAllocatedSection().getNextSection() == null) break;
                Thread tPause = this._autoActiveTrain.pauseTrain(tsa.getDataWhat1());
                tsa.setWaitingThread(tPause);
                break;
            }
            case 2: {
                log.trace("Set Max Speed Section:[{}]", (Object)tsa.getTargetTransitSection().getSectionName());
                temp = tsa.getDataWhat1();
                this._autoActiveTrain.setMaxSpeed(temp * 0.01f);
                this.completedAction(tsa);
                break;
            }
            case 17: {
                log.trace("Resume After Prestart Setting Target[{}] Section:[{}]", (Object)Float.valueOf(tsa.getDataWhat1Float()), (Object)tsa.getTargetTransitSection().getSectionName());
                this._autoActiveTrain.setTargetSpeedByPass(tsa.getDataWhat1Float());
                this.completedAction(tsa);
                break;
            }
            case 3: {
                log.trace("Set Current Speed Section:[{}]", (Object)tsa.getTargetTransitSection().getSectionName());
                temp = tsa.getDataWhat1();
                float spd = temp * 0.01f;
                if (spd > this._autoActiveTrain.getMaxSpeed()) {
                    spd = this._autoActiveTrain.getMaxSpeed();
                }
                this._autoActiveTrain.getAutoEngineer().setSpeedImmediate(spd * this._autoActiveTrain.getSpeedFactor());
                this.completedAction(tsa);
                break;
            }
            case 4: {
                log.trace("Set Ramp Speed Section:[{}]", (Object)tsa.getTargetTransitSection().getSectionName());
                temp = tsa.getDataWhat1();
                float spdx = temp * 0.01f;
                if (spdx > this._autoActiveTrain.getMaxSpeed()) {
                    spdx = this._autoActiveTrain.getMaxSpeed();
                }
                this._autoActiveTrain.setTargetSpeed(spdx * this._autoActiveTrain.getSpeedFactor());
                this.completedAction(tsa);
                break;
            }
            case 5: {
                log.trace("Goto Manual Section:[{}]", (Object)tsa.getTargetTransitSection().getSectionName());
                this._autoActiveTrain.initiateWorking();
                if (tsa.getStringWhat() != null && !tsa.getStringWhat().equals("")) {
                    this.listenToDoneSensor(tsa);
                }
                this.completedAction(tsa);
                break;
            }
            case 6: {
                log.trace("Set Light Section:[{}]", (Object)tsa.getTargetTransitSection().getSectionName());
                if (this._autoActiveTrain.getAutoEngineer() != null) {
                    log.trace("{}: setting light (F0) to {}", (Object)this._activeTrain.getTrainName(), (Object)tsa.getStringWhat());
                    if (tsa.getStringWhat().equals("On")) {
                        this._autoActiveTrain.getAutoEngineer().setFunction(0, true);
                    } else if (tsa.getStringWhat().equals("Off")) {
                        this._autoActiveTrain.getAutoEngineer().setFunction(0, false);
                    } else {
                        log.error("Incorrect Light ON/OFF setting *{}*", (Object)tsa.getStringWhat());
                    }
                }
                this.completedAction(tsa);
                break;
            }
            case 7: {
                log.trace("Set Start Bell Section:[{}]", (Object)tsa.getTargetTransitSection().getSectionName());
                if (this._autoActiveTrain.getSoundDecoder() && this._autoActiveTrain.getAutoEngineer() != null) {
                    log.trace("{}: starting bell (F1)", (Object)this._activeTrain.getTrainName());
                    this._autoActiveTrain.getAutoEngineer().setFunction(1, true);
                }
                this.completedAction(tsa);
                break;
            }
            case 8: {
                log.trace("Set Stop Bell Section:[{}]", (Object)tsa.getTargetTransitSection().getSectionName());
                if (this._autoActiveTrain.getSoundDecoder() && this._autoActiveTrain.getAutoEngineer() != null) {
                    log.trace("{}: stopping bell (F1)", (Object)this._activeTrain.getTrainName());
                    this._autoActiveTrain.getAutoEngineer().setFunction(1, false);
                }
                this.completedAction(tsa);
                break;
            }
            case 9: 
            case 10: {
                log.trace("Sound Horn or Pattern Section:[{}]", (Object)tsa.getTargetTransitSection().getSectionName());
                if (this._autoActiveTrain.getSoundDecoder()) {
                    log.trace("{}: sounding horn as specified in action", (Object)this._activeTrain.getTrainName());
                    HornExecution rHorn = new HornExecution(tsa);
                    Thread tHorn = ThreadingUtil.newThread(rHorn);
                    tsa.setWaitingThread(tHorn);
                    tHorn.start();
                    break;
                }
                this.completedAction(tsa);
                break;
            }
            case 11: {
                log.trace("Set Loco Function Section:[{}]", (Object)tsa.getTargetTransitSection().getSectionName());
                if (this._autoActiveTrain.getAutoEngineer() != null) {
                    log.trace("{}: setting function {} to {}", new Object[]{this._activeTrain.getTrainName(), tsa.getDataWhat1(), tsa.getStringWhat()});
                    int fun = tsa.getDataWhat1();
                    if (tsa.getStringWhat().equals("On")) {
                        this._autoActiveTrain.getAutoEngineer().setFunction(fun, true);
                    } else if (tsa.getStringWhat().equals("Off")) {
                        this._autoActiveTrain.getAutoEngineer().setFunction(fun, false);
                    }
                }
                this.completedAction(tsa);
                break;
            }
            case 12: {
                log.trace("Set Sensor Active Section:[{}]", (Object)tsa.getTargetTransitSection().getSectionName());
                s = InstanceManager.sensorManagerInstance().getSensor(tsa.getStringWhat());
                if (s != null) {
                    if (s.getKnownState() == 2) {
                        try {
                            s.setState(4);
                        }
                        catch (JmriException reason) {
                            log.error("Exception when toggling Sensor {} Inactive", (Object)tsa.getStringWhat(), (Object)reason);
                        }
                    }
                    try {
                        s.setState(2);
                    }
                    catch (JmriException reason) {
                        log.error("Exception when setting Sensor {} Active", (Object)tsa.getStringWhat(), (Object)reason);
                    }
                    break;
                }
                if (tsa.getStringWhat() != null && !tsa.getStringWhat().equals("")) {
                    log.error("Could not find Sensor {}", (Object)tsa.getStringWhat());
                    break;
                }
                log.error("Sensor not specified for Action");
                break;
            }
            case 13: {
                log.trace("Set Sensor Inactive Section:[{}]", (Object)tsa.getTargetTransitSection().getSectionName());
                s = InstanceManager.sensorManagerInstance().getSensor(tsa.getStringWhat());
                if (s != null) {
                    if (s.getKnownState() == 2) {
                        try {
                            s.setState(2);
                        }
                        catch (JmriException reason) {
                            log.error("Exception when toggling Sensor {} Active", (Object)tsa.getStringWhat(), (Object)reason);
                        }
                    }
                    try {
                        s.setState(4);
                    }
                    catch (JmriException reason) {
                        log.error("Exception when setting Sensor {} Inactive", (Object)tsa.getStringWhat(), (Object)reason);
                    }
                    break;
                }
                if (tsa.getStringWhat() != null && !tsa.getStringWhat().equals("")) {
                    log.error("Could not find Sensor {}", (Object)tsa.getStringWhat());
                    break;
                }
                log.error("Sensor not specified for Action");
                break;
            }
            case 14: {
                log.trace("Set Hold Section:[{}]", (Object)tsa.getTargetTransitSection().getSectionName());
                SignalMast sm = null;
                SignalHead sh = null;
                String sName = tsa.getStringWhat();
                sm = InstanceManager.getDefault(SignalMastManager.class).getSignalMast(sName);
                if (sm == null) {
                    sh = InstanceManager.getDefault(SignalHeadManager.class).getSignalHead(sName);
                    if (sh == null) {
                        log.error("{}: Could not find SignalMast or SignalHead named '{}'", (Object)this._activeTrain.getTrainName(), (Object)sName);
                        break;
                    }
                    log.trace("{}: setting signalHead '{}' to HELD", (Object)this._activeTrain.getTrainName(), (Object)sName);
                    sh.setHeld(true);
                    break;
                }
                log.trace("{}: setting signalMast '{}' to HELD", (Object)this._activeTrain.getTrainName(), (Object)sName);
                sm.setHeld(true);
                break;
            }
            case 15: {
                log.trace("Set Release Hold Section:[{}]", (Object)tsa.getTargetTransitSection().getSectionName());
                SignalMast sm = null;
                SignalHead sh = null;
                String sName = tsa.getStringWhat();
                sm = InstanceManager.getDefault(SignalMastManager.class).getSignalMast(sName);
                if (sm == null) {
                    sh = InstanceManager.getDefault(SignalHeadManager.class).getSignalHead(sName);
                    if (sh == null) {
                        log.error("{}: Could not find SignalMast or SignalHead named '{}'", (Object)this._activeTrain.getTrainName(), (Object)sName);
                        break;
                    }
                    log.trace("{}: setting signalHead '{}' to NOT HELD", (Object)this._activeTrain.getTrainName(), (Object)sName);
                    sh.setHeld(false);
                    break;
                }
                log.trace("{}: setting signalMast '{}' to NOT HELD", (Object)this._activeTrain.getTrainName(), (Object)sName);
                sm.setHeld(false);
                break;
            }
            case 16: {
                log.trace("EStop Section:[{}]", (Object)tsa.getTargetTransitSection().getSectionName());
                this._autoActiveTrain.getAutoEngineer().setSpeedImmediate(-1.0f);
                break;
            }
            default: {
                log.error("illegal What code - {} - in call to executeAction  Section:[{}]", (Object)tsa.getWhatCode(), (Object)tsa.getTargetTransitSection().getSectionName());
            }
        }
    }

    class MonitorTrainSpeed
    implements Runnable {
        private int _delay = 51;
        private TransitSectionAction _tsa = null;

        public MonitorTrainSpeed(TransitSectionAction tsa) {
            this._tsa = tsa;
        }

        @Override
        public void run() {
            while (AutoTrainAction.this._autoActiveTrain.getAutoEngineer() != null && !AutoTrainAction.this._autoActiveTrain.getAutoEngineer().isAtSpeed()) {
                try {
                    Thread.sleep(this._delay);
                }
                catch (InterruptedException e) {
                    log.error("unexpected interruption of wait for speed");
                }
            }
            AutoTrainAction.this._autoActiveTrain.setCurrentRampRate(AutoTrainAction.this._autoActiveTrain.getRampRate());
            if (this._tsa != null) {
                AutoTrainAction.this.completedAction(this._tsa);
            }
        }
    }

    class MonitorTrain
    implements Runnable {
        private int _delay = 50;
        private TransitSectionAction _tsa = null;

        public MonitorTrain(TransitSectionAction tsa) {
            this._tsa = tsa;
        }

        @Override
        public void run() {
            if (this._tsa != null) {
                boolean waitingOnTrain = true;
                if (this._tsa.getWhenCode() == 5) {
                    try {
                        while (waitingOnTrain) {
                            if (AutoTrainAction.this._autoActiveTrain.getAutoEngineer() != null && AutoTrainAction.this._autoActiveTrain.getAutoEngineer().isStopped()) {
                                waitingOnTrain = false;
                                continue;
                            }
                            Thread.sleep(this._delay);
                        }
                        AutoTrainAction.this.checkDelay(this._tsa);
                    }
                    catch (InterruptedException interruptedException) {}
                } else if (this._tsa.getWhenCode() == 6) {
                    if (AutoTrainAction.this._autoActiveTrain.getThrottle() != null && AutoTrainAction.this._autoActiveTrain.getAutoEngineer() != null && !AutoTrainAction.this._autoActiveTrain.getAutoEngineer().isStopped()) {
                        boolean waitingForStop = true;
                        try {
                            while (waitingForStop) {
                                if (AutoTrainAction.this._autoActiveTrain.getAutoEngineer() != null && AutoTrainAction.this._autoActiveTrain.getAutoEngineer().isStopped()) {
                                    waitingForStop = false;
                                    continue;
                                }
                                Thread.sleep(this._delay);
                            }
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    try {
                        while (waitingOnTrain) {
                            if (AutoTrainAction.this._autoActiveTrain.getThrottle() != null && AutoTrainAction.this._autoActiveTrain.getAutoEngineer() != null && !AutoTrainAction.this._autoActiveTrain.getAutoEngineer().isStopped()) {
                                waitingOnTrain = false;
                                continue;
                            }
                            Thread.sleep(this._delay);
                        }
                        AutoTrainAction.this.checkDelay(this._tsa);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    class HornExecution
    implements Runnable {
        private TransitSectionAction _tsa = null;

        public HornExecution(TransitSectionAction tsa) {
            this._tsa = tsa;
        }

        @Override
        public void run() {
            AutoTrainAction.this._autoActiveTrain.incrementHornExecution();
            if (this._tsa.getWhatCode() == 9) {
                if (AutoTrainAction.this._autoActiveTrain.getAutoEngineer() != null) {
                    try {
                        AutoTrainAction.this._autoActiveTrain.getAutoEngineer().setFunction(2, true);
                        Thread.sleep(this._tsa.getDataWhat1());
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                if (AutoTrainAction.this._autoActiveTrain.getAutoEngineer() != null) {
                    AutoTrainAction.this._autoActiveTrain.getAutoEngineer().setFunction(2, false);
                }
            } else if (this._tsa.getWhatCode() == 10) {
                String pattern = this._tsa.getStringWhat();
                int index = 0;
                int sleepTime = this._tsa.getDataWhat1() * 12 / 10;
                boolean keepGoing = true;
                while (keepGoing && index < pattern.length()) {
                    if (AutoTrainAction.this._autoActiveTrain.getAutoEngineer() != null) {
                        AutoTrainAction.this._autoActiveTrain.getAutoEngineer().setFunction(2, true);
                        try {
                            if (pattern.charAt(index) == 's') {
                                Thread.sleep(this._tsa.getDataWhat1());
                            } else if (pattern.charAt(index) == 'l') {
                                Thread.sleep(this._tsa.getDataWhat2());
                            }
                        }
                        catch (InterruptedException e) {
                            keepGoing = false;
                        }
                    } else {
                        keepGoing = false;
                    }
                    if (AutoTrainAction.this._autoActiveTrain.getAutoEngineer() != null) {
                        AutoTrainAction.this._autoActiveTrain.getAutoEngineer().setFunction(2, false);
                    } else {
                        keepGoing = false;
                    }
                    if (!keepGoing || ++index >= pattern.length()) continue;
                    try {
                        Thread.sleep(sleepTime);
                    }
                    catch (InterruptedException e) {
                        keepGoing = false;
                    }
                }
            }
            AutoTrainAction.this._autoActiveTrain.decrementHornExecution();
            AutoTrainAction.this.completedAction(this._tsa);
        }
    }

    class TSActionDelay
    implements Runnable {
        private TransitSectionAction _tsa = null;
        private int _delay = 0;

        public TSActionDelay(TransitSectionAction tsa, int delay) {
            this._tsa = tsa;
            this._delay = delay;
            log.debug("Delay Starting for Code [{}] in Section [{}] for [{}]", new Object[]{tsa.getWhatCode(), tsa.getTargetTransitSection().getSectionName(), delay});
        }

        @Override
        public void run() {
            try {
                Thread.sleep(this._delay);
                AutoTrainAction.this.executeAction(this._tsa);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

