/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.dispatcher;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.plaf.basic.BasicToolBarUI;
import jmri.InstanceManager;
import jmri.Throttle;
import jmri.UserPreferencesManager;
import jmri.jmrit.dispatcher.ActiveTrain;
import jmri.jmrit.dispatcher.AutoActiveTrain;
import jmri.jmrit.dispatcher.Bundle;
import jmri.jmrit.dispatcher.DispatcherFrame;
import jmri.jmrit.roster.RosterEntry;
import jmri.util.JmriJFrame;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoTrainsFrame
extends JmriJFrame {
    private final ArrayList<AutoActiveTrain> _autoTrainsList = new ArrayList();
    protected JmriJFrame autoTrainsFrame = null;
    private JPanel trainsPanel;
    private JScrollPane trainScrollPanel;
    private JCheckBoxMenuItem frameHasScrollBars = new JCheckBoxMenuItem(Bundle.getMessage("AutoTrainsFrameUseScrollBars"));
    private JCheckBoxMenuItem trainsCanBeFloated = new JCheckBoxMenuItem(Bundle.getMessage("AutoTrainsFrameAllowFloat"));
    private JCheckBoxMenuItem frameAlwaysOnTop = new JCheckBoxMenuItem(Bundle.getMessage("AutoTrainsFrameAlwaysOnTop"));
    private JCheckBoxMenuItem frameOnTopOnSpeedChange = new JCheckBoxMenuItem(Bundle.getMessage("AutoTrainsFrameOnTopOnSpeedChange"));
    UserPreferencesManager prefMan;
    String hasScrollBars = this.getClass().getName() + ".HasScrollBars";
    String canFloat = this.getClass().getName() + ".CanFloat";
    String alWaysOnTop = this.getClass().getName() + ".AlWaysOnTop";
    String onTopOnSpeedChange = this.getClass().getName() + ".OnTopOnSpeedChange";
    private static final Logger log = LoggerFactory.getLogger(AutoTrainsFrame.class);

    public AutoTrainsFrame(DispatcherFrame disp) {
        super(false, true);
        this.initializeAutoTrainsWindow();
    }

    public ArrayList<AutoActiveTrain> getAutoTrainsList() {
        return this._autoTrainsList;
    }

    public void addAutoActiveTrain(AutoActiveTrain autoActiveTrain) {
        if (autoActiveTrain != null) {
            log.debug("Adding ActiveTrain[{}]", (Object)autoActiveTrain.getActiveTrain().getActiveTrainName());
            AutoTrainControl atn = new AutoTrainControl(autoActiveTrain);
            if (!this.trainsCanBeFloated.isSelected()) {
                atn.componentJPanel.setFloatable(false);
            }
            this.trainsPanel.add(atn);
            atn.addPropertyChangeListener("terminated", e -> {
                AutoTrainControl atnn = (AutoTrainControl)e.getSource();
                ((BasicToolBarUI)atnn.componentJPanel.getUI()).setFloating(false, null);
                this.trainsPanel.remove((AutoTrainControl)e.getSource());
                this.pack();
            });
            atn.componentJPanel.addAncestorListener(new AncestorListener(){

                @Override
                public void ancestorAdded(AncestorEvent event) {
                    log.trace("ancestorAdded");
                    AutoTrainsFrame.this.pack();
                }

                @Override
                public void ancestorRemoved(AncestorEvent event) {
                    log.trace("ancestorRemoved");
                    AutoTrainsFrame.this.pack();
                }

                @Override
                public void ancestorMoved(AncestorEvent event) {
                }
            });
            this.pack();
        }
    }

    private void initializeAutoTrainsWindow() {
        this.prefMan = InstanceManager.getDefault(UserPreferencesManager.class);
        this.frameHasScrollBars.setSelected(this.prefMan.getSimplePreferenceState(this.hasScrollBars));
        this.trainsCanBeFloated.setSelected(this.prefMan.getSimplePreferenceState(this.canFloat));
        this.frameAlwaysOnTop.setSelected(this.prefMan.getSimplePreferenceState(this.alWaysOnTop));
        this.frameOnTopOnSpeedChange.setSelected(this.prefMan.getSimplePreferenceState(this.onTopOnSpeedChange));
        this.autoTrainsFrame = this;
        this.autoTrainsFrame.setTitle(Bundle.getMessage("TitleAutoTrains"));
        this.trainsPanel = new JPanel();
        this.trainsPanel.setLayout(new BoxLayout(this.trainsPanel, 1));
        JMenuBar menuBar = new JMenuBar();
        JMenu optMenu = new JMenu(Bundle.getMessage("MenuOptions"));
        optMenu.add(this.frameHasScrollBars);
        this.frameHasScrollBars.addActionListener(e -> this.setScrollBars());
        optMenu.add(this.trainsCanBeFloated);
        this.trainsCanBeFloated.addActionListener(e -> {
            for (Component ob : this.trainsPanel.getComponents()) {
                if (!(ob instanceof AutoTrainControl)) continue;
                AutoTrainControl atnn = (AutoTrainControl)ob;
                if (this.trainsCanBeFloated.isSelected()) {
                    atnn.componentJPanel.setFloatable(true);
                    continue;
                }
                ((BasicToolBarUI)atnn.componentJPanel.getUI()).setFloating(false, null);
                atnn.componentJPanel.setFloatable(false);
            }
        });
        optMenu.add(this.frameAlwaysOnTop);
        this.frameAlwaysOnTop.addActionListener(e -> this.setAlwaysOnTop(this.frameAlwaysOnTop.isSelected()));
        optMenu.add(this.frameOnTopOnSpeedChange);
        this.frameOnTopOnSpeedChange.addActionListener(e -> {
            for (Component ob : this.trainsPanel.getComponents()) {
                if (!(ob instanceof AutoTrainControl)) continue;
                AutoTrainControl atnn = (AutoTrainControl)ob;
                atnn.setOnTopOnSpeedChange(this.frameOnTopOnSpeedChange.isSelected());
            }
        });
        menuBar.add(optMenu);
        this.setJMenuBar(menuBar);
        this.autoTrainsFrame.addHelpMenu("package.jmri.jmrit.dispatcher.AutoTrains", true);
        this.trainsPanel.setLayout(new BoxLayout(this.trainsPanel, 1));
        JPanel pB = new JPanel();
        pB.setLayout(new FlowLayout());
        JButton stopAllButton = new JButton(Bundle.getMessage("StopAll"));
        pB.add(stopAllButton);
        stopAllButton.addActionListener(this::stopAllPressed);
        stopAllButton.setToolTipText(Bundle.getMessage("StopAllButtonHint"));
        this.trainsPanel.add(pB);
        this.trainsPanel.add(new JSeparator());
        this.trainsPanel.addComponentListener(this);
        this.trainsPanel.setVisible(true);
        this.trainsPanel.revalidate();
        this.trainScrollPanel = new JScrollPane();
        this.trainScrollPanel.getViewport().add(this.trainsPanel);
        this.autoTrainsFrame.getContentPane().setLayout(new BoxLayout(this.autoTrainsFrame.getContentPane(), 1));
        this.autoTrainsFrame.getContentPane().add(this.trainScrollPanel);
        this.setScrollBars();
        this.autoTrainsFrame.getContentPane().revalidate();
        this.autoTrainsFrame.pack();
        this.autoTrainsFrame.setVisible(true);
    }

    private void setScrollBars() {
        if (this.frameHasScrollBars.isSelected()) {
            this.trainScrollPanel.setVerticalScrollBarPolicy(20);
            this.trainScrollPanel.setHorizontalScrollBarPolicy(30);
            this.autoTrainsFrame.getContentPane().revalidate();
        } else {
            this.trainScrollPanel.setVerticalScrollBarPolicy(21);
            this.trainScrollPanel.setHorizontalScrollBarPolicy(31);
            this.autoTrainsFrame.getContentPane().revalidate();
        }
    }

    private void stopAllPressed(ActionEvent e) {
        for (Component ob : this.trainsPanel.getComponents()) {
            if (!(ob instanceof AutoTrainControl)) continue;
            ((AutoTrainControl)ob).stopAll();
        }
    }

    @Override
    public void dispose() {
        if (this.prefMan != null) {
            this.prefMan.setSimplePreferenceState(this.hasScrollBars, this.frameHasScrollBars.isSelected());
            this.prefMan.setSimplePreferenceState(this.canFloat, this.trainsCanBeFloated.isSelected());
            this.prefMan.setSimplePreferenceState(this.hasScrollBars, this.frameHasScrollBars.isSelected());
            this.prefMan.setSimplePreferenceState(this.canFloat, this.trainsCanBeFloated.isSelected());
        }
        super.dispose();
    }

    class AutoTrainControl
    extends JPanel {
        private boolean useOnTopOnSpeedChange;
        private AutoActiveTrain autoActiveTrain = null;
        private PropertyChangeListener activeTrainListener = null;
        private PropertyChangeListener throttleListener = null;
        private Throttle throttle = null;
        private ActiveTrain activeTrain = null;
        private RosterEntry rosterEntry = null;
        private JLabel trainLabel;
        private JLabel throttleStatus;
        protected JButton stopButton;
        private JButton resumeAutoRunningButton;
        private JRadioButton forwardButton;
        private JRadioButton reverseButton;
        private JSlider speedSlider;
        private JButton manualButton;
        private float lastReportedSpeed;
        private JToolBar componentJPanel;

        public AutoTrainControl(AutoActiveTrain autoActiveTrain) {
            this.autoActiveTrain = autoActiveTrain;
            this.activeTrain = autoActiveTrain.getActiveTrain();
            this.activeTrainListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent e) {
                    AutoTrainControl.this.handleActiveTrainListen(e);
                }
            };
            this.activeTrain.addPropertyChangeListener(this.activeTrainListener);
            this.rosterEntry = autoActiveTrain.getRosterEntry();
            this.drawComponent();
        }

        protected void setOnTopOnSpeedChange(boolean value) {
            this.useOnTopOnSpeedChange = value;
        }

        protected void stopAll() {
            if (this.activeTrain.getStatus() != 32 && this.activeTrain.getStatus() != 64) {
                this.autoActiveTrain.saveSpeedAndDirection();
                this.autoActiveTrain.getAutoEngineer().setHalt(true);
                this.autoActiveTrain.setSavedStatus(this.activeTrain.getStatus());
                this.activeTrain.setStatus(32);
            }
        }

        private void handleThrottleListen(PropertyChangeEvent e) {
            if (!e.getPropertyName().equals("SpeedSetting") && !e.getPropertyName().equals("IsForward")) {
                return;
            }
            this.updateThrottleDisplay(e);
        }

        private void primeThrottleDisplay() {
            if (this.throttle != null) {
                if (this.throttle.getIsForward()) {
                    this.forwardButton.setSelected(true);
                } else {
                    this.reverseButton.setSelected(true);
                }
                this.lastReportedSpeed = this.throttle.getSpeedSetting();
                if (this.speedSlider.isVisible()) {
                    this.speedSlider.setValue(Math.round(this.lastReportedSpeed * 100.0f));
                }
            }
            this.updateThrottleStatus();
        }

        private void updateThrottleDisplay(PropertyChangeEvent e) {
            if (this.throttle != null) {
                if (e.getPropertyName().equals("IsForward")) {
                    if (((Boolean)e.getNewValue()).booleanValue()) {
                        this.forwardButton.setSelected(true);
                    } else {
                        this.reverseButton.setSelected(true);
                    }
                } else {
                    this.lastReportedSpeed = ((Float)e.getNewValue()).floatValue();
                    if (this.speedSlider.isVisible()) {
                        this.speedSlider.setValue(Math.round(this.lastReportedSpeed * 100.0f));
                    }
                }
            }
            this.updateThrottleStatus();
        }

        private void updateThrottleStatus() {
            StringBuilder sb = new StringBuilder();
            if (this.throttle != null && this.throttleStatus.isVisible()) {
                if (this.rosterEntry != null && this.autoActiveTrain.useSpeedProfile && this.rosterEntry.getSpeedProfile() != null) {
                    sb.append(this.rosterEntry.getSpeedProfile().convertThrottleSettingToScaleSpeedWithUnits(this.lastReportedSpeed, this.forwardButton.isSelected()));
                } else {
                    sb.append("" + Math.round(this.throttle.getSpeedSetting() * 100.0f));
                    sb.append("% ");
                }
                if (this.forwardButton.isSelected()) {
                    sb.append("(fwd)");
                } else {
                    sb.append("(rev)");
                }
                this.throttleStatus.setText(sb.toString());
                if (this.useOnTopOnSpeedChange) {
                    AutoTrainsFrame.this.setAlwaysOnTop(true);
                    AutoTrainsFrame.this.setAlwaysOnTop(false);
                }
            } else if (this.throttleStatus.isVisible()) {
                this.throttleStatus.setText("No Throttle");
            }
        }

        private void handleActiveTrainListen(PropertyChangeEvent e) {
            if (e.getNewValue() != null) {
                log.trace("Property[{}] newValue[{}]", (Object)e.getPropertyName(), e.getNewValue());
            } else {
                log.trace("Property[{}] newValue[{}]", (Object)e.getPropertyName(), (Object)"NULL");
            }
            if (e.getPropertyName().equals("mode")) {
                int newValue = (Integer)e.getNewValue();
                if (newValue == 8) {
                    this.stopButton.setVisible(false);
                    this.manualButton.setVisible(false);
                    this.resumeAutoRunningButton.setVisible(true);
                    this.forwardButton.setVisible(false);
                    this.reverseButton.setVisible(false);
                    this.speedSlider.setVisible(false);
                    this.throttleStatus.setVisible(false);
                    InstanceManager.throttleManagerInstance().removeListener(this.throttle.getLocoAddress(), this.throttleListener);
                } else if (newValue == 2) {
                    log.trace("[{}]:Set auto", (Object)this.autoActiveTrain.getActiveTrain().getActiveTrainName());
                    if (this.throttle == null && this.autoActiveTrain.getThrottle() != null) {
                        log.trace("[{}]:Set new throttle", (Object)this.autoActiveTrain.getActiveTrain().getActiveTrainName());
                        this.throttle = this.autoActiveTrain.getThrottle();
                        this.throttleListener = new PropertyChangeListener(){

                            @Override
                            public void propertyChange(PropertyChangeEvent e) {
                                AutoTrainControl.this.handleThrottleListen(e);
                            }
                        };
                        InstanceManager.throttleManagerInstance().attachListener(this.throttle.getLocoAddress(), this.throttleListener);
                        this.rosterEntry = this.autoActiveTrain.getRosterEntry();
                        this.setStatusLabelWidth();
                        this.stopButton.setText(Bundle.getMessage("StopButton"));
                        this.stopButton.setToolTipText(Bundle.getMessage("StopButtonHint"));
                        this.stopButton.setVisible(true);
                        this.manualButton.setText(Bundle.getMessage("ToManualButton"));
                        this.manualButton.setToolTipText(Bundle.getMessage("ToManualButtonHint"));
                        this.manualButton.setVisible(true);
                        this.resumeAutoRunningButton.setVisible(false);
                        this.forwardButton.setVisible(false);
                        this.reverseButton.setVisible(false);
                        this.speedSlider.setVisible(false);
                        this.throttleStatus.setVisible(true);
                        this.primeThrottleDisplay();
                    }
                } else if ((Integer)e.getNewValue() == 16) {
                    if (this.throttle != null && this.throttleListener != null) {
                        this.throttle.removePropertyChangeListener(this.throttleListener);
                        this.throttle = null;
                    }
                    this.activeTrain.removePropertyChangeListener(this.activeTrainListener);
                    this.firePropertyChange("terminated", null, null);
                }
            } else if (e.getPropertyName().equals("status")) {
                log.debug("NewStatus[{}]", e.getNewValue());
                if ((Integer)e.getNewValue() == 32) {
                    this.stopButton.setText(Bundle.getMessage("ResumeButton"));
                    this.stopButton.setToolTipText(Bundle.getMessage("ResumeButtonHint"));
                    this.stopButton.setVisible(true);
                } else if ((Integer)e.getNewValue() == 1 || (Integer)e.getNewValue() == 4 || (Integer)e.getNewValue() == 16) {
                    log.trace("[{}]:Set auto STATUS RUNNING", (Object)this.autoActiveTrain.getActiveTrain().getActiveTrainName());
                    if (this.throttle == null && this.autoActiveTrain.getThrottle() != null) {
                        log.debug("[{}]:Set new throttle", (Object)this.autoActiveTrain.getActiveTrain().getActiveTrainName());
                        this.throttle = this.autoActiveTrain.getThrottle();
                        this.throttleListener = new PropertyChangeListener(){

                            @Override
                            public void propertyChange(PropertyChangeEvent e) {
                                AutoTrainControl.this.handleThrottleListen(e);
                            }
                        };
                        InstanceManager.throttleManagerInstance().attachListener(this.throttle.getLocoAddress(), this.throttleListener);
                        this.rosterEntry = this.autoActiveTrain.getRosterEntry();
                        this.setStatusLabelWidth();
                    }
                    this.stopButton.setText(Bundle.getMessage("StopButton"));
                    this.stopButton.setToolTipText(Bundle.getMessage("StopButtonHint"));
                    this.stopButton.setVisible(true);
                    this.manualButton.setText(Bundle.getMessage("ToManualButton"));
                    this.manualButton.setToolTipText(Bundle.getMessage("ToManualButtonHint"));
                    this.manualButton.setVisible(true);
                    this.resumeAutoRunningButton.setVisible(false);
                    this.forwardButton.setVisible(false);
                    this.reverseButton.setVisible(false);
                    this.speedSlider.setVisible(false);
                    this.throttleStatus.setVisible(true);
                    this.primeThrottleDisplay();
                } else if ((Integer)e.getNewValue() == 64) {
                    this.stopButton.setText(Bundle.getMessage("RestartButton"));
                    this.stopButton.setToolTipText(Bundle.getMessage("RestartButtonHint"));
                    this.stopButton.setVisible(true);
                } else {
                    log.debug("Ignored newstatus[{}]", e.getNewValue());
                }
            }
            AutoTrainsFrame.this.pack();
        }

        public void manualAutoTrain() {
            if (this.activeTrain.getMode() == 2) {
                this.activeTrain.setMode(4);
                this.manualButton.setText(Bundle.getMessage("ToAutoButton"));
                this.manualButton.setToolTipText(Bundle.getMessage("ToAutoButtonHint"));
                this.forwardButton.setVisible(true);
                this.reverseButton.setVisible(true);
                this.speedSlider.setVisible(true);
                if (this.autoActiveTrain.getAutoEngineer() != null) {
                    this.autoActiveTrain.saveSpeedAndDirection();
                    this.autoActiveTrain.getAutoEngineer().setHalt(true);
                    this.autoActiveTrain.setTargetSpeed(0.0f);
                    this.autoActiveTrain.waitUntilStopped();
                    this.autoActiveTrain.getAutoEngineer().setHalt(false);
                    if (this.throttle.getIsForward()) {
                        this.forwardButton.setSelected(true);
                    } else {
                        this.reverseButton.setSelected(true);
                    }
                }
            } else if (this.activeTrain.getMode() == 4) {
                this.activeTrain.setMode(2);
                this.manualButton.setText(Bundle.getMessage("ToManualButton"));
                this.manualButton.setToolTipText(Bundle.getMessage("ToManualButtonHint"));
                this.manualButton.setVisible(true);
                this.forwardButton.setVisible(false);
                this.reverseButton.setVisible(false);
                this.speedSlider.setVisible(false);
                this.autoActiveTrain.restoreSavedSpeedAndDirection();
                if (this.activeTrain.getStatus() == 1 || this.activeTrain.getStatus() == 4) {
                    this.autoActiveTrain.setSpeedBySignal();
                }
            }
            AutoTrainsFrame.this.pack();
        }

        private void drawComponent() {
            this.componentJPanel = new JToolBar();
            this.componentJPanel.setLayout(new FlowLayout());
            this.componentJPanel.setFloatable(true);
            this.trainLabel = new JLabel(this.autoActiveTrain.getActiveTrain().getTrainName());
            this.trainLabel.setVisible(true);
            this.componentJPanel.add(this.trainLabel);
            this.stopButton = new JButton(Bundle.getMessage("ResumeButton"));
            this.componentJPanel.add(this.stopButton);
            this.stopButton.addActionListener(e -> this.stopResume());
            this.manualButton = new JButton(Bundle.getMessage("ToManualButton"));
            this.componentJPanel.add(this.manualButton);
            this.manualButton.addActionListener(e -> this.manualAutoTrain());
            this.resumeAutoRunningButton = new JButton(Bundle.getMessage("ResumeAutoButton"));
            this.componentJPanel.add(this.resumeAutoRunningButton);
            this.resumeAutoRunningButton.addActionListener(e -> this.resumeAutoOperation());
            this.resumeAutoRunningButton.setVisible(false);
            this.resumeAutoRunningButton.setToolTipText(Bundle.getMessage("ResumeAutoButtonHint"));
            ButtonGroup directionGroup = new ButtonGroup();
            this.forwardButton = new JRadioButton(Bundle.getMessage("ForwardRadio"));
            this.componentJPanel.add(this.forwardButton);
            this.forwardButton.addActionListener(e -> this.directionButton());
            directionGroup.add(this.forwardButton);
            this.reverseButton = new JRadioButton(Bundle.getMessage("ReverseRadio"));
            this.componentJPanel.add(this.reverseButton);
            this.reverseButton.addActionListener(e -> this.directionButton());
            directionGroup.add(this.reverseButton);
            this.speedSlider = new JSlider(0, 100, 0);
            this.speedSlider.setPreferredSize(new Dimension(100, 20));
            this.componentJPanel.add(this.speedSlider);
            this.speedSlider.addChangeListener(e -> {
                if (this.speedSlider.isVisible()) {
                    int val = ((JSlider)e.getSource()).getValue();
                    float speedValue = (float)val * 0.01f;
                    this.autoActiveTrain.getThrottle().setSpeedSetting(speedValue);
                }
            });
            this.throttleStatus = new JLabel();
            this.throttleStatus.setPreferredSize(new Dimension(100, 20));
            this.throttleStatus.setText("Speed Unknown");
            this.componentJPanel.add(this.throttleStatus);
            this.componentJPanel.revalidate();
            this.add((Component)this.componentJPanel, "East");
            AutoTrainsFrame.this.pack();
        }

        private void setStatusLabelWidth() {
            if (this.rosterEntry != null && this.autoActiveTrain.getUseSpeedProfile()) {
                this.throttleStatus.setPreferredSize(new JTextField(20).getPreferredSize());
            } else {
                this.throttleStatus.setPreferredSize(new JTextField(10).getPreferredSize());
            }
        }

        public void stopResume() {
            if (this.autoActiveTrain.getAutoEngineer() != null) {
                ActiveTrain at = this.autoActiveTrain.getActiveTrain();
                if (at.getStatus() == 32) {
                    log.trace("Train Is Stopped - Resume");
                    this.autoActiveTrain.setEngineDirection();
                    this.autoActiveTrain.getAutoEngineer().setHalt(false);
                    this.autoActiveTrain.restoreSavedSpeedAndDirection();
                    at.setStatus(this.autoActiveTrain.getSavedStatus());
                    if (at.getStatus() == 1 || at.getStatus() == 4) {
                        this.autoActiveTrain.setSpeedBySignal();
                    }
                } else if (at.getStatus() == 16) {
                    this.handleActiveTrainListen(new PropertyChangeEvent(this, "status", 0, 16));
                } else if (at.getStatus() == 64) {
                    log.trace("Train Is Done - Restart");
                    at.allocateAFresh();
                    at.restart();
                } else {
                    log.trace("Process As Stop");
                    this.autoActiveTrain.saveSpeedAndDirection();
                    this.autoActiveTrain.getAutoEngineer().setHalt(true);
                    this.autoActiveTrain.setSavedStatus(at.getStatus());
                    at.setStatus(32);
                    this.speedSlider.setValue(0);
                }
            } else {
                log.error("unexpected null autoEngineer");
            }
        }

        public void resumeAutoOperation() {
            this.autoActiveTrain.resumeAutomaticRunning();
        }

        public void directionButton() {
            ActiveTrain at = this.autoActiveTrain.getActiveTrain();
            if (at.getMode() == 4) {
                this.autoActiveTrain.setForward(this.forwardButton.isSelected());
            } else {
                log.debug(" {}:Ignored direction button change, not in manual mode", (Object)at.getTrainName());
            }
        }
    }
}

