/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.dispatcher;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nonnull;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import jmri.Block;
import jmri.BlockManager;
import jmri.EntryPoint;
import jmri.InstanceManager;
import jmri.InstanceManagerAutoDefault;
import jmri.JmriException;
import jmri.NamedBean;
import jmri.Scale;
import jmri.ScaleManager;
import jmri.Section;
import jmri.SectionManager;
import jmri.Sensor;
import jmri.ShutDownManager;
import jmri.SignalMast;
import jmri.SignalMastManager;
import jmri.Timebase;
import jmri.Transit;
import jmri.TransitManager;
import jmri.TransitSection;
import jmri.jmrit.dispatcher.ActivateTrainFrame;
import jmri.jmrit.dispatcher.ActiveTrain;
import jmri.jmrit.dispatcher.AllocatedSection;
import jmri.jmrit.dispatcher.AllocationRequest;
import jmri.jmrit.dispatcher.AutoActiveTrain;
import jmri.jmrit.dispatcher.AutoAllocate;
import jmri.jmrit.dispatcher.AutoTrainsFrame;
import jmri.jmrit.dispatcher.AutoTurnouts;
import jmri.jmrit.dispatcher.Bundle;
import jmri.jmrit.dispatcher.DispatcherShutDownTask;
import jmri.jmrit.dispatcher.OptionsFile;
import jmri.jmrit.dispatcher.OptionsMenu;
import jmri.jmrit.dispatcher.TaskAllocateRelease;
import jmri.jmrit.dispatcher.TrainInfo;
import jmri.jmrit.dispatcher.TrainInfoFile;
import jmri.jmrit.display.EditorManager;
import jmri.jmrit.display.layoutEditor.LayoutBlock;
import jmri.jmrit.display.layoutEditor.LayoutBlockConnectivityTools;
import jmri.jmrit.display.layoutEditor.LayoutBlockManager;
import jmri.jmrit.display.layoutEditor.LayoutDoubleXOver;
import jmri.jmrit.display.layoutEditor.LayoutEditor;
import jmri.jmrit.display.layoutEditor.LayoutTrackExpectedState;
import jmri.jmrit.display.layoutEditor.LayoutTurnout;
import jmri.jmrit.display.layoutEditor.LevelXing;
import jmri.jmrit.roster.Roster;
import jmri.jmrit.roster.RosterEntry;
import jmri.jmrit.vsdecoder.VSDecoderManager;
import jmri.swing.JTablePersistenceManager;
import jmri.util.JmriJFrame;
import jmri.util.ThreadingUtil;
import jmri.util.swing.JmriJOptionPane;
import jmri.util.swing.JmriMouseAdapter;
import jmri.util.swing.JmriMouseEvent;
import jmri.util.swing.JmriMouseListener;
import jmri.util.swing.XTableColumnModel;
import jmri.util.table.ButtonEditor;
import jmri.util.table.ButtonRenderer;
import org.jdom2.JDOMException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DispatcherFrame
extends JmriJFrame
implements InstanceManagerAutoDefault {
    public static boolean dispatcherSystemSchedulingInOperation = false;
    public static final String OVERRIDETYPE_NONE = "NONE";
    public static final String OVERRIDETYPE_USER = "USER";
    public static final String OVERRIDETYPE_DCCADDRESS = "DCCADDRESS";
    public static final String OVERRIDETYPE_OPERATIONS = "OPERATIONS";
    public static final String OVERRIDETYPE_ROSTER = "ROSTER";
    private LayoutEditor _LE = null;
    public static final int SIGNALHEAD = 0;
    public static final int SIGNALMAST = 1;
    public static final int SECTIONSALLOCATED = 2;
    private int _SignalType = 0;
    private String _StoppingSpeedName = "RestrictedSlow";
    private boolean _UseConnectivity = false;
    private boolean _HasOccupancyDetection = false;
    private boolean _SetSSLDirectionalSensors = true;
    private TrainsFrom _TrainsFrom = TrainsFrom.TRAINSFROMROSTER;
    private boolean _AutoAllocate = false;
    private boolean _AutoRelease = false;
    private boolean _AutoTurnouts = false;
    private boolean _TrustKnownTurnouts = false;
    private boolean _useTurnoutConnectionDelay = false;
    private boolean _ShortActiveTrainNames = false;
    private boolean _ShortNameInBlock = true;
    private boolean _RosterEntryInBlock = false;
    private boolean _ExtraColorForAllocated = true;
    private boolean _NameInAllocatedBlock = false;
    private boolean _UseScaleMeters = false;
    private Scale _LayoutScale = ScaleManager.getScale("HO");
    private boolean _SupportVSDecoder = false;
    private int _MinThrottleInterval = 100;
    private int _FullRampTime = 10000;
    private float maximumLineSpeed = 0.0f;
    private Thread autoAllocateThread;
    private static final NamedBean.DisplayOptions USERSYS = NamedBean.DisplayOptions.USERNAME_SYSTEMNAME;
    private final List<ActiveTrain> activeTrainsList = new ArrayList<ActiveTrain>();
    private final List<PropertyChangeListener> _atListeners = new ArrayList<PropertyChangeListener>();
    private final List<ActiveTrain> delayedTrains = new ArrayList<ActiveTrain>();
    private final List<ActiveTrain> restartingTrainsList = new ArrayList<ActiveTrain>();
    private final TransitManager transitManager = InstanceManager.getDefault(TransitManager.class);
    private final List<AllocationRequest> allocationRequests = new ArrayList<AllocationRequest>();
    protected final List<AllocatedSection> allocatedSections = new ArrayList<AllocatedSection>();
    private boolean optionsRead = false;
    private AutoTurnouts autoTurnouts = null;
    private AutoAllocate autoAllocate = null;
    private OptionsMenu optionsMenu = null;
    private ActivateTrainFrame atFrame = null;
    private EditorManager editorManager = null;
    private boolean newTrainActive = false;
    private AutoTrainsFrame _autoTrainsFrame = null;
    private final Timebase fastClock = InstanceManager.getNullableDefault(Timebase.class);
    private final Sensor fastClockSensor = InstanceManager.sensorManagerInstance().provideSensor("ISCLOCKRUNNING");
    private transient PropertyChangeListener minuteChangeListener = null;
    protected JmriJFrame dispatcherFrame = null;
    private Container contentPane = null;
    private ActiveTrainsTableModel activeTrainsTableModel = null;
    private JButton addTrainButton = null;
    private JButton terminateTrainButton = null;
    private JButton cancelRestartButton = null;
    private JButton allocateExtraButton = null;
    private JCheckBox autoReleaseBox = null;
    private JCheckBox autoAllocateBox = null;
    private AllocationRequestTableModel allocationRequestTableModel = null;
    private AllocatedSectionTableModel allocatedSectionTableModel = null;
    private JmriJFrame extraFrame = null;
    private Container extraPane = null;
    private final JComboBox<String> atSelectBox = new JComboBox();
    private final JComboBox<String> extraBox = new JComboBox();
    private final List<Section> extraBoxList = new ArrayList<Section>();
    private int atSelectedIndex = -1;
    List<HeldMastDetails> heldMasts = new ArrayList<HeldMastDetails>();
    private static final Logger log = LoggerFactory.getLogger(DispatcherFrame.class);

    public DispatcherFrame() {
        super(true, true);
        this.editorManager = InstanceManager.getDefault(EditorManager.class);
        this.initializeOptions();
        this.openDispatcherWindow();
        this.autoTurnouts = new AutoTurnouts(this);
        InstanceManager.getDefault(SectionManager.class).initializeBlockingSensors();
        this.getActiveTrainFrame();
        if (this.fastClock == null) {
            log.error("Failed to instantiate a fast clock when constructing Dispatcher");
        } else {
            this.minuteChangeListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent e) {
                    DispatcherFrame.this.newFastClockMinute();
                }
            };
            this.fastClock.addMinuteChangeListener(this.minuteChangeListener);
        }
        InstanceManager.getDefault(ShutDownManager.class).register(new DispatcherShutDownTask("Dispatch Shutdown"));
    }

    public void loadAtStartup() {
        log.debug("Loading saved trains flagged as LoadAtStartup");
        TrainInfoFile tif = new TrainInfoFile();
        String[] names = tif.getTrainInfoFileNames();
        log.debug("initializing block paths early");
        InstanceManager.getDefault(LayoutBlockManager.class).initializeLayoutBlockPaths();
        if (names.length > 0) {
            for (int i = 0; i < names.length; ++i) {
                TrainInfo info = null;
                try {
                    info = tif.readTrainInfo(names[i]);
                }
                catch (IOException ioe) {
                    log.error("IO Exception when reading train info file {}", (Object)names[i], (Object)ioe);
                    continue;
                }
                catch (JDOMException jde) {
                    log.error("JDOM Exception when reading train info file {}", (Object)names[i], (Object)jde);
                    continue;
                }
                if (info == null || !info.getLoadAtStartup() || this.loadTrainFromTrainInfo(info) != 0) continue;
                try {
                    Thread.sleep(500L);
                    continue;
                }
                catch (InterruptedException e) {
                    log.warn("Sleep Interrupted in loading trains, likely being stopped", (Throwable)e);
                }
            }
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.autoAllocate != null) {
            this.autoAllocate.setAbort();
        }
    }

    public int loadTrainFromTrainInfo(String traininfoFileName) {
        return this.loadTrainFromTrainInfo(traininfoFileName, OVERRIDETYPE_NONE, "");
    }

    public int loadTrainFromTrainInfo(String traininfoFileName, String overRideType, String overRideValue) {
        try {
            TrainInfoFile tif = new TrainInfoFile();
            TrainInfo info = null;
            try {
                info = tif.readTrainInfo(traininfoFileName);
            }
            catch (FileNotFoundException fnfe) {
                log.error("Train info file not found {}", (Object)traininfoFileName);
                return -2;
            }
            catch (IOException ioe) {
                log.error("IO Exception when reading train info file {}", (Object)traininfoFileName, (Object)ioe);
                return -2;
            }
            catch (JDOMException jde) {
                log.error("JDOM Exception when reading train info file {}", (Object)traininfoFileName, (Object)jde);
                return -3;
            }
            return this.loadTrainFromTrainInfo(info, overRideType, overRideValue);
        }
        catch (RuntimeException ex) {
            log.error("Unexpected, uncaught exception loading traininfofile [{}]", (Object)traininfoFileName, (Object)ex);
            return -9;
        }
    }

    public int loadTrainFromTrainInfo(TrainInfo info) {
        return this.loadTrainFromTrainInfo(info, OVERRIDETYPE_NONE, "");
    }

    public int loadTrainFromTrainInfo(TrainInfo info, String overRideType, String overRideValue) {
        try {
            this.loadTrainFromTrainInfoThrowsException(info, overRideType, overRideValue);
            return 0;
        }
        catch (IllegalArgumentException ex) {
            return -1;
        }
    }

    public void loadTrainFromTrainInfoThrowsException(TrainInfo info, String overRideType, String overRideValue) throws IllegalArgumentException {
        log.debug("loading train:{}, startblockname:{}, destinationBlockName:{}", new Object[]{info.getTrainName(), info.getStartBlockName(), info.getDestinationBlockName()});
        int tSource = 0;
        if (info.getTrainFromRoster()) {
            tSource = 1;
        } else if (info.getTrainFromTrains()) {
            tSource = 2;
        } else if (info.getTrainFromUser()) {
            tSource = 4;
        }
        String dccAddressToUse = info.getDccAddress();
        String trainNameToUse = info.getTrainUserName();
        String rosterIDToUse = info.getRosterId();
        switch (overRideType) {
            case "": 
            case "NONE": {
                break;
            }
            case "USER": 
            case "DCCADDRESS": {
                tSource = 4;
                dccAddressToUse = overRideValue;
                if (!trainNameToUse.isEmpty()) break;
                trainNameToUse = overRideValue;
                break;
            }
            case "OPERATIONS": {
                tSource = 2;
                trainNameToUse = overRideValue;
                break;
            }
            case "ROSTER": {
                tSource = 1;
                rosterIDToUse = overRideValue;
                RosterEntry re = Roster.getDefault().getEntryForId(rosterIDToUse);
                if (re != null) {
                    dccAddressToUse = re.getDccAddress();
                }
                if (!trainNameToUse.isEmpty()) break;
                trainNameToUse = overRideValue;
                break;
            }
        }
        if (info.getDynamicTransit()) {
            Transit tmpTransit = this.createTemporaryTransit(InstanceManager.getDefault(BlockManager.class).getBlock(info.getStartBlockName()), InstanceManager.getDefault(BlockManager.class).getBlock(info.getDestinationBlockName()), InstanceManager.getDefault(BlockManager.class).getBlock(info.getViaBlockName()));
            if (tmpTransit == null) {
                throw new IllegalArgumentException(Bundle.getMessage("Error51"));
            }
            info.setTransitName(tmpTransit.getDisplayName());
            info.setTransitId(tmpTransit.getDisplayName());
            info.setDestinationBlockSeq(tmpTransit.getMaxSequence());
        }
        if (tSource == 0) {
            log.warn("Invalid Trains From [{}]", (Object)tSource);
            throw new IllegalArgumentException(Bundle.getMessage("Error21"));
        }
        if (!this.isTrainFree(trainNameToUse)) {
            log.warn("TrainName [{}] already in use", (Object)trainNameToUse);
            throw new IllegalArgumentException(Bundle.getMessage("Error24", trainNameToUse));
        }
        ActiveTrain at = this.createActiveTrain(info.getTransitId(), trainNameToUse, tSource, info.getStartBlockId(), info.getStartBlockSeq(), info.getDestinationBlockId(), info.getDestinationBlockSeq(), info.getAutoRun(), dccAddressToUse, info.getPriority(), info.getResetWhenDone(), info.getReverseAtEnd(), true, null, info.getAllocationMethod());
        if (at != null) {
            if (tSource == 1) {
                RosterEntry re = Roster.getDefault().getEntryForId(rosterIDToUse);
                if (re != null) {
                    at.setRosterEntry(re);
                    at.setDccAddress(re.getDccAddress());
                } else {
                    log.warn("Roster Entry '{}' not found, could not create ActiveTrain '{}'", (Object)trainNameToUse, (Object)info.getTrainName());
                    throw new IllegalArgumentException(Bundle.getMessage("Error40", rosterIDToUse));
                }
            }
            at.setTrainDetection(info.getTrainDetection());
            at.setAllocateMethod(info.getAllocationMethod());
            at.setDelayedStart(info.getDelayedStart());
            at.setDepartureTimeHr(info.getDepartureTimeHr());
            at.setDepartureTimeMin(info.getDepartureTimeMin());
            at.setDelayedRestart(info.getDelayedRestart());
            at.setRestartDelay(info.getRestartDelayMin());
            at.setDelaySensor(info.getDelaySensor());
            at.setResetStartSensor(info.getResetStartSensor());
            if (this.isFastClockTimeGE(at.getDepartureTimeHr(), at.getDepartureTimeMin()) && info.getDelayedStart() != 2 || info.getDelayedStart() == 0) {
                at.setStarted();
            }
            at.setRestartSensor(info.getRestartSensor());
            at.setResetRestartSensor(info.getResetRestartSensor());
            at.setReverseDelayRestart(info.getReverseDelayedRestart());
            at.setReverseRestartDelay(info.getReverseRestartDelayMin());
            at.setReverseDelaySensor(info.getReverseRestartSensor());
            at.setReverseResetRestartSensor(info.getReverseResetRestartSensor());
            at.setTrainType(info.getTrainType());
            at.setTerminateWhenDone(info.getTerminateWhenDone());
            at.setNextTrain(info.getNextTrain());
            if (info.getAutoRun()) {
                AutoActiveTrain aat = new AutoActiveTrain(at);
                aat.setSpeedFactor(info.getSpeedFactor().floatValue());
                aat.setMaxSpeed(info.getMaxSpeed().floatValue());
                aat.setMinReliableOperatingSpeed(info.getMinReliableOperatingSpeed());
                aat.setRampRate(AutoActiveTrain.getRampRateFromName(info.getRampRate()));
                aat.setRunInReverse(info.getRunInReverse());
                aat.setSoundDecoder(info.getSoundDecoder());
                aat.setMaxTrainLength(info.getMaxTrainLengthScaleMeters(), this.getScale().getScaleFactor());
                aat.setStopBySpeedProfile(info.getStopBySpeedProfile());
                aat.setStopBySpeedProfileAdjust(info.getStopBySpeedProfileAdjust());
                aat.setUseSpeedProfile(info.getUseSpeedProfile());
                this.getAutoTrainsFrame().addAutoActiveTrain(aat);
                if (!aat.initialize()) {
                    log.error("ERROR initializing autorunning for train {}", (Object)at.getTrainName());
                    throw new IllegalArgumentException(Bundle.getMessage("Error27", at.getTrainName()));
                }
            }
        } else {
            log.warn("failed to create Active Train '{}'", (Object)info.getTrainName());
            throw new IllegalArgumentException(Bundle.getMessage("Error48", info.getTrainName()));
        }
        at.setDispatcher(this);
        this.allocateNewActiveTrain(at);
        this.newTrainDone(at);
    }

    protected List<LayoutBlock> getAdHocRoute(Block start, Block dest, Block via) {
        LayoutBlockManager lBM = InstanceManager.getDefault(LayoutBlockManager.class);
        LayoutBlock lbStart = (LayoutBlock)lBM.getByUserName(start.getDisplayName(NamedBean.DisplayOptions.USERNAME));
        LayoutBlock lbEnd = (LayoutBlock)lBM.getByUserName(dest.getDisplayName(NamedBean.DisplayOptions.USERNAME));
        LayoutBlock lbVia = (LayoutBlock)lBM.getByUserName(via.getDisplayName(NamedBean.DisplayOptions.USERNAME));
        List<LayoutBlock> blocks = new ArrayList<LayoutBlock>();
        try {
            boolean result = lBM.getLayoutBlockConnectivityTools().checkValidDest(lbStart, lbVia, lbEnd, blocks, LayoutBlockConnectivityTools.Routing.NONE);
            if (!result) {
                JmriJOptionPane.showMessageDialog(this, Bundle.getMessage("Error51"), Bundle.getMessage("ErrorTitle"), 0);
            }
            blocks = lBM.getLayoutBlockConnectivityTools().getLayoutBlocks(lbStart, lbEnd, lbVia, false, LayoutBlockConnectivityTools.Routing.NONE);
        }
        catch (JmriException JEx) {
            log.error("Finding route {}", (Object)JEx.getMessage());
            return null;
        }
        return blocks;
    }

    protected Transit createTemporaryTransit(Block start, Block dest, Block via) {
        List<LayoutBlock> blocks = this.getAdHocRoute(start, dest, via);
        if (blocks == null) {
            return null;
        }
        SectionManager sm = InstanceManager.getDefault(SectionManager.class);
        Transit tempTransit = null;
        int wNo = 0;
        String baseTransitName = "-" + start.getDisplayName() + "-" + dest.getDisplayName();
        while (tempTransit == null && wNo < 99) {
            ++wNo;
            try {
                tempTransit = this.transitManager.createNewTransit("#" + Integer.toString(wNo) + baseTransitName);
            }
            catch (Exception ex) {
                log.trace("Transit [{}} already used, try next.", (Object)("#" + Integer.toString(wNo) + baseTransitName));
            }
        }
        if (tempTransit == null) {
            log.error("Limit of Dynamic Transits for [{}] has been exceeded!", (Object)baseTransitName);
            JmriJOptionPane.showMessageDialog(this, Bundle.getMessage("DynamicTransitsExceeded", baseTransitName), Bundle.getMessage("ErrorTitle"), 0);
            return null;
        }
        tempTransit.setTransitType(Transit.TransitType.DYNAMICADHOC);
        int seq = 1;
        TransitSection prevTs = null;
        TransitSection curTs = null;
        for (LayoutBlock lB : blocks) {
            Block b = lB.getBlock();
            Section currentSection = sm.createNewSection(tempTransit.getUserName() + Integer.toString(seq) + "-" + b.getDisplayName());
            currentSection.setSectionType(Section.DYNAMICADHOC);
            currentSection.addBlock(b);
            if (curTs == null) {
                curTs = new TransitSection(currentSection, seq, 4);
            } else {
                prevTs = curTs;
                EntryPoint fEp = new EntryPoint(prevTs.getSection().getBlockBySequenceNumber(0), b, "up");
                fEp.setTypeReverse();
                prevTs.getSection().addToReverseList(fEp);
                EntryPoint rEp = new EntryPoint(b, prevTs.getSection().getBlockBySequenceNumber(0), "down");
                rEp.setTypeForward();
                currentSection.addToForwardList(rEp);
                curTs = new TransitSection(currentSection, seq, 4);
            }
            curTs.setTemporary(true);
            tempTransit.addTransitSection(curTs);
            ++seq;
        }
        return tempTransit;
    }

    public ActivateTrainFrame getActiveTrainFrame() {
        if (this.atFrame == null) {
            this.atFrame = new ActivateTrainFrame(this);
        }
        return this.atFrame;
    }

    public boolean getNewTrainActive() {
        return this.newTrainActive;
    }

    public void setNewTrainActive(boolean boo) {
        this.newTrainActive = boo;
    }

    void initializeOptions() {
        if (this.optionsRead) {
            return;
        }
        this.optionsRead = true;
        try {
            InstanceManager.getDefault(OptionsFile.class).readDispatcherOptions(this);
        }
        catch (JDOMException jde) {
            log.error("JDOM Exception when retrieving dispatcher options", (Throwable)jde);
        }
        catch (IOException ioe) {
            log.error("I/O Exception when retrieving dispatcher options", (Throwable)ioe);
        }
    }

    void openDispatcherWindow() {
        if (this.dispatcherFrame == null) {
            if (this.editorManager.getAll(LayoutEditor.class).size() > 0 && this.autoAllocate == null) {
                this.autoAllocate = new AutoAllocate(this, this.allocationRequests);
                this.autoAllocateThread = ThreadingUtil.newThread(this.autoAllocate, "Auto Allocator ");
                this.autoAllocateThread.start();
            }
            this.dispatcherFrame = this;
            this.dispatcherFrame.setTitle(Bundle.getMessage("TitleDispatcher"));
            JMenuBar menuBar = new JMenuBar();
            this.optionsMenu = new OptionsMenu(this);
            menuBar.add(this.optionsMenu);
            this.setJMenuBar(menuBar);
            this.dispatcherFrame.addHelpMenu("package.jmri.jmrit.dispatcher.Dispatcher", true);
            this.contentPane = this.dispatcherFrame.getContentPane();
            this.contentPane.setLayout(new BoxLayout(this.contentPane, 1));
            JPanel p11 = new JPanel();
            p11.setLayout(new FlowLayout());
            p11.add(new JLabel(Bundle.getMessage("ActiveTrainTableTitle")));
            this.contentPane.add(p11);
            JPanel p12 = new JPanel();
            p12.setLayout(new BorderLayout());
            this.activeTrainsTableModel = new ActiveTrainsTableModel();
            JTable activeTrainsTable = new JTable(this.activeTrainsTableModel);
            activeTrainsTable.setName(this.getClass().getName().concat(":activeTrainsTableModel"));
            activeTrainsTable.setRowSelectionAllowed(false);
            activeTrainsTable.setPreferredScrollableViewportSize(new Dimension(950, 160));
            activeTrainsTable.setColumnModel(new XTableColumnModel());
            activeTrainsTable.createDefaultColumnsFromModel();
            XTableColumnModel activeTrainsColumnModel = (XTableColumnModel)activeTrainsTable.getColumnModel();
            TableColumn allocateButtonColumn = activeTrainsColumnModel.getColumn(10);
            allocateButtonColumn.setCellEditor(new ButtonEditor(new JButton()));
            allocateButtonColumn.setResizable(true);
            ButtonRenderer buttonRenderer = new ButtonRenderer();
            activeTrainsTable.setDefaultRenderer(JButton.class, buttonRenderer);
            JButton sampleButton = new JButton("WWW...");
            activeTrainsTable.setRowHeight(sampleButton.getPreferredSize().height);
            allocateButtonColumn.setPreferredWidth(sampleButton.getPreferredSize().width + 2);
            TableColumn terminateTrainButtonColumn = activeTrainsColumnModel.getColumn(11);
            terminateTrainButtonColumn.setCellEditor(new ButtonEditor(new JButton()));
            terminateTrainButtonColumn.setResizable(true);
            buttonRenderer = new ButtonRenderer();
            activeTrainsTable.setDefaultRenderer(JButton.class, buttonRenderer);
            sampleButton = new JButton("WWW...");
            activeTrainsTable.setRowHeight(sampleButton.getPreferredSize().height);
            terminateTrainButtonColumn.setPreferredWidth(sampleButton.getPreferredSize().width + 2);
            this.addMouseListenerToHeader(activeTrainsTable);
            activeTrainsTable.setAutoResizeMode(0);
            JScrollPane activeTrainsTableScrollPane = new JScrollPane(activeTrainsTable);
            p12.add((Component)activeTrainsTableScrollPane, "Center");
            this.contentPane.add(p12);
            JPanel p13 = new JPanel();
            p13.setLayout(new FlowLayout());
            this.addTrainButton = new JButton(Bundle.getMessage("InitiateTrain") + "...");
            p13.add(this.addTrainButton);
            this.addTrainButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (!DispatcherFrame.this.newTrainActive) {
                        DispatcherFrame.this.getActiveTrainFrame().initiateTrain(e);
                        DispatcherFrame.this.newTrainActive = true;
                    } else {
                        DispatcherFrame.this.getActiveTrainFrame().showActivateFrame();
                    }
                }
            });
            this.addTrainButton.setToolTipText(Bundle.getMessage("InitiateTrainButtonHint"));
            p13.add(new JLabel("   "));
            p13.add(new JLabel("   "));
            this.allocateExtraButton = new JButton(Bundle.getMessage("AllocateExtra") + "...");
            p13.add(this.allocateExtraButton);
            this.allocateExtraButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DispatcherFrame.this.allocateExtraSection(e);
                }
            });
            this.allocateExtraButton.setToolTipText(Bundle.getMessage("AllocateExtraButtonHint"));
            p13.add(new JLabel("   "));
            this.cancelRestartButton = new JButton(Bundle.getMessage("CancelRestart") + "...");
            p13.add(this.cancelRestartButton);
            this.cancelRestartButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (!DispatcherFrame.this.newTrainActive) {
                        DispatcherFrame.this.cancelRestart(e);
                    } else if (DispatcherFrame.this.restartingTrainsList.size() > 0) {
                        DispatcherFrame.this.getActiveTrainFrame().showActivateFrame();
                        JmriJOptionPane.showMessageDialog(DispatcherFrame.this.dispatcherFrame, Bundle.getMessage("Message2"), Bundle.getMessage("MessageTitle"), 1);
                    } else {
                        DispatcherFrame.this.getActiveTrainFrame().showActivateFrame();
                    }
                }
            });
            this.cancelRestartButton.setToolTipText(Bundle.getMessage("CancelRestartButtonHint"));
            p13.add(new JLabel("   "));
            this.terminateTrainButton = new JButton(Bundle.getMessage("TerminateTrain"));
            p13.add(this.terminateTrainButton);
            this.terminateTrainButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (!DispatcherFrame.this.newTrainActive) {
                        DispatcherFrame.this.terminateTrain(e);
                    } else if (DispatcherFrame.this.activeTrainsList.size() > 0) {
                        DispatcherFrame.this.getActiveTrainFrame().showActivateFrame();
                        JmriJOptionPane.showMessageDialog(DispatcherFrame.this.dispatcherFrame, Bundle.getMessage("Message1"), Bundle.getMessage("MessageTitle"), 1);
                    } else {
                        DispatcherFrame.this.getActiveTrainFrame().showActivateFrame();
                    }
                }
            });
            this.terminateTrainButton.setToolTipText(Bundle.getMessage("TerminateTrainButtonHint"));
            this.contentPane.add(p13);
            JTablePersistenceManager tpm = InstanceManager.getNullableDefault(JTablePersistenceManager.class);
            if (tpm != null) {
                tpm.resetState(activeTrainsTable);
                tpm.persist(activeTrainsTable);
            }
            this.contentPane.add(new JSeparator());
            JPanel p21 = new JPanel();
            p21.setLayout(new FlowLayout());
            p21.add(new JLabel(Bundle.getMessage("RequestedAllocationsTableTitle")));
            this.contentPane.add(p21);
            JPanel p22 = new JPanel();
            p22.setLayout(new BorderLayout());
            this.allocationRequestTableModel = new AllocationRequestTableModel();
            JTable allocationRequestTable = new JTable(this.allocationRequestTableModel);
            allocationRequestTable.setName(this.getClass().getName().concat(":allocationRequestTable"));
            allocationRequestTable.setRowSelectionAllowed(false);
            allocationRequestTable.setPreferredScrollableViewportSize(new Dimension(950, 100));
            allocationRequestTable.setColumnModel(new XTableColumnModel());
            allocationRequestTable.createDefaultColumnsFromModel();
            XTableColumnModel allocationRequestColumnModel = (XTableColumnModel)allocationRequestTable.getColumnModel();
            TableColumn allocateColumn = allocationRequestColumnModel.getColumn(10);
            allocateColumn.setCellEditor(new ButtonEditor(new JButton()));
            allocateColumn.setResizable(true);
            buttonRenderer = new ButtonRenderer();
            allocationRequestTable.setDefaultRenderer(JButton.class, buttonRenderer);
            sampleButton = new JButton(Bundle.getMessage("AllocateButton"));
            allocationRequestTable.setRowHeight(sampleButton.getPreferredSize().height);
            allocateColumn.setPreferredWidth(sampleButton.getPreferredSize().width + 2);
            TableColumn cancelButtonColumn = allocationRequestColumnModel.getColumn(11);
            cancelButtonColumn.setCellEditor(new ButtonEditor(new JButton()));
            cancelButtonColumn.setResizable(true);
            cancelButtonColumn.setPreferredWidth(sampleButton.getPreferredSize().width + 2);
            this.addMouseListenerToHeader(allocationRequestTable);
            allocationRequestTable.setAutoResizeMode(0);
            JScrollPane allocationRequestTableScrollPane = new JScrollPane(allocationRequestTable);
            p22.add((Component)allocationRequestTableScrollPane, "Center");
            this.contentPane.add(p22);
            if (tpm != null) {
                tpm.resetState(allocationRequestTable);
                tpm.persist(allocationRequestTable);
            }
            this.contentPane.add(new JSeparator());
            JPanel p30 = new JPanel();
            p30.setLayout(new FlowLayout());
            p30.add(new JLabel(Bundle.getMessage("AllocatedSectionsTitle") + "    "));
            this.autoAllocateBox = new JCheckBox(Bundle.getMessage("AutoDispatchItem"));
            p30.add(this.autoAllocateBox);
            this.autoAllocateBox.setToolTipText(Bundle.getMessage("AutoAllocateBoxHint"));
            this.autoAllocateBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DispatcherFrame.this.handleAutoAllocateChanged(e);
                }
            });
            this.autoAllocateBox.setSelected(this._AutoAllocate);
            this.autoReleaseBox = new JCheckBox(Bundle.getMessage("AutoReleaseBoxLabel"));
            p30.add(this.autoReleaseBox);
            this.autoReleaseBox.setToolTipText(Bundle.getMessage("AutoReleaseBoxHint"));
            this.autoReleaseBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DispatcherFrame.this.handleAutoReleaseChanged(e);
                }
            });
            this.autoReleaseBox.setSelected(this._AutoAllocate);
            this._AutoRelease = this._AutoAllocate;
            this.contentPane.add(p30);
            JPanel p31 = new JPanel();
            p31.setLayout(new BorderLayout());
            this.allocatedSectionTableModel = new AllocatedSectionTableModel();
            JTable allocatedSectionTable = new JTable(this.allocatedSectionTableModel);
            allocatedSectionTable.setName(this.getClass().getName().concat(":allocatedSectionTable"));
            allocatedSectionTable.setRowSelectionAllowed(false);
            allocatedSectionTable.setPreferredScrollableViewportSize(new Dimension(730, 200));
            allocatedSectionTable.setColumnModel(new XTableColumnModel());
            allocatedSectionTable.createDefaultColumnsFromModel();
            XTableColumnModel allocatedSectionColumnModel = (XTableColumnModel)allocatedSectionTable.getColumnModel();
            TableColumn releaseColumn = allocatedSectionColumnModel.getColumn(7);
            releaseColumn.setCellEditor(new ButtonEditor(new JButton()));
            releaseColumn.setResizable(true);
            allocatedSectionTable.setDefaultRenderer(JButton.class, buttonRenderer);
            JButton sampleAButton = new JButton(Bundle.getMessage("ReleaseButton"));
            allocatedSectionTable.setRowHeight(sampleAButton.getPreferredSize().height);
            releaseColumn.setPreferredWidth(sampleAButton.getPreferredSize().width + 2);
            JScrollPane allocatedSectionTableScrollPane = new JScrollPane(allocatedSectionTable);
            p31.add((Component)allocatedSectionTableScrollPane, "Center");
            this.addMouseListenerToHeader(allocatedSectionTable);
            allocatedSectionTable.setAutoResizeMode(0);
            this.contentPane.add(p31);
            if (tpm != null) {
                tpm.resetState(allocatedSectionTable);
                tpm.persist(allocatedSectionTable);
            }
        }
        this.dispatcherFrame.pack();
        this.dispatcherFrame.setVisible(true);
    }

    void releaseAllocatedSectionFromTable(int index) {
        AllocatedSection as = this.allocatedSections.get(index);
        this.releaseAllocatedSection(as, false);
    }

    public void allocateExtraSection(ActionEvent e, ActiveTrain at) {
        this.allocateExtraSection(e);
        if (this._ShortActiveTrainNames) {
            this.atSelectBox.setSelectedItem(at.getTrainName());
        } else {
            this.atSelectBox.setSelectedItem(at.getActiveTrainName());
        }
    }

    private void allocateExtraSection(ActionEvent e) {
        if (this.extraFrame == null) {
            this.extraFrame = new JmriJFrame(Bundle.getMessage("ExtraTitle"));
            this.extraFrame.addHelpMenu("package.jmri.jmrit.dispatcher.AllocateExtra", true);
            this.extraPane = this.extraFrame.getContentPane();
            this.extraPane.setLayout(new BoxLayout(this.extraFrame.getContentPane(), 1));
            JPanel p1 = new JPanel();
            p1.setLayout(new FlowLayout());
            p1.add(new JLabel(Bundle.getMessage("ActiveColumnTitle") + ":"));
            p1.add(this.atSelectBox);
            this.atSelectBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DispatcherFrame.this.handleATSelectionChanged(e);
                }
            });
            this.atSelectBox.setToolTipText(Bundle.getMessage("ATBoxHint"));
            this.extraPane.add(p1);
            JPanel p2 = new JPanel();
            p2.setLayout(new FlowLayout());
            p2.add(new JLabel(Bundle.getMessage("ExtraBoxLabel") + ":"));
            p2.add(this.extraBox);
            this.extraBox.setToolTipText(Bundle.getMessage("ExtraBoxHint"));
            this.extraPane.add(p2);
            JPanel p7 = new JPanel();
            p7.setLayout(new FlowLayout());
            JButton cancelButton = null;
            cancelButton = new JButton(Bundle.getMessage("ButtonCancel"));
            p7.add(cancelButton);
            cancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DispatcherFrame.this.cancelExtraRequested(e);
                }
            });
            cancelButton.setToolTipText(Bundle.getMessage("CancelExtraHint"));
            p7.add(new JLabel("    "));
            JButton aExtraButton = null;
            aExtraButton = new JButton(Bundle.getMessage("AllocateButton"));
            p7.add(aExtraButton);
            aExtraButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DispatcherFrame.this.addExtraRequested(e);
                }
            });
            aExtraButton.setToolTipText(Bundle.getMessage("AllocateButtonHint"));
            this.extraPane.add(p7);
        }
        this.initializeATComboBox();
        this.initializeExtraComboBox();
        this.extraFrame.pack();
        this.extraFrame.setVisible(true);
    }

    private void handleAutoAllocateChanged(ActionEvent e) {
        this.setAutoAllocate(this.autoAllocateBox.isSelected());
        this.stopStartAutoAllocateRelease();
        if (this.autoAllocateBox != null) {
            this.autoAllocateBox.setSelected(this._AutoAllocate);
        }
        if (this.optionsMenu != null) {
            this.optionsMenu.initializeMenu();
        }
        if (this._AutoAllocate) {
            this.queueScanOfAllocationRequests();
        }
    }

    protected void queueScanOfAllocationRequests() {
        if (this._AutoAllocate) {
            this.autoAllocate.scanAllocationRequests(new TaskAllocateRelease(TaskAllocateRelease.TaskAction.SCAN_REQUESTS));
        }
    }

    protected void queueReleaseOfReservedSections(String trainName) {
        if (this._AutoRelease || this._AutoAllocate) {
            this.autoAllocate.scanAllocationRequests(new TaskAllocateRelease(TaskAllocateRelease.TaskAction.RELEASE_RESERVED, trainName));
        }
    }

    protected void queueAllocate(AllocationRequest aRequest) {
        if (this._AutoRelease || this._AutoAllocate) {
            this.autoAllocate.scanAllocationRequests(new TaskAllocateRelease(TaskAllocateRelease.TaskAction.ALLOCATE_IMMEDIATE, aRequest));
        }
    }

    protected void queueWaitForEmpty() {
        if (this._AutoAllocate) {
            while (!this.autoAllocate.allRequestsDone()) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException iex) {
                    return;
                }
            }
        }
    }

    protected void queueReleaseOfCompletedAllocations() {
        if (this._AutoRelease) {
            this.autoAllocate.scanAllocationRequests(new TaskAllocateRelease(TaskAllocateRelease.TaskAction.AUTO_RELEASE));
        }
    }

    private void handleAutoReleaseChanged(ActionEvent e) {
        this._AutoRelease = this.autoReleaseBox.isSelected();
        this.stopStartAutoAllocateRelease();
        if (this.autoReleaseBox != null) {
            this.autoReleaseBox.setSelected(this._AutoRelease);
        }
        if (this._AutoRelease) {
            this.queueReleaseOfCompletedAllocations();
        }
    }

    protected boolean isTrainFree(String rName) {
        for (int j = 0; j < this.getActiveTrainsList().size(); ++j) {
            ActiveTrain at = this.getActiveTrainsList().get(j);
            if (!rName.equals(at.getTrainName())) continue;
            return false;
        }
        return true;
    }

    public boolean isAddressFree(int addr) {
        for (int j = 0; j < this.activeTrainsList.size(); ++j) {
            ActiveTrain at = this.activeTrainsList.get(j);
            if (addr != Integer.parseInt(at.getDccAddress())) continue;
            return false;
        }
        return true;
    }

    private void handleATSelectionChanged(ActionEvent e) {
        this.atSelectedIndex = this.atSelectBox.getSelectedIndex();
        this.initializeExtraComboBox();
        this.extraFrame.pack();
        this.extraFrame.setVisible(true);
    }

    private void initializeATComboBox() {
        this.atSelectedIndex = -1;
        this.atSelectBox.removeAllItems();
        for (int i = 0; i < this.activeTrainsList.size(); ++i) {
            ActiveTrain at = this.activeTrainsList.get(i);
            if (this._ShortActiveTrainNames) {
                this.atSelectBox.addItem(at.getTrainName());
                continue;
            }
            this.atSelectBox.addItem(at.getActiveTrainName());
        }
        if (this.activeTrainsList.size() > 0) {
            this.atSelectBox.setSelectedIndex(0);
            this.atSelectedIndex = 0;
        }
    }

    private void initializeExtraComboBox() {
        this.extraBox.removeAllItems();
        this.extraBoxList.clear();
        if (this.atSelectedIndex < 0) {
            return;
        }
        ActiveTrain at = this.activeTrainsList.get(this.atSelectedIndex);
        List<AllocatedSection> allocatedSectionList = at.getAllocatedSectionList();
        for (Section s : InstanceManager.getDefault(SectionManager.class).getNamedBeanSet()) {
            if (s.getState() != 2) continue;
            boolean connected = false;
            for (int k = 0; k < allocatedSectionList.size(); ++k) {
                if (!this.connected(s, allocatedSectionList.get(k).getSection())) continue;
                connected = true;
            }
            if (!connected) continue;
            this.extraBoxList.add(s);
            this.extraBox.addItem(this.getSectionName(s));
        }
        if (this.extraBoxList.size() > 0) {
            this.extraBox.setSelectedIndex(0);
        }
    }

    private boolean connected(Section s1, Section s2) {
        if (s1 != null && s2 != null) {
            List<EntryPoint> s1Entries = s1.getEntryPointList();
            List<EntryPoint> s2Entries = s2.getEntryPointList();
            for (int i = 0; i < s1Entries.size(); ++i) {
                Block b = s1Entries.get(i).getFromBlock();
                for (int j = 0; j < s2Entries.size(); ++j) {
                    if (b != s2Entries.get(j).getBlock()) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public String getSectionName(Section sec) {
        String s = sec.getDisplayName();
        return s;
    }

    private void cancelExtraRequested(ActionEvent e) {
        this.extraFrame.setVisible(false);
        this.extraFrame.dispose();
        this.extraFrame = null;
    }

    private void addExtraRequested(ActionEvent e) {
        int index = this.extraBox.getSelectedIndex();
        if (this.atSelectedIndex < 0 || index < 0) {
            this.cancelExtraRequested(e);
            return;
        }
        ActiveTrain at = this.activeTrainsList.get(this.atSelectedIndex);
        Transit t = at.getTransit();
        Section s = this.extraBoxList.get(index);
        AllocationRequest ar = null;
        boolean requested = false;
        if (t.containsSection(s)) {
            if (s == at.getNextSectionToAllocate()) {
                this.allocateNextRequested(this.atSelectedIndex);
                return;
            }
            int seq = -99;
            ArrayList<Integer> seqList = t.getSeqListBySection(s);
            if (seqList.size() > 0) {
                seq = (Integer)seqList.get(0);
            }
            if (seqList.size() > 1) {
                int test = at.getNextSectionSeqNumber() - 1;
                int diff = Math.abs(seq - test);
                for (int i = 1; i < seqList.size(); ++i) {
                    if (diff <= Math.abs(test - (Integer)seqList.get(i))) continue;
                    seq = (Integer)seqList.get(i);
                    diff = Math.abs(seq - test);
                }
            }
            requested = this.requestAllocation(at, s, at.getAllocationDirectionFromSectionAndSeq(s, seq), seq, true, this.extraFrame);
            ar = this.findAllocationRequestInQueue(s, seq, at.getAllocationDirectionFromSectionAndSeq(s, seq), at);
        } else {
            requested = this.requestAllocation(at, s, 4, -99, true, this.extraFrame);
            ar = this.findAllocationRequestInQueue(s, -99, 4, at);
        }
        if (requested && ar != null) {
            this.allocateSection(ar, null);
        }
        if (this.extraFrame != null) {
            this.extraFrame.setVisible(false);
            this.extraFrame.dispose();
            this.extraFrame = null;
        }
    }

    public boolean extendActiveTrainsPath(Section s, ActiveTrain at, JmriJFrame jFrame) {
        if (s.getEntryPointFromSection(at.getEndBlockSection(), 4) != null && at.getNextSectionToAllocate() == null) {
            int seq = at.getEndBlockSectionSequenceNumber() + 1;
            if (!at.addEndSection(s, seq)) {
                return false;
            }
            TransitSection ts = new TransitSection(s, seq, 4);
            ts.setTemporary(true);
            at.getTransit().addTransitSection(ts);
            boolean requested = this.requestAllocation(at, s, 4, seq, true, jFrame);
            AllocationRequest ar = this.findAllocationRequestInQueue(s, seq, 4, at);
            if (requested && ar != null) {
                this.allocateSection(ar, null);
                return true;
            }
        }
        return false;
    }

    public boolean removeFromActiveTrainPath(Section s, ActiveTrain at, JmriJFrame jFrame) {
        if (s == null || at == null) {
            return false;
        }
        if (at.getEndBlockSection() != s) {
            log.error("Active trains end section {} is not the same as the requested section to remove {}", (Object)at.getEndBlockSection().getDisplayName(USERSYS), (Object)s.getDisplayName(USERSYS));
            return false;
        }
        if (!at.getTransit().removeLastTemporarySection(s)) {
            return false;
        }
        for (int k = this.allocatedSections.size(); k > 0; --k) {
            if (at != this.allocatedSections.get(k - 1).getActiveTrain() || this.allocatedSections.get(k - 1).getSection() != s) continue;
            this.releaseAllocatedSection(this.allocatedSections.get(k - 1), true);
        }
        at.removeLastAllocatedSection();
        return true;
    }

    void cancelRestart(ActionEvent e) {
        ActiveTrain at = null;
        if (this.restartingTrainsList.size() == 1) {
            at = this.restartingTrainsList.get(0);
        } else if (this.restartingTrainsList.size() > 1) {
            Object[] choices = new Object[this.restartingTrainsList.size()];
            for (int i = 0; i < this.restartingTrainsList.size(); ++i) {
                choices[i] = this._ShortActiveTrainNames ? this.restartingTrainsList.get(i).getTrainName() : this.restartingTrainsList.get(i).getActiveTrainName();
            }
            Object selName = JmriJOptionPane.showInputDialog(this.dispatcherFrame, Bundle.getMessage("CancelRestartChoice"), Bundle.getMessage("CancelRestartTitle"), 3, null, choices, choices[0]);
            if (selName == null) {
                return;
            }
            for (int j = 0; j < this.restartingTrainsList.size(); ++j) {
                if (!selName.equals(choices[j])) continue;
                at = this.restartingTrainsList.get(j);
            }
        }
        if (at != null) {
            at.setResetWhenDone(false);
            for (int j = this.restartingTrainsList.size(); j > 0; --j) {
                if (this.restartingTrainsList.get(j - 1) != at) continue;
                this.restartingTrainsList.remove(j - 1);
                return;
            }
        }
    }

    void terminateTrain(ActionEvent e) {
        ActiveTrain at = null;
        if (this.activeTrainsList.size() == 1) {
            at = this.activeTrainsList.get(0);
        } else if (this.activeTrainsList.size() > 1) {
            Object[] choices = new Object[this.activeTrainsList.size()];
            for (int i = 0; i < this.activeTrainsList.size(); ++i) {
                choices[i] = this._ShortActiveTrainNames ? this.activeTrainsList.get(i).getTrainName() : this.activeTrainsList.get(i).getActiveTrainName();
            }
            Object selName = JmriJOptionPane.showInputDialog(this.dispatcherFrame, Bundle.getMessage("TerminateTrainChoice"), Bundle.getMessage("TerminateTrainTitle"), 3, null, choices, choices[0]);
            if (selName == null) {
                return;
            }
            for (int j = 0; j < this.activeTrainsList.size(); ++j) {
                if (!selName.equals(choices[j])) continue;
                at = this.activeTrainsList.get(j);
            }
        }
        if (at != null) {
            this.terminateActiveTrain(at, true, false);
        }
    }

    private int checkSignals(Transit t) {
        int numErrors = 0;
        for (TransitSection ts : t.getTransitSectionList()) {
            numErrors += ts.getSection().placeDirectionSensors();
        }
        return numErrors;
    }

    private int validateConnectivity(Transit t) {
        int numErrors = 0;
        for (int i = 0; i < t.getTransitSectionList().size(); ++i) {
            String s = t.getTransitSectionList().get(i).getSection().validate();
            if (s.isEmpty()) continue;
            log.error(s);
            ++numErrors;
        }
        return numErrors;
    }

    void allocateNextRequested(int index) {
        ActiveTrain at = this.activeTrainsList.get(index);
        this.allocateNextRequestedForTrain(at);
    }

    protected void allocateNextRequestedForTrain(ActiveTrain at) {
        Section next = at.getNextSectionToAllocate();
        if (next == null) {
            return;
        }
        int seqNext = at.getNextSectionSeqNumber();
        int dirNext = at.getAllocationDirectionFromSectionAndSeq(next, seqNext);
        if (this.requestAllocation(at, next, dirNext, seqNext, true, this.dispatcherFrame)) {
            AllocationRequest ar = this.findAllocationRequestInQueue(next, seqNext, dirNext, at);
            if (ar == null) {
                return;
            }
            this.allocateSection(ar, null);
        }
    }

    public ActiveTrain createActiveTrain(String transitID, String trainID, int tSource, String startBlockName, int startBlockSectionSequenceNumber, String endBlockName, int endBlockSectionSequenceNumber, boolean autoRun, String dccAddress, int priority, boolean resetWhenDone, boolean reverseAtEnd, boolean showErrorMessages, JmriJFrame frame, int allocateMethod) {
        int numErrors;
        Block endBlock;
        log.debug("trainID:{}, tSource:{}, startBlockName:{}, startBlockSectionSequenceNumber:{}, endBlockName:{}, endBlockSectionSequenceNumber:{}", new Object[]{trainID, tSource, startBlockName, startBlockSectionSequenceNumber, endBlockName, endBlockSectionSequenceNumber});
        Transit t = this.transitManager.getTransit(transitID);
        if (t == null) {
            if (showErrorMessages) {
                JmriJOptionPane.showMessageDialog(frame, MessageFormat.format(Bundle.getMessage("Error1"), transitID), Bundle.getMessage("ErrorTitle"), 0);
            }
            log.error("Bad Transit name '{}' when attempting to create an Active Train", (Object)transitID);
            return null;
        }
        if (t.getState() != 2) {
            if (showErrorMessages) {
                JmriJOptionPane.showMessageDialog(frame, MessageFormat.format(Bundle.getMessage("Error2"), transitID), Bundle.getMessage("ErrorTitle"), 0);
            }
            log.error("Transit '{}' not IDLE, cannot create an Active Train", (Object)transitID);
            return null;
        }
        if (trainID == null || trainID.equals("")) {
            if (showErrorMessages) {
                JmriJOptionPane.showMessageDialog(frame, Bundle.getMessage("Error3"), Bundle.getMessage("ErrorTitle"), 0);
            }
            log.error("TrainID string not provided, cannot create an Active Train");
            return null;
        }
        if (tSource != 1 && tSource != 2 && tSource != 4) {
            if (showErrorMessages) {
                JmriJOptionPane.showMessageDialog(frame, Bundle.getMessage("Error21"), Bundle.getMessage("ErrorTitle"), 0);
            }
            log.error("Train source is invalid - {} - cannot create an Active Train", (Object)tSource);
            return null;
        }
        Block startBlock = InstanceManager.getDefault(BlockManager.class).getBlock(startBlockName);
        if (startBlock == null) {
            if (showErrorMessages) {
                JmriJOptionPane.showMessageDialog(frame, MessageFormat.format(Bundle.getMessage("Error4"), startBlockName), Bundle.getMessage("ErrorTitle"), 0);
            }
            log.error("Bad startBlockName '{}' when attempting to create an Active Train", (Object)startBlockName);
            return null;
        }
        if (this.isInAllocatedSection(startBlock)) {
            if (showErrorMessages && !dispatcherSystemSchedulingInOperation) {
                JmriJOptionPane.showMessageDialog(frame, MessageFormat.format(Bundle.getMessage("Error5"), startBlock.getDisplayName()), Bundle.getMessage("ErrorTitle"), 0);
            }
            log.error("Start block '{}' in allocated Section, cannot create an Active Train", (Object)startBlock.getDisplayName(USERSYS));
            return null;
        }
        if (this._HasOccupancyDetection && startBlock.getState() != 2) {
            if (showErrorMessages && !dispatcherSystemSchedulingInOperation) {
                JmriJOptionPane.showMessageDialog(frame, MessageFormat.format(Bundle.getMessage("Error6"), startBlock.getDisplayName()), Bundle.getMessage("ErrorTitle"), 0);
            }
            log.error("No train in start block '{}', cannot create an Active Train", (Object)startBlock.getDisplayName(USERSYS));
            return null;
        }
        if (startBlockSectionSequenceNumber <= 0) {
            if (showErrorMessages) {
                JmriJOptionPane.showMessageDialog(frame, Bundle.getMessage("Error12"), Bundle.getMessage("ErrorTitle"), 0);
            }
        } else if (startBlockSectionSequenceNumber > t.getMaxSequence()) {
            if (showErrorMessages) {
                JmriJOptionPane.showMessageDialog(frame, MessageFormat.format(Bundle.getMessage("Error13"), "" + startBlockSectionSequenceNumber), Bundle.getMessage("ErrorTitle"), 0);
            }
            log.error("Invalid sequence number '{}' when attempting to create an Active Train", (Object)startBlockSectionSequenceNumber);
            return null;
        }
        if ((endBlock = InstanceManager.getDefault(BlockManager.class).getBlock(endBlockName)) == null || !t.containsBlock(endBlock)) {
            if (showErrorMessages) {
                JmriJOptionPane.showMessageDialog(frame, MessageFormat.format(Bundle.getMessage("Error7"), endBlockName), Bundle.getMessage("ErrorTitle"), 0);
            }
            log.error("Bad endBlockName '{}' when attempting to create an Active Train", (Object)endBlockName);
            return null;
        }
        if (endBlockSectionSequenceNumber <= 0 && t.getBlockCount(endBlock) > 1) {
            JmriJOptionPane.showMessageDialog(frame, Bundle.getMessage("Error8"), Bundle.getMessage("ErrorTitle"), 0);
        } else if (endBlockSectionSequenceNumber > t.getMaxSequence()) {
            if (showErrorMessages) {
                JmriJOptionPane.showMessageDialog(frame, MessageFormat.format(Bundle.getMessage("Error9"), "" + endBlockSectionSequenceNumber), Bundle.getMessage("ErrorTitle"), 0);
            }
            log.error("Invalid sequence number '{}' when attempting to create an Active Train", (Object)endBlockSectionSequenceNumber);
            return null;
        }
        if (!reverseAtEnd && resetWhenDone && !t.canBeResetWhenDone()) {
            if (showErrorMessages) {
                JmriJOptionPane.showMessageDialog(frame, MessageFormat.format(Bundle.getMessage("Error26"), t.getDisplayName()), Bundle.getMessage("ErrorTitle"), 0);
            }
            log.error("Incompatible Transit set up and request to Reset When Done when attempting to create an Active Train");
            return null;
        }
        if (autoRun && (dccAddress == null || dccAddress.equals(""))) {
            if (showErrorMessages) {
                JmriJOptionPane.showMessageDialog(frame, Bundle.getMessage("Error10"), Bundle.getMessage("ErrorTitle"), 0);
            }
            log.error("AutoRun requested without a dccAddress when attempting to create an Active Train");
            return null;
        }
        if (autoRun) {
            if (this._autoTrainsFrame == null) {
                if ((!this._UseConnectivity || this.editorManager.getAll(LayoutEditor.class).size() == 0) && showErrorMessages) {
                    JmriJOptionPane.showMessageDialog(frame, Bundle.getMessage("Error33"), Bundle.getMessage("ErrorTitle"), 0);
                    log.error("AutoRun requested without a LayoutEditor panel for connectivity.");
                    return null;
                }
                if (!this._HasOccupancyDetection && showErrorMessages) {
                    JmriJOptionPane.showMessageDialog(frame, Bundle.getMessage("Error35"), Bundle.getMessage("ErrorTitle"), 0);
                    log.error("AutoRun requested without occupancy detection.");
                    return null;
                }
                for (LayoutEditor panel : this.editorManager.getAll(LayoutEditor.class)) {
                    for (int iSM = 0; iSM < panel.getSignalMastList().size(); ++iSM) {
                        float msl = panel.getSignalMastList().get(iSM).getSignalMast().getSignalSystem().getMaximumLineSpeed();
                        if (!(msl > this.maximumLineSpeed)) continue;
                        this.maximumLineSpeed = msl;
                    }
                }
            }
            if ((numErrors = this.validateConnectivity(t)) != 0) {
                if (showErrorMessages) {
                    JmriJOptionPane.showMessageDialog(frame, MessageFormat.format(Bundle.getMessage("Error34"), "" + numErrors), Bundle.getMessage("ErrorTitle"), 0);
                }
                return null;
            }
            if (this.getSignalType() == 0 && this.getSetSSLDirectionalSensors()) {
                numErrors = this.checkSignals(t);
                if (numErrors == 0) {
                    t.initializeBlockingSensors();
                }
                if (numErrors != 0) {
                    if (showErrorMessages) {
                        JmriJOptionPane.showMessageDialog(frame, MessageFormat.format(Bundle.getMessage("Error36"), "" + numErrors), Bundle.getMessage("ErrorTitle"), 0);
                    }
                    return null;
                }
            }
            if (this._autoTrainsFrame == null) {
                this._autoTrainsFrame = new AutoTrainsFrame(this);
            } else {
                this._autoTrainsFrame.setVisible(true);
            }
        } else if (this._UseConnectivity && this.editorManager.getAll(LayoutEditor.class).size() > 0 && this.getSignalType() == 0) {
            numErrors = this.checkSignals(t);
            if (numErrors == 0) {
                t.initializeBlockingSensors();
            }
            if (numErrors != 0) {
                if (showErrorMessages) {
                    JmriJOptionPane.showMessageDialog(frame, MessageFormat.format(Bundle.getMessage("Error36"), "" + numErrors), Bundle.getMessage("ErrorTitle"), 0);
                }
                return null;
            }
        }
        ActiveTrain at = new ActiveTrain(t, trainID, tSource);
        this.activeTrainsList.add(at);
        PropertyChangeListener listener = null;
        listener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                DispatcherFrame.this.handleActiveTrainChange(e);
            }
        };
        at.addPropertyChangeListener(listener);
        this._atListeners.add(listener);
        t.setState(4);
        at.setStartBlock(startBlock);
        at.setStartBlockSectionSequenceNumber(startBlockSectionSequenceNumber);
        at.setEndBlock(endBlock);
        at.setEndBlockSection(t.getSectionFromBlockAndSeq(endBlock, endBlockSectionSequenceNumber));
        at.setEndBlockSectionSequenceNumber(endBlockSectionSequenceNumber);
        at.setResetWhenDone(resetWhenDone);
        if (resetWhenDone) {
            this.restartingTrainsList.add(at);
        }
        at.setReverseAtEnd(reverseAtEnd);
        at.setAllocateMethod(allocateMethod);
        at.setPriority(priority);
        at.setDccAddress(dccAddress);
        at.setAutoRun(autoRun);
        return at;
    }

    public void allocateNewActiveTrain(ActiveTrain at) {
        AllocationRequest ar;
        if (at.getDelayedStart() == 2 && at.getDelaySensor() != null && at.getDelaySensor().getState() != 2) {
            at.initializeDelaySensor();
        }
        if ((ar = at.initializeFirstAllocation()) == null) {
            log.debug("First allocation returned null, normal for auotallocate");
        }
        this.activeTrainsTableModel.fireTableDataChanged();
        if (this.allocatedSectionTableModel != null) {
            this.allocatedSectionTableModel.fireTableDataChanged();
        }
    }

    private void handleActiveTrainChange(PropertyChangeEvent e) {
        this.activeTrainsTableModel.fireTableDataChanged();
    }

    private boolean isInAllocatedSection(Block b) {
        for (int i = 0; i < this.allocatedSections.size(); ++i) {
            Section s = this.allocatedSections.get(i).getSection();
            if (!s.containsBlock(b)) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    public void terminateActiveTrain(ActiveTrain at) {
        this.terminateActiveTrain(at, true, false);
    }

    public void terminateActiveTrain(ActiveTrain at, boolean terminateNow, boolean runNextTrain) {
        int k;
        if (at == null) {
            log.error("Null ActiveTrain pointer when attempting to terminate an ActiveTrain");
            return;
        }
        for (k = this.allocationRequests.size(); k > 0; --k) {
            if (at != this.allocationRequests.get(k - 1).getActiveTrain()) continue;
            this.allocationRequests.get(k - 1).dispose();
            this.allocationRequests.remove(k - 1);
        }
        for (k = this.allocatedSections.size(); k > 0; --k) {
            try {
                if (at != this.allocatedSections.get(k - 1).getActiveTrain()) continue;
                if (!terminateNow) {
                    if (this.allocatedSections.get(k - 1).getSection().getOccupancy() != 2) {
                        this.releaseAllocatedSection(this.allocatedSections.get(k - 1), terminateNow);
                        continue;
                    }
                    log.debug("Section[{}] State [{}]", (Object)this.allocatedSections.get(k - 1).getSection().getUserName(), (Object)this.allocatedSections.get(k - 1).getSection().getState());
                    continue;
                }
                this.releaseAllocatedSection(this.allocatedSections.get(k - 1), terminateNow);
                continue;
            }
            catch (RuntimeException e) {
                log.warn("releaseAllocatedSection failed - maybe the AllocatedSection was removed due to a terminating train?? {}", (Object)e.getMessage());
            }
        }
        for (int j = this.restartingTrainsList.size(); j > 0; --j) {
            if (at != this.restartingTrainsList.get(j - 1)) continue;
            this.restartingTrainsList.remove(j - 1);
        }
        if (this.autoAllocate != null) {
            this.queueReleaseOfReservedSections(at.getTrainName());
        }
        if (terminateNow) {
            for (int m = this.activeTrainsList.size(); m > 0; --m) {
                if (at != this.activeTrainsList.get(m - 1)) continue;
                this.activeTrainsList.remove(m - 1);
                at.removePropertyChangeListener(this._atListeners.get(m - 1));
                this._atListeners.remove(m - 1);
            }
            if (at.getAutoRun()) {
                AutoActiveTrain aat = at.getAutoActiveTrain();
                aat.terminate();
                aat.dispose();
            }
            this.removeHeldMast(null, at);
            at.terminate();
            if (runNextTrain && !at.getNextTrain().isEmpty() && !at.getNextTrain().equals("None")) {
                log.debug("Loading Next Train[{}]", (Object)at.getNextTrain());
                if (at.getRosterEntry() != null) {
                    ThreadingUtil.runOnLayoutDelayed(() -> this.loadTrainFromTrainInfo(at.getNextTrain(), OVERRIDETYPE_ROSTER, at.getRosterEntry().getId()), 2000);
                } else {
                    ThreadingUtil.runOnLayoutDelayed(() -> this.loadTrainFromTrainInfo(at.getNextTrain(), OVERRIDETYPE_USER, at.getDccAddress()), 2000);
                }
            }
            at.dispose();
        }
        this.activeTrainsTableModel.fireTableDataChanged();
        if (this.allocatedSectionTableModel != null) {
            this.allocatedSectionTableModel.fireTableDataChanged();
        }
        this.allocationRequestTableModel.fireTableDataChanged();
    }

    protected boolean requestAllocation(ActiveTrain activeTrain, Section section, int direction, int seqNumber, boolean showErrorMessages, JmriJFrame frame, boolean firstAllocation) {
        if (activeTrain == null) {
            if (showErrorMessages) {
                JmriJOptionPane.showMessageDialog(frame, Bundle.getMessage("Error16"), Bundle.getMessage("ErrorTitle"), 0);
            }
            log.error("Missing ActiveTrain specification");
            return false;
        }
        if (section == null) {
            if (showErrorMessages) {
                JmriJOptionPane.showMessageDialog(frame, MessageFormat.format(Bundle.getMessage("Error17"), activeTrain.getActiveTrainName()), Bundle.getMessage("ErrorTitle"), 0);
            }
            log.error("Missing Section specification in allocation request from {}", (Object)activeTrain.getActiveTrainName());
            return false;
        }
        if ((seqNumber <= 0 || seqNumber > activeTrain.getTransit().getMaxSequence()) && seqNumber != -99) {
            if (showErrorMessages) {
                JmriJOptionPane.showMessageDialog(frame, MessageFormat.format(Bundle.getMessage("Error19"), "" + seqNumber, activeTrain.getActiveTrainName()), Bundle.getMessage("ErrorTitle"), 0);
            }
            log.error("Out-of-range sequence number *{}* in allocation request", (Object)seqNumber);
            return false;
        }
        if (direction != 4 && direction != 8) {
            if (showErrorMessages) {
                JmriJOptionPane.showMessageDialog(frame, MessageFormat.format(Bundle.getMessage("Error18"), "" + direction, activeTrain.getActiveTrainName()), Bundle.getMessage("ErrorTitle"), 0);
            }
            log.error("Invalid direction '{}' specification in allocation request", (Object)direction);
            return false;
        }
        AllocationRequest ar = this.findAllocationRequestInQueue(section, seqNumber, direction, activeTrain);
        if (ar == null) {
            ar = new AllocationRequest(section, seqNumber, direction, activeTrain);
            if (!firstAllocation && this._AutoAllocate) {
                this.allocationRequests.add(ar);
                if (this._AutoAllocate) {
                    this.queueScanOfAllocationRequests();
                }
            } else if (this._AutoAllocate) {
                this.queueAllocate(ar);
            } else {
                this.allocationRequests.add(ar);
            }
        }
        this.activeTrainsTableModel.fireTableDataChanged();
        this.allocationRequestTableModel.fireTableDataChanged();
        return true;
    }

    protected boolean requestAllocation(ActiveTrain activeTrain, Section section, int direction, int seqNumber, boolean showErrorMessages, JmriJFrame frame) {
        return this.requestAllocation(activeTrain, section, direction, seqNumber, showErrorMessages, frame, false);
    }

    protected AllocationRequest findAllocationRequestInQueue(Section s, int seq, int dir, ActiveTrain at) {
        for (int i = 0; i < this.allocationRequests.size(); ++i) {
            AllocationRequest ar = this.allocationRequests.get(i);
            if (ar.getActiveTrain() != at || ar.getSection() != s || ar.getSectionSeqNumber() != seq || ar.getSectionDirection() != dir) continue;
            return ar;
        }
        return null;
    }

    private void cancelAllocationRequest(int index) {
        AllocationRequest ar = this.allocationRequests.get(index);
        this.allocationRequests.remove(index);
        ar.dispose();
        this.allocationRequestTableModel.fireTableDataChanged();
    }

    private void allocateRequested(int index) {
        AllocationRequest ar = this.allocationRequests.get(index);
        this.allocateSection(ar, null);
    }

    protected void addDelayedTrain(ActiveTrain at, int restartType, Sensor delaySensor, boolean resetSensor) {
        if (restartType == 1) {
            if (!this.delayedTrains.contains(at)) {
                this.delayedTrains.add(at);
            }
        } else if (restartType == 2 && delaySensor != null) {
            at.initializeRestartSensor(delaySensor, resetSensor);
        }
        this.activeTrainsTableModel.fireTableDataChanged();
    }

    public AllocatedSection allocateSection(@Nonnull AllocationRequest ar, Section ns) {
        int i;
        int selectedValue;
        log.trace("{}: Checking Section [{}]", (Object)ar.getActiveTrain().getTrainName(), (Object)(ns != null ? ns.getDisplayName(USERSYS) : "auto"));
        AllocatedSection as = null;
        Section nextSection = null;
        int nextSectionSeqNo = 0;
        ActiveTrain at = ar.getActiveTrain();
        Section s = ar.getSection();
        if (at.reachedRestartPoint()) {
            log.debug("{}: waiting for restart, [{}] not allocated", (Object)at.getTrainName(), (Object)s.getDisplayName(USERSYS));
            return null;
        }
        if (at.holdAllocation()) {
            log.debug("{}: allocation is held, [{}] not allocated", (Object)at.getTrainName(), (Object)s.getDisplayName(USERSYS));
            return null;
        }
        if (s.getState() != 2) {
            log.debug("{}: section [{}] is not free", (Object)at.getTrainName(), (Object)s.getDisplayName(USERSYS));
            return null;
        }
        boolean checkOccupancy = true;
        if (at.getLastAllocatedSection() == null && s.containsBlock(at.getStartBlock())) {
            checkOccupancy = false;
        }
        if (checkOccupancy && s.getOccupancy() == 2) {
            if (this._AutoAllocate) {
                return null;
            }
            selectedValue = JmriJOptionPane.showOptionDialog(this.dispatcherFrame, Bundle.getMessage("Question1"), Bundle.getMessage("WarningTitle"), -1, 3, null, new Object[]{Bundle.getMessage("ButtonOverride"), Bundle.getMessage("ButtonNo")}, Bundle.getMessage("ButtonNo"));
            if (selectedValue != 0) {
                return null;
            }
        }
        if (checkOccupancy && !at.getStarted() && at.getDelayedStart() != 0) {
            if (this._AutoAllocate) {
                return null;
            }
            selectedValue = JmriJOptionPane.showOptionDialog(this.dispatcherFrame, Bundle.getMessage("Question4"), Bundle.getMessage("WarningTitle"), -1, 3, null, new Object[]{Bundle.getMessage("ButtonOverride"), Bundle.getMessage("ButtonNo")}, Bundle.getMessage("ButtonNo"));
            if (selectedValue != 0) {
                return null;
            }
            at.setStarted();
            for (int i2 = this.delayedTrains.size() - 1; i2 >= 0; --i2) {
                if (this.delayedTrains.get(i2) != at) continue;
                this.delayedTrains.remove(i2);
            }
        }
        if (this.checkBlocksNotInAllocatedSection(s, ar) != null) {
            return null;
        }
        if (ns != null) {
            nextSection = ns;
        } else if (!(ar.getSectionSeqNumber() == -99 || at.getNextSectionSeqNumber() != ar.getSectionSeqNumber() || s == at.getEndBlockSection() && ar.getSectionSeqNumber() == at.getEndBlockSectionSequenceNumber() || at.isAllocationReversed() && ar.getSectionSeqNumber() == 1)) {
            int seqNum = ar.getSectionSeqNumber();
            seqNum = at.isAllocationReversed() ? --seqNum : ++seqNum;
            ArrayList<Section> secList = at.getTransit().getSectionListBySeq(seqNum);
            if (secList.size() == 1) {
                nextSection = (Section)secList.get(0);
            } else if (secList.size() > 1) {
                nextSection = this._AutoAllocate ? this.autoChoice(secList, ar, seqNum) : this.dispatcherChoice(secList, ar);
            }
            nextSectionSeqNo = seqNum;
        } else if (at.getReverseAtEnd() && !at.isAllocationReversed() && s == at.getEndBlockSection() && ar.getSectionSeqNumber() == at.getEndBlockSectionSequenceNumber()) {
            at.holdAllocation(true);
            nextSectionSeqNo = at.getEndBlockSectionSequenceNumber() - 1;
            at.setAllocationReversed(true);
            ArrayList<Section> secList = at.getTransit().getSectionListBySeq(nextSectionSeqNo);
            if (secList.size() == 1) {
                nextSection = (Section)secList.get(0);
            } else if (secList.size() > 1) {
                nextSection = this._AutoAllocate ? this.autoChoice(secList, ar, nextSectionSeqNo) : this.dispatcherChoice(secList, ar);
            }
        } else if ((!at.isAllocationReversed() && s == at.getEndBlockSection() && ar.getSectionSeqNumber() == at.getEndBlockSectionSequenceNumber() || at.isAllocationReversed() && ar.getSectionSeqNumber() == 1) && at.getResetWhenDone()) {
            if (at.getDelayedRestart() != 0) {
                log.debug("{}: setting allocation to held", (Object)at.getTrainName());
                at.holdAllocation(true);
            }
            nextSection = at.getSecondAllocatedSection();
            nextSectionSeqNo = 2;
            at.setAllocationReversed(false);
        }
        ArrayList<Section> intermediateSections = new ArrayList<Section>();
        Section mastHeldAtSection = null;
        Object imSecProperty = ar.getSection().getProperty("intermediateSection");
        if (nextSection != null && imSecProperty != null && ((Boolean)imSecProperty).booleanValue()) {
            Object imSecProp;
            TransitSection ts;
            SignalMast endMast;
            Object sectionDirProp;
            String property = "forwardMast";
            if (at.isAllocationReversed()) {
                property = "reverseMast";
            }
            if ((sectionDirProp = ar.getSection().getProperty(property)) != null && (endMast = InstanceManager.getDefault(SignalMastManager.class).getSignalMast(sectionDirProp.toString())) != null && endMast.getHeld()) {
                mastHeldAtSection = ar.getSection();
            }
            ArrayList<TransitSection> tsList = ar.getActiveTrain().getTransit().getTransitSectionList();
            boolean found = false;
            if (at.isAllocationReversed()) {
                for (i = tsList.size() - 1; i > 0; --i) {
                    ts = (TransitSection)tsList.get(i);
                    if (ts.getSection() == ar.getSection() && ts.getSequenceNumber() == ar.getSectionSeqNumber()) {
                        found = true;
                        continue;
                    }
                    if (!found || (imSecProp = ts.getSection().getProperty("intermediateSection")) == null) continue;
                    if (((Boolean)imSecProp).booleanValue()) {
                        intermediateSections.add(ts.getSection());
                        continue;
                    }
                    intermediateSections.add(ts.getSection());
                    break;
                }
            } else {
                for (i = 0; i <= tsList.size() - 1; ++i) {
                    ts = (TransitSection)tsList.get(i);
                    if (ts.getSection() == ar.getSection() && ts.getSequenceNumber() == ar.getSectionSeqNumber()) {
                        found = true;
                        continue;
                    }
                    if (!found || (imSecProp = ts.getSection().getProperty("intermediateSection")) == null) continue;
                    if (((Boolean)imSecProp).booleanValue()) {
                        intermediateSections.add(ts.getSection());
                        continue;
                    }
                    intermediateSections.add(ts.getSection());
                    break;
                }
            }
            boolean intermediatesOccupied = false;
            for (int i3 = 0; i3 < intermediateSections.size() - 1; ++i3) {
                Section se = (Section)intermediateSections.get(i3);
                if (se.getState() == 2 && se.getOccupancy() == 4) {
                    SignalMast endMast2;
                    Object heldProp;
                    Section conflict = this.checkBlocksNotInAllocatedSection(se, null);
                    if (conflict != null) {
                        return null;
                    }
                    if (mastHeldAtSection != null || (heldProp = se.getProperty(property)) == null || (endMast2 = InstanceManager.getDefault(SignalMastManager.class).getSignalMast(heldProp.toString())) == null || !endMast2.getHeld()) continue;
                    mastHeldAtSection = se;
                    continue;
                }
                if (se.getState() != 2 && at.getLastAllocatedSection() != null && se.getState() != at.getLastAllocatedSection().getState()) {
                    return null;
                }
                intermediatesOccupied = true;
                break;
            }
            if (intermediatesOccupied) {
                intermediateSections = new ArrayList();
            }
        }
        List<LayoutTrackExpectedState<LayoutTurnout>> expectedTurnOutStates = null;
        if (this._UseConnectivity && ar.getSectionSeqNumber() != -99) {
            expectedTurnOutStates = this.checkTurnoutStates(s, ar.getSectionSeqNumber(), nextSection, at, at.getLastAllocatedSection());
            if (expectedTurnOutStates == null) {
                return null;
            }
            Section preSec = s;
            Section tmpcur = nextSection;
            int tmpSeqNo = nextSectionSeqNo;
            for (i = 1; i < intermediateSections.size(); ++i) {
                Section se = (Section)intermediateSections.get(i);
                if (preSec == mastHeldAtSection) {
                    log.debug("Section is beyond held mast do not set turnouts {}", (Object)(tmpcur != null ? tmpcur.getDisplayName(USERSYS) : "null"));
                    break;
                }
                if (this.checkTurnoutStates(tmpcur, tmpSeqNo, se, at, preSec) == null) {
                    return null;
                }
                preSec = tmpcur;
                tmpcur = se;
                if (at.isAllocationReversed()) {
                    --tmpSeqNo;
                    continue;
                }
                ++tmpSeqNo;
            }
        }
        if ((as = this.allocateSection(at, s, ar.getSectionSeqNumber(), nextSection, nextSectionSeqNo, ar.getSectionDirection())) != null) {
            as.setAutoTurnoutsResponse(expectedTurnOutStates);
        }
        if (intermediateSections.size() > 1 && mastHeldAtSection != s) {
            int tmpSeqNo;
            Section tmpcur = nextSection;
            int tmpNxtSeqNo = tmpSeqNo = nextSectionSeqNo;
            tmpNxtSeqNo = at.isAllocationReversed() ? --tmpNxtSeqNo : ++tmpNxtSeqNo;
            for (i = 1; i < intermediateSections.size(); ++i) {
                if (tmpcur == mastHeldAtSection) {
                    log.debug("Section is beyond held mast do not allocate any more sections {}", (Object)(tmpcur != null ? tmpcur.getDisplayName(USERSYS) : "null"));
                    break;
                }
                Section se = (Section)intermediateSections.get(i);
                as = this.allocateSection(at, tmpcur, tmpSeqNo, se, tmpNxtSeqNo, ar.getSectionDirection());
                tmpcur = se;
                if (at.isAllocationReversed()) {
                    --tmpSeqNo;
                    --tmpNxtSeqNo;
                    continue;
                }
                ++tmpSeqNo;
                ++tmpNxtSeqNo;
            }
        }
        int ix = -1;
        for (int i4 = 0; i4 < this.allocationRequests.size(); ++i4) {
            if (ar != this.allocationRequests.get(i4)) continue;
            ix = i4;
        }
        if (ix != -1) {
            this.allocationRequests.remove(ix);
        }
        ar.dispose();
        this.allocationRequestTableModel.fireTableDataChanged();
        this.activeTrainsTableModel.fireTableDataChanged();
        if (this.allocatedSectionTableModel != null) {
            this.allocatedSectionTableModel.fireTableDataChanged();
        }
        if (this.extraFrame != null) {
            this.cancelExtraRequested(null);
        }
        if (this._AutoAllocate) {
            this.requestNextAllocation(at);
            this.queueScanOfAllocationRequests();
        }
        return as;
    }

    private AllocatedSection allocateSection(ActiveTrain at, Section s, int seqNum, Section nextSection, int nextSectionSeqNo, int direction) {
        AllocatedSection as = null;
        as = new AllocatedSection(s, at, seqNum, nextSection, nextSectionSeqNo);
        if (this._SupportVSDecoder) {
            as.addPropertyChangeListener(InstanceManager.getDefault(VSDecoderManager.class));
        }
        s.setState(direction);
        if (this.getSignalType() == 1) {
            SignalMast toRelease;
            Section lastOccSec;
            SignalMast toHold;
            Object smProperty;
            String property = "forwardMast";
            if (s.getState() == 8) {
                property = "reverseMast";
            }
            if ((smProperty = s.getProperty(property)) != null && (toHold = InstanceManager.getDefault(SignalMastManager.class).getSignalMast(smProperty.toString())) != null && !toHold.getHeld()) {
                this.heldMasts.add(new HeldMastDetails(toHold, at));
                toHold.setHeld(true);
            }
            if ((lastOccSec = at.getLastAllocatedSection()) != null && (smProperty = lastOccSec.getProperty(property)) != null && (toRelease = InstanceManager.getDefault(SignalMastManager.class).getSignalMast(smProperty.toString())) != null && this.isMastHeldByDispatcher(toRelease, at)) {
                this.removeHeldMast(toRelease, at);
                toRelease.setHeld(false);
            }
        }
        at.addAllocatedSection(as);
        this.allocatedSections.add(as);
        log.debug("{}: Allocated section [{}]", (Object)at.getTrainName(), (Object)as.getSection().getDisplayName(USERSYS));
        return as;
    }

    protected boolean hasTrainAnOccupiedSection(ActiveTrain at) {
        for (AllocatedSection asItem : at.getAllocatedSectionList()) {
            if (asItem.getSection().getOccupancy() != 2) continue;
            return true;
        }
        return false;
    }

    List<LayoutTrackExpectedState<LayoutTurnout>> checkTurnoutStates(Section s, int sSeqNum, Section nextSection, ActiveTrain at, Section prevSection) {
        List<LayoutTrackExpectedState<LayoutTurnout>> turnoutsOK = this._AutoTurnouts || at.getAutoRun() ? this.autoTurnouts.setTurnoutsInSection(s, sSeqNum, nextSection, at, this._TrustKnownTurnouts, prevSection, this._useTurnoutConnectionDelay) : this.autoTurnouts.checkTurnoutsInSection(s, sSeqNum, nextSection, at, prevSection, this._useTurnoutConnectionDelay);
        if (turnoutsOK == null) {
            if (this._AutoAllocate) {
                return turnoutsOK;
            }
            int selectedValue = JmriJOptionPane.showOptionDialog(this.dispatcherFrame, Bundle.getMessage("Question2"), Bundle.getMessage("WarningTitle"), -1, 3, null, new Object[]{Bundle.getMessage("ButtonOverride"), Bundle.getMessage("ButtonNo")}, Bundle.getMessage("ButtonNo"));
            if (selectedValue != 0) {
                return null;
            }
            turnoutsOK = new ArrayList<LayoutTrackExpectedState<LayoutTurnout>>();
        }
        return turnoutsOK;
    }

    public boolean isMastHeldByDispatcher(SignalMast sm, ActiveTrain at) {
        for (HeldMastDetails hmd : this.heldMasts) {
            if (hmd.getMast() != sm || hmd.getActiveTrain() != at) continue;
            return true;
        }
        return false;
    }

    private void removeHeldMast(SignalMast sm, ActiveTrain at) {
        ArrayList<HeldMastDetails> toRemove = new ArrayList<HeldMastDetails>();
        for (HeldMastDetails hmd : this.heldMasts) {
            if (hmd.getActiveTrain() != at) continue;
            if (sm == null) {
                toRemove.add(hmd);
                continue;
            }
            if (sm != hmd.getMast()) continue;
            toRemove.add(hmd);
        }
        for (HeldMastDetails hmd : toRemove) {
            hmd.getMast().setHeld(false);
            this.heldMasts.remove(hmd);
        }
    }

    private List<LevelXing> containedLevelXing(Section s) {
        ArrayList<LevelXing> _levelXingList = new ArrayList<LevelXing>();
        if (s == null) {
            log.error("null argument to 'containsLevelCrossing'");
            return _levelXingList;
        }
        for (LayoutEditor panel : this.editorManager.getAll(LayoutEditor.class)) {
            for (Block blk : s.getBlockList()) {
                for (LevelXing temLevelXing : panel.getConnectivityUtil().getLevelCrossingsThisBlock(blk)) {
                    if (temLevelXing.getLayoutBlockAC().getBlock() != blk && temLevelXing.getLayoutBlockBD().getBlock() != blk) continue;
                    _levelXingList.add(temLevelXing);
                }
            }
        }
        return _levelXingList;
    }

    private List<LayoutTurnout> containedXOver(Section s) {
        ArrayList<LayoutTurnout> _XOverList = new ArrayList<LayoutTurnout>();
        LayoutBlockManager lbm = InstanceManager.getDefault(LayoutBlockManager.class);
        for (LayoutEditor panel : this.editorManager.getAll(LayoutEditor.class)) {
            for (Block blk : s.getBlockList()) {
                LayoutBlock lb = lbm.getLayoutBlock(blk);
                List<LayoutTurnout> turnoutsInBlock = panel.getConnectivityUtil().getAllTurnoutsThisBlock(lb);
                for (LayoutTurnout lt : turnoutsInBlock) {
                    if (!lt.isTurnoutTypeXover() || _XOverList.contains(lt)) continue;
                    _XOverList.add(lt);
                }
            }
        }
        return _XOverList;
    }

    protected boolean checkForBlockInAllocatedSection(Block b, Section ignoreSection) {
        for (AllocatedSection as : this.allocatedSections) {
            if (ignoreSection != null && as.getSection() == ignoreSection || !as.getSection().getBlockList().contains(b)) continue;
            return true;
        }
        return false;
    }

    /*
     * Could not resolve type clashes
     */
    protected Section checkBlocksNotInAllocatedSection(Section s, AllocationRequest ar) {
        ActiveTrain at = null;
        if (ar != null) {
            at = ar.getActiveTrain();
        }
        for (AllocatedSection as : this.allocatedSections) {
            if (as.getSection() == s) continue;
            List<Block> blas = as.getSection().getBlockList();
            List<Object> bls = new ArrayList();
            if (ar != null && ar.getActiveTrain().getAllocatedSectionList().size() == 0) {
                int i;
                boolean j;
                if (ar.getSectionDirection() == 4) {
                    j = false;
                    for (i = 0; i < s.getBlockList().size(); ++i) {
                        if (!j && s.getBlockList().get(i).getState() == 2) {
                            j = true;
                        }
                        if (!j) continue;
                        bls.add(s.getBlockList().get(i));
                    }
                } else {
                    j = false;
                    for (i = s.getBlockList().size() - 1; i >= 0; --i) {
                        if (!j && s.getBlockList().get(i).getState() == 2) {
                            j = true;
                        }
                        if (!j) continue;
                        bls.add(s.getBlockList().get(i));
                    }
                }
            } else {
                bls = s.getBlockList();
                for (LevelXing lx : this.containedLevelXing(s)) {
                    Block bAC = lx.getLayoutBlockAC().getBlock();
                    Block bBD = lx.getLayoutBlockBD().getBlock();
                    if (!bls.contains(bAC)) {
                        bls.add(bAC);
                    }
                    if (bls.contains(bBD)) continue;
                    bls.add(bBD);
                }
                for (LayoutTurnout lx : this.containedXOver(s)) {
                    if (!(lx instanceof LayoutDoubleXOver)) continue;
                    HashSet<Block> bhs = new HashSet<Block>(4);
                    bhs.add(lx.getLayoutBlock().getBlock());
                    bhs.add(lx.getLayoutBlockB().getBlock());
                    bhs.add(lx.getLayoutBlockC().getBlock());
                    bhs.add(lx.getLayoutBlockD().getBlock());
                    if (bhs.size() != 4) continue;
                    for (Block b : bhs) {
                        if (!this.checkBlockInAnyAllocatedSection(b, at) && b.getState() != 2 || lx.getTurnout().getKnownState() == 2) continue;
                        if (bls.contains(lx.getLayoutBlock().getBlock()) || bls.contains(lx.getLayoutBlockC().getBlock())) {
                            bls.add(lx.getLayoutBlockB().getBlock());
                            bls.add(lx.getLayoutBlockD().getBlock());
                            continue;
                        }
                        bls.add(lx.getLayoutBlock().getBlock());
                        bls.add(lx.getLayoutBlockC().getBlock());
                    }
                }
            }
            block6: for (Block b : bls) {
                if (!blas.contains(b)) continue;
                if (as.getActiveTrain().getTrainDetection() == ActiveTrain.TrainDetection.TRAINDETECTION_HEADONLY) {
                    return as.getSection();
                }
                if (as.getActiveTrain().getTrainDetection() == ActiveTrain.TrainDetection.TRAINDETECTION_HEADANDTAIL) {
                    for (AllocatedSection tas : this.allocatedSections) {
                        if (tas.getActiveTrain() != as.getActiveTrain() || !tas.getExited() || tas.getSection().getOccupancy() != 2) continue;
                        return as.getSection();
                    }
                } else if (at != as.getActiveTrain() && as.getActiveTrain().getTrainDetection() != ActiveTrain.TrainDetection.TRAINDETECTION_WHOLETRAIN) {
                    return as.getSection();
                }
                if (as.getSection().getOccupancy() == 2) {
                    if (as.getSection().getState() == 4) {
                        for (int i = 0; i < blas.size(); ++i) {
                            if (blas.get(i).getState() == 2) {
                                if (ar != null) {
                                    ar.setWaitingOnBlock(b);
                                }
                                return as.getSection();
                            }
                            if (blas.get(i) == b) continue block6;
                        }
                        continue;
                    }
                    for (int i = blas.size() - 1; i >= 0; --i) {
                        if (blas.get(i).getState() == 2) {
                            if (ar != null) {
                                ar.setWaitingOnBlock(b);
                            }
                            return as.getSection();
                        }
                        if (blas.get(i) == b) continue block6;
                    }
                    continue;
                }
                if (as.getSection().getOccupancy() == 2) continue;
                if (ar != null) {
                    ar.setWaitingOnBlock(b);
                }
                return as.getSection();
            }
        }
        return null;
    }

    private boolean checkBlockInAnyAllocatedSection(Block b, ActiveTrain at) {
        for (AllocatedSection as : this.allocatedSections) {
            if (as.getActiveTrain() == at || !as.getSection().getBlockList().contains(b)) continue;
            return true;
        }
        return false;
    }

    private Section autoChoice(List<Section> sList, AllocationRequest ar, int sectionSeqNo) {
        Section tSection = this.autoAllocate.autoNextSectionChoice(sList, ar, sectionSeqNo);
        if (tSection != null) {
            return tSection;
        }
        return this.dispatcherChoice(sList, ar);
    }

    private Section dispatcherChoice(List<Section> sList, AllocationRequest ar) {
        Object[] choices = new Object[sList.size()];
        for (int i = 0; i < sList.size(); ++i) {
            Section s = sList.get(i);
            String txt = s.getDisplayName();
            choices[i] = txt;
        }
        Object secName = JmriJOptionPane.showInputDialog(this.dispatcherFrame, Bundle.getMessage("ExplainChoice", ar.getSectionName()), Bundle.getMessage("ChoiceFrameTitle"), 3, null, choices, choices[0]);
        if (secName == null) {
            JmriJOptionPane.showMessageDialog(this.dispatcherFrame, Bundle.getMessage("WarnCancel"));
            return sList.get(0);
        }
        for (int j = 0; j < sList.size(); ++j) {
            if (!secName.equals(choices[j])) continue;
            return sList.get(j);
        }
        return sList.get(0);
    }

    private void requestNextAllocation(ActiveTrain at) {
        Section next = at.getNextSectionToAllocate();
        if (next == null) {
            return;
        }
        int seqNext = at.getNextSectionSeqNumber();
        int dirNext = at.getAllocationDirectionFromSectionAndSeq(next, seqNext);
        this.requestAllocation(at, next, dirNext, seqNext, true, this.dispatcherFrame);
    }

    protected void checkAutoRelease() {
        if (this._AutoRelease) {
            boolean foundOne = true;
            while (this.allocatedSections.size() > 0 && foundOne) {
                try {
                    foundOne = false;
                    AllocatedSection as = null;
                    for (int i = 0; i < this.allocatedSections.size() && !foundOne; ++i) {
                        as = this.allocatedSections.get(i);
                        if (!as.getExited() || as.getSection().getOccupancy() == 2 || as.getAllocationNumber() == -1) continue;
                        foundOne = true;
                        for (int j = 0; j < this.allocatedSections.size() && foundOne; ++j) {
                            AllocatedSection asx;
                            if (j == i || (asx = this.allocatedSections.get(j)).getActiveTrain() != as.getActiveTrain() || asx.getAllocationNumber() == -1 || asx.getAllocationNumber() >= as.getAllocationNumber()) continue;
                            foundOne = false;
                        }
                        if (foundOne && !this.hasTrainAnOccupiedSection(as.getActiveTrain())) {
                            log.warn("[{}]:CheckAutoRelease release section [{}] failed, train has no occupied section", (Object)as.getActiveTrain().getActiveTrainName(), (Object)as.getSectionName());
                            foundOne = false;
                        }
                        if (foundOne) {
                            int allocatedCount = 0;
                            for (int j = 0; j < this.allocatedSections.size(); ++j) {
                                AllocatedSection asx = this.allocatedSections.get(j);
                                if (asx.getActiveTrain() != as.getActiveTrain()) continue;
                                ++allocatedCount;
                            }
                            if (allocatedCount == 1) {
                                foundOne = false;
                            }
                        }
                        if (!foundOne) continue;
                        ActiveTrain at = as.getActiveTrain();
                        Section ns = as.getNextSection();
                        AllocatedSection nas = null;
                        for (int k = 0; k < this.allocatedSections.size() && nas == null; ++k) {
                            if (this.allocatedSections.get(k).getSection() != ns) continue;
                            nas = this.allocatedSections.get(k);
                        }
                        if (nas == null || at.getStatus() == 8 || at.getStatus() == 32 || at.getStatus() == 16 || at.getMode() == 4) {
                            foundOne = false;
                            if (nas != null && at.reachedRestartPoint()) {
                                foundOne = true;
                            }
                        } else if (nas.getActiveTrain() != as.getActiveTrain() || !nas.getEntered()) {
                            foundOne = false;
                        }
                        if (!(foundOne = this.sectionNotRequiredByHeadOnly(foundOne, at, as))) continue;
                        log.debug("{}: releasing section [{}]", (Object)at.getTrainName(), (Object)as.getSection().getDisplayName(USERSYS));
                        this.doReleaseAllocatedSection(as, false);
                    }
                }
                catch (RuntimeException e) {
                    log.warn("checkAutoRelease failed  - maybe the AllocatedSection was removed due to a terminating train? {}", (Object)e.toString());
                }
            }
        }
        if (this._AutoAllocate) {
            this.queueScanOfAllocationRequests();
        }
    }

    private boolean sectionNotRequiredByHeadOnly(boolean foundOne, ActiveTrain at, AllocatedSection as) {
        if (at.getAutoActiveTrain() != null && at.getTrainDetection() == ActiveTrain.TrainDetection.TRAINDETECTION_HEADONLY) {
            long allocatedLengthMM = 0L;
            for (AllocatedSection tas : at.getAllocatedSectionList()) {
                if (tas.getSection().getOccupancy() == 2) {
                    if (at.getAutoActiveTrain().getAutoEngineer().isStopped() && (at.getAutoActiveTrain().getStopBySpeedProfile() || tas.getSection().getForwardStoppingSensor() != null || tas.getSection().getReverseStoppingSensor() != null)) {
                        allocatedLengthMM += (long)tas.getSection().getActualLength();
                        log.debug("{}: sectionNotRequiredByHeadOnly Stopping at Secion [{}] including in length.", (Object)at.getTrainName(), (Object)tas.getSection().getDisplayName());
                        break;
                    }
                    log.debug("{}: sectionNotRequiredByHeadOnly Stopping at Secion [{}] excluding from length.", (Object)at.getTrainName(), (Object)tas.getSection().getDisplayName());
                    break;
                }
                if (!tas.getExited()) continue;
                allocatedLengthMM += (long)tas.getSection().getActualLength();
            }
            long trainLengthMM = at.getAutoActiveTrain().getMaxTrainLengthMM();
            long releaseLengthMM = as.getSection().getActualLength();
            log.debug("[{}]:Release Section [{}] by Length allocated [{}] release [{}] train [{}]", new Object[]{at.getTrainName(), as.getSectionName(), allocatedLengthMM, releaseLengthMM, trainLengthMM});
            if (allocatedLengthMM - releaseLengthMM < trainLengthMM) {
                return false;
            }
        }
        return true;
    }

    public void releaseAllocatedSection(AllocatedSection as, boolean terminatingTrain) {
        if (!terminatingTrain && !this.hasTrainAnOccupiedSection(as.getActiveTrain())) {
            log.warn("[{}]: releaseAllocatedSection release section [{}] failed train has no occupied section", (Object)as.getActiveTrain().getActiveTrainName(), (Object)as.getSectionName());
            return;
        }
        if (this._AutoAllocate) {
            this.autoAllocate.scanAllocationRequests(new TaskAllocateRelease(TaskAllocateRelease.TaskAction.RELEASE_ONE, as, terminatingTrain));
        } else {
            this.doReleaseAllocatedSection(as, terminatingTrain);
        }
    }

    protected void doReleaseAllocatedSection(AllocatedSection as, boolean terminatingTrain) {
        int selectedValue;
        if (!terminatingTrain && as.getSection().getOccupancy() == 2 && (selectedValue = JmriJOptionPane.showOptionDialog(this.dispatcherFrame, MessageFormat.format(Bundle.getMessage("Question5"), as.getSectionName()), Bundle.getMessage("WarningTitle"), -1, 3, null, new Object[]{Bundle.getMessage("ButtonRelease"), Bundle.getMessage("ButtonNo")}, Bundle.getMessage("ButtonNo"))) != 0) {
            return;
        }
        for (int i = this.allocatedSections.size(); i > 0; --i) {
            if (as != this.allocatedSections.get(i - 1)) continue;
            this.allocatedSections.remove(i - 1);
        }
        as.getSection().setState(2);
        as.getActiveTrain().removeAllocatedSection(as);
        as.dispose();
        if (this.allocatedSectionTableModel != null) {
            this.allocatedSectionTableModel.fireTableDataChanged();
        }
        this.allocationRequestTableModel.fireTableDataChanged();
        this.activeTrainsTableModel.fireTableDataChanged();
        if (this._AutoAllocate) {
            this.queueScanOfAllocationRequests();
        }
    }

    public void sectionOccupancyChanged() {
        this.queueReleaseOfCompletedAllocations();
        if (this.allocatedSectionTableModel != null) {
            this.allocatedSectionTableModel.fireTableDataChanged();
        }
        this.allocationRequestTableModel.fireTableDataChanged();
    }

    protected void newFastClockMinute() {
        for (int i = this.delayedTrains.size() - 1; i >= 0; --i) {
            ActiveTrain at = this.delayedTrains.get(i);
            if (!at.getStarted() && at.getDelayedStart() != 0) {
                if (at.getDelayedStart() != 1 || !this.isFastClockTimeGE(at.getDepartureTimeHr(), at.getDepartureTimeMin())) continue;
                at.setStarted();
                this.delayedTrains.remove(i);
                continue;
            }
            if (!at.getStarted() || at.getStatus() != 16 || !at.reachedRestartPoint() || !this.isFastClockTimeGE(at.getRestartDepartHr(), at.getRestartDepartMin())) continue;
            at.restart();
            this.delayedTrains.remove(i);
        }
        if (this._AutoAllocate) {
            this.queueScanOfAllocationRequests();
        }
    }

    public boolean isFastClockTimeGE(int hr, int min) {
        Calendar now = Calendar.getInstance();
        now.setTime(this.fastClock.getTime());
        int nowHours = now.get(11);
        int nowMinutes = now.get(12);
        return nowHours * 60 + nowMinutes == hr * 60 + min;
    }

    protected LayoutEditor getLayoutEditor() {
        return this._LE;
    }

    protected void setLayoutEditor(LayoutEditor editor) {
        this._LE = editor;
    }

    protected boolean getUseConnectivity() {
        return this._UseConnectivity;
    }

    protected void setUseConnectivity(boolean set) {
        this._UseConnectivity = set;
    }

    protected void setSignalType(int type) {
        this._SignalType = type;
    }

    protected int getSignalType() {
        return this._SignalType;
    }

    protected String getSignalTypeString() {
        switch (this._SignalType) {
            case 0: {
                return Bundle.getMessage("SignalType1");
            }
            case 1: {
                return Bundle.getMessage("SignalType2");
            }
            case 2: {
                return Bundle.getMessage("SignalType3");
            }
        }
        return "Unknown";
    }

    protected void setStoppingSpeedName(String speedName) {
        this._StoppingSpeedName = speedName;
    }

    protected String getStoppingSpeedName() {
        return this._StoppingSpeedName;
    }

    protected float getMaximumLineSpeed() {
        return this.maximumLineSpeed;
    }

    protected void setTrainsFrom(TrainsFrom value) {
        this._TrainsFrom = value;
    }

    protected TrainsFrom getTrainsFrom() {
        return this._TrainsFrom;
    }

    protected boolean getAutoAllocate() {
        return this._AutoAllocate;
    }

    protected boolean getAutoRelease() {
        return this._AutoRelease;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void stopStartAutoAllocateRelease() {
        if (!this._AutoAllocate && !this._AutoRelease) {
            if (this.autoAllocate == null) return;
            this.autoAllocate.setAbort();
            this.autoAllocate = null;
            return;
        }
        if (this.editorManager.getAll(LayoutEditor.class).size() > 0) {
            if (this.autoAllocate != null) return;
            this.autoAllocate = new AutoAllocate(this, this.allocationRequests);
            this.autoAllocateThread = ThreadingUtil.newThread(this.autoAllocate, "Auto Allocator ");
            this.autoAllocateThread.start();
            return;
        }
        JmriJOptionPane.showMessageDialog(this.dispatcherFrame, Bundle.getMessage("Error39"), Bundle.getMessage("MessageTitle"), 1);
        this._AutoAllocate = false;
        if (this.autoAllocateBox == null) return;
        this.autoAllocateBox.setSelected(this._AutoAllocate);
    }

    protected void setAutoAllocate(boolean set) {
        this._AutoAllocate = set;
        this.stopStartAutoAllocateRelease();
        if (this.autoAllocateBox != null) {
            this.autoAllocateBox.setSelected(this._AutoAllocate);
        }
    }

    protected void setAutoRelease(boolean set) {
        this._AutoRelease = set;
        this.stopStartAutoAllocateRelease();
        if (this.autoReleaseBox != null) {
            this.autoReleaseBox.setSelected(this._AutoAllocate);
        }
    }

    protected AutoTurnouts getAutoTurnoutsHelper() {
        return this.autoTurnouts;
    }

    protected boolean getAutoTurnouts() {
        return this._AutoTurnouts;
    }

    protected void setAutoTurnouts(boolean set) {
        this._AutoTurnouts = set;
    }

    protected boolean getTrustKnownTurnouts() {
        return this._TrustKnownTurnouts;
    }

    protected void setTrustKnownTurnouts(boolean set) {
        this._TrustKnownTurnouts = set;
    }

    protected boolean getUseTurnoutConnectionDelay() {
        return this._useTurnoutConnectionDelay;
    }

    protected void setUseTurnoutConnectionDelay(boolean set) {
        this._useTurnoutConnectionDelay = set;
    }

    protected int getMinThrottleInterval() {
        return this._MinThrottleInterval;
    }

    protected void setMinThrottleInterval(int set) {
        this._MinThrottleInterval = set;
    }

    protected int getFullRampTime() {
        return this._FullRampTime;
    }

    protected void setFullRampTime(int set) {
        this._FullRampTime = set;
    }

    protected boolean getHasOccupancyDetection() {
        return this._HasOccupancyDetection;
    }

    protected void setHasOccupancyDetection(boolean set) {
        this._HasOccupancyDetection = set;
    }

    protected boolean getSetSSLDirectionalSensors() {
        return this._SetSSLDirectionalSensors;
    }

    protected void setSetSSLDirectionalSensors(boolean set) {
        this._SetSSLDirectionalSensors = set;
    }

    protected boolean getUseScaleMeters() {
        return this._UseScaleMeters;
    }

    protected void setUseScaleMeters(boolean set) {
        this._UseScaleMeters = set;
    }

    protected boolean getShortActiveTrainNames() {
        return this._ShortActiveTrainNames;
    }

    protected void setShortActiveTrainNames(boolean set) {
        this._ShortActiveTrainNames = set;
        if (this.allocatedSectionTableModel != null) {
            this.allocatedSectionTableModel.fireTableDataChanged();
        }
        if (this.allocationRequestTableModel != null) {
            this.allocationRequestTableModel.fireTableDataChanged();
        }
    }

    protected boolean getShortNameInBlock() {
        return this._ShortNameInBlock;
    }

    protected void setShortNameInBlock(boolean set) {
        this._ShortNameInBlock = set;
    }

    protected boolean getRosterEntryInBlock() {
        return this._RosterEntryInBlock;
    }

    protected void setRosterEntryInBlock(boolean set) {
        this._RosterEntryInBlock = set;
    }

    protected boolean getExtraColorForAllocated() {
        return this._ExtraColorForAllocated;
    }

    protected void setExtraColorForAllocated(boolean set) {
        this._ExtraColorForAllocated = set;
    }

    protected boolean getNameInAllocatedBlock() {
        return this._NameInAllocatedBlock;
    }

    protected void setNameInAllocatedBlock(boolean set) {
        this._NameInAllocatedBlock = set;
    }

    protected Scale getScale() {
        return this._LayoutScale;
    }

    protected void setScale(Scale sc) {
        this._LayoutScale = sc;
    }

    public List<ActiveTrain> getActiveTrainsList() {
        return this.activeTrainsList;
    }

    protected List<AllocatedSection> getAllocatedSectionsList() {
        return this.allocatedSections;
    }

    public ActiveTrain getActiveTrainForRoster(RosterEntry re) {
        if (this._TrainsFrom != TrainsFrom.TRAINSFROMROSTER) {
            return null;
        }
        for (ActiveTrain at : this.activeTrainsList) {
            if (!at.getRosterEntry().equals(re)) continue;
            return at;
        }
        return null;
    }

    protected boolean getSupportVSDecoder() {
        return this._SupportVSDecoder;
    }

    protected void setSupportVSDecoder(boolean set) {
        this._SupportVSDecoder = set;
    }

    public void newTrainDone(ActiveTrain at) {
        if (at != null) {
            if (at.getDelayedStart() != 0 && !at.getStarted()) {
                this.delayedTrains.add(at);
                this.fastClockWarn(true);
            } else if (at.getDelayedRestart() == 1) {
                this.fastClockWarn(false);
            }
        }
        if (this.atFrame != null) {
            this.atFrame.setVisible(false);
            this.atFrame.dispose();
            this.atFrame = null;
        }
        this.newTrainActive = false;
    }

    protected void removeDelayedTrain(ActiveTrain at) {
        this.delayedTrains.remove(at);
    }

    private void fastClockWarn(boolean wMess) {
        if (this.fastClockSensor.getState() == 2) {
            return;
        }
        String mess = "";
        mess = wMess ? Bundle.getMessage("FastClockWarn") : Bundle.getMessage("FastClockWarn2");
        int selectedValue = JmriJOptionPane.showOptionDialog(this.dispatcherFrame, mess, Bundle.getMessage("WarningTitle"), -1, 3, null, new Object[]{Bundle.getMessage("ButtonYesStart"), Bundle.getMessage("ButtonNo")}, Bundle.getMessage("ButtonNo"));
        if (selectedValue == 0) {
            try {
                this.fastClockSensor.setState(2);
            }
            catch (JmriException reason) {
                log.error("Exception when setting fast clock sensor");
            }
        }
    }

    public AutoTrainsFrame getAutoTrainsFrame() {
        return this._autoTrainsFrame;
    }

    protected void showTableHeaderPopup(JmriMouseEvent e, JTable table) {
        JPopupMenu popupMenu = new JPopupMenu();
        XTableColumnModel tcm = (XTableColumnModel)table.getColumnModel();
        for (int i = 0; i < tcm.getColumnCount(false); ++i) {
            TableColumn tc = tcm.getColumnByModelIndex(i);
            String columnName = table.getModel().getColumnName(i);
            if (columnName == null || columnName.equals("")) continue;
            JCheckBoxMenuItem menuItem = new JCheckBoxMenuItem(table.getModel().getColumnName(i), tcm.isColumnVisible(tc));
            menuItem.addActionListener(new HeaderActionListener(tc, tcm));
            popupMenu.add(menuItem);
        }
        popupMenu.show(e.getComponent(), e.getX(), e.getY());
    }

    protected void addMouseListenerToHeader(JTable table) {
        TableHeaderListener mouseHeaderListener = new TableHeaderListener(table);
        table.getTableHeader().addMouseListener(JmriMouseListener.adapt(mouseHeaderListener));
    }

    class TableHeaderListener
    extends JmriMouseAdapter {
        JTable table;

        TableHeaderListener(JTable tbl) {
            this.table = tbl;
        }

        @Override
        public void mousePressed(JmriMouseEvent e) {
            if (e.isPopupTrigger()) {
                DispatcherFrame.this.showTableHeaderPopup(e, this.table);
            }
        }

        @Override
        public void mouseReleased(JmriMouseEvent e) {
            if (e.isPopupTrigger()) {
                DispatcherFrame.this.showTableHeaderPopup(e, this.table);
            }
        }

        @Override
        public void mouseClicked(JmriMouseEvent e) {
            if (e.isPopupTrigger()) {
                DispatcherFrame.this.showTableHeaderPopup(e, this.table);
            }
        }
    }

    protected static class HeaderActionListener
    implements ActionListener {
        TableColumn tc;
        XTableColumnModel tcm;

        HeaderActionListener(TableColumn tc, XTableColumnModel tcm) {
            this.tc = tc;
            this.tcm = tcm;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JCheckBoxMenuItem check = (JCheckBoxMenuItem)e.getSource();
            if (!check.isSelected() && this.tcm.getColumnCount(true) == 1) {
                return;
            }
            this.tcm.setColumnVisible(this.tc, check.isSelected());
        }
    }

    public class AllocatedSectionTableModel
    extends AbstractTableModel
    implements PropertyChangeListener {
        public static final int TRANSIT_COLUMN = 0;
        public static final int TRANSIT_COLUMN_U = 1;
        public static final int TRAIN_COLUMN = 2;
        public static final int SECTION_COLUMN = 3;
        public static final int SECTION_COLUMN_U = 4;
        public static final int OCCUPANCY_COLUMN = 5;
        public static final int USESTATUS_COLUMN = 6;
        public static final int RELEASEBUTTON_COLUMN = 7;
        public static final int MAX_COLUMN = 7;

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            if (e.getPropertyName().equals("length")) {
                this.fireTableDataChanged();
            }
        }

        @Override
        public Class<?> getColumnClass(int c) {
            if (c == 7) {
                return JButton.class;
            }
            return String.class;
        }

        @Override
        public int getColumnCount() {
            return 8;
        }

        @Override
        public int getRowCount() {
            return DispatcherFrame.this.allocatedSections.size();
        }

        @Override
        public boolean isCellEditable(int r, int c) {
            return c == 7;
        }

        @Override
        public String getColumnName(int col) {
            switch (col) {
                case 0: {
                    return Bundle.getMessage("TransitColumnSysTitle");
                }
                case 1: {
                    return Bundle.getMessage("TransitColumnTitle");
                }
                case 2: {
                    return Bundle.getMessage("TrainColumnTitle");
                }
                case 3: {
                    return Bundle.getMessage("AllocatedSectionColumnSysTitle");
                }
                case 4: {
                    return Bundle.getMessage("AllocatedSectionColumnTitle");
                }
                case 5: {
                    return Bundle.getMessage("OccupancyColumnTitle");
                }
                case 6: {
                    return Bundle.getMessage("UseStatusColumnTitle");
                }
                case 7: {
                    return Bundle.getMessage("ReleaseButton");
                }
            }
            return "";
        }

        public int getPreferredWidth(int col) {
            switch (col) {
                case 0: 
                case 1: 
                case 2: {
                    return new JTextField((int)17).getPreferredSize().width;
                }
                case 3: 
                case 4: {
                    return new JTextField((int)25).getPreferredSize().width;
                }
                case 5: {
                    return new JTextField((int)10).getPreferredSize().width;
                }
                case 6: {
                    return new JTextField((int)15).getPreferredSize().width;
                }
                case 7: {
                    return new JTextField((int)12).getPreferredSize().width;
                }
            }
            return new JTextField((int)5).getPreferredSize().width;
        }

        @Override
        public Object getValueAt(int r, int c) {
            int rx = r;
            if (rx >= DispatcherFrame.this.allocatedSections.size()) {
                return null;
            }
            AllocatedSection as = DispatcherFrame.this.allocatedSections.get(rx);
            switch (c) {
                case 0: {
                    return as.getActiveTrain().getTransit().getSystemName();
                }
                case 1: {
                    if (as.getActiveTrain().getTransit() != null && as.getActiveTrain().getTransit().getUserName() != null) {
                        return as.getActiveTrain().getTransit().getUserName();
                    }
                    return "";
                }
                case 2: {
                    return as.getActiveTrain().getTrainName();
                }
                case 3: {
                    if (as.getSection() != null) {
                        return as.getSection().getSystemName();
                    }
                    return "<none>";
                }
                case 4: {
                    if (as.getSection() != null && as.getSection().getUserName() != null) {
                        return as.getSection().getUserName();
                    }
                    return "<none>";
                }
                case 5: {
                    if (!DispatcherFrame.this._HasOccupancyDetection) {
                        return Bundle.getMessage("UNKNOWN");
                    }
                    if (as.getSection().getOccupancy() == 2) {
                        return Bundle.getMessage("OCCUPIED");
                    }
                    return Bundle.getMessage("UNOCCUPIED");
                }
                case 6: {
                    if (!as.getEntered()) {
                        return Bundle.getMessage("NotEntered");
                    }
                    if (as.getExited()) {
                        return Bundle.getMessage("Exited");
                    }
                    return Bundle.getMessage("Entered");
                }
                case 7: {
                    return Bundle.getMessage("ReleaseButton");
                }
            }
            return " ";
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            if (col == 7) {
                DispatcherFrame.this.releaseAllocatedSectionFromTable(row);
            }
        }
    }

    public class AllocationRequestTableModel
    extends AbstractTableModel
    implements PropertyChangeListener {
        public static final int TRANSIT_COLUMN = 0;
        public static final int TRANSIT_COLUMN_U = 1;
        public static final int TRAIN_COLUMN = 2;
        public static final int PRIORITY_COLUMN = 3;
        public static final int TRAINTYPE_COLUMN = 4;
        public static final int SECTION_COLUMN = 5;
        public static final int SECTION_COLUMN_U = 6;
        public static final int STATUS_COLUMN = 7;
        public static final int OCCUPANCY_COLUMN = 8;
        public static final int SECTIONLENGTH_COLUMN = 9;
        public static final int ALLOCATEBUTTON_COLUMN = 10;
        public static final int CANCELBUTTON_COLUMN = 11;
        public static final int MAX_COLUMN = 11;

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            if (e.getPropertyName().equals("length")) {
                this.fireTableDataChanged();
            }
        }

        @Override
        public Class<?> getColumnClass(int c) {
            if (c == 11) {
                return JButton.class;
            }
            if (c == 10) {
                return JButton.class;
            }
            return String.class;
        }

        @Override
        public int getColumnCount() {
            return 12;
        }

        @Override
        public int getRowCount() {
            return DispatcherFrame.this.allocationRequests.size();
        }

        @Override
        public boolean isCellEditable(int r, int c) {
            if (c == 11) {
                return true;
            }
            return c == 10;
        }

        @Override
        public String getColumnName(int col) {
            switch (col) {
                case 0: {
                    return Bundle.getMessage("TransitColumnSysTitle");
                }
                case 1: {
                    return Bundle.getMessage("TransitColumnTitle");
                }
                case 2: {
                    return Bundle.getMessage("TrainColumnTitle");
                }
                case 3: {
                    return Bundle.getMessage("PriorityLabel");
                }
                case 4: {
                    return Bundle.getMessage("TrainTypeColumnTitle");
                }
                case 5: {
                    return Bundle.getMessage("SectionColumnSysTitle");
                }
                case 6: {
                    return Bundle.getMessage("SectionColumnTitle");
                }
                case 7: {
                    return Bundle.getMessage("StatusColumnTitle");
                }
                case 8: {
                    return Bundle.getMessage("OccupancyColumnTitle");
                }
                case 9: {
                    return Bundle.getMessage("SectionLengthColumnTitle");
                }
                case 10: {
                    return Bundle.getMessage("AllocateButton");
                }
                case 11: {
                    return Bundle.getMessage("ButtonCancel");
                }
            }
            return "";
        }

        public int getPreferredWidth(int col) {
            switch (col) {
                case 0: 
                case 1: 
                case 2: {
                    return new JTextField((int)17).getPreferredSize().width;
                }
                case 3: {
                    return new JTextField((int)8).getPreferredSize().width;
                }
                case 4: {
                    return new JTextField((int)15).getPreferredSize().width;
                }
                case 5: {
                    return new JTextField((int)25).getPreferredSize().width;
                }
                case 7: {
                    return new JTextField((int)15).getPreferredSize().width;
                }
                case 8: {
                    return new JTextField((int)10).getPreferredSize().width;
                }
                case 9: {
                    return new JTextField((int)8).getPreferredSize().width;
                }
                case 10: {
                    return new JTextField((int)12).getPreferredSize().width;
                }
                case 11: {
                    return new JTextField((int)10).getPreferredSize().width;
                }
            }
            return new JTextField((int)5).getPreferredSize().width;
        }

        @Override
        public Object getValueAt(int r, int c) {
            int rx = r;
            if (rx >= DispatcherFrame.this.allocationRequests.size()) {
                return null;
            }
            AllocationRequest ar = DispatcherFrame.this.allocationRequests.get(rx);
            switch (c) {
                case 0: {
                    return ar.getActiveTrain().getTransit().getSystemName();
                }
                case 1: {
                    if (ar.getActiveTrain().getTransit() != null && ar.getActiveTrain().getTransit().getUserName() != null) {
                        return ar.getActiveTrain().getTransit().getUserName();
                    }
                    return "";
                }
                case 2: {
                    return ar.getActiveTrain().getTrainName();
                }
                case 3: {
                    return "   " + ar.getActiveTrain().getPriority();
                }
                case 4: {
                    return ar.getActiveTrain().getTrainTypeText();
                }
                case 5: {
                    if (ar.getSection() != null) {
                        return ar.getSection().getSystemName();
                    }
                    return "<none>";
                }
                case 6: {
                    if (ar.getSection() != null && ar.getSection().getUserName() != null) {
                        return ar.getSection().getUserName();
                    }
                    return "<none>";
                }
                case 7: {
                    if (ar.getSection().getState() == 2) {
                        return Bundle.getMessage("FREE");
                    }
                    return Bundle.getMessage("ALLOCATED");
                }
                case 8: {
                    if (!DispatcherFrame.this._HasOccupancyDetection) {
                        return Bundle.getMessage("UNKNOWN");
                    }
                    if (ar.getSection().getOccupancy() == 2) {
                        return Bundle.getMessage("OCCUPIED");
                    }
                    return Bundle.getMessage("UNOCCUPIED");
                }
                case 9: {
                    return "  " + ar.getSection().getLengthI(DispatcherFrame.this._UseScaleMeters, DispatcherFrame.this._LayoutScale);
                }
                case 10: {
                    return Bundle.getMessage("AllocateButton");
                }
                case 11: {
                    return Bundle.getMessage("ButtonCancel");
                }
            }
            return " ";
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            if (col == 10) {
                DispatcherFrame.this.allocateRequested(row);
            }
            if (col == 11) {
                DispatcherFrame.this.cancelAllocationRequest(row);
            }
        }
    }

    public class ActiveTrainsTableModel
    extends AbstractTableModel
    implements PropertyChangeListener {
        public static final int TRANSIT_COLUMN = 0;
        public static final int TRANSIT_COLUMN_U = 1;
        public static final int TRAIN_COLUMN = 2;
        public static final int TYPE_COLUMN = 3;
        public static final int STATUS_COLUMN = 4;
        public static final int MODE_COLUMN = 5;
        public static final int ALLOCATED_COLUMN = 6;
        public static final int ALLOCATED_COLUMN_U = 7;
        public static final int NEXTSECTION_COLUMN = 8;
        public static final int NEXTSECTION_COLUMN_U = 9;
        public static final int ALLOCATEBUTTON_COLUMN = 10;
        public static final int TERMINATEBUTTON_COLUMN = 11;
        public static final int RESTARTCHECKBOX_COLUMN = 12;
        public static final int ISAUTO_COLUMN = 13;
        public static final int CURRENTSIGNAL_COLUMN = 14;
        public static final int CURRENTSIGNAL_COLUMN_U = 15;
        public static final int DCC_ADDRESS = 16;
        public static final int MAX_COLUMN = 16;

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            if (e.getPropertyName().equals("length")) {
                this.fireTableDataChanged();
            }
        }

        @Override
        public Class<?> getColumnClass(int col) {
            switch (col) {
                case 10: 
                case 11: {
                    return JButton.class;
                }
                case 12: 
                case 13: {
                    return Boolean.class;
                }
            }
            return String.class;
        }

        @Override
        public int getColumnCount() {
            return 17;
        }

        @Override
        public int getRowCount() {
            return DispatcherFrame.this.activeTrainsList.size();
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            switch (col) {
                case 10: 
                case 11: 
                case 12: {
                    return true;
                }
            }
            return false;
        }

        @Override
        public String getColumnName(int col) {
            switch (col) {
                case 0: {
                    return Bundle.getMessage("TransitColumnSysTitle");
                }
                case 1: {
                    return Bundle.getMessage("TransitColumnTitle");
                }
                case 2: {
                    return Bundle.getMessage("TrainColumnTitle");
                }
                case 3: {
                    return Bundle.getMessage("TrainTypeColumnTitle");
                }
                case 4: {
                    return Bundle.getMessage("TrainStatusColumnTitle");
                }
                case 5: {
                    return Bundle.getMessage("TrainModeColumnTitle");
                }
                case 6: {
                    return Bundle.getMessage("AllocatedSectionColumnSysTitle");
                }
                case 7: {
                    return Bundle.getMessage("AllocatedSectionColumnTitle");
                }
                case 8: {
                    return Bundle.getMessage("NextSectionColumnSysTitle");
                }
                case 9: {
                    return Bundle.getMessage("NextSectionColumnTitle");
                }
                case 12: {
                    return Bundle.getMessage("AutoRestartColumnTitle");
                }
                case 10: {
                    return Bundle.getMessage("AllocateButton");
                }
                case 11: {
                    return Bundle.getMessage("TerminateTrain");
                }
                case 13: {
                    return Bundle.getMessage("AutoColumnTitle");
                }
                case 14: {
                    return Bundle.getMessage("CurrentSignalSysColumnTitle");
                }
                case 15: {
                    return Bundle.getMessage("CurrentSignalColumnTitle");
                }
                case 16: {
                    return Bundle.getMessage("DccColumnTitleColumnTitle");
                }
            }
            return "";
        }

        @SuppressFBWarnings(value={"DB_DUPLICATE_SWITCH_CLAUSES"}, justification="better to keep cases in column order rather than to combine")
        public int getPreferredWidth(int col) {
            switch (col) {
                case 0: 
                case 1: 
                case 2: {
                    return new JTextField((int)17).getPreferredSize().width;
                }
                case 3: {
                    return new JTextField((int)16).getPreferredSize().width;
                }
                case 4: {
                    return new JTextField((int)8).getPreferredSize().width;
                }
                case 5: {
                    return new JTextField((int)11).getPreferredSize().width;
                }
                case 6: 
                case 7: {
                    return new JTextField((int)17).getPreferredSize().width;
                }
                case 8: 
                case 9: {
                    return new JTextField((int)17).getPreferredSize().width;
                }
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: {
                    return new JTextField((int)5).getPreferredSize().width;
                }
            }
            return new JTextField((int)5).getPreferredSize().width;
        }

        @Override
        public Object getValueAt(int r, int c) {
            int rx = r;
            if (rx >= DispatcherFrame.this.activeTrainsList.size()) {
                return null;
            }
            ActiveTrain at = DispatcherFrame.this.activeTrainsList.get(rx);
            switch (c) {
                case 0: {
                    return at.getTransit().getSystemName();
                }
                case 1: {
                    if (at.getTransit() != null && at.getTransit().getUserName() != null) {
                        return at.getTransit().getUserName();
                    }
                    return "";
                }
                case 2: {
                    return at.getTrainName();
                }
                case 3: {
                    return at.getTrainTypeText();
                }
                case 4: {
                    return at.getStatusText();
                }
                case 5: {
                    return at.getModeText();
                }
                case 6: {
                    if (at.getLastAllocatedSection() != null) {
                        return at.getLastAllocatedSection().getSystemName();
                    }
                    return "<none>";
                }
                case 7: {
                    if (at.getLastAllocatedSection() != null && at.getLastAllocatedSection().getUserName() != null) {
                        return at.getLastAllocatedSection().getUserName();
                    }
                    return "<none>";
                }
                case 8: {
                    if (at.getNextSectionToAllocate() != null) {
                        return at.getNextSectionToAllocate().getSystemName();
                    }
                    return "<none>";
                }
                case 9: {
                    if (at.getNextSectionToAllocate() != null && at.getNextSectionToAllocate().getUserName() != null) {
                        return at.getNextSectionToAllocate().getUserName();
                    }
                    return "<none>";
                }
                case 10: {
                    return Bundle.getMessage("AllocateButtonName");
                }
                case 11: {
                    return Bundle.getMessage("TerminateTrain");
                }
                case 12: {
                    return at.getResetWhenDone();
                }
                case 13: {
                    return at.getAutoRun();
                }
                case 14: {
                    if (at.getAutoRun()) {
                        return at.getAutoActiveTrain().getCurrentSignal();
                    }
                    return "NA";
                }
                case 15: {
                    if (at.getAutoRun()) {
                        return at.getAutoActiveTrain().getCurrentSignalUserName();
                    }
                    return "NA";
                }
                case 16: {
                    if (at.getDccAddress() != null) {
                        return at.getDccAddress();
                    }
                    return "NA";
                }
            }
            return " ";
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            if (col == 10) {
                DispatcherFrame.this.allocateNextRequested(row);
            }
            if (col == 11 && DispatcherFrame.this.activeTrainsList.get(row) != null) {
                DispatcherFrame.this.terminateActiveTrain(DispatcherFrame.this.activeTrainsList.get(row), true, false);
            }
            if (col == 12) {
                ActiveTrain at = null;
                at = DispatcherFrame.this.activeTrainsList.get(row);
                if (DispatcherFrame.this.activeTrainsList.get(row) != null) {
                    if (!at.getResetWhenDone()) {
                        at.setResetWhenDone(true);
                        return;
                    }
                    at.setResetWhenDone(false);
                    for (int j = DispatcherFrame.this.restartingTrainsList.size(); j > 0; --j) {
                        if (DispatcherFrame.this.restartingTrainsList.get(j - 1) != at) continue;
                        DispatcherFrame.this.restartingTrainsList.remove(j - 1);
                        return;
                    }
                }
            }
        }
    }

    static class HeldMastDetails {
        SignalMast mast = null;
        ActiveTrain at = null;

        HeldMastDetails(SignalMast sm, ActiveTrain a) {
            this.mast = sm;
            this.at = a;
        }

        ActiveTrain getActiveTrain() {
            return this.at;
        }

        SignalMast getMast() {
            return this.mast;
        }
    }

    protected static enum TrainsFrom {
        TRAINSFROMROSTER,
        TRAINSFROMOPS,
        TRAINSFROMUSER,
        TRAINSFROMSETLATER;

    }
}

