/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.dispatcher;

import java.util.Collection;
import java.util.Collections;
import jmri.InstanceManager;
import jmri.implementation.AbstractShutDownTask;
import jmri.jmrit.dispatcher.ActiveTrain;
import jmri.jmrit.dispatcher.DispatcherFrame;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DispatcherShutDownTask
extends AbstractShutDownTask {
    private static final Logger log = LoggerFactory.getLogger(DispatcherShutDownTask.class);

    public DispatcherShutDownTask(String name) {
        super(name);
    }

    @Override
    public void run() {
        try {
            DispatcherFrame df = InstanceManager.getDefault(DispatcherFrame.class);
            Collection<ActiveTrain> atList = Collections.unmodifiableCollection(df.getActiveTrainsList());
            for (ActiveTrain at : atList) {
                if (at.getAutoActiveTrain() == null) continue;
                at.getAutoActiveTrain().initiateWorking();
            }
        }
        catch (Exception ex) {
            log.error("Failed to stop all autotrains", (Throwable)ex);
        }
    }
}

