/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.dispatcher;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.SortedSet;
import jmri.InstanceManager;
import jmri.InstanceManagerAutoDefault;
import jmri.ScaleManager;
import jmri.configurexml.AbstractXmlAdapter;
import jmri.jmrit.XmlFile;
import jmri.jmrit.dispatcher.DispatcherFrame;
import jmri.jmrit.display.EditorManager;
import jmri.jmrit.display.layoutEditor.LayoutEditor;
import jmri.util.FileUtil;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.ProcessingInstruction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OptionsFile
extends XmlFile
implements InstanceManagerAutoDefault {
    static final AbstractXmlAdapter.EnumIO<DispatcherFrame.TrainsFrom> trainsFromEnumMap = new AbstractXmlAdapter.EnumIoNamesNumbers<DispatcherFrame.TrainsFrom>(DispatcherFrame.TrainsFrom.class);
    protected DispatcherFrame dispatcher = null;
    private static String defaultFileName = FileUtil.getUserFilesPath() + "dispatcheroptions.xml";
    private Document doc = null;
    private Element root = null;
    private static final Logger log = LoggerFactory.getLogger(OptionsFile.class);

    public static void setDefaultFileName(String testLocation) {
        defaultFileName = testLocation;
    }

    public void readDispatcherOptions(DispatcherFrame f) throws JDOMException, IOException {
        if (this.checkFile(defaultFileName)) {
            Element options;
            log.debug("Reading Dispatcher options from file {}", (Object)defaultFileName);
            this.root = this.rootFromName(defaultFileName);
            this.dispatcher = f;
            if (this.root != null && (options = this.root.getChild("options")) != null) {
                String s;
                if (options.getAttribute("lename") != null) {
                    String leName = options.getAttribute("lename").getValue();
                    SortedSet<LayoutEditor> layoutEditorList = InstanceManager.getDefault(EditorManager.class).getAll(LayoutEditor.class);
                    if (layoutEditorList.isEmpty()) {
                        log.warn("Dispatcher options specify a Layout Editor panel that is not present.");
                    } else {
                        boolean found = false;
                        for (LayoutEditor editor : layoutEditorList) {
                            if (!leName.equals(editor.getTitle())) continue;
                            found = true;
                            this.dispatcher.setLayoutEditor(editor);
                        }
                        if (!found) {
                            log.warn("Layout Editor panel - {} - not found.", (Object)leName);
                        }
                    }
                }
                if (options.getAttribute("usesignaltype") != null) {
                    switch (options.getAttribute("usesignaltype").getValue()) {
                        case "signalmast": {
                            this.dispatcher.setSignalType(1);
                            break;
                        }
                        case "sectionsallocated": {
                            this.dispatcher.setSignalType(2);
                            break;
                        }
                        default: {
                            this.dispatcher.setSignalType(0);
                        }
                    }
                }
                if (options.getAttribute("useconnectivity") != null) {
                    this.dispatcher.setUseConnectivity(true);
                    if (options.getAttribute("useconnectivity").getValue().equals("no")) {
                        this.dispatcher.setUseConnectivity(false);
                    }
                }
                if (options.getAttribute("trainsfrom") != null) {
                    this.dispatcher.setTrainsFrom(trainsFromEnumMap.inputFromAttribute(options.getAttribute("trainsfrom")));
                } else {
                    log.warn("Old Style dispatcheroptions file found - will be converted when saved");
                    if (options.getAttribute("trainsfromroster") != null && options.getAttribute("trainsfromroster").getValue().equals("yes")) {
                        this.dispatcher.setTrainsFrom(DispatcherFrame.TrainsFrom.TRAINSFROMROSTER);
                    } else if (options.getAttribute("trainsfromtrains") != null && options.getAttribute("trainsfromtrains").getValue().equals("no")) {
                        this.dispatcher.setTrainsFrom(DispatcherFrame.TrainsFrom.TRAINSFROMOPS);
                    } else if (options.getAttribute("trainsfromuser") != null && options.getAttribute("trainsfromuser").getValue().equals("no")) {
                        this.dispatcher.setTrainsFrom(DispatcherFrame.TrainsFrom.TRAINSFROMUSER);
                    }
                }
                if (options.getAttribute("autoallocate") != null) {
                    this.dispatcher.setAutoAllocate(false);
                    if (options.getAttribute("autoallocate").getValue().equals("yes")) {
                        this.dispatcher.setAutoAllocate(true);
                    }
                }
                if (options.getAttribute("autorelease") != null) {
                    this.dispatcher.setAutoRelease(false);
                    if (options.getAttribute("autorelease").getValue().equals("yes")) {
                        this.dispatcher.setAutoRelease(true);
                    }
                }
                if (options.getAttribute("autoturnouts") != null) {
                    this.dispatcher.setAutoTurnouts(true);
                    if (options.getAttribute("autoturnouts").getValue().equals("no")) {
                        this.dispatcher.setAutoTurnouts(false);
                    }
                }
                if (options.getAttribute("trustknownturnouts") != null) {
                    this.dispatcher.setTrustKnownTurnouts(false);
                    if (options.getAttribute("trustknownturnouts").getValue().equals("yes")) {
                        this.dispatcher.setTrustKnownTurnouts(true);
                    }
                }
                if (options.getAttribute("useturnoutconnectiondelay") != null) {
                    this.dispatcher.setUseTurnoutConnectionDelay(false);
                    if (options.getAttribute("useturnoutconnectiondelay").getValue().equals("yes")) {
                        this.dispatcher.setUseTurnoutConnectionDelay(true);
                    }
                }
                if (options.getAttribute("minthrottleinterval") != null) {
                    s = options.getAttribute("minthrottleinterval").getValue();
                    this.dispatcher.setMinThrottleInterval(Integer.parseInt(s));
                }
                if (options.getAttribute("fullramptime") != null) {
                    s = options.getAttribute("fullramptime").getValue();
                    this.dispatcher.setFullRampTime(Integer.parseInt(s));
                }
                if (options.getAttribute("hasoccupancydetection") != null) {
                    this.dispatcher.setHasOccupancyDetection(true);
                    if (options.getAttribute("hasoccupancydetection").getValue().equals("no")) {
                        this.dispatcher.setHasOccupancyDetection(false);
                    }
                }
                if (options.getAttribute("sslcheckdirectionsensors") != null) {
                    this.dispatcher.setSetSSLDirectionalSensors(true);
                    if (options.getAttribute("sslcheckdirectionsensors").getValue().equals("no")) {
                        this.dispatcher.setSetSSLDirectionalSensors(false);
                    }
                }
                if (options.getAttribute("shortactivetrainnames") != null) {
                    this.dispatcher.setShortActiveTrainNames(true);
                    if (options.getAttribute("shortactivetrainnames").getValue().equals("no")) {
                        this.dispatcher.setShortActiveTrainNames(false);
                    }
                }
                if (options.getAttribute("shortnameinblock") != null) {
                    this.dispatcher.setShortNameInBlock(true);
                    if (options.getAttribute("shortnameinblock").getValue().equals("no")) {
                        this.dispatcher.setShortNameInBlock(false);
                    }
                }
                if (options.getAttribute("extracolorforallocated") != null) {
                    this.dispatcher.setExtraColorForAllocated(true);
                    if (options.getAttribute("extracolorforallocated").getValue().equals("no")) {
                        this.dispatcher.setExtraColorForAllocated(false);
                    }
                }
                if (options.getAttribute("nameinallocatedblock") != null) {
                    this.dispatcher.setNameInAllocatedBlock(true);
                    if (options.getAttribute("nameinallocatedblock").getValue().equals("no")) {
                        this.dispatcher.setNameInAllocatedBlock(false);
                    }
                }
                if (options.getAttribute("supportvsdecoder") != null) {
                    this.dispatcher.setSupportVSDecoder(true);
                    if (options.getAttribute("supportvsdecoder").getValue().equals("no")) {
                        this.dispatcher.setSupportVSDecoder(false);
                    }
                }
                if (options.getAttribute("layoutscale") != null) {
                    s = options.getAttribute("layoutscale").getValue();
                    this.dispatcher.setScale(ScaleManager.getScale(s));
                }
                if (options.getAttribute("usescalemeters") != null) {
                    this.dispatcher.setUseScaleMeters(true);
                    if (options.getAttribute("usescalemeters").getValue().equals("no")) {
                        this.dispatcher.setUseScaleMeters(false);
                    }
                }
                if (options.getAttribute("userosterentryinblock") != null) {
                    this.dispatcher.setRosterEntryInBlock(false);
                    if (options.getAttribute("userosterentryinblock").getValue().equals("yes")) {
                        this.dispatcher.setRosterEntryInBlock(true);
                    }
                }
                if (options.getAttribute("stoppingspeedname") != null) {
                    this.dispatcher.setStoppingSpeedName(options.getAttribute("stoppingspeedname").getValue());
                }
                log.debug("  Options: {}, Detection={}, AutoAllocate={}, AutoTurnouts={}, SetSSLDirectionSensors={}", new Object[]{this.dispatcher.getSignalTypeString(), this.dispatcher.getAutoAllocate() ? "yes" : "no", this.dispatcher.getAutoTurnouts() ? "yes" : "no", this.dispatcher.getSetSSLDirectionalSensors() ? "yes" : "no"});
            }
        } else {
            log.debug("No Dispatcher options file found at {}, using defaults", (Object)defaultFileName);
        }
    }

    public void writeDispatcherOptions(DispatcherFrame f) throws IOException {
        log.debug("Saving Dispatcher options to file {}", (Object)defaultFileName);
        this.dispatcher = f;
        this.root = new Element("dispatcheroptions");
        this.doc = OptionsFile.newDocument(this.root, this.dtdLocation + "dispatcher-options.dtd");
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("type", "text/xsl");
        m.put("href", "/xml/XSLT/dispatcheroptions.xsl");
        ProcessingInstruction p = new ProcessingInstruction("xml-stylesheet", m);
        this.doc.addContent(0, (Content)p);
        Element options = new Element("options");
        LayoutEditor le = this.dispatcher.getLayoutEditor();
        if (le != null) {
            options.setAttribute("lename", le.getTitle());
        }
        options.setAttribute("useconnectivity", this.dispatcher.getUseConnectivity() ? "yes" : "no");
        options.setAttribute("trainsfrom", trainsFromEnumMap.outputFromEnum(this.dispatcher.getTrainsFrom()));
        options.setAttribute("autoallocate", this.dispatcher.getAutoAllocate() ? "yes" : "no");
        options.setAttribute("autorelease", this.dispatcher.getAutoRelease() ? "yes" : "no");
        options.setAttribute("autoturnouts", this.dispatcher.getAutoTurnouts() ? "yes" : "no");
        options.setAttribute("trustknownturnouts", this.dispatcher.getTrustKnownTurnouts() ? "yes" : "no");
        options.setAttribute("useturnoutconnectiondelay", this.dispatcher.getUseTurnoutConnectionDelay() ? "yes" : "no");
        options.setAttribute("minthrottleinterval", "" + this.dispatcher.getMinThrottleInterval());
        options.setAttribute("fullramptime", "" + this.dispatcher.getFullRampTime());
        options.setAttribute("hasoccupancydetection", this.dispatcher.getHasOccupancyDetection() ? "yes" : "no");
        options.setAttribute("sslcheckdirectionsensors", this.dispatcher.getSetSSLDirectionalSensors() ? "yes" : "no");
        options.setAttribute("shortactivetrainnames", this.dispatcher.getShortActiveTrainNames() ? "yes" : "no");
        options.setAttribute("shortnameinblock", this.dispatcher.getShortNameInBlock() ? "yes" : "no");
        options.setAttribute("extracolorforallocated", this.dispatcher.getExtraColorForAllocated() ? "yes" : "no");
        options.setAttribute("nameinallocatedblock", this.dispatcher.getNameInAllocatedBlock() ? "yes" : "no");
        options.setAttribute("supportvsdecoder", this.dispatcher.getSupportVSDecoder() ? "yes" : "no");
        options.setAttribute("layoutscale", this.dispatcher.getScale().getScaleName());
        options.setAttribute("usescalemeters", this.dispatcher.getUseScaleMeters() ? "yes" : "no");
        options.setAttribute("userosterentryinblock", this.dispatcher.getRosterEntryInBlock() ? "yes" : "no");
        options.setAttribute("stoppingspeedname", this.dispatcher.getStoppingSpeedName());
        switch (this.dispatcher.getSignalType()) {
            case 1: {
                options.setAttribute("usesignaltype", "signalmast");
                break;
            }
            case 2: {
                options.setAttribute("usesignaltype", "sectionsallocated");
                break;
            }
            default: {
                options.setAttribute("usesignaltype", "signalhead");
            }
        }
        this.root.addContent((Content)options);
        try {
            File file;
            if (!this.checkFile(defaultFileName) && !(file = new File(defaultFileName)).createNewFile()) {
                log.error("createNewFile failed");
            }
            this.writeXML(this.findFile(defaultFileName), this.doc);
        }
        catch (IOException ioe) {
            log.error("IO Exception {}", (Object)ioe.getMessage());
            throw ioe;
        }
    }
}

