/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.display;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.awt.Color;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Polygon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.text.DecimalFormat;
import java.util.Date;
import javax.annotation.Nonnull;
import javax.swing.ButtonGroup;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.Timebase;
import jmri.TimebaseRateException;
import jmri.jmrit.catalog.NamedIcon;
import jmri.jmrit.display.Bundle;
import jmri.jmrit.display.CoordinateEdit;
import jmri.jmrit.display.Editor;
import jmri.jmrit.display.LinkingObject;
import jmri.jmrit.display.Positionable;
import jmri.jmrit.display.PositionableJComponent;
import jmri.util.HelpUtil;
import jmri.util.JmriJFrame;
import jmri.util.swing.JmriColorChooser;
import jmri.util.swing.JmriMouseEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnalogClock2Display
extends PositionableJComponent
implements LinkingObject {
    Timebase clock;
    double rate;
    double minuteAngle;
    double hourAngle;
    String amPm;
    Color color = Color.black;
    Image logo;
    Image scaledLogo;
    Image clockFace;
    NamedIcon jmriIcon;
    NamedIcon scaledIcon;
    NamedIcon clockIcon;
    int[] hourX = new int[]{-12, -11, -25, -10, -10, 0, 10, 10, 25, 11, 12};
    int[] hourY = new int[]{-31, -163, -170, -211, -276, -285, -276, -211, -170, -163, -31};
    int[] minuteX = new int[]{-12, -11, -24, -11, -11, 0, 11, 11, 24, 11, 12};
    int[] minuteY = new int[]{-31, -261, -266, -314, -381, -391, -381, -314, -266, -261, -31};
    int[] scaledHourX = new int[this.hourX.length];
    int[] scaledHourY = new int[this.hourY.length];
    int[] scaledMinuteX = new int[this.minuteX.length];
    int[] scaledMinuteY = new int[this.minuteY.length];
    int[] rotatedHourX = new int[this.hourX.length];
    int[] rotatedHourY = new int[this.hourY.length];
    int[] rotatedMinuteX = new int[this.minuteX.length];
    int[] rotatedMinuteY = new int[this.minuteY.length];
    Polygon hourHand;
    Polygon scaledHourHand;
    Polygon minuteHand;
    Polygon scaledMinuteHand;
    int minuteHeight;
    int hourHeight;
    double scaleRatio;
    int faceSize;
    int panelWidth;
    int panelHeight;
    int size;
    int logoWidth;
    int logoHeight;
    int centreX;
    int centreY;
    String _url;
    ButtonGroup colorButtonGroup = null;
    ButtonGroup rateButtonGroup = null;
    JMenuItem runMenu = null;
    private static final Logger log = LoggerFactory.getLogger(AnalogClock2Display.class);

    public AnalogClock2Display(Editor editor) {
        super(editor);
        this.clock = InstanceManager.getDefault(Timebase.class);
        this.rate = (int)this.clock.userGetRate();
        this.init();
    }

    public AnalogClock2Display(Editor editor, String url) {
        this(editor);
        this._url = url;
    }

    @Override
    public Positionable deepClone() {
        AnalogClock2Display pos = this._url == null || this._url.trim().length() == 0 ? new AnalogClock2Display(this._editor) : new AnalogClock2Display(this._editor, this._url);
        return this.finishClone(pos);
    }

    protected Positionable finishClone(AnalogClock2Display pos) {
        pos.setScale(this.getScale());
        return super.finishClone(pos);
    }

    final void init() {
        this.jmriIcon = new NamedIcon("resources/logo.gif", "resources/logo.gif");
        this.scaledIcon = new NamedIcon("resources/logo.gif", "resources/logo.gif");
        this.clockIcon = new NamedIcon("resources/clock2.gif", "resources/clock2.gif");
        this.logo = this.jmriIcon.getImage();
        this.clockFace = this.clockIcon.getImage();
        this.hourHand = new Polygon(this.hourX, this.hourY, 11);
        this.hourHeight = this.hourHand.getBounds().getSize().height;
        this.minuteHand = new Polygon(this.minuteX, this.minuteY, 11);
        this.minuteHeight = this.minuteHand.getBounds().getSize().height;
        this.amPm = "AM";
        this.clock.addMinuteChangeListener(e -> this.update());
        this.clock.addPropertyChangeListener(e -> this.update());
        this.setSize(this.clockIcon.getIconHeight());
    }

    public int getFaceWidth() {
        return this.faceSize;
    }

    public int getFaceHeight() {
        return this.faceSize;
    }

    @Override
    public boolean setScaleMenu(JPopupMenu popup) {
        popup.add(new JMenuItem(Bundle.getMessage("FastClock")));
        JMenu rateMenu = new JMenu("Clock rate");
        this.rateButtonGroup = new ButtonGroup();
        this.addRateMenuEntry(rateMenu, 1);
        this.addRateMenuEntry(rateMenu, 2);
        this.addRateMenuEntry(rateMenu, 4);
        this.addRateMenuEntry(rateMenu, 8);
        popup.add(rateMenu);
        this.runMenu = new JMenuItem(this.getRun() ? "Stop" : "Start");
        this.runMenu.addActionListener(e -> {
            this.setRun(!this.getRun());
            this.update();
        });
        popup.add(this.runMenu);
        popup.add(CoordinateEdit.getScaleEditAction(this));
        popup.addSeparator();
        JMenuItem colorMenuItem = new JMenuItem(Bundle.getMessage("Color"));
        colorMenuItem.addActionListener(event -> {
            Color desiredColor = JmriColorChooser.showDialog(this, Bundle.getMessage("DefaultTextColor", ""), this.color);
            if (desiredColor != null && !this.color.equals(desiredColor)) {
                this.setColor(desiredColor);
            }
        });
        popup.add(colorMenuItem);
        return true;
    }

    @Override
    @Nonnull
    public String getTypeString() {
        return Bundle.getMessage("PositionableType_");
    }

    @Override
    public String getNameString() {
        return "Clock";
    }

    @Override
    public void setScale(double scale) {
        if (scale == 1.0) {
            this.init();
            return;
        }
        AffineTransform t = AffineTransform.getScaleInstance(scale, scale);
        this.clockIcon = new NamedIcon("resources/clock2.gif", "resources/clock2.gif");
        int w = (int)Math.ceil(scale * (double)this.clockIcon.getIconWidth());
        int h = (int)Math.ceil(scale * (double)this.clockIcon.getIconHeight());
        this.clockIcon.transformImage(w, h, t, null);
        this.scaledIcon = new NamedIcon("resources/logo.gif", "resources/logo.gif");
        w = (int)Math.ceil(scale * (double)this.scaledIcon.getIconWidth());
        h = (int)Math.ceil(scale * (double)this.scaledIcon.getIconHeight());
        this.scaledIcon.transformImage(w, h, t, null);
        this.jmriIcon = new NamedIcon("resources/logo.gif", "resources/logo.gif");
        w = (int)Math.ceil(scale * (double)this.jmriIcon.getIconWidth());
        h = (int)Math.ceil(scale * (double)this.jmriIcon.getIconHeight());
        this.jmriIcon.transformImage(w, h, t, null);
        this.logo = this.jmriIcon.getImage();
        this.clockFace = this.clockIcon.getImage();
        this.setSize(this.clockIcon.getIconHeight());
        super.setScale(scale);
    }

    @SuppressFBWarnings(value={"FE_FLOATING_POINT_EQUALITY"}, justification="fixed number of possible values")
    void addRateMenuEntry(JMenu menu, final int newrate) {
        JRadioButtonMenuItem button = new JRadioButtonMenuItem(newrate + ":1");
        button.addActionListener(new ActionListener(){
            final int r;
            {
                this.r = newrate;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    AnalogClock2Display.this.clock.userSetRate(this.r);
                    AnalogClock2Display.this.rate = this.r;
                }
                catch (TimebaseRateException t) {
                    log.error("TimebaseRateException for rate= {}", (Object)this.r, (Object)t);
                }
            }
        });
        this.rateButtonGroup.add(button);
        if (this.rate == (double)newrate) {
            button.setSelected(true);
        } else {
            button.setSelected(false);
        }
        menu.add(button);
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
        this.update();
        JmriColorChooser.addRecentColor(color);
    }

    @Override
    public void paint(Graphics g) {
        g.setColor(this.color);
        g.translate(this.centreX, this.centreY);
        g.drawImage(this.clockFace, -this.faceSize / 2, -this.faceSize / 2, this.faceSize, this.faceSize, this);
        g.drawImage(this.scaledLogo, -this.logoWidth / 2, -this.faceSize / 4, this.logoWidth, this.logoHeight, this);
        double minuteAngleRadians = Math.toRadians(this.minuteAngle);
        for (int i = 0; i < this.scaledMinuteX.length; ++i) {
            this.rotatedMinuteX[i] = (int)((double)this.scaledMinuteX[i] * Math.cos(minuteAngleRadians) - (double)this.scaledMinuteY[i] * Math.sin(minuteAngleRadians));
            this.rotatedMinuteY[i] = (int)((double)this.scaledMinuteX[i] * Math.sin(minuteAngleRadians) + (double)this.scaledMinuteY[i] * Math.cos(minuteAngleRadians));
        }
        this.scaledMinuteHand = new Polygon(this.rotatedMinuteX, this.rotatedMinuteY, this.rotatedMinuteX.length);
        double hourAngleRadians = Math.toRadians(this.hourAngle);
        for (int i = 0; i < this.scaledHourX.length; ++i) {
            this.rotatedHourX[i] = (int)((double)this.scaledHourX[i] * Math.cos(hourAngleRadians) - (double)this.scaledHourY[i] * Math.sin(hourAngleRadians));
            this.rotatedHourY[i] = (int)((double)this.scaledHourX[i] * Math.sin(hourAngleRadians) + (double)this.scaledHourY[i] * Math.cos(hourAngleRadians));
        }
        this.scaledHourHand = new Polygon(this.rotatedHourX, this.rotatedHourY, this.rotatedHourX.length);
        g.fillPolygon(this.scaledHourHand);
        g.fillPolygon(this.scaledMinuteHand);
        int amPmFontSize = (int)((double)this.faceSize * 0.075);
        if (amPmFontSize < 1) {
            amPmFontSize = 1;
        }
        Font amPmSizedFont = new Font("Serif", 1, amPmFontSize);
        g.setFont(amPmSizedFont);
        FontMetrics amPmFontM = g.getFontMetrics(amPmSizedFont);
        g.drawString(this.amPm, -amPmFontM.stringWidth(this.amPm) / 2, this.faceSize / 5);
    }

    int dotX(double radius, double angle) {
        int xDist = (int)Math.round(radius * Math.cos(Math.toRadians(angle)));
        return xDist;
    }

    int dotY(double radius, double angle) {
        int yDist = (int)Math.round(radius * Math.sin(Math.toRadians(angle)));
        return yDist;
    }

    private void scaleFace() {
        this.panelHeight = this.getSize().height;
        this.panelWidth = this.getSize().width;
        if (this.panelHeight > 0 && this.panelWidth > 0) {
            this.size = Math.min(this.panelHeight, this.panelWidth);
        }
        this.faceSize = this.size;
        if (this.faceSize <= 12) {
            return;
        }
        int logoScaleWidth = this.faceSize / 6;
        int logoScaleHeight = (int)((float)logoScaleWidth * (float)this.jmriIcon.getIconHeight() / (float)this.jmriIcon.getIconWidth());
        this.scaledLogo = this.logo.getScaledInstance(logoScaleWidth, logoScaleHeight, 4);
        this.scaledIcon.setImage(this.scaledLogo);
        this.logoWidth = this.scaledIcon.getIconWidth();
        this.logoHeight = this.scaledIcon.getIconHeight();
        this.scaleRatio = (double)this.faceSize / 2.7 / (double)this.minuteHeight;
        for (int i = 0; i < this.minuteX.length; ++i) {
            this.scaledMinuteX[i] = (int)((double)this.minuteX[i] * this.scaleRatio);
            this.scaledMinuteY[i] = (int)((double)this.minuteY[i] * this.scaleRatio);
            this.scaledHourX[i] = (int)((double)this.hourX[i] * this.scaleRatio);
            this.scaledHourY[i] = (int)((double)this.hourY[i] * this.scaleRatio);
        }
        this.scaledHourHand = new Polygon(this.scaledHourX, this.scaledHourY, this.scaledHourX.length);
        this.scaledMinuteHand = new Polygon(this.scaledMinuteX, this.scaledMinuteY, this.scaledMinuteX.length);
        if (this.panelHeight > 0 && this.panelWidth > 0) {
            this.centreX = this.panelWidth / 2;
            this.centreY = this.panelHeight / 2;
        } else {
            this.centreX = this.centreY = this.size / 2;
        }
    }

    public void setSize(int x) {
        this.size = x;
        this.setSize(x, x);
        this.scaleFace();
    }

    public void update() {
        Date now = this.clock.getTime();
        if (this.runMenu != null) {
            this.runMenu.setText(this.getRun() ? "Stop" : "Start");
        }
        int hours = now.getHours();
        int minutes = now.getMinutes();
        this.minuteAngle = (double)minutes * 6.0;
        this.hourAngle = (double)hours * 30.0 + 30.0 * this.minuteAngle / 360.0;
        this.amPm = hours < 12 ? Bundle.getMessage("ClockAM") : Bundle.getMessage("ClockPM");
        if (hours == 12 && minutes == 0) {
            this.amPm = Bundle.getMessage("ClockNoon");
        }
        if (hours == 0 && minutes == 0) {
            this.amPm = Bundle.getMessage("ClockMidnight");
        }
        if (!this.clock.getRun()) {
            this.amPm = this.amPm + " " + Bundle.getMessage("ClockStopped");
        } else {
            Object rate = "" + (int)this.clock.userGetRate();
            if (Math.floor(this.clock.userGetRate()) != this.clock.userGetRate()) {
                DecimalFormat format = new DecimalFormat("0.###");
                rate = format.format(this.clock.userGetRate());
            }
            this.amPm = this.amPm + " " + (String)rate + ":1";
        }
        this.repaint();
    }

    public boolean getRun() {
        return this.clock.getRun();
    }

    public void setRun(boolean next) {
        this.clock.setRun(next);
    }

    @Override
    void cleanup() {
    }

    public void dispose() {
        this.rateButtonGroup = null;
        this.runMenu = null;
    }

    @Override
    public String getURL() {
        return this._url;
    }

    @Override
    public void setULRL(String u) {
        this._url = u;
    }

    @Override
    public boolean setLinkMenu(JPopupMenu popup) {
        if (this._url == null || this._url.trim().length() == 0) {
            return false;
        }
        popup.add(CoordinateEdit.getLinkEditAction(this, "EditLink"));
        return true;
    }

    @Override
    public void doMouseClicked(JmriMouseEvent event) {
        log.debug("click to {}", (Object)this._url);
        if (this._url == null || this._url.trim().length() == 0) {
            return;
        }
        try {
            if (this._url.startsWith("frame:")) {
                String frame = this._url.substring(6);
                JmriJFrame jframe = JmriJFrame.getFrame(frame);
                EventQueue.invokeLater(() -> {
                    jframe.toFront();
                    jframe.repaint();
                });
            } else {
                HelpUtil.openWebPage(this._url);
            }
        }
        catch (JmriException t) {
            log.error("Error handling link", (Throwable)t);
        }
        super.doMouseClicked(event);
    }
}

