/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.display;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import jmri.Audio;
import jmri.AudioException;
import jmri.AudioManager;
import jmri.InstanceManager;
import jmri.NamedBean;
import jmri.NamedBeanHandle;
import jmri.NamedBeanHandleManager;
import jmri.jmrit.audio.AudioSource;
import jmri.jmrit.catalog.NamedIcon;
import jmri.jmrit.display.Bundle;
import jmri.jmrit.display.Editor;
import jmri.jmrit.display.Positionable;
import jmri.jmrit.display.PositionableLabel;
import jmri.jmrit.picker.PickListModel;
import jmri.util.swing.JmriMouseEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AudioIcon
extends PositionableLabel {
    public static final String PROPERTY_COMMAND = "Command";
    public static final String PROPERTY_COMMAND_PLAY = "Play";
    public static final String PROPERTY_COMMAND_STOP = "Stop";
    public static final IdentityManager IDENTITY_MANAGER = new IdentityManager();
    private final int _identity;
    private NamedIcon _originalIcon = new NamedIcon("resources/icons/audio_icon.gif", "resources/icons/audio_icon.gif");
    private String _originalText = Bundle.getMessage("AudioIcon_Text");
    private OnClickOperation _onClickOperation = OnClickOperation.DoNothing;
    private boolean _playSoundWhenJmriPlays = true;
    private boolean _stopSoundWhenJmriStops = false;
    private NamedBeanHandle<Audio> _namedAudio;
    private static final Logger log = LoggerFactory.getLogger(AudioIcon.class);

    public AudioIcon(String s, @Nonnull Editor editor) {
        super(s, editor);
        this._identity = IDENTITY_MANAGER.getIdentity(this);
        this._originalText = s;
    }

    public AudioIcon(int identity, String s, @Nonnull Editor editor) {
        super(s, editor);
        this._identity = IDENTITY_MANAGER.getIdentity(identity, this);
        this._originalText = s;
    }

    public AudioIcon(@CheckForNull NamedIcon s, @Nonnull Editor editor) {
        super(s, editor);
        this._identity = IDENTITY_MANAGER.getIdentity(this);
        this._originalIcon = this._namedIcon;
    }

    public AudioIcon(int identity, @CheckForNull NamedIcon s, @Nonnull Editor editor) {
        super(s, editor);
        this._identity = IDENTITY_MANAGER.getIdentity(identity, this);
        this._originalIcon = this._namedIcon;
    }

    @Override
    public Positionable deepClone() {
        AudioIcon pos = new AudioIcon(this.getText(), this._editor);
        pos._originalIcon = new NamedIcon(this._originalIcon);
        pos._originalText = this._originalText;
        pos.setAudio(this.getNamedAudio().getName());
        pos._onClickOperation = this._onClickOperation;
        pos._playSoundWhenJmriPlays = this._playSoundWhenJmriPlays;
        pos._stopSoundWhenJmriStops = this._stopSoundWhenJmriStops;
        return super.finishClone(pos);
    }

    @Override
    @Nonnull
    public String getTypeString() {
        return Bundle.getMessage("PositionableType_AudioIcon");
    }

    @Override
    @Nonnull
    public String getNameString() {
        String name = this._namedAudio == null ? Bundle.getMessage("NotConnected") : this._namedAudio.getBean().getDisplayName(NamedBean.DisplayOptions.USERNAME_SYSTEMNAME);
        return name;
    }

    public int getIdentity() {
        return this._identity;
    }

    public void setAudio(String pName) {
        if (InstanceManager.getNullableDefault(AudioManager.class) != null) {
            try {
                Audio audio = InstanceManager.getDefault(AudioManager.class).provideAudio(pName);
                this.setAudio(InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(pName, audio));
            }
            catch (IllegalArgumentException | AudioException ex) {
                log.error("Audio '{}' not available, icon won't see changes", (Object)pName);
            }
        } else {
            log.error("No AudioManager for this protocol, icon won't see changes");
        }
    }

    public void setAudio(NamedBeanHandle<Audio> s) {
        this._namedAudio = s;
        if (this._namedAudio != null) {
            this.setName(this._namedAudio.getName());
        }
    }

    public Audio getAudio() {
        if (this._namedAudio == null) {
            return null;
        }
        return this._namedAudio.getBean();
    }

    @Override
    public NamedBean getNamedBean() {
        return this.getAudio();
    }

    public NamedBeanHandle<Audio> getNamedAudio() {
        return this._namedAudio;
    }

    public void setOnClickOperation(OnClickOperation operation) {
        this._onClickOperation = operation;
    }

    public OnClickOperation getOnClickOperation() {
        return this._onClickOperation;
    }

    public void setPlaySoundWhenJmriPlays(boolean value) {
        this._playSoundWhenJmriPlays = value;
    }

    public boolean getPlaySoundWhenJmriPlays() {
        return this._playSoundWhenJmriPlays;
    }

    public void setStopSoundWhenJmriStops(boolean value) {
        this._stopSoundWhenJmriStops = value;
    }

    public boolean getStopSoundWhenJmriStops() {
        return this._stopSoundWhenJmriStops;
    }

    public void play() {
        log.debug("AudioIcon.play()");
        this.firePropertyChange(PROPERTY_COMMAND, null, PROPERTY_COMMAND_PLAY);
    }

    public void stop() {
        log.debug("AudioIcon.stop()");
        this.firePropertyChange(PROPERTY_COMMAND, null, PROPERTY_COMMAND_STOP);
    }

    @Override
    protected void edit() {
        this.makeIconEditorFrame(this, "Audio", true, null);
        this._iconEditor.setPickList(PickListModel.audioPickModelInstance());
        this._iconEditor.setIcon(0, "plainIcon", this._namedIcon);
        this._iconEditor.makeIconPanel(false);
        ActionListener addIconAction = a -> this.updateAudio();
        this._iconEditor.complete(addIconAction, true, true, true);
        this._iconEditor.setSelection(this.getAudio());
    }

    void updateAudio() {
        this.setAudio(this._iconEditor.getTableSelection().getDisplayName());
        Hashtable<String, NamedIcon> iconMap = this._iconEditor.getIconMap();
        NamedIcon newIcon = iconMap.get("plainIcon");
        this.setIcon(newIcon);
        this._iconEditorFrame.dispose();
        this._iconEditorFrame = null;
        this._iconEditor = null;
        this.invalidate();
    }

    @Override
    protected void editIcon() {
        super.editIcon();
        this._originalIcon = this._namedIcon;
    }

    @Override
    public void doMousePressed(JmriMouseEvent e) {
        Audio audio;
        log.debug("doMousePressed");
        if (!e.isMetaDown() && !e.isAltDown() && this._onClickOperation != OnClickOperation.DoNothing && this._namedAudio != null && (audio = this._namedAudio.getBean()).getSubType() == 'S' && audio instanceof AudioSource) {
            AudioSource source = (AudioSource)audio;
            if (source.getState() == 17) {
                source.stop();
            } else {
                source.play();
            }
        }
        super.doMousePressed(e);
    }

    private void changeAudioIconType() {
        this._unRotatedText = null;
        if (this.isIcon()) {
            this._icon = false;
            this._text = true;
            this.setText(this._originalText);
            this.setIcon(null);
            this.setOpaque(true);
        } else if (this.isText()) {
            this._icon = true;
            if (this.getText() != null) {
                this._originalText = this.getText();
            }
            this._text = false;
            this.setText(null);
            this.setUnRotatedText(null);
            this.setOpaque(false);
            this.setIcon(this._originalIcon);
        }
        int deg = this.getDegrees();
        this.rotate(deg);
    }

    @Override
    public boolean showPopUp(JPopupMenu popup) {
        if (this.isEditable()) {
            if (this.isIcon()) {
                popup.add(new AbstractAction(Bundle.getMessage("ChangeToText")){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        AudioIcon.this.changeAudioIconType();
                    }
                });
            } else {
                popup.add(new AbstractAction(Bundle.getMessage("ChangeToIcon")){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        AudioIcon.this.changeAudioIconType();
                    }
                });
            }
            JMenu menu = new JMenu(Bundle.getMessage("AudioIcon_WebPanelMenu"));
            ButtonGroup buttonGroup = new ButtonGroup();
            JRadioButtonMenuItem rbMenuItem = new JRadioButtonMenuItem(Bundle.getMessage("AudioIcon_WebPanelMenu_OnClickPlaySoundGlobally"));
            rbMenuItem.addActionListener(event -> {
                this._onClickOperation = OnClickOperation.PlaySoundGlobally;
            });
            rbMenuItem.setSelected(this._onClickOperation == OnClickOperation.PlaySoundGlobally);
            menu.add(rbMenuItem);
            buttonGroup.add(rbMenuItem);
            rbMenuItem = new JRadioButtonMenuItem(Bundle.getMessage("AudioIcon_WebPanelMenu_OnClickPlaySoundLocally"));
            rbMenuItem.addActionListener(event -> {
                this._onClickOperation = OnClickOperation.PlaySoundLocally;
            });
            rbMenuItem.setSelected(this._onClickOperation == OnClickOperation.PlaySoundLocally);
            menu.add(rbMenuItem);
            buttonGroup.add(rbMenuItem);
            rbMenuItem = new JRadioButtonMenuItem(Bundle.getMessage("AudioIcon_WebPanelMenu_OnClickDoNothing"));
            rbMenuItem.addActionListener(event -> {
                this._onClickOperation = OnClickOperation.DoNothing;
            });
            rbMenuItem.setSelected(this._onClickOperation == OnClickOperation.DoNothing);
            menu.add(rbMenuItem);
            buttonGroup.add(rbMenuItem);
            JCheckBoxMenuItem cbMenuItem2 = new JCheckBoxMenuItem(Bundle.getMessage("AudioIcon_WebPanelMenu_PlaySoundWhenJmriPlays"));
            cbMenuItem2.addActionListener(event -> {
                this._playSoundWhenJmriPlays = cbMenuItem2.isSelected();
            });
            cbMenuItem2.setSelected(this._playSoundWhenJmriPlays);
            menu.add(cbMenuItem2);
            JCheckBoxMenuItem cbMenuItem3 = new JCheckBoxMenuItem(Bundle.getMessage("AudioIcon_WebPanelMenu_StopSoundWhenJmriStops"));
            cbMenuItem3.addActionListener(event -> {
                this._stopSoundWhenJmriStops = cbMenuItem3.isSelected();
            });
            cbMenuItem3.setSelected(this._stopSoundWhenJmriStops);
            menu.add(cbMenuItem3);
            popup.add(menu);
        }
        return true;
    }

    public static class IdentityManager {
        Map<Integer, AudioIcon> _identities = new HashMap<Integer, AudioIcon>();
        int _lastIdentity = -1;

        private IdentityManager() {
        }

        public int getIdentity(AudioIcon audioIcon) {
            ++this._lastIdentity;
            this._identities.put(this._lastIdentity, audioIcon);
            return this._lastIdentity;
        }

        public int getIdentity(int identity, AudioIcon audioIcon) {
            if (this._identities.containsKey(identity)) {
                log.error("Identity {} already exists", (Object)identity);
                return this.getIdentity(audioIcon);
            }
            this._identities.put(identity, audioIcon);
            if (identity > this._lastIdentity) {
                this._lastIdentity = identity;
            }
            return identity;
        }

        public AudioIcon getAudioIcon(int identity) {
            return this._identities.get(identity);
        }
    }

    public static enum OnClickOperation {
        PlaySoundGlobally(Bundle.getMessage("AudioIcon_WebPanelMenu_OnClickPlaySoundGlobally")),
        PlaySoundLocally(Bundle.getMessage("AudioIcon_WebPanelMenu_OnClickPlaySoundLocally")),
        DoNothing(Bundle.getMessage("AudioIcon_WebPanelMenu_OnClickDoNothing"));

        private final String _text;

        private OnClickOperation(String text) {
            this._text = text;
        }

        public String toString() {
            return this._text;
        }
    }
}

