/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.display;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.text.MessageFormat;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeListener;
import jmri.jmrit.display.Bundle;
import jmri.jmrit.display.Editor;
import jmri.jmrit.display.LinkingObject;
import jmri.jmrit.display.Positionable;
import jmri.jmrit.display.PositionableLabel;
import jmri.jmrit.display.PositionablePopupUtil;
import jmri.jmrit.display.SensorIcon;
import jmri.util.JmriJFrame;
import jmri.util.swing.JmriJOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoordinateEdit
extends JmriJFrame {
    Positionable pl;
    int oldX;
    int oldY;
    double oldD;
    String oldStr;
    JLabel nameText = new JLabel();
    JLabel textX;
    JLabel textY;
    JButton okButton = new JButton();
    JButton cancelButton = new JButton();
    JTextField xTextField;
    JTextField yTextField;
    JSpinner spinX;
    JSpinner spinY;
    private static final Logger log = LoggerFactory.getLogger(CoordinateEdit.class);

    public static AbstractAction getCoordinateEditAction(final Positionable pos) {
        return new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CoordinateEdit f = new CoordinateEdit();
                f.addHelpMenu("package.jmri.jmrit.display.CoordinateEdit", true);
                f.init(Bundle.getMessage("SetXY", ""), pos, true);
                f.initSetXY();
                f.setVisible(true);
                f.setLocationRelativeTo((Component)((Object)pos));
            }
        };
    }

    public static AbstractAction getLevelEditAction(final Positionable pos) {
        return new AbstractAction(Bundle.getMessage("SetLevel", "...")){

            @Override
            public void actionPerformed(ActionEvent e) {
                CoordinateEdit f = new CoordinateEdit();
                f.addHelpMenu("package.jmri.jmrit.display.CoordinateEdit", true);
                f.init(Bundle.getMessage("SetLevel", ""), pos, true);
                f.initSetLevel();
                f.setVisible(true);
                f.setLocationRelativeTo((Component)((Object)pos));
            }
        };
    }

    public static AbstractAction getToolTipEditAction(final Positionable pos) {
        return new AbstractAction(Bundle.getMessage("SetCustomTooltip", "...")){

            @Override
            public void actionPerformed(ActionEvent e) {
                CoordinateEdit f = new CoordinateEdit();
                f.addHelpMenu("package.jmri.jmrit.display.CoordinateEdit", true);
                f.init(Bundle.getMessage("SetTooltip", ""), pos, true);
                f.initSetTip();
                f.setVisible(true);
                f.setLocationRelativeTo((Component)((Object)pos));
            }
        };
    }

    public static AbstractAction getBorderEditAction(final Positionable pos) {
        return new AbstractAction(Bundle.getMessage("SetBorderSize", "...")){

            @Override
            public void actionPerformed(ActionEvent e) {
                CoordinateEdit f = new CoordinateEdit();
                f.addHelpMenu("package.jmri.jmrit.display.CoordinateEdit", true);
                f.init(Bundle.getMessage("SetBorderSize", ""), pos, true);
                f.initBorder();
                f.setVisible(true);
                f.setLocationRelativeTo((Component)((Object)pos));
            }
        };
    }

    public static AbstractAction getMarginEditAction(final Positionable pos) {
        return new AbstractAction(Bundle.getMessage("SetMarginSize", "...")){

            @Override
            public void actionPerformed(ActionEvent e) {
                CoordinateEdit f = new CoordinateEdit();
                f.addHelpMenu("package.jmri.jmrit.display.CoordinateEdit", true);
                f.init(Bundle.getMessage("SetMarginSize", ""), pos, true);
                f.initMargin();
                f.setVisible(true);
                f.setLocationRelativeTo((Component)((Object)pos));
            }
        };
    }

    public static AbstractAction getFixedSizeEditAction(final Positionable pos) {
        return new AbstractAction(Bundle.getMessage("SetFixedSize", "...")){

            @Override
            public void actionPerformed(ActionEvent e) {
                CoordinateEdit f = new CoordinateEdit();
                f.addHelpMenu("package.jmri.jmrit.display.CoordinateEdit", true);
                f.init(Bundle.getMessage("SetFixedSize", ""), pos, true);
                f.initFixedSize();
                f.setVisible(true);
                f.setLocationRelativeTo((Component)((Object)pos));
            }
        };
    }

    public static AbstractAction getRotateEditAction(final Positionable pos) {
        return new AbstractAction(Bundle.getMessage("RotateSign", pos.getDegrees())){

            @Override
            public void actionPerformed(ActionEvent e) {
                CoordinateEdit f = new CoordinateEdit();
                f.addHelpMenu("package.jmri.jmrit.display.CoordinateEdit", true);
                f.init(Bundle.getMessage("Rotate", ""), pos, true);
                f.initRotate();
                f.setVisible(true);
                f.setLocationRelativeTo((Component)((Object)pos));
            }
        };
    }

    public static AbstractAction getScaleEditAction(final Positionable pos) {
        return new AbstractAction(Bundle.getMessage("Rescale", "...")){

            @Override
            public void actionPerformed(ActionEvent e) {
                CoordinateEdit f = new CoordinateEdit();
                f.addHelpMenu("package.jmri.jmrit.display.CoordinateEdit", true);
                f.init(Bundle.getMessage("Rescale", ""), pos, true);
                f.initScale();
                f.setVisible(true);
                f.setLocationRelativeTo((Component)((Object)pos));
            }
        };
    }

    public static AbstractAction getIdEditAction(final Positionable pos, final String title, final Editor editor) {
        return new AbstractAction(Bundle.getMessage(title) + "..."){

            @Override
            public void actionPerformed(ActionEvent e) {
                CoordinateEdit f = new CoordinateEdit();
                f.addHelpMenu("package.jmri.jmrit.display.CoordinateEdit", true);
                f.init(Bundle.getMessage(title), pos, false);
                f.initId(editor);
                f.setVisible(true);
                f.setLocationRelativeTo((Component)((Object)pos));
            }
        };
    }

    public static AbstractAction getClassesEditAction(final Positionable pos, final String title, final Editor editor) {
        return new AbstractAction(Bundle.getMessage(title) + "..."){

            @Override
            public void actionPerformed(ActionEvent e) {
                CoordinateEdit f = new CoordinateEdit();
                f.addHelpMenu("package.jmri.jmrit.display.CoordinateEdit", true);
                f.init(Bundle.getMessage(title), pos, false);
                f.initClasses(editor);
                f.setVisible(true);
                f.setLocationRelativeTo((Component)((Object)pos));
            }
        };
    }

    public static AbstractAction getTextEditAction(final Positionable pos, final String title) {
        return new AbstractAction(Bundle.getMessage(title) + "..."){

            @Override
            public void actionPerformed(ActionEvent e) {
                CoordinateEdit f = new CoordinateEdit();
                f.addHelpMenu("package.jmri.jmrit.display.CoordinateEdit", true);
                f.init(Bundle.getMessage(title), pos, false);
                f.initText();
                f.setVisible(true);
                f.setLocationRelativeTo((Component)((Object)pos));
            }
        };
    }

    public static AbstractAction getLinkEditAction(final Positionable pos, final String title) {
        return new AbstractAction(Bundle.getMessage(title) + "..."){

            @Override
            public void actionPerformed(ActionEvent e) {
                CoordinateEdit f = new CoordinateEdit();
                f.addHelpMenu("package.jmri.jmrit.display.CoordinateEdit", true);
                f.init(Bundle.getMessage(title), pos, false);
                f.initLink();
                f.setVisible(true);
                f.setLocationRelativeTo((Component)((Object)pos));
            }
        };
    }

    public static AbstractAction getZoomEditAction(final Positionable pos) {
        return new AbstractAction(Bundle.getMessage("Zoom", "...")){

            @Override
            public void actionPerformed(ActionEvent e) {
                CoordinateEdit f = new CoordinateEdit();
                f.addHelpMenu("package.jmri.jmrit.display.CoordinateEdit", true);
                f.init(Bundle.getMessage("Zoom", ""), pos, false);
                f.initZoom();
                f.setVisible(true);
                f.setLocationRelativeTo(pos.getEditor().getTargetPanel());
            }
        };
    }

    public static AbstractAction getNameEditAction(final Positionable pos) {
        return new AbstractAction(Bundle.getMessage("renamePanelMenu", "...")){

            @Override
            public void actionPerformed(ActionEvent e) {
                CoordinateEdit f = new CoordinateEdit();
                f.addHelpMenu("package.jmri.jmrit.display.CoordinateEdit", true);
                f.init(Bundle.getMessage("renamePanelMenu", ""), pos, false);
                f.initSetName();
                f.setVisible(true);
                f.setLocationRelativeTo(pos.getEditor().getTargetPanel());
            }
        };
    }

    public CoordinateEdit() {
        super(false, false);
    }

    @Override
    public void windowClosed(WindowEvent e) {
        super.windowClosed(e);
    }

    public void init(String title, Positionable pos, boolean showName) {
        this.pl = pos;
        if (showName) {
            this.nameText.setText(MessageFormat.format(Bundle.getMessage("namelabel"), pos.getNameString()));
            this.nameText.setVisible(true);
        }
        this.okButton.setText(Bundle.getMessage("ButtonOK"));
        this.okButton.setVisible(true);
        this.cancelButton.setText(Bundle.getMessage("ButtonCancel"));
        this.cancelButton.setVisible(true);
        Dimension dim = new JButton("XXXXXXXX").getPreferredSize();
        this.okButton.setMinimumSize(dim);
        this.cancelButton.setMinimumSize(dim);
        this.setTitle(title);
    }

    public void initSetXY() {
        this.oldX = this.pl.getX();
        this.oldY = this.pl.getY();
        this.textX = new JLabel();
        this.textX.setText("X: " + this.pl.getX());
        this.textX.setVisible(true);
        this.textY = new JLabel();
        this.textY.setText("Y: " + this.pl.getY());
        this.textY.setVisible(true);
        SpinnerNumberModel model = new SpinnerNumberModel(0, 0, 10000, 1);
        ChangeListener listener = e -> {
            int x = ((Number)this.spinX.getValue()).intValue();
            int y = ((Number)this.spinY.getValue()).intValue();
            this.pl.setLocation(x, y);
            this.textX.setText("X: " + this.pl.getX());
            this.textY.setText("Y: " + this.pl.getY());
        };
        this.spinX = new JSpinner(model);
        this.spinX.setValue(this.pl.getX());
        this.spinX.setToolTipText(Bundle.getMessage("EnterXcoord"));
        this.spinX.setMaximumSize(new Dimension(this.spinX.getMaximumSize().width, this.spinX.getPreferredSize().height));
        this.spinX.addChangeListener(listener);
        model = new SpinnerNumberModel(0, 0, 10000, 1);
        this.spinY = new JSpinner(model);
        this.spinY.setValue(this.pl.getY());
        this.spinY.setToolTipText(Bundle.getMessage("EnterYcoord"));
        this.spinY.setMaximumSize(new Dimension(this.spinY.getMaximumSize().width, this.spinY.getPreferredSize().height));
        this.spinY.addChangeListener(listener);
        this.getContentPane().setLayout(new GridBagLayout());
        this.addSpinItems(true);
        this.okButton.addActionListener(e -> {
            int x = ((Number)this.spinX.getValue()).intValue();
            int y = ((Number)this.spinY.getValue()).intValue();
            this.pl.setLocation(x, y);
            this.textX.setText("X: " + this.pl.getX());
            this.textY.setText("Y: " + this.pl.getY());
            this.dispose();
        });
        this.okButton.getRootPane().setDefaultButton(this.okButton);
        this.cancelButton.addActionListener(e -> {
            this.pl.setLocation(this.oldX, this.oldY);
            this.dispose();
        });
        this.setMinimumSize(new Dimension(250, 175));
        this.pack();
    }

    public void initSetLevel() {
        this.oldX = this.pl.getDisplayLevel();
        this.textX = new JLabel();
        this.textX.setText(Bundle.getMessage("Level") + ": " + this.pl.getDisplayLevel());
        this.textX.setVisible(true);
        SpinnerNumberModel model = new SpinnerNumberModel(0, 0, 10, 1);
        this.spinX = new JSpinner(model);
        this.spinX.setValue(this.pl.getDisplayLevel());
        this.spinX.setToolTipText(Bundle.getMessage("EnterLevel"));
        this.spinX.setMaximumSize(new Dimension(this.spinX.getMaximumSize().width, this.spinX.getPreferredSize().height));
        this.getContentPane().setLayout(new GridBagLayout());
        this.addSpinItems(false);
        this.okButton.addActionListener(e -> {
            int l = ((Number)this.spinX.getValue()).intValue();
            this.pl.getEditor().setSelectionsDisplayLevel(l, this.pl);
            this.textX.setText(Bundle.getMessage("Level") + ": " + l);
            this.dispose();
        });
        this.okButton.getRootPane().setDefaultButton(this.okButton);
        this.cancelButton.addActionListener(e -> {
            this.pl.getEditor().setSelectionsDisplayLevel(this.oldX, this.pl);
            this.dispose();
        });
        this.setMinimumSize(new Dimension(250, 175));
        this.pack();
    }

    public void initSetTip() {
        this.oldStr = this.pl.getToolTip().getText();
        this.textX = new JLabel();
        this.textX.setText(Bundle.getMessage("TooltipLabel") + ": ");
        this.textX.setVisible(true);
        this.xTextField = new JTextField(15);
        this.xTextField.setText(this.pl.getToolTip().getText());
        this.xTextField.setToolTipText(Bundle.getMessage("EnterTooltip"));
        this.getContentPane().setLayout(new GridBagLayout());
        this.addTextItems();
        this.okButton.addActionListener(e -> {
            this.pl.getToolTip().setText(this.xTextField.getText());
            this.dispose();
        });
        this.okButton.getRootPane().setDefaultButton(this.okButton);
        this.cancelButton.addActionListener(e -> {
            this.pl.getToolTip().setText(this.oldStr);
            this.dispose();
        });
        this.pack();
    }

    public void initBorder() {
        PositionablePopupUtil util = this.pl.getPopupUtility();
        this.oldX = util.getBorderSize();
        this.textX = new JLabel();
        this.textX.setText(Bundle.getMessage("Border") + ": " + util.getBorderSize());
        this.textX.setVisible(true);
        SpinnerNumberModel model = new SpinnerNumberModel(0, 0, 1000, 1);
        this.spinX = new JSpinner(model);
        this.spinX.setValue(util.getBorderSize());
        this.spinX.setToolTipText("Enter border size");
        this.spinX.setMaximumSize(new Dimension(this.spinX.getMaximumSize().width, this.spinX.getPreferredSize().height));
        this.getContentPane().setLayout(new GridBagLayout());
        this.addSpinItems(false);
        this.okButton.addActionListener(e -> {
            int l = ((Number)this.spinX.getValue()).intValue();
            PositionablePopupUtil util1 = this.pl.getPopupUtility();
            util1.setBorderSize(l);
            this.pl.getEditor().setAttributes(util1, this.pl);
            this.textX.setText(Bundle.getMessage("Border") + ": " + l);
            this.dispose();
        });
        this.okButton.getRootPane().setDefaultButton(this.okButton);
        this.cancelButton.addActionListener(e -> {
            this.pl.getPopupUtility().setBorderSize(this.oldX);
            this.dispose();
        });
        this.pack();
    }

    public void initMargin() {
        PositionablePopupUtil util = this.pl.getPopupUtility();
        this.oldX = util.getMargin();
        this.textX = new JLabel();
        this.textX.setText(Bundle.getMessage("Margin") + ": " + util.getMargin());
        this.textX.setVisible(true);
        SpinnerNumberModel model = new SpinnerNumberModel(0, 0, 1000, 1);
        this.spinX = new JSpinner(model);
        this.spinX.setValue(util.getMargin());
        this.spinX.setToolTipText("Enter margin size");
        this.spinX.setMaximumSize(new Dimension(this.spinX.getMaximumSize().width, this.spinX.getPreferredSize().height));
        this.getContentPane().setLayout(new GridBagLayout());
        this.addSpinItems(false);
        this.okButton.addActionListener(e -> {
            int l = ((Number)this.spinX.getValue()).intValue();
            PositionablePopupUtil util1 = this.pl.getPopupUtility();
            this.pl.getPopupUtility().setMargin(l);
            this.pl.getEditor().setAttributes(util1, this.pl);
            this.textX.setText(Bundle.getMessage("Margin") + ": " + l);
            this.dispose();
        });
        this.okButton.getRootPane().setDefaultButton(this.okButton);
        this.cancelButton.addActionListener(e -> {
            this.pl.getPopupUtility().setMargin(this.oldX);
            this.dispose();
        });
        this.pack();
    }

    public void initFixedSize() {
        PositionablePopupUtil util = this.pl.getPopupUtility();
        this.oldX = util.getFixedHeight();
        this.oldY = util.getFixedWidth();
        this.textX = new JLabel();
        this.textX.setText("Height = " + util.getFixedHeight());
        this.textX.setVisible(true);
        this.textY = new JLabel();
        this.textY.setText("Width = " + util.getFixedWidth());
        this.textY.setVisible(true);
        SpinnerNumberModel model = new SpinnerNumberModel(0, 0, 1000, 1);
        this.spinX = new JSpinner(model);
        this.spinX.setValue(util.getFixedHeight());
        this.spinX.setToolTipText(Bundle.getMessage("FixedSizeHeight"));
        this.spinX.setMaximumSize(new Dimension(this.spinX.getMaximumSize().width, this.spinX.getPreferredSize().height));
        model = new SpinnerNumberModel(0, 0, 1000, 1);
        this.spinY = new JSpinner(model);
        this.spinY.setValue(util.getFixedWidth());
        this.spinY.setToolTipText(Bundle.getMessage("FixedSizeWidth"));
        this.spinY.setMaximumSize(new Dimension(this.spinY.getMaximumSize().width, this.spinY.getPreferredSize().height));
        this.getContentPane().setLayout(new GridBagLayout());
        this.addSpinItems(true);
        this.okButton.addActionListener(e -> {
            int height = ((Number)this.spinX.getValue()).intValue();
            int width = ((Number)this.spinY.getValue()).intValue();
            PositionablePopupUtil util1 = this.pl.getPopupUtility();
            util1.setFixedSize(width, height);
            this.pl.getEditor().setAttributes(util1, this.pl);
            this.textX.setText("Height: " + util1.getFixedHeight());
            this.textY.setText("Width: " + util1.getFixedWidth());
            this.dispose();
        });
        this.okButton.getRootPane().setDefaultButton(this.okButton);
        this.cancelButton.addActionListener(e -> {
            this.pl.getPopupUtility().setFixedSize(this.oldY, this.oldX);
            this.dispose();
        });
        this.pack();
    }

    public void initRotate() {
        this.oldX = this.pl.getDegrees();
        this.textX = new JLabel();
        int deg = this.oldX;
        this.textX.setText(MessageFormat.format(Bundle.getMessage("Angle"), deg));
        this.textX.setVisible(true);
        SpinnerNumberModel model = new SpinnerNumberModel(0, -360, 360, 1);
        this.spinX = new JSpinner(model);
        this.spinX.setValue(deg);
        this.spinX.setToolTipText(Bundle.getMessage("enterDegrees"));
        this.spinX.setMaximumSize(new Dimension(this.spinX.getMaximumSize().width, this.spinX.getPreferredSize().height));
        this.getContentPane().setLayout(new GridBagLayout());
        this.addSpinItems(false);
        this.okButton.addActionListener(e -> {
            int k = ((Number)this.spinX.getValue()).intValue();
            this.pl.getEditor().setSelectionsRotation(k, this.pl);
            this.textX.setText(MessageFormat.format(Bundle.getMessage("Angle"), k));
            this.dispose();
        });
        this.okButton.getRootPane().setDefaultButton(this.okButton);
        this.cancelButton.addActionListener(e -> this.dispose());
        this.pack();
    }

    public void initScale() {
        this.oldD = this.pl.getScale();
        log.debug("initScale oldD = {}", (Object)this.oldD);
        log.trace("  pl = {}", (Object)this.pl);
        this.textX = new JLabel();
        this.textX.setText(MessageFormat.format(Bundle.getMessage("Scale"), this.oldD * 100.0));
        this.textX.setVisible(true);
        SpinnerNumberModel model = new SpinnerNumberModel(100.0, 10.0, 5000.0, 1.0);
        this.spinX = new JSpinner(model);
        log.debug("scale%= {}", (Object)((int)Math.round(this.oldD * 100.0)));
        this.spinX.setValue(Math.round(this.oldD * 100.0));
        this.spinX.setToolTipText(Bundle.getMessage("enterScale"));
        this.spinX.setMaximumSize(new Dimension(this.spinX.getMaximumSize().width, this.spinX.getPreferredSize().height));
        this.getContentPane().setLayout(new GridBagLayout());
        this.addSpinItems(false);
        this.okButton.addActionListener(e -> {
            double s = ((Number)this.spinX.getValue()).doubleValue() / 100.0 * this.pl.getScale();
            this.pl.getEditor().setSelectionsScale(s, this.pl);
            this.textX.setText(MessageFormat.format(Bundle.getMessage("Scale"), this.pl.getScale() * 100.0));
            this.dispose();
        });
        this.okButton.getRootPane().setDefaultButton(this.okButton);
        this.cancelButton.addActionListener(e -> this.dispose());
        this.pack();
    }

    public void initId(Editor editor) {
        PositionableLabel pLabel = (PositionableLabel)this.pl;
        this.oldStr = pLabel.getId();
        this.textX = new JLabel();
        this.textX.setText(Bundle.getMessage("EnterId") + ":");
        this.textX.setVisible(true);
        this.xTextField = new JTextField(15);
        this.xTextField.setText(pLabel.getId());
        this.xTextField.setToolTipText(Bundle.getMessage("TooltipEnterId"));
        this.getContentPane().setLayout(new GridBagLayout());
        this.addTextItems();
        this.okButton.addActionListener(e -> {
            boolean hasText;
            PositionableLabel pp = (PositionableLabel)this.pl;
            String t = this.xTextField.getText();
            boolean bl = hasText = t != null && t.length() > 0;
            if (hasText) {
                try {
                    pp.setId(t);
                    pp.updateSize();
                    this.dispose();
                }
                catch (Positionable.DuplicateIdException ignore) {
                    JmriJOptionPane.showMessageDialog(editor, Bundle.getMessage("ErrorIdNotUnique"), Bundle.getMessage("ErrorDialog"), 0);
                }
            } else {
                try {
                    pp.setId(null);
                    pp.updateSize();
                    this.dispose();
                }
                catch (Positionable.DuplicateIdException ex) {
                    log.error("Positionable.setId(null) has thrown DuplicateIdException", (Throwable)ex);
                }
            }
        });
        this.okButton.getRootPane().setDefaultButton(this.okButton);
        this.cancelButton.addActionListener(e -> {
            PositionableLabel pp = (PositionableLabel)this.pl;
            pp.updateSize();
            this.dispose();
        });
        this.pack();
    }

    public void initClasses(Editor editor) {
        PositionableLabel pLabel = (PositionableLabel)this.pl;
        this.oldStr = String.join((CharSequence)",", pLabel.getClasses());
        this.textX = new JLabel();
        this.textX.setText(Bundle.getMessage("EnterClasses") + ":");
        this.textX.setVisible(true);
        this.xTextField = new JTextField(15);
        this.xTextField.setText(this.oldStr);
        this.xTextField.setToolTipText(Bundle.getMessage("TooltipEnterClasses"));
        this.getContentPane().setLayout(new GridBagLayout());
        this.addTextItems();
        this.okButton.addActionListener(e -> {
            PositionableLabel pp = (PositionableLabel)this.pl;
            pp.removeAllClasses();
            String t = this.xTextField.getText();
            if (t != null && t.length() > 0) {
                for (String className : t.split(",")) {
                    if (className.isBlank()) continue;
                    pp.addClass(className.trim());
                }
            }
            pp.updateSize();
            this.dispose();
        });
        this.okButton.getRootPane().setDefaultButton(this.okButton);
        this.cancelButton.addActionListener(e -> {
            PositionableLabel pp = (PositionableLabel)this.pl;
            pp.updateSize();
            this.dispose();
        });
        this.pack();
    }

    public void initText() {
        PositionableLabel pLabel = (PositionableLabel)this.pl;
        this.oldStr = pLabel.getUnRotatedText();
        this.textX = new JLabel();
        this.textX.setText(Bundle.getMessage("TextLabel") + ":");
        this.textX.setVisible(true);
        this.xTextField = new JTextField(15);
        this.xTextField.setText(pLabel.getUnRotatedText());
        this.xTextField.setToolTipText(Bundle.getMessage("TooltipEnterText"));
        this.getContentPane().setLayout(new GridBagLayout());
        this.addTextItems();
        this.okButton.addActionListener(e -> {
            boolean hasText;
            PositionableLabel pp = (PositionableLabel)this.pl;
            String t = this.xTextField.getText();
            boolean bl = hasText = t != null && t.length() > 0;
            if (pp.isIcon() || hasText) {
                pp._text = hasText;
                if (pp instanceof SensorIcon) {
                    ((SensorIcon)pp).setOriginalText(t);
                }
                pp.setText(t);
                pp.updateSize();
                this.dispose();
            } else {
                this.xTextField.setText(Bundle.getMessage("warningNullText"));
            }
        });
        this.okButton.getRootPane().setDefaultButton(this.okButton);
        this.cancelButton.addActionListener(e -> {
            PositionableLabel pp = (PositionableLabel)this.pl;
            pp.setText(this.oldStr);
            pp.updateSize();
            this.dispose();
        });
        this.pack();
    }

    public void initLink() {
        LinkingObject pLabel = (LinkingObject)((Object)this.pl);
        this.oldStr = pLabel.getURL();
        this.textX = new JLabel();
        this.textX.setText(Bundle.getMessage("LinkEqual"));
        this.textX.setVisible(true);
        this.xTextField = new JTextField(15);
        this.xTextField.setText(pLabel.getURL());
        this.xTextField.setToolTipText(Bundle.getMessage("EnterLink"));
        this.getContentPane().setLayout(new GridBagLayout());
        this.addTextItems();
        this.oldX = 0;
        this.okButton.addActionListener(e -> {
            boolean hasText;
            LinkingObject pp = (LinkingObject)((Object)this.pl);
            String t = this.xTextField.getText();
            boolean bl = hasText = t != null && t.length() > 0;
            if (hasText || this.oldX > 0) {
                pp.setULRL(t);
                pp.updateSize();
                this.dispose();
            } else {
                this.xTextField.setText("Link disappears with null text!");
                ++this.oldX;
            }
        });
        this.okButton.getRootPane().setDefaultButton(this.okButton);
        this.cancelButton.addActionListener(e -> {
            LinkingObject pp = (LinkingObject)((Object)this.pl);
            pp.setULRL(this.oldStr);
            pp.updateSize();
            this.dispose();
        });
        this.pack();
    }

    public void initZoom() {
        this.oldD = this.pl.getScale();
        log.debug("initZoom oldD = {}", (Object)this.oldD);
        log.trace("  pl = {}", (Object)this.pl);
        this.textX = new JLabel();
        this.textX.setText(MessageFormat.format(Bundle.getMessage("Scale"), this.oldD * 100.0));
        this.textX.setVisible(true);
        SpinnerNumberModel model = new SpinnerNumberModel(100.0, 1.0, 5000.0, 1.0);
        this.spinX = new JSpinner(model);
        if (log.isDebugEnabled()) {
            log.debug("scale%= {}", (Object)((int)Math.round(this.oldD * 100.0)));
        }
        this.spinX.setToolTipText(Bundle.getMessage("enterZoom"));
        this.spinX.setMaximumSize(new Dimension(this.spinX.getMaximumSize().width, this.spinX.getPreferredSize().height));
        this.getContentPane().setLayout(new GridBagLayout());
        this.addSpinItems(false);
        this.okButton.addActionListener(e -> {
            double s = ((Number)this.spinX.getValue()).doubleValue() / 100.0;
            this.pl.setScale(s);
            this.pl.getEditor().setPaintScale(s);
            this.textX.setText(MessageFormat.format(Bundle.getMessage("Scale"), this.pl.getScale() * 100.0));
            this.dispose();
        });
        this.okButton.getRootPane().setDefaultButton(this.okButton);
        this.cancelButton.addActionListener(e -> this.dispose());
        this.pack();
    }

    public void initSetName() {
        this.oldStr = this.pl.getEditor().getName();
        this.textX = new JLabel();
        this.textX.setText(MessageFormat.format(Bundle.getMessage("namelabel"), this.oldStr));
        this.textX.setVisible(true);
        this.xTextField = new JTextField(15);
        this.xTextField.setText(this.oldStr);
        this.xTextField.setToolTipText(Bundle.getMessage("PromptNewName"));
        this.getContentPane().setLayout(new GridBagLayout());
        this.addTextItems();
        this.okButton.addActionListener(e -> {
            String t = this.xTextField.getText();
            Editor ed = this.pl.getEditor();
            ed.setName(t);
            ed.setTitle();
            this.textX.setText(MessageFormat.format(Bundle.getMessage("namelabel"), t));
            this.dispose();
        });
        this.okButton.getRootPane().setDefaultButton(this.okButton);
        this.cancelButton.addActionListener(e -> {
            this.pl.getEditor().setName(this.oldStr);
            this.dispose();
        });
        this.pack();
    }

    protected void addSpinItems(boolean addY) {
        this.addItem(this.nameText, 0, 0, 2, true);
        this.addItem(this.textX, 0, 1, 1, true);
        this.addItem(this.spinX, 1, 1, 1, false);
        if (addY) {
            this.addItem(this.textY, 0, 2, 1, true);
            this.addItem(this.spinY, 1, 2, 1, false);
            this.addItem(this.cancelButton, 0, 3, 1, false);
            this.addItem(this.okButton, 1, 3, 1, false);
        } else {
            this.addItem(this.cancelButton, 0, 2, 1, false);
            this.addItem(this.okButton, 1, 2, 1, false);
        }
        this.validate();
    }

    private void addTextItems() {
        this.addItem(this.nameText, 0, 0, 2, true);
        this.addItem(this.textX, 0, 1, 1, true);
        this.addItem(this.xTextField, 1, 1, 1, true);
        this.addItem(this.cancelButton, 0, 2, 1, false);
        this.addItem(this.okButton, 1, 2, 1, false);
        this.validate();
    }

    private void addItem(JComponent c, int x, int y, int w, boolean horzExpand) {
        GridBagConstraints gc = new GridBagConstraints();
        gc.gridx = x;
        gc.gridy = y;
        gc.gridwidth = w;
        gc.weightx = 100.0;
        gc.weighty = 100.0;
        gc.anchor = 10;
        if (horzExpand) {
            gc.fill = 2;
        }
        this.getContentPane().add((Component)c, gc);
    }
}

