/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.display;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import jmri.jmrit.display.Editor;
import jmri.util.JmriJFrame;
import jmri.util.swing.DrawSquares;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DisplayFrame
extends JmriJFrame {
    static Color _grayColor = new Color(235, 235, 235);
    static Color _darkGrayColor = new Color(150, 150, 150);
    static final Color[] colorChoice = new Color[]{Color.white, _grayColor, _darkGrayColor};
    private BufferedImage[] _backgrounds;
    private Editor _editor;
    private Color _panelBackground;
    private int previewBgIndex = 0;
    private static final Logger log = LoggerFactory.getLogger(DisplayFrame.class);

    public DisplayFrame(boolean saveSize, boolean savePosition) {
        super(saveSize, savePosition);
    }

    public DisplayFrame(String name, boolean saveSize, boolean savePosition) {
        super(name, saveSize, savePosition);
    }

    public DisplayFrame(String name, Editor editor) {
        super(name, false, false);
        this._editor = editor;
        this.makeBackgrounds();
    }

    public DisplayFrame() {
        this(true, true);
    }

    public DisplayFrame(String name) {
        this(name, true, true);
    }

    public void setPreviewBg(int index) {
        this.previewBgIndex = index;
    }

    public int getPreviewBg() {
        return this.previewBgIndex;
    }

    public BufferedImage getPreviewBackground() {
        return this._backgrounds[this.previewBgIndex];
    }

    public Color getCurrentColor() {
        return this._panelBackground;
    }

    public BufferedImage getBackground(int index) {
        return this._backgrounds[index];
    }

    public void updateBackground(Editor ed) {
        if (ed == null) {
            log.error("updateBackground called for a null editor!");
            return;
        }
        this._editor = ed;
        Color color = ed.getTargetPanel().getBackground();
        if (!color.equals(this._panelBackground)) {
            this._backgrounds[0] = DrawSquares.getImage(500, 400, 10, color, color);
            this._panelBackground = color;
            if (this.previewBgIndex == 0) {
                this.setPreviewBg(0);
            }
        }
    }

    public Editor getEditor() {
        return this._editor;
    }

    private void makeBackgrounds() {
        this._panelBackground = this._editor.getTargetPanel().getBackground();
        if (this._backgrounds == null) {
            this._backgrounds = new BufferedImage[5];
            for (int i = 1; i <= 3; ++i) {
                this._backgrounds[i] = DrawSquares.getImage(500, 400, 10, colorChoice[i - 1], colorChoice[i - 1]);
            }
            this._backgrounds[4] = DrawSquares.getImage(500, 400, 10, Color.white, _grayColor);
        }
        this._backgrounds[0] = DrawSquares.getImage(500, 400, 10, this._panelBackground, this._panelBackground);
        log.debug("makeBackgrounds backgrounds[0] = {}", (Object)this._backgrounds[0]);
    }

    public void reSize(Container container, Dimension deltaDim, Dimension newDim) {
        Dimension dim = new Dimension(deltaDim.width + newDim.width, deltaDim.height + newDim.height);
        container.setPreferredSize(dim);
        container.invalidate();
        if (log.isDebugEnabled()) {
            log.debug(" deltaDim= ({}, {}) NewDim= ({}, {}) setPreferredSize to ({}, {})", new Object[]{deltaDim.width, deltaDim.height, newDim.width, newDim.height, dim.width, dim.height});
        }
        this.pack();
        if (log.isDebugEnabled()) {
            dim = container.getSize();
            log.debug(" Resized to ({}, {})", (Object)dim.width, (Object)dim.height);
        }
    }
}

