/*
 * Decompiled with CFR 0.152.
 */
package jmri.jmrit.display;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.Timer;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.ListSelectionEvent;
import jmri.BlockManager;
import jmri.ConfigureManager;
import jmri.InstanceManager;
import jmri.Light;
import jmri.NamedBean;
import jmri.NamedBeanUsageReport;
import jmri.Reporter;
import jmri.ShutDownManager;
import jmri.SignalHeadManager;
import jmri.SignalMastManager;
import jmri.UserPreferencesManager;
import jmri.jmrit.catalog.CatalogPanel;
import jmri.jmrit.catalog.DirectorySearcher;
import jmri.jmrit.catalog.ImageIndexEditor;
import jmri.jmrit.catalog.NamedIcon;
import jmri.jmrit.display.AnalogClock2Display;
import jmri.jmrit.display.AudioIcon;
import jmri.jmrit.display.BlockContentsIcon;
import jmri.jmrit.display.Bundle;
import jmri.jmrit.display.CoordinateEdit;
import jmri.jmrit.display.EditorManager;
import jmri.jmrit.display.GlobalVariableIcon;
import jmri.jmrit.display.GlobalVariableInputIcon;
import jmri.jmrit.display.GlobalVariableSpinnerIcon;
import jmri.jmrit.display.IconAdder;
import jmri.jmrit.display.JmriJFrameWithPermissions;
import jmri.jmrit.display.LightIcon;
import jmri.jmrit.display.LocoIcon;
import jmri.jmrit.display.LogixNGDeleteDialog;
import jmri.jmrit.display.LogixNGIcon;
import jmri.jmrit.display.MemoryIcon;
import jmri.jmrit.display.MemoryIconCoordinateEdit;
import jmri.jmrit.display.MemoryInputIcon;
import jmri.jmrit.display.MemoryOrGVIcon;
import jmri.jmrit.display.MemorySpinnerIcon;
import jmri.jmrit.display.MultiSensorIcon;
import jmri.jmrit.display.MultiSensorIconAdder;
import jmri.jmrit.display.Positionable;
import jmri.jmrit.display.PositionableIcon;
import jmri.jmrit.display.PositionableJPanel;
import jmri.jmrit.display.PositionableLabel;
import jmri.jmrit.display.PositionablePopupUtil;
import jmri.jmrit.display.ReporterIcon;
import jmri.jmrit.display.RpsPositionIcon;
import jmri.jmrit.display.SensorIcon;
import jmri.jmrit.display.SignalHeadIcon;
import jmri.jmrit.display.SignalMastIcon;
import jmri.jmrit.display.SlipIconAdder;
import jmri.jmrit.display.SlipTurnoutIcon;
import jmri.jmrit.display.ToolTip;
import jmri.jmrit.display.TurnoutIcon;
import jmri.jmrit.display.controlPanelEditor.shape.PositionableShape;
import jmri.jmrit.logixng.LogixNG;
import jmri.jmrit.logixng.LogixNG_Manager;
import jmri.jmrit.logixng.LogixNG_UserPreferences;
import jmri.jmrit.logixng.tools.swing.DeleteBean;
import jmri.jmrit.logixng.tools.swing.LogixNGEditor;
import jmri.jmrit.operations.trains.TrainIcon;
import jmri.jmrit.picker.PickListModel;
import jmri.jmrit.roster.Roster;
import jmri.jmrit.roster.RosterEntry;
import jmri.jmrit.roster.swing.RosterEntrySelectorPanel;
import jmri.util.DnDStringImportHandler;
import jmri.util.JmriJFrame;
import jmri.util.swing.JmriColorChooser;
import jmri.util.swing.JmriJOptionPane;
import jmri.util.swing.JmriMouseEvent;
import jmri.util.swing.JmriMouseListener;
import jmri.util.swing.JmriMouseMotionListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Editor
extends JmriJFrameWithPermissions
implements JmriMouseListener,
JmriMouseMotionListener,
ActionListener,
KeyListener,
VetoableChangeListener {
    public static final int BKG = 1;
    public static final int TEMP = 2;
    public static final int ICONS = 3;
    public static final int LABELS = 4;
    public static final int MEMORIES = 5;
    public static final int REPORTERS = 5;
    public static final int SECURITY = 6;
    public static final int TURNOUTS = 7;
    public static final int LIGHTS = 8;
    public static final int SIGNALS = 9;
    public static final int SENSORS = 10;
    public static final int CLOCK = 10;
    public static final int MARKERS = 10;
    public static final int NUM_LEVELS = 10;
    public static final int SCROLL_NONE = 0;
    public static final int SCROLL_BOTH = 1;
    public static final int SCROLL_HORIZONTAL = 2;
    public static final int SCROLL_VERTICAL = 3;
    public static final Color HIGHLIGHT_COLOR = new Color(204, 207, 88);
    public static final String POSITIONABLE_FLAVOR = "application/x-java-jvm-local-objectref;class=jmri.jmrit.display.Positionable";
    private boolean _loadFailed = false;
    private ArrayList<Positionable> _contents = new ArrayList();
    private Map<String, Positionable> _idContents = new HashMap<String, Positionable>();
    private Map<String, Set<Positionable>> _classContents = new HashMap<String, Set<Positionable>>();
    protected JLayeredPane _targetPanel;
    private JFrame _targetFrame;
    private JScrollPane _panelScrollPane;
    protected int _scrollState = 0;
    protected boolean _editable = true;
    private boolean _positionable = true;
    private boolean _controlLayout = true;
    private boolean _showHidden = true;
    private boolean _showToolTip = true;
    public static final int OPTION_POSITION = 1;
    public static final int OPTION_CONTROLS = 2;
    public static final int OPTION_HIDDEN = 3;
    public static final int OPTION_TOOLTIP = 4;
    private boolean _globalSetsLocal = true;
    private boolean _useGlobalFlag = false;
    protected int _lastX;
    protected int _lastY;
    BasicStroke DASHED_LINE = new BasicStroke(1.0f, 0, 2, 10.0f, new float[]{10.0f, 10.0f}, 0.0f);
    protected Rectangle _selectRect = null;
    protected Rectangle _highlightcomponent = null;
    protected boolean _dragging = false;
    protected ArrayList<Positionable> _selectionGroup = null;
    protected Positionable _currentSelection;
    private ToolTip _defaultToolTip;
    private ToolTip _tooltip = null;
    protected int xLoc = 0;
    protected int yLoc = 0;
    protected int _anchorX;
    protected int _anchorY;
    protected double _paintScale = 1.0;
    protected Color defaultBackgroundColor = Color.lightGray;
    protected boolean _pastePending = false;
    protected HashMap<String, JFrameItem> _iconEditorFrame = new HashMap();
    private boolean panelMenuIsVisible = true;
    private boolean _inEditInlineLogixNGMode = false;
    private LogixNGEditor _inlineLogixNGEdit;
    NamedIcon _newIcon;
    boolean _ignore = false;
    boolean _delete;
    HashMap<String, String> _urlMap = new HashMap();
    private ToolTipTimer _tooltipTimer;
    static int TOOLTIPSHOWDELAY = 1000;
    static int TOOLTIPDISMISSDELAY = 4000;
    static final String[] ICON_EDITORS = new String[]{"Sensor", "RightTurnout", "LeftTurnout", "SlipTOEditor", "SignalHead", "SignalMast", "Memory", "Light", "Reporter", "Background", "MultiSensor", "Icon", "Text", "Block Contents"};
    public int frameLocationX = 0;
    public int frameLocationY = 0;
    static final int DELTA = 20;
    private final SpinnerNumberModel _spinCols = new SpinnerNumberModel(3, 1, 100, 1);
    public static final int VIEWPOPUPONLY = 0;
    public static final int EDITPOPUPONLY = 1;
    public static final int BOTHPOPUPS = 2;
    private static final Logger log = LoggerFactory.getLogger(Editor.class);

    public Editor() {
    }

    public Editor(String name, boolean saveSize, boolean savePosition) {
        super(name, saveSize, savePosition);
        this.setName(name);
        this._defaultToolTip = new ToolTip(null, 0, 0, null);
        this.setVisible(false);
        InstanceManager.getDefault(SignalHeadManager.class).addVetoableChangeListener(this);
        InstanceManager.getDefault(SignalMastManager.class).addVetoableChangeListener(this);
        InstanceManager.turnoutManagerInstance().addVetoableChangeListener(this);
        InstanceManager.sensorManagerInstance().addVetoableChangeListener(this);
        InstanceManager.memoryManagerInstance().addVetoableChangeListener(this);
        InstanceManager.getDefault(BlockManager.class).addVetoableChangeListener(this);
        InstanceManager.getDefault(EditorManager.class).add(this);
    }

    public Editor(String name) {
        this(name, true, true);
    }

    public void newPanelDefaults() {
        this.setBackgroundColor(Color.WHITE);
    }

    public void loadFailed() {
        this._loadFailed = true;
    }

    public NamedIcon loadFailed(String msg, String url) {
        String goodUrl;
        log.debug("loadFailed _ignore= {} {}", (Object)this._ignore, (Object)msg);
        if (this._urlMap == null) {
            this._urlMap = new HashMap();
        }
        if ((goodUrl = this._urlMap.get(url)) != null) {
            return NamedIcon.getIconByName(goodUrl);
        }
        if (this._ignore) {
            this._loadFailed = true;
            return NamedIcon.getIconByName(url);
        }
        this._newIcon = null;
        this._delete = false;
        new UrlErrorDialog(msg, url).setVisible(true);
        if (this._delete) {
            return null;
        }
        if (this._newIcon == null) {
            this._loadFailed = true;
            this._newIcon = NamedIcon.getIconByName(url);
        }
        return this._newIcon;
    }

    public void disposeLoadData() {
        this._urlMap = null;
    }

    public boolean loadOK() {
        return !this._loadFailed;
    }

    public List<Positionable> getContents() {
        return Collections.unmodifiableList(this._contents);
    }

    public Map<String, Positionable> getIdContents() {
        return Collections.unmodifiableMap(this._idContents);
    }

    public Set<String> getClassNames() {
        return Collections.unmodifiableSet(this._classContents.keySet());
    }

    public Set<Positionable> getPositionablesByClassName(String className) {
        Set<Positionable> set = this._classContents.get(className);
        if (set == null) {
            return null;
        }
        return Collections.unmodifiableSet(set);
    }

    public void setDefaultToolTip(ToolTip dtt) {
        this._defaultToolTip = dtt;
    }

    protected void setTargetPanel(JLayeredPane targetPanel, JmriJFrame frame) {
        this._targetPanel = targetPanel == null ? new TargetPane() : targetPanel;
        if (GraphicsEnvironment.isHeadless()) {
            this._panelScrollPane = null;
            this._targetFrame = null;
            return;
        }
        this._targetFrame = frame == null ? this : frame;
        this._targetFrame.setDefaultCloseOperation(1);
        this._panelScrollPane = new JScrollPane(this._targetPanel);
        Container contentPane = this._targetFrame.getContentPane();
        contentPane.add(this._panelScrollPane);
        this._targetFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                Editor.this.targetWindowClosingEvent(e);
            }
        });
        this._targetPanel.addMouseListener(JmriMouseListener.adapt(this));
        this._targetPanel.addMouseMotionListener(JmriMouseMotionListener.adapt(this));
        this._targetPanel.setFocusable(true);
        this._targetPanel.addKeyListener(this);
    }

    protected void setTargetPanelSize(int w, int h) {
        this._targetPanel.setSize(w, h);
        this._targetPanel.invalidate();
    }

    protected Dimension getTargetPanelSize() {
        return this._targetPanel.getSize();
    }

    public final JComponent getTargetPanel() {
        return this._targetPanel;
    }

    public final JScrollPane getPanelScrollPane() {
        return this._panelScrollPane;
    }

    public final JFrame getTargetFrame() {
        return this._targetFrame;
    }

    public Color getBackgroundColor() {
        if (this._targetPanel instanceof TargetPane) {
            TargetPane tmp = (TargetPane)this._targetPanel;
            return tmp.getBackgroundColor();
        }
        return null;
    }

    public void setBackgroundColor(Color col) {
        if (this._targetPanel instanceof TargetPane) {
            TargetPane tmp = (TargetPane)this._targetPanel;
            tmp.setBackgroundColor(col);
        }
        JmriColorChooser.addRecentColor(col);
    }

    public void clearBackgroundColor() {
        if (this._targetPanel instanceof TargetPane) {
            TargetPane tmp = (TargetPane)this._targetPanel;
            tmp.clearBackgroundColor();
        }
    }

    public final double getPaintScale() {
        return this._paintScale;
    }

    protected final void setPaintScale(double newScale) {
        double ratio = newScale / this._paintScale;
        this._paintScale = newScale;
        this.setScrollbarScale(ratio);
    }

    protected void setToolTip(ToolTip tt) {
        Positionable pos;
        if (tt != null && (pos = tt.getPositionable()) != null && pos.isHidden() && !this.isEditable()) {
            return;
        }
        if (tt == null) {
            this._tooltip = null;
            if (this._tooltipTimer != null) {
                this._tooltipTimer.stop();
                this._tooltipTimer = null;
                this._targetPanel.repaint();
            }
        } else if (this._tooltip == null && this._tooltipTimer == null) {
            log.debug("start :: tt = {}, tooltip = {}, timer = {}", new Object[]{tt, this._tooltip, this._tooltipTimer});
            this._tooltipTimer = new ToolTipTimer(TOOLTIPSHOWDELAY, this, tt);
            this._tooltipTimer.setRepeats(false);
            this._tooltipTimer.start();
        }
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (this._tooltipTimer != null) {
            this._tooltip = this._tooltipTimer.getToolTip();
            this._tooltipTimer.stop();
        }
        if (this._tooltip != null) {
            this._tooltipTimer = new ToolTipTimer(TOOLTIPDISMISSDELAY, this, null);
            this._tooltipTimer.setRepeats(false);
            this._tooltipTimer.start();
        } else {
            this._tooltipTimer = null;
        }
        this._targetPanel.repaint();
    }

    private void setScrollbarScale(double ratio) {
        Dimension dim = this._targetPanel.getSize();
        int tpWidth = (int)((double)dim.width * ratio);
        int tpHeight = (int)((double)dim.height * ratio);
        this._targetPanel.setSize(tpWidth, tpHeight);
        log.debug("setScrollbarScale: ratio= {}, tpWidth= {}, tpHeight= {}", new Object[]{ratio, tpWidth, tpHeight});
        JScrollBar horScroll = this._panelScrollPane.getHorizontalScrollBar();
        JScrollBar vertScroll = this._panelScrollPane.getVerticalScrollBar();
        int hScroll = (int)((double)horScroll.getValue() * ratio);
        int vScroll = (int)((double)vertScroll.getValue() * ratio);
        horScroll.setMaximum((int)((double)horScroll.getMaximum() * ratio));
        vertScroll.setMaximum((int)((double)vertScroll.getMaximum() * ratio));
        horScroll.setValue(hScroll);
        vertScroll.setValue(vScroll);
    }

    public void setAllEditable(boolean state) {
        this._editable = state;
        for (Positionable _content : this._contents) {
            _content.setEditable(state);
        }
        if (!this._editable) {
            this._highlightcomponent = null;
            this.deselectSelectionGroup();
        }
    }

    public void deselectSelectionGroup() {
        if (this._selectionGroup == null) {
            return;
        }
        for (Positionable p : this._selectionGroup) {
            if (!(p instanceof PositionableShape)) continue;
            PositionableShape s = (PositionableShape)p;
            s.removeHandles();
        }
        this._selectionGroup = null;
    }

    public boolean isEditable() {
        return this._editable;
    }

    public void setUseGlobalFlag(boolean set) {
        this._useGlobalFlag = set;
    }

    public boolean useGlobalFlag() {
        return this._useGlobalFlag;
    }

    public boolean getFlag(int whichOption, boolean localFlag) {
        if (this._useGlobalFlag) {
            switch (whichOption) {
                case 1: {
                    return this._positionable;
                }
                case 2: {
                    return this._controlLayout;
                }
                case 3: {
                    return this._showHidden;
                }
                case 4: {
                    return this._showToolTip;
                }
            }
            log.warn("Unhandled which option code: {}", (Object)whichOption);
        }
        return localFlag;
    }

    public void setGlobalSetsLocalFlag(boolean set) {
        this._globalSetsLocal = set;
    }

    public void setAllPositionable(boolean state) {
        this._positionable = state;
        if (this._globalSetsLocal) {
            for (Positionable p : this._contents) {
                if (state && p.getDisplayLevel() == 1) continue;
                p.setPositionable(state);
            }
        }
    }

    public boolean allPositionable() {
        return this._positionable;
    }

    public void setAllControlling(boolean state) {
        this._controlLayout = state;
        if (this._globalSetsLocal) {
            for (Positionable _content : this._contents) {
                _content.setControlling(state);
            }
        }
    }

    public boolean allControlling() {
        return this._controlLayout;
    }

    public void setShowHidden(boolean state) {
        this._showHidden = state;
        if (this._showHidden) {
            for (Positionable _content : this._contents) {
                _content.setVisible(true);
            }
        } else {
            for (Positionable _content : this._contents) {
                _content.showHidden();
            }
        }
    }

    public boolean showHidden() {
        return this._showHidden;
    }

    public void setAllShowToolTip(boolean state) {
        this._showToolTip = state;
        for (Positionable _content : this._contents) {
            _content.setShowToolTip(state);
        }
    }

    public boolean showToolTip() {
        return this._showToolTip;
    }

    public void setPanelMenuVisible(boolean state) {
        this.panelMenuIsVisible = state;
        if (!GraphicsEnvironment.isHeadless() && this._targetFrame != null) {
            this._targetFrame.getJMenuBar().setVisible(state);
            this.revalidate();
        }
    }

    public boolean isPanelMenuVisible() {
        if (!GraphicsEnvironment.isHeadless() && this._targetFrame != null) {
            this.panelMenuIsVisible = this._targetFrame.getJMenuBar().isVisible();
        }
        return this.panelMenuIsVisible;
    }

    protected void setScroll(int state) {
        log.debug("setScroll {}", (Object)state);
        switch (state) {
            case 0: {
                this._panelScrollPane.setVerticalScrollBarPolicy(21);
                this._panelScrollPane.setHorizontalScrollBarPolicy(31);
                break;
            }
            case 1: {
                this._panelScrollPane.setVerticalScrollBarPolicy(22);
                this._panelScrollPane.setHorizontalScrollBarPolicy(32);
                break;
            }
            case 2: {
                this._panelScrollPane.setVerticalScrollBarPolicy(21);
                this._panelScrollPane.setHorizontalScrollBarPolicy(32);
                break;
            }
            case 3: {
                this._panelScrollPane.setVerticalScrollBarPolicy(22);
                this._panelScrollPane.setHorizontalScrollBarPolicy(31);
                break;
            }
            default: {
                log.warn("Unexpected  setScroll state of {}", (Object)state);
            }
        }
        this._scrollState = state;
    }

    public void setScroll(String strState) {
        int state = 1;
        if (strState.equalsIgnoreCase("none") || strState.equalsIgnoreCase("no")) {
            state = 0;
        } else if (strState.equals("horizontal")) {
            state = 2;
        } else if (strState.equals("vertical")) {
            state = 3;
        }
        log.debug("setScroll: strState= {}, state= {}", (Object)strState, (Object)state);
        this.setScroll(state);
    }

    public String getScrollable() {
        String value = "";
        switch (this._scrollState) {
            case 0: {
                value = "none";
                break;
            }
            case 1: {
                value = "both";
                break;
            }
            case 2: {
                value = "horizontal";
                break;
            }
            case 3: {
                value = "vertical";
                break;
            }
            default: {
                log.warn("Unexpected _scrollState of {}", (Object)this._scrollState);
            }
        }
        return value;
    }

    protected void targetWindowClosing() {
        String name = this._targetFrame.getTitle();
        if (!InstanceManager.getDefault(ShutDownManager.class).isShuttingDown()) {
            InstanceManager.getDefault(UserPreferencesManager.class).showInfoMessage(Bundle.getMessage("PanelHideTitle"), Bundle.getMessage("PanelHideNotice", name), "jmri.jmrit.display.EditorManager", "skipHideDialog");
            InstanceManager.getDefault(UserPreferencesManager.class).setPreferenceItemDetails("jmri.jmrit.display.EditorManager", "skipHideDialog", Bundle.getMessage("PanelHideSkip"));
        }
    }

    protected Editor changeView(String className) {
        JFrame frame = this.getTargetFrame();
        try {
            Editor ed = (Editor)Class.forName(className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            ed.setName(this.getName());
            ed.init(this.getName());
            ed._contents = new ArrayList<Positionable>(this._contents);
            ed._idContents = new HashMap<String, Positionable>(this._idContents);
            ed._classContents = new HashMap<String, Set<Positionable>>(this._classContents);
            for (Positionable p : this._contents) {
                p.setEditor(ed);
                ed.addToTarget(p);
                if (!log.isDebugEnabled()) continue;
                log.debug("changeView: {} addToTarget class= {}", (Object)p.getNameString(), (Object)p.getClass().getName());
            }
            ed.setAllEditable(this.isEditable());
            ed.setAllShowToolTip(this.showToolTip());
            ed.setShowHidden(this.isVisible());
            ed.setPanelMenuVisible(frame.getJMenuBar().isVisible());
            ed.setScroll(this.getScrollable());
            ed.setTitle();
            ed.setBackgroundColor(this.getBackgroundColor());
            ed.getTargetFrame().setLocation(frame.getLocation());
            ed.getTargetFrame().setSize(frame.getSize());
            ed.setSize(this.getSize());
            ed.setVisible(true);
            this.dispose();
            InstanceManager.getDefault(EditorManager.class).add(ed);
            return ed;
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException cnfe) {
            log.error("changeView exception {}", (Object)cnfe.toString());
            return null;
        }
    }

    public void setPositionableMenu(Positionable p, JPopupMenu popup) {
        JCheckBoxMenuItem lockItem = new JCheckBoxMenuItem(Bundle.getMessage("LockPosition"));
        lockItem.setSelected(!p.isPositionable());
        lockItem.addActionListener(new ActionListener(){
            private Positionable comp;
            private JCheckBoxMenuItem checkBox;

            @Override
            public void actionPerformed(ActionEvent e) {
                this.comp.setPositionable(!this.checkBox.isSelected());
                Editor.this.setSelectionsPositionable(!this.checkBox.isSelected(), this.comp);
            }

            ActionListener init(Positionable pos, JCheckBoxMenuItem cb) {
                this.comp = pos;
                this.checkBox = cb;
                return this;
            }
        }.init(p, lockItem));
        popup.add(lockItem);
    }

    public boolean setShowCoordinatesMenu(Positionable p, JPopupMenu popup) {
        JMenuItem edit;
        if (p instanceof MemoryOrGVIcon && p.getPopupUtility().getFixedWidth() == 0) {
            MemoryOrGVIcon pm = (MemoryOrGVIcon)p;
            edit = new JMenuItem(Bundle.getMessage("EditLocationXY", pm.getOriginalX(), pm.getOriginalY()));
            edit.addActionListener(MemoryIconCoordinateEdit.getCoordinateEditAction(pm));
        } else {
            edit = new JMenuItem(Bundle.getMessage("EditLocationXY", p.getX(), p.getY()));
            edit.addActionListener(CoordinateEdit.getCoordinateEditAction(p));
        }
        popup.add(edit);
        return true;
    }

    public boolean setShowAlignmentMenu(Positionable p, JPopupMenu popup) {
        if (this.showAlignPopup(p)) {
            JMenu edit = new JMenu(Bundle.getMessage("EditAlignment"));
            edit.add(new AbstractAction(Bundle.getMessage("AlignX")){
                private int _x;

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (Editor.this._selectionGroup == null) {
                        return;
                    }
                    for (Positionable comp : Editor.this._selectionGroup) {
                        if (!Editor.this.getFlag(1, comp.isPositionable())) continue;
                        comp.setLocation(this._x, comp.getY());
                    }
                }

                AbstractAction init(int x) {
                    this._x = x;
                    return this;
                }
            }.init(p.getX()));
            edit.add(new AbstractAction(Bundle.getMessage("AlignMiddleX")){
                private int _x;

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (Editor.this._selectionGroup == null) {
                        return;
                    }
                    for (Positionable comp : Editor.this._selectionGroup) {
                        if (!Editor.this.getFlag(1, comp.isPositionable())) continue;
                        comp.setLocation(this._x - comp.getWidth() / 2, comp.getY());
                    }
                }

                AbstractAction init(int x) {
                    this._x = x;
                    return this;
                }
            }.init(p.getX() + p.getWidth() / 2));
            edit.add(new AbstractAction(Bundle.getMessage("AlignOtherX")){
                private int _x;

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (Editor.this._selectionGroup == null) {
                        return;
                    }
                    for (Positionable comp : Editor.this._selectionGroup) {
                        if (!Editor.this.getFlag(1, comp.isPositionable())) continue;
                        comp.setLocation(this._x - comp.getWidth(), comp.getY());
                    }
                }

                AbstractAction init(int x) {
                    this._x = x;
                    return this;
                }
            }.init(p.getX() + p.getWidth()));
            edit.add(new AbstractAction(Bundle.getMessage("AlignY")){
                private int _y;

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (Editor.this._selectionGroup == null) {
                        return;
                    }
                    for (Positionable comp : Editor.this._selectionGroup) {
                        if (!Editor.this.getFlag(1, comp.isPositionable())) continue;
                        comp.setLocation(comp.getX(), this._y);
                    }
                }

                AbstractAction init(int y) {
                    this._y = y;
                    return this;
                }
            }.init(p.getY()));
            edit.add(new AbstractAction(Bundle.getMessage("AlignMiddleY")){
                private int _y;

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (Editor.this._selectionGroup == null) {
                        return;
                    }
                    for (Positionable comp : Editor.this._selectionGroup) {
                        if (!Editor.this.getFlag(1, comp.isPositionable())) continue;
                        comp.setLocation(comp.getX(), this._y - comp.getHeight() / 2);
                    }
                }

                AbstractAction init(int y) {
                    this._y = y;
                    return this;
                }
            }.init(p.getY() + p.getHeight() / 2));
            edit.add(new AbstractAction(Bundle.getMessage("AlignOtherY")){
                private int _y;

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (Editor.this._selectionGroup == null) {
                        return;
                    }
                    for (Positionable comp : Editor.this._selectionGroup) {
                        if (!Editor.this.getFlag(1, comp.isPositionable())) continue;
                        comp.setLocation(comp.getX(), this._y - comp.getHeight());
                    }
                }

                AbstractAction init(int y) {
                    this._y = y;
                    return this;
                }
            }.init(p.getY() + p.getHeight()));
            edit.add(new AbstractAction(Bundle.getMessage("AlignXFirst")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (Editor.this._selectionGroup == null) {
                        return;
                    }
                    int x = Editor.this._selectionGroup.get(0).getX();
                    for (int i = 1; i < Editor.this._selectionGroup.size(); ++i) {
                        Positionable comp = Editor.this._selectionGroup.get(i);
                        if (!Editor.this.getFlag(1, comp.isPositionable())) continue;
                        comp.setLocation(x, comp.getY());
                    }
                }
            });
            edit.add(new AbstractAction(Bundle.getMessage("AlignYFirst")){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (Editor.this._selectionGroup == null) {
                        return;
                    }
                    int y = Editor.this._selectionGroup.get(0).getX();
                    for (int i = 1; i < Editor.this._selectionGroup.size(); ++i) {
                        Positionable comp = Editor.this._selectionGroup.get(i);
                        if (!Editor.this.getFlag(1, comp.isPositionable())) continue;
                        comp.setLocation(comp.getX(), y);
                    }
                }
            });
            popup.add(edit);
            return true;
        }
        return false;
    }

    public void setDisplayLevelMenu(Positionable p, JPopupMenu popup) {
        JMenuItem edit = new JMenuItem(Bundle.getMessage("EditLevel_", p.getDisplayLevel()));
        edit.addActionListener(CoordinateEdit.getLevelEditAction(p));
        popup.add(edit);
    }

    public void setHiddenMenu(Positionable p, JPopupMenu popup) {
        if (p.getDisplayLevel() == 1) {
            return;
        }
        JCheckBoxMenuItem hideItem = new JCheckBoxMenuItem(Bundle.getMessage("SetHidden"));
        hideItem.setSelected(p.isHidden());
        hideItem.addActionListener(new ActionListener(){
            private Positionable comp;
            private JCheckBoxMenuItem checkBox;

            @Override
            public void actionPerformed(ActionEvent e) {
                this.comp.setHidden(this.checkBox.isSelected());
                Editor.this.setSelectionsHidden(this.checkBox.isSelected(), this.comp);
            }

            ActionListener init(Positionable pos, JCheckBoxMenuItem cb) {
                this.comp = pos;
                this.checkBox = cb;
                return this;
            }
        }.init(p, hideItem));
        popup.add(hideItem);
    }

    public void setEmptyHiddenMenu(Positionable p, JPopupMenu popup) {
        if (p.getDisplayLevel() == 1) {
            return;
        }
        if (p instanceof BlockContentsIcon || p instanceof MemoryIcon || p instanceof GlobalVariableIcon) {
            JCheckBoxMenuItem hideEmptyItem = new JCheckBoxMenuItem(Bundle.getMessage("SetEmptyHidden"));
            hideEmptyItem.setSelected(p.isEmptyHidden());
            hideEmptyItem.addActionListener(new ActionListener(){
                private Positionable comp;
                private JCheckBoxMenuItem checkBox;

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.comp.setEmptyHidden(this.checkBox.isSelected());
                }

                ActionListener init(Positionable pos, JCheckBoxMenuItem cb) {
                    this.comp = pos;
                    this.checkBox = cb;
                    return this;
                }
            }.init(p, hideEmptyItem));
            popup.add(hideEmptyItem);
        }
    }

    public void setValueEditDisabledMenu(Positionable p, JPopupMenu popup) {
        if (p.getDisplayLevel() == 1) {
            return;
        }
        if (p instanceof BlockContentsIcon || p instanceof MemoryIcon || p instanceof GlobalVariableIcon) {
            JCheckBoxMenuItem valueEditDisableItem = new JCheckBoxMenuItem(Bundle.getMessage("SetValueEditDisabled"));
            valueEditDisableItem.setSelected(p.isValueEditDisabled());
            valueEditDisableItem.addActionListener(new ActionListener(){
                private Positionable comp;
                private JCheckBoxMenuItem checkBox;

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.comp.setValueEditDisabled(this.checkBox.isSelected());
                }

                ActionListener init(Positionable pos, JCheckBoxMenuItem cb) {
                    this.comp = pos;
                    this.checkBox = cb;
                    return this;
                }
            }.init(p, valueEditDisableItem));
            popup.add(valueEditDisableItem);
        }
    }

    public void setEditIdMenu(Positionable p, JPopupMenu popup) {
        if (p.getDisplayLevel() == 1) {
            return;
        }
        popup.add(CoordinateEdit.getIdEditAction(p, "EditId", this));
    }

    public void setEditClassesMenu(Positionable p, JPopupMenu popup) {
        if (p.getDisplayLevel() == 1) {
            return;
        }
        popup.add(CoordinateEdit.getClassesEditAction(p, "EditClasses", this));
    }

    private boolean checkEditConditionalNG() {
        if (this._inEditInlineLogixNGMode) {
            JmriJOptionPane.showMessageDialog(null, Bundle.getMessage("Error_InlineLogixNGInEditMode"), Bundle.getMessage("ErrorTitle"), 0);
            this._inlineLogixNGEdit.bringToFront();
            return true;
        }
        return false;
    }

    public void setLogixNGPositionableMenu(final Positionable p, JPopupMenu popup) {
        if (p.getDisplayLevel() == 1) {
            return;
        }
        JMenu logixNG_Menu = new JMenu("LogixNG");
        popup.add(logixNG_Menu);
        logixNG_Menu.add(new AbstractAction(Bundle.getMessage("LogixNG_Inline")){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (Editor.this.checkEditConditionalNG()) {
                    return;
                }
                if (p.getLogixNG() == null) {
                    LogixNG logixNG = InstanceManager.getDefault(LogixNG_Manager.class).createLogixNG(null, true);
                    logixNG.setInlineLogixNG(p);
                    logixNG.activate();
                    logixNG.setEnabled(true);
                    logixNG.clearStartup();
                    p.setLogixNG(logixNG);
                }
                LogixNGEditor logixNGEditor = new LogixNGEditor(null, p.getLogixNG().getSystemName());
                logixNGEditor.addEditorEventListener(data -> {
                    Editor.this._inEditInlineLogixNGMode = false;
                    data.forEach((key, value) -> {
                        if (key.equals("Finish")) {
                            Editor.this._inlineLogixNGEdit = null;
                            Editor.this._inEditInlineLogixNGMode = false;
                        } else if (key.equals("Delete")) {
                            Editor.this._inEditInlineLogixNGMode = false;
                            Editor.this.deleteLogixNG(p.getLogixNG());
                        } else if (key.equals("chgUname")) {
                            p.getLogixNG().setUserName((String)value);
                        }
                    });
                    if (p.getLogixNG() != null && p.getLogixNG().getNumConditionalNGs() == 0) {
                        Editor.this.deleteLogixNG_Internal(p.getLogixNG());
                    }
                });
                logixNGEditor.bringToFront();
                Editor.this._inEditInlineLogixNGMode = true;
                Editor.this._inlineLogixNGEdit = logixNGEditor;
            }
        });
    }

    private void deleteLogixNG(LogixNG logixNG) {
        DeleteBean<LogixNG> deleteBean = new DeleteBean<LogixNG>(InstanceManager.getDefault(LogixNG_Manager.class));
        boolean hasChildren = logixNG.getNumConditionalNGs() > 0;
        deleteBean.delete(logixNG, hasChildren, t -> this.deleteLogixNG_Internal((LogixNG)t), (t, list) -> logixNG.getListenerRefsIncludingChildren(list), LogixNG_UserPreferences.class.getName());
    }

    private void deleteLogixNG_Internal(LogixNG logixNG) {
        logixNG.setEnabled(false);
        try {
            InstanceManager.getDefault(LogixNG_Manager.class).deleteBean(logixNG, "DoDelete");
            logixNG.getInlineLogixNG().setLogixNG(null);
        }
        catch (PropertyVetoException e) {
            log.error("{} : Could not Delete.", (Object)e.getMessage());
        }
    }

    public void positionalIdChange(Positionable p, String newId) throws Positionable.DuplicateIdException {
        if (Objects.equals(newId, p.getId())) {
            return;
        }
        if (newId != null && this._idContents.containsKey(newId)) {
            throw new Positionable.DuplicateIdException();
        }
        if (p.getId() != null) {
            this._idContents.remove(p.getId());
        }
        if (newId != null) {
            this._idContents.put(newId, p);
        }
    }

    public void positionalAddClass(Positionable p, String className) {
        if (className == null) {
            throw new IllegalArgumentException("Class name must not be null");
        }
        if (className.isBlank()) {
            throw new IllegalArgumentException("Class name must not be blank");
        }
        if (className.contains(",")) {
            throw new IllegalArgumentException("Class name must not contain a comma");
        }
        if (p.getClasses().contains(className)) {
            return;
        }
        this._classContents.computeIfAbsent(className, o -> new HashSet()).add(p);
    }

    public void positionalRemoveClass(Positionable p, String className) {
        if (p.getClasses().contains(className)) {
            return;
        }
        this._classContents.get(className).remove(p);
    }

    public void setShowToolTipMenu(Positionable p, JPopupMenu popup) {
        if (p.getDisplayLevel() == 1) {
            return;
        }
        JMenu edit = new JMenu(Bundle.getMessage("EditTooltip"));
        JCheckBoxMenuItem showToolTipItem = new JCheckBoxMenuItem(Bundle.getMessage("ShowTooltip"));
        showToolTipItem.setSelected(p.showToolTip());
        showToolTipItem.addActionListener(new ActionListener(){
            private Positionable comp;
            private JCheckBoxMenuItem checkBox;

            @Override
            public void actionPerformed(ActionEvent e) {
                this.comp.setShowToolTip(this.checkBox.isSelected());
            }

            ActionListener init(Positionable pos, JCheckBoxMenuItem cb) {
                this.comp = pos;
                this.checkBox = cb;
                return this;
            }
        }.init(p, showToolTipItem));
        edit.add(showToolTipItem);
        edit.add(CoordinateEdit.getToolTipEditAction(p));
        JCheckBoxMenuItem prependToolTipWithDisplayNameItem = new JCheckBoxMenuItem(Bundle.getMessage("PrependTooltipWithDisplayName"));
        prependToolTipWithDisplayNameItem.setSelected(p.getToolTip().getPrependToolTipWithDisplayName());
        prependToolTipWithDisplayNameItem.addActionListener(new ActionListener(){
            private Positionable comp;
            private JCheckBoxMenuItem checkBox;

            @Override
            public void actionPerformed(ActionEvent e) {
                this.comp.getToolTip().setPrependToolTipWithDisplayName(this.checkBox.isSelected());
            }

            ActionListener init(Positionable pos, JCheckBoxMenuItem cb) {
                this.comp = pos;
                this.checkBox = cb;
                return this;
            }
        }.init(p, prependToolTipWithDisplayNameItem));
        edit.add(prependToolTipWithDisplayNameItem);
        popup.add(edit);
    }

    public void setRemoveMenu(Positionable p, JPopupMenu popup) {
        popup.add(new AbstractAction(Bundle.getMessage("Remove")){
            private Positionable comp;

            @Override
            public void actionPerformed(ActionEvent e) {
                this.comp.remove();
                Editor.this.removeSelections(this.comp);
            }

            AbstractAction init(Positionable pos) {
                this.comp = pos;
                return this;
            }
        }.init(p));
    }

    protected void locoMarkerFromRoster() {
        final JmriJFrame locoRosterFrame = new JmriJFrame();
        locoRosterFrame.getContentPane().setLayout(new FlowLayout());
        locoRosterFrame.setTitle(Bundle.getMessage("LocoFromRoster"));
        JLabel mtext = new JLabel();
        mtext.setText(Bundle.getMessage("SelectLoco") + ":");
        locoRosterFrame.getContentPane().add(mtext);
        RosterEntrySelectorPanel rosterBox = new RosterEntrySelectorPanel();
        rosterBox.addPropertyChangeListener("selectedRosterEntries", pce -> {
            if (rosterBox.getSelectedRosterEntries().length != 0) {
                this.selectLoco(rosterBox.getSelectedRosterEntries()[0]);
            }
        });
        locoRosterFrame.getContentPane().add(rosterBox);
        locoRosterFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                locoRosterFrame.dispose();
            }
        });
        locoRosterFrame.pack();
        locoRosterFrame.setVisible(true);
    }

    protected LocoIcon selectLoco(String rosterEntryTitle) {
        if ("".equals(rosterEntryTitle)) {
            return null;
        }
        return this.selectLoco(Roster.getDefault().entryFromTitle(rosterEntryTitle));
    }

    protected LocoIcon selectLoco(RosterEntry entry) {
        LocoIcon l = null;
        if (entry == null) {
            return null;
        }
        String rn = entry.getRoadNumber();
        if (rn == null || rn.equals("")) {
            rn = entry.getDccAddress();
        }
        if (rn != null) {
            l = this.addLocoIcon(rn);
            l.setRosterEntry(entry);
        }
        return l;
    }

    protected void locoMarkerFromInput() {
        final JmriJFrame locoFrame = new JmriJFrame();
        locoFrame.getContentPane().setLayout(new FlowLayout());
        locoFrame.setTitle(Bundle.getMessage("EnterLocoMarker"));
        JLabel textId = new JLabel();
        textId.setText(Bundle.getMessage("LocoID") + ":");
        locoFrame.getContentPane().add(textId);
        JTextField locoId = new JTextField(7);
        locoFrame.getContentPane().add(locoId);
        locoId.setText("");
        locoId.setToolTipText(Bundle.getMessage("EnterLocoID"));
        JButton okay = new JButton();
        okay.setText(Bundle.getMessage("ButtonOK"));
        okay.addActionListener(e -> {
            String nameID = locoId.getText();
            if (nameID != null && !nameID.trim().equals("")) {
                this.addLocoIcon(nameID.trim());
            } else {
                JmriJOptionPane.showMessageDialog(locoFrame, Bundle.getMessage("ErrorEnterLocoID"), Bundle.getMessage("ErrorTitle"), 0);
            }
        });
        locoFrame.getContentPane().add(okay);
        locoFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                locoFrame.dispose();
            }
        });
        locoFrame.pack();
        if (this._targetFrame != null) {
            locoFrame.setLocation(this._targetFrame.getLocation());
        }
        locoFrame.setVisible(true);
    }

    protected void removeMarkers() {
        log.debug("Remove markers");
        for (int i = this._contents.size() - 1; i >= 0; --i) {
            Positionable il = this._contents.get(i);
            if (!(il instanceof LocoIcon)) continue;
            il.remove();
            if (il.getId() != null) {
                this._idContents.remove(il.getId());
            }
            for (String className : il.getClasses()) {
                this._classContents.get(className).remove(il);
            }
        }
    }

    public PositionableLabel setUpBackground(String name) {
        NamedIcon icon = NamedIcon.getIconByName(name);
        PositionableLabel l = new PositionableLabel(icon, this);
        l.setPopupUtility(null);
        l.setPositionable(false);
        l.setShowToolTip(false);
        l.setSize(icon.getIconWidth(), icon.getIconHeight());
        l.setDisplayLevel(1);
        l.setLocation(this.getNextBackgroundLeft(), 0);
        try {
            this.putItem(l);
        }
        catch (Positionable.DuplicateIdException e) {
            log.error("Editor.putItem() with null id has thrown DuplicateIdException", (Throwable)e);
        }
        return l;
    }

    protected PositionableLabel addLabel(String text) {
        PositionableLabel l = new PositionableLabel(text, this);
        l.setSize(l.getPreferredSize().width, l.getPreferredSize().height);
        l.setDisplayLevel(4);
        this.setNextLocation(l);
        try {
            this.putItem(l);
        }
        catch (Positionable.DuplicateIdException e) {
            log.error("Editor.putItem() with null id has thrown DuplicateIdException", (Throwable)e);
        }
        return l;
    }

    private int getNextBackgroundLeft() {
        int left = 0;
        for (Positionable p : this._contents) {
            int test;
            PositionableLabel l;
            if (!(p instanceof PositionableLabel) || !(l = (PositionableLabel)p).isBackground() || (test = l.getX() + l.maxWidth()) <= left) continue;
            left = test;
        }
        return left;
    }

    public void displayLevelChange(Positionable l) {
        this.removeFromTarget(l);
        this.addToTarget(l);
    }

    public TrainIcon addTrainIcon(String name) {
        TrainIcon l = new TrainIcon(this);
        this.putLocoIcon(l, name);
        return l;
    }

    public LocoIcon addLocoIcon(String name) {
        LocoIcon l = new LocoIcon(this);
        this.putLocoIcon(l, name);
        return l;
    }

    public void putLocoIcon(LocoIcon l, String name) {
        l.setText(name);
        l.setHorizontalTextPosition(0);
        l.setSize(l.getPreferredSize().width, l.getPreferredSize().height);
        l.setEditable(this.isEditable());
        try {
            this.putItem(l);
        }
        catch (Positionable.DuplicateIdException e) {
            log.error("Editor.putItem() with null id has thrown DuplicateIdException", (Throwable)e);
        }
    }

    public void putItem(Positionable l) throws Positionable.DuplicateIdException {
        l.invalidate();
        l.setPositionable(true);
        l.setVisible(true);
        if (l.getToolTip() == null) {
            l.setToolTip(new ToolTip(this._defaultToolTip, l));
        }
        this.addToTarget(l);
        if (!this._contents.add(l)) {
            log.error("Unable to add {} to _contents", (Object)l.getNameString());
        }
        if (l.getId() != null) {
            if (this._idContents.containsKey(l.getId())) {
                throw new Positionable.DuplicateIdException();
            }
            this._idContents.put(l.getId(), l);
        }
        for (String className : l.getClasses()) {
            this._classContents.get(className).add(l);
        }
        if (log.isDebugEnabled()) {
            log.debug("putItem {} to _contents. level= {}", (Object)l.getNameString(), (Object)l.getDisplayLevel());
        }
    }

    protected void addToTarget(Positionable l) {
        JComponent c = (JComponent)((Object)l);
        c.invalidate();
        this._targetPanel.remove(c);
        this._targetPanel.add((Component)c, (Object)l.getDisplayLevel());
        this._targetPanel.moveToFront(c);
        c.repaint();
        this._targetPanel.revalidate();
    }

    public JFrameItem getIconFrame(String name) {
        JFrameItem frame = this._iconEditorFrame.get(name);
        if (frame == null) {
            if ("Sensor".equals(name)) {
                this.addSensorEditor();
            } else if ("RightTurnout".equals(name)) {
                this.addRightTOEditor();
            } else if ("LeftTurnout".equals(name)) {
                this.addLeftTOEditor();
            } else if ("SlipTOEditor".equals(name)) {
                this.addSlipTOEditor();
            } else if ("SignalHead".equals(name)) {
                this.addSignalHeadEditor();
            } else if ("SignalMast".equals(name)) {
                this.addSignalMastEditor();
            } else if ("Memory".equals(name)) {
                this.addMemoryEditor();
            } else if ("GlobalVariable".equals(name)) {
                this.addGlobalVariableEditor();
            } else if ("Reporter".equals(name)) {
                this.addReporterEditor();
            } else if ("Light".equals(name)) {
                this.addLightEditor();
            } else if ("Background".equals(name)) {
                this.addBackgroundEditor();
            } else if ("MultiSensor".equals(name)) {
                this.addMultiSensorEditor();
            } else if ("Icon".equals(name)) {
                this.addIconEditor();
            } else if ("Text".equals(name)) {
                this.addTextEditor();
            } else if ("BlockLabel".equals(name)) {
                this.addBlockContentsEditor();
            } else if ("Audio".equals(name)) {
                this.addAudioEditor();
            } else if ("LogixNG".equals(name)) {
                this.addLogixNGEditor();
            } else {
                return null;
            }
            frame = this._iconEditorFrame.get(name);
            if (frame == null) {
                return null;
            }
            frame.setLocation(this.frameLocationX, this.frameLocationY);
            this.frameLocationX += 20;
            this.frameLocationY += 20;
        }
        frame.setVisible(true);
        return frame;
    }

    public IconAdder getIconEditor(String name) {
        return this._iconEditorFrame.get(name).getEditor();
    }

    protected void addTextEditor() {
        String newLabel = JmriJOptionPane.showInputDialog((Component)this, Bundle.getMessage("PromptNewLabel"), "");
        if (newLabel == null) {
            return;
        }
        PositionableLabel l = this.addLabel(newLabel);
        l.setPositionable(true);
    }

    protected void addRightTOEditor() {
        IconAdder editor = new IconAdder("RightTurnout");
        editor.setIcon(3, "TurnoutStateClosed", "resources/icons/smallschematics/tracksegments/os-righthand-west-closed.gif");
        editor.setIcon(2, "TurnoutStateThrown", "resources/icons/smallschematics/tracksegments/os-righthand-west-thrown.gif");
        editor.setIcon(0, "BeanStateInconsistent", "resources/icons/smallschematics/tracksegments/os-righthand-west-error.gif");
        editor.setIcon(1, "BeanStateUnknown", "resources/icons/smallschematics/tracksegments/os-righthand-west-unknown.gif");
        JFrameItem frame = this.makeAddIconFrame("RightTurnout", true, true, editor);
        this._iconEditorFrame.put("RightTurnout", frame);
        editor.setPickList(PickListModel.turnoutPickModelInstance());
        ActionListener addIconAction = a -> this.addTurnoutR();
        editor.makeIconPanel(true);
        editor.complete(addIconAction, true, true, false);
        frame.addHelpMenu("package.jmri.jmrit.display.IconAdder", true);
    }

    protected void addLeftTOEditor() {
        IconAdder editor = new IconAdder("LeftTurnout");
        editor.setIcon(3, "TurnoutStateClosed", "resources/icons/smallschematics/tracksegments/os-lefthand-east-closed.gif");
        editor.setIcon(2, "TurnoutStateThrown", "resources/icons/smallschematics/tracksegments/os-lefthand-east-thrown.gif");
        editor.setIcon(0, "BeanStateInconsistent", "resources/icons/smallschematics/tracksegments/os-lefthand-east-error.gif");
        editor.setIcon(1, "BeanStateUnknown", "resources/icons/smallschematics/tracksegments/os-lefthand-east-unknown.gif");
        JFrameItem frame = this.makeAddIconFrame("LeftTurnout", true, true, editor);
        this._iconEditorFrame.put("LeftTurnout", frame);
        editor.setPickList(PickListModel.turnoutPickModelInstance());
        ActionListener addIconAction = a -> this.addTurnoutL();
        editor.makeIconPanel(true);
        editor.complete(addIconAction, true, true, false);
        frame.addHelpMenu("package.jmri.jmrit.display.IconAdder", true);
    }

    protected void addSlipTOEditor() {
        SlipIconAdder editor = new SlipIconAdder("SlipTOEditor");
        editor.setIcon(3, "LowerWestToUpperEast", "resources/icons/smallschematics/tracksegments/os-slip-lower-west-upper-east.gif");
        editor.setIcon(2, "UpperWestToLowerEast", "resources/icons/smallschematics/tracksegments/os-slip-upper-west-lower-east.gif");
        editor.setIcon(4, "LowerWestToLowerEast", "resources/icons/smallschematics/tracksegments/os-slip-lower-west-lower-east.gif");
        editor.setIcon(5, "UpperWestToUpperEast", "resources/icons/smallschematics/tracksegments/os-slip-upper-west-upper-east.gif");
        editor.setIcon(0, "BeanStateInconsistent", "resources/icons/smallschematics/tracksegments/os-slip-error-full.gif");
        editor.setIcon(1, "BeanStateUnknown", "resources/icons/smallschematics/tracksegments/os-slip-unknown-full.gif");
        editor.setTurnoutType(0);
        JFrameItem frame = this.makeAddIconFrame("SlipTOEditor", true, true, editor);
        this._iconEditorFrame.put("SlipTOEditor", frame);
        editor.setPickList(PickListModel.turnoutPickModelInstance());
        ActionListener addIconAction = a -> this.addSlip();
        editor.makeIconPanel(true);
        editor.complete(addIconAction, true, true, false);
        frame.addHelpMenu("package.jmri.jmrit.display.SlipTurnoutIcon", true);
    }

    protected void addSensorEditor() {
        IconAdder editor = new IconAdder("Sensor");
        editor.setIcon(3, "SensorStateActive", "resources/icons/smallschematics/tracksegments/circuit-occupied.gif");
        editor.setIcon(2, "SensorStateInactive", "resources/icons/smallschematics/tracksegments/circuit-empty.gif");
        editor.setIcon(0, "BeanStateInconsistent", "resources/icons/smallschematics/tracksegments/circuit-error.gif");
        editor.setIcon(1, "BeanStateUnknown", "resources/icons/smallschematics/tracksegments/circuit-error.gif");
        JFrameItem frame = this.makeAddIconFrame("Sensor", true, true, editor);
        this._iconEditorFrame.put("Sensor", frame);
        editor.setPickList(PickListModel.sensorPickModelInstance());
        ActionListener addIconAction = a -> this.putSensor();
        editor.makeIconPanel(true);
        editor.complete(addIconAction, true, true, false);
        frame.addHelpMenu("package.jmri.jmrit.display.IconAdder", true);
    }

    protected void addSignalHeadEditor() {
        IconAdder editor = this.getSignalHeadEditor();
        JFrameItem frame = this.makeAddIconFrame("SignalHead", true, true, editor);
        this._iconEditorFrame.put("SignalHead", frame);
        editor.setPickList(PickListModel.signalHeadPickModelInstance());
        ActionListener addIconAction = a -> this.putSignalHead();
        editor.makeIconPanel(true);
        editor.complete(addIconAction, true, false, false);
        frame.addHelpMenu("package.jmri.jmrit.display.IconAdder", true);
    }

    protected IconAdder getSignalHeadEditor() {
        IconAdder editor = new IconAdder("SignalHead");
        editor.setIcon(0, "SignalHeadStateRed", "resources/icons/smallschematics/searchlights/left-red-marker.gif");
        editor.setIcon(1, "SignalHeadStateYellow", "resources/icons/smallschematics/searchlights/left-yellow-marker.gif");
        editor.setIcon(2, "SignalHeadStateGreen", "resources/icons/smallschematics/searchlights/left-green-marker.gif");
        editor.setIcon(3, "SignalHeadStateDark", "resources/icons/smallschematics/searchlights/left-dark-marker.gif");
        editor.setIcon(4, "SignalHeadStateHeld", "resources/icons/smallschematics/searchlights/left-held-marker.gif");
        editor.setIcon(5, "SignalHeadStateLunar", "resources/icons/smallschematics/searchlights/left-lunar-marker.gif");
        editor.setIcon(6, "SignalHeadStateFlashingRed", "resources/icons/smallschematics/searchlights/left-flashred-marker.gif");
        editor.setIcon(7, "SignalHeadStateFlashingYellow", "resources/icons/smallschematics/searchlights/left-flashyellow-marker.gif");
        editor.setIcon(8, "SignalHeadStateFlashingGreen", "resources/icons/smallschematics/searchlights/left-flashgreen-marker.gif");
        editor.setIcon(9, "SignalHeadStateFlashingLunar", "resources/icons/smallschematics/searchlights/left-flashlunar-marker.gif");
        return editor;
    }

    protected void addSignalMastEditor() {
        IconAdder editor = new IconAdder("SignalMast");
        JFrameItem frame = this.makeAddIconFrame("SignalMast", true, true, editor);
        this._iconEditorFrame.put("SignalMast", frame);
        editor.setPickList(PickListModel.signalMastPickModelInstance());
        ActionListener addIconAction = a -> this.putSignalMast();
        editor.makeIconPanel(true);
        editor.complete(addIconAction, true, false, false);
        frame.addHelpMenu("package.jmri.jmrit.display.IconAdder", true);
    }

    protected void addMemoryEditor() {
        IconAdder editor = new IconAdder("Memory"){
            final JButton bSpin;
            final JButton bBox;
            final JSpinner spinner;
            {
                this.bSpin = new JButton(Bundle.getMessage("AddSpinner"));
                this.bBox = new JButton(Bundle.getMessage("AddInputBox"));
                this.spinner = new JSpinner(Editor.this._spinCols);
            }

            @Override
            protected void addAdditionalButtons(JPanel p) {
                this.bSpin.addActionListener(a -> Editor.this.addMemorySpinner());
                JPanel p1 = new JPanel();
                this.bBox.addActionListener(a -> Editor.this.addMemoryInputBox());
                ((JSpinner.DefaultEditor)this.spinner.getEditor()).getTextField().setColumns(2);
                this.spinner.setMaximumSize(this.spinner.getPreferredSize());
                JPanel p2 = new JPanel();
                p2.add(new JLabel(Bundle.getMessage("NumColsLabel")));
                p2.add(this.spinner);
                p1.add(p2);
                p1.add(this.bBox);
                p.add(p1);
                p1 = new JPanel();
                p1.add(this.bSpin);
                p.add(p1);
            }

            @Override
            public void valueChanged(ListSelectionEvent e) {
                super.valueChanged(e);
                this.bSpin.setEnabled(this.addIconIsEnabled());
                this.bBox.setEnabled(this.addIconIsEnabled());
            }
        };
        ActionListener addIconAction = a -> this.putMemory();
        JFrameItem frame = this.makeAddIconFrame("Memory", true, true, editor);
        this._iconEditorFrame.put("Memory", frame);
        editor.setPickList(PickListModel.memoryPickModelInstance());
        editor.makeIconPanel(true);
        editor.complete(addIconAction, false, true, false);
        frame.addHelpMenu("package.jmri.jmrit.display.IconAdder", true);
    }

    protected void addGlobalVariableEditor() {
        IconAdder editor = new IconAdder("GlobalVariable"){
            final JButton bSpin;
            final JButton bBox;
            final JSpinner spinner;
            {
                this.bSpin = new JButton(Bundle.getMessage("AddSpinner"));
                this.bBox = new JButton(Bundle.getMessage("AddInputBox"));
                this.spinner = new JSpinner(Editor.this._spinCols);
            }

            @Override
            protected void addAdditionalButtons(JPanel p) {
                this.bSpin.addActionListener(a -> Editor.this.addGlobalVariableSpinner());
                JPanel p1 = new JPanel();
                this.bBox.addActionListener(a -> Editor.this.addGlobalVariableInputBox());
                ((JSpinner.DefaultEditor)this.spinner.getEditor()).getTextField().setColumns(2);
                this.spinner.setMaximumSize(this.spinner.getPreferredSize());
                JPanel p2 = new JPanel();
                p2.add(new JLabel(Bundle.getMessage("NumColsLabel")));
                p2.add(this.spinner);
                p1.add(p2);
                p1.add(this.bBox);
                p.add(p1);
                p1 = new JPanel();
                p1.add(this.bSpin);
                p.add(p1);
            }

            @Override
            public void valueChanged(ListSelectionEvent e) {
                super.valueChanged(e);
                this.bSpin.setEnabled(this.addIconIsEnabled());
                this.bBox.setEnabled(this.addIconIsEnabled());
            }
        };
        ActionListener addIconAction = a -> this.putGlobalVariable();
        JFrameItem frame = this.makeAddIconFrame("GlobalVariable", true, true, editor);
        this._iconEditorFrame.put("GlobalVariable", frame);
        editor.setPickList(PickListModel.globalVariablePickModelInstance());
        editor.makeIconPanel(true);
        editor.complete(addIconAction, false, false, false);
        frame.addHelpMenu("package.jmri.jmrit.display.IconAdder", true);
    }

    protected void addBlockContentsEditor() {
        IconAdder editor = new IconAdder("Block Contents");
        ActionListener addIconAction = a -> this.putBlockContents();
        JFrameItem frame = this.makeAddIconFrame("BlockLabel", true, true, editor);
        this._iconEditorFrame.put("BlockLabel", frame);
        editor.setPickList(PickListModel.blockPickModelInstance());
        editor.makeIconPanel(true);
        editor.complete(addIconAction, false, true, false);
        frame.addHelpMenu("package.jmri.jmrit.display.IconAdder", true);
    }

    protected void addReporterEditor() {
        IconAdder editor = new IconAdder("Reporter");
        ActionListener addIconAction = a -> this.addReporter();
        JFrameItem frame = this.makeAddIconFrame("Reporter", true, true, editor);
        this._iconEditorFrame.put("Reporter", frame);
        editor.setPickList(PickListModel.reporterPickModelInstance());
        editor.makeIconPanel(true);
        editor.complete(addIconAction, false, true, false);
        frame.addHelpMenu("package.jmri.jmrit.display.IconAdder", true);
    }

    protected void addLightEditor() {
        IconAdder editor = new IconAdder("Light");
        editor.setIcon(3, "StateOff", "resources/icons/smallschematics/lights/cross-on.png");
        editor.setIcon(2, "StateOn", "resources/icons/smallschematics/lights/cross-off.png");
        editor.setIcon(0, "BeanStateInconsistent", "resources/icons/smallschematics/lights/cross-inconsistent.png");
        editor.setIcon(1, "BeanStateUnknown", "resources/icons/smallschematics/lights/cross-unknown.png");
        JFrameItem frame = this.makeAddIconFrame("Light", true, true, editor);
        this._iconEditorFrame.put("Light", frame);
        editor.setPickList(PickListModel.lightPickModelInstance());
        ActionListener addIconAction = a -> this.addLight();
        editor.makeIconPanel(true);
        editor.complete(addIconAction, true, true, false);
        frame.addHelpMenu("package.jmri.jmrit.display.IconAdder", true);
    }

    protected void addBackgroundEditor() {
        IconAdder editor = new IconAdder("Background");
        editor.setIcon(0, "background", "resources/PanelPro.gif");
        JFrameItem frame = this.makeAddIconFrame("Background", true, false, editor);
        this._iconEditorFrame.put("Background", frame);
        ActionListener addIconAction = a -> this.putBackground();
        editor.makeIconPanel(true);
        editor.complete(addIconAction, true, false, false);
        frame.addHelpMenu("package.jmri.jmrit.display.IconAdder", true);
    }

    protected JFrameItem addMultiSensorEditor() {
        MultiSensorIconAdder editor = new MultiSensorIconAdder("MultiSensor");
        editor.setIcon(0, "BeanStateInconsistent", "resources/icons/USS/plate/levers/l-inconsistent.gif");
        editor.setIcon(1, "BeanStateUnknown", "resources/icons/USS/plate/levers/l-unknown.gif");
        editor.setIcon(2, "SensorStateInactive", "resources/icons/USS/plate/levers/l-inactive.gif");
        editor.setIcon(3, "MultiSensorPosition 0", "resources/icons/USS/plate/levers/l-left.gif");
        editor.setIcon(4, "MultiSensorPosition 1", "resources/icons/USS/plate/levers/l-vertical.gif");
        editor.setIcon(5, "MultiSensorPosition 2", "resources/icons/USS/plate/levers/l-right.gif");
        JFrameItem frame = this.makeAddIconFrame("MultiSensor", true, false, editor);
        this._iconEditorFrame.put("MultiSensor", frame);
        frame.addHelpMenu("package.jmri.jmrit.display.MultiSensorIconAdder", true);
        editor.setPickList(PickListModel.sensorPickModelInstance());
        ActionListener addIconAction = a -> this.addMultiSensor();
        editor.makeIconPanel(true);
        editor.complete(addIconAction, true, true, false);
        return frame;
    }

    protected void addIconEditor() {
        IconAdder editor = new IconAdder("Icon");
        editor.setIcon(0, "plainIcon", "resources/icons/smallschematics/tracksegments/block.gif");
        JFrameItem frame = this.makeAddIconFrame("Icon", true, false, editor);
        this._iconEditorFrame.put("Icon", frame);
        ActionListener addIconAction = a -> this.putIcon();
        editor.makeIconPanel(true);
        editor.complete(addIconAction, true, false, false);
        frame.addHelpMenu("package.jmri.jmrit.display.IconAdder", true);
    }

    protected void addAudioEditor() {
        IconAdder editor = new IconAdder("Audio");
        editor.setIcon(0, "plainIcon", "resources/icons/audio_icon.gif");
        JFrameItem frame = this.makeAddIconFrame("Audio", true, false, editor);
        this._iconEditorFrame.put("Audio", frame);
        editor.setPickList(PickListModel.audioPickModelInstance());
        ActionListener addIconAction = a -> this.putAudio();
        editor.makeIconPanel(true);
        editor.complete(addIconAction, true, false, false);
        frame.addHelpMenu("package.jmri.jmrit.display.IconAdder", true);
    }

    protected void addLogixNGEditor() {
        IconAdder editor = new IconAdder("LogixNG");
        editor.setIcon(0, "plainIcon", "resources/icons/logixng/logixng_icon.gif");
        JFrameItem frame = this.makeAddIconFrame("LogixNG", true, false, editor);
        this._iconEditorFrame.put("LogixNG", frame);
        ActionListener addIconAction = a -> this.putLogixNG();
        editor.makeIconPanel(true);
        editor.complete(addIconAction, true, false, false);
        frame.addHelpMenu("package.jmri.jmrit.display.IconAdder", true);
    }

    protected SensorIcon putSensor() {
        SensorIcon result = new SensorIcon(new NamedIcon("resources/icons/smallschematics/tracksegments/circuit-error.gif", "resources/icons/smallschematics/tracksegments/circuit-error.gif"), this);
        IconAdder editor = this.getIconEditor("Sensor");
        Hashtable<String, NamedIcon> map = editor.getIconMap();
        Enumeration<String> e = map.keys();
        while (e.hasMoreElements()) {
            String key = e.nextElement();
            result.setIcon(key, map.get(key));
        }
        NamedBean b = editor.getTableSelection();
        if (b != null) {
            result.setSensor(b.getDisplayName());
        }
        result.setDisplayLevel(10);
        this.setNextLocation(result);
        try {
            this.putItem(result);
        }
        catch (Positionable.DuplicateIdException ex) {
            log.error("Editor.putItem() with null id has thrown DuplicateIdException", (Throwable)ex);
        }
        return result;
    }

    void addTurnoutR() {
        IconAdder editor = this.getIconEditor("RightTurnout");
        this.addTurnout(editor);
    }

    void addTurnoutL() {
        IconAdder editor = this.getIconEditor("LeftTurnout");
        this.addTurnout(editor);
    }

    protected TurnoutIcon addTurnout(IconAdder editor) {
        TurnoutIcon result = new TurnoutIcon(this);
        result.setTurnout(editor.getTableSelection().getDisplayName());
        Hashtable<String, NamedIcon> map = editor.getIconMap();
        Enumeration<String> e = map.keys();
        while (e.hasMoreElements()) {
            String key = e.nextElement();
            result.setIcon(key, map.get(key));
        }
        result.setDisplayLevel(7);
        this.setNextLocation(result);
        try {
            this.putItem(result);
        }
        catch (Positionable.DuplicateIdException ex) {
            log.error("Editor.putItem() with null id has thrown DuplicateIdException", (Throwable)ex);
        }
        return result;
    }

    @SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST_OF_RETURN_VALUE"}, justification="iconEditor requested as exact type")
    SlipTurnoutIcon addSlip() {
        SlipTurnoutIcon result = new SlipTurnoutIcon(this);
        SlipIconAdder editor = (SlipIconAdder)this.getIconEditor("SlipTOEditor");
        result.setSingleSlipRoute(editor.getSingleSlipRoute());
        switch (editor.getTurnoutType()) {
            case 0: {
                result.setLowerWestToUpperEastIcon(editor.getIcon("LowerWestToUpperEast"));
                result.setUpperWestToLowerEastIcon(editor.getIcon("UpperWestToLowerEast"));
                result.setLowerWestToLowerEastIcon(editor.getIcon("LowerWestToLowerEast"));
                result.setUpperWestToUpperEastIcon(editor.getIcon("UpperWestToUpperEast"));
                break;
            }
            case 2: {
                result.setLowerWestToUpperEastIcon(editor.getIcon("LowerWestToUpperEast"));
                result.setUpperWestToLowerEastIcon(editor.getIcon("UpperWestToLowerEast"));
                result.setLowerWestToLowerEastIcon(editor.getIcon("Slip"));
                result.setSingleSlipRoute(editor.getSingleSlipRoute());
                break;
            }
            case 4: {
                result.setLowerWestToUpperEastIcon(editor.getIcon("Upper"));
                result.setUpperWestToLowerEastIcon(editor.getIcon("Middle"));
                result.setLowerWestToLowerEastIcon(editor.getIcon("Lower"));
                result.setSingleSlipRoute(editor.getSingleSlipRoute());
                break;
            }
            case 8: {
                result.setLowerWestToUpperEastIcon(editor.getIcon("LowerWestToUpperEast"));
                result.setUpperWestToLowerEastIcon(editor.getIcon("UpperWestToLowerEast"));
                result.setLowerWestToLowerEastIcon(editor.getIcon("LowerWestToLowerEast"));
                break;
            }
            default: {
                log.warn("Unexpected addSlip editor.getTurnoutType() of {}", (Object)editor.getTurnoutType());
            }
        }
        if (editor.getTurnoutType() == 8 && !editor.getSingleSlipRoute()) {
            result.setTurnout(editor.getTurnout("lowerwest").getName(), 4);
            result.setTurnout(editor.getTurnout("lowereast").getName(), 6);
        }
        result.setInconsistentIcon(editor.getIcon("BeanStateInconsistent"));
        result.setUnknownIcon(editor.getIcon("BeanStateUnknown"));
        result.setTurnoutType(editor.getTurnoutType());
        result.setTurnout(editor.getTurnout("west").getName(), 1);
        result.setTurnout(editor.getTurnout("east").getName(), 2);
        result.setDisplayLevel(7);
        this.setNextLocation(result);
        try {
            this.putItem(result);
        }
        catch (Positionable.DuplicateIdException e) {
            log.error("Editor.putItem() with null id has thrown DuplicateIdException", (Throwable)e);
        }
        return result;
    }

    protected SignalHeadIcon putSignalHead() {
        SignalHeadIcon result = new SignalHeadIcon(this);
        IconAdder editor = this.getIconEditor("SignalHead");
        result.setSignalHead(editor.getTableSelection().getDisplayName());
        Hashtable<String, NamedIcon> map = editor.getIconMap();
        Enumeration<String> e = map.keys();
        while (e.hasMoreElements()) {
            String key = e.nextElement();
            result.setIcon(key, map.get(key));
        }
        result.setDisplayLevel(9);
        this.setNextLocation(result);
        try {
            this.putItem(result);
        }
        catch (Positionable.DuplicateIdException ex) {
            log.error("Editor.putItem() with null id has thrown DuplicateIdException", (Throwable)ex);
        }
        return result;
    }

    protected SignalMastIcon putSignalMast() {
        SignalMastIcon result = new SignalMastIcon(this);
        IconAdder editor = this._iconEditorFrame.get("SignalMast").getEditor();
        result.setSignalMast(editor.getTableSelection().getDisplayName());
        result.setDisplayLevel(9);
        this.setNextLocation(result);
        try {
            this.putItem(result);
        }
        catch (Positionable.DuplicateIdException e) {
            log.error("Editor.putItem() with null id has thrown DuplicateIdException", (Throwable)e);
        }
        return result;
    }

    protected MemoryIcon putMemory() {
        MemoryIcon result = new MemoryIcon(new NamedIcon("resources/icons/misc/X-red.gif", "resources/icons/misc/X-red.gif"), this);
        IconAdder memoryIconEditor = this.getIconEditor("Memory");
        result.setMemory(memoryIconEditor.getTableSelection().getDisplayName());
        result.setSize(result.getPreferredSize().width, result.getPreferredSize().height);
        result.setDisplayLevel(5);
        this.setNextLocation(result);
        try {
            this.putItem(result);
        }
        catch (Positionable.DuplicateIdException e) {
            log.error("Editor.putItem() with null id has thrown DuplicateIdException", (Throwable)e);
        }
        return result;
    }

    protected MemorySpinnerIcon addMemorySpinner() {
        MemorySpinnerIcon result = new MemorySpinnerIcon(this);
        IconAdder memoryIconEditor = this.getIconEditor("Memory");
        result.setMemory(memoryIconEditor.getTableSelection().getDisplayName());
        result.setSize(result.getPreferredSize().width, result.getPreferredSize().height);
        result.setDisplayLevel(5);
        this.setNextLocation(result);
        try {
            this.putItem(result);
        }
        catch (Positionable.DuplicateIdException e) {
            log.error("Editor.putItem() with null id has thrown DuplicateIdException", (Throwable)e);
        }
        return result;
    }

    protected MemoryInputIcon addMemoryInputBox() {
        MemoryInputIcon result = new MemoryInputIcon(this._spinCols.getNumber().intValue(), this);
        IconAdder memoryIconEditor = this.getIconEditor("Memory");
        result.setMemory(memoryIconEditor.getTableSelection().getDisplayName());
        result.setSize(result.getPreferredSize().width, result.getPreferredSize().height);
        result.setDisplayLevel(5);
        this.setNextLocation(result);
        try {
            this.putItem(result);
        }
        catch (Positionable.DuplicateIdException e) {
            log.error("Editor.putItem() with null id has thrown DuplicateIdException", (Throwable)e);
        }
        return result;
    }

    protected GlobalVariableIcon putGlobalVariable() {
        GlobalVariableIcon result = new GlobalVariableIcon(new NamedIcon("resources/icons/misc/X-red.gif", "resources/icons/misc/X-red.gif"), this);
        IconAdder globalVariableIconEditor = this.getIconEditor("GlobalVariable");
        result.setGlobalVariable(globalVariableIconEditor.getTableSelection().getDisplayName());
        result.setSize(result.getPreferredSize().width, result.getPreferredSize().height);
        result.setDisplayLevel(5);
        this.setNextLocation(result);
        try {
            this.putItem(result);
        }
        catch (Positionable.DuplicateIdException e) {
            log.error("Editor.putItem() with null id has thrown DuplicateIdException", (Throwable)e);
        }
        return result;
    }

    protected GlobalVariableSpinnerIcon addGlobalVariableSpinner() {
        GlobalVariableSpinnerIcon result = new GlobalVariableSpinnerIcon(this);
        IconAdder globalVariableIconEditor = this.getIconEditor("GlobalVariable");
        result.setGlobalVariable(globalVariableIconEditor.getTableSelection().getDisplayName());
        result.setSize(result.getPreferredSize().width, result.getPreferredSize().height);
        result.setDisplayLevel(5);
        this.setNextLocation(result);
        try {
            this.putItem(result);
        }
        catch (Positionable.DuplicateIdException e) {
            log.error("Editor.putItem() with null id has thrown DuplicateIdException", (Throwable)e);
        }
        return result;
    }

    protected GlobalVariableInputIcon addGlobalVariableInputBox() {
        GlobalVariableInputIcon result = new GlobalVariableInputIcon(this._spinCols.getNumber().intValue(), this);
        IconAdder globalVariableIconEditor = this.getIconEditor("GlobalVariable");
        result.setGlobalVariable(globalVariableIconEditor.getTableSelection().getDisplayName());
        result.setSize(result.getPreferredSize().width, result.getPreferredSize().height);
        result.setDisplayLevel(5);
        this.setNextLocation(result);
        try {
            this.putItem(result);
        }
        catch (Positionable.DuplicateIdException e) {
            log.error("Editor.putItem() with null id has thrown DuplicateIdException", (Throwable)e);
        }
        return result;
    }

    protected BlockContentsIcon putBlockContents() {
        BlockContentsIcon result = new BlockContentsIcon(new NamedIcon("resources/icons/misc/X-red.gif", "resources/icons/misc/X-red.gif"), this);
        IconAdder blockIconEditor = this.getIconEditor("BlockLabel");
        result.setBlock(blockIconEditor.getTableSelection().getDisplayName());
        result.setSize(result.getPreferredSize().width, result.getPreferredSize().height);
        result.setDisplayLevel(5);
        this.setNextLocation(result);
        try {
            this.putItem(result);
        }
        catch (Positionable.DuplicateIdException e) {
            log.error("Editor.putItem() with null id has thrown DuplicateIdException", (Throwable)e);
        }
        return result;
    }

    protected LightIcon addLight() {
        LightIcon result = new LightIcon(this);
        IconAdder editor = this.getIconEditor("Light");
        result.setOffIcon(editor.getIcon("StateOff"));
        result.setOnIcon(editor.getIcon("StateOn"));
        result.setInconsistentIcon(editor.getIcon("BeanStateInconsistent"));
        result.setUnknownIcon(editor.getIcon("BeanStateUnknown"));
        result.setLight((Light)editor.getTableSelection());
        result.setDisplayLevel(8);
        this.setNextLocation(result);
        try {
            this.putItem(result);
        }
        catch (Positionable.DuplicateIdException e) {
            log.error("Editor.putItem() with null id has thrown DuplicateIdException", (Throwable)e);
        }
        return result;
    }

    protected ReporterIcon addReporter() {
        ReporterIcon result = new ReporterIcon(this);
        IconAdder reporterIconEditor = this.getIconEditor("Reporter");
        result.setReporter((Reporter)reporterIconEditor.getTableSelection());
        result.setSize(result.getPreferredSize().width, result.getPreferredSize().height);
        result.setDisplayLevel(5);
        this.setNextLocation(result);
        try {
            this.putItem(result);
        }
        catch (Positionable.DuplicateIdException e) {
            log.error("Editor.putItem() with null id has thrown DuplicateIdException", (Throwable)e);
        }
        return result;
    }

    void putBackground() {
        IconAdder bkgrndEditor = this.getIconEditor("Background");
        String url = bkgrndEditor.getIcon("background").getURL();
        this.setUpBackground(url);
    }

    protected Positionable putIcon() {
        IconAdder iconEditor = this.getIconEditor("Icon");
        String url = iconEditor.getIcon("plainIcon").getURL();
        NamedIcon icon = NamedIcon.getIconByName(url);
        if (log.isDebugEnabled()) {
            log.debug("putIcon: {} url= {}", (Object)(icon == null ? "null" : "icon"), (Object)url);
        }
        PositionableLabel result = new PositionableLabel(icon, this);
        result.setDisplayLevel(3);
        this.setNextLocation(result);
        try {
            this.putItem(result);
        }
        catch (Positionable.DuplicateIdException e) {
            log.error("Editor.putItem() with null id has thrown DuplicateIdException", (Throwable)e);
        }
        result.updateSize();
        return result;
    }

    protected Positionable putAudio() {
        IconAdder iconEditor = this.getIconEditor("Audio");
        String url = iconEditor.getIcon("plainIcon").getURL();
        NamedIcon icon = NamedIcon.getIconByName(url);
        if (log.isDebugEnabled()) {
            log.debug("putAudio: {} url= {}", (Object)(icon == null ? "null" : "icon"), (Object)url);
        }
        AudioIcon result = new AudioIcon(icon, this);
        NamedBean b = iconEditor.getTableSelection();
        if (b != null) {
            result.setAudio(b.getDisplayName());
        }
        result.setDisplayLevel(3);
        this.setNextLocation(result);
        try {
            this.putItem(result);
        }
        catch (Positionable.DuplicateIdException e) {
            log.error("Editor.putAudio() with null id has thrown DuplicateIdException", (Throwable)e);
        }
        result.updateSize();
        return result;
    }

    protected Positionable putLogixNG() {
        IconAdder iconEditor = this.getIconEditor("LogixNG");
        String url = iconEditor.getIcon("plainIcon").getURL();
        NamedIcon icon = NamedIcon.getIconByName(url);
        if (log.isDebugEnabled()) {
            log.debug("putLogixNG: {} url= {}", (Object)(icon == null ? "null" : "icon"), (Object)url);
        }
        LogixNGIcon result = new LogixNGIcon(icon, this);
        result.setDisplayLevel(3);
        this.setNextLocation(result);
        try {
            this.putItem(result);
        }
        catch (Positionable.DuplicateIdException e) {
            log.error("Editor.putLogixNG() with null id has thrown DuplicateIdException", (Throwable)e);
        }
        result.updateSize();
        return result;
    }

    @SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST_OF_RETURN_VALUE"}, justification="iconEditor requested as exact type")
    public MultiSensorIcon addMultiSensor() {
        MultiSensorIcon result = new MultiSensorIcon(this);
        MultiSensorIconAdder editor = (MultiSensorIconAdder)this.getIconEditor("MultiSensor");
        result.setUnknownIcon(editor.getIcon("BeanStateUnknown"));
        result.setInconsistentIcon(editor.getIcon("BeanStateInconsistent"));
        result.setInactiveIcon(editor.getIcon("SensorStateInactive"));
        int numPositions = editor.getNumIcons();
        for (int i = 3; i < numPositions; ++i) {
            NamedIcon icon = editor.getIcon(i);
            String sensor = editor.getSensor(i).getName();
            result.addEntry(sensor, icon);
        }
        result.setUpDown(editor.getUpDown());
        result.setDisplayLevel(10);
        this.setNextLocation(result);
        try {
            this.putItem(result);
        }
        catch (Positionable.DuplicateIdException e) {
            log.error("Editor.putItem() with null id has thrown DuplicateIdException", (Throwable)e);
        }
        return result;
    }

    protected AnalogClock2Display addClock() {
        AnalogClock2Display result = new AnalogClock2Display(this);
        result.setOpaque(false);
        result.update();
        result.setDisplayLevel(10);
        this.setNextLocation(result);
        try {
            this.putItem(result);
        }
        catch (Positionable.DuplicateIdException e) {
            log.error("Editor.putItem() with null id has thrown DuplicateIdException", (Throwable)e);
        }
        return result;
    }

    protected RpsPositionIcon addRpsReporter() {
        RpsPositionIcon result = new RpsPositionIcon(this);
        result.setSize(result.getPreferredSize().width, result.getPreferredSize().height);
        result.setDisplayLevel(10);
        this.setNextLocation(result);
        try {
            this.putItem(result);
        }
        catch (Positionable.DuplicateIdException e) {
            log.error("Editor.putItem() with null id has thrown DuplicateIdException", (Throwable)e);
        }
        return result;
    }

    public void setTitle() {
        String name = this._targetFrame.getTitle();
        if (name == null || name.equals("")) {
            super.setTitle(Bundle.getMessage("LabelEditor"));
        } else {
            super.setTitle(name + " " + Bundle.getMessage("LabelEditor"));
        }
        for (JFrameItem frame : this._iconEditorFrame.values()) {
            frame.setTitle(frame.getName() + " (" + name + ")");
        }
        this.setName(name);
    }

    protected JFrameItem makeAddIconFrame(String name, boolean add, boolean table, IconAdder editor) {
        String txt;
        log.debug("makeAddIconFrame for {}, add= {}, table= {}", new Object[]{name, add, table});
        JFrameItem frame = new JFrameItem(name, editor);
        String bundleName = "Sensor".equals(name) ? "BeanNameSensor" : ("SignalHead".equals(name) ? "BeanNameSignalHead" : ("SignalMast".equals(name) ? "BeanNameSignalMast" : ("Memory".equals(name) ? "BeanNameMemory" : ("Reporter".equals(name) ? "BeanNameReporter" : ("Light".equals(name) ? "BeanNameLight" : ("Turnout".equals(name) ? "BeanNameTurnout" : ("Block".equals(name) ? "BeanNameBlock" : ("GlobalVariable".equals(name) ? "BeanNameGlobalVariable" : ("Audio".equals(name) ? "BeanNameAudio" : name)))))))));
        if (editor != null) {
            JPanel p = new JPanel();
            p.setLayout(new BoxLayout(p, 1));
            txt = add ? MessageFormat.format(Bundle.getMessage("addItemToPanel"), Bundle.getMessage(bundleName)) : MessageFormat.format(Bundle.getMessage("editItemInPanel"), Bundle.getMessage(bundleName));
            p.add(new JLabel(txt));
            txt = table ? MessageFormat.format(Bundle.getMessage("TableSelect"), Bundle.getMessage(bundleName), add ? Bundle.getMessage("ButtonAddIcon") : Bundle.getMessage("ButtonUpdateIcon")) : ("MultiSensor".equals(name) ? MessageFormat.format(Bundle.getMessage("SelectMultiSensor", Bundle.getMessage("ButtonAddIcon")), add ? Bundle.getMessage("ButtonAddIcon") : Bundle.getMessage("ButtonUpdateIcon")) : MessageFormat.format(Bundle.getMessage("IconSelect"), Bundle.getMessage(bundleName), add ? Bundle.getMessage("ButtonAddIcon") : Bundle.getMessage("ButtonUpdateIcon")));
            p.add(new JLabel(txt));
            p.add(new JLabel("    "));
            frame.getContentPane().add((Component)p, "North");
            frame.getContentPane().add(editor);
            JMenuBar menuBar = new JMenuBar();
            JMenu findIcon = new JMenu(Bundle.getMessage("findIconMenu"));
            menuBar.add(findIcon);
            JMenuItem editItem = new JMenuItem(Bundle.getMessage("editIndexMenu"));
            editItem.addActionListener(e -> {
                ImageIndexEditor ii = InstanceManager.getDefault(ImageIndexEditor.class);
                ii.pack();
                ii.setVisible(true);
            });
            findIcon.add(editItem);
            findIcon.addSeparator();
            JMenuItem searchItem = new JMenuItem(Bundle.getMessage("searchFSMenu"));
            searchItem.addActionListener(new ActionListener(){
                private IconAdder ea;

                @Override
                public void actionPerformed(ActionEvent e) {
                    InstanceManager.getDefault(DirectorySearcher.class).searchFS();
                    this.ea.addDirectoryToCatalog();
                }

                ActionListener init(IconAdder ed) {
                    this.ea = ed;
                    return this;
                }
            }.init(editor));
            findIcon.add(searchItem);
            frame.setJMenuBar(menuBar);
            editor.setParent(frame);
            if (add) {
                frame.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        Editor.this.setDefaultCloseOperation(1);
                        if (log.isDebugEnabled()) {
                            log.debug("windowClosing: HIDE {}", (Object)this.toString());
                        }
                    }
                });
            }
        } else {
            log.error("No icon editor specified for {}", (Object)name);
        }
        if (add) {
            txt = MessageFormat.format(Bundle.getMessage("AddItem"), Bundle.getMessage(bundleName));
            this._iconEditorFrame.put(name, frame);
        } else {
            txt = MessageFormat.format(Bundle.getMessage("EditItem"), Bundle.getMessage(bundleName));
        }
        frame.setTitle(txt + " (" + this.getTitle() + ")");
        frame.pack();
        return frame;
    }

    protected void removeFromTarget(Positionable l) {
        this._targetPanel.remove((Component)((Object)l));
        this._highlightcomponent = null;
        Point p = l.getLocation();
        int w = l.getWidth();
        int h = l.getHeight();
        this._targetPanel.revalidate();
        this._targetPanel.repaint(p.x, p.y, w, h);
    }

    public boolean removeFromContents(Positionable l) {
        this.removeFromTarget(l);
        if (l.getId() != null) {
            this._idContents.remove(l.getId());
        }
        for (String className : l.getClasses()) {
            this._classContents.get(className).remove(l);
        }
        return this._contents.remove(l);
    }

    private void dispositionLogixNGs() {
        ArrayList<LogixNG> logixNGArrayList = new ArrayList<LogixNG>();
        for (Positionable _content : this._contents) {
            if (_content.getLogixNG() == null) continue;
            LogixNG logixNG = _content.getLogixNG();
            logixNGArrayList.add(logixNG);
        }
        if (!logixNGArrayList.isEmpty()) {
            LogixNGDeleteDialog logixNGDeleteDialog = new LogixNGDeleteDialog((Frame)this, this.getTitle(), logixNGArrayList);
            logixNGDeleteDialog.setVisible(true);
            List<LogixNG> selectedItems = logixNGDeleteDialog.getSelectedItems();
            for (LogixNG logixNG : selectedItems) {
                this.deleteLogixNG_Internal(logixNG);
                logixNGArrayList.remove(logixNG);
            }
            for (LogixNG logixNG : logixNGArrayList) {
                logixNG.setInline(false);
                logixNG.setEnabled(!logixNGDeleteDialog.isDisableLogixNG());
            }
        }
    }

    public boolean deletePanel() {
        log.debug("deletePanel");
        int selectedValue = JmriJOptionPane.showOptionDialog(this._targetPanel, Bundle.getMessage("QuestionA") + "\n" + Bundle.getMessage("QuestionA2", Bundle.getMessage("FileMenuItemStore")), Bundle.getMessage("DeleteVerifyTitle"), -1, 3, null, new Object[]{Bundle.getMessage("ButtonYesDelete"), Bundle.getMessage("ButtonCancel")}, Bundle.getMessage("ButtonCancel"));
        if (selectedValue == 0) {
            this.dispositionLogixNGs();
        }
        return selectedValue == 0;
    }

    @Override
    public void dispose() {
        for (JFrameItem frame : this._iconEditorFrame.values()) {
            frame.setDefaultCloseOperation(0);
            frame.dispose();
        }
        ConfigureManager cm = InstanceManager.getNullableDefault(ConfigureManager.class);
        if (cm != null) {
            cm.deregister(this);
        }
        InstanceManager.getDefault(EditorManager.class).remove(this);
        this.setVisible(false);
        this._contents.clear();
        this._idContents.clear();
        for (Set<Positionable> list : this._classContents.values()) {
            list.clear();
        }
        this._classContents.clear();
        this.removeAll();
        super.dispose();
    }

    public void showToolTip(Positionable selection, JmriMouseEvent event) {
        ToolTip tip = selection.getToolTip();
        tip.setLocation(selection.getX() + selection.getWidth() / 2, selection.getY() + selection.getHeight());
        this.setToolTip(tip);
    }

    protected int getItemX(Positionable p, int deltaX) {
        if (p instanceof MemoryOrGVIcon && p.getPopupUtility().getFixedWidth() == 0) {
            MemoryOrGVIcon pm = (MemoryOrGVIcon)p;
            return pm.getOriginalX() + (int)Math.round((double)deltaX / this.getPaintScale());
        }
        return p.getX() + (int)Math.round((double)deltaX / this.getPaintScale());
    }

    protected int getItemY(Positionable p, int deltaY) {
        if (p instanceof MemoryOrGVIcon && p.getPopupUtility().getFixedWidth() == 0) {
            MemoryOrGVIcon pm = (MemoryOrGVIcon)p;
            return pm.getOriginalY() + (int)Math.round((double)deltaY / this.getPaintScale());
        }
        return p.getY() + (int)Math.round((double)deltaY / this.getPaintScale());
    }

    public void addToPopUpMenu(NamedBean nb, JMenuItem item, int menu) {
        if (nb == null || item == null) {
            return;
        }
        for (Positionable pos : this._contents) {
            if (pos.getNamedBean() == nb && pos.getPopupUtility() != null) {
                this.addToPopUpMenu(pos, item, menu);
                return;
            }
            if (pos instanceof SlipTurnoutIcon) {
                SlipTurnoutIcon sti;
                if (pos.getPopupUtility() == null || (sti = (SlipTurnoutIcon)pos).getTurnout(2) != nb && sti.getTurnout(1) != nb && sti.getTurnout(6) != nb && sti.getTurnout(4) != nb) continue;
                this.addToPopUpMenu(pos, item, menu);
                return;
            }
            if (!(pos instanceof MultiSensorIcon) || pos.getPopupUtility() == null) continue;
            MultiSensorIcon msi = (MultiSensorIcon)pos;
            for (int i = 0; i < msi.getNumEntries(); ++i) {
                if (!msi.getSensorName(i).equals(nb.getUserName()) && !msi.getSensorName(i).equals(nb.getSystemName())) continue;
                this.addToPopUpMenu(pos, item, menu);
                return;
            }
        }
    }

    private void addToPopUpMenu(Positionable pos, JMenuItem item, int menu) {
        switch (menu) {
            case 0: {
                pos.getPopupUtility().addViewPopUpMenu(item);
                break;
            }
            case 1: {
                pos.getPopupUtility().addEditPopUpMenu(item);
                break;
            }
            default: {
                pos.getPopupUtility().addEditPopUpMenu(item);
                pos.getPopupUtility().addViewPopUpMenu(item);
            }
        }
    }

    public void moveItem(Positionable p, int deltaX, int deltaY) {
        if (this.getFlag(1, p.isPositionable())) {
            int xObj = this.getItemX(p, deltaX);
            int yObj = this.getItemY(p, deltaY);
            if (xObj < 0) {
                xObj = 0;
            }
            if (yObj < 0) {
                yObj = 0;
            }
            p.setLocation(xObj, yObj);
            p.repaint();
        }
    }

    protected List<Positionable> getSelectedItems(JmriMouseEvent event) {
        Rectangle rect = new Rectangle();
        ArrayList<Positionable> selections = new ArrayList<Positionable>();
        for (Positionable p : this._contents) {
            Rectangle2D.Double rect2D;
            double x = event.getX();
            double y = event.getY();
            rect = p.getBounds(rect);
            if (p instanceof PositionableShape && p.getDegrees() != 0) {
                double rad = (double)p.getDegrees() * Math.PI / 180.0;
                AffineTransform t = AffineTransform.getRotateInstance(-rad);
                double[] pt = new double[]{x - (double)rect.x - (double)(rect.width >>> 1), y - (double)rect.y - (double)(rect.height >>> 1)};
                t.transform(pt, 0, pt, 0, 1);
                x = pt[0] + (double)rect.x + (double)(rect.width >>> 1);
                y = pt[1] + (double)rect.y + (double)(rect.height >>> 1);
            }
            if (!(rect2D = new Rectangle2D.Double((double)rect.x * this._paintScale, (double)rect.y * this._paintScale, (double)rect.width * this._paintScale, (double)rect.height * this._paintScale)).contains(x, y) || p.getDisplayLevel() <= 1 && !event.isControlDown()) continue;
            boolean added = false;
            int level = p.getDisplayLevel();
            for (int k = 0; k < selections.size(); ++k) {
                if (level < selections.get(k).getDisplayLevel()) continue;
                selections.add(k, p);
                added = true;
                break;
            }
            if (added) continue;
            selections.add(p);
        }
        return selections;
    }

    protected void makeSelectionGroup(JmriMouseEvent event) {
        if (!event.isControlDown() || this._selectionGroup == null) {
            this._selectionGroup = new ArrayList();
        }
        Rectangle test = new Rectangle();
        List<Positionable> list = this.getContents();
        if (event.isShiftDown()) {
            for (Positionable comp : list) {
                if (!this._selectRect.intersects(comp.getBounds(test)) || !event.isControlDown() && comp.getDisplayLevel() <= 1) continue;
                this._selectionGroup.add(comp);
            }
        } else {
            for (Positionable comp : list) {
                if (!this._selectRect.contains(comp.getBounds(test)) || !event.isControlDown() && comp.getDisplayLevel() <= 1) continue;
                this._selectionGroup.add(comp);
            }
        }
        log.debug("makeSelectionGroup: {} selected.", (Object)this._selectionGroup.size());
        if (this._selectionGroup.size() < 1) {
            this._selectRect = null;
            this.deselectSelectionGroup();
        }
    }

    protected void modifySelectionGroup(Positionable selection, JmriMouseEvent event) {
        if (!event.isControlDown() || this._selectionGroup == null) {
            this._selectionGroup = new ArrayList();
        }
        boolean removed = false;
        if (event.isControlDown()) {
            if (selection.getDisplayLevel() > 1) {
                if (this._selectionGroup.contains(selection)) {
                    removed = this._selectionGroup.remove(selection);
                } else {
                    this._selectionGroup.add(selection);
                }
            } else if (event.isShiftDown()) {
                if (this._selectionGroup.contains(selection)) {
                    removed = this._selectionGroup.remove(selection);
                } else {
                    this._selectionGroup.add(selection);
                }
            }
        }
        log.debug("modifySelectionGroup: size= {}, selection {}", (Object)this._selectionGroup.size(), (Object)(removed ? "removed" : "added"));
    }

    public void setAttributes(PositionablePopupUtil newUtil, Positionable p) {
        NamedBean bean;
        p.setPopupUtility(newUtil.clone(p, p.getTextComponent()));
        int mar = newUtil.getMargin();
        int bor = newUtil.getBorderSize();
        Border outlineBorder = bor == 0 ? BorderFactory.createEmptyBorder(0, 0, 0, 0) : new LineBorder(newUtil.getBorderColor(), bor);
        Border borderMargin = newUtil.hasBackground() ? new LineBorder(p.getBackground(), mar) : BorderFactory.createEmptyBorder(mar, mar, mar, mar);
        p.setBorder(new CompoundBorder(outlineBorder, borderMargin));
        if (p instanceof PositionableLabel) {
            PositionableLabel pos = (PositionableLabel)p;
            if (pos.isText()) {
                int deg = pos.getDegrees();
                pos.rotate(0);
                if (deg == 0) {
                    p.setOpaque(newUtil.hasBackground());
                } else {
                    pos.rotate(deg);
                }
            }
        } else if (p instanceof PositionableJPanel) {
            p.setOpaque(newUtil.hasBackground());
            p.getTextComponent().setOpaque(newUtil.hasBackground());
        }
        p.updateSize();
        p.repaint();
        if (p instanceof PositionableIcon && (bean = p.getNamedBean()) != null) {
            ((PositionableIcon)p).displayState(bean.getState());
        }
    }

    protected void setSelectionsAttributes(PositionablePopupUtil util, Positionable pos) {
        if (this._selectionGroup != null && this._selectionGroup.contains(pos)) {
            for (Positionable p : this._selectionGroup) {
                if (!(p instanceof PositionableLabel)) continue;
                this.setAttributes(util, p);
            }
        }
    }

    protected void setSelectionsHidden(boolean enabled, Positionable p) {
        if (this._selectionGroup != null && this._selectionGroup.contains(p)) {
            for (Positionable comp : this._selectionGroup) {
                comp.setHidden(enabled);
            }
        }
    }

    protected boolean setSelectionsPositionable(boolean enabled, Positionable p) {
        if (this._selectionGroup != null && this._selectionGroup.contains(p)) {
            for (Positionable comp : this._selectionGroup) {
                comp.setPositionable(enabled);
            }
            return true;
        }
        return false;
    }

    protected void removeSelections(Positionable p) {
        if (this._selectionGroup != null && this._selectionGroup.contains(p)) {
            for (Positionable comp : this._selectionGroup) {
                comp.remove();
            }
            this.deselectSelectionGroup();
        }
    }

    protected void setSelectionsScale(double s, Positionable p) {
        if (this._selectionGroup != null && this._selectionGroup.contains(p)) {
            for (Positionable comp : this._selectionGroup) {
                comp.setScale(s);
            }
        } else {
            p.setScale(s);
        }
    }

    protected void setSelectionsRotation(int k, Positionable p) {
        if (this._selectionGroup != null && this._selectionGroup.contains(p)) {
            for (Positionable comp : this._selectionGroup) {
                comp.rotate(k);
            }
        } else {
            p.rotate(k);
        }
    }

    protected void setSelectionsDisplayLevel(int k, Positionable p) {
        if (this._selectionGroup != null && this._selectionGroup.contains(p)) {
            for (Positionable comp : this._selectionGroup) {
                comp.setDisplayLevel(k);
            }
        } else {
            p.setDisplayLevel(k);
        }
    }

    protected void setSelectionsDockingLocation(Positionable p) {
        if (this._selectionGroup != null && this._selectionGroup.contains(p)) {
            for (Positionable pos : this._selectionGroup) {
                if (!(pos instanceof LocoIcon)) continue;
                ((LocoIcon)pos).setDockingLocation(pos.getX(), pos.getY());
            }
        } else if (p instanceof LocoIcon) {
            ((LocoIcon)p).setDockingLocation(p.getX(), p.getY());
        }
    }

    protected void dockSelections(Positionable p) {
        if (this._selectionGroup != null && this._selectionGroup.contains(p)) {
            for (Positionable pos : this._selectionGroup) {
                if (!(pos instanceof LocoIcon)) continue;
                ((LocoIcon)pos).dock();
            }
        } else if (p instanceof LocoIcon) {
            ((LocoIcon)p).dock();
        }
    }

    protected boolean showAlignPopup(Positionable p) {
        return this._selectionGroup != null && this._selectionGroup.contains(p);
    }

    public Rectangle getSelectRect() {
        return this._selectRect;
    }

    public void drawSelectRect(int x, int y) {
        int aX = this.getAnchorX();
        int aY = this.getAnchorY();
        int w = x - aX;
        int h = y - aY;
        if (x < aX) {
            aX = x;
            w = -w;
        }
        if (y < aY) {
            aY = y;
            h = -h;
        }
        this._selectRect = new Rectangle((int)Math.round((double)aX / this._paintScale), (int)Math.round((double)aY / this._paintScale), (int)Math.round((double)w / this._paintScale), (int)Math.round((double)h / this._paintScale));
    }

    public final int getAnchorX() {
        return this._anchorX;
    }

    public final int getAnchorY() {
        return this._anchorY;
    }

    public final int getLastX() {
        return this._lastX;
    }

    public final int getLastY() {
        return this._lastY;
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (this._selectionGroup == null) {
            return;
        }
        int x = 0;
        int y = 0;
        switch (e.getKeyCode()) {
            case 38: {
                y = -1;
                break;
            }
            case 40: {
                y = 1;
                break;
            }
            case 37: {
                x = -1;
                break;
            }
            case 39: {
                x = 1;
                break;
            }
            default: {
                log.warn("Unexpected e.getKeyCode() of {}", (Object)e.getKeyCode());
            }
        }
        if (!e.isShiftDown()) {
            y *= 5;
            x *= 5;
        }
        for (Positionable comp : this._selectionGroup) {
            this.moveItem(comp, x, y);
        }
        this._targetPanel.repaint();
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
        NamedBean nb = (NamedBean)evt.getOldValue();
        if ("CanDelete".equals(evt.getPropertyName())) {
            StringBuilder message = new StringBuilder();
            message.append(Bundle.getMessage("VetoInUseEditorHeader", this.getName()));
            message.append("<br>");
            boolean found = false;
            int count = 0;
            for (Positionable p : this._contents) {
                if (!nb.equals(p.getNamedBean())) continue;
                found = true;
                ++count;
            }
            if (found) {
                message.append(Bundle.getMessage("VetoFoundInPanel", count));
                message.append("<br>");
                message.append(Bundle.getMessage("VetoReferencesWillBeRemoved"));
                message.append("<br>");
                throw new PropertyVetoException(message.toString(), evt);
            }
        } else if ("DoDelete".equals(evt.getPropertyName())) {
            ArrayList<Positionable> toDelete = new ArrayList<Positionable>();
            for (Positionable p : this._contents) {
                if (!nb.equals(p.getNamedBean())) continue;
                toDelete.add(p);
            }
            for (Positionable p : toDelete) {
                this.removeFromContents(p);
                this._targetPanel.repaint();
            }
        }
    }

    @Override
    public abstract void mousePressed(JmriMouseEvent var1);

    @Override
    public abstract void mouseReleased(JmriMouseEvent var1);

    @Override
    public abstract void mouseClicked(JmriMouseEvent var1);

    @Override
    public abstract void mouseDragged(JmriMouseEvent var1);

    @Override
    public abstract void mouseMoved(JmriMouseEvent var1);

    @Override
    public abstract void mouseEntered(JmriMouseEvent var1);

    @Override
    public abstract void mouseExited(JmriMouseEvent var1);

    protected abstract void init(String var1);

    protected abstract void targetWindowClosingEvent(WindowEvent var1);

    protected abstract void paintTargetPanel(Graphics var1);

    protected abstract void setNextLocation(Positionable var1);

    protected abstract void initView();

    protected abstract void copyItem(Positionable var1);

    public List<NamedBeanUsageReport> getUsageReport(NamedBean bean) {
        ArrayList<NamedBeanUsageReport> report = new ArrayList<NamedBeanUsageReport>();
        if (bean != null) {
            this.getContents().forEach(pos -> {
                String data = this.getUsageData((Positionable)pos);
                if (pos instanceof MultiSensorIcon) {
                    MultiSensorIcon multi = (MultiSensorIcon)pos;
                    multi.getSensors().forEach(sensor -> {
                        if (bean.equals(sensor)) {
                            report.add(new NamedBeanUsageReport("PositionalIcon", data));
                        }
                    });
                } else if (pos instanceof SlipTurnoutIcon) {
                    SlipTurnoutIcon slip3Scissor = (SlipTurnoutIcon)pos;
                    if (bean.equals(slip3Scissor.getTurnout(2))) {
                        report.add(new NamedBeanUsageReport("PositionalIcon", data));
                    }
                    if (bean.equals(slip3Scissor.getTurnout(1))) {
                        report.add(new NamedBeanUsageReport("PositionalIcon", data));
                    }
                    if (slip3Scissor.getNamedTurnout(6) != null && bean.equals(slip3Scissor.getTurnout(6))) {
                        report.add(new NamedBeanUsageReport("PositionalIcon", data));
                    }
                    if (slip3Scissor.getNamedTurnout(4) != null && bean.equals(slip3Scissor.getTurnout(4))) {
                        report.add(new NamedBeanUsageReport("PositionalIcon", data));
                    }
                } else if (pos instanceof LightIcon) {
                    LightIcon icon = (LightIcon)pos;
                    if (bean.equals(icon.getLight())) {
                        report.add(new NamedBeanUsageReport("PositionalIcon", data));
                    }
                } else if (pos instanceof ReporterIcon) {
                    ReporterIcon icon = (ReporterIcon)pos;
                    if (bean.equals(icon.getReporter())) {
                        report.add(new NamedBeanUsageReport("PositionalIcon", data));
                    }
                } else if (pos instanceof AudioIcon) {
                    AudioIcon icon = (AudioIcon)pos;
                    if (bean.equals(icon.getAudio())) {
                        report.add(new NamedBeanUsageReport("PositionalIcon", data));
                    }
                } else if (bean.equals(pos.getNamedBean())) {
                    report.add(new NamedBeanUsageReport("PositionalIcon", data));
                }
            });
        }
        return report;
    }

    String getUsageData(Positionable pos) {
        Point point = pos.getLocation();
        return String.format("%s :: x=%d, y=%d", pos.getClass().getSimpleName(), Math.round(point.getX()), Math.round(point.getY()));
    }

    public static class JFrameItem
    extends JmriJFrame {
        private final IconAdder _editor;

        JFrameItem(String name, IconAdder editor) {
            super(name);
            this._editor = editor;
            this.setName(name);
        }

        public IconAdder getEditor() {
            return this._editor;
        }

        @Override
        public String toString() {
            return this.getName();
        }
    }

    public class TargetPane
    extends JLayeredPane {
        private int h = 100;
        private int w = 150;
        private Color _highlightColor = HIGHLIGHT_COLOR;
        private Color _selectGroupColor = HIGHLIGHT_COLOR;
        private Color _selectRectColor = Color.red;
        private transient Stroke _selectRectStroke;

        public TargetPane() {
            this._selectRectStroke = Editor.this.DASHED_LINE;
            this.setLayout(null);
        }

        @Override
        public void setSize(int width, int height) {
            this.h = height;
            this.w = width;
            super.setSize(width, height);
        }

        @Override
        public Dimension getSize() {
            return new Dimension(this.w, this.h);
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(this.w, this.h);
        }

        @Override
        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        @Override
        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }

        @Override
        public Component add(@Nonnull Component c, int i) {
            int hnew = Math.max(this.h, c.getLocation().y + c.getSize().height);
            int wnew = Math.max(this.w, c.getLocation().x + c.getSize().width);
            if (hnew > this.h || wnew > this.w) {
                this.setSize(wnew, hnew);
            }
            return super.add(c, i);
        }

        @Override
        public void add(@Nonnull Component c, Object o) {
            super.add(c, o);
            int hnew = Math.max(this.h, c.getLocation().y + c.getSize().height);
            int wnew = Math.max(this.w, c.getLocation().x + c.getSize().width);
            if (hnew > this.h || wnew > this.w) {
                this.setSize(wnew, hnew);
            }
        }

        public void setHighlightColor(Color color) {
            this._highlightColor = color;
        }

        public Color getHighlightColor() {
            return this._highlightColor;
        }

        public void setSelectGroupColor(Color color) {
            this._selectGroupColor = color;
        }

        public void setSelectRectColor(Color color) {
            this._selectRectColor = color;
        }

        public void setSelectRectStroke(Stroke stroke) {
            this._selectRectStroke = stroke;
        }

        public void setDefaultColors() {
            this._highlightColor = HIGHLIGHT_COLOR;
            this._selectGroupColor = HIGHLIGHT_COLOR;
            this._selectRectColor = Color.red;
            this._selectRectStroke = Editor.this.DASHED_LINE;
        }

        @Override
        public void paint(Graphics g) {
            Graphics2D g2d = null;
            if (g instanceof Graphics2D) {
                g2d = (Graphics2D)g;
                g2d.scale(Editor.this._paintScale, Editor.this._paintScale);
            }
            super.paint(g);
            Stroke stroke = new BasicStroke();
            if (g2d != null) {
                stroke = g2d.getStroke();
            }
            Color color = g.getColor();
            if (Editor.this._selectRect != null) {
                if (g2d != null) {
                    g2d.setStroke(this._selectRectStroke);
                }
                g.setColor(this._selectRectColor);
                g.drawRect(Editor.this._selectRect.x, Editor.this._selectRect.y, Editor.this._selectRect.width, Editor.this._selectRect.height);
            }
            if (Editor.this._selectionGroup != null) {
                g.setColor(this._selectGroupColor);
                if (g2d != null) {
                    g2d.setStroke(new BasicStroke(2.0f));
                }
                for (Positionable p : Editor.this._selectionGroup) {
                    if (p == null) continue;
                    if (!(p instanceof PositionableShape)) {
                        g.drawRect(p.getX(), p.getY(), p.maxWidth(), p.maxHeight());
                        continue;
                    }
                    PositionableShape s = (PositionableShape)p;
                    s.drawHandles();
                }
            }
            if (Editor.this._highlightcomponent != null) {
                g.setColor(this._highlightColor);
                if (g2d != null) {
                    g2d.setStroke(new BasicStroke(2.0f));
                }
                g.drawRect(Editor.this._highlightcomponent.x, Editor.this._highlightcomponent.y, Editor.this._highlightcomponent.width, Editor.this._highlightcomponent.height);
            }
            Editor.this.paintTargetPanel(g);
            g.setColor(color);
            if (g2d != null) {
                g2d.setStroke(stroke);
            }
            if (Editor.this._tooltip != null) {
                Editor.this._tooltip.paint(g2d, Editor.this._paintScale);
            }
        }

        public void setBackgroundColor(Color col) {
            this.setBackground(col);
            this.setOpaque(true);
            JmriColorChooser.addRecentColor(col);
        }

        public void clearBackgroundColor() {
            this.setOpaque(false);
        }

        public Color getBackgroundColor() {
            if (this.isOpaque()) {
                return this.getBackground();
            }
            return null;
        }
    }

    static class ToolTipTimer
    extends Timer {
        private final ToolTip tooltip;

        ToolTipTimer(int delay, ActionListener listener, ToolTip tip) {
            super(delay, listener);
            this.tooltip = tip;
        }

        ToolTip getToolTip() {
            return this.tooltip;
        }
    }

    public class UrlErrorDialog
    extends JDialog {
        private final JTextField _urlField;
        private final CatalogPanel _catalog;
        private final String _badUrl;

        UrlErrorDialog(String msg, String url) {
            super(Editor.this._targetFrame, Bundle.getMessage("BadIcon"), true);
            this._badUrl = url;
            JPanel content = new JPanel();
            JPanel panel = new JPanel();
            panel.setLayout(new BoxLayout(panel, 1));
            panel.add(Box.createVerticalStrut(10));
            panel.add(new JLabel(MessageFormat.format(Bundle.getMessage("IconUrlError"), msg)));
            panel.add(new JLabel(Bundle.getMessage("UrlErrorPrompt1")));
            panel.add(new JLabel(Bundle.getMessage("UrlErrorPrompt1A")));
            panel.add(new JLabel(Bundle.getMessage("UrlErrorPrompt1B")));
            panel.add(Box.createVerticalStrut(10));
            panel.add(new JLabel(Bundle.getMessage("UrlErrorPrompt2", Bundle.getMessage("ButtonContinue"))));
            panel.add(new JLabel(Bundle.getMessage("UrlErrorPrompt3", Bundle.getMessage("ButtonDelete"))));
            panel.add(new JLabel(Bundle.getMessage("UrlErrorPrompt3A")));
            panel.add(Box.createVerticalStrut(10));
            panel.add(new JLabel(Bundle.getMessage("UrlErrorPrompt4", Bundle.getMessage("ButtonIgnore"))));
            panel.add(Box.createVerticalStrut(10));
            this._urlField = new JTextField(url);
            this._urlField.setDragEnabled(true);
            this._urlField.setTransferHandler(new DnDStringImportHandler());
            panel.add(this._urlField);
            panel.add(this.makeDoneButtonPanel());
            this._urlField.setToolTipText(Bundle.getMessage("TooltipFixUrl"));
            panel.setToolTipText(Bundle.getMessage("TooltipFixUrl"));
            this._catalog = CatalogPanel.makeDefaultCatalog();
            this._catalog.setToolTipText(Bundle.getMessage("ToolTipDragIconToText"));
            panel.add(this._catalog);
            content.add(panel);
            this.setContentPane(content);
            this.setLocation(200, 100);
            this.pack();
        }

        private JPanel makeDoneButtonPanel() {
            JPanel result = new JPanel();
            result.setLayout(new FlowLayout());
            JButton doneButton = new JButton(Bundle.getMessage("ButtonContinue"));
            doneButton.addActionListener(a -> {
                Editor.this._newIcon = NamedIcon.getIconByName(this._urlField.getText());
                if (Editor.this._newIcon != null) {
                    Editor.this._urlMap.put(this._badUrl, this._urlField.getText());
                }
                this.dispose();
            });
            doneButton.setToolTipText(Bundle.getMessage("TooltipContinue"));
            result.add(doneButton);
            JButton deleteButton = new JButton(Bundle.getMessage("ButtonDelete"));
            deleteButton.addActionListener(a -> {
                Editor.this._delete = true;
                this.dispose();
            });
            result.add(deleteButton);
            deleteButton.setToolTipText(Bundle.getMessage("TooltipDelete"));
            JButton cancelButton = new JButton(Bundle.getMessage("ButtonIgnore"));
            cancelButton.addActionListener(a -> {
                Editor.this._ignore = true;
                this.dispose();
            });
            result.add(cancelButton);
            cancelButton.setToolTipText(Bundle.getMessage("TooltipIgnore"));
            return result;
        }
    }
}

